// Codeware 1.19.0

public abstract native class Codeware {
    public static native func Require(version: String) -> Bool
    public static native func Version() -> String
}

@addField(AdjustTransform)
public native let position: Vector4;
@addField(AdjustTransform)
public native let rotation: Quaternion;

@addField(AdvertGlitchEvent)
public native let glitchValue: Float;

@addField(AIArgumentMapping)
public native let type: AIArgumentType;
@addField(AIArgumentMapping)
public native let parameterizationType: AIParameterizationType;
@addField(AIArgumentMapping)
public native let defaultValue: Variant;
@addField(AIArgumentMapping)
public native let prefixValue: ref<AIArgumentMapping>;
@addField(AIArgumentMapping)
public native let customTypeName: CName;

@addField(AIBaseUseWorkspotCommand)
public native persistent let workExcludedGestures: array<WorkEntryId>;
@addField(AIBaseUseWorkspotCommand)
public native persistent let infiniteSequenceEntryId: WorkEntryId;
@addField(AIBaseUseWorkspotCommand)
public native persistent let idleOnlyMode: Bool;

@addField(AICommand)
public native persistent let questBlockId: Uint64;
@addField(AICommand)
public native persistent let category: CName;

@addField(AIGateSignal)
public native let tags: [CName; 4];

@addField(AIHumanComponent)
public native let movementParamsRecord: TweakDBID;

@addField(AINavigationSystemQuery)
public native let minDesiredDistance: Float;
@addField(AINavigationSystemQuery)
public native let maxDesiredDistance: Float;
@addField(AINavigationSystemQuery)
public native let useFollowSlots: Bool;
@addField(AINavigationSystemQuery)
public native let usePredictionTime: Bool;

@addField(AINavigationSystemResult)
public native let adjustedTargetPosition: WorldPosition;

@addField(AIPatrolPathParameters)
public native persistent let continuationPolicy: AIPatrolContinuationPolicy;
@addField(AIPatrolPathParameters)
public native persistent let sortPatrolPoints: Bool;

@addField(AIUseCoverCommand)
public native let exposureMethods: array<AICoverExposureMethod>;

@addField(AIUseWorkspotCommand)
public native persistent let entryTag: CName;

@addField(animAnimFeatureEntry)
public native let name: CName;
@addField(animAnimFeatureEntry)
public native let className: CName;
@addField(animAnimFeatureEntry)
public native let forceAllocate: Bool;

@addField(AnimatedComponent)
public native let controlBinding: ref<entAnimationControlBinding>;
@addField(AnimatedComponent)
public native let rig: ResourceRef; // rRef<animRig>
@addField(AnimatedComponent)
public native let graph: ResourceRef; // rRef<animAnimGraph>
@addField(AnimatedComponent)
public native let animations: animAnimSetup;
@addField(AnimatedComponent)
public native let animTags: redTagList;
@addField(AnimatedComponent)
public native let audioAltName: CName;
@addField(AnimatedComponent)
public native let useLongRangeVisibility: Bool;
@addField(AnimatedComponent)
public native let facialSetup: ResourceAsyncRef; // raRef<animFacialSetup>
@addField(AnimatedComponent)
public native let calculateAccelerationWs: Bool;
@addField(AnimatedComponent)
public native let animParameters: array<entAnimTrackParameter>;
@addField(AnimatedComponent)
public native let serverForcedLod: Int32;
@addField(AnimatedComponent)
public native let clientForcedLod: Int32;
@addField(AnimatedComponent)
public native let serverForcedVisibility: Bool;
@addField(AnimatedComponent)
public native let clientForcedVisibility: Bool;

@addField(AnimationControllerComponent)
public native let actionAnimDatabaseRef: ResourceRef; // rRef<animActionAnimDatabase>
@addField(AnimationControllerComponent)
public native let animDatabaseCollection: animAnimDatabaseCollection;
@addField(AnimationControllerComponent)
public native let controlBinding: ref<entAnimationControlBinding>;

@addField(AnimFeature_Aim)
public native let aimPoint: Vector4;

@addField(AnimFeature_AimPlayer)
public native let zoomLevel: Float;
@addField(AnimFeature_AimPlayer)
public native let aimInTime: Float;
@addField(AnimFeature_AimPlayer)
public native let aimOutTime: Float;

@addField(AnimFeature_BasicAim)
public native let aimState: Int32;
@addField(AnimFeature_BasicAim)
public native let zoomState: Int32;

@addField(AnimFeature_Cover)
public native let coverPosition: Vector4;
@addField(AnimFeature_Cover)
public native let coverDirection: Vector4;
@addField(AnimFeature_Cover)
public native let coverState: Int32;
@addField(AnimFeature_Cover)
public native let coverAngleToAction: Float;
@addField(AnimFeature_Cover)
public native let stance: Int32;
@addField(AnimFeature_Cover)
public native let behavior: Int32;
@addField(AnimFeature_Cover)
public native let coverAction: Int32;
@addField(AnimFeature_Cover)
public native let behaviorTime_PreAction: Float;
@addField(AnimFeature_Cover)
public native let behaviorTime_Action: Float;
@addField(AnimFeature_Cover)
public native let behaviorTime_PostAction: Float;

@addField(AnimFeature_FPPCamera)
public native let fov: Float;
@addField(AnimFeature_FPPCamera)
public native let deltaYaw: Float;
@addField(AnimFeature_FPPCamera)
public native let deltaYawExternal: Float;
@addField(AnimFeature_FPPCamera)
public native let deltaYawInput: Float;
@addField(AnimFeature_FPPCamera)
public native let yawSpeed: Float;
@addField(AnimFeature_FPPCamera)
public native let yawMaxLeft: Float;
@addField(AnimFeature_FPPCamera)
public native let yawMaxRight: Float;
@addField(AnimFeature_FPPCamera)
public native let deltaPitch: Float;
@addField(AnimFeature_FPPCamera)
public native let deltaPitchExternal: Float;
@addField(AnimFeature_FPPCamera)
public native let deltaPitchInput: Float;
@addField(AnimFeature_FPPCamera)
public native let pitchSpeed: Float;
@addField(AnimFeature_FPPCamera)
public native let pitchMin: Float;
@addField(AnimFeature_FPPCamera)
public native let pitchMax: Float;
@addField(AnimFeature_FPPCamera)
public native let resetYawSpeed: Float;
@addField(AnimFeature_FPPCamera)
public native let resetPitchSpeed: Float;
@addField(AnimFeature_FPPCamera)
public native let resetExternalsSpeed: Float;
@addField(AnimFeature_FPPCamera)
public native let isSceneMode: Bool;
@addField(AnimFeature_FPPCamera)
public native let t4Blend: Float;
@addField(AnimFeature_FPPCamera)
public native let t4Pitch: Float;
@addField(AnimFeature_FPPCamera)
public native let t4Yaw: Float;
@addField(AnimFeature_FPPCamera)
public native let t4Roll: Float;
@addField(AnimFeature_FPPCamera)
public native let t4CopyPitchAndYaw: Bool;
@addField(AnimFeature_FPPCamera)
public native let sceneCameraUseTrajectorySpace: Bool;
@addField(AnimFeature_FPPCamera)
public native let sceneTransitioningToGameplay: Bool;
@addField(AnimFeature_FPPCamera)
public native let yawMultiplier: Float;
@addField(AnimFeature_FPPCamera)
public native let pitchMultiplier: Float;
@addField(AnimFeature_FPPCamera)
public native let overridePitchInput: Float;
@addField(AnimFeature_FPPCamera)
public native let overridePitchRef: Float;
@addField(AnimFeature_FPPCamera)
public native let overrideYawInput: Float;
@addField(AnimFeature_FPPCamera)
public native let overrideYawRef: Float;
@addField(AnimFeature_FPPCamera)
public native let override: Float;
@addField(AnimFeature_FPPCamera)
public native let parallaxSide: Float;
@addField(AnimFeature_FPPCamera)
public native let parallaxForward: Float;
@addField(AnimFeature_FPPCamera)
public native let parallaxSpace: Float;
@addField(AnimFeature_FPPCamera)
public native let normalizeYaw: Bool;
@addField(AnimFeature_FPPCamera)
public native let vehicleOffsetWeight: Float;
@addField(AnimFeature_FPPCamera)
public native let gameplayCameraPoseWeight: Float;
@addField(AnimFeature_FPPCamera)
public native let additiveCameraMovementsWeight: Float;
@addField(AnimFeature_FPPCamera)
public native let vehicleProceduralCameraWeight: Float;
@addField(AnimFeature_FPPCamera)
public native let t4CameraIdleOrientation: Quaternion;
@addField(AnimFeature_FPPCamera)
public native let t4UseCameraIdleOrientation: Bool;
@addField(AnimFeature_FPPCamera)
public native let t4CameraControlIdleOrientation: Quaternion;

@addField(AnimFeature_LoopableAction)
public native let loopDuration: Float;
@addField(AnimFeature_LoopableAction)
public native let numLoops: Uint8;
@addField(AnimFeature_LoopableAction)
public native let isActive: Bool;

@addField(AnimFeature_Movement)
public native let movementDirection: Vector4;
@addField(AnimFeature_Movement)
public native let speed: Float;
@addField(AnimFeature_Movement)
public native let desiredSpeed: Float;
@addField(AnimFeature_Movement)
public native let stabilizedSpeed: Float;
@addField(AnimFeature_Movement)
public native let acceleration: Float;
@addField(AnimFeature_Movement)
public native let timeToChangeLocomotion: Float;
@addField(AnimFeature_Movement)
public native let strafeYaw: Float;
@addField(AnimFeature_Movement)
public native let yawSpeed: Float;
@addField(AnimFeature_Movement)
public native let locomotionState: Int32;

@addField(AnimFeature_MoveTo)
public native let initialFwdVector: Vector4;
@addField(AnimFeature_MoveTo)
public native let targetPositionWs: Vector4;
@addField(AnimFeature_MoveTo)
public native let targetDirectionWs: Vector4;
@addField(AnimFeature_MoveTo)
public native let timeToMove: Float;

@addField(AnimFeature_PlayerMovement)
public native let facingDirection: Vector4;
@addField(AnimFeature_PlayerMovement)
public native let verticalSpeed: Float;
@addField(AnimFeature_PlayerMovement)
public native let movementDirectionHorizontalAngle: Float;
@addField(AnimFeature_PlayerMovement)
public native let inAir: Bool;
@addField(AnimFeature_PlayerMovement)
public native let standingTerrainAngle: Float;

@addField(AnimFeature_Stance)
public native let stanceState: Int32;

@addField(AnimFeature_VehiclePassenger)
public native let overallForceMS: Vector4;
@addField(AnimFeature_VehiclePassenger)
public native let turnSpeed: Float;
@addField(AnimFeature_VehiclePassenger)
public native let bankSpeed: Float;
@addField(AnimFeature_VehiclePassenger)
public native let longitudinalForce: Float;
@addField(AnimFeature_VehiclePassenger)
public native let transversalForce: Float;
@addField(AnimFeature_VehiclePassenger)
public native let collisionForceLR: Float;
@addField(AnimFeature_VehiclePassenger)
public native let collisionForceFB: Float;
@addField(AnimFeature_VehiclePassenger)
public native let speed: Float;
@addField(AnimFeature_VehiclePassenger)
public native let inputLR: Float;
@addField(AnimFeature_VehiclePassenger)
public native let inputFB: Float;
@addField(AnimFeature_VehiclePassenger)
public native let inputGas: Float;
@addField(AnimFeature_VehiclePassenger)
public native let inputBreak: Float;
@addField(AnimFeature_VehiclePassenger)
public native let inputHandBreak: Float;
@addField(AnimFeature_VehiclePassenger)
public native let vehicleRoll: Float;
@addField(AnimFeature_VehiclePassenger)
public native let vehiclePitch: Float;
@addField(AnimFeature_VehiclePassenger)
public native let inAir: Bool;
@addField(AnimFeature_VehiclePassenger)
public native let clutchInUse: Bool;
@addField(AnimFeature_VehiclePassenger)
public native let headCollision: Bool;

@addField(AnimFeature_WeaponData)
public native let cycleTime: Float;
@addField(AnimFeature_WeaponData)
public native let chargePercentage: Float;
@addField(AnimFeature_WeaponData)
public native let timeInMaxCharge: Float;
@addField(AnimFeature_WeaponData)
public native let ammoRemaining: Int32;
@addField(AnimFeature_WeaponData)
public native let triggerMode: Int32;
@addField(AnimFeature_WeaponData)
public native let isMagazineFull: Bool;
@addField(AnimFeature_WeaponData)
public native let isTriggerDown: Bool;

@addField(AnimTargetAddEvent)
public native let targetPositionProvider: ref<IPositionProvider>;

@addField(AreaShapeComponent)
public native let outline: ref<AreaShapeOutline>;
@addField(AreaShapeComponent)
public native let color: Color;
@addField(AreaShapeComponent)
public native let isEnabled: Bool;

@addField(AttitudeAgent)
public native let baseAttitudeGroup: CName;

@addField(AudioEvent)
public native let emitterName: CName;

@addField(BaseDirectionalIndicatorPartLogicController)
public native let defaultForwardFovRange: Float;
@addField(BaseDirectionalIndicatorPartLogicController)
public native let adjustedForwardFovRange: Float;

@addField(BaseInteractionMappinController)
public native let canvasWidgetName: CName;
@addField(BaseInteractionMappinController)
public native let arrowWidgetName: CName;

@addField(BaseMappinBaseController)
public native let scaleWidget: inkWidgetRef;

@addField(BaseMinimapMappinController)
public native let iconOrientation: gameuiEIconOrientation;
@addField(BaseMinimapMappinController)
public native let fixedOrientationWidget: inkWidgetRef;

@addField(BaseStrategyRequest)
public native let forceArriveFromBehind: Bool;

@addField(BaseWorldMapMappinController)
public native let groupContainerWidget: inkWidgetRef;
@addField(BaseWorldMapMappinController)
public native let groupCountTextWidget: inkTextRef;

@addField(BinkComponent)
public native let meshTargetBinding: ref<gameBinkMeshTargetBinding>;
@addField(BinkComponent)
public native let videoPlayerName: CName;
@addField(BinkComponent)
public native let binkResource: ResourceAsyncRef; // raRef<Bink>
@addField(BinkComponent)
public native let audioEvent: CName;
@addField(BinkComponent)
public native let loopVideo: Bool;
@addField(BinkComponent)
public native let forceVideoFrameRate: Bool;
@addField(BinkComponent)
public native let isEnabled: Bool;

@addField(BinkResource)
public native let video: ResourceAsyncRef; // raRef<Bink>

@addField(BlackboardChangedEvent)
public native let definition: ref<BlackboardDefinition>;
@addField(BlackboardChangedEvent)
public native let id: BlackboardID;

@addField(BlackboardID)
public native let None: gamebbID;

@addField(BreachComponent)
public native let radius: Float;
@addField(BreachComponent)
public native let healthPercentageOverride: Float;

@addField(BreachControllerComponent)
public native let canHaveBreaches: Bool;
@addField(BreachControllerComponent)
public native let allowNormalBreachesAfterWeakspotsAreDestroyed: Bool;
@addField(BreachControllerComponent)
public native let debugAllowBreachesAfterDestruction: Bool;
@addField(BreachControllerComponent)
public native let breachesScale: Float;

@addField(BumpComponent)
public native let isPlayerControlled: Bool;
@addField(BumpComponent)
public native let movementSpreadDistance: Float;
@addField(BumpComponent)
public native let movementSpreadRadius: Float;
@addField(BumpComponent)
public native let distanceToReactBack: Float;
@addField(BumpComponent)
public native let distanceToReactFront: Float;
@addField(BumpComponent)
public native let reactionSettings: array<BumpReactionSetting>;
@addField(BumpComponent)
public native let autoPlayBumpAnimation: Bool;
@addField(BumpComponent)
public native let isEnabled: Bool;

@addField(CameraComponent)
public native let animParamFovOverrideWeight: CName;
@addField(CameraComponent)
public native let animParamFovOverrideValue: CName;
@addField(CameraComponent)
public native let animParamZoomOverrideWeight: CName;
@addField(CameraComponent)
public native let animParamZoomOverrideValue: CName;
@addField(CameraComponent)
public native let animParamZoomWeaponOverrideWeight: CName;
@addField(CameraComponent)
public native let animParamZoomWeaponOverrideValue: CName;
@addField(CameraComponent)
public native let animParamdofIntensity: CName;
@addField(CameraComponent)
public native let animParamdofNearBlur: CName;
@addField(CameraComponent)
public native let animParamdofNearFocus: CName;
@addField(CameraComponent)
public native let animParamdofFarBlur: CName;
@addField(CameraComponent)
public native let animParamdofFarFocus: CName;
@addField(CameraComponent)
public native let animParamWeaponNearPlaneCM: CName;
@addField(CameraComponent)
public native let animParamWeaponFarPlaneCM: CName;
@addField(CameraComponent)
public native let animParamWeaponEdgesSharpness: CName;
@addField(CameraComponent)
public native let animParamWeaponVignetteIntensity: CName;
@addField(CameraComponent)
public native let animParamWeaponVignetteRadius: CName;
@addField(CameraComponent)
public native let animParamWeaponVignetteCircular: CName;
@addField(CameraComponent)
public native let animParamWeaponBlurIntensity: CName;
@addField(CameraComponent)
public native let weaponPlane: SWeaponPlaneParams;

@addField(ChoiceTypeWrapper)
public native let properties: Uint32;

@addField(ColliderComponent)
public native let colliders: array<ref<physicsICollider>>;
@addField(ColliderComponent)
public native let simulationType: physicsSimulationType;
@addField(ColliderComponent)
public native let startInactive: Bool;
@addField(ColliderComponent)
public native let useCCD: Bool;
@addField(ColliderComponent)
public native let massOverride: Float;
@addField(ColliderComponent)
public native let volume: Float;
@addField(ColliderComponent)
public native let mass: Float;
@addField(ColliderComponent)
public native let inertia: Vector3;
@addField(ColliderComponent)
public native let comOffset: Transform;
@addField(ColliderComponent)
public native let filterData: ref<physicsFilterData>;
@addField(ColliderComponent)
public native let isEnabled: Bool;
@addField(ColliderComponent)
public native let dynamicTrafficSetting: TrafficGenDynamicTrafficSetting;

@addField(ControllerSettingsGameController)
public native let defaultWidgets: array<inkWidgetRef>;
@addField(ControllerSettingsGameController)
public native let southpawWidgets: array<inkWidgetRef>;
@addField(ControllerSettingsGameController)
public native let legacyWidgets: array<inkWidgetRef>;

@addField(Damage)
public native let damageType: gamedataDamageType;
@addField(Damage)
public native let value: Float;

@addField(DamageIndicatorGameController)
public native let maxVisibleParts: Uint8;

@addField(DamageIndicatorPartLogicController)
public native let maxDistanceForSharedIndicators: Float;

@addField(DeviceRef)
public native let componentName: CName;

@addField(DrawItemRequest)
public native let assignOnly: Bool;

@addField(DriverCombatHUDGameController)
public native let crosshairBrackets: inkWidgetRef;
@addField(DriverCombatHUDGameController)
public native let crosshairBracketsFlairLeft: inkWidgetRef;
@addField(DriverCombatHUDGameController)
public native let crosshairBracketsFlairRight: inkWidgetRef;
@addField(DriverCombatHUDGameController)
public native let bracketsTransitionDetailsWidgetList: array<inkWidgetRef>;
@addField(DriverCombatHUDGameController)
public native let crosshairBracketsMinSize: Vector2;
@addField(DriverCombatHUDGameController)
public native let crosshairBracketsInstantSnapValue: Float;
@addField(DriverCombatHUDGameController)
public native let crosshairBracketsInOutTransitionTime: Float;
@addField(DriverCombatHUDGameController)
public native let crosshairBracketsIntroSizeMultiplier: Float;
@addField(DriverCombatHUDGameController)
public native let crosshairBracketsTrail: inkWidgetRef;
@addField(DriverCombatHUDGameController)
public native let crosshairBracketsTrailTransitionTime: Float;
@addField(DriverCombatHUDGameController)
public native let crosshairReducedOpacity: Float;
@addField(DriverCombatHUDGameController)
public native let unifomSafeZone: Float;

@addField(EffectExecutor)
public native let usesHitCooldown: Bool;

@addField(EffectInputParameter_Bool)
public native let evaluator: ref<gameIEffectParameter_BoolEvaluator>;

@addField(EffectInputParameter_CName)
public native let evaluator: ref<gameIEffectParameter_CNameEvaluator>;

@addField(EffectInputParameter_Float)
public native let evaluator: ref<gameIEffectParameter_FloatEvaluator>;

@addField(EffectInputParameter_Int)
public native let evaluator: ref<gameIEffectParameter_IntEvaluator>;

@addField(EffectInputParameter_Quat)
public native let evaluator: ref<gameIEffectParameter_QuatEvaluator>;

@addField(EffectInputParameter_String)
public native let evaluator: ref<gameIEffectParameter_StringEvaluator>;

@addField(EffectInputParameter_Variant)
public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;

@addField(EffectInputParameter_Vector)
public native let evaluator: ref<gameIEffectParameter_VectorEvaluator>;

@addField(EffectOutputParameter_Bool)
public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;

@addField(EffectOutputParameter_CName)
public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;

@addField(EffectOutputParameter_Float)
public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;

@addField(EffectOutputParameter_Int)
public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;

@addField(EffectOutputParameter_Quat)
public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;

@addField(EffectOutputParameter_String)
public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;

@addField(EffectOutputParameter_Variant)
public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;

@addField(EffectOutputParameter_Vector)
public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;

@addField(EffectRef)
public native let set: ResourceRef; // rRef<gameEffectSet>
@addField(EffectRef)
public native let tag: CName;

@addField(entCameraComponent)
public native let fov: Float;
@addField(entCameraComponent)
public native let zoom: Float;
@addField(entCameraComponent)
public native let nearPlaneOverride: Float;
@addField(entCameraComponent)
public native let farPlaneOverride: Float;
@addField(entCameraComponent)
public native let motionBlurScale: Float;

@addField(Entity)
public native let customCameraTarget: ECustomCameraTarget;
@addField(Entity)
public native let renderSceneLayerMask: Uint8; // RenderSceneLayerMask

@addField(EntityID)
public native persistent let hash: Uint64;

@addField(EntityReference)
public native persistent let type: gameEntityReferenceType;
@addField(EntityReference)
public native persistent let names: array<CName>;
@addField(EntityReference)
public native persistent let slotName: CName;
@addField(EntityReference)
public native persistent let sceneActorContextName: CName;
@addField(EntityReference)
public native persistent let dynamicEntityUniqueName: CName;

@addField(entSpawnEffectEvent)
public native let idForRandomizedEffect: CRUID;
@addField(entSpawnEffectEvent)
public native let e3hackDeferCount: Uint32;

@addField(EnvironmentDamageReceiverComponent)
public native let shapes: array<ref<gameEnvironmentDamageReceiverShape>>;

@addField(FactChangedEvent)
public native let factName: CName;

@addField(FPPCameraComponent)
public native let pitchMin: Float;
@addField(FPPCameraComponent)
public native let pitchMax: Float;
@addField(FPPCameraComponent)
public native let yawMaxLeft: Float;
@addField(FPPCameraComponent)
public native let yawMaxRight: Float;
@addField(FPPCameraComponent)
public native let headingLocked: Bool;
@addField(FPPCameraComponent)
public native let sensitivityMultX: Float;
@addField(FPPCameraComponent)
public native let sensitivityMultY: Float;
@addField(FPPCameraComponent)
public native let timeDilationCurveName: CName;

@addField(frameWidgetComponent)
public native let dimensions: Vector2;

@addField(FriendlyFireParams)
public native let attitude: wref<AttitudeAgent>;
@addField(FriendlyFireParams)
public native let slots: wref<SlotComponent>;
@addField(FriendlyFireParams)
public native let attachmentName: CName;
@addField(FriendlyFireParams)
public native let slotId: Int32;
@addField(FriendlyFireParams)
public native let spread: Float;
@addField(FriendlyFireParams)
public native let maxRange: Float;

@addField(FxResource)
public native let effect: ResourceAsyncRef; // raRef<worldEffect>

@addField(gameaiCyberwareBreachGameController)
public native let strokeHealthDepleation: inkWidgetRef;

@addField(GameComponent)
public native let persistentState: ref<PersistentState>;

@addField(gameContainerObjectBase)
public native let giveHandicapAmmo: Bool;

@addField(gameCpoPickableItem)
public native let itemIDToEquip: TweakDBID;
@addField(gameCpoPickableItem)
public native let quickSlotID: Int32;

@addField(gameEffectExecutor_BulletImpact)
public native let isBackfaceImpact: Bool;
@addField(gameEffectExecutor_BulletImpact)
public native let noAudio: Bool;
@addField(gameEffectExecutor_BulletImpact)
public native let isMeleeAttack: Bool;

@addField(gameEffectExecutor_KatanaBulletBending)
public native let effects: array<gameEffectExecutor_KatanaBulletBendingEffectEntry>;

@addField(gameEffectExecutor_Ricochet)
public native let outputRicochetVector: EffectOutputParameter_Vector;

@addField(gameEffectObjectFilter_OnlyNearest)
public native let count: Uint32;

@addField(gameEntityStubComponentPS)
public native persistent let entityLocalPosition: Vector3;
@addField(gameEntityStubComponentPS)
public native persistent let entityLocalRotation: Quaternion;
@addField(gameEntityStubComponentPS)
public native persistent let spawnerId: gameCommunityID;
@addField(gameEntityStubComponentPS)
public native persistent let ownerCommunityEntryName: CName;
@addField(gameEntityStubComponentPS)
public native persistent let selectedAppearanceName: CName;
@addField(gameEntityStubComponentPS)
public native persistent let selectedColorVariantName: CName;

@addField(gameHitEvent)
public native let hitColliderTag: CName;

@addField(gameJournalPath)
public native let realPath: String;
@addField(gameJournalPath)
public native let fileEntryIndex: Int32;
@addField(gameJournalPath)
public native let className: CName;

@addField(gameLightComponent)
public native let emissiveOnly: Bool;
@addField(gameLightComponent)
public native let materialZone: gameEMaterialZone;
@addField(gameLightComponent)
public native let meshBrokenAppearance: CName;
@addField(gameLightComponent)
public native let onStrength: Float;
@addField(gameLightComponent)
public native let turnOnByDefault: Bool;
@addField(gameLightComponent)
public native let turnOnTime: Float;
@addField(gameLightComponent)
public native let turnOnCurve: CName;
@addField(gameLightComponent)
public native let turnOffTime: Float;
@addField(gameLightComponent)
public native let turnOffCurve: CName;
@addField(gameLightComponent)
public native let loopTime: Float;
@addField(gameLightComponent)
public native let loopCurve: CName;
@addField(gameLightComponent)
public native let synchronizedLoop: Bool;
@addField(gameLightComponent)
public native let isDestructible: Bool;
@addField(gameLightComponent)
public native let colliderName: CName;
@addField(gameLightComponent)
public native let colliderTag: CName;
@addField(gameLightComponent)
public native let destructionEffect: ResourceAsyncRef; // raRef<worldEffect>
@addField(gameLightComponent)
public native let genericCurveSetOverride: ResourceRef; // rRef<CurveSet>

@addField(gameLootContainerBase)
public native let useAreaLoot: Bool;
@addField(gameLootContainerBase)
public native let lootTables: array<TweakDBID>;
@addField(gameLootContainerBase)
public native let contentAssignment: TweakDBID;
@addField(gameLootContainerBase)
public native let isIllegal: Bool;
@addField(gameLootContainerBase)
public native let containerType: gamedataContainerType;

@addField(gameLootObject)
public native let lootID: TweakDBID;

@addField(GameObject)
public native let persistentState: ref<PersistentState>;
@addField(GameObject)
public native let playerSocket: gamePlayerSocket;
@addField(GameObject)
public native let tags: redTagList;
@addField(GameObject)
public native let displayName: LocalizationString;
@addField(GameObject)
public native let displayDescription: LocalizationString;
@addField(GameObject)
public native let audioResourceName: CName;
@addField(GameObject)
public native let visibilityCheckDistance: Float;

@addField(gameprojectileLaunchEvent)
public native let weapon: wref<GameObject>;

@addField(GamePuppetPS)
public native persistent let gender: CName;
@addField(GamePuppetPS)
public native persistent let wasQuickHacked: Bool;
@addField(GamePuppetPS)
public native persistent let hasQuickHackBegunUpload: Bool;
@addField(GamePuppetPS)
public native persistent let hasAlternativeName: Bool;
@addField(GamePuppetPS)
public native persistent let isCrouch: Bool;
@addField(GamePuppetPS)
public native persistent let allowVehicleCollisionRagdoll: Bool;

@addField(gameScanningComponentPS)
public native persistent let scanningState: gameScanningState;
@addField(gameScanningComponentPS)
public native persistent let pctScanned: Float;
@addField(gameScanningComponentPS)
public native persistent let isBlocked: Bool;

@addField(gamestateMachineComponent)
public native let packageName: String;

@addField(GameTime)
public native let seconds: Int32;

@addField(gameuiAppearanceInfo)
public native let resource: ResourceAsyncRef; // raRef<appearanceAppearanceResource>

@addField(gameuiBaseMenuGameController)
public native let puppetSceneInfos: array<gameuiBaseMenuGameControllerPuppetSceneInfo>;

@addField(gameuiCharacterCustomizationInfo)
public native let index: Int32;
@addField(gameuiCharacterCustomizationInfo)
public native let enabled: Bool;
@addField(gameuiCharacterCustomizationInfo)
public native let link: CName;
@addField(gameuiCharacterCustomizationInfo)
public native let linkController: Bool;
@addField(gameuiCharacterCustomizationInfo)
public native let censorFlag: Uint32; // CensorshipFlags
@addField(gameuiCharacterCustomizationInfo)
public native let censorFlagAction: gameuiCharacterCustomizationActionType;
@addField(gameuiCharacterCustomizationInfo)
public native let onDeactivateActions: array<gameuiCharacterCustomizationAction>;
@addField(gameuiCharacterCustomizationInfo)
public native let randomizeCategory: gamedataCharacterRandomizationCategory;

@addField(gameuiCreditsController)
public native let creditsResourcePS4: ResourceRef; // rRef<inkCreditsResource>
@addField(gameuiCreditsController)
public native let creditsResourceXBOXPC: ResourceRef; // rRef<inkCreditsResource>
@addField(gameuiCreditsController)
public native let scrollingSpeed: Float;
@addField(gameuiCreditsController)
public native let fastforwardScrollingSpeed: Float;
@addField(gameuiCreditsController)
public native let sectionsContainer: inkCompoundRef;
@addField(gameuiCreditsController)
public native let singleTextWidget: inkTextRef;
@addField(gameuiCreditsController)
public native let speakerNameTextWidget: inkTextRef;
@addField(gameuiCreditsController)
public native let swapBackgroundVideoAnimName: CName;
@addField(gameuiCreditsController)
public native let singleAnimName: CName;
@addField(gameuiCreditsController)
public native let openVideoScreenAnimName: CName;
@addField(gameuiCreditsController)
public native let closeVideoScreenAnimName: CName;
@addField(gameuiCreditsController)
public native let headerLibraryID: CName;
@addField(gameuiCreditsController)
public native let boldLibraryID: CName;
@addField(gameuiCreditsController)
public native let basicLibraryID: CName;
@addField(gameuiCreditsController)
public native let basicTranslatableLibraryID: CName;
@addField(gameuiCreditsController)
public native let topCreditsMargin: Float;
@addField(gameuiCreditsController)
public native let bottomCreditsMargin: Float;
@addField(gameuiCreditsController)
public native let startPosition: Float;
@addField(gameuiCreditsController)
public native let subtitlesContainer: inkCompoundRef;
@addField(gameuiCreditsController)
public native let subtitlesLibraryPath: ResourceAsyncRef; // raRef<CResource>

@addField(gameuiCrosshairBaseGameController)
public native let details: inkWidgetRef;

@addField(gameuiCrosshairContainerController)
public native let defaultCrosshair: TweakDBID;

@addField(gameuiGenericNotificationGameController)
public native let exclusiveProcessing: Bool;

@addField(gameuiGenericNotificationReceiverGameController)
public native let ItemChanged: inkEmptyCallback;
@addField(gameuiGenericNotificationReceiverGameController)
public native let NotificationPaused: inkEmptyCallback;
@addField(gameuiGenericNotificationReceiverGameController)
public native let NotificationResumed: inkEmptyCallback;

@addField(gameuiHudSafezonesEditorGameController)
public native let rootWidget: inkCompoundRef;
@addField(gameuiHudSafezonesEditorGameController)
public native let flexWidget: inkCompoundRef;

@addField(gameuiIndexedAppearanceDefinition)
public native let index: Int32;
@addField(gameuiIndexedAppearanceDefinition)
public native let actions: array<gameuiCharacterCustomizationAction>;
@addField(gameuiIndexedAppearanceDefinition)
public native let tags: redTagList;
@addField(gameuiIndexedAppearanceDefinition)
public native let randomizationInfo: gameuiCharacterRandomizationInfo;

@addField(gameuiIndexedMorphName)
public native let index: Int32;
@addField(gameuiIndexedMorphName)
public native let tags: redTagList;
@addField(gameuiIndexedMorphName)
public native let randomizationInfo: gameuiCharacterRandomizationInfo;

@addField(gameuiInGameMenuGameController)
public native let itemSceneInfos: array<gameuiInGameMenuGameControllerItemSceneInfo>;
@addField(gameuiInGameMenuGameController)
public native let garmentSwitchEffectControllers: array<gameuiGarmentSwitchEffectController>;

@addField(gameuiNewHudPhoneGameController)
public native let smsMessengerElement: gameuiExternalPhoneElement;
@addField(gameuiNewHudPhoneGameController)
public native let notificationsElement: gameuiPhoneElementVisibility;
@addField(gameuiNewHudPhoneGameController)
public native let resolutionSensitiveWidgets: array<gameuiResolutionSensitiveWidget>;
@addField(gameuiNewHudPhoneGameController)
public native let hudScalingSensitiveWidgets: array<gameuiHudScalingSensitiveWidget>;
@addField(gameuiNewHudPhoneGameController)
public native let phoneIconMarker: inkWidgetRef;
@addField(gameuiNewHudPhoneGameController)
public native let phoneIconVehicleMarker: inkWidgetRef;
@addField(gameuiNewHudPhoneGameController)
public native let callMarker: inkWidgetRef;
@addField(gameuiNewHudPhoneGameController)
public native let contactsMarker: inkWidgetRef;
@addField(gameuiNewHudPhoneGameController)
public native let notificationMarker: inkWidgetRef;

@addField(gameuiPhoneElementVisibility)
public native let tierVisibility: Uint64; // worlduiContextVisibility
@addField(gameuiPhoneElementVisibility)
public native let gameContextVisibility: Uint32; // gameuiContext

@addField(gameuiPhotoModeMenuController)
public native let SetAttributeOptionEnabled: gameuiSetPhotoModeKeyEnabledCallback;
@addField(gameuiPhotoModeMenuController)
public native let SetCategoryEnabled: gameuiSetPhotoModeKeyEnabledCallback;
@addField(gameuiPhotoModeMenuController)
public native let SetStickerImage: gameuiStickerImageCallback;
@addField(gameuiPhotoModeMenuController)
public native let SetNpcImage: gameuiNpcImageCallback;
@addField(gameuiPhotoModeMenuController)
public native let ChangeAspectRatio: gameuiChangeAspectRatioCallback;

@addField(gameuiPhotoModeStickersController)
public native let backgroundPrefabRef: NodeRef;
@addField(gameuiPhotoModeStickersController)
public native let ResetStickers: inkEmptyCallback;
@addField(gameuiPhotoModeStickersController)
public native let SetStickerImage: gameuiStickerImageCallback;
@addField(gameuiPhotoModeStickersController)
public native let SetFrameImage: gameuiStickerFrameCallback;
@addField(gameuiPhotoModeStickersController)
public native let SetBackground: gameuiStickerBackgroundCallback;
@addField(gameuiPhotoModeStickersController)
public native let SetSetSelectedSticker: gameuiStickerCallback;

@addField(gameuiPuppetPreview_SetCameraSetupEvent)
public native let delayed: Bool;

@addField(gameuiStadiaControllersGameController)
public native let stadiaControllerPage: inkWidgetRef;
@addField(gameuiStadiaControllersGameController)
public native let nintendoControllerPage: inkWidgetRef;
@addField(gameuiStadiaControllersGameController)
public native let durangoControllerPage: inkWidgetRef;
@addField(gameuiStadiaControllersGameController)
public native let orbisControllerPage: inkWidgetRef;
@addField(gameuiStadiaControllersGameController)
public native let disclaimerText: inkWidgetRef;

@addField(gameuiSwitcherInfo)
public native let uiSlots: array<CName>;
@addField(gameuiSwitcherInfo)
public native let switchVisibility: Bool;

@addField(gameuiSwitcherOption)
public native let index: Int32;
@addField(gameuiSwitcherOption)
public native let names: array<CName>;
@addField(gameuiSwitcherOption)
public native let actions: array<gameuiCharacterCustomizationAction>;
@addField(gameuiSwitcherOption)
public native let tags: redTagList;
@addField(gameuiSwitcherOption)
public native let randomizationInfo: gameuiCharacterRandomizationInfo;

@addField(gameuiTimeDisplayLogicController)
public native let timerText: inkTextRef;
@addField(gameuiTimeDisplayLogicController)
public native let noConnectionText: inkTextRef;

@addField(gameuiTooltipsManager)
public native let tooltipsContainer: inkWidgetRef;
@addField(gameuiTooltipsManager)
public native let flipX: Bool;
@addField(gameuiTooltipsManager)
public native let flipY: Bool;
@addField(gameuiTooltipsManager)
public native let flipVerticalAttachment: Bool;
@addField(gameuiTooltipsManager)
public native let rootMargin: inkMargin;
@addField(gameuiTooltipsManager)
public native let screenMargin: inkMargin;

@addField(gameVisionModeComponentPS)
public native persistent let hideInDefaultMode: Bool;
@addField(gameVisionModeComponentPS)
public native persistent let hideInFocusMode: Bool;
@addField(gameVisionModeComponentPS)
public native persistent let inactive: Bool;
@addField(gameVisionModeComponentPS)
public native persistent let questInactive: Bool;

@addField(GlobalNodeID)
public native persistent let hash: Uint64;

@addField(GlobalNodeRef)
public native let hash: Uint64;

@addField(GridCell)
public native let isActive: Bool;

@addField(HackingMinigameGameController)
public native let symbolsRecordTDBID: TweakDBID;
@addField(HackingMinigameGameController)
public native let deviceMode: Bool;

@addField(HDRSettingsGameController)
public native let callibrationScreen: ResourceRef; // rRef<CBitmapTexture>
@addField(HDRSettingsGameController)
public native let callibrationScreenTarget: inkWidgetRef;
@addField(HDRSettingsGameController)
public native let callibrationScreenAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>

@addField(HoldIndicatorGameController)
public native let HoldProgress: gameuiHoldIndicatorProgressCallback;
@addField(HoldIndicatorGameController)
public native let HoldStart: inkEmptyCallback;
@addField(HoldIndicatorGameController)
public native let HoldFinish: inkEmptyCallback;
@addField(HoldIndicatorGameController)
public native let HoldStop: inkEmptyCallback;

@addField(HotSpotLayerDefinition)
public native let group: gameinteractionsEGroupType;
@addField(HotSpotLayerDefinition)
public native let priorityMultiplier: Float;
@addField(HotSpotLayerDefinition)
public native let areaFilterDefinition: ref<gameinteractionsCHotSpotAreaFilterDefinition>;
@addField(HotSpotLayerDefinition)
public native let gameLogicFilterDefinition: ref<gameinteractionsCHotSpotGameLogicFilterDefinition>;

@addField(IComparisonPrereq)
public native let comparisonType: gameComparisonType;

@addField(IComponent)
public native let name: CName;
@addField(IComponent)
public native let isReplicable: Bool;
@addField(IComponent)
public native let id: CRUID;

@addField(IMovingPlatformMovement)
public native let initData: gameIMovingPlatformMovementInitData;
@addField(IMovingPlatformMovement)
public native let endNode: NodeRef;

@addField(InfluenceComponent)
public native let isEnabled: Bool;

@addField(InfluenceObstacleComponent)
public native let boundingBoxType: gameinfluenceEBoundingBoxType;
@addField(InfluenceObstacleComponent)
public native let customBoundingBox: Box;
@addField(InfluenceObstacleComponent)
public native let obstacleAgent: InfluenceObstacleAgent;
@addField(InfluenceObstacleComponent)
public native let isEnabled: Bool;

@addField(InitialLoadingScreenLogicController)
public native let skipButtonPanel: inkWidgetRef;
@addField(InitialLoadingScreenLogicController)
public native let loadingPartsContainer: inkCompoundRef;
@addField(InitialLoadingScreenLogicController)
public native let afterSkipAnimation: CName;
@addField(InitialLoadingScreenLogicController)
public native let loadingFinishedAudioStopEvent: CName;

@addField(inkAnimAnchor)
public native let startValue: Vector2;
@addField(inkAnimAnchor)
public native let endValue: Vector2;

@addField(inkAnimColor)
public native let startValue: HDRColor;
@addField(inkAnimColor)
public native let endValue: HDRColor;

@addField(inkAnimDef)
public native let interpolators: array<ref<inkAnimInterpolator>>;
@addField(inkAnimDef)
public native let events: array<ref<inkAnimEvent>>;

@addField(inkAnimEffect)
public native let startValue: Float;
@addField(inkAnimEffect)
public native let endValue: Float;
@addField(inkAnimEffect)
public native let effectType: inkEffectType;
@addField(inkAnimEffect)
public native let effectName: CName;
@addField(inkAnimEffect)
public native let paramName: CName;

@addField(inkAnimEvent)
public native let startTime: Float;

@addField(inkAnimInterpolator)
public native let interpolationMode: inkanimInterpolationMode;
@addField(inkAnimInterpolator)
public native let interpolationType: inkanimInterpolationType;
@addField(inkAnimInterpolator)
public native let interpolationDirection: inkanimInterpolationDirection;
@addField(inkAnimInterpolator)
public native let duration: Float;
@addField(inkAnimInterpolator)
public native let startDelay: Float;
@addField(inkAnimInterpolator)
public native let useRelativeDuration: Bool;
@addField(inkAnimInterpolator)
public native let isAdditive: Bool;

@addField(inkAnimMargin)
public native let startValue: inkMargin;
@addField(inkAnimMargin)
public native let endValue: inkMargin;

@addField(inkAnimPadding)
public native let startValue: inkMargin;
@addField(inkAnimPadding)
public native let endValue: inkMargin;

@addField(inkAnimPivot)
public native let startValue: Vector2;
@addField(inkAnimPivot)
public native let endValue: Vector2;

@addField(inkAnimRotation)
public native let startValue: Float;
@addField(inkAnimRotation)
public native let endValue: Float;
@addField(inkAnimRotation)
public native let goShortPath: Bool;

@addField(inkAnimScale)
public native let startValue: Vector2;
@addField(inkAnimScale)
public native let endValue: Vector2;

@addField(inkAnimSequence)
public native let name: CName;
@addField(inkAnimSequence)
public native let definitions: array<ref<inkAnimDef>>;
@addField(inkAnimSequence)
public native let targets: array<ref<inkanimSequenceTargetInfo>>;

@addField(inkAnimSetVisibilityEvent)
public native let isVisible: Bool;

@addField(inkAnimShear)
public native let startValue: Vector2;
@addField(inkAnimShear)
public native let endValue: Vector2;

@addField(inkAnimSize)
public native let startValue: Vector2;
@addField(inkAnimSize)
public native let endValue: Vector2;

@addField(inkAnimTextInterpolator)
public native let startValue: Float;
@addField(inkAnimTextInterpolator)
public native let endValue: Float;

@addField(inkAnimTranslation)
public native let startValue: Vector2;
@addField(inkAnimTranslation)
public native let endValue: Vector2;

@addField(inkAnimTransparency)
public native let startValue: Float;
@addField(inkAnimTransparency)
public native let endValue: Float;

@addField(inkBorder)
public native let thickness: Float;

@addField(inkButtonController)
public native let ButtonClick: inkButtonClickCallback;
@addField(inkButtonController)
public native let ButtonHoldComplete: inkButtonHoldCompleteCallback;
@addField(inkButtonController)
public native let ButtonStateChanged: inkButtonStateChangeCallback;
@addField(inkButtonController)
public native let ButtonSelectionChanged: inkButtonSelectionCallback;
@addField(inkButtonController)
public native let ButtonHoldProgressChanged: inkButtonProgressChangedCallback;
@addField(inkButtonController)
public native let canHold: Bool;
@addField(inkButtonController)
public native let selected: Bool;
@addField(inkButtonController)
public native let autoUpdateWidgetState: Bool;

@addField(inkCacheWidget)
public native let innerScale: Vector2;
@addField(inkCacheWidget)
public native let mode: inkCacheMode;
@addField(inkCacheWidget)
public native let externalDynamicTexture: CName;

@addField(inkCharacterCreationPuppetPreviewGameController)
public native let maleSceneName: CName;
@addField(inkCharacterCreationPuppetPreviewGameController)
public native let femaleSceneName: CName;
@addField(inkCharacterCreationPuppetPreviewGameController)
public native let maleCamera01Ref: NodeRef;
@addField(inkCharacterCreationPuppetPreviewGameController)
public native let femaleCamera01Ref: NodeRef;
@addField(inkCharacterCreationPuppetPreviewGameController)
public native let root: inkCompoundRef;
@addField(inkCharacterCreationPuppetPreviewGameController)
public native let image: inkImageRef;
@addField(inkCharacterCreationPuppetPreviewGameController)
public native let animLib: inkWidgetLibraryReference;
@addField(inkCharacterCreationPuppetPreviewGameController)
public native let animName: CName;

@addField(inkCircle)
public native let segmentsNumber: Uint32;

@addField(inkComboBoxController)
public native let comboBoxObjectRef: inkWidgetRef;
@addField(inkComboBoxController)
public native let ComboBoxVisibleChanged: inkComboBoxVisibleChangedCallback;

@addField(inkComboBoxObjectController)
public native let contentWidgetRef: inkWidgetRef;
@addField(inkComboBoxObjectController)
public native let placeholderOffsetWidgetRef: inkWidgetRef;
@addField(inkComboBoxObjectController)
public native let colliderRef: inkShapeRef;
@addField(inkComboBoxObjectController)
public native let offset: inkMargin;

@addField(inkCompoundWidget)
public native let childOrder: inkEChildOrder;
@addField(inkCompoundWidget)
public native let children: ref<inkMultiChildren>;
@addField(inkCompoundWidget)
public native let childMargin: inkMargin;

@addField(inkEntityPreviewCameraSettings)
public native let autoEnable: Bool;
@addField(inkEntityPreviewCameraSettings)
public native let renderingMode: ERenderingMode;

@addField(inkEntityPreviewGameController)
public native let entityToPreview: ResourceAsyncRef; // raRef<entEntityTemplate>

@addField(inkGameNotificationData)
public native let introAnimation: CName;

@addField(inkGenderSelectionPuppetPreviewGameController)
public native let sceneName: CName;
@addField(inkGenderSelectionPuppetPreviewGameController)
public native let cameraRef: NodeRef;

@addField(inkGenericSystemNotificationLogicController)
public native let titleTextWidget: inkTextRef;
@addField(inkGenericSystemNotificationLogicController)
public native let descriptionTextWidget: inkTextRef;
@addField(inkGenericSystemNotificationLogicController)
public native let additionalDataTextWidget: inkTextRef;
@addField(inkGenericSystemNotificationLogicController)
public native let introAnimationName: CName;
@addField(inkGenericSystemNotificationLogicController)
public native let outroAnimationName: CName;
@addField(inkGenericSystemNotificationLogicController)
public native let confirmButton: inkWidgetRef;
@addField(inkGenericSystemNotificationLogicController)
public native let cancelButton: inkWidgetRef;
@addField(inkGenericSystemNotificationLogicController)
public native let DataSetByToken: inkEmptyCallback;

@addField(inkGridController)
public native let height: Uint32;
@addField(inkGridController)
public native let width: Uint32;
@addField(inkGridController)
public native let items: array<inkGridItem>;
@addField(inkGridController)
public native let slotSize: Vector2;
@addField(inkGridController)
public native let itemTemplates: array<inkGridItemTemplate>;

@addField(inkHoldControllerActionData)
public native let actionName: CName;

@addField(inkIGameController)
public native let audioMetadataName: CName;

@addField(inkILogicController)
public native let audioMetadataName: CName;

@addField(inkImage)
public native let useExternalDynamicTexture: Bool;
@addField(inkImage)
public native let externalDynamicTexture: CName;
@addField(inkImage)
public native let useNineSliceScale: Bool;
@addField(inkImage)
public native let nineSliceScale: inkMargin;
@addField(inkImage)
public native let mirrorType: inkBrushMirrorType;
@addField(inkImage)
public native let tileType: inkBrushTileType;
@addField(inkImage)
public native let horizontalTileCrop: Float;
@addField(inkImage)
public native let verticalTileCrop: Float;
@addField(inkImage)
public native let textureAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
@addField(inkImage)
public native let texturePart: CName;
@addField(inkImage)
public native let contentHAlign: inkEHorizontalAlign;
@addField(inkImage)
public native let contentVAlign: inkEVerticalAlign;
@addField(inkImage)
public native let tileHAlign: inkEHorizontalAlign;
@addField(inkImage)
public native let tileVAlign: inkEVerticalAlign;

@addField(inkInputDisplayController)
public native let iconRef: inkWidgetRef;
@addField(inkInputDisplayController)
public native let iconAND: inkTextRef;
@addField(inkInputDisplayController)
public native let nameRef: inkWidgetRef;
@addField(inkInputDisplayController)
public native let canvasRef: inkWidgetRef;
@addField(inkInputDisplayController)
public native let holdIndicatorContainerRef: inkCompoundRef;
@addField(inkInputDisplayController)
public native let gamepadHoldIndicatorLibraryRef: inkWidgetLibraryReference;
@addField(inkInputDisplayController)
public native let keyboardHoldIndicatorLibraryRef: inkWidgetLibraryReference;
@addField(inkInputDisplayController)
public native let holdIndicationType: inkInputHintHoldIndicationType;
@addField(inkInputDisplayController)
public native let inputActionName: CName;
@addField(inkInputDisplayController)
public native let fixedIconHeight: Float;

@addField(inkInventoryPuppetPreviewGameController)
public native let sceneName: CName;
@addField(inkInventoryPuppetPreviewGameController)
public native let cameraRef: NodeRef;

@addField(inkISystemRequestsHandler)
public native let SavesForSaveReady: inkSystemRequesResult;
@addField(inkISystemRequestsHandler)
public native let SavesForLoadReady: inkSystemRequesResult;
@addField(inkISystemRequestsHandler)
public native let SaveMetadataReady: inkSaveMetadataRequestResult;
@addField(inkISystemRequestsHandler)
public native let GogLoginStatusChanged: inkOnGogLoginStatusChangedResult;
@addField(inkISystemRequestsHandler)
public native let SaveDeleted: inkDeleteRequestResult;
@addField(inkISystemRequestsHandler)
public native let SaveTransferUpdate: inkSaveTransferRequestUpdate;
@addField(inkISystemRequestsHandler)
public native let ServersSearchResult: inkSystemServerRequesResult;
@addField(inkISystemRequestsHandler)
public native let AdditionalContentPurchaseResult: inkAdditionalContentPurchaseCallback;
@addField(inkISystemRequestsHandler)
public native let AdditionalContentInstallationRequestResult: inkAdditionalContentInstallRequestedCallback;
@addField(inkISystemRequestsHandler)
public native let AdditionalContentInstallationResult: inkAdditionalContentInstalledCallback;
@addField(inkISystemRequestsHandler)
public native let AdditionalContentStatusUpdateResult: inkAdditionalContentStatusUpdateCallback;
@addField(inkISystemRequestsHandler)
public native let AdditionalContentDataReloadProgressCallback: inkAdditionalContentDataReloadProgress;
@addField(inkISystemRequestsHandler)
public native let ToggleBreachingCallback: inkToggleBreachingCallback;
@addField(inkISystemRequestsHandler)
public native let UserChanged: inkUserIdResult;
@addField(inkISystemRequestsHandler)
public native let UserIdResult: inkUserIdResult;
@addField(inkISystemRequestsHandler)
public native let TrialVersionRemainingTimeUpdated: inkTrialVersionRemainingTimeUpdate;
@addField(inkISystemRequestsHandler)
public native let BoughtFullGame: inkTrialOnBuyFullGame;
@addField(inkISystemRequestsHandler)
public native let CloudSavesQueryStatusChanged: inkCloudSavesQueryStatusChange;
@addField(inkISystemRequestsHandler)
public native let CloudSaveUploadFinish: inkCloudSaveUploadFinish;
@addField(inkISystemRequestsHandler)
public native let ScreenshotsForLoadReady: inkGameScreenshotsRequestResult;
@addField(inkISystemRequestsHandler)
public native let FavoritesLoadedReady: inkFavoriteLoadResult;
@addField(inkISystemRequestsHandler)
public native let DeleteSreenshotComplete: inkDeleteScreenshotResult;
@addField(inkISystemRequestsHandler)
public native let MarketingConsentPopupTypeResult: inkMarketingConsentPopupTypeResult;

@addField(inkItemPreviewGameController)
public native let root: inkWidgetRef;
@addField(inkItemPreviewGameController)
public native let image: inkImageRef;
@addField(inkItemPreviewGameController)
public native let sceneName: CName;
@addField(inkItemPreviewGameController)
public native let cameraRef: NodeRef;

@addField(inkLanguageOverrideProvider)
public native let languageId: inkLanguageId;

@addField(inkLinePattern)
public native let vertexList: array<inkLineVertex>;
@addField(inkLinePattern)
public native let spacing: Float;
@addField(inkLinePattern)
public native let looseSpacing: Float;
@addField(inkLinePattern)
public native let startOffset: Float;
@addField(inkLinePattern)
public native let endOffset: Float;
@addField(inkLinePattern)
public native let fadeInLength: Float;
@addField(inkLinePattern)
public native let rotateWithSegment: Bool;
@addField(inkLinePattern)
public native let patternDirection: inkEChildOrder;

@addField(inkMask)
public native let textureAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
@addField(inkMask)
public native let texturePart: CName;
@addField(inkMask)
public native let dynamicTextureMask: CName;
@addField(inkMask)
public native let dataSource: inkMaskDataSource;
@addField(inkMask)
public native let invertMask: Bool;
@addField(inkMask)
public native let maskTransparency: Float;

@addField(inkPreviewGameController)
public native let yawSpeed: Float;
@addField(inkPreviewGameController)
public native let yawDefault: Float;

@addField(inkPuppetPreviewGameController)
public native let cameraController: gameuiPuppetPreviewCameraController;

@addField(inkRadioGroupController)
public native let toggleRefs: array<inkWidgetRef>;
@addField(inkRadioGroupController)
public native let alwaysToggled: Bool;
@addField(inkRadioGroupController)
public native let selectedIndex: Int32;
@addField(inkRadioGroupController)
public native let ValueChanged: inkRadioGroupChangedCallback;

@addField(inkScrollArea)
public native let horizontalScrolling: Float;
@addField(inkScrollArea)
public native let verticalScrolling: Float;
@addField(inkScrollArea)
public native let constrainContentPosition: Bool;
@addField(inkScrollArea)
public native let fitToContentDirection: inkFitToContentDirection;
@addField(inkScrollArea)
public native let useInternalMask: Bool;

@addField(inkScrollController)
public native let ScrollArea: inkScrollAreaRef;
@addField(inkScrollController)
public native let VerticalScrollBarRef: inkWidgetRef;
@addField(inkScrollController)
public native let navigableCompoundWidget: inkWidgetRef;
@addField(inkScrollController)
public native let CompoundWidgetRef: inkCompoundRef;
@addField(inkScrollController)
public native let autoHideVertical: Bool;
@addField(inkScrollController)
public native let scrollSpeedGamepad: Float;
@addField(inkScrollController)
public native let scrollSpeedMouse: Float;
@addField(inkScrollController)
public native let direction: inkEScrollDirection;
@addField(inkScrollController)
public native let useGlobalInput: Bool;
@addField(inkScrollController)
public native let position: Float;
@addField(inkScrollController)
public native let desiredSetupPosition: Float;
@addField(inkScrollController)
public native let contentSmallerThanViewport: Bool;
@addField(inkScrollController)
public native let scrollDelta: Float;
@addField(inkScrollController)
public native let viewportSize: Vector2;
@addField(inkScrollController)
public native let contentSize: Vector2;

@addField(inkShape)
public native let shapeResource: ResourceRef; // rRef<inkShapeCollectionResource>
@addField(inkShape)
public native let shapeName: CName;
@addField(inkShape)
public native let shapeVariant: inkEShapeVariant;
@addField(inkShape)
public native let keepInBounds: Bool;
@addField(inkShape)
public native let nineSliceScale: inkMargin;
@addField(inkShape)
public native let useNineSlice: Bool;
@addField(inkShape)
public native let contentHAlign: inkEHorizontalAlign;
@addField(inkShape)
public native let contentVAlign: inkEVerticalAlign;
@addField(inkShape)
public native let borderColor: HDRColor;
@addField(inkShape)
public native let borderOpacity: Float;
@addField(inkShape)
public native let fillOpacity: Float;
@addField(inkShape)
public native let lineThickness: Float;
@addField(inkShape)
public native let endCapStyle: inkEEndCapStyle;
@addField(inkShape)
public native let jointStyle: inkEJointStyle;
@addField(inkShape)
public native let vertexList: array<Vector2>;

@addField(inkSliderController)
public native let slidingAreaRef: inkWidgetRef;
@addField(inkSliderController)
public native let handleRef: inkWidgetRef;
@addField(inkSliderController)
public native let nextRef: inkWidgetRef;
@addField(inkSliderController)
public native let priorRef: inkWidgetRef;
@addField(inkSliderController)
public native let direction: inkESliderDirection;
@addField(inkSliderController)
public native let autoSizeHandle: Bool;
@addField(inkSliderController)
public native let minHandleSize: Float;
@addField(inkSliderController)
public native let maxHandleSize: Float;
@addField(inkSliderController)
public native let percentHandleSize: Float;
@addField(inkSliderController)
public native let currentProgress: Float;
@addField(inkSliderController)
public native let minimumValue: Float;
@addField(inkSliderController)
public native let maximumValue: Float;
@addField(inkSliderController)
public native let step: Float;
@addField(inkSliderController)
public native let SliderInput: inkSliderControllerInputCallback;
@addField(inkSliderController)
public native let SliderValueChanged: inkSliderControllerValueChangeCallback;
@addField(inkSliderController)
public native let SliderHandleReleased: inkSliderControllerHandleReleasedCallback;

@addField(inkStepperController)
public native let Change: inkStepperChangedCallback;

@addField(inkText)
public native let localizationString: LocalizationString;
@addField(inkText)
public native let textIdKey: CName;
@addField(inkText)
public native let text: String;
@addField(inkText)
public native let fontFamily: ResourceAsyncRef; // raRef<inkFontFamilyResource>
@addField(inkText)
public native let fontStyle: CName;
@addField(inkText)
public native let fontSize: Uint32;
@addField(inkText)
public native let font: ref<rendFont>;
@addField(inkText)
public native let letterCase: textLetterCase;
@addField(inkText)
public native let tracking: Uint32;
@addField(inkText)
public native let lockFontInGame: Bool;
@addField(inkText)
public native let wrappingInfo: textWrappingInfo;
@addField(inkText)
public native let lineHeightPercentage: Float;
@addField(inkText)
public native let justification: textJustificationType;
@addField(inkText)
public native let textHorizontalAlignment: textHorizontalAlignment;
@addField(inkText)
public native let textVerticalAlignment: textVerticalAlignment;
@addField(inkText)
public native let textOverflowPolicy: textOverflowPolicy;
@addField(inkText)
public native let scrollTextSpeed: Float;
@addField(inkText)
public native let scrollDelay: Uint16;
@addField(inkText)
public native let contentHAlign: inkEHorizontalAlign;
@addField(inkText)
public native let contentVAlign: inkEVerticalAlign;

@addField(inkTextAnimationController)
public native let playOnInitialize: Bool;
@addField(inkTextAnimationController)
public native let animationName: CName;
@addField(inkTextAnimationController)
public native let useDefaultAnimation: Bool;
@addField(inkTextAnimationController)
public native let duration: Float;
@addField(inkTextAnimationController)
public native let startDelay: Float;
@addField(inkTextAnimationController)
public native let startValue: Float;
@addField(inkTextAnimationController)
public native let endValue: Float;

@addField(inkTextKiroshiAnimController)
public native let timeToSkip: Float;
@addField(inkTextKiroshiAnimController)
public native let nativeText: String;
@addField(inkTextKiroshiAnimController)
public native let preTranslatedTextWidget: inkTextRef;
@addField(inkTextKiroshiAnimController)
public native let postTranslatedTextWidget: inkTextRef;
@addField(inkTextKiroshiAnimController)
public native let nativeTextWidget: inkRichTextBoxRef;
@addField(inkTextKiroshiAnimController)
public native let translatedTextWidget: inkTextRef;

@addField(inkTextMotherTongueController)
public native let preTranslatedTextWidget: inkTextRef;
@addField(inkTextMotherTongueController)
public native let postTranslatedTextWidget: inkTextRef;
@addField(inkTextMotherTongueController)
public native let nativeTextWidget: inkRichTextBoxRef;
@addField(inkTextMotherTongueController)
public native let translatedTextWidget: inkTextRef;

@addField(inkTextOffsetController)
public native let timeToSkip: Float;

@addField(inkTextReplaceController)
public native let timeToSkip: Float;
@addField(inkTextReplaceController)
public native let widgetTextUsage: inkTextReplaceAnimationControllerWidgetTextUsage;
@addField(inkTextReplaceController)
public native let baseTextLocalized: LocalizationString;
@addField(inkTextReplaceController)
public native let targetText: String;
@addField(inkTextReplaceController)
public native let targetTextLocalized: LocalizationString;

@addField(inkTextValueProgressController)
public native let baseValue: Float;
@addField(inkTextValueProgressController)
public native let targetValue: Float;
@addField(inkTextValueProgressController)
public native let numbersAfterDot: Int32;
@addField(inkTextValueProgressController)
public native let stepValue: Float;
@addField(inkTextValueProgressController)
public native let suffix: String;

@addField(inkToggleController)
public native let ToggleChanged: inkToggleChangedCallback;
@addField(inkToggleController)
public native let isToggled: Bool;
@addField(inkToggleController)
public native let autoToggleOnInput: Bool;

@addField(inkUniformGrid)
public native let wrappingWidgetCount: Uint32;
@addField(inkUniformGrid)
public native let orientation: inkEOrientation;

@addField(inkVideo)
public native let videoResource: ResourceAsyncRef; // raRef<Bink>
@addField(inkVideo)
public native let loop: Bool;
@addField(inkVideo)
public native let overriddenPlayerName: CName;
@addField(inkVideo)
public native let isParallaxEnabled: Bool;
@addField(inkVideo)
public native let prefetchVideo: Bool;

@addField(inkVirtualCompoundController)
public native let ItemSelected: inkVirtualCompoundControllerCallback;
@addField(inkVirtualCompoundController)
public native let ItemActivated: inkVirtualCompoundControllerCallback;
@addField(inkVirtualCompoundController)
public native let AllElementsSpawned: inkEmptyCallback;

@addField(inkVirtualCompoundItemController)
public native let ToggledOff: inkVirtualCompoundItemControllerCallback;
@addField(inkVirtualCompoundItemController)
public native let ToggledOn: inkVirtualCompoundItemControllerCallback;
@addField(inkVirtualCompoundItemController)
public native let Selected: inkVirtualCompoundItemSelectControllerCallback;
@addField(inkVirtualCompoundItemController)
public native let Deselected: inkVirtualCompoundItemControllerCallback;
@addField(inkVirtualCompoundItemController)
public native let Added: inkVirtualCompoundItemControllerCallback;

@addField(inkVirtualListController)
public native let itemTemplates: array<inkWidgetLibraryReference>;
@addField(inkVirtualListController)
public native let cycleNavigation: Bool;

@addField(inkVirtualUniformListController)
public native let itemTemplate: inkWidgetLibraryReference;

@addField(inkWidget)
public native let logicController: ref<inkLogicController>;
@addField(inkWidget)
public native let secondaryControllers: array<ref<inkLogicController>>;
@addField(inkWidget)
public native let userData: array<ref<inkUserData>>;
@addField(inkWidget)
public native let name: CName;
@addField(inkWidget)
public native let state: CName;
@addField(inkWidget)
public native let visible: Bool;
@addField(inkWidget)
public native let affectsLayoutWhenHidden: Bool;
@addField(inkWidget)
public native let isInteractive: Bool;
@addField(inkWidget)
public native let canSupportFocus: Bool;
@addField(inkWidget)
public native let style: ref<inkStyleResourceWrapper>;
@addField(inkWidget)
public native let parentWidget: wref<inkWidget>;
@addField(inkWidget)
public native let propertyManager: ref<inkPropertyManager>;
@addField(inkWidget)
public native let fitToContent: Bool;
@addField(inkWidget)
public native let layout: inkWidgetLayout;
@addField(inkWidget)
public native let opacity: Float;
@addField(inkWidget)
public native let tintColor: HDRColor;
@addField(inkWidget)
public native let size: Vector2;
@addField(inkWidget)
public native let renderTransformPivot: Vector2;
@addField(inkWidget)
public native let renderTransform: inkUITransform;
@addField(inkWidget)
public native let effects: array<ref<inkIEffect>>;

@addField(inkWidgetLayout)
public native let sizeRule: inkESizeRule;
@addField(inkWidgetLayout)
public native let sizeCoefficient: Float;

@addField(inkWidgetLibraryResource)
public native let library: ResourceAsyncRef; // raRef<inkWidgetLibraryResource>

@addField(inkWidgetPath)
public native let names: array<CName>;

@addField(inkWidgetRef)
public native let widget: wref<inkWidget>;

@addField(inkWorldMapPreviewGameController)
public native let viewTemplate: ResourceAsyncRef; // raRef<entEntityTemplate>
@addField(inkWorldMapPreviewGameController)
public native let viewEnvironmentDefinition: ResourceRef; // rRef<worldEnvironmentAreaParameters>
@addField(inkWorldMapPreviewGameController)
public native let cursorTemplate: ResourceAsyncRef; // raRef<entEntityTemplate>
@addField(inkWorldMapPreviewGameController)
public native let canvas: inkImageRef;

@addField(InputHintManagerGameController)
public native let baseGroupContainer: inkCompoundRef;
@addField(InputHintManagerGameController)
public native let groupsContainer: inkCompoundRef;
@addField(InputHintManagerGameController)
public native let hintLibRef: inkWidgetLibraryReference;
@addField(InputHintManagerGameController)
public native let groupLibRef: inkWidgetLibraryReference;

@addField(InteractionChoice)
public native let lookAtDescriptor: gameinteractionsChoiceLookAtDescriptor;

@addField(InteractionComponent)
public native let definitionResource: ResourceRef; // rRef<gameinteractionsInteractionDescriptorResource>
@addField(InteractionComponent)
public native let interactionRootOffset: Vector3;
@addField(InteractionComponent)
public native let layerOverrides: array<gameinteractionsInteractionDefinitionOverrider>;
@addField(InteractionComponent)
public native let layerOverridesTemp: array<gameinteractionsInteractionDefinitionOverrider>;
@addField(InteractionComponent)
public native let isEnabled: Bool;

@addField(InteractionMultipleSetEnableEvent)
public native let enable: [Bool; 4];
@addField(InteractionMultipleSetEnableEvent)
public native let layer: [CName; 4];
@addField(InteractionMultipleSetEnableEvent)
public native let linkedLayers: [CName; 4];

@addField(Inventory)
public native let saveInventory: Bool;
@addField(Inventory)
public native let inventoryTag: gameSharedInventoryTag;
@addField(Inventory)
public native let noInitialization: Bool;

@addField(IPlacedComponent)
public native let localTransform: WorldTransform;
@addField(IPlacedComponent)
public native let parentTransform: ref<entITransformBinding>;

@addField(ISenseShape)
public native let id: TweakDBID;

@addField(ItemID)
public native persistent let id: TweakDBID;
@addField(ItemID)
public native persistent let rngSeed: Uint32;
@addField(ItemID)
public native persistent let uniqueCounter: Uint16;
@addField(ItemID)
public native persistent let flags: Uint8;

@addField(ItemObject)
public native let updateBucket: UpdateBucketEnum;

@addField(IVisualComponent)
public native let autoHideDistance: Float;
@addField(IVisualComponent)
public native let renderSceneLayerMask: Uint8; // RenderSceneLayerMask
@addField(IVisualComponent)
public native let forceLODLevel: Int8;

@addField(IWorldWidgetComponent)
public native let glitchValue: Float;
@addField(IWorldWidgetComponent)
public native let tintColor: Color;
@addField(IWorldWidgetComponent)
public native let screenAreaMultiplier: Float;
@addField(IWorldWidgetComponent)
public native let textureMinMipBias: Uint32;
@addField(IWorldWidgetComponent)
public native let textureMaxMipBias: Uint32;
@addField(IWorldWidgetComponent)
public native let meshTargetBinding: ref<worlduiMeshTargetBinding>;
@addField(IWorldWidgetComponent)
public native let isEnabled: Bool;

@addField(JournalBriefingMapSection)
public native let mapLocation: Vector3;

@addField(JournalBriefingVideoSection)
public native let videoResource: ResourceAsyncRef; // raRef<Bink>

@addField(JournalCodexCategory)
public native let categoryName: LocalizationString;

@addField(JournalCodexDescription)
public native let subTitle: LocalizationString;
@addField(JournalCodexDescription)
public native let textContent: LocalizationString;

@addField(JournalCodexEntry)
public native let title: LocalizationString;
@addField(JournalCodexEntry)
public native let imageId: TweakDBID;
@addField(JournalCodexEntry)
public native let linkImageId: TweakDBID;

@addField(JournalCodexGroup)
public native let groupName: LocalizationString;
@addField(JournalCodexGroup)
public native let isSorted: Bool;

@addField(JournalContact)
public native let name: LocalizationString;
@addField(JournalContact)
public native let avatarID: TweakDBID;
@addField(JournalContact)
public native let type: gameContactType;
@addField(JournalContact)
public native let useFlatMessageLayout: Bool;
@addField(JournalContact)
public native let isCallableDefault: Bool;

@addField(JournalContainerEntry)
public native let entries: array<ref<JournalEntry>>;

@addField(JournalEmail)
public native let sender: LocalizationString;
@addField(JournalEmail)
public native let addressee: LocalizationString;
@addField(JournalEmail)
public native let title: LocalizationString;
@addField(JournalEmail)
public native let content: LocalizationString;
@addField(JournalEmail)
public native let videoResource: ResourceAsyncRef; // raRef<Bink>
@addField(JournalEmail)
public native let pictureTweak: TweakDBID;

@addField(JournalEntry)
public native let id: String;
@addField(JournalEntry)
public native let journalEntryOverrideDataList: array<JournalEntryOverrideData>;

@addField(JournalEntryOverrideData)
public native let overriddenLocalizationString: LocalizationString;

@addField(JournalFile)
public native let title: LocalizationString;
@addField(JournalFile)
public native let content: LocalizationString;
@addField(JournalFile)
public native let videoResource: ResourceAsyncRef; // raRef<Bink>
@addField(JournalFile)
public native let pictureTweak: TweakDBID;

@addField(JournalImageEntry)
public native let imageId: TweakDBID;
@addField(JournalImageEntry)
public native let thumbnailImageId: TweakDBID;

@addField(JournalInternetBase)
public native let name: CName;
@addField(JournalInternetBase)
public native let linkAddress: String;
@addField(JournalInternetBase)
public native let tintColor: Color;
@addField(JournalInternetBase)
public native let hoverTintColor: Color;

@addField(JournalInternetCanvas)
public native let isHidden: Bool;

@addField(JournalInternetImage)
public native let textureAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
@addField(JournalInternetImage)
public native let texturePart: CName;

@addField(JournalInternetPage)
public native let address: String;
@addField(JournalInternetPage)
public native let factsToSet: array<JournalFactNameValue>;
@addField(JournalInternetPage)
public native let additionallyFilledFromScripts: Bool;
@addField(JournalInternetPage)
public native let reloadOnZoomIn: Bool;
@addField(JournalInternetPage)
public native let widgetFile: ResourceAsyncRef; // raRef<inkWidgetLibraryResource>
@addField(JournalInternetPage)
public native let scale: Float;
@addField(JournalInternetPage)
public native let texts: array<ref<JournalInternetText>>;
@addField(JournalInternetPage)
public native let rectangles: array<ref<JournalInternetRectangle>>;
@addField(JournalInternetPage)
public native let images: array<ref<JournalInternetImage>>;
@addField(JournalInternetPage)
public native let videos: array<ref<JournalInternetVideo>>;
@addField(JournalInternetPage)
public native let canvases: array<ref<JournalInternetCanvas>>;

@addField(JournalInternetSite)
public native let shortName: LocalizationString;
@addField(JournalInternetSite)
public native let mainPagePath: ref<gameJournalPath>;
@addField(JournalInternetSite)
public native let ignoredAtDesktop: Bool;
@addField(JournalInternetSite)
public native let textureAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
@addField(JournalInternetSite)
public native let texturePart: CName;

@addField(JournalInternetText)
public native let text: LocalizationString;

@addField(JournalInternetVideo)
public native let videoResource: ResourceAsyncRef; // raRef<Bink>

@addField(JournalMetaQuest)
public native let title: LocalizationString;

@addField(JournalMetaQuestObjective)
public native let description: LocalizationString;
@addField(JournalMetaQuestObjective)
public native let progressPercent: Uint32;
@addField(JournalMetaQuestObjective)
public native let iconID: TweakDBID;

@addField(JournalOnscreen)
public native let tag: CName;
@addField(JournalOnscreen)
public native let title: LocalizationString;
@addField(JournalOnscreen)
public native let description: LocalizationString;
@addField(JournalOnscreen)
public native let iconID: TweakDBID;

@addField(JournalPhoneChoiceEntry)
public native let text: LocalizationString;
@addField(JournalPhoneChoiceEntry)
public native let isQuestImportant: Bool;
@addField(JournalPhoneChoiceEntry)
public native let questCondition: ref<questIBaseCondition>;

@addField(JournalPhoneConversation)
public native let title: LocalizationString;

@addField(JournalPhoneMessage)
public native let sender: gameMessageSender;
@addField(JournalPhoneMessage)
public native let text: LocalizationString;
@addField(JournalPhoneMessage)
public native let imageId: TweakDBID;
@addField(JournalPhoneMessage)
public native let delay: Float;
@addField(JournalPhoneMessage)
public native let attachment: ref<gameJournalPath>;
@addField(JournalPhoneMessage)
public native let isQuestImportant: Bool;

@addField(JournalQuest)
public native let title: LocalizationString;
@addField(JournalQuest)
public native let type: gameJournalQuestType;
@addField(JournalQuest)
public native let recommendedLevelID: TweakDBID;
@addField(JournalQuest)
public native let districtID: String;

@addField(JournalQuestCodexLink)
public native let path: ref<gameJournalPath>;

@addField(JournalQuestDescription)
public native let description: LocalizationString;

@addField(JournalQuestGuidanceMarker)
public native let nodeRef: NodeRef;
@addField(JournalQuestGuidanceMarker)
public native let pathfindingType: gameQuestGuidanceMarkerPathfindingType;
@addField(JournalQuestGuidanceMarker)
public native let isPortal: Bool;

@addField(JournalQuestMapPin)
public native let reference: EntityReference;
@addField(JournalQuestMapPin)
public native let slotName: CName;
@addField(JournalQuestMapPin)
public native let mappinData: MappinData;
@addField(JournalQuestMapPin)
public native let offset: Vector3;
@addField(JournalQuestMapPin)
public native let uiAnimation: TweakDBID;

@addField(JournalQuestMapPinBase)
public native let enableGPS: Bool;

@addField(JournalQuestMapPinLink)
public native let path: ref<gameJournalPath>;

@addField(JournalQuestObjectiveBase)
public native let description: LocalizationString;
@addField(JournalQuestObjectiveBase)
public native let counter: Uint32;
@addField(JournalQuestObjectiveBase)
public native let optional: Bool;
@addField(JournalQuestObjectiveBase)
public native let locationPrefabRef: NodeRef;
@addField(JournalQuestObjectiveBase)
public native let itemID: TweakDBID;
@addField(JournalQuestObjectiveBase)
public native let districtID: String;

@addField(JournalQuestPhase)
public native let locationPrefabRef: NodeRef;

@addField(JournalRequestContext)
public native let classFilter: JournalRequestClassFilter;

@addField(JournalTarot)
public native let index: Int32;
@addField(JournalTarot)
public native let name: LocalizationString;
@addField(JournalTarot)
public native let description: LocalizationString;
@addField(JournalTarot)
public native let imagePart: CName;

@addField(LatestSaveMetadataInfo)
public native let gameVersion: String;
@addField(LatestSaveMetadataInfo)
public native let additionalContentIds: array<CName>;

@addField(LightComponent)
public native let type: ELightType;
@addField(LightComponent)
public native let color: Color;
@addField(LightComponent)
public native let radius: Float;
@addField(LightComponent)
public native let unit: ELightUnit;
@addField(LightComponent)
public native let intensity: Float;
@addField(LightComponent)
public native let EV: Float;
@addField(LightComponent)
public native let temperature: Float;
@addField(LightComponent)
public native let lightChannel: Uint16; // rendLightChannel
@addField(LightComponent)
public native let sceneDiffuse: Bool;
@addField(LightComponent)
public native let sceneSpecularScale: Uint8;
@addField(LightComponent)
public native let directional: Bool;
@addField(LightComponent)
public native let roughnessBias: Int8;
@addField(LightComponent)
public native let scaleGI: Uint8;
@addField(LightComponent)
public native let scaleEnvProbes: Uint8;
@addField(LightComponent)
public native let useInTransparents: Bool;
@addField(LightComponent)
public native let scaleVolFog: Uint8;
@addField(LightComponent)
public native let useInParticles: Bool;
@addField(LightComponent)
public native let attenuation: rendLightAttenuation;
@addField(LightComponent)
public native let clampAttenuation: Bool;
@addField(LightComponent)
public native let group: rendLightGroup;
@addField(LightComponent)
public native let areaShape: EAreaLightShape;
@addField(LightComponent)
public native let areaTwoSided: Bool;
@addField(LightComponent)
public native let spotCapsule: Bool;
@addField(LightComponent)
public native let sourceRadius: Float;
@addField(LightComponent)
public native let capsuleLength: Float;
@addField(LightComponent)
public native let areaRectSideA: Float;
@addField(LightComponent)
public native let areaRectSideB: Float;
@addField(LightComponent)
public native let innerAngle: Float;
@addField(LightComponent)
public native let outerAngle: Float;
@addField(LightComponent)
public native let softness: Float;
@addField(LightComponent)
public native let enableLocalShadows: Bool;
@addField(LightComponent)
public native let enableLocalShadowsForceStaticsOnly: Bool;
@addField(LightComponent)
public native let contactShadows: rendContactShadowReciever;
@addField(LightComponent)
public native let shadowAngle: Float;
@addField(LightComponent)
public native let shadowRadius: Float;
@addField(LightComponent)
public native let shadowFadeDistance: Float;
@addField(LightComponent)
public native let shadowFadeRange: Float;
@addField(LightComponent)
public native let shadowSoftnessMode: ELightShadowSoftnessMode;
@addField(LightComponent)
public native let rayTracedShadowsPlatform: rendRayTracedShadowsPlatform;
@addField(LightComponent)
public native let rayTracingLightSourceRadius: Float;
@addField(LightComponent)
public native let rayTracingContactShadowRange: Float;
@addField(LightComponent)
public native let iesProfile: ResourceAsyncRef; // raRef<CIESDataResource>
@addField(LightComponent)
public native let flicker: rendSLightFlickering;
@addField(LightComponent)
public native let envColorGroup: EEnvColorGroup;
@addField(LightComponent)
public native let colorGroupSaturation: Uint8;
@addField(LightComponent)
public native let portalAngleCutoff: Uint8;
@addField(LightComponent)
public native let allowDistantLight: Bool;
@addField(LightComponent)
public native let rayTracingIntensityScale: Float;
@addField(LightComponent)
public native let pathTracingLightUsage: rendEPathTracingLightUsage;
@addField(LightComponent)
public native let pathTracingOverrideScaleGI: Bool;
@addField(LightComponent)
public native let rtxdiShadowStartingDistance: Float;
@addField(LightComponent)
public native let isEnabled: Bool;

@addField(ListChoiceHubData)
public native let hubPriority: Uint8;

@addField(ListController)
public native let itemLibraryID: CName;
@addField(ListController)
public native let cycledNavigation: Bool;
@addField(ListController)
public native let beginToggled: Bool;
@addField(ListController)
public native let ItemSelected: inkListControllerCallback;
@addField(ListController)
public native let ItemActivated: inkListControllerCallback;

@addField(ListItemController)
public native let ToggledOff: inkListItemControllerCallback;
@addField(ListItemController)
public native let ToggledOn: inkListItemControllerCallback;
@addField(ListItemController)
public native let Selected: inkListItemControllerCallback;
@addField(ListItemController)
public native let Deselected: inkListItemControllerCallback;
@addField(ListItemController)
public native let AddedToList: inkListItemControllerCallback;

@addField(LoadingScreenLogicController)
public native let mainBackgroundImage: inkImageRef;
@addField(LoadingScreenLogicController)
public native let supportBackgroundImage: inkImageRef;
@addField(LoadingScreenLogicController)
public native let introAnimationName: CName;
@addField(LoadingScreenLogicController)
public native let loopAnimationName: CName;
@addField(LoadingScreenLogicController)
public native let tooltipAnimName: CName;
@addField(LoadingScreenLogicController)
public native let breathInAnimName: CName;
@addField(LoadingScreenLogicController)
public native let breathOutAnimName: CName;
@addField(LoadingScreenLogicController)
public native let tooltipsWidget: inkRichTextBoxRef;

@addField(LocalizationStringComponent)
public native let Strings: array<entLocalizationStringMapEntry>;

@addField(LocomotionParameters)
public native let imperfectTurn: Bool;
@addField(LocomotionParameters)
public native let speedBoostInputRequired: Bool;
@addField(LocomotionParameters)
public native let speedBoostMultiplyByDot: Bool;
@addField(LocomotionParameters)
public native let useCameraHeadingForMovement: Bool;
@addField(LocomotionParameters)
public native let validImperfectTurn: Bool;
@addField(LocomotionParameters)
public native let validSpeedBoostInputRequired: Bool;
@addField(LocomotionParameters)
public native let validSpeedBoostMultiplyByDot: Bool;
@addField(LocomotionParameters)
public native let validUseCameraHeadingForMovement: Bool;
@addField(LocomotionParameters)
public native let doJump: Bool;
@addField(LocomotionParameters)
public native let doSpeedBoost: Bool;

@addField(LookAtRemoveEvent)
public native let hasOutTransition: Bool;
@addField(LookAtRemoveEvent)
public native let outTransitionSpeed: Float;

@addField(LookAtRequest)
public native let additionalParts: [LookAtPartRequest; 2];

@addField(MainMenuGameController)
public native let backgroundContainer: inkCompoundRef;

@addField(MappinData)
public native let localizedCaption: LocalizationString;

@addField(MappinEntry)
public native let type: CName;

@addField(MappinsContainerController)
public native let tier: GameplayTier;
@addField(MappinsContainerController)
public native let spawnContainerPath: inkWidgetPath;
@addField(MappinsContainerController)
public native let gpsQuestPathWidget: inkLinePatternRef;
@addField(MappinsContainerController)
public native let gpsPlayerTrackedPathWidget: inkLinePatternRef;
@addField(MappinsContainerController)
public native let gpsDelamainPathWidget: inkLinePatternRef;
@addField(MappinsContainerController)
public native let autodrivePathWidget: inkLinePatternRef;

@addField(MappinVariantChangedEvent)
public native let entry: wref<JournalEntry>;
@addField(MappinVariantChangedEvent)
public native let phase: gamedataMappinPhase;
@addField(MappinVariantChangedEvent)
public native let variant: gamedataMappinVariant;

@addField(MeshComponent)
public native let mesh: ResourceAsyncRef; // raRef<CMesh>
@addField(MeshComponent)
public native let meshAppearance: CName;
@addField(MeshComponent)
public native let castShadows: shadowsShadowCastingMode;
@addField(MeshComponent)
public native let castLocalShadows: shadowsShadowCastingMode;
@addField(MeshComponent)
public native let castRayTracedGlobalShadows: shadowsShadowCastingMode;
@addField(MeshComponent)
public native let castRayTracedLocalShadows: shadowsShadowCastingMode;
@addField(MeshComponent)
public native let motionBlurScale: Float;
@addField(MeshComponent)
public native let visualScale: Vector3;
@addField(MeshComponent)
public native let renderingPlane: ERenderingPlane;
@addField(MeshComponent)
public native let objectTypeID: ERenderObjectType;
@addField(MeshComponent)
public native let numInstances: Uint32;
@addField(MeshComponent)
public native let chunkMask: Uint64;
@addField(MeshComponent)
public native let order: Uint8;
@addField(MeshComponent)
public native let isEnabled: Bool;
@addField(MeshComponent)
public native let LODMode: entMeshComponentLODMode;
@addField(MeshComponent)
public native let forcedLodDistance: entForcedLodDistance;
@addField(MeshComponent)
public native let overrideMeshNavigationImpact: Bool;
@addField(MeshComponent)
public native let navigationImpact: NavGenNavigationSetting;
@addField(MeshComponent)
public native let version: Uint8;

@addField(MinigameCollisionLogic)
public native let colliderPositionOffset: Vector2;
@addField(MinigameCollisionLogic)
public native let colliderSizeOffset: Vector2;

@addField(MinigameData)
public native let trapSpawnProbability: Float;

@addField(MinigameDynObject)
public native let spawnPoolSize: Uint32;

@addField(MinigameLogicController)
public native let startHealth: Uint32;
@addField(MinigameLogicController)
public native let playerLibraryName: CName;
@addField(MinigameLogicController)
public native let playerColliderPositionOffset: Vector2;
@addField(MinigameLogicController)
public native let playerColliderSizeOffset: Vector2;
@addField(MinigameLogicController)
public native let gameplayRoot: inkCompoundRef;
@addField(MinigameLogicController)
public native let baseSpeed: Float;
@addField(MinigameLogicController)
public native let spawnedListLibraryNames: array<CName>;

@addField(MinigameStateAdvanced)
public native let opertyMaxScore: CName;
@addField(MinigameStateAdvanced)
public native let opertyCurrentLives: CName;
@addField(MinigameStateAdvanced)
public native let opertyCurrentScore: CName;
@addField(MinigameStateAdvanced)
public native let PropertyChanged: gameuiGameStatePropertyChangedCallback;

@addField(MiniGameStateUpdateEventAdvanced)
public native let propertyNames: array<CName>;

@addField(MinimapContainerController)
public native let settings: ref<MinimapSettings>;
@addField(MinimapContainerController)
public native let clampedMappinContainer: inkCompoundRef;
@addField(MinimapContainerController)
public native let unclampedMappinContainer: inkCompoundRef;
@addField(MinimapContainerController)
public native let maskWidget: inkMaskRef;
@addField(MinimapContainerController)
public native let playerIconWidget: inkWidgetRef;
@addField(MinimapContainerController)
public native let compassWidget: inkWidgetRef;
@addField(MinimapContainerController)
public native let worldGeometryContainer: inkCanvasRef;
@addField(MinimapContainerController)
public native let worldGeometryCache: inkCacheRef;
@addField(MinimapContainerController)
public native let geometryLibraryID: CName;
@addField(MinimapContainerController)
public native let timeDisplayWidget: inkCompoundRef;

@addField(MinimapDynamicEventMappinController)
public native let hideAtDistance: Float;
@addField(MinimapDynamicEventMappinController)
public native let hideInCombat: Bool;

@addField(MinimapPingSystemMappinController)
public native let rootWidget: inkWidgetRef;

@addField(MinimapRemotePlayerMappinController)
public native let rootWidget: inkWidgetRef;

@addField(MinimapSettings)
public native let globalVisionRadiusBounds: Range;
@addField(MinimapSettings)
public native let visionRadiusLocked: Bool;
@addField(MinimapSettings)
public native let dynamicVisionRadiusEnabled: Bool;
@addField(MinimapSettings)
public native let smoothingEnabled: Bool;

@addField(MountEventData)
public native persistent let setEntityVisibleWhenMountFinish: Bool;
@addField(MountEventData)
public native persistent let switchRenderPlane: Bool;
@addField(MountEventData)
public native persistent let isJustAttached: Bool;
@addField(MountEventData)
public native persistent let isCarrying: Bool;
@addField(MountEventData)
public native persistent let allowFailsafeTeleport: Bool;

@addField(MountingRelationship)
public native let otherObject: wref<GameObject>;

@addField(MovePolicies)
public native let destination: Vector3;
@addField(MovePolicies)
public native let destinationTangent: Vector3;
@addField(MovePolicies)
public native let startTangent: Vector3;
@addField(MovePolicies)
public native let targetSmartObject: AIObjectId;
@addField(MovePolicies)
public native let targetWorkspot: ref<SetupWorkspotActionEvent>;
@addField(MovePolicies)
public native let targetSmartObjectHash: Uint64;
@addField(MovePolicies)
public native let targetObject: wref<GameObject>;
@addField(MovePolicies)
public native let strafingTarget: StrafingTarget;
@addField(MovePolicies)
public native let useFollowSlots: Bool;
@addField(MovePolicies)
public native let followSlotOverrides: [Vector3; 4];
@addField(MovePolicies)
public native let hasLocalTargetOffset: Bool;
@addField(MovePolicies)
public native let localTargetOffset: Vector3;
@addField(MovePolicies)
public native let desiredDistance: Float;
@addField(MovePolicies)
public native let toleranceRadius: Float;
@addField(MovePolicies)
public native let minMovementDistance: Float;
@addField(MovePolicies)
public native let strafingRotationOffset: Float;
@addField(MovePolicies)
public native let minFollowerDistance: Float;
@addField(MovePolicies)
public native let maxFollowerDistance: Float;
@addField(MovePolicies)
public native let movementType: moveMovementType;
@addField(MovePolicies)
public native let circlingDirection: moveCirclingDirection;
@addField(MovePolicies)
public native let stopOnObstacle: Bool;
@addField(MovePolicies)
public native let avoidObstacleWithinTolerance: Bool;
@addField(MovePolicies)
public native let useCollisionAvoidance: Bool;
@addField(MovePolicies)
public native let useDestReservation: Bool;
@addField(MovePolicies)
public native let inRestrictedArea: Bool;
@addField(MovePolicies)
public native let isSpline: Bool;
@addField(MovePolicies)
public native let startFromClosestPoint: Bool;
@addField(MovePolicies)
public native let ignoreNavigation: Bool;
@addField(MovePolicies)
public native let useStart: Bool;
@addField(MovePolicies)
public native let useStop: Bool;
@addField(MovePolicies)
public native let isEvaluated: Bool;
@addField(MovePolicies)
public native let useOffMeshAllowedTags: Bool;
@addField(MovePolicies)
public native let useOffMeshBlockedTags: Bool;

@addField(MovingPlatform)
public native let loopType: gameMovingPlatformLoopType;
@addField(MovingPlatform)
public native let supportLegacyUnalignedMarkers: Bool;
@addField(MovingPlatform)
public native let enableWaterInteractions: Bool;
@addField(MovingPlatform)
public native let soundPositionName: CName;

@addField(NetrunnerPrototypeNetworkNode)
public native let colorIndex: Int8;

@addField(NetrunnerPrototypeSpawnRequestEvent)
public native let whatToSpawn: CName;
@addField(NetrunnerPrototypeSpawnRequestEvent)
public native let whereToSpawn: Vector3;
@addField(NetrunnerPrototypeSpawnRequestEvent)
public native let scale: Vector3;
@addField(NetrunnerPrototypeSpawnRequestEvent)
public native let colorIndex: Uint8;

@addField(OffMeshConnectionComponent)
public native let offMeshConnectionNodesRefs: array<NodeRef>;
@addField(OffMeshConnectionComponent)
public native let agentSize: NavGenAgentSize;

@addField(OnBeingDetectedEvent)
public native let source: wref<SensorObject>;

@addField(PatrolSplineProgress)
public native let currentControlPoints: array<gamePatrolSplineControlPoint>;
@addField(PatrolSplineProgress)
public native let entrySplineParam: Float;
@addField(PatrolSplineProgress)
public native let controlPointIndex: Uint32;

@addField(PersistentID)
public native persistent let entityHash: Uint64;
@addField(PersistentID)
public native persistent let componentName: CName;

@addField(PhoneWaveformGameController)
public native let measurementsIntreval: Float;
@addField(PhoneWaveformGameController)
public native let measurementsCount: Int32;

@addField(PhysicalDestructionComponent)
public native let mesh: ResourceAsyncRef; // raRef<CMesh>
@addField(PhysicalDestructionComponent)
public native let meshAppearance: CName;
@addField(PhysicalDestructionComponent)
public native let forceAutoHideDistance: Float;
@addField(PhysicalDestructionComponent)
public native let destructionParams: physicsDestructionParams;
@addField(PhysicalDestructionComponent)
public native let destructionLevelData: array<physicsDestructionLevelData>;
@addField(PhysicalDestructionComponent)
public native let isEnabled: Bool;
@addField(PhysicalDestructionComponent)
public native let audioMetadata: CName;
@addField(PhysicalDestructionComponent)
public native let systemsToNotifyFlags: Uint16;

@addField(PhysicalMeshComponent)
public native let visibilityAnimationParam: CName;
@addField(PhysicalMeshComponent)
public native let simulationType: physicsSimulationType;
@addField(PhysicalMeshComponent)
public native let useResourceSimulationType: Bool;
@addField(PhysicalMeshComponent)
public native let startInactive: Bool;
@addField(PhysicalMeshComponent)
public native let filterDataSource: physicsFilterDataSource;
@addField(PhysicalMeshComponent)
public native let filterData: ref<physicsFilterData>;

@addField(PopupData)
public native let video: ResourceAsyncRef; // raRef<Bink>

@addField(PopupsManager)
public native let bracketsContainer: inkCompoundRef;
@addField(PopupsManager)
public native let tutorialOverlayContainer: inkCompoundRef;
@addField(PopupsManager)
public native let bracketLibraryID: CName;

@addField(ProgressionViewData)
public native let canBeMerged: Bool;

@addField(ProjectileComponent)
public native let onCollisionAction: gameprojectileOnCollisionAction;
@addField(ProjectileComponent)
public native let useSweepCollision: Bool;
@addField(ProjectileComponent)
public native let collisionsFilterClosest: Bool;
@addField(ProjectileComponent)
public native let sweepCollisionRadius: Float;
@addField(ProjectileComponent)
public native let rotationOffset: Quaternion;
@addField(ProjectileComponent)
public native let deriveOwnerVelocity: Bool;
@addField(ProjectileComponent)
public native let derivedVelocityParams: gameprojectileVelocityParams;
@addField(ProjectileComponent)
public native let filterData: ref<physicsFilterData>;
@addField(ProjectileComponent)
public native let queryPreset: QueryPreset;
@addField(ProjectileComponent)
public native let previewEffect: ResourceAsyncRef; // raRef<worldEffect>
@addField(ProjectileComponent)
public native let bouncePreviewEffect: ResourceAsyncRef; // raRef<worldEffect>
@addField(ProjectileComponent)
public native let explosionPreviewEffect: ResourceAsyncRef; // raRef<worldEffect>
@addField(ProjectileComponent)
public native let explosionPreviewTime: Float;
@addField(ProjectileComponent)
public native let gameEffectRef: EffectRef;

@addField(ProjectileSpawnComponent)
public native let spawnOffset: Vector3;
@addField(ProjectileSpawnComponent)
public native let projectileTemplates: array<CName>;
@addField(ProjectileSpawnComponent)
public native let slotName: CName;

@addField(QuadRacerLogicController)
public native let endgameDelay: Float;
@addField(QuadRacerLogicController)
public native let baseMultiplicatorScale: Float;
@addField(QuadRacerLogicController)
public native let skyWidget: inkWidgetRef;
@addField(QuadRacerLogicController)
public native let road: array<gameuiRoadEditorSegment>;
@addField(QuadRacerLogicController)
public native let checkpointLibraryName: CName;
@addField(QuadRacerLogicController)
public native let roadLibraryName: CName;
@addField(QuadRacerLogicController)
public native let backgroundLibraryName: CName;
@addField(QuadRacerLogicController)
public native let timeToPassCheckpoint: Float;
@addField(QuadRacerLogicController)
public native let scorePerMeter: Int32;
@addField(QuadRacerLogicController)
public native let scorePerExtraSecond: Int32;
@addField(QuadRacerLogicController)
public native let bonusTime: Float;
@addField(QuadRacerLogicController)
public native let backgroundStitch: Float;
@addField(QuadRacerLogicController)
public native let drawDistance: Uint32;
@addField(QuadRacerLogicController)
public native let carDistanceOfView: Int32;
@addField(QuadRacerLogicController)
public native let colorBlindDrawDistance: Uint32;
@addField(QuadRacerLogicController)
public native let segmentDetails: Uint32;
@addField(QuadRacerLogicController)
public native let segmentLength: Float;
@addField(QuadRacerLogicController)
public native let roadWidth: Float;
@addField(QuadRacerLogicController)
public native let backgroundSpeed: Float;
@addField(QuadRacerLogicController)
public native let cameraFov: Float;
@addField(QuadRacerLogicController)
public native let cameraHeight: Float;
@addField(QuadRacerLogicController)
public native let startTime: Float;
@addField(QuadRacerLogicController)
public native let defaultMaxSpeed: Float;
@addField(QuadRacerLogicController)
public native let nitroMaxSpeed: Float;
@addField(QuadRacerLogicController)
public native let acceleration: Float;
@addField(QuadRacerLogicController)
public native let breaking: Float;
@addField(QuadRacerLogicController)
public native let deceleration: Float;
@addField(QuadRacerLogicController)
public native let offRoadLimit: Float;
@addField(QuadRacerLogicController)
public native let offRoadDeceleration: Float;
@addField(QuadRacerLogicController)
public native let centrifugalForce: Float;
@addField(QuadRacerLogicController)
public native let playerSegmentOffset: Int32;

@addField(QueryFilter)
public native let mask1: Uint64;
@addField(QueryFilter)
public native let mask2: Uint64;

@addField(RagdollActivationRequestData)
public native let activationNoGroundThreshold: Float;
@addField(RagdollActivationRequestData)
public native let activateOnCollision: Bool;
@addField(RagdollActivationRequestData)
public native let calculateEarlyPositionGroundHeight: Bool;

@addField(RagdollImpactPointData)
public native let otherProxyActorIndex: Uint32;

@addField(ReactionData)
public native let startDuration: Float;
@addField(ReactionData)
public native let endDuration: Float;
@addField(ReactionData)
public native let interactionDuration: Float;
@addField(ReactionData)
public native let interactionType: CName;
@addField(ReactionData)
public native let requiredEquips: array<RequestItemParam>;
@addField(ReactionData)
public native let interactionPoint: Transform;
@addField(ReactionData)
public native let useIK: Bool;
@addField(ReactionData)
public native let IKPoint: Vector4;

@addField(RequestItemParam)
public native let instant: Bool;

@addField(ResRef)
public native let resource: ResourceAsyncRef; // raRef<CResource>

@addField(RoachRaceLogicController)
public native let jumpAcceleration: Float;
@addField(RoachRaceLogicController)
public native let jumpCancelAcceleration: Float;
@addField(RoachRaceLogicController)
public native let gravity: Float;
@addField(RoachRaceLogicController)
public native let playerSpawnPoint: Vector2;
@addField(RoachRaceLogicController)
public native let pixelsPerScore: Float;
@addField(RoachRaceLogicController)
public native let invincibilityTime: Float;
@addField(RoachRaceLogicController)
public native let maxSpeedMultiplier: Float;
@addField(RoachRaceLogicController)
public native let multiplierPerScore: Float;
@addField(RoachRaceLogicController)
public native let house: inkWidgetRef;
@addField(RoachRaceLogicController)
public native let ground: inkWidgetRef;
@addField(RoachRaceLogicController)
public native let startAnimation: CName;
@addField(RoachRaceLogicController)
public native let deathAnimation: CName;
@addField(RoachRaceLogicController)
public native let layers: array<RoachRaceChunkLayer>;

@addField(ScanningComponent)
public native let scannableData: array<ScanningTooltipElementDef>;
@addField(ScanningComponent)
public native let timeNeeded: Float;
@addField(ScanningComponent)
public native let autoGenerateBoundingSphere: Bool;
@addField(ScanningComponent)
public native let boundingSphere: Sphere;
@addField(ScanningComponent)
public native let ignoresScanningDistanceLimit: Bool;
@addField(ScanningComponent)
public native let cpoEnableMultiplePlayersScanningModifier: Bool;

@addField(SceneAnimationMotionActionParams)
public native let motionType: gameSceneAnimationMotionActionParamsMotionType;
@addField(SceneAnimationMotionActionParams)
public native let motionBlendInTime: Float;
@addField(SceneAnimationMotionActionParams)
public native let blendInCurve: gameSceneAnimationMotionActionParamsEasingType;
@addField(SceneAnimationMotionActionParams)
public native let initialDt: Float;
@addField(SceneAnimationMotionActionParams)
public native let globalTimeToAnimTime: Float;
@addField(SceneAnimationMotionActionParams)
public native let mountDescriptor: gameMountDescriptor;
@addField(SceneAnimationMotionActionParams)
public native let playerParams: gameScenePlayerAnimationParams;
@addField(SceneAnimationMotionActionParams)
public native let trajectoryLOD: array<scnAnimationMotionSample>;
@addField(SceneAnimationMotionActionParams)
public native let dynamicAnimSetupHash: Uint64;

@addField(SceneTierData)
public native let userDebugInfo: String;

@addField(ScriptableComponent)
public native let priority: Uint32;

@addField(SelectorController)
public native let index: Int32;
@addField(SelectorController)
public native let values: array<String>;
@addField(SelectorController)
public native let cycledNavigation: Bool;
@addField(SelectorController)
public native let SelectionChanged: inkSelectionChangeCallback;

@addField(SenseComponent)
public native let enableBeingDetectable: Bool;
@addField(SenseComponent)
public native let sensorObject: ref<SensorObject>;
@addField(SenseComponent)
public native let isEnabled: Bool;

@addField(SensorObjectComponent)
public native let sensorObject: ref<SensorObject>;
@addField(SensorObjectComponent)
public native let isEnabled: Bool;

@addField(ServerHitData)
public native let id: Uint32;

@addField(ServerKillData)
public native let id: Uint32;

@addField(SetAsQuestImportantEvent)
public native let isImportant: Bool;
@addField(SetAsQuestImportantEvent)
public native let propagateToSlaves: Bool;

@addField(SimpleColliderComponent)
public native let isEnabled: Bool;
@addField(SimpleColliderComponent)
public native let colliders: array<ref<physicsICollider>>;
@addField(SimpleColliderComponent)
public native let filter: ref<physicsFilterData>;

@addField(SimulationFilter)
public native let mask1: Uint64;
@addField(SimulationFilter)
public native let mask2: Uint64;

@addField(SlotComponent)
public native let slots: array<entSlot>;
@addField(SlotComponent)
public native let fallbackSlots: array<entFallbackSlot>;

@addField(SongbirdAudioCallGameController)
public native let waveformEnabled: Bool;
@addField(SongbirdAudioCallGameController)
public native let voLevelsUpdateTimer: Float;
@addField(SongbirdAudioCallGameController)
public native let intensityMultiplier: Float;
@addField(SongbirdAudioCallGameController)
public native let targets: array<inkWidgetRef>;

@addField(soundComponent)
public native let subSystems: array<gameaudioSoundComponentSubSystemWrapper>;
@addField(soundComponent)
public native let voEventOverride: CName;
@addField(soundComponent)
public native let minVocalizationRepeatTime: Float;
@addField(soundComponent)
public native let streamingDistance: Float;

@addField(SoundComponentBase)
public native let audioName: CName;
@addField(SoundComponentBase)
public native let applyObstruction: Bool;
@addField(SoundComponentBase)
public native let applyAcousticOcclusion: Bool;
@addField(SoundComponentBase)
public native let applyAcousticRepositioning: Bool;
@addField(SoundComponentBase)
public native let obstructionChangeTime: Float;
@addField(SoundComponentBase)
public native let maxPlayDistance: Float;

@addField(SoundPlayEvent)
public native let emitterName: CName;
@addField(SoundPlayEvent)
public native let audioTag: CName;
@addField(SoundPlayEvent)
public native let seekTime: Float;
@addField(SoundPlayEvent)
public native let playUnique: Bool;

@addField(SoundPlayVo)
public native let ignoreGlobalVoLimitCheck: Bool;
@addField(SoundPlayVo)
public native let overridingVoiceoverContext: locVoiceoverContext;
@addField(SoundPlayVo)
public native let overridingVoiceoverExpression: locVoiceoverExpression;
@addField(SoundPlayVo)
public native let overrideVoiceoverExpression: Bool;
@addField(SoundPlayVo)
public native let overridingVisualStyleValue: Uint8;
@addField(SoundPlayVo)
public native let overrideVisualStyle: Bool;

@addField(StateScriptInterface)
public native let stateMachineBBDef: ref<BlackboardDefinition>;

@addField(StateSnapshot)
public native let logicalOwnerIsAWeapon: Bool;

@addField(StateSnapshotsContainer)
public native let snapshot: array<StateSnapshot>;

@addField(StatPoolModifier)
public native let usingPointValues: Bool;

@addField(StatsObjectID)
public native let entityHash: Uint64;
@addField(StatsObjectID)
public native let idType: gameStatIDType;

@addField(StatusEffect)
public native persistent let durationID: Uint32;
@addField(StatusEffect)
public native persistent let duration: Float;
@addField(StatusEffect)
public native persistent let remainingDuration: Float;
@addField(StatusEffect)
public native persistent let maxStacks: Uint32;
@addField(StatusEffect)
public native persistent let sourcesData: array<gameSourceData>;
@addField(StatusEffect)
public native persistent let initialApplicationTimestamp: Float;
@addField(StatusEffect)
public native persistent let lastApplicationTimestamp: Float;
@addField(StatusEffect)
public native persistent let ownerEntityID: EntityID;
@addField(StatusEffect)
public native persistent let instigatorRecordID: TweakDBID;
@addField(StatusEffect)
public native persistent let instigatorEntityID: EntityID;
@addField(StatusEffect)
public native persistent let proxyEntityID: EntityID;
@addField(StatusEffect)
public native persistent let direction: Vector4;
@addField(StatusEffect)
public native persistent let removeAllStacksWhenDurationEnds: Bool;
@addField(StatusEffect)
public native persistent let applicationSource: CName;

@addField(StatusEffectBase)
public native persistent let statusEffectRecordID: TweakDBID;

@addField(TargetingComponent)
public native let isPrimary: Bool;
@addField(TargetingComponent)
public native let isDirectional: Bool;
@addField(TargetingComponent)
public native let aimAssistData: array<TweakDBID>;
@addField(TargetingComponent)
public native let isEnabled: Bool;
@addField(TargetingComponent)
public native let alwaysInTestRange: Bool;

@addField(TargetTrackerComponent)
public native let TriggersCombat: Bool;

@addField(TelemetryDamage)
public native let hitCount: Uint32;

@addField(ThreatRemoved)
public native let isDead: Bool;

@addField(TrafficLightListenerComponent)
public native let intersectionRef: NodeRef;
@addField(TrafficLightListenerComponent)
public native let groupIdx: Uint32;

@addField(TransformHistoryComponent)
public native let historyLength: Float;
@addField(TransformHistoryComponent)
public native let samplesAmount: Uint32;

@addField(TriggerComponent)
public native let includeMask: Uint32;
@addField(TriggerComponent)
public native let excludeMask: Uint32;

@addField(TutorialArea)
public native let bracketID: CName;

@addField(TutorialOverlayLogicController)
public native let hideInMenu: Bool;

@addField(UpdateInputHintMultipleEvent)
public native let data: array<InputHintData>;
@addField(UpdateInputHintMultipleEvent)
public native let show: array<Bool>;

@addField(vehicleAudioCurvesParam)
public native let audioCurves: ResourceRef; // rRef<vehicleAudioVehicleCurveSet>

@addField(VehicleCameraManagerComponent)
public native let cinematicCameraEntityTemplate: ResourceAsyncRef; // raRef<entEntityTemplate>

@addField(vehicleCinematicCameraComponent)
public native let groups: array<vehicleCinematicCameraShotGroup>;

@addField(vehicleCinematicCameraShotGroup)
public native let conditions: array<ref<vehicleCinematicCameraShotStartCondition>>;
@addField(vehicleCinematicCameraShotGroup)
public native let shots: array<vehicleCinematicCameraShot>;

@addField(vehicleController)
public native let alarmCurve: CName;
@addField(vehicleController)
public native let alarmTime: Float;
@addField(vehicleController)
public native let overrideHeadlightsSettingsForPlayer: Bool;

@addField(vehicleControllerPS)
public native persistent let vehicleDoors: [VehicleSlotsState; 6];
@addField(vehicleControllerPS)
public native persistent let state: vehicleEState;
@addField(vehicleControllerPS)
public native persistent let lightMode: vehicleELightMode;
@addField(vehicleControllerPS)
public native persistent let isAlarmOn: Bool;
@addField(vehicleControllerPS)
public native persistent let lightTypeMask: Int32;
@addField(vehicleControllerPS)
public native persistent let allowPassengerCameraSwitch: Bool;

@addField(VehicleCustomizationComponent)
public native let defaultDecalsPerAppearance: array<vehicleVehicleAppearanceToDecalsName>;

@addField(VehicleObject)
public native let archetype: ResourceRef; // rRef<AIArchetype>
@addField(VehicleObject)
public native persistent let isVehicleOnStateLocked: Bool;

@addField(VehicleStartedMountingEvent)
public native let silent: Bool;

@addField(VirtualCameraComponent)
public native let virtualCameraName: CName;
@addField(VirtualCameraComponent)
public native let resolutionWidth: Uint32;
@addField(VirtualCameraComponent)
public native let resolutionHeight: Uint32;
@addField(VirtualCameraComponent)
public native let drawBackground: Bool;
@addField(VirtualCameraComponent)
public native let isEnabled: Bool;

@addField(VirtualCameraViewComponent)
public native let virtualCameraName: CName;
@addField(VirtualCameraViewComponent)
public native let targetPlaneSize: Vector2;

@addField(VisibleObject)
public native let visibleObjectType: gamedataSenseObjectType;

@addField(VoicesetComponent)
public native let combatVoSettingsName: CName;

@addField(WeakspotComponent)
public native let defaultPhysicalDestructionProperties: WeakspotPhysicalDestructionProperties;

@addField(WeaponObject)
public native let effect: ResourceRef; // rRef<gameEffectSet>

@addField(WidgetHudComponentInterface)
public native let hudEntriesResource: ResourceRef; // rRef<inkHudEntriesResource>
@addField(WidgetHudComponentInterface)
public native let externalMaterial: ResourceRef; // rRef<CMaterialTemplate>
@addField(WidgetHudComponentInterface)
public native let meshTargetBinding: ref<worlduiMeshTargetBinding>;

@addField(WorkspotFinishedEvent)
public native let statusEffectID: TweakDBID;

@addField(WorkspotResourceComponent)
public native let workspotResource: ResourceAsyncRef; // raRef<workWorkspotResource>
@addField(WorkspotResourceComponent)
public native let npcWorkspotResourceSync: ResourceRef; // rRef<workWorkspotResource>
@addField(WorkspotResourceComponent)
public native let deviceWorkspotResourceSync: ResourceRef; // rRef<workWorkspotResource>
@addField(WorkspotResourceComponent)
public native let syncSlotName: CName;

@addField(WorkspotStartedEvent)
public native let statusEffectID: TweakDBID;

@addField(worldBenchmarkSummary)
public native let CASSharpeningEnabled: Bool;
@addField(worldBenchmarkSummary)
public native let FSREnabled: Bool;
@addField(worldBenchmarkSummary)
public native let FSRQuality: Int32;

@addField(worldITriggerAreaNotifer)
public native let isEnabled: Bool;
@addField(worldITriggerAreaNotifer)
public native let includeChannels: Uint32; // TriggerChannel
@addField(worldITriggerAreaNotifer)
public native let excludeChannels: Uint32;

@addField(WorldMapDistrictLogicController)
public native let outlineWidget: inkLinePatternRef;

@addField(WorldMapMenuGameController)
public native let settingsRecordID: TweakDBID;
@addField(WorldMapMenuGameController)
public native let playerOnTop: Bool;
@addField(WorldMapMenuGameController)
public native let entityPreviewLibraryID: CName;
@addField(WorldMapMenuGameController)
public native let floorPlanSpawnContainer: inkCompoundRef;
@addField(WorldMapMenuGameController)
public native let compassWidget: inkWidgetRef;
@addField(WorldMapMenuGameController)
public native let mappinOutlinesContainer: inkCompoundRef;
@addField(WorldMapMenuGameController)
public native let groupOutlinesContainer: inkCompoundRef;
@addField(WorldMapMenuGameController)
public native let tooltipDistrictOffset: inkMargin;
@addField(WorldMapMenuGameController)
public native let hoveredDistrict: gamedataDistrict;
@addField(WorldMapMenuGameController)
public native let hoveredSubDistrict: gamedataDistrict;

@addField(WorldMapPlayerMappinController)
public native let coneIconWidget: inkImageRef;

@addField(WorldPosition)
public native let x: FixedPoint;
@addField(WorldPosition)
public native let y: FixedPoint;
@addField(WorldPosition)
public native let z: FixedPoint;

@addField(WorldTransform)
public native let Position: WorldPosition;
@addField(WorldTransform)
public native let Orientation: Quaternion;

@addField(worlduiIGameController)
public native let elementRecordID: TweakDBID;

@addField(worlduiWidgetComponent)
public native let cursorResource: ResourceRef; // rRef<inkWidgetLibraryResource>
@addField(worlduiWidgetComponent)
public native let widgetResource: ResourceAsyncRef; // raRef<inkWidgetLibraryResource>
@addField(worlduiWidgetComponent)
public native let itemNameToSpawn: CName;
@addField(worlduiWidgetComponent)
public native let staticTextureResource: ResourceAsyncRef; // raRef<CBitmapTexture>
@addField(worlduiWidgetComponent)
public native let sceneWidgetProperties: worlduiSceneWidgetProperties;
@addField(worlduiWidgetComponent)
public native let spawnDistanceOverride: Float;
@addField(worlduiWidgetComponent)
public native let limitedSpawnDistanceFromVehicle: Bool;

public native class AbortSummoningActionEvent extends ActionEvent {}

public native struct AbsolutePathSerializable {
  public native let Path: String;
}

public native class AcousticPortalComponent extends IPlacedComponent {
  public native let radius: Uint8;
  public native let nominalRadius: Uint8;
  public native let initialyOpen: Bool;
}

public native struct ActionParameterBool {
  public native let name: CName;
  public native let value: Bool;
}

public native struct ActionParameterCName {
  public native let name: CName;
  public native let value: CName;
}

public native struct ActionParameterDouble {
  public native let name: CName;
  public native let value: Double;
}

public native struct ActionParameterFloat {
  public native let name: CName;
  public native let value: Float;
}

public native struct ActionParameterInt {
  public native let name: CName;
  public native let value: Int32;
}

public native struct ActionParameterIScriptable {
  public native let name: CName;
  public native let value: ref<IScriptable>;
}

public native struct ActionParameterTweakDBID {
  public native let name: CName;
  public native let value: TweakDBID;
}

public native struct ActionParameterVector {
  public native let name: CName;
  public native let value: Vector4;
}

public native struct ActionParameterWeakIScriptable {
  public native let name: CName;
  public native let value: wref<IScriptable>;
}

public native class ActionScript extends IObjectScriptBase {
  public native let actionFlags: Uint32;
  public final native func EnableUpdate()
  public final native func GetAITime()
}

public native class ActivityCardsSystem extends IActivityCardsSystem {}

public native class AddedAsHostileThreat extends AIEvent {
  public native let threateningEntity: wref<TargetTrackerComponent>;
  public native let threateningEntityCanTriggersCombat: Bool;
}

public native class AdjustableStreamingRangeTarget extends GameObject {
  public native let minStreamingDistance: Float;
}

public enum AdvertisementFormat {
  Format_0_7x1 = 0,
  Format_1x1 = 1,
  Format_1x0_7 = 2,
  Format_1x1_5 = 3,
  Format_1x2 = 4,
  Format_1x3_3 = 5,
  Format_1_5x1 = 6,
  Format_2x1 = 7,
  Format_3_3x1 = 8,
  Format_3x4 = 9,
  Format_4x3 = 10,
  Format_9x16 = 11,
  Format_9x21 = 12,
  Format_16x9 = 13,
  Format_21x9 = 14,
  Format_a = 15,
  Format_b = 16,
  Format_c = 17,
  Format_d = 18,
  Format_e = 19,
  Format_f = 20,
  Format_i = 21,
  Format_o = 22,
  Format_k = 23,
}

public enum AdvertisementLoadMode {
  TweakDB = 0,
  Override = 1,
}

public native class AdvertisementWidgetComponent extends IWorldWidgetComponent {
  public native let format: AdvertisementFormat;
  public native let adGroupTDBID: TweakDBID;
  public native let enableOverride: Bool;
  public native let adOverrideTDBID: TweakDBID;
  public native let adVersion: Uint32;
  public native let useOnlyAttachedLights: Bool;
  public final native func GetLocalizedDescription()
}

public native class AdvertTranslationLogicController extends inkGameController {
  public native let advertText: inkTextRef;
}

public native class AIActionSpot extends AISmartSpot {
  public native let resource: ResourceAsyncRef; // raRef<workWorkspotResource>
  public native let ActorBodytypeE3: AISocketsForRig;
  public native let masterNodeRef: NodeRef;
  public native let enabledWhenMasterOccupied: Bool;
  public native let snapToGround: Bool;
  public native let useClippingSpace: Bool;
  public native let clippingSpaceOrientation: Float;
  public native let clippingSpaceRange: Float;
}

public native struct AIAIBlackboardSerializableID {
  public native let id: BlackboardSerializableID;
}

public native class AIArchetype extends CResource {
  public native let behaviorDefinition: ref<AIbehaviorParameterizedBehavior>;
  public native let movementParameters: [MovementParameters; 5];
}

public native class AIArchetypeSet extends CResource {
  public native let archetypeResources: array<AIArchetypeSetEntry>;
}

public native struct AIArchetypeSetEntry {
  public native let name: CName;
  public native let resource: ResourceRef; // rRef<AIArchetype>
}

public native class AIArgumentBoolValue extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let defaultValue: Bool;
}

public native class AIArgumentCNameValue extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let defaultValue: CName;
}

public abstract native class AIArgumentDefinition extends ISerializable {
  public native let name: CName;
  public native let isPersistent: Bool;
  public native let behaviorCallbackName: CName;
}

public native class AIArgumentEnumValue extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let enumClass: CName;
  public native let defaultValue: Int64;
}

public native class AIArgumentFloatValue extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let defaultValue: Float;
}

public native class AIArgumentGlobalNodeIdValue extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let defaultValue: GlobalNodeID;
}

public abstract native class AIArgumentInstancePS extends ISerializable {
  public native persistent let name: CName;
}

public native class AIArgumentIntValue extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let defaultValue: Int32;
}

public native class AIArgumentNodeRefValue extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let defaultValue: NodeRef;
}

public native class AIArgumentObjectValue extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let defaultValue: wref<GameObject>;
}

public native struct AIArgumentOverrideWrapper {
  public native let name: CName;
  public native let type: AIArgumentType;
  public native let definition: ref<AIArgumentDefinition>;
}

public native class AIArgumentPuppetRefValue extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let defaultValue: EntityReference;
}

public native class AIArgumentReference extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let defaultValue: Variant;
  public native let rttiClassName: CName;
}

public native class AIArgumentSerializableValue extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let defaultValue: ref<ISerializable>;
}

public native class AIArgumentTreeRefValue extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let defaultValue: ref<AIbehaviorParameterizedBehavior>;
}

public native class AIArgumentUint64Value extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let defaultValue: Uint64;
}

public native class AIArgumentVectorValue extends AIArgumentDefinition {
  public native let type: AIArgumentType;
  public native let defaultValue: Vector3;
}

public native class AIAudioSquad extends SquadBase {}

public native class AIbehaviorActionAnimationCurvePathDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let nodeReference: ref<AIArgumentMapping>;
  public native let controllersSetupName: ref<AIArgumentMapping>;
  public native let useStart: ref<AIArgumentMapping>;
  public native let useStop: ref<AIArgumentMapping>;
  public native let blendTime: ref<AIArgumentMapping>;
  public native let globalInBlendTime: ref<AIArgumentMapping>;
  public native let globalOutBlendTime: ref<AIArgumentMapping>;
  public native let turnCharacterToMatchVelocity: ref<AIArgumentMapping>;
  public native let customStartAnimationName: ref<AIArgumentMapping>;
  public native let customMainAnimationName: ref<AIArgumentMapping>;
  public native let customStopAnimationName: ref<AIArgumentMapping>;
  public native let startSnapToTerrain: ref<AIArgumentMapping>;
  public native let mainSnapToTerrain: ref<AIArgumentMapping>;
  public native let stopSnapToTerrain: ref<AIArgumentMapping>;
  public native let startSnapToTerrainBlendTime: ref<AIArgumentMapping>;
  public native let stopSnapToTerrainBlendTime: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionDieTreeNodeDefinition extends AIbehaviorActionTreeNodeDefinition {}

public native class AIbehaviorActionDroneMoveSplineTreeNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let spline: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionDroneMoveTreeNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let moveType: ref<AIArgumentMapping>;
  public native let target: ref<AIArgumentMapping>;
  public native let movementTarget: ref<AIArgumentMapping>;
  public native let toleranceRadius: ref<AIArgumentMapping>;
  public native let desiredDistanceFromTarget: ref<AIArgumentMapping>;
  public native let strafingTarget: ref<AIArgumentMapping>;
  public native let stopWhenDestinationReached: ref<AIArgumentMapping>;
  public native let rotateEntity: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionDynamicMoveTreeNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let moveType: ref<AIArgumentMapping>;
  public native let target: ref<AIArgumentMapping>;
  public native let targetPosition: ref<AIArgumentMapping>;
  public native let toleranceRadius: ref<AIArgumentMapping>;
  public native let desiredDistanceFromTarget: ref<AIArgumentMapping>;
  public native let strafingTarget: ref<AIArgumentMapping>;
  public native let stopWhenDestinationReached: ref<AIArgumentMapping>;
  public native let rotateEntity: ref<AIArgumentMapping>;
  public native let ignoreNavigation: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionEquipItemNodeDefinition extends AIbehaviorActionItemHandlingNodeDefinition {
  public native let slotId: ref<AIArgumentMapping>;
  public native let itemId: ref<AIArgumentMapping>;
  public native let duration: ref<AIArgumentMapping>;
  public native let failIfItemNotFound: ref<AIArgumentMapping>;
  public native let spawnDelay: ref<AIArgumentMapping>;
}

public abstract native class AIbehaviorActionItemHandlingNodeDefinition extends AIbehaviorActionTreeNodeDefinition {}

public abstract native class AIbehaviorActionMountHandlingNodeDefinition extends AIbehaviorActionTreeNodeDefinition {}

public native class AIbehaviorActionMountNodeDefinition extends AIbehaviorActionMountHandlingNodeDefinition {
  public native let mountData: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionMoveOnSplineNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let spline: ref<AIArgumentMapping>;
  public native let strafingTarget: ref<AIArgumentMapping>;
  public native let movementType: ref<AIArgumentMapping>;
  public native let ignoreNavigation: ref<AIArgumentMapping>;
  public native let snapToTerrain: ref<AIArgumentMapping>;
  public native let rotateEntity: ref<AIArgumentMapping>;
  public native let startFromClosestPoint: ref<AIArgumentMapping>;
  public native let splineRecalculation: ref<AIArgumentMapping>;
  public native let useStart: ref<AIArgumentMapping>;
  public native let useStop: ref<AIArgumentMapping>;
  public native let reverse: ref<AIArgumentMapping>;
  public native let isBackAndForth: ref<AIArgumentMapping>;
  public native let isInfinite: ref<AIArgumentMapping>;
  public native let numberOfLoops: ref<AIArgumentMapping>;
  public native let useOffMeshLinkReservation: ref<AIArgumentMapping>;
  public native let disableFootIK: ref<AIArgumentMapping>;
  public native let allowCrowdOnPath: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionMoveToSmartObjectNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let smartObjectId: ref<AIArgumentMapping>;
  public native let lookAtTarget: ref<AIArgumentMapping>;
  public native let movementType: ref<AIArgumentMapping>;
  public native let tolerance: ref<AIArgumentMapping>;
  public native let ignoreNavigation: ref<AIArgumentMapping>;
  public native let rotateEntity: ref<AIArgumentMapping>;
  public native let useStart: ref<AIArgumentMapping>;
  public native let useStop: ref<AIArgumentMapping>;
  public native let forcedEntryAnimation: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionMoveToWorkspotNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let workspotSetup: ref<AIArgumentMapping>;
  public native let lookAtTarget: ref<AIArgumentMapping>;
  public native let movementType: ref<AIArgumentMapping>;
  public native let tolerance: ref<AIArgumentMapping>;
  public native let ignoreNavigation: ref<AIArgumentMapping>;
  public native let rotateEntity: ref<AIArgumentMapping>;
  public native let useStart: ref<AIArgumentMapping>;
  public native let spotReservation: ref<AIArgumentMapping>;
  public native let startTangent: ref<AIArgumentMapping>;
  public native let fastForwardAfterTeleport: ref<AIArgumentMapping>;
  public native let ignoreExploration: ref<AIArgumentMapping>;
  public native let failWhenStoppedByCollision: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionMoveTreeNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let movementTarget: ref<AIArgumentMapping>;
  public native let lookAtTarget: ref<AIArgumentMapping>;
  public native let movementType: ref<AIArgumentMapping>;
  public native let tolerance: ref<AIArgumentMapping>;
  public native let ignoreNavigation: ref<AIArgumentMapping>;
  public native let rotateEntity: ref<AIArgumentMapping>;
  public native let useStart: ref<AIArgumentMapping>;
  public native let useStop: ref<AIArgumentMapping>;
  public native let destinationTangent: ref<AIArgumentMapping>;
  public native let startTangent: ref<AIArgumentMapping>;
  public native let spotReservation: ref<AIArgumentMapping>;
  public native let ignoreRestrictedArea: ref<AIArgumentMapping>;
  public native let ignoreCollisionsWhenCloseToTarget: ref<AIArgumentMapping>;
  public native let failWhenStoppedByCollision: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionMoveWithPolicyTreeNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let stopWhenDestinationReached: Bool;
}

public abstract native class AIbehaviorActionRotateBaseTreeNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let target: ref<AIArgumentMapping>;
  public native let angleOffset: ref<AIArgumentMapping>;
  public native let angleTolerance: ref<AIArgumentMapping>;
  public native let speed: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionRotateByAngleTreeNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let angle: ref<AIArgumentMapping>;
  public native let angleTolerance: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionRotateToObjectConstTimeTreeNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let target: ref<AIArgumentMapping>;
  public native let angleOffset: ref<AIArgumentMapping>;
  public native let angleTolerance: ref<AIArgumentMapping>;
  public native let time: ref<AIArgumentMapping>;
  public native let keepUpdatingTarget: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionRotateToObjectHeadingTreeNodeDefinition extends AIbehaviorActionRotateBaseTreeNodeDefinition {}

public native class AIbehaviorActionRotateToObjectTreeNodeDefinition extends AIbehaviorActionRotateBaseTreeNodeDefinition {
  public native let completeWhenRotated: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionRotateToPositionTreeNodeDefinition extends AIbehaviorActionRotateBaseTreeNodeDefinition {}

public native class AIbehaviorActionSceneAnimationMotionNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let params: ref<AIArgumentMapping>;
  public native let mountData: ref<AIArgumentMapping>;
}

public abstract native class AIbehaviorActionSlideNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let duration: ref<AIArgumentMapping>;
  public native let ignoreNavigation: ref<AIArgumentMapping>;
  public native let rotateTowardsMovementDirection: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionSlideToLocalPositionNodeDefinition extends AIbehaviorActionSlideNodeDefinition {
  public native let localOffset: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionSlideToObjectNodeDefinition extends AIbehaviorActionSlideNodeDefinition {
  public native let destination: ref<AIArgumentMapping>;
  public native let offset: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionSlideToWorldPositionNodeDefinition extends AIbehaviorActionSlideNodeDefinition {
  public native let worldPosition: ref<AIArgumentMapping>;
  public native let useMovePlanner: Bool;
}

public native class AIbehaviorActionTeleportTreeNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let destinationPoint: ref<AIArgumentMapping>;
  public native let doNavTest: ref<AIArgumentMapping>;
  public native let rotation: ref<AIArgumentMapping>;
  public native let waitForPositionUpdate: ref<AIArgumentMapping>;
}

public abstract native class AIbehaviorActionTreeNodeDefinition extends AIbehaviorLeafTreeNodeDefinition {
  public native let command: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionUnequipItemNodeDefinition extends AIbehaviorActionItemHandlingNodeDefinition {
  public native let slotId: ref<AIArgumentMapping>;
  public native let duration: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionUnmountNodeDefinition extends AIbehaviorActionMountHandlingNodeDefinition {
  public native let mountData: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionUseCommunityWorkspotNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let workspotData: ref<AIArgumentMapping>;
  public native let dependentWorkspotData: ref<AIArgumentMapping>;
  public native let playExitAutomatically: ref<AIArgumentMapping>;
  public native let fastForwardAfterTeleport: ref<AIArgumentMapping>;
}

public native class AIbehaviorActionUseWorkspotNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let eventData: ref<AIArgumentMapping>;
  public native let playStartAnimationAfterwards: ref<AIArgumentMapping>;
  public native let mountData: ref<AIArgumentMapping>;
  public native let dependentWorkspotData: ref<AIArgumentMapping>;
  public native let playExitAutomatically: ref<AIArgumentMapping>;
  public native let markUninterruptable: ref<AIArgumentMapping>;
  public native let fastForwardAfterTeleport: ref<AIArgumentMapping>;
}

public enum AIbehaviorActivationStatus {
  NOT_ACTIVATED = 0,
  ACTIVATING = 1,
  ACTIVATED = 2,
  DEACTIVATING = 3,
}

public native class AIbehaviorAdvancedParameterizedBehavior extends AIbehaviorParameterizedBehavior {}

public native class AIbehaviorAgentInfoDebuggerCommand extends AIbehaviorIDebuggerCommand {
  public native let entityId: EntityID;
  public native let agentName: String;
  public native let isSelected: Bool;
  public native let entries: array<AIbehaviorAgentInfoDebuggerCommandEntry>;
}

public native struct AIbehaviorAgentInfoDebuggerCommandEntry {
  public native let callStack: AIbehaviorBehaviorInstanceCallStack;
  public native let behaviorResourcePath: String;
}

public native class AIbehaviorAndConditionDefinition extends AIbehaviorCompositeConditionDefinition {}

public native class AIbehaviorAssignTaskDefinition extends AIbehaviorTaskDefinition {
  public native let assignments: array<AIbehaviorAssignTaskItem>;
  public native let endAssignments: array<AIbehaviorAssignTaskItem>;
}

public native struct AIbehaviorAssignTaskItem {
  public native let leftHandSide: ref<AIArgumentMapping>;
  public native let rightHandSide: ref<AIArgumentMapping>;
}

public native struct AIbehaviorAsyncCallbackToken {}

public native class AIbehaviorAttachToElevatorCommandTaskDefinition extends AIbehaviorTaskDefinition {
  public native let command: ref<AIArgumentMapping>;
}

public native class AIbehaviorAvoidPlayerTaskDefinition extends AIbehaviorTaskDefinition {
  public native let threatRadius: ref<AIArgumentMapping>;
}

public abstract native class AIbehaviorBehaviorComponentDefinition extends ISerializable {}

public native class AIbehaviorBehaviorDebugInfo extends AIbehaviorDebugInfoBase {}

public native class AIbehaviorBehaviorIncludedDebuggerCommand extends AIbehaviorIDebuggerCommand {
  public native let entries: array<AIbehaviorBehaviorIncludedDebuggerCommandEntry>;
}

public native struct AIbehaviorBehaviorIncludedDebuggerCommandEntry {
  public native let includedBehaviorResourcePath: String;
}

public native struct AIbehaviorBehaviorInstanceCallStack {
  public native let resourceHashes: array<Uint32>;
}

public native class AIbehaviorCancelWorkspotCommandNodeDefinition extends AIbehaviorDecoratorNodeDefinition {}

public native class AIbehaviorChangeGuardAreaTaskDefinition extends AIbehaviorTaskDefinition {
  public native let guardAreaNodeRef: ref<AIArgumentMapping>;
}

public native class AIbehaviorCheckDistanceToCompanionConditionDefinition extends AIbehaviorCompanionConditionDefinition {
  public native let distance: ref<AIArgumentMapping>;
  public native let comparisonOperator: EComparisonType;
}

public native class AIbehaviorCheckLineOfFireTaskDefinition extends AIbehaviorTaskDefinition {
  public native let slotName: ref<AIArgumentMapping>;
  public native let attachmentName: ref<AIArgumentMapping>;
  public native let spread: ref<AIArgumentMapping>;
  public native let maxRange: ref<AIArgumentMapping>;
}

public native class AIbehaviorClearActiveNodesDebuggerCommand extends AIbehaviorIDebuggerCommand {}

public native class AIbehaviorClearSearchInfluenceTaskDefinition extends AIbehaviorTaskDefinition {
  public native let clearedAreaRadius: ref<AIArgumentMapping>;
  public native let clearedAreaDistance: ref<AIArgumentMapping>;
  public native let clearedAreaAngle: ref<AIArgumentMapping>;
}

public native class AIbehaviorClearUsedAlertedSpotsTaskDefinition extends AIbehaviorTaskDefinition {
  public native let usedTokens: ref<AIArgumentMapping>;
}

public native class AIbehaviorCombatModeTaskDefinition extends AIbehaviorTaskDefinition {
  public native let mode: AIbehaviorCombatModes;
  public native let priority: Int32;
  public native let timeToLive: Float;
}

public native class AIbehaviorCommandConditionDefinition extends AIbehaviorConditionDefinition {
  public native let commandName: ref<AIArgumentMapping>;
  public native let useInheritance: Bool;
  public native let isWaiting: Bool;
  public native let isExecuting: Bool;
  public native let commandOut: ref<AIArgumentMapping>;
}

public native class AIbehaviorCommandConditionExpressionDefinition extends AIbehaviorPassiveExpressionDefinition {
  public native let commandName: CName;
  public native let useInheritance: Bool;
  public native let isEnqueued: Bool;
  public native let isExecuting: Bool;
}

public native class AIbehaviorCommandHandlerNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let commandName: CName;
  public native let useInheritance: Bool;
  public native let contexts: array<AICommandContextsType>;
  public native let commandOut: ref<AIArgumentMapping>;
  public native let runningSignal: CName;
  public native let waitForCommand: Bool;
  public native let retryIfCommandEnqueued: Bool;
  public native let resultIfNoCommand: AIbehaviorCompletionStatus;
  public native let resultIfChildFailed: AIbehaviorCompletionStatus;
}

public abstract native class AIbehaviorCompanionConditionDefinition extends AIbehaviorConditionDefinition {
  public native let spline: ref<AIArgumentMapping>;
  public native let companion: ref<AIArgumentMapping>;
}

public native class AIbehaviorComparisonExpressionDefinition extends AIbehaviorPassiveExpressionDefinition {
  public native let leftHandSide: ref<AIbehaviorExpressionSocket>;
  public native let operator: EComparisonType;
  public native let rightHandSide: ref<AIbehaviorExpressionSocket>;
}

public native class AIbehaviorCompleteOnEventNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let eventName: CName;
  public native let resultOnEvent: AIbehaviorCompletionStatus;
}

public abstract native class AIbehaviorCompositeConditionDefinition extends AIbehaviorConditionDefinition {
  public native let conditions: array<ref<AIbehaviorConditionDefinition>>;
}

public abstract native class AIbehaviorCompositeTreeNodeDefinition extends AIbehaviorTreeNodeDefinition {
  public native let children: array<ref<AIbehaviorTreeNodeDefinition>>;
}

public abstract native class AIbehaviorConditionDefinition extends AIbehaviorBehaviorComponentDefinition {
  public native let isInverted: Bool;
}

public abstract native class AIbehaviorConditionNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let condition: ref<AIbehaviorConditionDefinition>;
  public native let resultIfFailed: AIbehaviorCompletionStatus;
}

public native class AIbehaviorConstantExpressionDefinition extends AIbehaviorPassiveExpressionDefinition {
  public native let type: AIbehaviorTypeRef;
  public native let value: Variant;
}

public native class AIbehaviorConvertCommandToDynamicWorkspotTaskDefinition extends AIbehaviorTaskDefinition {
  public native let command: ref<AIArgumentMapping>;
  public native let outWorkspotData: ref<AIArgumentMapping>;
}

public native class AIbehaviorConvertToDynamicWorkspotTaskDefinition extends AIbehaviorTaskDefinition {
  public native let workspotData: ref<AIArgumentMapping>;
  public native let spotInstance: ref<AIArgumentMapping>;
  public native let jumpToEntry: ref<AIArgumentMapping>;
  public native let entryId: ref<AIArgumentMapping>;
}

public native class AIbehaviorCreateAlertedInfluenceMapTaskDefinition extends AIbehaviorTaskDefinition {}

public native class AIbehaviorCrowdSettingsNameVehicleExpressionDefinition extends AIbehaviorVehicleExpressionDefinition {
  public native let settingsName: CName;
}

public native class AIbehaviorCTreeNodeControlledByQuestNodeDefinition extends AIbehaviorActionTreeNodeDefinition {}

public native class AIbehaviorDebugFailsafeConditionDefinition extends AIbehaviorConditionDefinition {
  public native let logMessage: ref<AIArgumentMapping>;
}

public native class AIbehaviorDebugger extends AIbehaviorIDebugger {}

public native class AIbehaviorDebugInfoBase extends ISerializable {
  public native let caption: String;
}

public enum AIbehaviorDebugNodeStatus {
  Undefined = 0,
  NotRunning = 1,
  ForceStopped = 2,
  Running = 3,
  Success = 4,
  Failure = 5,
}

public abstract native class AIbehaviorDecoratorNodeDefinition extends AIbehaviorTreeNodeDefinition {
  public native let child: ref<AIbehaviorTreeNodeDefinition>;
}

public native class AIbehaviorDelegateExpressionDefinition extends AIbehaviorPassiveExpressionDefinition {
  public native let delegateAttribute: AIDelegateAttrRef;
  public native let behaviorCallbackNames: array<CName>;
}

public native class AIbehaviorDelegateTaskDefinition extends AIbehaviorTaskDefinition {
  public native let onActivate: AIDelegateTaskRef;
  public native let onUpdate: AIDelegateTaskRef;
  public native let onDeactivate: AIDelegateTaskRef;
}

public native class AIbehaviorDistanceToExpressionDefinition extends AIbehaviorPassiveExpressionDefinition {
  public native let target: ref<AIbehaviorExpressionSocket>;
  public native let tolerance: Float;
  public native let updatePeriod: Float;
}

public abstract native class AIbehaviorDistanceToTargetConditionDefinition extends AIbehaviorConditionDefinition {
  public native let target: ref<AIArgumentMapping>;
  public native let distance: ref<AIArgumentMapping>;
  public native let comparisonOperator: EComparisonType;
}

public native class AIbehaviorDistanceToTargetObjectConditionDefinition extends AIbehaviorDistanceToTargetConditionDefinition {}

public native class AIbehaviorDistanceToTargetPositionConditionDefinition extends AIbehaviorDistanceToTargetConditionDefinition {}

public native class AIbehaviorDriveAutodriveTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {
  public native let laneFindRange: ref<AIArgumentMapping>;
  public native let minimumDistanceToTarget: ref<AIArgumentMapping>;
  public native let minimumDistanceToTargetVertical: ref<AIArgumentMapping>;
}

public native class AIbehaviorDriveAvSimpleTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {
  public native let timeToTravel: ref<AIArgumentMapping>;
  public native let distanceToTravel: ref<AIArgumentMapping>;
  public native let useEaseInFunction: ref<AIArgumentMapping>;
  public native let useEaseOutFunction: ref<AIArgumentMapping>;
  public native let movementDirection: ref<AIArgumentMapping>;
  public native let useForwardDirection: ref<AIArgumentMapping>;
  public native let easeBounceMultiplier: ref<AIArgumentMapping>;
  public native let despawnAtTheEnd: ref<AIArgumentMapping>;
  public native let disableVFXs: ref<AIArgumentMapping>;
  public native let facePlayer: ref<AIArgumentMapping>;
  public native let doLandingRotation: ref<AIArgumentMapping>;
  public native let interruptTaskOnLandingFound: ref<AIArgumentMapping>;
  public native let attemptToSendEarlyDismountCommand: ref<AIArgumentMapping>;
}

public native class AIbehaviorDriveChaseTargetTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {
  public native let target: ref<AIArgumentMapping>;
  public native let distanceMin: ref<AIArgumentMapping>;
  public native let distanceMax: ref<AIArgumentMapping>;
  public native let forcedStartSpeed: ref<AIArgumentMapping>;
  public native let needDriver: ref<AIArgumentMapping>;
  public native let aggressiveRammingEnabled: ref<AIArgumentMapping>;
  public native let ignoreChaseVehiclesLimit: ref<AIArgumentMapping>;
  public native let boostDrivingStats: ref<AIArgumentMapping>;
}

public native class AIbehaviorDriveCreateTrafficSlotTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {}

public native class AIbehaviorDriveFollowPositionTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {}

public native class AIbehaviorDriveFollowSlotTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {}

public native class AIbehaviorDriveFollowSplineTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {
  public native let useKinematic: ref<AIArgumentMapping>;
  public native let needDriver: ref<AIArgumentMapping>;
  public native let spline: ref<AIArgumentMapping>;
  public native let secureTimeOut: ref<AIArgumentMapping>;
  public native let backwards: ref<AIArgumentMapping>;
  public native let reverse: ref<AIArgumentMapping>;
  public native let closest: ref<AIArgumentMapping>;
  public native let forcedStartSpeed: ref<AIArgumentMapping>;
  public native let stopAtPathEnd: ref<AIArgumentMapping>;
  public native let keepDistanceParamBool: ref<AIArgumentMapping>;
  public native let keepDistanceParamCompanion: ref<AIArgumentMapping>;
  public native let keepDistanceParamDistance: ref<AIArgumentMapping>;
  public native let rubberBandingBool: ref<AIArgumentMapping>;
  public native let rubberBandingTargetRef: ref<AIArgumentMapping>;
  public native let rubberBandingMinDistance: ref<AIArgumentMapping>;
  public native let rubberBandingMaxDistance: ref<AIArgumentMapping>;
  public native let rubberBandingStopAndWait: ref<AIArgumentMapping>;
  public native let rubberBandingTeleportToCatchUp: ref<AIArgumentMapping>;
  public native let audioCurvesParam: ref<AIArgumentMapping>;
}

public native class AIbehaviorDriveFollowTargetTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {
  public native let useKinematic: ref<AIArgumentMapping>;
  public native let needDriver: ref<AIArgumentMapping>;
  public native let target: ref<AIArgumentMapping>;
  public native let secureTimeOut: ref<AIArgumentMapping>;
  public native let distanceMin: ref<AIArgumentMapping>;
  public native let distanceMax: ref<AIArgumentMapping>;
  public native let isPlayer: ref<AIArgumentMapping>;
  public native let stopHasReachedTarget: ref<AIArgumentMapping>;
  public native let useTraffic: ref<AIArgumentMapping>;
  public native let allowStubMovement: ref<AIArgumentMapping>;
}

public native class AIbehaviorDriveIdleTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {}

public native class AIbehaviorDriveJoinTrafficTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {}

public native class AIbehaviorDrivePanicTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {
  public native let allowSimplifiedMovement: ref<AIArgumentMapping>;
  public native let ignoreTickets: ref<AIArgumentMapping>;
  public native let disableStuckDetection: ref<AIArgumentMapping>;
  public native let useSpeedBasedLookupRange: ref<AIArgumentMapping>;
  public native let tryDriveAwayFromPlayer: ref<AIArgumentMapping>;
  public native let needDriver: ref<AIArgumentMapping>;
}

public native class AIbehaviorDrivePatrolTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {
  public native let maxSpeed: ref<AIArgumentMapping>;
  public native let minSpeed: ref<AIArgumentMapping>;
  public native let clearTrafficOnPath: ref<AIArgumentMapping>;
  public native let emergencyPatrol: ref<AIArgumentMapping>;
  public native let numPatrolLoops: ref<AIArgumentMapping>;
  public native let forcedStartSpeed: ref<AIArgumentMapping>;
}

public native class AIbehaviorDriveRacingTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {
  public native let useKinematic: ref<AIArgumentMapping>;
  public native let needDriver: ref<AIArgumentMapping>;
  public native let spline: ref<AIArgumentMapping>;
  public native let secureTimeOut: ref<AIArgumentMapping>;
  public native let backwards: ref<AIArgumentMapping>;
  public native let reverse: ref<AIArgumentMapping>;
  public native let closest: ref<AIArgumentMapping>;
  public native let forcedStartSpeed: ref<AIArgumentMapping>;
  public native let stopAtPathEnd: ref<AIArgumentMapping>;
  public native let keepDistanceParamBool: ref<AIArgumentMapping>;
  public native let keepDistanceParamCompanion: ref<AIArgumentMapping>;
  public native let keepDistanceParamDistance: ref<AIArgumentMapping>;
  public native let rubberBandingBool: ref<AIArgumentMapping>;
  public native let rubberBandingTargetRef: ref<AIArgumentMapping>;
  public native let rubberBandingTargetForwardOffset: ref<AIArgumentMapping>;
  public native let rubberBandingMinDistance: ref<AIArgumentMapping>;
  public native let rubberBandingMaxDistance: ref<AIArgumentMapping>;
  public native let rubberBandingStopAndWait: ref<AIArgumentMapping>;
  public native let rubberBandingTeleportToCatchUp: ref<AIArgumentMapping>;
  public native let rubberBandingStayInFront: ref<AIArgumentMapping>;
}

public native class AIbehaviorDriveSplineReverseTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {
  public native let spline: ref<AIArgumentMapping>;
}

public native class AIbehaviorDriveStunnedTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {}

public native class AIbehaviorDriveSummoningTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {}

public native class AIbehaviorDriveToNodeTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {
  public native let useKinematic: ref<AIArgumentMapping>;
  public native let needDriver: ref<AIArgumentMapping>;
  public native let nodeRef: ref<AIArgumentMapping>;
  public native let stopAtPathEnd: ref<AIArgumentMapping>;
  public native let secureTimeOut: ref<AIArgumentMapping>;
  public native let isPlayer: ref<AIArgumentMapping>;
  public native let useTraffic: ref<AIArgumentMapping>;
  public native let speedInTraffic: ref<AIArgumentMapping>;
  public native let forceGreenLights: ref<AIArgumentMapping>;
  public native let portals: ref<AIArgumentMapping>;
  public native let trafficTryNeighborsForStart: ref<AIArgumentMapping>;
  public native let trafficTryNeighborsForEnd: ref<AIArgumentMapping>;
  public native let ignoreNoAIDrivingLanes: ref<AIArgumentMapping>;
}

public native class AIbehaviorDriveToPointAutonomousTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {
  public native let targetPosition: ref<AIArgumentMapping>;
  public native let maxSpeed: ref<AIArgumentMapping>;
  public native let minSpeed: ref<AIArgumentMapping>;
  public native let clearTrafficOnPath: ref<AIArgumentMapping>;
  public native let minimumDistanceToTarget: ref<AIArgumentMapping>;
  public native let forcedStartSpeed: ref<AIArgumentMapping>;
  public native let driveDownTheRoadIndefinitely: ref<AIArgumentMapping>;
}

public native class AIbehaviorDriveToPointTreeNodeDefinition extends AIbehaviorDriveTreeNodeDefinition {
  public native let targetPosition: ref<AIArgumentMapping>;
  public native let secureTimeOut: ref<AIArgumentMapping>;
  public native let useTraffic: ref<AIArgumentMapping>;
  public native let speedInTraffic: ref<AIArgumentMapping>;
  public native let forceGreenLights: ref<AIArgumentMapping>;
  public native let portals: ref<AIArgumentMapping>;
  public native let trafficTryNeighborsForStart: ref<AIArgumentMapping>;
  public native let trafficTryNeighborsForEnd: ref<AIArgumentMapping>;
}

public abstract native class AIbehaviorDriveTreeNodeDefinition extends AIbehaviorActionTreeNodeDefinition {}

public enum AIbehaviorEdgeConditionAction {
  None = 0,
  Toggle = 1,
  TurnOn = 2,
  TurnOff = 3,
}

public native class AIbehaviorEdgeConditionDefinition extends AIbehaviorUnaryConditionDefinition {
  public native let risingEdgeAction: AIbehaviorEdgeConditionAction;
  public native let fallingEdgeAction: AIbehaviorEdgeConditionAction;
  public native let initialValue: Bool;
}

public native class AIbehaviorEntityLODConditionDefinition extends AIbehaviorConditionDefinition {
  public native let any: array<AIbehaviorEntityLODConditions>;
  public native let all: array<AIbehaviorEntityLODConditions>;
  public native let none: array<AIbehaviorEntityLODConditions>;
}

public enum AIbehaviorEntityLODConditions {
  Crowd = 0,
  Cinematic = 1,
  WorkspotStatic = 2,
}

public native class AIbehaviorEntityReuseEventResolverDefinition extends AIbehaviorEventResolverDefinition {
  public native let destination: ref<AIArgumentMapping>;
  public native let fastForwardAfterTeleport: ref<AIArgumentMapping>;
}

public native class AIbehaviorEventConditionDefinition extends ISerializable {
  public native let condition: ref<AIbehaviorConditionDefinition>;
  public native let eventName: CName;
}

public native struct AIbehaviorEventHandler {}

public native class AIbehaviorEventHandlerNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let eventName: CName;
  public native let resolver: ref<AIbehaviorEventResolverDefinition>;
}

public abstract native class AIbehaviorEventResolverDefinition extends ISerializable {}

public native class AIbehaviorEventWithTagConditionDefinition extends AIbehaviorConditionDefinition {
  public native let tag: CName;
  public native let consumeEvent: Bool;
}

public native class AIbehaviorExitWorkspotNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let skipExitAnimation: ref<AIArgumentMapping>;
  public native let useSlowExitAnimation: ref<AIArgumentMapping>;
  public native let doSlowIfFastExitFails: ref<AIArgumentMapping>;
  public native let stayInWorkspotIfExitFails: ref<AIArgumentMapping>;
  public native let tryBlendFastExitToWalk: ref<AIArgumentMapping>;
  public native let dontRequestExit: ref<AIArgumentMapping>;
  public native let cancelQueuedCommand: ref<AIArgumentMapping>;
  public native let target: ref<AIArgumentMapping>;
}

public native class AIbehaviorExpressionSocket extends ISerializable {
  public native let typeHint: AIbehaviorTypeRef;
  public native let expression: ref<AIbehaviorPassiveExpressionDefinition>;
}

public native class AIbehaviorExtractMountDataTaskDefinition extends AIbehaviorTaskDefinition {
  public native let mountEventData: ref<AIArgumentMapping>;
  public native let outWorkspotData: ref<AIArgumentMapping>;
  public native let outIsInstant: ref<AIArgumentMapping>;
  public native let outAllowFailsafeTeleport: ref<AIArgumentMapping>;
}

public native class AIbehaviorExtractMountParentStubPositionTaskDefinition extends AIbehaviorTaskDefinition {
  public native let mountData: ref<AIArgumentMapping>;
  public native let position: ref<AIArgumentMapping>;
}

public native class AIbehaviorExtractVehicleSlotWorkspotTaskDefinition extends AIbehaviorTaskDefinition {
  public native let outWorkspotData: ref<AIArgumentMapping>;
}

public native class AIbehaviorFailerNodeDefinition extends AIbehaviorLeafTreeNodeDefinition {}

public native class AIbehaviorFindAlertedWorkspotTaskDefinition extends AIbehaviorTaskDefinition {
  public native let usedTokens: ref<AIArgumentMapping>;
  public native let spots: ref<AIArgumentMapping>;
  public native let radius: ref<AIArgumentMapping>;
  public native let outWorkspotData: ref<AIArgumentMapping>;
}

public native class AIbehaviorFindClosestPointOnPathTaskDefinition extends AIbehaviorTaskDefinition {
  public native let path: ref<AIArgumentMapping>;
  public native let forceStartFromClosest: ref<AIArgumentMapping>;
  public native let patrolProgress: ref<AIArgumentMapping>;
  public native let positionOnPath: ref<AIArgumentMapping>;
  public native let entryTangent: ref<AIArgumentMapping>;
}

public native class AIbehaviorFindClosestPointOnTrafficPathTaskDefinition extends AIbehaviorTaskDefinition {
  public native let enterClosest: ref<AIArgumentMapping>;
  public native let avoidedPosition: ref<AIArgumentMapping>;
  public native let useThreatPosAsAvoidedPos: ref<AIArgumentMapping>;
  public native let avoidedPositionDistance: ref<AIArgumentMapping>;
  public native let usePreviousPosition: ref<AIArgumentMapping>;
  public native let checkRoadIntersection: ref<AIArgumentMapping>;
  public native let workspotData: ref<AIArgumentMapping>;
  public native let positionOnPath: ref<AIArgumentMapping>;
  public native let pathDirection: ref<AIArgumentMapping>;
  public native let joinTrafficSettings: ref<AIArgumentMapping>;
}

public native class AIbehaviorFindLaneTaskDefinition extends AIbehaviorTaskDefinition {
  public native let pointOnLane: ref<AIArgumentMapping>;
  public native let filter: worldFindLaneFilter;
}

public native class AIbehaviorFindNavigablePointTaskDefinition extends AIbehaviorTaskDefinition {
  public native let destination: ref<AIArgumentMapping>;
  public native let outAdjustedDestination: ref<AIArgumentMapping>;
  public native let outWasAdjusted: ref<AIArgumentMapping>;
}

public native class AIbehaviorFindTeleportPositionTaskDefinition extends AIbehaviorTaskDefinition {
  public native let patrolPath: ref<AIArgumentMapping>;
  public native let teleportPosition: ref<AIArgumentMapping>;
  public native let teleportRotation: ref<AIArgumentMapping>;
}

public native class AIbehaviorForcedBehaviorNodeDefinition extends AIbehaviorTreeNodeDefinition {}

public native class AIbehaviorFreeReservedWorkspotNodeDefinition extends AIbehaviorDecoratorNodeDefinition {}

public native class AIbehaviorFSMStateDefinition extends AIbehaviorTreeNodeDefinition {
  public native let behaviorRoot: ref<AIbehaviorTreeNodeDefinition>;
  public native let isInitial: Bool;
  public native let isExit: Bool;
  public native let completionStatus: AIbehaviorStateCompletionStatus;
}

public native struct AIbehaviorFSMStateWrapper {}

public native class AIbehaviorFSMTransitionDefinition extends AIbehaviorBehaviorComponentDefinition {
  public native let inState: Uint16;
  public native let outState: Uint16;
  public native let evaluationOrder: Int32;
  public native let instantConditions: array<ref<AIbehaviorInstantConditionDefinition>>;
  public native let monitorConditions: array<ref<AIbehaviorMonitorConditionDefinition>>;
  public native let eventConditions: array<ref<AIbehaviorEventConditionDefinition>>;
  public native let passiveConditions: array<ref<AIbehaviorExpressionSocket>>;
}

public native class AIbehaviorFSMTreeNodeDefinition extends AIbehaviorTreeNodeDefinition {
  public native let states: array<ref<AIbehaviorFSMStateDefinition>>;
  public native let transitions: array<ref<AIbehaviorFSMTransitionDefinition>>;
  public native let initialState: ref<AIbehaviorFSMStateDefinition>;
}

public native class AIbehaviorGenerateSearchInfluenceTaskDefinition extends AIbehaviorTaskDefinition {
  public native let position: ref<AIArgumentMapping>;
  public native let path: ref<AIArgumentMapping>;
  public native let radius: ref<AIArgumentMapping>;
}

public native class AIbehaviorGetEntryPointOnPathTaskDefinition extends AIbehaviorTaskDefinition {
  public native let patrolProgress: ref<AIArgumentMapping>;
  public native let positionOnPath: ref<AIArgumentMapping>;
  public native let entryTangent: ref<AIArgumentMapping>;
}

public native class AIbehaviorGetFollowTrailPointTaskDefinition extends AIbehaviorTaskDefinition {
  public native let inTrailDelay: ref<AIArgumentMapping>;
  public native let outFollowTrailPoint: ref<AIArgumentMapping>;
}

public native class AIbehaviorGetNextPointOnPathTaskDefinition extends AIbehaviorTaskDefinition {
  public native let patrolProgress: ref<AIArgumentMapping>;
  public native let positionOnPath: ref<AIArgumentMapping>;
  public native let entryTangent: ref<AIArgumentMapping>;
}

public native class AIbehaviorGetPatrolPointTaskDefinition extends AIbehaviorTaskDefinition {
  public native let inPatrolDistance: ref<AIArgumentMapping>;
  public native let inLastKnownPosition: ref<AIArgumentMapping>;
  public native let outFollowTrailPoint: ref<AIArgumentMapping>;
}

public native class AIbehaviorGetSearchPointTaskDefinition extends AIbehaviorTaskDefinition {
  public native let inPlayerPositionDelay: ref<AIArgumentMapping>;
  public native let inSearchPositionMaxRadius: ref<AIArgumentMapping>;
  public native let inNearestNavmeshPolyExtent: ref<AIArgumentMapping>;
  public native let inPavementsOnly: ref<AIArgumentMapping>;
  public native let inLastKnownPosition: ref<AIArgumentMapping>;
  public native let outSearchPosition: ref<AIArgumentMapping>;
}

public native class AIbehaviorGetSelectedAgentDebuggerCommand extends AIbehaviorIDebuggerCommand {}

public native class AIbehaviorHasDriverConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorHasPendingForcedBehaviorConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorHostilesDetectedConditionDefinition extends AIbehaviorConditionDefinition {}

public abstract native class AIbehaviorIDebugger extends ISerializable {}

public abstract native class AIbehaviorIDebuggerCommand extends ISerializable {}

public native class AIbehaviorIdleTreeNodeDefinition extends AIbehaviorLeafTreeNodeDefinition {}

public native class AIbehaviorIfElseNodeDefinition extends AIbehaviorCompositeTreeNodeDefinition {
  public native let condition: ref<AIbehaviorExpressionSocket>;
}

public native class AIbehaviorIncludedTreeDefinition extends AIbehaviorNestedTreeDefinition {
  public native let treeReference: ref<AIArgumentMapping>;
}

public native class AIbehaviorInfluenceExcludeObstaclePointTaskDefinition extends AIbehaviorTaskDefinition {
  public native let workspotData: ref<AIArgumentMapping>;
  public native let mountData: ref<AIArgumentMapping>;
}

public native struct AIbehaviorInstance {}

public native class AIbehaviorInstantConditionDefinition extends ISerializable {
  public native let condition: ref<AIbehaviorConditionDefinition>;
}

public native class AIbehaviorInstantConditionNodeDefinition extends AIbehaviorConditionNodeDefinition {}

public native class AIbehaviorInstantJoinTrafficConditionDefinition extends AIbehaviorConditionDefinition {
  public native let joinTrafficSettings: ref<AIArgumentMapping>;
  public native let closestPointOnPath: ref<AIArgumentMapping>;
  public native let pathDirection: ref<AIArgumentMapping>;
  public native let runOnTraffic: ref<AIArgumentMapping>;
}

public native class AIbehaviorInstantMountConditionDefinition extends AIbehaviorConditionDefinition {
  public native let mountData: ref<AIArgumentMapping>;
}

public native class AIbehaviorInstantRunAwayConditionDefinition extends AIbehaviorConditionDefinition {
  public native let destination: ref<AIArgumentMapping>;
  public native let runOnNavmesh: ref<AIArgumentMapping>;
}

public native class AIbehaviorInstantTaskNodeDefinition extends AIbehaviorTaskNodeDefinition {}

public native class AIbehaviorIsAutoDriveFreeRoamModeEnabledVehicleExpressionDefinition extends AIbehaviorVehicleExpressionDefinition {}

public native class AIbehaviorIsAutoDriveModeEnabledVehicleExpressionDefinition extends AIbehaviorVehicleExpressionDefinition {}

public native class AIbehaviorIsAutopilotActiveVehicleExpressionDefinition extends AIbehaviorVehicleExpressionDefinition {}

public native class AIbehaviorIsBeingSummonedDefinition extends AIbehaviorVehicleExpressionDefinition {}

public native class AIbehaviorIsBlockedByCompanionConditionDefinition extends AIbehaviorCompanionConditionDefinition {
  public native let distance: ref<AIArgumentMapping>;
}

public native class AIbehaviorIsDriverInCombatVehicleExpressionDefinition extends AIbehaviorVehicleExpressionDefinition {}

public native class AIbehaviorIsInDesiredRangeConditionDefinition extends AIbehaviorCompanionConditionDefinition {
  public native let desiredDistance: ref<AIArgumentMapping>;
  public native let deadZoneRadius: ref<AIArgumentMapping>;
}

public native class AIbehaviorIsNodeStreamedConditionDefinition extends AIbehaviorConditionDefinition {
  public native let nodeRef: ref<AIArgumentMapping>;
}

public native class AIbehaviorIsStunnedVehicleDefinition extends AIbehaviorVehicleExpressionDefinition {}

public native class AIbehaviorIsThreatOnPathConditionDefinition extends AIbehaviorConditionDefinition {
  public native let threatObject: ref<AIArgumentMapping>;
  public native let threatRadius: ref<AIArgumentMapping>;
}

public native class AIbehaviorIsValueValidConditionDefinition extends AIbehaviorConditionDefinition {
  public native let value: ref<AIArgumentMapping>;
}

public native class AIbehaviorJoinFollowerSquadWithTargetDefinition extends AIbehaviorTaskDefinition {
  public native let follower: ref<AIArgumentMapping>;
}

public abstract native class AIbehaviorLeafTreeNodeDefinition extends AIbehaviorTreeNodeDefinition {}

public native class AIbehaviorLeaveCoverImmediatelyNodeDefinition extends AIbehaviorDecoratorNodeDefinition {}

public native class AIbehaviorLimiterNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let activationLimitPerFrame: Uint32;
  public native let delayChildActivation: Bool;
  public native let delayChildActivationIfAttaching: Bool;
}

public native class AIbehaviorLineOfSightClearConditionDefinition extends AIbehaviorConditionDefinition {
  public native let collisionFilters: array<CName>;
  public native let offset: Vector3;
  public native let target: ref<AIArgumentMapping>;
}

public native class AIbehaviorMappingConditionDefinition extends AIbehaviorConditionDefinition {
  public native let value: ref<AIArgumentMapping>;
}

public native class AIbehaviorMappingExpressionDefinition extends AIbehaviorPassiveExpressionDefinition {
  public native let mapping: ref<AIArgumentMapping>;
  public native let update: Bool;
  public native let updatePeriod: Float;
  public native let behaviorCallbackNames: array<CName>;
}

public enum AIbehaviorMaybeNodeAction {
  Succeed = 0,
  Fail = 1,
  RepeatChild = 2,
}

public native class AIbehaviorMaybeNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let onChildSuccess: AIbehaviorMaybeNodeAction;
  public native let onChildFailure: AIbehaviorMaybeNodeAction;
}

public native class AIbehaviorMonitorConditionDefinition extends ISerializable {
  public native let condition: ref<AIbehaviorConditionDefinition>;
  public native let timeout: Float;
}

public native class AIbehaviorMonitorConditionNodeDefinition extends AIbehaviorConditionNodeDefinition {
  public native let timeout: Float;
}

public native class AIbehaviorMonitorTaskNodeDefinition extends AIbehaviorTaskNodeDefinition {
  public native let timeout: Float;
}

public native class AIbehaviorMountEventResolverDefinition extends AIbehaviorEventResolverDefinition {
  public native let mountData: ref<AIArgumentMapping>;
  public native let workspotData: ref<AIArgumentMapping>;
  public native let isInstant: ref<AIArgumentMapping>;
  public native let behaviorCallbackName: CName;
}

public native class AIbehaviorMountRequestConditionDefinition extends AIbehaviorConditionDefinition {
  public native let testMountRequest: Bool;
  public native let testUnmountRequest: Bool;
  public native let acceptInstant: Bool;
  public native let acceptNotInstant: Bool;
}

public native class AIbehaviorMountToEntTaskDefinition extends AIbehaviorTaskDefinition {
  public native let mountData: ref<AIArgumentMapping>;
}

public native class AIbehaviorMoveAlongTrafficPathActionNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let joinTrafficSettings: ref<AIArgumentMapping>;
  public native let ignoreTrafficSpots: ref<AIArgumentMapping>;
  public native let useCrowdAnimationGraph: ref<AIArgumentMapping>;
  public native let workspotData: ref<AIArgumentMapping>;
  public native let workspotExitPositionWS: ref<AIArgumentMapping>;
  public native let workspotReturnPositionVector: ref<AIArgumentMapping>;
  public native let workspotExitTangent: ref<AIArgumentMapping>;
  public native let trafficLaneReturnTangent: ref<AIArgumentMapping>;
  public native let trafficLaneExitTangent: ref<AIArgumentMapping>;
}

public native class AIbehaviorMovementPolicyTaskDefinition extends AIbehaviorTaskDefinition {
  public native let useCurrentPolicy: Bool;
  public native let waitForPolicy: Bool;
  public native let stopWhenDestinationReached: ref<AIArgumentMapping>;
  public native let policies: array<ref<AIbehaviorMovementPolicyTaskItemDefinition>>;
}

public enum AIbehaviorMovementPolicyTaskFunctions {
  SetMovementType = 0,
  SetTargetObject = 1,
  UseFollowSlots = 2,
  SetLocalTargetOffset = 3,
  SetIgnoreNavigation = 4,
  SetStrafingTarget = 5,
}

public native class AIbehaviorMovementPolicyTaskItemDefinition extends ISerializable {
  public native let function: AIbehaviorMovementPolicyTaskFunctions;
  public native let params: [ref<AIbehaviorExpressionSocket>; 4];
}

public enum AIbehaviorNaryExpressionOperators {
  LogicalAnd = 0,
  LogicalOr = 1,
}

public native class AIbehaviorNaryOperatorExpressionDefinition extends AIbehaviorPassiveExpressionDefinition {
  public native let operator: AIbehaviorNaryExpressionOperators;
  public native let operands: array<ref<AIbehaviorExpressionSocket>>;
}

public abstract native class AIbehaviorNestedTreeDefinition extends AIbehaviorTreeNodeDefinition {
  public native let lateInitialization: Bool;
  public native let initializeOnEvent: array<CName>;
}

public abstract native class AIbehaviorNodeRefConverterTaskDefinition extends AIbehaviorTaskDefinition {
  public native let nodeRef: ref<AIArgumentMapping>;
  public native let result: ref<AIArgumentMapping>;
}

public native class AIbehaviorNodeRefToInstanceTaskDefinition extends AIbehaviorNodeRefConverterTaskDefinition {}

public native class AIbehaviorNodeRefToObjectTaskDefinition extends AIbehaviorNodeRefConverterTaskDefinition {}

public native class AIbehaviorNodeStatusDebuggerCommand extends AIbehaviorIDebuggerCommand {
  public native let behaviorResourceHash: Uint32;
  public native let generation: Uint32;
  public native let entries: array<AIbehaviorNodeStatusDebuggerCommandEntry>;
}

public native struct AIbehaviorNodeStatusDebuggerCommandEntry {
  public native let status: AIbehaviorDebugNodeStatus;
  public native let generation: Uint32;
  public native let failure: ref<gamedebugFailure>;
}

public native class AIbehaviorOrConditionDefinition extends AIbehaviorCompositeConditionDefinition {}

public enum AIbehaviorParallelNodeChildState {
  Inactive = 0,
  Active = 1,
  Completed = 2,
}

public native class AIbehaviorParallelNodeDefinition extends AIbehaviorCompositeTreeNodeDefinition {
  public native let waitFor: AIbehaviorParallelNodeWaitFor;
}

public enum AIbehaviorParallelNodeWaitFor {
  LeftChild = 0,
  RightChild = 1,
  AllChildren = 2,
  BothChildren = 2,
  AnyChild = 3,
}

public native class AIbehaviorParameterizedBehavior extends ISerializable {
  public native let treeDefinition: ResourceRef; // rRef<AIbehaviorResource>
  public native let argumentsOverrides: array<AIArgumentOverrideWrapper>;
}

public abstract native class AIbehaviorPassiveConditionDefinition extends ISerializable {
  public native let invert: Bool;
}

public native class AIbehaviorPassiveConditionNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let condition: ref<AIbehaviorPassiveConditionDefinition>;
  public native let resultIfFailed: AIbehaviorCompletionStatus;
}

public native class AIbehaviorPassiveEventTagConditionDefinition extends AIbehaviorPassiveConditionDefinition {
  public native let tag: CName;
  public native let deactivateEvents: Bool;
}

public native class AIbehaviorPassiveSignalConditionDefinition extends AIbehaviorPassiveConditionDefinition {
  public native let tag: CName;
  public native let deactivateSignal: Bool;
}

public native class AIbehaviorPatrolActionNodeDefinition extends AIbehaviorActionTreeNodeDefinition {
  public native let path: ref<AIArgumentMapping>;
  public native let patrolProgress: ref<AIArgumentMapping>;
  public native let startFromClosestPoint: ref<AIArgumentMapping>;
  public native let patrolContinuationPolicy: ref<AIArgumentMapping>;
  public native let playStartAnimation: ref<AIArgumentMapping>;
  public native let fastForwardAfterTeleport: ref<AIArgumentMapping>;
  public native let workspotData: ref<AIArgumentMapping>;
  public native let dependentWorkspotData: ref<AIArgumentMapping>;
  public native let lookAtTarget: ref<AIArgumentMapping>;
  public native let usePathContext: ref<AIArgumentMapping>;
  public native let useOffMeshLinkReservation: ref<AIArgumentMapping>;
}

public native class AIbehaviorPickSearchDestinationTaskDefinition extends AIbehaviorTaskDefinition {
  public native let destinationPosition: ref<AIArgumentMapping>;
  public native let desiredDistance: ref<AIArgumentMapping>;
  public native let maxDistance: ref<AIArgumentMapping>;
  public native let clearedAreaRadius: ref<AIArgumentMapping>;
  public native let clearedAreaDistance: ref<AIArgumentMapping>;
  public native let clearedAreaAngle: ref<AIArgumentMapping>;
  public native let ignoreRestrictMovementArea: ref<AIArgumentMapping>;
}

public native class AIbehaviorPredictTargetMovementDefinition extends AIbehaviorTaskDefinition {
  public native let target: ref<AIArgumentMapping>;
  public native let timeInterval: ref<AIArgumentMapping>;
  public native let result: ref<AIArgumentMapping>;
}

public native class AIbehaviorPrepareReservedCrowdWorkspotNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let workspotData: ref<AIArgumentMapping>;
  public native let returnPosition: ref<AIArgumentMapping>;
  public native let returnPositionVector: ref<AIArgumentMapping>;
  public native let workspotExitTangent: ref<AIArgumentMapping>;
  public native let joinTrafficSettings: ref<AIArgumentMapping>;
  public native let overrideExit: ref<AIArgumentMapping>;
}

public native class AIbehaviorPuppetRefToGameObjectTaskDefinition extends AIbehaviorTaskDefinition {
  public native let puppetRef: ref<AIArgumentMapping>;
  public native let result: ref<AIArgumentMapping>;
}

public native class AIbehaviorRandomConditionDefinition extends AIbehaviorConditionDefinition {
  public native let chance: Float;
}

public native class AIbehaviorRecalculateVehicleWorkspotPositionTaskDefinition extends AIbehaviorTaskDefinition {
  public native let mountData: ref<AIArgumentMapping>;
  public native let workspotData: ref<AIArgumentMapping>;
}

public native class AIbehaviorReevaluateOnEventNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let eventName: CName;
}

public native class AIbehaviorRepeatNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let limit: ref<AIArgumentMapping>;
  public native let repeatChildOnFailure: Bool;
}

public native class AIbehaviorResource extends CResource {
  public native let root: ref<AIbehaviorTreeNodeDefinition>;
  public native let arguments: AITreeArgumentsDefinition;
  public native let delegate: ref<BehaviorDelegate>;
  public native let initializationEvents: array<CName>;
}

public native class AIbehaviorRestoreSavedPatrolProgressTaskDefinition extends AIbehaviorTaskDefinition {
  public native let path: ref<AIArgumentMapping>;
  public native let savedState: ref<AIArgumentMapping>;
  public native let patrolProgress: ref<AIArgumentMapping>;
  public native let destinationPosition: ref<AIArgumentMapping>;
  public native let destinationTangent: ref<AIArgumentMapping>;
}

public native class AIbehaviorSaveEventResolverDefinition extends AIbehaviorEventResolverDefinition {
  public native let eventData: ref<AIArgumentMapping>;
}

public native class AIbehaviorSavePatrolProgressTaskDefinition extends AIbehaviorTaskDefinition {
  public native let patrolProgress: ref<AIArgumentMapping>;
  public native let saveOnDeactivation: Bool;
  public native let savedState: ref<AIArgumentMapping>;
}

public native class AIbehaviorScriptConditionDefinition extends AIbehaviorConditionDefinition {
  public native let script: ref<AIbehaviorconditionScript>;
  public native let disableLazyInitialization: Bool;
}

public native class AIbehaviorScriptEventResolverDefinition extends AIbehaviorEventResolverDefinition {
  public native let script: ref<AIScriptEventResolver>;
}

public native class AIbehaviorScriptPassiveExpressionDefinition extends AIbehaviorPassiveExpressionDefinition {
  public native let script: ref<AIbehaviorexpressionScript>;
}

public native class AIbehaviorScriptTaskDefinition extends AIbehaviorTaskDefinition {
  public native let script: ref<AIbehaviortaskScript>;
  public native let disableLazyInitialization: Bool;
}

public native class AIbehaviorSelectCombatTargetTaskDefinition extends AIbehaviorTaskDefinition {
  public native let target: ref<AIArgumentMapping>;
  public native let targetClosest: Bool;
}

public native class AIbehaviorSelectCoverTaskDefinition extends AIbehaviorTaskDefinition {
  public native let cover: ref<AIArgumentMapping>;
  public native let coverID: ref<AIArgumentMapping>;
  public native let multiCoverID: ref<AIArgumentMapping>;
  public native let combatTarget: ref<AIArgumentMapping>;
  public native let friendlyTarget: ref<AIArgumentMapping>;
  public native let combatZone: ref<AIArgumentMapping>;
  public native let sectorSelection: CName;
  public native let ignoreRestrictMovementArea: ref<AIArgumentMapping>;
  public native let selectionPreset: ref<AIArgumentMapping>;
  public native let onActivationSelectionPreset: ref<AIArgumentMapping>;
  public native let secondStagePreset: ref<AIArgumentMapping>;
  public native let coverChangeThreshold: ref<AIArgumentMapping>;
  public native let coverGatheringCenterObject: ref<AIArgumentMapping>;
  public native let coverDisablingDuration: ref<AIArgumentMapping>;
}

public native struct AIbehaviorSelectionStagePtrWrapper {}

public native class AIbehaviorSelectorTreeNodeDefinition extends AIbehaviorCompositeTreeNodeDefinition {}

public native class AIbehaviorSelectWorkspotEntryTaskDefinition extends AIbehaviorTaskDefinition {
  public native let workspotData: ref<AIArgumentMapping>;
  public native let destinationPosition: ref<AIArgumentMapping>;
  public native let tangentPoint: ref<AIArgumentMapping>;
  public native let entranceFromStand: ref<AIArgumentMapping>;
}

public native class AIbehaviorSelectWorkspotNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let spotInstance: ref<AIArgumentMapping>;
  public native let workspotData: ref<AIArgumentMapping>;
  public native let dependentWorkspotData: ref<AIArgumentMapping>;
  public native let repeatChild: Bool;
  public native let fastForwardAfterTeleport: ref<AIArgumentMapping>;
}

public native class AIbehaviorSendActionEventTaskDefinition extends AIbehaviorTaskDefinition {
  public native let event: ref<ActionEvent>;
}

public native class AIbehaviorSendSignalTaskDefinition extends AIbehaviorTaskDefinition {
  public native let signalName: CName;
  public native let startAction: gameBoolSignalAction;
  public native let startActionUserData: ref<SignalUserDataDefinition>;
  public native let endAction: gameBoolSignalAction;
  public native let endActionUserData: ref<SignalUserDataDefinition>;
}

public native class AIbehaviorSequenceTreeNodeDefinition extends AIbehaviorCompositeTreeNodeDefinition {}

public native class AIbehaviorShouldEnterCrowdConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorShouldFollowSlotDefinition extends AIbehaviorVehicleExpressionDefinition {}

public native class AIbehaviorShouldJoinTrafficDefinition extends AIbehaviorVehicleExpressionDefinition {}

public native class AIbehaviorSignalConditionDefinition extends AIbehaviorConditionDefinition {
  public native let signalName: CName;
  public native let mode: AIbehaviorSignalConditionModes;
  public native let tagSignal: Bool;
}

public enum AIbehaviorSignalConditionModes {
  CurrentValue = 0,
  StartOfFrameValue = 1,
  RisingEdge = 2,
  FallingEdge = 3,
  AnyEdge = 4,
}

public native class AIbehaviorSimpleParameterizedBehavior extends AIbehaviorParameterizedBehavior {}

public native class AIbehaviorSlotOccupiedConditionDefinition extends AIbehaviorConditionDefinition {
  public native let slot: ref<AIArgumentMapping>;
}

public native class AIbehaviorStackScriptTaskDefinition extends AIbehaviorTaskDefinition {
  public native let script: ref<AIbehaviortaskStackScript>;
}

public enum AIbehaviorStateCompletionStatus {
  ForwardBehaviorStatus = 0,
  Failure = 1,
  Success = 2,
}

public native class AIbehaviorStoryActionConditionDefinition extends AIbehaviorConditionDefinition {
  public native let action: AIbehaviorStoryActionType;
}

public enum AIbehaviorStoryActionType {
  Setup = 0,
  Stop = 1,
}

public native class AIbehaviorStoryEventResolverDefinition extends AIbehaviorEventResolverDefinition {
  public native let storyTier: ref<AIArgumentMapping>;
}

public native class AIbehaviorStoryTierConditionDefinition extends AIbehaviorConditionDefinition {
  public native let tier: gameStoryTier;
  public native let storyTier: ref<AIArgumentMapping>;
}

public native class AIbehaviorSubtreeDefinition extends AIbehaviorNestedTreeDefinition {
  public native let tree: ref<AIbehaviorParameterizedBehavior>;
}

public native class AIbehaviorSucceederNodeDefinition extends AIbehaviorLeafTreeNodeDefinition {}

public native class AIbehaviorSystemVariableExpressionDefinition extends AIbehaviorPassiveExpressionDefinition {
  public native let variable: AIbehaviorSystemVariableExpressionTypes;
}

public enum AIbehaviorSystemVariableExpressionTypes {
  IsFPSLow = 0,
}

public abstract native class AIbehaviorTaskDefinition extends ISerializable {
  public native let ignoreTaskCompletion: Bool;
}

public abstract native class AIbehaviorTaskNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let task: ref<AIbehaviorTaskDefinition>;
}

public native class AIbehaviorTimeoutNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let time: ref<AIArgumentMapping>;
}

public native class AIbehaviorTrackPatrolProgressNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let pathParameters: ref<AIArgumentMapping>;
  public native let patrolProgress: ref<AIArgumentMapping>;
  public native let startFromClosestPoint: ref<AIArgumentMapping>;
  public native let patrolContinuationPolicy: ref<AIArgumentMapping>;
  public native let teleportPositionAfterTimeSkipping: ref<AIArgumentMapping>;
  public native let teleportRotationAfterTimeSkipping: ref<AIArgumentMapping>;
  public native let handleTeleportRequest: ref<AIArgumentMapping>;
  public native let fastForwardAfterTeleport: ref<AIArgumentMapping>;
}

public native class AIbehaviorTreeNodeDebugInfo extends AIbehaviorDebugInfoBase {}

public abstract native class AIbehaviorTreeNodeDefinition extends AIbehaviorBehaviorComponentDefinition {}

public native class AIbehaviorTrueConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorTryGetChasePointTaskDefinition extends AIbehaviorTaskDefinition {
  public native let inPlayerPositionDelay: ref<AIArgumentMapping>;
  public native let inPlayerPositionMaxDistance: ref<AIArgumentMapping>;
  public native let inNearestNavmeshPolyExtent: ref<AIArgumentMapping>;
  public native let outChasePosition: ref<AIArgumentMapping>;
}

public native struct AIbehaviortweakAmmoCountConditionData {}

public native class AIbehaviortweakAttachmentSlotsListener extends AttachmentSlotsListener {}

public native struct AIbehaviortweakCompiledActionConditionData {}

public native class AIbehaviorTweakConditionDefinition extends AIbehaviorConditionDefinition {
  public native let recordId: TweakDBID;
}

public native class AIbehaviortweakConditionStatusEffectListener extends IStatusEffectListener {}

public native struct AIbehaviortweakDetectionListenerWrapper {}

public native struct AIbehaviortweakInstanceRef {}

public native class AIbehaviortweakItemsInInventoryListener extends InventoryListener {}

public native struct AIbehaviortweakNPCCallbacks {}

public native struct AIbehaviortweakPlayerCallbacks {}

public native struct AIbehaviortweakStateCallback {}

public native struct AIbehaviortweakStateConditionData {}

public native struct AIbehaviortweakTargetHelper {}

public native struct AIbehaviortweakTargetLocation {
  public native let object: wref<GameObject>;
  public native let position: Vector3;
  public native let speed: Vector3;
  public native let coverId: AIObjectId;
  public native let hasPosition: Bool;
  public native let hasSpeed: Bool;
}

public native struct AIbehaviortweakTargetStates {}

public native struct AIbehaviorTypeRef {
  public native let isSet: Bool;
  public native let customType: CName;
  public native let enumeratedType: AIArgumentType;
}

public abstract native class AIbehaviorUnaryConditionDefinition extends AIbehaviorConditionDefinition {
  public native let child: ref<AIbehaviorConditionDefinition>;
}

public native class AIbehaviorUnmountImmediatelyNodeDefinition extends AIbehaviorDecoratorNodeDefinition {
  public native let mountData: ref<AIArgumentMapping>;
}

public native class AIbehaviorVehicleExpressionDefinition extends AIbehaviorPassiveExpressionDefinition {}

public native class AIbehaviorWaitConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorWaitFormationPositionConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorWaitingKeepMountedCommandConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorWaitingMountCommandConditionDefinition extends AIbehaviorConditionDefinition {
  public native let requestArgument: ref<AIArgumentMapping>;
  public native let callbackName: CName;
}

public native class AIbehaviorWaitingNotMountedCommandConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorWaitJoinTrafficConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorWaitRefPositionConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorWaitSlotConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorWaitSplineBackwardToFollowConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorWaitSplineToFollowConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorWaitStunnedConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorWaitSummonConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorWaitTargetToFollowConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorWaitTargetToReachConditionDefinition extends AIbehaviorConditionDefinition {}

public native class AIbehaviorWaitWorldPositionConditionDefinition extends AIbehaviorConditionDefinition {}

public native struct AIbehaviorWorkspotListenerWrapper {}

public native class AIBehaviourSpot extends AISmartSpot {
  public native let behaviour: ref<AIResourceReference>;
}

public native class AIBoolArgumentInstancePS extends AIArgumentInstancePS {
  public native persistent let value: Bool;
}

public native class AICArchetypeManager extends AIIArchetypeManager {}

public native class AICNameArgumentInstancePS extends AIArgumentInstancePS {
  public native persistent let value: CName;
}

public native struct AICombatGuardAreaConnectedCommunity {
  public native let communityArea: EntityReference;
  public native let conditions: array<ref<ICombatRestrictMovementAreaCondition>>;
}

public enum AICommandContextsType {
  Default = 0,
  Immediate = 1,
  Movement = 2,
  Workspot = 3,
  Aiming = 4,
}

public native class AICommandQueuePS extends GameComponentPS {
  public native persistent let behaviorArgumentList: array<ref<AIArgumentInstancePS>>;
  public native persistent let aiRole: ref<AIRole>;
}

public native struct AICoverScoringData {}

public abstract native struct AICoverSelectionParameters {}

public abstract native struct AICoverSelectionRuntimeData {}

public abstract native class AICTreeExtendableNodeDefinition extends AICTreeNodeDefinition {
  public native let optionalChild: ref<LibTreeINodeDefinition>;
}

public native struct AICTreeInstance {}

public native class AICTreeLazyNodeDefinition extends AICTreeNodeDefinition {
  public native let tree: ref<LibTreeCTreeResource>;
}

public native class AICTreeNodeActionAnimationCurvePathDefinition extends AICTreeNodeActionDefinition {
  public native let nodeReference: LibTreeDefNodeRef;
  public native let controllersSetupName: LibTreeDefCName;
  public native let useStart: LibTreeDefBool;
  public native let useStop: LibTreeDefBool;
  public native let blendTime: LibTreeDefFloat;
  public native let globalInBlendTime: LibTreeDefFloat;
  public native let globalOutBlendTime: LibTreeDefFloat;
  public native let turnCharacterToMatchVelocity: LibTreeDefBool;
  public native let customStartAnimationName: LibTreeDefCName;
  public native let customMainAnimationName: LibTreeDefCName;
  public native let customStopAnimationName: LibTreeDefCName;
  public native let startSnapToTerrain: LibTreeDefBool;
  public native let mainSnapToTerrain: LibTreeDefBool;
  public native let stopSnapToTerrain: LibTreeDefBool;
  public native let startSnapToTerrainBlendTime: LibTreeDefFloat;
  public native let stopSnapToTerrainBlendTime: LibTreeDefFloat;
}

public native class AICTreeNodeActionAnimationCurvePathDynamicDefinition extends AICTreeNodeActionDefinition {
  public native let targetSplineVarName: CName;
  public native let controlerVarName: CName;
  public native let startAnimVarName: CName;
  public native let stopAnimVarName: CName;
  public native let blendTime: Float;
  public native let globalInBlendTime: Float;
  public native let globalOutBlendTime: Float;
  public native let turnCharacterToMatchVelocity: Bool;
  public native let startSnapToTerrain: Bool;
  public native let mainSnapToTerrain: Bool;
  public native let stopSnapToTerrain: Bool;
  public native let startSnapToTerrainBlendTime: Float;
  public native let stopSnapToTerrainBlendTime: Float;
}

public abstract native class AICTreeNodeActionDefinition extends AICTreeExtendableNodeDefinition {}

public native class AICTreeNodeActionDieDefinition extends AICTreeNodeActionDefinition {}

public native class AICTreeNodeActionDynamicMoveToDefinition extends AICTreeNodeActionDefinition {
  public native let moveType: moveMovementType;
  public native let tolerance: Float;
  public native let target: CName;
  public native let keepDistance: Bool;
}

public native class AICTreeNodeActionReloadWeaponDefinition extends AICTreeNodeActionDefinition {}

public native class AICTreeNodeActionTeleportToNodeDefinition extends AICTreeNodeActionDefinition {
  public native let nodeRef: LibTreeDefNodeRef;
  public native let offset: LibTreeDefVector;
  public native let doNavTest: Bool;
}

public native class AICTreeNodeActionTeleportToPositionDefinition extends AICTreeNodeActionDefinition {
  public native let positionName: CName;
  public native let doNavTest: Bool;
}

public abstract native class AICTreeNodeAtomicDefinition extends AICTreeNodeDefinition {}

public native class AICTreeNodeBoolSharedVarDecoratorDefinition extends AICTreeNodeSingleSharedVarDecoratorDefinition {}

public native class AICTreeNodeBrainDefinition extends AICTreeNodeCompositeDefinition {
  public native let children: array<ref<LibTreeINodeDefinition>>;
  public native let useScoring: Bool;
}

public native class AICTreeNodeChildrenListDefinition extends AICTreeNodeCompositeDefinition {
  public native let children: array<ref<LibTreeINodeDefinition>>;
}

public native class AICTreeNodeCompleteImmediatelyDefinition extends AICTreeNodeAtomicDefinition {
  public native let completeWithSuccess: Bool;
}

public abstract native class AICTreeNodeCompositeDefinition extends AICTreeNodeDefinition {}

public native class AICTreeNodeConditionDefinition extends AICTreeNodeCompositeDefinition {
  public native let expressions: array<ref<LibTreeINodeDefinition>>;
  public native let trueBranch: ref<LibTreeINodeDefinition>;
  public native let falseBranch: ref<LibTreeINodeDefinition>;
  public native let reevaluateOnExecution: Bool;
}

public native class AICTreeNodeDebugLogDefinition extends AICTreeExtendableNodeDefinition {
  public native let text: String;
  public native let timeOnScreen: Float;
  public native let useVisualDebug: Bool;
}

public native class AICTreeNodeDecisionDefinition extends AICTreeNodeCompositeDefinition {
  public native let child: ref<LibTreeINodeDefinition>;
  public native let expressions: array<ref<LibTreeINodeDefinition>>;
  public native let interruption: AIInterruptionSignal;
}

public abstract native class AICTreeNodeDecoratorDefinition extends AICTreeNodeDefinition {
  public native let child: ref<LibTreeINodeDefinition>;
}

public abstract native class AICTreeNodeDefinition extends LibTreeINodeDefinition {}

public native class AICTreeNodeDoNothingDefinition extends AICTreeNodeAtomicDefinition {}

public native class AICTreeNodeDynamicBindDefinition extends AICTreeNodeDynamicDefinition {}

public abstract native class AICTreeNodeDynamicDefinition extends AICTreeNodeDefinition {}

public native class AICTreeNodeFloatSharedVarDecoratorDefinition extends AICTreeNodeSingleSharedVarDecoratorDefinition {}

public native class AICTreeNodeForcedBehaviourDefinition extends AICTreeNodeDynamicDefinition {}

public native class AICTreeNodeFSMDefinition extends AICTreeNodeCompositeDefinition {
  public native let defaultState: Uint16;
  public native let transitions: array<AIFSMTransitionDefinition>;
  public native let onEventTransitions: array<AIFSMEventTransitionsListDefinition>;
  public native let states: array<AIFSMStateDefinition>;
  public native let sharedVars: AISharedVarTableDefinition;
}

public native class AICTreeNodeIncludedTreeDefinition extends AICTreeNodeDefinition {
  public native let tree: LibTreeDefTree;
}

public native class AICTreeNodeInt32SharedVarDecoratorDefinition extends AICTreeNodeSingleSharedVarDecoratorDefinition {}

public native class AICTreeNodeNameSharedVarDecoratorDefinition extends AICTreeNodeSingleSharedVarDecoratorDefinition {}

public native class AICTreeNodeParallelDefinition extends AICTreeNodeChildrenListDefinition {
  public native let forwardChildrenCompleteness: Bool;
}

public native class AICTreeNodePlayerControlledDefinition extends AICTreeNodeAtomicDefinition {}

public native class AICTreeNodePositionSharedVarDecoratorDefinition extends AICTreeNodeSingleSharedVarDecoratorDefinition {}

public native class AICTreeNodeReadWorkspotParamsDefinition extends AICTreeNodeDecoratorDefinition {
  public native let workspotNodeVarName: CName;
  public native let prevWorkspotNodeVarName: CName;
  public native let splineNodeVarName: CName;
  public native let workspotEntryAnimVar: CName;
  public native let animControllerVarName: CName;
  public native let splineStartAnimVarName: CName;
  public native let splineStopAnimVarName: CName;
  public native let moveTargetVarName: CName;
}

public native class AICTreeNodeScriptDecoratorDefinition extends AICTreeExtendableNodeDefinition {
  public native let script: ref<ActionScript>;
  public native let scriptName: CName;
}

public native class AICTreeNodeSequenceDefinition extends AICTreeNodeChildrenListDefinition {}

public native class AICTreeNodeSetSplineMovementTargetDefinition extends AICTreeNodeDecoratorDefinition {
  public native let splineNode: LibTreeSharedVarReferenceName;
  public native let movementTarget: LibTreeSharedVarRegistrationName;
}

public abstract native class AICTreeNodeSharedVarsBaseDecoratorDefinition extends AICTreeNodeDecoratorDefinition {}

public native class AICTreeNodeSharedVarsDecoratorDefinition extends AICTreeNodeSharedVarsBaseDecoratorDefinition {
  public native let sharedVars: AISharedVarTableDefinition;
}

public native class AICTreeNodeSimpleSelectorDefinition extends AICTreeNodeChildrenListDefinition {}

public abstract native class AICTreeNodeSingleSharedVarDecoratorDefinition extends AICTreeNodeSharedVarsBaseDecoratorDefinition {
  public native let sharedVarName: LibTreeSharedVarRegistrationName;
}

public native class AICTreeNodeTargetNodeSharedVarDecoratorDefinition extends AICTreeNodeSingleSharedVarDecoratorDefinition {}

public native class AICTreeNodeTargetSharedVarDecoratorDefinition extends AICTreeNodeSingleSharedVarDecoratorDefinition {}

public native class AICTreeNodeTimeoutDefinition extends AICTreeExtendableNodeDefinition {
  public native let timeout: Float;
}

public native struct AIDebugLogScope {
  public native let index: Uint32;
  public native let id: Uint32;
}

public native class AIDefAI extends AIResourceReference {}

public native class AIDefTreeVariableComparison extends LibTreeDefTreeVariableBoolBase {
  public native let exportAsProperty: Bool;
  public native let referenceVariableId: Uint16;
  public native let referenceVariableName: CName;
  public native let referenceVariableShortName: CName;
  public native let referenceType: CName;
  public native let operator: EComparisonType;
  public native let referenceValue: Variant;
}

public native class AIDirectorSystemSquadAudioMember extends AISquadAudioMemberBase {}

public enum AIEExecutionStatus {
  STATUS_INVALID = 0,
  STATUS_SUCCESS = 1,
  STATUS_FAILURE = 2,
  STATUS_RUNNING = 3,
  STATUS_ABORTED = 4,
}

public enum AIEInterruptionImportance {
  Undefined = 0,
  Casual = 1,
  Rush = 2,
  Immediate = 3,
  ForcedImmediate = 4,
}

public native class AIEnemy extends ISerializable {}

public importonly class AIEntityReuseEvent extends AIEvent {
  public native let destination: GlobalNodeID;
}

public enum AIESharedVarDefinitionType {
  SVInt = 0,
  SVFloat = 1,
  SVBool = 2,
  SVName = 3,
  SVTarget = 4,
  SVPosition = 5,
  SVNodeInstance = 6,
  SVGlobalNodeRef = 7,
}

public enum AIFiniteRoleType {
  Patrol = 0,
}

public native class AIFloatArgumentInstancePS extends AIArgumentInstancePS {
  public native persistent let value: Float;
}

public enum AIForcedBehaviourPriority {
  AboveIdle = 0,
  AboveCombat = 1,
  AboveCriticalState = 2,
  AboveDeath = 3,
}

public native struct AIFSMEventTransitionsListDefinition {
  public native let eventName: CName;
  public native let transitions: AIFSMTransitionListDefinition;
}

public native struct AIFSMStateDefinition {
  public native let onUpdateTransition: AIFSMTransitionListDefinition;
  public native let onCompleteTransition: AIFSMTransitionListDefinition;
  public native let onSuccessTransition: AIFSMTransitionListDefinition;
  public native let onFailureTransition: AIFSMTransitionListDefinition;
  public native let onInterruptionTransition: AIFSMTransitionListDefinition;
  public native let onEventTransitions: AIFSMTransitionListDefinition;
  public native let childNode: ref<AICTreeNodeDefinition>;
}

public native struct AIFSMTransitionDefinition {
  public native let destination: Uint16;
  public native let condition: Uint16;
}

public native struct AIFSMTransitionListDefinition {
  public native let firstTransitionIndex: Uint16;
  public native let transitionsCount: Uint16;
}

public native class AIGameToneDetectorSquadAudioMember extends AISquadAudioMemberBase {}

public native struct AIGuardArea {}

public native struct AIGuardAreaConnectedCommunity {
  public native let communityArea: EntityReference;
  public native let isPrimary: Bool;
}

public native struct AIGuardAreaSavedData {
  public native let puppetId: EntityID;
  public native let nodeRef: NodeRef;
}

public native class AIGuardAreasSavedState extends ISerializable {
  public native let data: array<AIGuardAreaSavedData>;
  public native let cleared: array<EntityID>;
}

public native class AIHumanComponentPS extends AICommandQueuePS {
  public native persistent let spotUsageToken: AISpotUsageToken;
}

public abstract native class AIIArchetypeManager extends IGameSystem {}

public abstract native class AIICoverSelectionSystem extends IGameSystem {}

public abstract native class AIIEntityStubHandlerProviderSystem extends IGameSystem {}

public abstract native class AIIInformationSpreadSystem extends IGameSystem {}

public native class AIInt32ArgumentInstancePS extends AIArgumentInstancePS {
  public native persistent let value: Int32;
}

public native class AIInt64ArgumentInstancePS extends AIArgumentInstancePS {
  public native persistent let value: Int64;
}

public native class AIInterruptionHandlerAllowDefinition extends AIInterruptionHandlerDefinition {}

public native class AIInterruptionHandlerBehaviorDefinition extends AIInterruptionHandlerDefinition {
  public native let ai: ref<LibTreeINodeDefinition>;
  public native let parallelActivation: Bool;
  public native let parallelExecution: Bool;
  public native let blockInterruption: Bool;
}

public abstract native class AIInterruptionHandlerDefinition extends LibTreeINodeDefinition {
  public native let signal: AIInterruptionSignal;
  public native let supportLessImportantSignals: Bool;
}

public native class AIInterruptionHandlerDenyDefinition extends AIInterruptionHandlerDefinition {}

public native struct AIInterruptionSignal {
  public native let importance: AIEInterruptionImportance;
  public native let signal: CName;
}

public abstract native struct AIIObjectSelectionDebugProxy {}

public native class AIISerializableArgumentInstancePS extends AIArgumentInstancePS {
  public native persistent let value: ref<ISerializable>;
}

public abstract native class AIISquadManager extends IGameSystem {}

public abstract native class AIISystem extends IGameSystem {}

public abstract native struct AIITarget {}

public abstract native class AIITrafficMovementSystem extends IGameSystem {}

public abstract native class AIIVehicleCoversSystem extends IGameSystem {}

public enum AIIWorkspotManagerSpotUsageState {
  Reserved = 0,
  Occupied = 1,
  None = 2,
}

public native class AIMixingOutputSystemSquadAudioMember extends AISquadAudioMemberBase {}

public native class AIMusicSystemSquadAudioMember extends AISquadAudioMemberBase {}

public native struct AIObjectId {
  public native let value: Uint64;
}

public abstract native class AIObjectSelectionManagerInterface extends IGameSystem {}

public native class AIParametrizedResourceReference extends AIResourceReference {
  public native let overrides: LibTreeParametersForwarder;
}

public native class AIPlayMountedSlotWorkspotCommand extends AICommand {
  public native persistent let mountData: gameMountDescriptor;
}

public native struct AIPosition {
  public native let position: Vector3;
}

public native class AIPuppetBlackboardListener extends ISerializable {}

public native class AIResource extends LibTreeCTreeResource {
  public native let root: ref<AICTreeNodeDefinition>;
}

public native class AIResourceReference extends LibTreeCTreeReference {}

public native class AIRunAwayFromPlayerCommand extends AICommand {}

public native class AIScriptEventResolver extends IScriptable {}

public native class AIScriptsTargetTrackingListenerWrapper extends AIITargetTrackingListener {}

public native struct AISharedVarDefinition {
  public native let type: AIESharedVarDefinitionType;
  public native let name: LibTreeSharedVarRegistrationName;
}

public native struct AISharedVarTableDefinition {
  public native let table: array<AISharedVarDefinition>;
}

public abstract native class AISmartSpot extends AISpot {}

public enum AISocketsForRig {
  Undefined = 0,
  ManAverage = 1,
  ManBig = 2,
  ManFat = 3,
  WomanAverage = 4,
  WomanBig = 5,
  ChildMale = 6,
}

public abstract native class AISpot extends ISerializable {}

public abstract native struct AISpotInstance {}

public native struct AISpotPersistentData {
  public native let worldPosition: WorldPosition;
  public native let globalNodeId: GlobalNodeID;
  public native let yaw: Float;
  public native let isEnabled: Bool;
}

public native struct AISpotUsageToken {
  public native persistent let usedSpotId: GlobalNodeID;
  public native persistent let spotUserId: EntityID;
}

public native class AISquadAudioMemberBase extends AISquadMemberBase {}

public abstract native class AISquadMemberBase extends ISerializable {}

public native class AISquadNPCMember extends AISquadMemberBase {}

public native class AISystemImpl extends AIISystem {}

public native class AITargetTrackerComponentPS extends GameComponentPS {
  public native persistent let threatsSaveData: array<AIThreatSaveData>;
}

public abstract native class AITargetTrackerManagerInterface extends IGameSystem {}

public native class AIThreatBeliefPositionProvider extends ThreatPositionProvider {}

public native class AIThreatLastKnownPositionProvider extends ThreatPositionProvider {}

public native struct AIThreatSaveData {
  public native persistent let entityId: EntityID;
  public native persistent let persistenceSourceBitMask: Uint32;
}

public native class AIThreatSharedBeliefPositionProvider extends ThreatPositionProvider {}

public native class AIThreatSharedLastKnownPositionProvider extends ThreatPositionProvider {}

public native class AITrafficExternalWorkspotDefinition extends worldTrafficSpotDefinition {
  public native let nearestPointEntry: Bool;
  public native let globalWorkspotNodeRef: NodeRef;
}

public native class AITrafficMovementSystem extends AIITrafficMovementSystem {}

public native class AITrafficWorkspotCompiled extends worldTrafficSpotCompiled {}

public native class AITrafficWorkspotDefinition extends worldTrafficSpotDefinition {
  public native let workspotResource: ResourceRef; // rRef<workWorkspotResource>
}

public native struct AITreeArgumentsDefinition {
  public native let args: array<ref<AIArgumentDefinition>>;
}

public native class AITreeNodeDeathDefinition extends AICTreeNodeActionDefinition {}

public native class AITreeNodeInterruptionDecoratorDefinition extends AICTreeNodeDecoratorDefinition {
  public native let interruptions: array<ref<AIInterruptionHandlerDefinition>>;
}

public native class AITreeNodeRepeatDefinition extends AICTreeNodeDecoratorDefinition {
  public native let limit: LibTreeDefInt32;
}

public native class AIUint64ArgumentInstancePS extends AIArgumentInstancePS {
  public native persistent let value: Uint64;
}

public native class AIVehicleCoversComponent extends IComponent {}

public native class AIVehicleCoversSystem extends AIIVehicleCoversSystem {}

public native class AmbientOverrideAreaSettings extends IAreaSettings {
  public native let color: [CurveDataHDRColor; 6];
}

public native struct animActionAnimDatabase_AnimationData {
  public native let animationName: CName;
  public native let fallbackAnimationName: CName;
  public native let inTransitionDuration: Float;
  public native let inCanRequestInertialization: Bool;
  public native let outTransitionDuration: Float;
  public native let outCanRequestInertialization: Bool;
  public native let streamingContext: CName;
}

public native struct animActionAnimDatabase_DatabaseRow {
  public native let animFeatureName: CName;
  public native let state: Int32;
  public native let animVariation: Int32;
  public native let animationData: animActionAnimDatabase_AnimationData;
}

public native class animActionAnimDatabase extends CResource {
  public native let rows: array<animActionAnimDatabase_DatabaseRow>;
}

public native struct animAdditionalFloatTrackContainer {
  public native let entries: array<animAdditionalFloatTrackEntry>;
  public native let overwriteExistingValues: Bool;
}

@neverRef()
public native class animAdditionalFloatTrackEntry extends ISerializable {
  public native let name: CName;
  public native let trackInfo: animFloatTrackInfo;
  public native let values: CurveDataFloat;
}

public native struct animAdditionalTransformContainer {
  public native let entries: array<ref<animAdditionalTransformEntry>>;
}

public native class animAdditionalTransformEntry extends ISerializable {
  public native let transformInfo: animTransformInfo;
  public native let value: QsTransform;
}

public native class animAnimation extends ISerializable {
  public native let tags: redTagList;
  public native let name: CName;
  public native let duration: Float;
  public native let animationType: animAnimationType;
  public native let animBuffer: ref<animIAnimationBuffer>;
  public native let additionalTransforms: animAdditionalTransformContainer;
  public native let additionalTracks: animAdditionalFloatTrackContainer;
  public native let motionExtraction: ref<animIMotionExtraction>;
  public native let frameClamping: Bool;
  public native let frameClampingStartFrame: Int8;
  public native let frameClampingEndFrame: Int8;
}

public native class animAnimationBufferCompressed extends animIAnimationBuffer {
  public native let duration: Float;
  public native let numFrames: Uint32;
  public native let numExtraJoints: Uint8;
  public native let numExtraTracks: Uint8;
  public native let numJoints: Uint16;
  public native let numTracks: Uint16;
  public native let numAnimKeys: Uint32;
  public native let numAnimKeysRaw: Uint32;
  public native let numConstAnimKeys: Uint32;
  public native let numTrackKeys: Uint32;
  public native let numConstTrackKeys: Uint32;
  public native let isScaleConstant: Bool;
  public native let hasRawRotations: Bool;
  public native let fallbackFrameIndices: array<Uint16>;
  public native let dataAddress: animAnimDataAddress;
  public native let extraDataNames: array<CName>;
}

public native class animAnimationBufferSimd extends animIAnimationBuffer {
  public native let duration: Float;
  public native let numFrames: Uint32;
  public native let numExtraJoints: Uint8;
  public native let numExtraTracks: Uint8;
  public native let numJoints: Uint16;
  public native let numTracks: Uint16;
  public native let numTranslationsToCopy: Uint16;
  public native let numTranslationsToEvalAlignedToSimd: Uint16;
  public native let quantizationBits: Uint16;
  public native let isScaleConstant: Bool;
  public native let isTrackConstant: Bool;
  public native let dataAddress: animAnimDataAddress;
  public native let fallbackFrameIndices: array<Uint16>;
  public native let extraDataNames: array<CName>;
}

public native struct animAnimationImportInfo {
  public native let AnimationType: animAnimationType;
  public native let BufferType: animcompressionBufferTypePreset;
  public native let CompressionPreset: animcompressionQualityPreset;
  public native let FrameratePreset: animcompressionFrameratePreset;
  public native let MotionExtractionCompression: animEMotionExtractionCompressionType;
}

public native struct animAnimationSetup {
  public native let cinematics: animAnimSetCollection;
  public native let gameplay: animAnimSetCollection;
  public native let finalAnimSetCollection: animAnimSetCollection;
}

public enum animAnimationType {
  Normal = 0,
  AdditiveFromRefPose = 1,
  AdditiveFromFirstFrame = 2,
  Additive = 3,
  AdditiveWithoutFirstFrame = 4,
}

public native struct animAnimDataAddress {
  public native let unkIndex: Uint32;
  public native let fsetInBytes: Uint32;
  public native let zeInBytes: Uint32;
}

public native struct animAnimDatabaseCollection {
  public native let animDatabases: array<animAnimDatabaseCollectionEntry>;
}

public native struct animAnimDatabaseCollectionEntry {
  public native let name: CName;
  public native let animDatabase: ResourceRef; // rRef<C2dArray>
  public native let overrideAnimDatabase: ResourceRef; // rRef<animGenericAnimDatabase>
}

public native struct animAnimDataChunk {}

public native class animAnimEvent_Effect extends animAnimEvent {
  public native let effectName: CName;
}

public native class animAnimEvent_EffectDuration extends animAnimEvent {
  public native let effectName: CName;
  public native let sequenceShift: Uint32;
  public native let breakAllLoopsOnStop: Bool;
}

public native class animAnimEvent_FoleyAction extends animAnimEvent {
  public native let actionName: CName;
}

public native class animAnimEvent_FootIK extends animAnimEvent {
  public native let leg: animLeg;
}

public native class animAnimEvent_FootPhase extends animAnimEvent {
  public native let phase: animEFootPhase;
}

public native class animAnimEvent_FootPlant extends animAnimEvent {
  public native let side: animEventSide;
  public native let customEvent: CName;
}

public native class animAnimEvent_ForceRagdoll extends animAnimEvent {}

public native class animAnimEvent_GameplayVo extends animAnimEvent {
  public native let voContext: CName;
  public native let isQuest: Bool;
}

public native class animAnimEvent_ItemEffect extends animAnimEvent {
  public native let effectName: CName;
}

public native class animAnimEvent_ItemEffectDuration extends animAnimEvent {
  public native let effectName: CName;
  public native let sequenceShift: Uint32;
  public native let breakAllLoopsOnStop: Bool;
}

public native class animAnimEvent_KeyPose extends animAnimEvent {}

public native class animAnimEvent_Phase extends animAnimEvent {}

public native class animAnimEvent_SafeCut extends animAnimEvent {}

public native class animAnimEvent_SceneItem extends animAnimEvent {
  public native let boneName: CName;
}

public native class animAnimEvent_Simple extends animAnimEvent {}

public native class animAnimEvent_SimpleDuration extends animAnimEvent {}

public native class animAnimEvent_Slide extends animAnimEvent {}

public native class animAnimEvent_Sound extends animAnimEvent {
  public native let switches: array<audioAudSwitch>;
  public native let params: array<audioAudParameter>;
  public native let dynamicParams: array<CName>;
  public native let metadataContext: CName;
  public native let onlyPlayOn: CName;
  public native let dontPlayOn: CName;
  public native let playerGenderAlt: animAnimEventGenderAlt;
}

public native class animAnimEvent_SoundFromEmitter extends animAnimEvent {
  public native let emitterName: CName;
}

public native class animAnimEvent_TrajectoryAdjustment extends animAnimEvent {}

public native class animAnimEvent_Valued extends animAnimEvent {
  public native let value: Float;
}

public native class animAnimEvent_WorkspotFastExitCutoff extends animAnimEvent {}

public native class animAnimEvent_WorkspotItem extends animAnimEvent {
  public native let actions: array<ref<workIWorkspotItemAction>>;
}

public native class animAnimEvent_WorkspotPlayFacialAnim extends animAnimEvent {
  public native let facialAnimName: CName;
}

public abstract native class animAnimEvent extends ISerializable {
  public native let startFrame: Uint32;
  public native let durationInFrames: Uint32;
  public native let eventName: CName;
}

public enum animAnimEventGenderAlt {
  None = 0,
  Female = 1,
  Male = 2,
}

public native struct animAnimFallbackFrameDesc {
  public native let mPositions: Uint16;
  public native let mRotations: Uint16;
  public native let mFloatTracks: Uint16;
}

public native class animAnimFeature_AIActionAnimation extends AnimFeature_AIAction {
  public native let animFeatureName: CName;
}

public native class animAnimFeature_Crowd extends AnimFeature {
  public native let stopType: Int32;
  public native let speedType: Int32;
  public native let speedOverrideType: Int32;
  public native let bumpDirection: Int32;
  public native let threatSource: Int32;
  public native let locomotionState: Int32;
  public native let bumpSourceLocation: Int32;
  public native let lookAtAngle: Float;
  public native let fearStage: Int32;
  public native let startType: Int32;
  public native let startDirectionAngle: Float;
  public native let animTime: Float;
  public native let isBlocked: Bool;
  public native let bumpType: Int32;
  public native let fleeType: Int32;
  public native let randomVariation: Float;
  public native let animScale: Float;
  public native let slopeRatio: Float;
  public native let distanceToPlayer2D: Float;
  public native let angleToPlayer: Float;
}

public native class animAnimFeature_CrowdLocomotion extends AnimFeature {
  public native let speed: Float;
  public native let slopeAngle: Float;
  public native let isCrowd: Bool;
}

public native class animAnimFeature_DangleExternalInput extends AnimFeature {
  public native let fictitiousAccelerationWs: Vector4;
}

public native class animAnimFeature_EditorOnlyPredictiveLookAt extends AnimFeature {
  public native let isEnabled: Bool;
  public native let target: Vector4;
  public native let suppress: Float;
  public native let mode: Int32;
}

public native class animAnimFeature_Interaction extends AnimFeature {
  public native let interactionDuration: Float;
  public native let interactionStage: Int32;
}

public native class animAnimFeature_NPCExploration extends AnimFeature {
  public native let explorationType: Int32;
  public native let state: Int32;
  public native let movementType: Int32;
  public native let isEvenLoop: Bool;
  public native let playbackTime: Float;
}

public native class animAnimFeature_SmartObject extends AnimFeature {
  public native let state: Int32;
  public native let privateAnimationName: CName;
}

public native class animAnimFeature_VehiclePassengerAnimSetup extends AnimFeature {
  public native let enableAdditiveAnim: Bool;
  public native let additiveScale: Float;
}

public native class animAnimFeature_WeaponUser extends AnimFeature {
  public native let ikLeftHandLocalPosition: Vector4;
  public native let ikRightHandLocalPosition: Vector4;
}

public native struct animAnimFeatureEvent {}

public native class animAnimFeatureUpdateWorkspot extends AnimFeature {
  public native let animName: CName;
  public native let recordID: Int32;
  public native let updateCounter: Int32;
  public native let boolsAsFlags: Int32;
  public native let animBlendTime: Float;
  public native let forcedBlendIn: Float;
  public native let forceAnimTime: Float;
  public native let timeScale: Float;
  public native let animationStartTime: Double;
  public native let isPaused: Bool;
  public native let isLooped: Bool;
  public native let isExitAnim: Bool;
  public native let enableMotion: Bool;
  public native let isActive: Bool;
  public native let isAnimValid: Bool;
  public native let slotNameHash: Int32;
  public native let facialKeyWeight: Float;
  public native let facialIdleAnimation: CName;
  public native let facialIdleKeyAnimation: CName;
  public native let globalBlendDuration: Float;
  public native let globalBlendIn: Bool;
}

public native class animAnimGraph extends CResource {
  public native let rootNode: ref<animAnimNode_Root>;
  public native let variables: ref<animAnimVariableContainer>;
  public native let animFeatures: array<animAnimFeatureEntry>;
  public native let timeDeltaMultiplier: Float;
  public native let isPaused: Bool;
  public native let oneFrameToggle: Bool;
  public native let hasMixerSlot: Bool;
  public native let additionalAnimDatabases: array<animAnimDatabaseCollectionEntry>;
  public native let nodesToInit: array<ref<animAnimNode_Base>>;
  public native let useLunaticMode: Bool;
  public native let useAnimCommands: Bool;
  public native let useAnimCommandsForCrowd: Bool;
  public native let useAnimStaticCommands: Bool;
  public native let staticCommandsRig: ResourceRef; // rRef<animRig>
  public native let hackAlwaysSample: Bool;
}

public native class animAnimGraphDebugState extends ISerializable {
  public native let nodes: array<animAnimNodeDebugState>;
}

public native class animAnimGraphExternalEvent extends ISerializable {
  public native let eventName: CName;
}

public native struct animAnimMathExpressionFloatSocket {
  public native let link: animFloatLink;
  public native let expressionVarId: Uint16;
  public native let inputFloatTrack: animNamedTrackIndex;
}

public native struct animAnimMathExpressionQuaternionSocket {
  public native let link: animQuaternionLink;
  public native let expressionVarId: Uint16;
}

public native struct animAnimMathExpressionVectorSocket {
  public native let link: animVectorLink;
  public native let expressionVarId: Uint16;
}

public native struct animAnimMultiBoolToFloatEntry {
  public native let group: CName;
  public native let name: CName;
}

public native class animAnimNode_AddIkRequest extends animAnimNode_OnePoseInput {
  public native let ikChain: CName;
  public native let targetBone: animTransformIndex;
  public native let positionOffset: Vector3;
  public native let rotationOffset: Quaternion;
  public native let poleVector: animPoleVectorDetails;
  public native let weightPosition: Float;
  public native let weightRotation: Float;
  public native let blendTimeIn: Float;
  public native let blendTimeOut: Float;
  public native let priority: Int32;
}

public native class animAnimNode_AdditionalFloatTrack extends animAnimNode_Base {
  public native let poseInputNode: animPoseLink;
  public native let additionalTracks: animAdditionalFloatTrackContainer;
}

public native class animAnimNode_AdditionalTransform extends animAnimNode_OnePoseInput {
  public native let additionalTransforms: animAdditionalTransformContainer;
}

public native class animAnimNode_AddSnapToTerrainIkRequest extends animAnimNode_OnePoseInput {
  public native let animDeltaZ: animFloatLink;
  public native let leftFootRequest: animSnapToTerrainIkRequest;
  public native let rightFootRequest: animSnapToTerrainIkRequest;
  public native let hipsRequest: animHipsIkRequest;
}

public native class animAnimNode_AimConstraint_ObjectRotationUp extends animAnimNode_OnePoseInput {
  public native let targetTransform: animTransformIndex;
  public native let upTransform: animTransformIndex;
  public native let upTransformVector: Vector3;
  public native let transformIndex: animTransformIndex;
  public native let forwardAxisLS: Vector3;
  public native let upAxisLS: Vector3;
  public native let weightMode: animConstraintWeightMode;
  public native let weight: Float;
  public native let weightFloatTrack: animNamedTrackIndex;
}

public native class animAnimNode_AimConstraint_ObjectUp extends animAnimNode_OnePoseInput {
  public native let targetTransform: animTransformIndex;
  public native let upTransform: animTransformIndex;
  public native let transformIndex: animTransformIndex;
  public native let forwardAxisLS: Vector3;
  public native let upAxisLS: Vector3;
  public native let weightMode: animConstraintWeightMode;
  public native let weight: Float;
  public native let weightFloatTrack: animNamedTrackIndex;
}

public native class animAnimNode_AimConstraint extends animAnimNode_OnePoseInput {
  public native let areSourceChannelsResaved: Bool;
  public native let targetTransforms: array<ref<animAnimNodeSourceChannel_WeightedVector>>;
  public native let targetTransform: animTransformIndex;
  public native let upTransform: ref<animIAnimNodeSourceChannel_Vector>;
  public native let transformIndex: animTransformIndex;
  public native let forwardAxisLS: Vector3;
  public native let upAxisLS: Vector3;
  public native let weightMode: animConstraintWeightMode;
  public native let weight: Float;
  public native let weightFloatTrack: animNamedTrackIndex;
}

public native class animAnimNode_AnimDatabase extends animAnimNode_SkPhaseWithDurationAnim {
  public native let animDataBase: animAnimDatabaseCollectionEntry;
  public native let inputLinks: array<animIntLink>;
}

public native class animAnimNode_AnimSetTagValue extends animAnimNode_FloatValue {
  public native let tags: redTagList;
}

public native class animAnimNode_AnimSlot extends animAnimNode_Base {
  public native let inputLink: animPoseLink;
}

public native class animAnimNode_ApplyCorrectivePoseRBF extends animAnimNode_OnePoseInput {
  public native let rbfCoefficient: Float;
  public native let rbfPowValue: Float;
  public native let correctiveFrame: Float;
  public native let correctives: array<animCorrectivePoseEntry>;
}

public abstract native class animAnimNode_Base extends ISerializable {
  public native let id: Uint32;
}

public native class animAnimNode_BaseSwitch extends animAnimNode_Base {
  public native let blendTime: Float;
  public native let timeWarpingEnabled: Bool;
  public native let syncMethod: ref<animISyncMethod>;
  public native let inputNodes: array<animPoseLink>;
  public native let canRequestInertialization: Bool;
}

public native class animAnimNode_Blend2 extends animAnimNode_Base {
  public native let minInputValue: Float;
  public native let maxInputValue: Float;
  public native let timeWarpingEnabled: Bool;
  public native let syncMethod: ref<animISyncMethod>;
  public native let firstInputNode: animPoseLink;
  public native let secondInputNode: animPoseLink;
  public native let weightNode: animFloatLink;
}

public native class animAnimNode_BlendAdditive extends animAnimNode_Base {
  public native let biasValue: Float;
  public native let scaleValue: Float;
  public native let additiveType: animEAnimGraphAdditiveType;
  public native let timeWarpingEnabled: Bool;
  public native let blendTracks: animEBlendTracksMode;
  public native let syncMethod: ref<animISyncMethod>;
  public native let inputNode: animPoseLink;
  public native let addedInputNode: animPoseLink;
  public native let weightNode: animFloatLink;
  public native let postProcess: ref<animIAnimNode_PostProcess>;
  public native let weightPreviousFrameFloatTrack: animNamedTrackIndex;
  public native let weightPreviousFrameFloatTrackDefaultValue: Float;
  public native let maskName: CName;
}

public native class animAnimNode_BlendByMaskDynamic extends animAnimNode_Base {
  public native let base: animPoseLink;
  public native let blend: animPoseLink;
  public native let mask: animIntLink;
  public native let weight: animFloatLink;
  public native let masks: array<CName>;
  public native let syncMethod: ref<animISyncMethod>;
}

public native class animAnimNode_BlendFromPose extends animAnimNode_OnePoseInput {
  public native let blendTime: Float;
  public native let blendType: animEBlendTypeLBC;
  public native let customBlendCurve: CurveDataFloat;
  public native let mode: animEBlendFromPoseMode;
  public native let requestedByTag: CName;
}

public native class animAnimNode_BlendMultiple extends animAnimNode_Base {
  public native let inputValues: array<Float>;
  public native let sortedInputValues: array<Float>;
  public native let minWeight: Float;
  public native let maxWeight: Float;
  public native let radialBlending: Bool;
  public native let timeWarpingEnabled: Bool;
  public native let syncMethod: ref<animISyncMethod>;
  public native let motionProvider: ref<animIMotionTableProvider>;
  public native let weightNode: animFloatLink;
  public native let inputNodes: array<animPoseLink>;
}

public native class animAnimNode_BlendOverride extends animAnimNode_Base {
  public native let inputNode: animPoseLink;
  public native let overrideInputNode: animPoseLink;
  public native let weightNode: animFloatLink;
  public native let bones: array<animOverrideBlendBoneInfo>;
  public native let blendAllTracks: Bool;
  public native let blendTrackMode: animEBlendTracksMode;
  public native let tracks: array<animOverrideBlendTrackInfo>;
  public native let getDeltaMotionFromOverride: Bool;
  public native let timeWarpingEnabled: Bool;
  public native let syncMethod: ref<animISyncMethod>;
  public native let blendMethod: ref<animIPoseBlendMethod>;
  public native let postProcess: ref<animIAnimNode_PostProcess>;
}

public native struct animAnimNode_BlendSpace_InternalsBlendSpace {
  public native let spaceDimension: Uint32;
  public native let coordinatesDescriptions: array<animAnimNode_BlendSpace_InternalsBlendSpaceCoordinateDescription>;
  public native let spacePoints: array<animAnimNode_BlendSpace_InternalsBlendSpacePoint>;
  public native let boundaryPointsCount: Uint32;
  public native let fireAnimEndEvent: Bool;
  public native let animEndEventName: CName;
  public native let isLooped: Bool;
  public native let needsRuntimeTriangulation: Bool;
  public native let wasRuntimeTriangulationResaveDone: Bool;
  public native let cachedSpacePoints_coordinates: array<Float>;
  public native let cachedSpaceSimplexes_pointsIndices: array<Uint32>;
  public native let cachedSamplesForGridPoints_simplexIndex: array<Int32>;
  public native let cachedSamplesForGridPoints_weightsForPoints: array<Float>;
}

public native struct animAnimNode_BlendSpace_InternalsBlendSpaceCoordinateDescription {
  public native let name: CName;
  public native let minValue: Float;
  public native let maxValue: Float;
  public native let gridDivisionsCount: Uint32;
}

public native struct animAnimNode_BlendSpace_InternalsBlendSpacePoint {
  public native let animationName: CName;
  public native let useFixedCoordinates: Bool;
  public native let fixedCoordinates: array<Float>;
  public native let useStaticPose: Bool;
  public native let staticPoseTime: Float;
  public native let staticPoseProgress: Float;
}

public native class animAnimNode_BlendSpace extends animAnimNode_Base {
  public native let inputLinks: array<animFloatLink>;
  public native let blendSpace: animAnimNode_BlendSpace_InternalsBlendSpace;
  public native let progressLink: animFloatLink;
  public native let fireAnimEndEvent: Bool;
  public native let animEndEventName: CName;
  public native let isLooped: Bool;
}

public native class animAnimNode_BoolConstant extends animAnimNode_BoolValue {
  public native let value: Bool;
}

public native class animAnimNode_BoolInput extends animAnimNode_BoolValue {
  public native let group: CName;
  public native let name: CName;
}

public native class animAnimNode_BoolJoin extends animAnimNode_BoolValue {
  public native let input: animBoolLink;
}

public native class animAnimNode_BoolLatch extends animAnimNode_BoolValue {
  public native let input: animBoolLink;
}

public native class animAnimNode_BoolToFloatConverter extends animAnimNode_FloatValue {
  public native let inputNode: animBoolLink;
}

public abstract native class animAnimNode_BoolValue extends animAnimNode_Base {}

public native class animAnimNode_BoolVariable extends animAnimNode_BoolValue {
  public native let variableName: CName;
}

public native class animAnimNode_ConditionalSegmentBegin extends animAnimNode_OnePoseInput {
  public native let condition: animConditionalSegmentCondition;
}

public native class animAnimNode_ConditionalSegmentEnd extends animAnimNode_OnePoseInput {}

public native class animAnimNode_ConeLimit extends animAnimNode_OnePoseInput {
  public native let coneTransform: animTransformIndex;
  public native let constrainedTransform: animTransformIndex;
  public native let coneAxisLs: Vector3;
  public native let coneAxisNormalizedLs: Vector3;
  public native let coneOffsetMs: Vector3;
  public native let coneOffsetMsLink: animVectorLink;
  public native let marginEaseOutCurve: CurveDataFloat;
  public native let limit1: Float;
  public native let limit1Link: animFloatLink;
  public native let limit1FloatTrack: animNamedTrackIndex;
  public native let paraboloidRadius1: Float;
  public native let limit2: Float;
  public native let limit2Link: animFloatLink;
  public native let limit2FloatTrack: animNamedTrackIndex;
  public native let paraboloidRadius2: Float;
  public native let limit3: Float;
  public native let limit3Link: animFloatLink;
  public native let limit3FloatTrack: animNamedTrackIndex;
  public native let paraboloidRadius3: Float;
  public native let limit4: Float;
  public native let limit4Link: animFloatLink;
  public native let limit4FloatTrack: animNamedTrackIndex;
  public native let paraboloidRadius4: Float;
  public native let coneLimitReached: animNamedTrackIndex;
  public native let debug: Bool;
  public native let colorfulCone: Bool;
  public native let applyDebugConeScalling: Bool;
}

public abstract native class animAnimNode_Container extends animAnimNode_Base {
  public native let nodes: array<ref<animAnimNode_Base>>;
}

public native class animAnimNode_CoordinateFromVector extends animAnimNode_FloatValue {
  public native let vectorCoodrinateType: animVectorCoordinateType;
  public native let input: animVectorLink;
}

public native class animAnimNode_CriticalSpringDamp extends animAnimNode_FloatValue {
  public native let smoothTime: Float;
  public native let useRange: Bool;
  public native let rangeMin: Float;
  public native let rangeMax: Float;
  public native let useRawTime: Bool;
  public native let inputNode: animFloatLink;
}

public native class animAnimNode_CurveFloatValue extends animAnimNode_FloatValue {
  public native let curveData: CurveDataFloat;
  public native let argument: animFloatLink;
}

public native class animAnimNode_CurvePathSlot extends animAnimNode_Base {
  public native let input: animPoseLink;
}

public native class animAnimNode_CurveVectorValue extends animAnimNode_VectorValue {
  public native let curveData: CurveDataVector4;
  public native let argument: animFloatLink;
}

public native class animAnimNode_DampFloat extends animAnimNode_FloatValue {
  public native let defaultIncreaseSpeed: Float;
  public native let defaultDecreaseSpeed: Float;
  public native let startFromDefaultValue: Bool;
  public native let defaultInitialValue: Float;
  public native let wrapAroundRange: Bool;
  public native let rangeMin: Float;
  public native let rangeMax: Float;
  public native let inputNode: animFloatLink;
  public native let increaseSpeedNode: animFloatLink;
  public native let decreaseSpeedNode: animFloatLink;
}

public native class animAnimNode_DampQuaternion extends animAnimNode_QuaternionValue {
  public native let defaultRotationSpeed: Float;
  public native let defaultInitialValue: EulerAngles;
  public native let inputNode: animQuaternionLink;
  public native let initialValueNode: animQuaternionLink;
  public native let rotationSpeedNode: animFloatLink;
}

public native class animAnimNode_DampVector extends animAnimNode_VectorValue {
  public native let defaultIncreaseSpeed: Vector4;
  public native let defaultDecreaseSpeed: Vector4;
  public native let startFromDefaultValue: Bool;
  public native let defaultInitialValue: Vector4;
  public native let inputNode: animVectorLink;
  public native let increaseSpeedNode: animVectorLink;
  public native let decreaseSpeedNode: animVectorLink;
}

public native class animAnimNode_Dangle extends animAnimNode_OnePoseInput {
  public native let dangleConstraint: ref<animDangleConstraint_Simulation>;
}

public native class animAnimNode_DirectConnConstraint extends animAnimNode_OnePoseInput {
  public native let sourceTransform: ref<animIAnimNodeSourceChannel_QsTransform>;
  public native let isSourceTransformResaved: Bool;
  public native let sourceTransformIndex: animTransformIndex;
  public native let transformIndex: animTransformIndex;
  public native let posX: Bool;
  public native let posY: Bool;
  public native let posZ: Bool;
  public native let rotX: Bool;
  public native let rotY: Bool;
  public native let rotZ: Bool;
  public native let scaleX: Bool;
  public native let scaleY: Bool;
  public native let scaleZ: Bool;
  public native let weight: Float;
  public native let weightNode: animFloatLink;
}

public native class animAnimNode_DirectionToEuler extends animAnimNode_FloatValue {
  public native let inputNode: animVectorLink;
  public native let initialForwardVector: Vector4;
  public native let conversionType: animEDirectionToEuler;
}

public native class animAnimNode_DisableLunaticMode extends animAnimNode_OnePoseInput {}

public native class animAnimNode_DisableSleepMode extends animAnimNode_OnePoseInput {
  public native let forceUpdate: Bool;
}

public native class animAnimNode_Drag extends animAnimNode_OnePoseInput {
  public native let sourceBone: animTransformIndex;
  public native let outTargetBone: animTransformIndex;
  public native let simulationFps: Float;
  public native let sourceSpeedMultiplier: Float;
  public native let hasOvershoot: Bool;
  public native let overshootDuration: Float;
  public native let overshootDetectionMinSpeed: Float;
  public native let overshootDetectionMaxSpeed: Float;
  public native let useSteps: Bool;
  public native let stepsTargetSpeedMultiplier: Float;
  public native let timeBetweenSteps: Float;
  public native let timeInStep: Float;
}

public native class animAnimNode_EnumSwitch extends animAnimNode_InputSwitch {
  public native let enumName: CName;
}

public native class animAnimNode_Event extends animAnimNode_FloatValue {
  public native let eventName: CName;
  public native let defaultValue: Float;
  public native let eventValue: Float;
}

public native class animAnimNode_EventValue extends animAnimNode_FloatValue {
  public native let eventName: CName;
  public native let defaultValue: Float;
}

public native class animAnimNode_ExplorationAdjuster extends animAnimNode_MotionAdjuster {
  public native let targetPosition2: animVectorLink;
  public native let targetDirection2: animVectorLink;
  public native let totalTimeToAdjust2: animFloatLink;
  public native let targetPosition3: animVectorLink;
  public native let targetDirection3: animVectorLink;
  public native let totalTimeToAdjust3: animFloatLink;
}

public native class animAnimNode_EyesLookAt extends animAnimNode_OnePoseInput {
  public native let targetALink: animVectorLink;
  public native let weightALink: animFloatLink;
  public native let targetBLink: animVectorLink;
  public native let weightBLink: animFloatLink;
  public native let transitionWeightLink: animFloatLink;
  public native let leftEye: animTransformIndex;
  public native let rightEye: animTransformIndex;
  public native let head: animTransformIndex;
  public native let forwardDirection: animAxis;
}

public native class animAnimNode_EyesReset extends animAnimNode_OnePoseInput {}

public native class animAnimNode_EyesTracksLookAt extends animAnimNode_OnePoseInput {
  public native let eyeTransform: animTransformIndex;
  public native let leftTrack: animNamedTrackIndex;
  public native let rightTrack: animNamedTrackIndex;
  public native let upTrack: animNamedTrackIndex;
  public native let downTrack: animNamedTrackIndex;
  public native let debug: Bool;
}

public native class animAnimNode_FacialMixerSlot extends animAnimNode_OnePoseInput {
  public native let lookAtDefinitions: array<animLookAtAnimationDefinition>;
}

public native class animAnimNode_FacialSharedMetaPose extends animAnimNode_OnePoseInput {}

public native class animAnimNode_FloatClamp extends animAnimNode_FloatValue {
  public native let min: Float;
  public native let max: Float;
  public native let inputNode: animFloatLink;
}

public native class animAnimNode_FloatComparator extends animAnimNode_FloatValue {
  public native let firstValue: Float;
  public native let secondValue: Float;
  public native let trueValue: Float;
  public native let falseValue: Float;
  public native let operation: animEAnimGraphCompareFunc;
  public native let firstInputLink: animFloatLink;
  public native let secondInputLink: animFloatLink;
  public native let trueInputLink: animFloatLink;
  public native let falseInputLink: animFloatLink;
}

public native class animAnimNode_FloatConstant extends animAnimNode_FloatValue {
  public native let value: Float;
}

public native class animAnimNode_FloatCumulative extends animAnimNode_FloatValue {
  public native let clamp: Bool;
  public native let resetOnActivation: Bool;
  public native let normalize180: Bool;
  public native let defaultValue: Float;
  public native let resetExternalEventName: CName;
  public native let inputNode: animFloatLink;
  public native let minValue: animFloatLink;
  public native let maxValue: animFloatLink;
  public native let resetSpeed: animFloatLink;
  public native let override: animBoolLink;
  public native let curValue: animFloatLink;
  public native let normalize180Input: animBoolLink;
}

public native class animAnimNode_FloatInput extends animAnimNode_FloatValue {
  public native let group: CName;
  public native let name: CName;
}

public native class animAnimNode_FloatInterpolation extends animAnimNode_FloatValue {
  public native let x1: Float;
  public native let x2: Float;
  public native let y1: Float;
  public native let y2: Float;
  public native let interpolationType: animEAnimGraphMathInterpolation;
  public native let inputNode: animFloatLink;
}

public native class animAnimNode_FloatJoin extends animAnimNode_FloatValue {
  public native let input: animFloatLink;
}

public native class animAnimNode_FloatLatch extends animAnimNode_FloatValue {
  public native let input: animFloatLink;
}

public native class animAnimNode_FloatMathOp extends animAnimNode_FloatValue {
  public native let operationType: animEAnimGraphMathOp;
  public native let firstInputNode: animFloatLink;
  public native let secondInputNode: animFloatLink;
}

public native class animAnimNode_FloatRandom extends animAnimNode_FloatValue {
  public native let rand: Bool;
  public native let cooldown: Float;
  public native let min: Float;
  public native let max: Float;
}

public native class animAnimNode_FloatTimeDependentSinus extends animAnimNode_FloatValue {
  public native let min: Float;
  public native let max: Float;
  public native let frequencyFactor: Float;
  public native let phaseFactor: Float;
}

public native class animAnimNode_FloatToBoolConverter extends animAnimNode_BoolValue {
  public native let inputNode: animFloatLink;
}

public native class animAnimNode_FloatToIntConverter extends animAnimNode_IntValue {
  public native let inputNode: animFloatLink;
}

public native class animAnimNode_FloatTrackDirectConnConstraint extends animAnimNode_OnePoseInput {
  public native let floatTrackIndex: animNamedTrackIndex;
  public native let transformIndex: animTransformIndex;
  public native let channel: animTransformChannel;
  public native let mulFactor: Float;
  public native let weight: Float;
  public native let weightNode: animFloatLink;
  public native let mulFactorNode: animFloatLink;
}

public native class animAnimNode_FloatTrackModifier extends animAnimNode_Base {
  public native let floatTrack: animNamedTrackIndex;
  public native let operationType: animFloatTrackOperationType;
  public native let inputFloatTrack: animNamedTrackIndex;
  public native let poseInputNode: animPoseLink;
  public native let floatInputNode: animFloatLink;
}

public native class animAnimNode_FloatTrackModifierMarkUnstable extends animAnimNode_FloatTrackModifier {
  public native let requiredQualityDistanceCategory: Uint32;
}

public abstract native class animAnimNode_FloatValue extends animAnimNode_Base {}

public native struct animAnimNode_FloatValueDebugProvider {
  public native let isEnabled: Bool;
  public native let min: Float;
  public native let max: Float;
  public native let progress: Float;
  public native let auto: Bool;
  public native let speed: Float;
  public native let wrap: Bool;
}

public native class animAnimNode_FloatVariable extends animAnimNode_FloatValue {
  public native let variableName: CName;
}

public native class animAnimNode_FloorIk extends animAnimNode_FloorIkBase {
  public native let pelvis: animSBehaviorConstraintNodeFloorIKVerticalBoneData;
  public native let legs: animSBehaviorConstraintNodeFloorIKLegsData;
  public native let leftLegIK: animSTwoBonesIKSolverData;
  public native let rightLegIK: animSTwoBonesIKSolverData;
}

public native class animAnimNode_FloorIkBase extends animAnimNode_OnePoseInput {
  public native let requiredAnimEvent: CName;
  public native let blockAnimEvent: CName;
  public native let canBeDisabledDueToFrameRate: Bool;
  public native let useFixedVersion: Bool;
  public native let slopeAngleDamp: Float;
  public native let common: animSBehaviorConstraintNodeFloorIKCommonData;
}

public native class animAnimNode_FootStepAdjuster extends animAnimNode_OnePoseInput {
  public native let leftToeName: animTransformIndex;
  public native let rightToeName: animTransformIndex;
  public native let leftFootName: animTransformIndex;
  public native let rightFootName: animTransformIndex;
  public native let leftCalfName: animTransformIndex;
  public native let rightCalfName: animTransformIndex;
  public native let leftThighName: animTransformIndex;
  public native let rightThighName: animTransformIndex;
  public native let pelvisBoneName: animTransformIndex;
  public native let calfHingeAxis: Vector4;
  public native let IKBlendTime: Float;
  public native let pelvisAdjustmentBlendSpeed: Float;
  public native let adjustPelvisVertically: Bool;
  public native let stepAdjustmentInterval: Float;
  public native let controlValueNode: animFloatLink;
  public native let controlVectorNode: animVectorLink;
}

public native class animAnimNode_FootStepScaling extends animAnimNode_OnePoseInput {
  public native let hipsIndex: animTransformIndex;
  public native let leftFootIKIndex: animTransformIndex;
  public native let rightFootIKIndex: animTransformIndex;
  public native let inputSpeed: animFloatLink;
  public native let weight: animFloatLink;
  public native let Params: animfssBodyOfflineParams;
}

public native class animAnimNode_ForegroundSegmentBegin extends animAnimNode_OnePoseInput {}

public native class animAnimNode_ForegroundSegmentEnd extends animAnimNode_OnePoseInput {
  public native let isAlwaysEnabledForHighEndHardware: Bool;
}

public native class animAnimNode_FPPCamera extends animAnimNode_OnePoseInput {}

public native class animAnimNode_FPPCameraSharedVar extends animAnimNode_FloatValue {}

public native class animAnimNode_FrozenFrame extends animAnimNode_OnePoseInput {
  public native let maxFramesFrozen: Int32;
  public native let triggerEventName: CName;
  public native let clearEventName: CName;
}

public native class animAnimNode_GenerateIkAnimFeatureData extends animAnimNode_OnePoseInput {
  public native let ikChainSettings: array<IKChainSettings>;
}

public native class animAnimNode_GraphSlot_Test extends animAnimNode_GraphSlot {
  public native let graph_TEST: ResourceRef; // rRef<animAnimGraph>
  public native let copyAnimInputsAtAttachTime: Bool;
}

public native class animAnimNode_GraphSlot extends animAnimNode_Base {
  public native let name: CName;
  public native let dontDeactivateInput: Bool;
  public native let inputLink: animPoseLink;
}

public native class animAnimNode_GraphSlotConditions extends animAnimNode_GraphSlot {
  public native let conditions: array<animGraphSlotCondition>;
}

public native class animAnimNode_GraphSlotInput extends animAnimNode_Base {}

public native class animAnimNode_HumanIk extends animAnimNode_OnePoseInput {
  public native let ikTargetsControllers: array<animTEMP_IKTargetsControllerBodyType>;
}

public native class animAnimNode_IdentityPoseTerminator extends animAnimNode_Base {}

public native class animAnimNode_Ik2 extends animAnimNode_Base {
  public native let firstBone: animTransformIndex;
  public native let secondBone: animTransformIndex;
  public native let endBone: animTransformIndex;
  public native let hingeAxis: animAxis;
  public native let minHingeAngleDegrees: Float;
  public native let maxHingeAngleDegrees: Float;
  public native let firstBoneIkGain: Float;
  public native let secondBoneIkGain: Float;
  public native let endBoneIkGain: Float;
  public native let enforceEndPosition: Bool;
  public native let enforceEndOrientation: Bool;
  public native let endBoneOffsetPositionLS: Vector4;
  public native let bone: animTransformIndex;
  public native let floatTrack: animNamedTrackIndex;
  public native let inputPoseNode: animPoseLink;
  public native let weightNode: animFloatLink;
  public native let endTargetPositionNode: animVectorLink;
  public native let endTargetOrientationNode: animQuaternionLink;
}

public native class animAnimNode_Ik2Constraint extends animAnimNode_OnePoseInput {
  public native let inputTarget: ref<animIAnimNodeSourceChannel_Vector>;
  public native let inputPoleVector: ref<animIAnimNodeSourceChannel_Vector>;
  public native let inputTargetOrientation: ref<animAnimNodeSourceChannel_WeightedQuat>;
  public native let firstBoneIndex: animTransformIndex;
  public native let secondBoneIndex: animTransformIndex;
  public native let endBoneIndex: animTransformIndex;
  public native let hingeAxis: animAxis;
  public native let twistValue: Float;
  public native let weight: Float;
  public native let weightFloatTrack: animNamedTrackIndex;
  public native let weightNode: animFloatLink;
  public native let twistNode: animFloatLink;
  public native let maxHingeAngle: Float;
}

public native class animAnimNode_Inertialization extends animAnimNode_OnePoseInput {
  public native let safeMode: Bool;
  public native let transformsCountUpperBound: Uint32;
  public native let tracksCountUpperBound: Uint32;
  public native let rotationLimits: array<animInertializationRotationLimit>;
}

public native class animAnimNode_InputSwitch extends animAnimNode_BaseSwitch {
  public native let selectIntNode: animIntLink;
  public native let selectFloatNode: animFloatLink;
}

public native class animAnimNode_IntConstant extends animAnimNode_IntValue {
  public native let value: Int32;
}

public native class animAnimNode_IntInput extends animAnimNode_IntValue {
  public native let group: CName;
  public native let name: CName;
}

public native class animAnimNode_IntJoin extends animAnimNode_IntValue {
  public native let input: animIntLink;
}

public native class animAnimNode_IntLatch extends animAnimNode_IntValue {
  public native let input: animIntLink;
}

public native class animAnimNode_IntToFloatConverter extends animAnimNode_FloatValue {
  public native let inputNode: animIntLink;
}

public abstract native class animAnimNode_IntValue extends animAnimNode_Base {}

public native class animAnimNode_IntVariable extends animAnimNode_IntValue {
  public native let variableName: CName;
}

public native class animAnimNode_Join extends animAnimNode_Base {
  public native let input: animPoseLink;
}

public native class animAnimNode_LocomotionAdjuster extends animAnimNode_OnePoseInput {
  public native let targetPosition: animVectorLink;
  public native let targetDirection: animVectorLink;
  public native let initialForwardVector: Vector4;
  public native let blendSpeedPos: Float;
  public native let blendSpeedPosMin: Float;
  public native let blendSpeedRot: Float;
  public native let maxDistance: Float;
}

public native class animAnimNode_LocomotionAdjusterOnEvent extends animAnimNode_LocomotionAdjuster {
  public native let locomotionFeatureName: CName;
  public native let targetAnimationName: CName;
  public native let startAdjustmentAfterAnimEvent: CName;
}

public native class animAnimNode_LocomotionMachine extends animAnimNode_StateMachine {
  public native let usePlanner: Bool;
  public native let group: CName;
  public native let logic: CName;
  public native let requestId: CName;
  public native let distance: CName;
  public native let duration: CName;
  public native let motion: CName;
  public native let state: CName;
  public native let transitionTime: Float;
  public native let numVariants: Uint32;
}

public native class animAnimNode_LocomotionSwitch extends animAnimNode_Switch {
  public native let audioTagsPerInput: array<CName>;
}

public native class animAnimNode_LocoState extends animAnimNode_State {
  public native let type: animLocoStateType;
  public native let locoTag: CName;
}

public native class animAnimNode_LODBegin extends animAnimNode_OnePoseInput {
  public native let levelOfDetail: Uint32;
}

public native class animAnimNode_LODEnd extends animAnimNode_Base {
  public native let inputLink: animPoseLink;
}

public native class animAnimNode_LookAt extends animAnimNode_OnePoseInput {
  public native let transform: animTransformIndex;
  public native let forwardAxis: animAxis;
  public native let useLimits: Bool;
  public native let limitAxis: animAxis;
  public native let limitAngle: Float;
  public native let targetNode: animVectorLink;
  public native let weightNode: animFloatLink;
}

public native class animAnimNode_LookAtApplyVehicleRestrictions extends animAnimNode_OnePoseInput {
  public native let group: CName;
  public native let name: CName;
  public native let referenceBone: animTransformIndex;
}

public native class animAnimNode_LookAtController extends animAnimNode_OnePoseInput {
  public native let E3_HACK_offset: animVectorLink;
  public native let orderedBodyParts: array<LookAtPartInfo>;
  public native let stateMachinesSettings: array<LookAtStateMachineSettings>;
  public native let bodyPartsDependencies: array<LookAtPartsDependency>;
  public native let substepTime: Float;
  public native let isFacial: Bool;
}

public native class animAnimNode_LookAtPose360 extends animAnimNode_Base {
  public native let speedInDegreesPerSecond: Float;
  public native let angleOffsetNode: animFloatLink;
  public native let targetAngleOffsetNode: animFloatLink;
  public native let weightNode: animFloatLink;
  public native let animEndEventName: CName;
  public native let animation: CName;
  public native let durationCut: Float;
}

public native class animAnimNode_LookAtPose360Direction extends animAnimNode_FloatValue {
  public native let angleOffset: Float;
  public native let defaultValue: Float;
  public native let negateOutput: Bool;
}

public native class animAnimNode_MaskReset extends animAnimNode_OnePoseInput {
  public native let weightNode: animFloatLink;
  public native let transforms: array<animTransformIndex>;
}

public native class animAnimNode_MathExpressionFloat extends animAnimNode_FloatValue {
  public native let expressionData: animMathExpressionNodeData;
}

public native class animAnimNode_MathExpressionPose extends animAnimNode_OnePoseInput {
  public native let expressionData: animMathExpressionNodeData;
  public native let outputFloatTrack: animNamedTrackIndex;
}

public native class animAnimNode_MathExpressionQuaternion extends animAnimNode_QuaternionValue {
  public native let expressionData: animMathExpressionNodeData;
}

public native class animAnimNode_MathExpressionVector extends animAnimNode_VectorValue {
  public native let expressionData: animMathExpressionNodeData;
}

public native class animAnimNode_MixerSlot extends animAnimNode_OnePoseInput {
  public native let maxNormalAnimEntriesCount: Uint16;
  public native let maxAdditiveAnimEntriesCount: Uint16;
  public native let maxOverrideAnimEntriesCount: Uint16;
}

public native class animAnimNode_MotionAdjuster extends animAnimNode_Base {
  public native let inputNode: animPoseLink;
  public native let targetPosition: animVectorLink;
  public native let targetDirection: animVectorLink;
  public native let totalTimeToAdjust: animFloatLink;
  public native let forwardVector: Vector4;
}

public abstract native class animAnimNode_MotionTableSwitch extends animAnimNode_Base {}

public native class animAnimNode_MultiBoolToFloatValue extends animAnimNode_FloatValue {
  public native let allMustBeTrue: Bool;
  public native let onTrue: Float;
  public native let onFalse: Float;
  public native let inputsData: array<animAnimMultiBoolToFloatEntry>;
}

public native struct animAnimNode_MultipleParentConstraint_ParentInfo {
  public native let parentTransform: animTransformIndex;
  public native let parentWeightMode: animConstraintWeightMode;
  public native let parentStaticWeight: Float;
  public native let parentTrackWeight: animNamedTrackIndex;
  public native let useComplementWeight: Bool;
  public native let useOffset: Bool;
  public native let offset: QsTransform;
}

public native class animAnimNode_MultipleParentConstraint extends animAnimNode_OnePoseInput {
  public native let parentsTransform: array<ref<animIAnimNodeSourceChannel_QsTransform>>;
  public native let parentsWeight: array<ref<animIAnimNodeSourceChannel_Float>>;
  public native let areSourceChannelsResaved: Bool;
  public native let parentsTransforms: array<animAnimNode_MultipleParentConstraint_ParentInfo>;
  public native let transformIndex: animTransformIndex;
  public native let interpolationType: animEInterpolationType;
  public native let weightMode: animConstraintWeightMode;
  public native let weight: Float;
  public native let weightFloatTrack: animNamedTrackIndex;
}

public native class animAnimNode_NameHashConstant extends animAnimNode_IntValue {
  public native let value: CName;
}

public native class animAnimNode_NPCExploration extends animAnimNode_Base {}

public abstract native class animAnimNode_OnePoseInput extends animAnimNode_Base {
  public native let inputLink: animPoseLink;
}

public native struct animAnimNode_OrientConstraint_WeightedTransform {
  public native let transform: animTransformIndex;
  public native let weight: Float;
}

public native class animAnimNode_OrientConstraint extends animAnimNode_OnePoseInput {
  public native let areSourceChannelsResaved: Bool;
  public native let inputTransforms: array<ref<animAnimNodeSourceChannel_WeightedQuat>>;
  public native let preprocessedWeights: array<Float>;
  public native let inputWeightedTransforms: array<animAnimNode_OrientConstraint_WeightedTransform>;
  public native let transformIndex: animTransformIndex;
  public native let weightMode: animConstraintWeightMode;
  public native let weight: Float;
  public native let weightFloatTrack: animNamedTrackIndex;
}

public native class animAnimNode_Output extends animAnimNode_Base {
  public native let node: animPoseLink;
}

public native class animAnimNode_ParentConstraint extends animAnimNode_OnePoseInput {
  public native let parentTransform: ref<animIAnimNodeSourceChannel_QsTransform>;
  public native let isParentTransformResaved: Bool;
  public native let parentTransformIndex: animTransformIndex;
  public native let transformIndex: animTransformIndex;
  public native let interpolationType: animEInterpolationType;
  public native let weight: Float;
  public native let weightFloatTrack: animNamedTrackIndex;
  public native let useBoneReferencePoseAsDefaultOffset: Bool;
  public native let weightNode: animFloatLink;
  public native let offsetTranslationLS: animVectorLink;
  public native let offsetEulerRotationLS: animVectorLink;
}

public native class animAnimNode_ParentTransform extends animAnimNode_OnePoseInput {
  public native let mapping: array<animAnimTransformMappingEntry>;
}

public native struct animAnimNode_PointConstraint_WeightedTransform {
  public native let transform: animTransformIndex;
  public native let weight: Float;
}

public native class animAnimNode_PointConstraint extends animAnimNode_OnePoseInput {
  public native let areSourceChannelsResaved: Bool;
  public native let inputTransforms: array<ref<animAnimNodeSourceChannel_WeightedVector>>;
  public native let preprocessedWeights: array<Float>;
  public native let inputWeightedTransforms: array<animAnimNode_PointConstraint_WeightedTransform>;
  public native let transformIndex: animTransformIndex;
  public native let weightMode: animConstraintWeightMode;
  public native let weight: Float;
  public native let weightFloatTrack: animNamedTrackIndex;
}

public native class animAnimNode_Pose360 extends animAnimNode_Base {
  public native let angle: animFloatLink;
  public native let animation: CName;
}

public native class animAnimNode_PoseCorrection extends animAnimNode_OnePoseInput {}

public native class animAnimNode_PoseLsToMs extends animAnimNode_OnePoseInput {}

public native class animAnimNode_PoseMsToLs extends animAnimNode_OnePoseInput {}

public native class animAnimNode_PostProcess_Footlock extends animIAnimNode_PostProcess {}

public native class animAnimNode_QuaternionConstant extends animAnimNode_QuaternionValue {
  public native let value: Quaternion;
}

public native class animAnimNode_QuaternionInput extends animAnimNode_QuaternionValue {
  public native let group: CName;
  public native let name: CName;
}

public native class animAnimNode_QuaternionInterpolation extends animAnimNode_QuaternionValue {
  public native let interpolationType: animQuaternionInterpolationType;
  public native let firstInput: animQuaternionLink;
  public native let secondInput: animQuaternionLink;
  public native let weight: animFloatLink;
}

public native class animAnimNode_QuaternionJoin extends animAnimNode_QuaternionValue {
  public native let input: animQuaternionLink;
}

public native class animAnimNode_QuaternionLatch extends animAnimNode_QuaternionValue {
  public native let input: animQuaternionLink;
}

public abstract native class animAnimNode_QuaternionValue extends animAnimNode_Base {}

public native class animAnimNode_QuaternionVariable extends animAnimNode_QuaternionValue {
  public native let variableName: CName;
}

public native class animAnimNode_QuaternionWsToMs extends animAnimNode_QuaternionValue {
  public native let quaternionWs: animQuaternionLink;
}

public native class animAnimNode_RagdollControl extends animAnimNode_Base {
  public native let blendInDuration: Float;
  public native let blendOutDuration: Float;
  public native let inputPoseNode: animPoseLink;
}

public native class animAnimNode_RagdollPose extends animAnimNode_Base {}

public native class animAnimNode_ReadIkRequest extends animAnimNode_OnePoseInput {
  public native let ikChain: CName;
  public native let outTransform: animTransformIndex;
}

public native class animAnimNode_ReferencePoseTerminator extends animAnimNode_Base {}

public native class animAnimNode_Retarget extends animAnimNode_OnePoseInput {
  public native let refRig: ResourceRef; // rRef<animRig>
  public native let postProcess: ref<animIAnimNode_PostProcess>;
}

public native class animAnimNode_Root extends animAnimNode_Container {
  public native let outputNode: animPoseLink;
}

public native class animAnimNode_RotateBone extends animAnimNode_Base {
  public native let inputNode: animPoseLink;
  public native let angleNode: animFloatLink;
  public native let minValueNode: animFloatLink;
  public native let maxValueNode: animFloatLink;
  public native let bone: animTransformIndex;
  public native let axis: animETransformAxis;
  public native let scale: Float;
  public native let biasAngle: Float;
  public native let minAngle: Float;
  public native let maxAngle: Float;
  public native let clampRotation: Bool;
  public native let useIncrementalMode: Bool;
  public native let resetOnActivation: Bool;
  public native let inModelSpace: Bool;
}

public native class animAnimNode_RotateBoneByQuaternion extends animAnimNode_Base {
  public native let inputNode: animPoseLink;
  public native let quaternionNode: animQuaternionLink;
  public native let bone: animTransformIndex;
  public native let useIncrementalMode: Bool;
  public native let resetOnActivation: Bool;
}

public native class animAnimNode_RotationLimit extends animAnimNode_OnePoseInput {
  public native let constrainedTransform: animTransformIndex;
  public native let limitOnX: animSmoothFloatClamp;
  public native let limitOnY: animSmoothFloatClamp;
  public native let limitOnZ: animSmoothFloatClamp;
  public native let useEyesLookAtBlendWeight: Bool;
  public native let weightLink: animFloatLink;
}

public native class animAnimNode_RuntimeSwitch extends animAnimNode_Base {
  public native let condition: ref<animIRuntimeCondition>;
  public native let True: animPoseLink;
  public native let False: animPoseLink;
}

public native class animAnimNode_SelectiveJoin extends animAnimNode_OnePoseInput {}

public native class animAnimNode_Sermo extends animAnimNode_OnePoseInput {}

public native class animAnimNode_SetBoneOrientation extends animAnimNode_OnePoseInput {
  public native let bone: animTransformIndex;
  public native let orientationMs: animQuaternionLink;
}

public native class animAnimNode_SetBonePosition extends animAnimNode_OnePoseInput {
  public native let bone: animTransformIndex;
  public native let positionMs: animVectorLink;
}

public native class animAnimNode_SetBoneTransform extends animAnimNode_OnePoseInput {
  public native let entries: array<animSetBoneTransformEntry>;
}

public enum animAnimNode_SetDrivenKey_InternalsEChannelType {
  FloatTrack = 0,
  TransX = 1,
  TransY = 2,
  TransZ = 3,
  RotEulZ_Pitch = 4,
  RotEulX_Roll = 5,
  RotEulY_Yaw = 6,
  ScaleX = 7,
  ScaleY = 8,
  ScaleZ = 9,
  RotQuatX = 10,
  RotQuatY = 11,
  RotQuatZ = 12,
  RotQuatW = 13,
}

public native struct animAnimNode_SetDrivenKey_InternalsEntry {
  public native let curve: CurveDataFloat;
  public native let inChannelName: CName;
  public native let outChannelName: CName;
  public native let inChanelType: animAnimNode_SetDrivenKey_InternalsEChannelType;
  public native let outChanelType: animAnimNode_SetDrivenKey_InternalsEChannelType;
}

public abstract native class animAnimNode_SetDrivenKey_InternalsISetDrivenKeyEntryProvider extends ISerializable {}

public native class animAnimNode_SetDrivenKey_InternalsSetDrivenKeyEntryProviderInline extends animAnimNode_SetDrivenKey_InternalsISetDrivenKeyEntryProvider {
  public native let entries: array<animAnimNode_SetDrivenKey_InternalsEntry>;
}

public native class animAnimNode_SetDrivenKey extends animAnimNode_Base {
  public native let inputLink: animPoseLink;
  public native let provider: ref<animAnimNode_SetDrivenKey_InternalsISetDrivenKeyEntryProvider>;
}

public native class animAnimNode_SetRequiredDistanceCategory extends animAnimNode_OnePoseInput {
  public native let requiredQualityDistanceCategory: Uint32;
}

public native class animAnimNode_SetRequiredDistanceCategoryByBone extends animAnimNode_OnePoseInput {
  public native let bone: animTransformIndex;
}

public native class animAnimNode_SetTrackRange extends animAnimNode_OnePoseInput {
  public native let min: Float;
  public native let max: Float;
  public native let oldMin: Float;
  public native let oldMax: Float;
  public native let minLink: animFloatLink;
  public native let maxLink: animFloatLink;
  public native let oldMinLink: animFloatLink;
  public native let oldMaxLink: animFloatLink;
  public native let track: animNamedTrackIndex;
  public native let debug: Bool;
}

public native class animAnimNode_SharedMetaPose extends animAnimNode_OnePoseInput {
  public native let weightLink: animFloatLink;
}

public native class animAnimNode_SharedMetaPoseAdditive extends animAnimNode_OnePoseInput {
  public native let weightLink: animFloatLink;
  public native let additiveType: animEAnimGraphAdditiveType;
  public native let blendTracks: animEBlendTracksMode;
  public native let convertParentPoseToAdditive: Bool;
}

public native class animAnimNode_Signal extends animAnimNode_FloatValue {
  public native let blendIn: Float;
  public native let blendOut: Float;
  public native let startEvent: CName;
  public native let endEvent: CName;
  public native let defaultState: Bool;
  public native let cooldown: Float;
}

public native class animAnimNode_SimpleBounce extends animAnimNode_OnePoseInput {
  public native let areChannelsResaved: Bool;
  public native let outputDriverTrack: animNamedTrackIndex;
  public native let debug: Bool;
  public native let startTransform: animTransformIndex;
  public native let endTransform: animTransformIndex;
  public native let multiplier: Float;
  public native let negativeMultiplier: Float;
  public native let smoothStep: Float;
  public native let offset: Float;
  public native let delay: Float;
  public native let transformOutputs: array<animSimpleBounceTransformOutput>;
  public native let trackOutputs: array<animSimpleBounceTrackOutput>;
}

public native class animAnimNode_SimpleSpline extends animAnimNode_OnePoseInput {
  public native let areSourceChannelsResaved: Bool;
  public native let startTransform: animTransformIndex;
  public native let middleTransform: animTransformIndex;
  public native let endTransform: animTransformIndex;
  public native let constrainedTransform: animTransformIndex;
  public native let progressMode: animConstraintWeightMode;
  public native let defaultProgress: Float;
  public native let progressTrack: animNamedTrackIndex;
}

public native class animAnimNode_SkAnim extends animAnimNode_Base {
  public native let animation: CName;
  public native let applyMotion: Bool;
  public native let isLooped: Bool;
  public native let resume: Bool;
  public native let collectEvents: Bool;
  public native let fireAnimLoopEvent: Bool;
  public native let animLoopEventName: CName;
  public native let clipFront: Float;
  public native let clipEnd: Float;
  public native let clipFrontByEvent: CName;
  public native let clipEndByEvent: CName;
  public native let pushDataByTag: CName;
  public native let popDataByTag: CName;
  public native let pushSafeCutTag: CName;
  public native let convertToAdditive: Bool;
  public native let motionProvider: ref<animIMotionTableProvider>;
  public native let applyInertializationOnAnimSetSwap: Bool;
}

public native class animAnimNode_SkAnimAdjuster extends animAnimNode_SkAnim {
  public native let targetPositionWs: animVectorLink;
  public native let targetDirectionWs: animVectorLink;
  public native let initialForwardVector: Vector4;
  public native let startAdjustmentEventName: CName;
  public native let endAdjustmentEventName: CName;
}

public native class animAnimNode_SkAnimContinue extends animAnimNode_SkAnim {
  public native let Input: animPoseLink;
  public native let popSafeCutTag: CName;
}

public native class animAnimNode_SkAnimDecorator extends animAnimNode_SkAnim {
  public native let Fallback: animPoseLink;
}

public native class animAnimNode_SkAnimSlot extends animAnimNode_SkAnim {
  public native let forFacialIdle: Bool;
}

public native class animAnimNode_SkDurationAnim extends animAnimNode_SkAnim {
  public native let Duration: animFloatLink;
}

public native class animAnimNode_SkFrameAnim extends animAnimNode_SkAnim {
  public native let progressLink: animFloatLink;
  public native let timeLink: animFloatLink;
  public native let frameLink: animFloatLink;
  public native let fireAnimEndOnceOnAnimEnd: Bool;
}

public native class animAnimNode_SkFrameAnimByTrack extends animAnimNode_SkFrameAnim {
  public native let progressFloatTrack: animNamedTrackIndex;
  public native let timeFloatTrack: animNamedTrackIndex;
  public native let frameFloatTrack: animNamedTrackIndex;
  public native let inputWithTracks: animPoseLink;
}

public native class animAnimNode_SkipConsoleBegin extends animAnimNode_OnePoseInput {}

public native class animAnimNode_SkipConsoleEnd extends animAnimNode_Base {
  public native let inputLink: animPoseLink;
}

public native class animAnimNode_SkipPerformanceModeBegin extends animAnimNode_OnePoseInput {}

public native class animAnimNode_SkipPerformanceModeEnd extends animAnimNode_Base {
  public native let inputLink: animPoseLink;
}

public native class animAnimNode_SkOneShotAnim extends animAnimNode_SkAnim {
  public native let Input: animPoseLink;
  public native let blendIn: Float;
  public native let blendOut: Float;
}

public native class animAnimNode_SkPhaseAnim extends animAnimNode_SkAnim {
  public native let phase: CName;
}

public native class animAnimNode_SkPhaseSlotWithDurationAnim extends animAnimNode_SkPhaseWithDurationAnim {
  public native let animFeatureName: CName;
  public native let actionAnimDatabaseRef: ResourceRef; // rRef<animActionAnimDatabase>
}

public native class animAnimNode_SkPhaseWithDurationAnim extends animAnimNode_SkPhaseAnim {
  public native let durationLink: animFloatLink;
}

public native class animAnimNode_SkPhaseWithSpeedAnim extends animAnimNode_SkPhaseAnim {
  public native let speedLink: animFloatLink;
}

public native class animAnimNode_SkSpeedAnim extends animAnimNode_SkAnim {
  public native let Speed: animFloatLink;
}

public native class animAnimNode_SkSyncedMasterAnim extends animAnimNode_SkSpeedAnim {
  public native let syncTag: CName;
}

public native class animAnimNode_SkSyncedMasterAnimByTime extends animAnimNode_SkFrameAnim {
  public native let syncTag: CName;
}

public native class animAnimNode_SkSyncedSlaveAnim extends animAnimNode_SkAnim {
  public native let syncTag: CName;
}

public native class animAnimNode_SpringDamp extends animAnimNode_FloatValue {
  public native let massFactor: Float;
  public native let springFactor: Float;
  public native let dampFactor: Float;
  public native let startFromDefaultValue: Bool;
  public native let defaultInitialValue: Float;
  public native let wrapAroundRange: Bool;
  public native let rangeMin: Float;
  public native let rangeMax: Float;
  public native let timeStep: Float;
  public native let inputNode: animFloatLink;
}

public native class animAnimNode_StackTracksExtender extends animAnimNode_OnePoseInput {
  public native let tag: CName;
  public native let newTracks: array<animFloatTrackInfo>;
}

public native class animAnimNode_StackTracksShrinker extends animAnimNode_OnePoseInput {
  public native let tag: CName;
}

public native class animAnimNode_StackTransformsExtender extends animAnimNode_OnePoseInput {
  public native let tag: CName;
  public native let transformInfos: array<animTransformInfo>;
  public native let snapMethods: array<animStackTransformsExtender_SnapToBoneMethod>;
  public native let snapToReferenceValues: array<Bool>;
  public native let snapTargetBones: array<animTransformIndex>;
  public native let offsetToReferenceValues: array<Bool>;
  public native let offsetSpaceBones: array<animTransformIndex>;
  public native let offsets: array<QsTransform>;
}

public native class animAnimNode_StackTransformsShrinker extends animAnimNode_OnePoseInput {
  public native let tag: CName;
}

public native class animAnimNode_Stage extends animAnimNode_Container {
  public native let inputPoses: array<animPoseLink>;
}

public native class animAnimNode_StageFloatEntry extends animAnimNode_FloatValue {}

public native class animAnimNode_StagePoseEntry extends animAnimNode_Base {
  public native let inputName: CName;
  public native let parentInput: animPoseLink;
}

public native class animAnimNode_State extends animAnimNode_Container {
  public native let name: CName;
  public native let outTransitionIndices: array<Int16>;
  public native let preventTransitionsInActivationFrame: Bool;
  public native let tags: array<CName>;
  public native let requiredQualityDistanceCategory: Uint32;
}

public native class animAnimNode_StateFrozen extends animAnimNode_State {}

public native class animAnimNode_StateMachine extends animAnimNode_Base {
  public native let states: array<ref<animAnimNode_State>>;
  public native let frozenState: ref<animAnimNode_StateFrozen>;
  public native let transitions: array<ref<animAnimStateTransitionDescription>>;
  public native let conditionalEntries: array<ref<animAnimStateMachineConditionalEntry>>;
  public native let globalTransitions: array<ref<animAnimStateTransitionDescription>>;
  public native let anyStateInterpolator: ref<animIAnimStateTransitionInterpolator>;
  public native let defaultStateIndex: Uint32;
  public native let notifyOnEnterState: Bool;
}

public native class animAnimNode_StaticSwitch extends animAnimNode_MotionTableSwitch {
  public native let condition: ref<animIStaticCondition>;
  public native let motionProvider: ref<animIMotionTableProvider>;
  public native let True: animPoseLink;
  public native let False: animPoseLink;
}

public native class animAnimNode_SuspensionLimit extends animAnimNode_OnePoseInput {
  public native let constrainedTransform: animTransformIndex;
  public native let radiusTrack: animNamedTrackIndex;
  public native let deviationTrack: animNamedTrackIndex;
  public native let axis: animAxis;
}

public native class animAnimNode_Switch extends animAnimNode_MotionTableSwitch {
  public native let numInputs: Uint32;
  public native let blendTime: Float;
  public native let timeWarpingEnabled: Bool;
  public native let syncMethod: ref<animISyncMethod>;
  public native let motionProvider: ref<animIMotionTableProvider>;
  public native let weightNode: animFloatLink;
  public native let inputNodes: array<animPoseLink>;
  public native let pushDataByTag: CName;
  public native let canRequestInertialization: Bool;
}

public native class animAnimNode_TagSwitch extends animAnimNode_BaseSwitch {
  public native let tags: array<CName>;
}

public native class animAnimNode_TagValue extends animAnimNode_FloatValue {
  public native let tag: CName;
  public native let defaultValue: Float;
  public native let oneMinus: Bool;
}

public native class animAnimNode_Timer extends animAnimNode_FloatValue {}

public native class animAnimNode_TrackSetter extends animAnimNode_OnePoseInput {
  public native let track: animNamedTrackIndex;
  public native let value: animFloatLink;
}

public native class animAnimNode_TrajectoryFromMetaPose extends animAnimNode_OnePoseInput {
  public native let metaPoseTrajectoryLs: animTransformIndex;
}

public native class animAnimNode_TransformConstant extends animAnimNode_TransformValue {
  public native let pos: Vector4;
  public native let rotation: Quaternion;
  public native let scale: Vector4;
}

public native class animAnimNode_TransformInterpolation extends animAnimNode_TransformValue {
  public native let interpolationType: animQuaternionInterpolationType;
  public native let firstInput: animTransformLink;
  public native let secondInput: animTransformLink;
  public native let weight: animFloatLink;
}

public native class animAnimNode_TransformJoin extends animAnimNode_TransformValue {
  public native let input: animTransformLink;
}

public native class animAnimNode_TransformLatch extends animAnimNode_TransformValue {
  public native let input: animTransformLink;
}

public native class animAnimNode_TransformRotator extends animAnimNode_OnePoseInput {
  public native let transform: animTransformIndex;
  public native let axis: Vector3;
  public native let valueScale: Float;
  public native let clamp: Bool;
  public native let angleMin: Float;
  public native let angleMax: Float;
  public native let angleValueNode: animFloatLink;
  public native let angleSpeedNode: animFloatLink;
}

public native class animAnimNode_TransformToTrack extends animAnimNode_OnePoseInput {
  public native let floatTrack: Int32;
  public native let floatTrackIndex: animNamedTrackIndex;
  public native let outputTransform: Int16;
  public native let transformIndex: animTransformIndex;
  public native let channel: animTransformChannel;
  public native let mulFactor: Float;
  public native let weight: Float;
  public native let weightNode: animFloatLink;
  public native let mulFactorNode: animFloatLink;
}

public abstract native class animAnimNode_TransformValue extends animAnimNode_Base {}

public native class animAnimNode_TransformVariable extends animAnimNode_TransformValue {
  public native let variableName: CName;
}

public native class animAnimNode_TranslateBone extends animAnimNode_Base {
  public native let inputNode: animPoseLink;
  public native let inputTranslation: animVectorLink;
  public native let scale: Vector4;
  public native let biasValue: Vector4;
  public native let bone: animTransformIndex;
  public native let useIncrementalMode: Bool;
  public native let resetOnActivation: Bool;
}

public native class animAnimNode_TranslationLimit extends animAnimNode_OnePoseInput {
  public native let constrainedTransform: animTransformIndex;
  public native let parentTransform: animTransformIndex;
  public native let limitOnXAxis: animFloatClamp;
  public native let limitOnYAxis: animFloatClamp;
  public native let limitOnZAxis: animFloatClamp;
}

public native class animAnimNode_TriggerBranch extends animAnimNode_Base {
  public native let base: animPoseLink;
  public native let overlay: animPoseLink;
  public native let blendIn: Float;
  public native let blendOut: Float;
  public native let startEvent: CName;
  public native let endEvent: CName;
  public native let cooldown: Float;
}

public native class animAnimNode_TwistConstraint extends animAnimNode_OnePoseInput {
  public native let frontAxis: animAxis;
  public native let transformA: animTransformIndex;
  public native let transformB: animTransformIndex;
  public native let outputs: array<animTwistOutput>;
  public native let debug: Bool;
}

public native class animAnimNode_ValueBySpeed extends animAnimNode_FloatValue {
  public native let defaultValue: Float;
  public native let clampType: animClampType;
  public native let rangeMin: Float;
  public native let rangeMax: Float;
  public native let resetOnActivation: Bool;
  public native let speed: animFloatLink;
}

public native class animAnimNode_VectorConstant extends animAnimNode_VectorValue {
  public native let value: Vector4;
}

public native class animAnimNode_VectorInput extends animAnimNode_VectorValue {
  public native let group: CName;
  public native let name: CName;
}

public native class animAnimNode_VectorInterpolation extends animAnimNode_VectorValue {
  public native let firstInput: animVectorLink;
  public native let secondInput: animVectorLink;
  public native let weight: animFloatLink;
}

public native class animAnimNode_VectorJoin extends animAnimNode_VectorValue {
  public native let input: animVectorLink;
}

public native class animAnimNode_VectorLatch extends animAnimNode_VectorValue {
  public native let input: animVectorLink;
}

public abstract native class animAnimNode_VectorValue extends animAnimNode_Base {}

public native class animAnimNode_VectorVariable extends animAnimNode_VectorValue {
  public native let variableName: CName;
}

public native class animAnimNode_VectorWsToMs extends animAnimNode_VectorValue {
  public native let type: animEVectorWsToMsType;
  public native let vectorWs: animVectorLink;
}

public native class animAnimNode_WorkspotAnim extends animAnimNode_Base {
  public native let collectEvents: Bool;
  public native let inputLink: animPoseLink;
}

public native class animAnimNode_WorkspotHub extends animAnimNode_Base {
  public native let additionalLinkIds: array<WorkEntryId>;
  public native let additionalLinks: array<animPoseLink>;
  public native let animLoopEventName: CName;
  public native let isCoverHubHack: Bool;
  public native let eventFilterType: animEventFilterType;
  public native let mainEmotionalState: CName;
  public native let emotionalExpression: CName;
  public native let facialKeyWeight: Float;
  public native let facialIdleMaleAnimation: CName;
  public native let facialIdleKey_MaleAnimation: CName;
  public native let facialIdleFemaleAnimation: CName;
  public native let facialIdleKey_FemaleAnimation: CName;
}

public native class animAnimNode_WrapperValue extends animAnimNode_FloatValue {
  public native let wrapperNames: array<CName>;
  public native let logicOp: animEAnimGraphLogicOp;
  public native let oneMinus: Bool;
}

@neverRef()
public native class animAnimNodeDebugState extends ISerializable {
  public native let nodeId: Uint32;
  public native let active: Bool;
}

public native class animAnimNodeSourceChannel_AnimFeatureQsTransform extends animIAnimNodeSourceChannel_QsTransform {}

public native class animAnimNodeSourceChannel_AnimFeatureQuat extends animIAnimNodeSourceChannel_Quat {}

public native class animAnimNodeSourceChannel_AnimFeatureVector extends animIAnimNodeSourceChannel_Vector {}

public native class animAnimNodeSourceChannel_FloatTrack extends animIAnimNodeSourceChannel_Float {
  public native let floatTrack: animNamedTrackIndex;
  public native let useComplementValue: Bool;
}

public native class animAnimNodeSourceChannel_OrientationVector extends animIAnimNodeSourceChannel_Vector {
  public native let transformIndex: animTransformIndex;
  public native let inputTransformIndex: animTransformIndex;
  public native let up: Vector3;
}

public native class animAnimNodeSourceChannel_ReferenceTransformVector extends animIAnimNodeSourceChannel_Vector {
  public native let transformIndex: animTransformIndex;
}

public native class animAnimNodeSourceChannel_SocketQsTransform extends animIAnimNodeSourceChannel_QsTransform {}

public native class animAnimNodeSourceChannel_SocketQuat extends animIAnimNodeSourceChannel_Quat {}

public native class animAnimNodeSourceChannel_SocketVector extends animIAnimNodeSourceChannel_Vector {}

public native class animAnimNodeSourceChannel_StaticQsTransform extends animIAnimNodeSourceChannel_QsTransform {
  public native let data: QsTransform;
}

public native class animAnimNodeSourceChannel_StaticQuat extends animIAnimNodeSourceChannel_Quat {
  public native let data: Quaternion;
}

public native class animAnimNodeSourceChannel_StaticVector extends animIAnimNodeSourceChannel_Vector {
  public native let data: Vector4;
}

public native class animAnimNodeSourceChannel_TransformQsTransform extends animIAnimNodeSourceChannel_QsTransform {
  public native let transformIndex: animTransformIndex;
}

public native class animAnimNodeSourceChannel_TransformQuat extends animIAnimNodeSourceChannel_Quat {
  public native let transformIndex: animTransformIndex;
}

public native class animAnimNodeSourceChannel_TransformVector extends animIAnimNodeSourceChannel_Vector {
  public native let transformIndex: animTransformIndex;
}

public native class animAnimNodeSourceChannel_WeightedQsTransform extends ISerializable {
  public native let channel: ref<animIAnimNodeSourceChannel_QsTransform>;
  public native let weight: Float;
}

public native class animAnimNodeSourceChannel_WeightedQuat extends ISerializable {
  public native let channel: ref<animIAnimNodeSourceChannel_Quat>;
  public native let weight: Float;
  public native let weightLink: animFloatLink;
  public native let weightFloatTrack: animNamedTrackIndex;
}

public native class animAnimNodeSourceChannel_WeightedVector extends ISerializable {
  public native let channel: ref<animIAnimNodeSourceChannel_Vector>;
  public native let weight: Float;
  public native let weightLink: animFloatLink;
  public native let weightFloatTrack: animNamedTrackIndex;
}

public native class animAnimProfileData_RootItem extends ISerializable {
  public native let timeMS: Float;
  public native let children: array<ref<animAnimProfilerData_TreeItem>>;
}

public native struct animAnimProfilerData_SectionTimings {
  public native let sectionName: CName;
  public native let updateTimeMS: Float;
  public native let sampleTimeMS: Float;
}

public native struct animAnimProfilerData_Timings {
  public native let className: CName;
  public native let avarageExclusiveTimeMS: Float;
  public native let avarageInclusiveTimeMS: Float;
}

public native struct animAnimProfilerData_TimingsDetailed {
  public native let className: CName;
  public native let avarageExclusiveUpdateTimeMS: Float;
  public native let avarageInclusiveUpdateTimeMS: Float;
  public native let avarageExclusiveSampleTimeMS: Float;
  public native let avarageInclusiveSampleTimeMS: Float;
  public native let totalExclusiveUpdateTimeMS: Float;
  public native let totalInclusiveUpdateTimeMS: Float;
  public native let totalExclusiveSampleTimeMS: Float;
  public native let totalInclusiveSampleTimeMS: Float;
  public native let updatesCount: Uint32;
  public native let samplesCount: Uint32;
}

public native class animAnimProfilerData_TimingsDetailedRoot extends ISerializable {
  public native let sections: array<animAnimProfilerData_SectionTimings>;
  public native let timings: array<animAnimProfilerData_TimingsDetailed>;
}

public native class animAnimProfilerData_TimingsRoot extends ISerializable {
  public native let timings: array<animAnimProfilerData_Timings>;
}

public native class animAnimProfilerData_TreeItem extends ISerializable {
  public native let className: CName;
  public native let exclusiveTimeMS: Float;
  public native let inclusiveTimeMS: Float;
  public native let children: array<ref<animAnimProfilerData_TreeItem>>;
}

public native class animAnimSet extends CResource {
  public native let animations: array<ref<animAnimSetEntry>>;
  public native let animationDataChunks: array<animAnimDataChunk>;
  public native let fallbackDataAddresses: array<Uint16>;
  public native let fallbackDataAddressIndexes: array<Uint8>;
  public native let fallbackAnimFrameDescs: array<animAnimFallbackFrameDesc>;
  public native let fallbackAnimDescIndexes: array<Uint8>;
  public native let fallbackNumPositionData: Uint16;
  public native let fallbackNumRotationData: Uint16;
  public native let fallbackNumFloatTrackData: Uint16;
  public native let rig: ResourceRef; // rRef<animRig>
  public native let tags: redTagList;
  public native let version: Uint32;
}

public native struct animAnimSetCollection {
  public native let animSets: array<ResourceAsyncRef>;
  public native let overrideAnimSets: array<animOverrideAnimSetRef>;
  public native let animWrapperVariables: array<animAnimWrapperVariableDescription>;
}

public native class animAnimSetEntry extends ISerializable {
  public native let animation: ref<animAnimation>;
  public native let events: ref<animEventsContainer>;
}

public native class animAnimSetEntryAudioData extends ISerializable {
  public native let events: array<ref<animAnimEvent>>;
}

public native struct animAnimSetup {
  public native let cinematics: array<animAnimSetupEntry>;
  public native let gameplay: array<animAnimSetupEntry>;
  public native let hash: Uint64;
}

public native struct animAnimSetupEntry {
  public native let priority: Uint8;
  public native let animSet: ResourceAsyncRef; // raRef<animAnimSet>
  public native let variableNames: array<CName>;
}

public native class animAnimSetupResource extends CResource {
  public native let dependencies: array<ResourceRef>;
}

public native class animAnimsetVariableCondition extends animIRuntimeCondition {
  public native let variableToCompare: CName;
}

public native class animAnimsetWithOverridesTagCondition extends animIRuntimeCondition {
  public native let animsetTags: redTagList;
}

public enum animAnimStateInterpolationType {
  Linear = 0,
  EaseIn = 1,
  EaseOut = 2,
  EaseInOut = 3,
}

public native class animAnimStateMachineConditionalEntry extends ISerializable {
  public native let targetStateIndex: Uint32;
  public native let condition: ref<animIAnimStateTransitionCondition>;
  public native let isEnabled: Bool;
  public native let priority: Int32;
  public native let isForcedToTrue: Bool;
}

public native class animAnimStateTransitionCondition_AnimEnd extends animIAnimStateTransitionCondition {
  public native let eventName: CName;
}

public native class animAnimStateTransitionCondition_AnimEvent extends animIAnimStateTransitionCondition {
  public native let eventName: CName;
}

public native class animAnimStateTransitionCondition_AnyAnimEnd extends animIAnimStateTransitionCondition {}

public native class animAnimStateTransitionCondition_BoolEdgeFeature extends animIAnimStateTransitionCondition {
  public native let featureName: CName;
  public native let featurePropertyName: CName;
}

public native class animAnimStateTransitionCondition_BoolFeature extends animIAnimStateTransitionCondition {
  public native let compareValue: Bool;
  public native let featureName: CName;
  public native let featurePropertyName: CName;
}

public native class animAnimStateTransitionCondition_BoolVariable extends animIAnimStateTransitionCondition {
  public native let variableName: CName;
  public native let compareValue: Bool;
}

public native class animAnimStateTransitionCondition_CompositeSimultaneous extends animIAnimStateTransitionCondition {
  public native let conditions: array<ref<animIAnimStateTransitionCondition>>;
}

public native class animAnimStateTransitionCondition_ExternalEvent extends animIAnimStateTransitionCondition {
  public native let eventName: CName;
}

public native class animAnimStateTransitionCondition_FloatFeature extends animIAnimStateTransitionCondition {
  public native let compareValue: Float;
  public native let featureName: CName;
  public native let featurePropertyName: CName;
  public native let compareFunc: animCompareFunc;
}

public native class animAnimStateTransitionCondition_FloatVariable extends animIAnimStateTransitionCondition {
  public native let variableName: CName;
  public native let compareValue: Float;
  public native let compareFunc: animCompareFunc;
}

public native class animAnimStateTransitionCondition_FootPhaseEvent extends animIAnimStateTransitionCondition {
  public native let footPhase: animEFootPhase;
}

public native class animAnimStateTransitionCondition_HasAnimation extends animIAnimStateTransitionCondition {
  public native let animationName: CName;
}

public native class animAnimStateTransitionCondition_IntEdgeFeature extends animIAnimStateTransitionCondition {
  public native let featureName: CName;
  public native let featurePropertyName: CName;
}

public native class animAnimStateTransitionCondition_IntEdgeFromToFeature extends animAnimStateTransitionCondition_IntEdgeFeature {
  public native let fromValue: Int32;
  public native let toValue: Int32;
}

public native class animAnimStateTransitionCondition_IntEdgeGreaterFromZeroFeature extends animAnimStateTransitionCondition_IntEdgeFeature {
  public native let greaterThenValue: Int32;
}

public native class animAnimStateTransitionCondition_IntEdgeToFeature extends animAnimStateTransitionCondition_IntEdgeFeature {
  public native let toValue: Int32;
}

public native class animAnimStateTransitionCondition_IntFeature extends animIAnimStateTransitionCondition {
  public native let compareValue: Int32;
  public native let featureName: CName;
  public native let featurePropertyName: CName;
  public native let compareFunc: animCompareFunc;
}

public native class animAnimStateTransitionCondition_IntVariable extends animIAnimStateTransitionCondition {
  public native let variableName: CName;
  public native let compareValue: Int32;
  public native let compareFunc: animCompareFunc;
}

public native class animAnimStateTransitionCondition_ModifiedFloatVariable extends animIAnimStateTransitionCondition {
  public native let variableName: CName;
  public native let compareValue: Float;
  public native let compareFunc: animCompareFunc;
}

public native class animAnimStateTransitionCondition_Timed extends animIAnimStateTransitionCondition {
  public native let timeToFireTransition: Float;
}

public native class animAnimStateTransitionCondition_WrapperValue extends animIAnimStateTransitionCondition {
  public native let wrapperName: CName;
  public native let checkIfWrapperIsSet: Bool;
}

public native class animAnimStateTransitionDescription extends ISerializable {
  public native let targetStateIndex: Uint32;
  public native let condition: ref<animIAnimStateTransitionCondition>;
  public native let isEnabled: Bool;
  public native let interpolator: ref<animIAnimStateTransitionInterpolator>;
  public native let duration: Float;
  public native let priority: Int32;
  public native let syncMethod: ref<animISyncMethod>;
  public native let isForcedToTrue: Bool;
  public native let supportBlendFromPose: Bool;
  public native let canRequestInertialization: Bool;
  public native let animFeatureName: CName;
  public native let actionAnimDatabaseRef: ResourceRef; // rRef<animActionAnimDatabase>
  public native let isOutTransitionFromAction: Bool;
}

public native class animAnimStateTransitionInterpolator_Blend extends animIAnimStateTransitionInterpolator {
  public native let interpolationType: animAnimStateInterpolationType;
}

public native struct animAnimTransformMappingEntry {
  public native let from: CName;
  public native let to: CName;
}

public abstract native class animAnimVariable extends ISerializable {
  public native let name: CName;
}

public native class animAnimVariableBool extends animAnimVariable {
  public native let value: Bool;
  public native let default: Bool;
}

public native class animAnimVariableContainer extends ISerializable {
  public native let boolVariables: array<ref<animAnimVariableBool>>;
  public native let intVariables: array<ref<animAnimVariableInt>>;
  public native let floatVariables: array<ref<animAnimVariableFloat>>;
  public native let vectorVariables: array<ref<animAnimVariableVector>>;
  public native let quaternionVariables: array<ref<animAnimVariableQuaternion>>;
  public native let transformVariables: array<ref<animAnimVariableTransform>>;
}

public native class animAnimVariableFloat extends animAnimVariable {
  public native let value: Float;
  public native let default: Float;
  public native let min: Float;
  public native let max: Float;
}

public native class animAnimVariableInt extends animAnimVariable {
  public native let value: Int32;
  public native let default: Int32;
  public native let min: Int32;
  public native let max: Int32;
}

public native class animAnimVariableQuaternion extends animAnimVariable {
  public native let roll: Float;
  public native let pitch: Float;
  public native let yaw: Float;
  public native let default: Quaternion;
}

public native class animAnimVariableTransform extends animAnimVariable {
  public native let value: QsTransform;
  public native let default: QsTransform;
}

public native class animAnimVariableVector extends animAnimVariable {
  public native let x: Float;
  public native let y: Float;
  public native let z: Float;
  public native let w: Float;
  public native let default: Vector4;
  public native let min: Vector4;
  public native let max: Vector4;
}

public native struct animAnimWrapperVariableDescription {
  public native let variableName: CName;
  public native let defaultValue: Float;
}

public enum animAxis {
  X = 0,
  Y = 1,
  Z = 2,
  NegativeX = 3,
  NegativeY = 4,
  NegativeZ = 5,
}

public native struct animBoneCorrection {
  public native let boneName: CName;
  public native let additiveCorrection: Quaternion;
}

public native class animBoneTraceCondition extends ISerializable {
  public native let boneIndex: Int16;
  public native let traceByRotation: Bool;
  public native let rotationAngleTolerance: Float;
  public native let traceByTranslation: Bool;
  public native let translationTolerance: Float;
}

public native struct animBoolLink {
  public native let node: wref<animAnimNode_BoolValue>;
}

public native class animCAnimationBufferBitwiseCompressed extends animIAnimationBuffer {
  public native let version: Uint32;
  public native let bones: array<animSAnimationBufferBitwiseCompressedBoneTrack>;
  public native let tracks: array<animSAnimationBufferBitwiseCompressedData>;
  public native let data: array<Int8>;
  public native let fallbackData: array<Int8>;
  public native let orientationCompressionMethod: SAnimationBufferOrientationCompressionMethod;
  public native let duration: Float;
  public native let numFrames: Uint32;
  public native let dt: Float;
  public native let streamingOption: SAnimationBufferStreamingOption;
  public native let nonStreamableBones: Uint32;
  public native let extraDataNames: array<CName>;
  public native let numExtraBones: Uint32;
}

public native class animCAnimationBufferUncompressed extends animIAnimationBuffer {
  public native let transforms: array<array<QsTransform>>;
  public native let tracks: array<array<Float>>;
  public native let duration: Float;
}

public enum animClampType {
  None = 0,
  Clamp = 1,
  WrappedClamp = 2,
}

public native struct animCollisionRoundedShape {
  public native let bone: animTransformIndex;
  public native let transformLS: QsTransform;
  public native let roundedCornerRadius: Float;
  public native let xBoxExtent: Float;
  public native let yBoxExtent: Float;
  public native let zBoxExtent: Float;
}

public native class animCollisionShapesCollection extends ISerializable {
  public native let collisionRoundedShapes: array<animCollisionRoundedShape>;
}

public native struct animCompareBone {
  public native let boneName: CName;
  public native let boneRotationLs: Quaternion;
}

public enum animCompareFunc {
  Equal = 0,
  NotEqual = 1,
  Less = 2,
  LessEqual = 3,
  Greater = 4,
  GreaterEqual = 5,
}

public native class animComponentTagCondition extends animIStaticCondition {
  public native let animTag: CName;
}

public enum animcompressionBufferTypePreset {
  Spline = 0,
  SIMD = 1,
  TestRaw = 2,
}

public enum animcompressionFrameratePreset {
  USE_30_HZ = 0,
  USE_15_HZ = 1,
  USE_10_HZ = 2,
}

public enum animcompressionQualityPreset {
  CINEMATIC_HIGH = 3,
  HIGH = 0,
  MID = 1,
  LOW = 2,
}

public native struct animConditionalSegmentCondition {
  public native let lod: Int32;
  public native let group: CName;
  public native let name: CName;
  public native let animFeatureValue: Bool;
}

public enum animConstraintWeightMode {
  Static = 0,
  FloatTrack = 1,
}

public native struct animCorrectivePoseEntry {
  public native let comparePose: CName;
  public native let correctivePose: CName;
  public native let jointsToCompare: array<CName>;
  public native let enabled: Bool;
}

public enum animCoverBehavior {
  Idle = 0,
  PreAction = 1,
  DoAction = 2,
  PostAction = 3,
}

public enum animCoverStance {
  None = 0,
  LowLeft = 1,
  HighLeft = 2,
  LowRight = 3,
  HighRight = 4,
}

public native struct animCurvePathAnimControllerPreset {
  public native let name: CName;
  public native let leftAnimationName: CName;
  public native let forwardAnimationName: CName;
  public native let rightAnimationName: CName;
}

public native struct animCurvePathBakerAdvancedUserInput {
  public native let partsInputs: [animCurvePathPartInput; 3];
}

public native struct animCurvePathBakerUserInput {
  public native let controllersSetupName: CName;
  public native let useStart: Bool;
  public native let useStop: Bool;
  public native let blendTime: Float;
}

public native struct animCurvePathControllersSetup {
  public native let name: CName;
  public native let startControllerName: CName;
  public native let mainControllerName: CName;
  public native let stopControllerName: CName;
}

public native struct animCurvePathPartInput {
  public native let curveLengthStart: Float;
  public native let curveLengthEnd: Float;
  public native let controllerName: CName;
  public native let eventNameStart: CName;
  public native let eventNameEnd: CName;
  public native let startBlendTime: Float;
}

public abstract native class animDangleConstraint_Simulation extends ISerializable {
  public native let collisionRoundedShapes: array<animCollisionRoundedShape>;
  public native let jsonCollisionShapes: ResourceRef; // rRef<JsonResource>
  public native let jsonCollisionShapesLoadedSuccessfully: Bool;
  public native let alpha: Float;
  public native let rotateParentToLookAtDangle: Bool;
  public native let parentRotationAltersTransformsOfDangleAndItsChildren: Bool;
  public native let parentRotationAltersTransformsOfNonDanglesAndItsChildren: Bool;
  public native let dangleAltersTransformsOfItsChildren: Bool;
}

public native class animDangleConstraint_SimulationDyng extends animDangleConstraint_Simulation {
  public native let HACK_checkDangleTeleport: Bool;
  public native let substepTime: Float;
  public native let solverIterations: Uint32;
  public native let particlesContainer: animDyngParticlesContainer;
  public native let dyngConstraint: ref<animIDyngConstraint>;
}

public native class animDangleConstraint_SimulationPendulum extends animDangleConstraint_SimulationSingleBone {
  public native let constraintType: animPendulumConstraintType;
  public native let halfOfMaxApertureAngle: Float;
  public native let mass: Float;
  public native let damping: Float;
  public native let pullForceFactor: Float;
  public native let pullForceDirectionLS: Vector3;
  public native let externalForceWS: Vector3;
  public native let externalForceWsLink: animVectorLink;
  public native let collisionCapsuleRadius: Float;
  public native let collisionCapsuleHeightExtent: Float;
  public native let cosOfHalfMaxApertureAngle: Float;
  public native let cosOfHalfOfHalfMaxApertureAngle: Float;
  public native let sinOfHalfOfHalfMaxApertureAngle: Float;
  public native let invertedMass: Float;
  public native let simulationFps: Float;
  public native let gravityWS: Float;
  public native let projectionType: animPendulumProjectionType;
  public native let constraintOrientation: Vector3;
  public native let cosOfHalfXAngle: Float;
  public native let cosOfHalfYAngle: Float;
  public native let cosOfHalfZAngle: Float;
  public native let sinOfHalfXAngle: Float;
  public native let sinOfHalfYAngle: Float;
  public native let sinOfHalfZAngle: Float;
}

public native class animDangleConstraint_SimulationPositionProjection extends animDangleConstraint_SimulationSingleBone {
  public native let collisionCapsuleRadius: Float;
  public native let collisionCapsuleHeightExtent: Float;
  public native let collisionCapsuleAxisLS: Vector3;
  public native let directionReferenceBone: animTransformIndex;
  public native let projectionType: animPositionProjectionType;
}

public abstract native class animDangleConstraint_SimulationSingleBone extends animDangleConstraint_Simulation {
  public native let dangleBone: animTransformIndex;
}

public native class animDangleConstraint_SimulationSpring extends animDangleConstraint_SimulationSingleBone {
  public native let constraintSphereRadius: Float;
  public native let constraintScale1: Float;
  public native let constraintScale2: Float;
  public native let mass: Float;
  public native let damping: Float;
  public native let pullForceFactor: Float;
  public native let externalForceWS: Vector3;
  public native let externalForceWsLink: animVectorLink;
  public native let collisionSphereRadius: Float;
  public native let invertedMass: Float;
  public native let simulationFps: Float;
  public native let gravityWS: Float;
  public native let pullForceOriginLS: Vector3;
  public native let projectionType: animSpringProjectionType;
  public native let constraintOrientation: Vector2;
  public native let cosOfHalfXAngle: Float;
  public native let cosOfHalfYAngle: Float;
  public native let sinOfHalfXAngle: Float;
  public native let sinOfHalfYAngle: Float;
}

public native class AnimDataChanged extends Event {}

public native class AnimDurationFeature extends AnimFeature {
  public native let duration: Float;
}

public native class animDyngConstraintCone extends animIDyngConstraint {
  public native let constrainedBone: animTransformIndex;
  public native let coneAttachmentBone: animTransformIndex;
  public native let coneTransformLS: QsTransform;
  public native let constraintType: animPendulumConstraintType;
  public native let halfOfMaxApertureAngle: Float;
  public native let projectionType: animPendulumProjectionType;
  public native let collisionCapsuleRadius: Float;
  public native let collisionCapsuleHeightExtent: Float;
}

public native class animDyngConstraintEllipsoid extends animIDyngConstraint {
  public native let bone: animTransformIndex;
  public native let ellipsoidTransformLS: QsTransform;
  public native let constraintRadius: Float;
  public native let constraintScale1: Float;
  public native let constraintScale2: Float;
}

public native class animDyngConstraintLink extends animIDyngConstraint {
  public native let bone1: animTransformIndex;
  public native let bone2: animTransformIndex;
  public native let linkType: animDyngConstraintLinkType;
  public native let lengthLowerBoundRatioPercentage: Float;
  public native let lengthUpperBoundRatioPercentage: Float;
  public native let lookAtAxis: Vector3;
}

public enum animDyngConstraintLinkType {
  KeepFixedDistance = 0,
  KeepVariableDistance = 1,
  Greater = 2,
  Closer = 3,
}

public native class animDyngConstraintMulti extends animIDyngConstraint {
  public native let innerConstraints: array<ref<animIDyngConstraint>>;
}

public native struct animDyngParticle {
  public native let mass: Float;
  public native let damping: Float;
  public native let pullForceFactor: Float;
  public native let isFree: Bool;
  public native let bone: animTransformIndex;
  public native let collisionCapsuleRadius: Float;
  public native let collisionCapsuleHeightExtent: Float;
  public native let collisionCapsuleAxisLS: Vector3;
  public native let projectionType: animDyngParticleProjectionType;
}

public enum animDyngParticleProjectionType {
  Disabled = 0,
  ShortestPath = 1,
  Directed = 2,
}

public native struct animDyngParticlesContainer {
  public native let externalForceWS: Vector3;
  public native let externalForceWsLink: animVectorLink;
  public native let particles: array<animDyngParticle>;
  public native let gravityWS: Float;
}

public enum animEAnimGraphAdditiveType {
  AGAT_Local = 0,
  AGAT_Ref = 1,
}

public enum animEAnimGraphCompareFunc {
  AGCF_Equal = 0,
  AGCF_NotEqual = 1,
  AGCF_Less = 2,
  AGCF_LessEqual = 3,
  AGCF_Greater = 4,
  AGCF_GreaterEqual = 5,
}

public enum animEAnimGraphLogicOp {
  AGLO_Or = 0,
  AGLO_And = 1,
}

public enum animEAnimGraphMathInterpolation {
  AGMI_LINEAR = 0,
  AGMI_SIN = 1,
  AGMI_BEZIER = 2,
}

public enum animEAnimGraphMathOp {
  AGMO_Add = 0,
  AGMO_Subtract = 1,
  AGMO_Multiply = 2,
  AGMO_Divide = 3,
  AGMO_SafeDivide = 4,
  AGMO_ATan = 5,
  AGMO_AngleDiff = 6,
  AGMO_Length = 7,
  AGMO_Abs = 8,
}

public enum animEBlendFromPoseMode {
  BFPM_AlwaysOnActivation = 0,
  BFPM_RequestedByTag = 1,
}

public enum animEBlendTracksMode {
  AGBT_BasePose = 0,
  AGBT_Interpolate = 1,
  AGBT_Add = 2,
}

public enum animEBlendTypeLBC {
  Linear = 0,
  Smoothstep = 1,
  CustomCurve = 2,
}

public enum animEDirectionToEuler {
  Pitch = 0,
  Yaw = 1,
  Roll = 2,
}

public enum animEFootPhase {
  RightUp = 0,
  RightForward = 1,
  LeftUp = 2,
  LeftForward = 3,
  NotConsidered = 4,
}

public enum animEInterpolationType {
  Lerp = 0,
  Slerp = 1,
}

public enum animEMotionExtractionCompressionType {
  EMECT_LINEAR = 6,
  EMECT_SPLINE_LOW = 4,
  EMECT_SPLINE_MID = 2,
  EMECT_SPLINE_HIGH = 5,
  EMECT_UNCOMPRESSED = 0,
  EMECT_UNCOMPRESSED_ALL_ANGLES = 3,
  EMECT_UNCOMPRESSED_2D = 7,
  EMECT_UNCOMPRESSED_3D_FALLBACKING = 8,
  EMECT_UNCOMPRESSED_ALL_ANGLES_FALLBACKING = 9,
}

public enum animEResetTypeNode {
  RT_Reference = 0,
  RT_Indentity = 1,
}

public enum animESpace {
  Local = 0,
  Model = 1,
  World = 2,
}

public enum animESpaceMW {
  Model = 0,
  World = 1,
}

public enum animETransformAxis {
  X_Axis = 1,
  Y_Axis = 2,
  Z_Axis = 4,
}

public enum animEVectorWsToMsType {
  Position = 0,
  Direction = 1,
}

public enum animEventFilterType {
  Default = 0,
  AlwaysCollect = 1,
  Solo = 2,
  Mute = 3,
}

public native class animEventsContainer extends ISerializable {
  public native let events: array<ref<animAnimEvent>>;
}

public enum animEventSide {
  Left = 0,
  Right = 1,
}

public native class animFacialCustomizationSet extends CResource {
  public native let baseSetup: ResourceRef; // rRef<animFacialSetup>
  public native let targetSetups: array<ResourceAsyncRef>;
  public native let targetSetupsTemp: array<animFacialCustomizationTargetEntryTemp>;
  public native let numTargets: Uint32;
  public native let posesInfo: animFacialSetup_PosesBufferInfo;
  public native let jointRegions: array<Uint8>;
  public native let usedTransformIndices: array<Uint16>;
  public native let numJoints: Uint32;
  public native let isCooked: Bool;
}

public native struct animFacialCustomizationTargetEntryTemp {
  public native let setup: ResourceAsyncRef; // raRef<animFacialSetup>
  public native let targetNames: array<CName>;
}

public native struct animFacialEmotionTransitionBaked {
  public native let toIdleMale: CName;
  public native let facialKey_Male: CName;
  public native let toIdleFemale: CName;
  public native let facialKey_Female: CName;
  public native let transitionType: animFacialEmotionTransitionType;
  public native let transitionDuration: Float;
  public native let timeScale: Float;
  public native let toIdleWeight: Float;
  public native let toIdleNeckWeight: Float;
  public native let facialKeyWeight: Float;
  public native let customTransitionAnim: CName;
}

public native struct animFacialEmotionTransitionEditData {
  public native let toIdleMale: CName;
  public native let facialKeyMale: CName;
  public native let toIdleFemale: CName;
  public native let facialKeyFemale: CName;
  public native let transitionType: animFacialEmotionTransitionType;
  public native let toIdleWeight: Float;
  public native let toIdleNeckWeight: Float;
  public native let facialKeyWeight: Float;
  public native let customTransitionAnim: CName;
}

public enum animFacialEmotionTransitionType {
  Natural = 0,
  Fast = 1,
  Blend = 2,
  Instant = 3,
  Custom = 4,
}

public native struct animFacialSetup_BufferInfo {
  public native let tracksMapping: animFacialSetup_TracksMapping;
  public native let numLipsyncOverridesIndexMapping: Uint16;
  public native let numJointRegions: Uint16;
  public native let face: animFacialSetup_OneSermoBufferInfo;
  public native let eyes: animFacialSetup_OneSermoBufferInfo;
  public native let tongue: animFacialSetup_OneSermoBufferInfo;
}

public native struct animFacialSetup_OneSermoBufferInfo {
  public native let numGlobalLimits: Uint16;
  public native let numInfluencedPoses: Uint16;
  public native let numInfluenceIndices: Uint16;
  public native let numUpperLowerFace: Uint16;
  public native let numLipsyncPosesSides: Uint16;
  public native let numAllCorrectives: Uint16;
  public native let numGlobalCorrectiveEntries: Uint16;
  public native let numInbetweenCorrectiveEntries: Uint16;
  public native let numCorrectiveInfluencedPoses: Uint16;
  public native let numCorrectiveInfluenceIndices: Uint16;
  public native let numAllMainPoses: Uint16;
  public native let numAllMainPosesInbetweens: Uint16;
  public native let numAllMainPosesInbetweenScopeMultipliers: Uint16;
  public native let numEnvelopesPerTrackMapping: Uint16;
  public native let wrinkleStartingIndex: Uint16;
  public native let numWrinkles: Uint16;
}

public native struct animFacialSetup_OneSermoPoseBufferInfo {
  public native let numMainPoses: Uint16;
  public native let numCorrectivePoses: Uint16;
  public native let numMainTransforms: Uint32;
  public native let numMainScales: Uint32;
  public native let numCorrectiveTransforms: Uint32;
  public native let numCorrectiveScales: Uint32;
}

public native struct animFacialSetup_PosesBufferInfo {
  public native let face: animFacialSetup_OneSermoPoseBufferInfo;
  public native let tongue: animFacialSetup_OneSermoPoseBufferInfo;
  public native let eyes: animFacialSetup_OneSermoPoseBufferInfo;
}

public native struct animFacialSetup_TracksMapping {
  public native let numEnvelopes: Uint16;
  public native let numMainPoses: Uint16;
  public native let numLipsyncOverrides: Uint16;
  public native let numWrinkles: Uint16;
}

public native class animFacialSetup extends CResource {
  public native let rig: ResourceRef; // rRef<animRig>
  public native let inputRig: ResourceRef; // rRef<animRig>
  public native let info: animFacialSetup_BufferInfo;
  public native let posesInfo: animFacialSetup_PosesBufferInfo;
  public native let usedTransformIndices: array<Uint16>;
  public native let useFemaleAnimSet: Bool;
  public native let version: Uint32;
}

public native class AnimFeature_Bump extends AnimFeature {
  public native let direction: Float;
  public native let source: Float;
  public native let intensity: Float;
  public native let isBumping: Bool;
  public native let bumpType: Int32;
}

public native class AnimFeature_Climb extends AnimFeature {
  public native let verticalPosition: Vector4;
  public native let horizontalPosition: Vector4;
  public native let toVerticalTime: Float;
  public native let verticalToHorizontalTime: Float;
  public native let frontEdgePosition: Vector4;
  public native let frontEdgeNormal: Vector4;
  public native let yawAngle: Float;
  public native let stateLength: Float;
  public native let climbType: Int32;
  public native let state: Int32;
  public final native func SetFrontEdgeNormal()
  public final native func SetFrontEdgePosition()
  public final native func SetHorizontalPosition()
  public final native func SetVerticalPosition()
  public final native func SetVerticalToHorizontalTime()
}

public native class AnimFeature_DeviceCameraControlled extends AnimFeature {
  public native let currentRotation: Vector4;
}

public native class AnimFeature_DroneLocomotion extends AnimFeature {
  public native let speed: Float;
  public native let angularSpeed: Float;
  public native let lookAtAngle: Float;
  public native let desiredSpeed: Float;
  public native let pathCurvative: Float;
}

public native class AnimFeature_HitReactions extends AnimFeature {
  public native let hitDirection: Vector4;
  public native let hitIntensity: Float;
  public native let hitType: Int32;
  public native let hitBodyPart: Int32;
  public final native func Hit()
}

public native class AnimFeature_Ladder extends AnimFeature {
  public native let state: Int32;
  public native let transitionType: Int32;
  public native let distanceFromTop: Float;
  public native let entryFromRight: Bool;
}

public native class AnimFeature_Locomotion extends AnimFeature {
  public native let action: Int32;
  public native let style: Int32;
  public native let pathCurvature: Float;
  public native let inclineAngle: Float;
  public native let groundAngle: Float;
  public native let animDeltaZ: Float;
  public native let animationPlaybackTime: Float;
  public native let footScaleFactor: Float;
  public native let directionalStartAngle: Float;
  public native let speedProgress: Float;
  public native let isOnStairs: Bool;
  public native let areAnimWrappersUnlocked: Bool;
}

public native class AnimFeature_Loot extends AnimFeature {
  public native let opened: Bool;
  public native let transitionDuration: Float;
  public final native func SetOpened()
  public final native func SetTransitionDuration()
}

public native class AnimFeature_PhotomodeBodyPartRotate extends AnimFeature {
  public native let rotateDegree: Float;
}

public native class AnimFeature_PhotomodePoseCategory extends AnimFeature {
  public native let poseCategoryIndex: Int32;
}

public native class AnimFeature_PlayerCover extends AnimFeature {
  public native let cameraPositionMS: Vector4;
  public native let coverState: Int32;
  public native let leanAmount: Float;
  public native let cameraOffsetAmount: Float;
  public native let autoCoverActivationFrame: Bool;
}

public native class AnimFeature_PlayerSpatialAwareness extends AnimFeature {
  public native let leftClosestVector: Vector4;
  public native let rightClosestVector: Vector4;
  public native let upHitPosition: Vector4;
  public native let forwardDistance: Float;
  public final native func SetForwardDistance()
  public final native func SetLeftClosestVector()
  public final native func SetRightClosestVector()
  public final native func SetSetUpHitPosition()
}

public native class AnimFeature_Vault extends AnimFeature_Climb {
  public native let landPosition: Vector4;
  public native let travellingTime: Float;
  public native let obstacleDepth: Float;
  public final native func SetObstacleDepth()
  public final native func SetTravellingTime()
  public final native func SetlandPosition()
}

public native class AnimFeature_WallRun extends AnimFeature {
  public native let wallOnRightSide: Bool;
  public native let wallPosition: Vector4;
  public native let wallNormal: Vector4;
  public final native func SetWallOnRightSide()
}

public native class AnimFeaturePlaySlotAnim extends AnimFeature {
  public native let slotName: CName;
  public native let animationName: CName;
  public native let blendInTime: Float;
  public native let blendOutTime: Float;
  public native let speedMultiplier: Float;
  public native let startOffsetRelative: Float;
  public native let playAsAdditive: Bool;
  public native let enableMotion: Bool;
  public native let numberOfLoops: Int32;
  public final native func SetSlotName()
}

public native class AnimFeatureWorkspotExitAnim extends AnimFeature {}

public native class AnimFeatureWorkspotInertializationAnim extends AnimFeature {
  public native let duration: Float;
}

public native struct animFloatClamp {
  public native let useMin: Bool;
  public native let min: Float;
  public native let useMax: Bool;
  public native let max: Float;
}

public native struct animFloatLink {
  public native let node: wref<animAnimNode_FloatValue>;
}

public native struct animFloatTrackInfo {
  public native let name: CName;
  public native let referenceValue: Float;
}

public enum animFloatTrackOperationType {
  Override = 0,
  Multiply = 1,
  Add = 2,
  Subtract = 3,
  SubtractSwapped = 4,
  WeightComplement = 5,
}

public native struct animfssBodyOfflineParams {
  public native let HipsTilt: Float;
  public native let HipsShift: Float;
  public native let LegsPullFactorMin: Float;
  public native let LegsPullFactorMax: Float;
  public native let LegLengthAdjustment: Float;
  public native let LegMaxStretchOffset: Float;
  public native let LegMaxStretchAdjustment: Float;
}

public native struct animGenericAnimDatabase_AnimationData {
  public native let animationName: CName;
  public native let fallbackAnimationName: CName;
  public native let streamingContext: CName;
}

public native struct animGenericAnimDatabase_DatabaseRow {
  public native let inputValues: array<Int32>;
  public native let animationData: animGenericAnimDatabase_AnimationData;
}

public native class animGenericAnimDatabase extends CResource {
  public native let rows: array<animGenericAnimDatabase_DatabaseRow>;
}

public native struct AnimGraphResourceContainerEntry {
  public native let graphName: CName;
  public native let animGraphResource: ResourceRef; // rRef<animAnimGraph>
}

public native struct animGraphSlotCondition {
  public native let condition: ref<animIStaticCondition>;
  public native let graph: ResourceRef; // rRef<animAnimGraph>
}

public native class animHasAnimationCondition extends animIStaticCondition {
  public native let animationName: CName;
}

public native struct animHipsIkRequest {
  public native let leftLegIkChain: CName;
  public native let rightLegIkChain: CName;
  public native let hipsTransformIndex: animTransformIndex;
  public native let leftFootTransformIndex: animTransformIndex;
  public native let rightFootTransformIndex: animTransformIndex;
}

public abstract native class animIAnimationBuffer extends ISerializable {}

public abstract native struct animIAnimBreakpoint {
  public native let enabled: Bool;
}

public abstract native struct animIAnimDebuggerCommand {}

public abstract native class animIAnimNode_PostProcess extends ISerializable {
  public native let isEnabled: Bool;
}

public abstract native class animIAnimNodeSourceChannel_Float extends ISerializable {}

public abstract native class animIAnimNodeSourceChannel_QsTransform extends ISerializable {}

public abstract native class animIAnimNodeSourceChannel_Quat extends ISerializable {}

public abstract native class animIAnimNodeSourceChannel_Vector extends ISerializable {}

public abstract native class animIAnimStateTransitionCondition extends ISerializable {}

public abstract native class animIAnimStateTransitionInterpolator extends ISerializable {}

public abstract native class animIDyngConstraint extends ISerializable {}

public native class animIKTargetParams_Add extends ISerializable {}

public native class animIKTargetParams_Remove extends ISerializable {}

public native class animIKTargetParams_Update extends ISerializable {}

public abstract native class animIMotionExtraction extends ISerializable {}

public abstract native class animIMotionTableProvider extends ISerializable {
  public native let id: Int32;
  public native let parentId: Int32;
  public native let type: animMotionTableType;
  public native let action: animMotionTableAction;
  public native let parentStaticSwitchBranch: animParentStaticSwitchBranch;
}

public native struct animImportFacialCorrectivePoseDataDesc {
  public native let transforms: array<animImportFacialTransform>;
  public native let transformsNoScale: array<animImportFacialTransformNoScale>;
  public native let transformIds: array<Uint16>;
  public native let transformNames: array<CName>;
  public native let parentsWeights: array<Float>;
}

public native struct animImportFacialCorrectivePoseDesc {
  public native let influencedBy: array<CName>;
  public native let influenceMainWeightIndices: array<Uint16>;
  public native let poses: array<animImportFacialCorrectivePoseDataDesc>;
  public native let parentsInBetweenIndices: array<Int16>;
  public native let parentIndices: array<Uint16>;
  public native let name: CName;
  public native let index: Uint16;
  public native let influencedBySpeed: Uint8;
  public native let poseType: Uint8;
  public native let poseLOD: Uint8;
  public native let weights: array<Float>;
  public native let inBetweenScopeMultipliers: array<Float>;
  public native let linearCorrection: Bool;
  public native let useGlobalWeight: Bool;
}

public native struct animImportFacialInitialControlsDesc {
  public native let transformIds: array<Uint16>;
  public native let transformNames: array<CName>;
  public native let transformRegions: array<Uint8>;
}

public native struct animImportFacialInitialPoseEntryDesc {
  public native let poseName: CName;
  public native let id: Int16;
  public native let weight: Float;
  public native let type: Uint8;
  public native let side: Uint8;
  public native let isCachable: Bool;
  public native let initAnimationPoseMid: Float;
  public native let initAnimationPoseMin: Float;
  public native let initAnimationPoseMax: Float;
}

public native struct animImportFacialInitialPoseWeightDesc {
  public native let poseNames: array<CName>;
  public native let weights: array<Float>;
}

public native struct animImportFacialMainPoseDesc {
  public native let influencedBy: array<CName>;
  public native let influenceMainWeightIndices: array<Uint16>;
  public native let poses: array<animImportFacialPoseDesc>;
  public native let poseIndices: array<Uint16>;
  public native let weights: array<Float>;
  public native let inBetweenScopeMultipliers: array<Float>;
  public native let name: CName;
  public native let index: Uint16;
  public native let influenceType: Uint8;
  public native let side: Uint8;
  public native let facePart: Uint8;
}

public native struct animImportFacialPoseDesc {
  public native let transforms: array<animImportFacialTransform>;
  public native let transformsNoScale: array<animImportFacialTransformNoScale>;
  public native let transformIds: array<Uint16>;
  public native let transformNames: array<CName>;
}

public native struct animImportFacialSetupCombinedDesc {
  public native let face: animImportFacialSetupDesc;
  public native let eyes: animImportFacialSetupDesc;
  public native let tongue: animImportFacialSetupDesc;
  public native let usedTransformIndices: array<Uint16>;
  public native let lipsyncOverrideToMainPosesTracksMapping: array<Int16>;
  public native let firstLipsyncOverrideTrackIndex: Int16;
}

public native struct animImportFacialSetupDesc {
  public native let initialPose: array<animImportFacialInitialPoseEntryDesc>;
  public native let initialControls: animImportFacialInitialControlsDesc;
  public native let mainPoses: array<animImportFacialMainPoseDesc>;
  public native let mainPosesInfo: array<animSermoPoseInfo>;
  public native let jawAreaTrackIndices: array<Int16>;
  public native let lipsAreaTrackIndices: array<Int16>;
  public native let eyesAreaTrackIndices: array<Int16>;
  public native let numCachedPoseTracks: Uint16;
  public native let correctivePoses: array<animImportFacialCorrectivePoseDesc>;
  public native let globalPoseLimits: array<animPoseLimitWeights>;
  public native let wrinkleStartingIndex: Uint16;
  public native let wrinkleMapping: array<Uint16>;
}

public native struct animImportFacialTransform {
  public native let rotation: Quaternion;
  public native let translation: Vector3;
  public native let scale: Vector3;
}

public native struct animImportFacialTransformNoScale {
  public native let rotation: Quaternion;
  public native let translation: Vector3;
}

public native struct animInertializationFloatClamp {
  public native let isActive: Bool;
  public native let min: Float;
  public native let max: Float;
}

public native struct animInertializationRotationLimit {
  public native let constrainedTransform: animTransformIndex;
  public native let limitOnX: animInertializationFloatClamp;
  public native let limitOnY: animInertializationFloatClamp;
  public native let limitOnZ: animInertializationFloatClamp;
}

public native class AnimInputSetterQuaternion extends AnimInputSetter {
  public native let value: Quaternion;
}

public native struct animIntLink {
  public native let node: wref<animAnimNode_IntValue>;
}

public abstract native class animIPoseBlendMethod extends ISerializable {}

public abstract native class animIRigIkSetup extends ISerializable {
  public native let name: CName;
}

public abstract native class animIRuntimeCondition extends ISerializable {}

public abstract native class animIStaticCondition extends ISerializable {}

public abstract native class animISyncMethod extends ISerializable {}

public enum animLeg {
  Left = 0,
  Right = 1,
}

public native class animLinearCompressedMotionExtraction extends animIMotionExtraction {
  public native let duration: Float;
  public native let rotFrames: array<Quaternion>;
  public native let posFrames: array<Vector3>;
  public native let rotTime: array<Float>;
  public native let posTime: array<Float>;
}

public native class animLipsyncMapping extends CResource {
  public native let languageCodeName: CName;
  public native let scenePaths: array<Uint64>;
  public native let sceneEntries: array<animLipsyncMappingSceneEntry>;
}

public native struct animLipsyncMappingSceneEntry {
  public native let actorVoiceTags: array<CRUID>;
  public native let animSets: array<ResourceAsyncRef>;
}

public enum animLocomotion_AnimType {
  None = 0,
  idle_stand = 1,
  idle_to_idle_0 = 2,
  idle_to_idle_090 = 3,
  idle_to_idle_270 = 4,
  idle_to_idle_180_l = 5,
  idle_to_idle_180_r = 6,
  walk_0 = 7,
  walk_left = 8,
  walk_right = 9,
  jog_0 = 10,
  jog_left = 11,
  jog_right = 12,
  sprint_0 = 13,
  sprint_left = 14,
  sprint_right = 15,
  idle_to_walk_0 = 16,
  idle_to_jog_0 = 17,
  idle_to_sprint_0 = 18,
  walk_to_idle_0 = 19,
  jog_to_idle_0 = 20,
  sprint_to_idle_0 = 21,
  walk_to_idle_0_l_hard = 22,
  walk_to_idle_0_r_hard = 23,
  jog_to_idle_0_l_hard = 24,
  jog_to_idle_0_r_hard = 25,
  sprint_to_idle_0_l_hard = 26,
  sprint_to_idle_0_r_hard = 27,
  walk_to_jog_0 = 28,
  walk_to_sprint_0 = 29,
  jog_to_walk_0 = 30,
  jog_to_sprint_0 = 31,
  sprint_to_walk_0 = 32,
  sprint_to_jog_0 = 33,
  idle_turn_to_walk_090 = 34,
  idle_turn_to_walk_180_l = 35,
  idle_turn_to_walk_180_r = 36,
  idle_turn_to_walk_270 = 37,
  idle_turn_to_jog_090 = 38,
  idle_turn_to_jog_180_l = 39,
  idle_turn_to_jog_180_r = 40,
  idle_turn_to_jog_270 = 41,
  idle_turn_to_sprint_090 = 42,
  idle_turn_to_sprint_180_l = 43,
  idle_turn_to_sprint_180_r = 44,
  idle_turn_to_sprint_270 = 45,
  walk_180 = 46,
  jog_180 = 47,
  walk_0_to_walk_180_l = 48,
  walk_0_to_walk_180_r = 49,
  walk_180_to_walk_0_l = 50,
  walk_180_to_walk_0_r = 51,
  idle_to_walk_180 = 52,
  idle_to_jog_180 = 53,
  walk_to_idle_180 = 54,
  jog_to_idle_180 = 55,
  jog_0_to_jog_180_l = 56,
  jog_0_to_jog_180_r = 57,
  jog_180_to_jog_0_l = 58,
  jog_180_to_jog_0_r = 59,
  jog_to_sprint_180 = 60,
  walk_to_jog_180 = 61,
  jog_to_walk_180 = 62,
  idle_to_walk_090 = 63,
  idle_to_walk_270 = 64,
  walk_090 = 65,
  walk_270 = 66,
  walk_to_idle_090 = 67,
  walk_to_idle_270 = 68,
  walk_0_to_walk_090 = 69,
  walk_0_to_walk_270 = 70,
  walk_180_to_walk_090 = 71,
  walk_180_to_walk_270 = 72,
  walk_090_to_walk_0 = 73,
  walk_270_to_walk_0 = 74,
  walk_090_to_walk_180 = 75,
  walk_270_to_walk_180 = 76,
  walk_090_to_walk_270_l = 77,
  walk_090_to_walk_270_r = 78,
  walk_270_to_walk_090_l = 79,
  walk_270_to_walk_090_r = 80,
  walk_0_down_stairs = 81,
  walk_0_up_stairs = 82,
  walk_0_down_slope = 83,
  walk_0_up_slope = 84,
  jog_0_down_stairs = 85,
  jog_0_up_stairs = 86,
  jog_0_down_slope = 87,
  jog_0_up_slope = 88,
  sprint_0_down_stairs = 89,
  sprint_0_up_stairs = 90,
  sprint_0_down_slope = 91,
  sprint_0_up_slope = 92,
  walk_090_up_stairs = 93,
  walk_090_down_stairs = 94,
  walk_270_up_stairs = 95,
  walk_270_down_stairs = 96,
  walk_180_up_stairs = 97,
  walk_180_down_stairs = 98,
  idle_step_single_0 = 99,
  idle_step_single_090 = 100,
  idle_step_single_180 = 101,
  idle_step_single_270 = 102,
}

public enum animLocomotion_Style {
  LS_Idle = 0,
  LS_Rotation = 1,
  LS_Walk = 2,
  LS_Jog = 3,
  LS_Sprint = 4,
  LS_Any = 5,
}

public enum animLocomotionDecision {
  LD_None = 0,
  LD_Stop = 1,
  LD_MoveTo = 2,
  LD_Move = 3,
}

public enum animLocoStateType {
  LS_Pre = 0,
  LS_Loop = 1,
}

public native class animLookAtAdditionalPreset_BothArms extends animLookAtAdditionalPreset {
  public native let rightHanded: Bool;
  public native let softLimitAngle: Float;
}

public native class animLookAtAdditionalPreset_Eyes extends animLookAtAdditionalPreset {
  public native let softLimitAngle: Float;
}

public native class animLookAtAdditionalPreset_FullControl extends animLookAtAdditionalPreset {
  public native let useRightHand: Bool;
  public native let attachHandToOtherOne: Bool;
  public native let limits: LookAtLimits;
  public native let suppress: Float;
  public native let mode: Int32;
}

public native class animLookAtAdditionalPreset_LeftArm extends animLookAtAdditionalPreset {
  public native let isAiming: Bool;
  public native let softLimitAngle: Float;
}

public native class animLookAtAdditionalPreset_RightArm extends animLookAtAdditionalPreset {
  public native let isAiming: Bool;
  public native let softLimitAngle: Float;
}

public abstract native class animLookAtAdditionalPreset extends IScriptable {}

public native struct animLookAtAnimationDefinition {
  public native let minTransitionDuration: Float;
  public native let playAnimProbability: Float;
  public native let animDelay: Float;
  public native let animations: array<CName>;
}

public native class animLookAtParams_Add extends ISerializable {}

public native class animLookAtParams_Remove extends ISerializable {}

public native class animLookAtParams_UpdatePositions extends ISerializable {}

public native class animLookAtPreset_DroneHorizontal extends animLookAtPreset {
  public native let softLimitDegrees: Float;
  public native let hardLimitDegrees: Float;
  public native let hardLimitDistance: Float;
  public native let backLimitDegrees: Float;
  public native let suppress: Float;
  public native let mode: Int32;
}

public native class animLookAtPreset_DroneVertical extends animLookAtPreset {
  public native let softLimitDegrees: Float;
  public native let hardLimitDegrees: Float;
  public native let hardLimitDistance: Float;
  public native let backLimitDegrees: Float;
  public native let suppress: Float;
  public native let mode: Int32;
}

public native class animLookAtPreset_Eyes extends animLookAtPreset {
  public native let softLimitAngle: Float;
}

public native class animLookAtPreset_EyesHead extends animLookAtPreset {
  public native let suppressHeadAnimation: Float;
  public native let headMobility: Float;
  public native let softLimitAngle: Float;
}

public native class animLookAtPreset_EyesHeadWithBodyAttached extends animLookAtPreset {
  public native let suppressHeadAnimation: Float;
  public native let headMobility: Float;
  public native let suppressChestAnimation: Float;
  public native let chestMobility: Float;
  public native let softLimitAngle: Float;
}

public native class animLookAtPreset_EyesHeadWithBodyFree extends animLookAtPreset {
  public native let suppressHeadAnimation: Float;
  public native let headMobility: Float;
  public native let suppressChestAnimation: Float;
  public native let chestMobility: Float;
  public native let softLimitAngle: Float;
}

public native class animLookAtPreset_EyesHeadWithBodyFreeForFollower extends animLookAtPreset {
  public native let suppressHeadAnimation: Float;
  public native let headMobility: Float;
  public native let suppressChestAnimation: Float;
  public native let chestMobility: Float;
  public native let softLimitAngle: Float;
}

public native class animLookAtPreset_EyesHeadWithoutSuppress extends animLookAtPreset {
  public native let headMobility: Float;
  public native let softLimitAngle: Float;
}

public native class animLookAtPreset_FullControl extends animLookAtPreset {
  public native let limits: LookAtLimits;
  public native let eyesSuppress: Float;
  public native let eyesMode: Int32;
  public native let headSuppress: Float;
  public native let headMode: Int32;
  public native let headSquareScale: Float;
  public native let chestSuppress: Float;
  public native let chestMode: Int32;
  public native let chestSquareScale: Float;
}

public abstract native class animLookAtPreset extends IScriptable {}

public native struct animLookAtRequestForPart {
  public native let bodyPart: CName;
  public native let request: LookAtRequest;
  public native let attachLeftHandToRightHand: Int32;
  public native let attachRightHandToLeftHand: Int32;
}

public native class animLookAtVehicleRestrictionParams extends ISerializable {}

public native struct animMathExpressionNodeData {
  public native let expression: ref<mathExprExpression>;
  public native let floatSockets: array<animAnimMathExpressionFloatSocket>;
  public native let vectorSockets: array<animAnimMathExpressionVectorSocket>;
  public native let quaternionSockets: array<animAnimMathExpressionQuaternionSocket>;
}

public native class animMixerSlotAddIdleParams extends ISerializable {}

public native class animMixerSlotIdleParams extends ISerializable {}

public native class animMixerSlotParams extends ISerializable {}

public native class animMixerSlotTrajectoryBlendParams extends ISerializable {}

public enum animMotionTableAction {
  MTA_None = 0,
  MTA_Start = 1,
  MTA_Stop = 2,
  MTA_Move = 3,
  MTA_TurnInPlace = 4,
  MTA_TransitionToBackward = 5,
  MTA_BackwardMove = 6,
  MTA_TransitionFromBackward = 7,
  MTA_StrafeLeft = 8,
  MTA_StrafeRight = 9,
  MTA_ForwardToStrafeLeft = 10,
  MTA_ForwardToStrafeRight = 11,
  MTA_StrafeLeftToForward = 12,
  MTA_StrafeRightToForward = 13,
  MTA_BackwardToStrafeLeft = 14,
  MTA_BackwardToStrafeRight = 15,
  MTA_StrafeLeftToBackward = 16,
  MTA_StrafeRightToBackward = 17,
  MTA_BackwardStart = 18,
  MTA_BackwardStop = 19,
  MTA_StrafeLeftStart = 20,
  MTA_StrafeLeftStop = 21,
  MTA_StrafeRightStart = 22,
  MTA_StrafeRightStop = 23,
  MTA_ForwardToWalk = 24,
  MTA_ForwardToJog = 25,
  MTA_ForwardToSprint = 26,
  MTA_HardStopLeftLeg = 27,
  MTA_HardStopRightLeg = 28,
  MTA_RepositionForward = 29,
  MTA_RepositionLeft = 30,
  MTA_RepositionRight = 31,
  MTA_RepositionBackward = 32,
  MTA_Custom = 33,
  MTA_CrowdMove = 34,
  MTA_CrowdMoveSlopes = 35,
  MTA_CrowdMoveStairs = 36,
  MTA_StrafeLeftToStrafeRight = 37,
  MTA_StrafeRightToStrafeLeft = 38,
  MTA_CrowdRelaxedStop = 39,
  MTA_CrowdHardStop = 40,
  MTA_CrowdSprintStop = 41,
  MTA_CrowdFleeStopFront = 42,
  MTA_CrowdFleeStopBack = 43,
  MTA_CrowdRelaxedStart = 44,
  MTA_CrowdFleeStartIdle = 45,
  MTA_CrowdFleeStartMotion = 46,
  MTA_CrowdDirectionalStartFast = 47,
}

public native class animMotionTableProvider_Animation extends animIMotionTableProvider {}

public native class animMotionTableProvider_Default extends animIMotionTableProvider {}

public native class animMotionTableProvider_MasterSlaveBlend extends animIMotionTableProvider {
  public native let masterInputIdx: Uint8;
}

public native class animMotionTableProvider_MultiBlend extends animIMotionTableProvider {}

public native class animMotionTableProvider_StaticSwitch extends animIMotionTableProvider {}

public enum animMotionTableType {
  MTT_None = 0,
  MTT_Walk = 1,
  MTT_Jog = 2,
  MTT_Sprint = 3,
  MTT_Custom = 4,
}

public enum animMotionTag {
  MT_Invalid = 0,
  Walk = 1,
  Jog = 2,
  Sprint = 3,
}

public native struct animMotionWrapper {}

public native struct animMultipleParentConstraint_JsonEntry {
  public native let parentTransform: CName;
  public native let parentWeightMode: animConstraintWeightMode;
  public native let parentStaticWeight: Float;
  public native let parentTrackWeight: CName;
  public native let useComplementWeight: Bool;
  public native let useOffset: Bool;
  public native let offset: QsTransform;
}

public native class animMultipleParentConstraint_JsonProperties extends ISerializable {
  public native let parentsTransforms: array<animMultipleParentConstraint_JsonEntry>;
  public native let transformIndex: CName;
  public native let weightMode: animConstraintWeightMode;
  public native let weight: Float;
  public native let weightFloatTrack: CName;
}

public native struct animNamedTrackIndex {
  public native let name: CName;
}

public native struct animNodeProfileTimerInfo {
  public native let name: CName;
  public native let mode: animNodeProfileTimerMode;
}

public enum animNodeProfileTimerMode {
  Begin = 0,
  End = 1,
}

public native class AnimObstacleDetected extends Event {}

public native struct animOverrideAnimSetRef {
  public native let animSet: ResourceAsyncRef; // raRef<animAnimSet>
  public native let variableName: CName;
}

public native struct animOverrideBlendBoneInfo {
  public native let transformIndex: animTransformIndex;
  public native let weight: Float;
}

public native struct animOverrideBlendTrackInfo {
  public native let track: animNamedTrackIndex;
  public native let weight: Float;
}

public enum animParentStaticSwitchBranch {
  None = 0,
  TrueBranch = 1,
  FalseBranch = 2,
}

public enum animPendulumConstraintType {
  Cone = 0,
  HingePlane = 1,
  HalfCone = 2,
}

public enum animPendulumProjectionType {
  Disabled = 0,
  ShortestPathRotational = 1,
  DirectedRotational = 2,
}

public native class animPlaneUncompressedMotionExtraction extends animIMotionExtraction {
  public native let frames: array<Vector3>;
  public native let duration: Float;
}

public native struct animPoleVectorDetails {
  public native let targetBone: animTransformIndex;
  public native let positionOffset: Vector3;
}

public native class animPoseBlendMethod_BoneBranch extends animIPoseBlendMethod {
  public native let bones: array<animOverrideBlendBoneInfo>;
}

public native class animPoseBlendMethod_Mask extends animIPoseBlendMethod {
  public native let maskName: CName;
}

public native struct animPoseCorrection {
  public native let rbfCoefficient: Float;
  public native let rbfPowValue: Float;
  public native let compareBones: [animCompareBone; 4];
  public native let boneCorrections: [animBoneCorrection; 4];
}

public native struct animPoseCorrectionGroup {
  public native let poseCorrections: [animPoseCorrection; 2];
}

public native struct animPoseCorrectionParams {
  public native let poseCorrectionGroup: animPoseCorrectionGroup;
  public native let blendDuration: Float;
}

public native struct animPoseInfoLogger {
  public native let enabled: Bool;
  public native let showStackTransformsCount: Bool;
  public native let showStackTracksCount: Bool;
  public native let entries: array<ref<animPoseInfoLoggerEntry>>;
}

public native class animPoseInfoLoggerEntry_FloatTrack extends animPoseInfoLoggerEntry {
  public native let floatTrack: animNamedTrackIndex;
  public native let showOnlyWhenPositive: Bool;
}

public native class animPoseInfoLoggerEntry_Transform extends animPoseInfoLoggerEntry {
  public native let transform: animTransformIndex;
  public native let logInModelSpace: Bool;
}

public abstract native class animPoseInfoLoggerEntry extends ISerializable {}

public native struct animPoseLimitWeights {
  public native let min: Float;
  public native let mid: Float;
  public native let max: Float;
  public native let poseTrackIndex: Int16;
  public native let type: Uint8;
  public native let isCachable: Bool;
}

public native struct animPoseLink {
  public native let node: wref<animAnimNode_Base>;
}

public enum animPositionProjectionType {
  Disabled = 0,
  ShortestPath = 1,
  Directional = 2,
}

public native struct animPropSetup {}

public enum animQuaternionInterpolationType {
  Linear = 0,
  Spherical = 1,
}

public native struct animQuaternionLink {
  public native let node: wref<animAnimNode_QuaternionValue>;
}

public native class animRig extends CResource {
  public native let boneNames: array<CName>;
  public native let trackNames: array<CName>;
  public native let rigExtraTracks: array<animFloatTrackInfo>;
  public native let levelOfDetailStartIndices: array<Int16>;
  public native let distanceCategoryToLodMap: array<Int16>;
  public native let turnOffLOD: Int32;
  public native let turningOffUpdateAndSample: Bool;
  public native let referenceTracks: array<Float>;
  public native let referencePoseMS: array<QsTransform>;
  public native let aPoseLS: array<QsTransform>;
  public native let aPoseMS: array<QsTransform>;
  public native let tags: redTagList;
  public native let parts: array<animRigPart>;
  public native let retargets: array<animRigRetarget>;
  public native let ikSetups: array<ref<animIRigIkSetup>>;
  public native let ragdollDesc: array<physicsRagdollBodyInfo>;
  public native let ragdollNames: array<physicsRagdollBodyNames>;
}

public native class animRigIk2Setup extends animIRigIkSetup {
  public native let firstBone: CName;
  public native let secondBone: CName;
  public native let endBone: CName;
  public native let hingeAxis: animAxis;
  public native let firstBoneIdx: Int16;
  public native let secondBoneIdx: Int16;
  public native let endBoneIdx: Int16;
}

public native class animRigIkLeftFootSetup extends animRigIk2Setup {}

public native class animRigIkRightFootSetup extends animRigIk2Setup {}

public native struct animRigPart {
  public native let name: CName;
  public native let singleBones: array<animRigPartBone>;
  public native let treeBones: array<animRigPartBoneTree>;
  public native let bonesWithRotationInModelSpace: array<CName>;
  public native let mask: array<animTransformMask>;
  public native let maskRotMS: array<Int32>;
}

public native struct animRigPartBone {
  public native let bone: CName;
  public native let weight: Float;
}

public native struct animRigPartBoneTree {
  public native let rootBone: CName;
  public native let weight: Float;
  public native let subtreesToChange: array<animRigPartBoneTree>;
}

public native struct animRigRetarget {
  public native let sourceRig: ResourceRef; // rRef<animRig>
}

public native class animRigSharedData extends CResource {
  public native let parts: array<animRigPart>;
  public native let ikSetups: array<ref<animIRigIkSetup>>;
}

public native class animRigTagCondition extends animIStaticCondition {
  public native let tag: CName;
}

public native struct animSAnimationBufferBitwiseCompressedBoneTrack {
  public native let position: animSAnimationBufferBitwiseCompressedData;
  public native let orientation: animSAnimationBufferBitwiseCompressedData;
  public native let scale: animSAnimationBufferBitwiseCompressedData;
}

public native struct animSAnimationBufferBitwiseCompressedData {
  public native let dt: Float;
  public native let compression: Int8;
  public native let numFrames: Uint16;
  public native let dataAddr: Uint32;
  public native let dataAddrFallback: Uint32;
}

public native struct animSAnimationBufferBitwiseCompressionSettings {
  public native let translationTolerance: Float;
  public native let translationSkipFrameTolerance: Float;
  public native let orientationTolerance: Float;
  public native let orientationCompressionMethod: SAnimationBufferOrientationCompressionMethod;
  public native let orientationSkipFrameTolerance: Float;
  public native let scaleTolerance: Float;
  public native let scaleSkipFrameTolerance: Float;
  public native let trackTolerance: Float;
  public native let trackSkipFrameTolerance: Float;
}

public native struct animSApplyRotationIKSolver {}

public native struct animSApplyRotationIKSolverData {
  public native let bone: animTransformIndex;
}

public native struct animSBehaviorConstraintNodeFloorIKCachedTrace {}

public native struct animSBehaviorConstraintNodeFloorIKCommon {}

public native struct animSBehaviorConstraintNodeFloorIKCommonData {
  public native let gravityCentreBone: animTransformIndex;
  public native let rootRotationBlendTime: Float;
  public native let verticalVelocityOffsetUpBlendTime: Float;
  public native let verticalVelocityOffsetDownBlendTime: Float;
  public native let slidingOnSlopeBlendTime: Float;
}

public native struct animSBehaviorConstraintNodeFloorIKDebugTrace {}

public native struct animSBehaviorConstraintNodeFloorIKFrontBackWeightHandler {}

public native struct animSBehaviorConstraintNodeFloorIKLeg {}

public native struct animSBehaviorConstraintNodeFloorIKLegs {}

public native struct animSBehaviorConstraintNodeFloorIKLegsData {
  public native let verticalOffsetBlendUpTime: Float;
  public native let verticalOffsetBlendDownTime: Float;
}

public native struct animSBehaviorConstraintNodeFloorIKLegsIKWeightHandler {}

public native struct animSBehaviorConstraintNodeFloorIKMaintainLookBone {}

public native struct animSBehaviorConstraintNodeFloorIKMaintainLookBoneData {
  public native let bone: CName;
  public native let amountOfRotation: Float;
}

public native struct animSBehaviorConstraintNodeFloorIKVerticalBone {}

public native struct animSBehaviorConstraintNodeFloorIKVerticalBoneData {
  public native let bone: animTransformIndex;
  public native let offsetToDesiredBlendTime: Float;
  public native let verticalOffsetBlendTime: Float;
  public native let stiffness: Float;
}

public native struct animSBehaviorConstraintNodeFloorIKWeightHandler {}

public native struct animSermoPoseInfo {
  public native let lod: Uint8;
  public native let type: Uint8;
  public native let trackIndex: Uint16;
}

public native struct animSermoTestController {
  public native let faceEnvelope: Float;
  public native let upperFace: Float;
  public native let lowerFace: Float;
  public native let lipSyncEnvelope: Float;
  public native let lipSyncLeftEnvelope: Float;
  public native let lipSyncRightEnvelope: Float;
  public native let jaliJaw: Float;
  public native let jaliLips: Float;
  public native let muzzleLips: Float;
  public native let muzzleEyes: Float;
  public native let muzzleBrows: Float;
  public native let muzzleEyeDirections: Float;
  public native let eye_l_blink: Float;
  public native let eye_r_blink: Float;
  public native let eye_l_widen: Float;
  public native let eye_r_widen: Float;
  public native let eye_l_dir_up: Float;
  public native let eye_l_dir_dn: Float;
  public native let eye_l_dir_in: Float;
  public native let eye_l_dir_out: Float;
  public native let eye_r_dir_up: Float;
  public native let eye_r_dir_dn: Float;
  public native let eye_r_dir_in: Float;
  public native let eye_r_dir_out: Float;
  public native let eye_l_pupil_narrow: Float;
  public native let eye_r_pupil_narrow: Float;
  public native let eye_l_pupil_wide: Float;
  public native let eye_r_pupil_wide: Float;
  public native let eye_l_brows_raise_in: Float;
  public native let eye_r_brows_raise_in: Float;
  public native let eye_l_brows_raise_out: Float;
  public native let eye_r_brows_raise_out: Float;
  public native let eye_l_brows_lower: Float;
  public native let eye_r_brows_lower: Float;
  public native let eye_l_brows_lateral: Float;
  public native let eye_r_brows_lateral: Float;
  public native let eye_l_oculi_squint_inner: Float;
  public native let eye_r_oculi_squint_inner: Float;
  public native let eye_l_oculi_squint_outer_lower: Float;
  public native let eye_r_oculi_squint_outer_lower: Float;
  public native let eye_l_oculi_squint_outer_upper: Float;
  public native let eye_r_oculi_squint_outer_upper: Float;
  public native let nose_l_compress: Float;
  public native let nose_r_compress: Float;
  public native let nose_l_breathe_in: Float;
  public native let nose_r_breathe_in: Float;
  public native let nose_l_breathe_out: Float;
  public native let nose_r_breathe_out: Float;
  public native let nose_l_snear: Float;
  public native let nose_r_snear: Float;
  public native let lips_l_nasolabialDeepener: Float;
  public native let lips_r_nasolabialDeepener: Float;
  public native let lips_l_upper_raise: Float;
  public native let lips_r_upper_raise: Float;
  public native let lips_l_pull: Float;
  public native let lips_r_pull: Float;
  public native let lips_l_corner_up: Float;
  public native let lips_r_corner_up: Float;
  public native let lips_l_corner_wide: Float;
  public native let lips_r_corner_wide: Float;
  public native let lips_l_corner_stretch: Float;
  public native let lips_r_corner_stretch: Float;
  public native let lips_l_stretch: Float;
  public native let lips_r_stretch: Float;
  public native let lips_l_corner_sharp_up: Float;
  public native let lips_r_corner_sharp_up: Float;
  public native let lips_suck_up: Float;
  public native let lips_suck_dn: Float;
  public native let lips_puff_up: Float;
  public native let lips_puff_dn: Float;
  public native let lips_apart_up: Float;
  public native let lips_apart_dn: Float;
  public native let lips_l_lower_raise: Float;
  public native let lips_r_lower_raise: Float;
  public native let lips_l_corner_dn: Float;
  public native let lips_r_corner_dn: Float;
  public native let lips_chin_raise: Float;
  public native let lips_together_up: Float;
  public native let lips_together_dn: Float;
  public native let lips_l_purse: Float;
  public native let lips_r_purse: Float;
  public native let lips_l_funnel: Float;
  public native let lips_r_funnel: Float;
  public native let lips_tighten_up: Float;
  public native let lips_tighten_dn: Float;
  public native let lips_mid_shift_l: Float;
  public native let lips_mid_shift_r: Float;
  public native let lips_mid_shift_up: Float;
  public native let lips_mid_shift_dn: Float;
  public native let lips_corner_sticky: Float;
  public native let lips_l_corner_up_in_sticky_cutScene: Float;
  public native let lips_l_corner_dn_in_sticky_cutScene: Float;
  public native let lips_l_corner_up_out_sticky_cutScene: Float;
  public native let lips_l_corner_dn_out_sticky_cutScene: Float;
  public native let lips_r_corner_up_in_sticky_cutScene: Float;
  public native let lips_r_corner_up_out_sticky_cutScene: Float;
  public native let lips_r_corner_dn_in_sticky_cutScene: Float;
  public native let lips_r_corner_dn_out_sticky_cutScene: Float;
  public native let cheek_l_suck: Float;
  public native let cheek_r_suck: Float;
  public native let cheek_l_puff: Float;
  public native let cheek_r_puff: Float;
  public native let jaw_mid_open: Float;
  public native let jaw_mid_close: Float;
  public native let jaw_mid_shift_l: Float;
  public native let jaw_mid_shift_r: Float;
  public native let jaw_mid_shift_fwd: Float;
  public native let jaw_mid_shift_back: Float;
  public native let jaw_mid_clench: Float;
  public native let neck_l_stretch: Float;
  public native let neck_r_stretch: Float;
  public native let neck_tighten: Float;
  public native let neck_l_sternocleidomastoid_flex: Float;
  public native let neck_r_sternocleidomastoid_flex: Float;
  public native let neck_l_platysma_flex: Float;
  public native let neck_r_platysma_flex: Float;
  public native let neck_throat_adamsApple_up: Float;
  public native let neck_throat_adamsApple_dn: Float;
  public native let neck_throat_compress: Float;
  public native let neck_throat_open: Float;
  public native let neck_l_turn: Float;
  public native let neck_r_turn: Float;
  public native let neck_up_turn: Float;
  public native let neck_dn_turn: Float;
  public native let neck_l_tilt: Float;
  public native let neck_r_tilt: Float;
  public native let head_neck_up_turn: Float;
  public native let head_neck_dn_turn: Float;
  public native let head_neck_l_tilt: Float;
  public native let head_neck_r_tilt: Float;
  public native let ear_l_shift_up: Float;
  public native let ear_r_shift_up: Float;
  public native let sculp_mid_slide: Float;
  public native let face_gravity_fwd: Float;
  public native let face_gravity_back: Float;
  public native let face_gravity_l: Float;
  public native let face_gravity_r: Float;
  public native let tongue_mid_base_l: Float;
  public native let tongue_mid_base_r: Float;
  public native let tongue_mid_base_dn: Float;
  public native let tongue_mid_base_up: Float;
  public native let tongue_mid_base_fwd: Float;
  public native let tongue_mid_base_front: Float;
  public native let tongue_mid_base_back: Float;
  public native let tongue_mid_fwd: Float;
  public native let tongue_mid_lift: Float;
  public native let tongue_mid_tip_l: Float;
  public native let tongue_mid_tip_r: Float;
  public native let tongue_mid_tip_dn: Float;
  public native let tongue_mid_tip_up: Float;
  public native let tongue_mid_twist_l: Float;
  public native let tongue_mid_twist_r: Float;
  public native let tongue_mid_thick: Float;
  public native let nose_l_snearAnimOverrideWeight: Float;
  public native let nose_r_snearAnimOverrideWeight: Float;
  public native let lips_l_nasolabialDeepenerAnimOverrideWeight: Float;
  public native let lips_r_nasolabialDeepenerAnimOverrideWeight: Float;
  public native let lips_l_upper_raiseAnimOverrideWeight: Float;
  public native let lips_r_upper_raiseAnimOverrideWeight: Float;
  public native let lips_l_pullAnimOverrideWeight: Float;
  public native let lips_r_pullAnimOverrideWeight: Float;
  public native let lips_l_corner_upAnimOverrideWeight: Float;
  public native let lips_r_corner_upAnimOverrideWeight: Float;
  public native let lips_l_corner_wideAnimOverrideWeight: Float;
  public native let lips_r_corner_wideAnimOverrideWeight: Float;
  public native let lips_l_corner_stretchAnimOverrideWeight: Float;
  public native let lips_r_corner_stretchAnimOverrideWeight: Float;
  public native let lips_l_stretchAnimOverrideWeight: Float;
  public native let lips_r_stretchAnimOverrideWeight: Float;
  public native let lips_l_corner_sharp_upAnimOverrideWeight: Float;
  public native let lips_r_corner_sharp_upAnimOverrideWeight: Float;
  public native let lips_suck_upAnimOverrideWeight: Float;
  public native let lips_suck_dnAnimOverrideWeight: Float;
  public native let lips_puff_upAnimOverrideWeight: Float;
  public native let lips_puff_dnAnimOverrideWeight: Float;
  public native let lips_apart_upAnimOverrideWeight: Float;
  public native let lips_apart_dnAnimOverrideWeight: Float;
  public native let lips_l_lower_raiseAnimOverrideWeight: Float;
  public native let lips_r_lower_raiseAnimOverrideWeight: Float;
  public native let lips_l_corner_dnAnimOverrideWeight: Float;
  public native let lips_r_corner_dnAnimOverrideWeight: Float;
  public native let lips_chin_raiseAnimOverrideWeight: Float;
  public native let lips_together_upAnimOverrideWeight: Float;
  public native let lips_together_dnAnimOverrideWeight: Float;
  public native let lips_l_purseAnimOverrideWeight: Float;
  public native let lips_r_purseAnimOverrideWeight: Float;
  public native let lips_l_funnelAnimOverrideWeight: Float;
  public native let lips_r_funnelAnimOverrideWeight: Float;
  public native let lips_tighten_upAnimOverrideWeight: Float;
  public native let lips_tighten_dnAnimOverrideWeight: Float;
  public native let lips_mid_shift_lAnimOverrideWeight: Float;
  public native let lips_mid_shift_rAnimOverrideWeight: Float;
  public native let lips_mid_shift_upAnimOverrideWeight: Float;
  public native let lips_mid_shift_dnAnimOverrideWeight: Float;
  public native let cheek_l_puffAnimOverrideWeight: Float;
  public native let cheek_r_puffAnimOverrideWeight: Float;
  public native let jaw_mid_openAnimOverrideWeight: Float;
  public native let jaw_mid_closeAnimOverrideWeight: Float;
  public native let jaw_mid_shift_lAnimOverrideWeight: Float;
  public native let jaw_mid_shift_rAnimOverrideWeight: Float;
  public native let jaw_mid_shift_fwdAnimOverrideWeight: Float;
  public native let jaw_mid_shift_backAnimOverrideWeight: Float;
  public native let jaw_mid_clenchAnimOverrideWeight: Float;
  public native let neck_l_stretchAnimOverrideWeight: Float;
  public native let neck_r_stretchAnimOverrideWeight: Float;
  public native let neck_tightenAnimOverrideWeight: Float;
  public native let neck_l_sternocleidomastoid_flexAnimOverrideWeight: Float;
  public native let neck_r_sternocleidomastoid_flexAnimOverrideWeight: Float;
  public native let neck_l_platysma_flexAnimOverrideWeight: Float;
  public native let neck_r_platysma_flexAnimOverrideWeight: Float;
  public native let neck_throat_adamsApple_upAnimOverrideWeight: Float;
  public native let neck_throat_adamsApple_dnAnimOverrideWeight: Float;
  public native let neck_throat_compressAnimOverrideWeight: Float;
  public native let neck_throat_openAnimOverrideWeight: Float;
  public native let lips_corner_stickyAnimOverrideWeight: Float;
  public native let lips_l_corner_up_in_sticky_cutSceneAnimOverrideWeight: Float;
  public native let lips_l_corner_dn_in_sticky_cutSceneAnimOverrideWeight: Float;
  public native let lips_l_corner_up_out_sticky_cutSceneAnimOverrideWeight: Float;
  public native let lips_l_corner_dn_out_sticky_cutSceneAnimOverrideWeight: Float;
  public native let lips_r_corner_up_in_sticky_cutSceneAnimOverrideWeight: Float;
  public native let lips_r_corner_up_out_sticky_cutSceneAnimOverrideWeight: Float;
  public native let lips_r_corner_dn_in_sticky_cutSceneAnimOverrideWeight: Float;
  public native let lips_r_corner_dn_out_sticky_cutSceneAnimOverrideWeight: Float;
  public native let tongue_mid_base_lAnimOverrideWeight: Float;
  public native let tongue_mid_base_rAnimOverrideWeight: Float;
  public native let tongue_mid_base_dnAnimOverrideWeight: Float;
  public native let tongue_mid_base_upAnimOverrideWeight: Float;
  public native let tongue_mid_base_fwdAnimOverrideWeight: Float;
  public native let tongue_mid_base_frontAnimOverrideWeight: Float;
  public native let tongue_mid_base_backAnimOverrideWeight: Float;
  public native let tongue_mid_fwdAnimOverrideWeight: Float;
  public native let tongue_mid_liftAnimOverrideWeight: Float;
  public native let tongue_mid_tip_lAnimOverrideWeight: Float;
  public native let tongue_mid_tip_rAnimOverrideWeight: Float;
  public native let tongue_mid_tip_dnAnimOverrideWeight: Float;
  public native let tongue_mid_tip_upAnimOverrideWeight: Float;
  public native let tongue_mid_twist_lAnimOverrideWeight: Float;
  public native let tongue_mid_twist_rAnimOverrideWeight: Float;
  public native let tongue_mid_thickAnimOverrideWeight: Float;
  public native let eye_l_blinkLipsyncPoseOutput: Float;
  public native let eye_r_blinkLipsyncPoseOutput: Float;
  public native let eye_l_widenLipsyncPoseOutput: Float;
  public native let eye_r_widenLipsyncPoseOutput: Float;
  public native let eye_l_dir_upLipsyncPoseOutput: Float;
  public native let eye_l_dir_dnLipsyncPoseOutput: Float;
  public native let eye_l_dir_inLipsyncPoseOutput: Float;
  public native let eye_l_dir_outLipsyncPoseOutput: Float;
  public native let eye_r_dir_upLipsyncPoseOutput: Float;
  public native let eye_r_dir_dnLipsyncPoseOutput: Float;
  public native let eye_r_dir_inLipsyncPoseOutput: Float;
  public native let eye_r_dir_outLipsyncPoseOutput: Float;
  public native let eye_l_pupil_narrowLipsyncPoseOutput: Float;
  public native let eye_r_pupil_narrowLipsyncPoseOutput: Float;
  public native let eye_l_pupil_wideLipsyncPoseOutput: Float;
  public native let eye_r_pupil_wideLipsyncPoseOutput: Float;
  public native let eye_l_brows_raise_inLipsyncPoseOutput: Float;
  public native let eye_r_brows_raise_inLipsyncPoseOutput: Float;
  public native let eye_l_brows_raise_outLipsyncPoseOutput: Float;
  public native let eye_r_brows_raise_outLipsyncPoseOutput: Float;
  public native let eye_l_brows_lowerLipsyncPoseOutput: Float;
  public native let eye_r_brows_lowerLipsyncPoseOutput: Float;
  public native let eye_l_brows_lateralLipsyncPoseOutput: Float;
  public native let eye_r_brows_lateralLipsyncPoseOutput: Float;
  public native let eye_l_oculi_squint_innerLipsyncPoseOutput: Float;
  public native let eye_r_oculi_squint_innerLipsyncPoseOutput: Float;
  public native let eye_l_oculi_squint_outer_lowerLipsyncPoseOutput: Float;
  public native let eye_r_oculi_squint_outer_lowerLipsyncPoseOutput: Float;
  public native let eye_l_oculi_squint_outer_upperLipsyncPoseOutput: Float;
  public native let eye_r_oculi_squint_outer_upperLipsyncPoseOutput: Float;
  public native let nose_l_compressLipsyncPoseOutput: Float;
  public native let nose_r_compressLipsyncPoseOutput: Float;
  public native let nose_l_breathe_inLipsyncPoseOutput: Float;
  public native let nose_r_breathe_inLipsyncPoseOutput: Float;
  public native let nose_l_breathe_outLipsyncPoseOutput: Float;
  public native let nose_r_breathe_outLipsyncPoseOutput: Float;
  public native let nose_l_snearLipsyncPoseOutput: Float;
  public native let nose_r_snearLipsyncPoseOutput: Float;
  public native let lips_l_nasolabialDeepenerLipsyncPoseOutput: Float;
  public native let lips_r_nasolabialDeepenerLipsyncPoseOutput: Float;
  public native let lips_l_upper_raiseLipsyncPoseOutput: Float;
  public native let lips_r_upper_raiseLipsyncPoseOutput: Float;
  public native let lips_l_pullLipsyncPoseOutput: Float;
  public native let lips_r_pullLipsyncPoseOutput: Float;
  public native let lips_l_corner_upLipsyncPoseOutput: Float;
  public native let lips_r_corner_upLipsyncPoseOutput: Float;
  public native let lips_l_corner_wideLipsyncPoseOutput: Float;
  public native let lips_r_corner_wideLipsyncPoseOutput: Float;
  public native let lips_l_corner_stretchLipsyncPoseOutput: Float;
  public native let lips_r_corner_stretchLipsyncPoseOutput: Float;
  public native let lips_l_stretchLipsyncPoseOutput: Float;
  public native let lips_r_stretchLipsyncPoseOutput: Float;
  public native let lips_l_corner_sharp_upLipsyncPoseOutput: Float;
  public native let lips_r_corner_sharp_upLipsyncPoseOutput: Float;
  public native let lips_suck_upLipsyncPoseOutput: Float;
  public native let lips_suck_dnLipsyncPoseOutput: Float;
  public native let lips_puff_upLipsyncPoseOutput: Float;
  public native let lips_puff_dnLipsyncPoseOutput: Float;
  public native let lips_apart_upLipsyncPoseOutput: Float;
  public native let lips_apart_dnLipsyncPoseOutput: Float;
  public native let lips_l_lower_raiseLipsyncPoseOutput: Float;
  public native let lips_r_lower_raiseLipsyncPoseOutput: Float;
  public native let lips_l_corner_dnLipsyncPoseOutput: Float;
  public native let lips_r_corner_dnLipsyncPoseOutput: Float;
  public native let lips_chin_raiseLipsyncPoseOutput: Float;
  public native let lips_together_upLipsyncPoseOutput: Float;
  public native let lips_together_dnLipsyncPoseOutput: Float;
  public native let lips_l_purseLipsyncPoseOutput: Float;
  public native let lips_r_purseLipsyncPoseOutput: Float;
  public native let lips_l_funnelLipsyncPoseOutput: Float;
  public native let lips_r_funnelLipsyncPoseOutput: Float;
  public native let lips_tighten_upLipsyncPoseOutput: Float;
  public native let lips_tighten_dnLipsyncPoseOutput: Float;
  public native let lips_mid_shift_lLipsyncPoseOutput: Float;
  public native let lips_mid_shift_rLipsyncPoseOutput: Float;
  public native let lips_mid_shift_upLipsyncPoseOutput: Float;
  public native let lips_mid_shift_dnLipsyncPoseOutput: Float;
  public native let lips_corner_stickyLipsyncPoseOutput: Float;
  public native let lips_l_corner_up_in_sticky_cutSceneLipsyncPoseOutput: Float;
  public native let lips_l_corner_dn_in_sticky_cutSceneLipsyncPoseOutput: Float;
  public native let lips_l_corner_up_out_sticky_cutSceneLipsyncPoseOutput: Float;
  public native let lips_l_corner_dn_out_sticky_cutSceneLipsyncPoseOutput: Float;
  public native let lips_r_corner_up_in_sticky_cutSceneLipsyncPoseOutput: Float;
  public native let lips_r_corner_up_out_sticky_cutSceneLipsyncPoseOutput: Float;
  public native let lips_r_corner_dn_in_sticky_cutSceneLipsyncPoseOutput: Float;
  public native let lips_r_corner_dn_out_sticky_cutSceneLipsyncPoseOutput: Float;
  public native let cheek_l_suckLipsyncPoseOutput: Float;
  public native let cheek_r_suckLipsyncPoseOutput: Float;
  public native let cheek_l_puffLipsyncPoseOutput: Float;
  public native let cheek_r_puffLipsyncPoseOutput: Float;
  public native let jaw_mid_openLipsyncPoseOutput: Float;
  public native let jaw_mid_closeLipsyncPoseOutput: Float;
  public native let jaw_mid_shift_lLipsyncPoseOutput: Float;
  public native let jaw_mid_shift_rLipsyncPoseOutput: Float;
  public native let jaw_mid_shift_fwdLipsyncPoseOutput: Float;
  public native let jaw_mid_shift_backLipsyncPoseOutput: Float;
  public native let jaw_mid_clenchLipsyncPoseOutput: Float;
  public native let neck_l_stretchLipsyncPoseOutput: Float;
  public native let neck_r_stretchLipsyncPoseOutput: Float;
  public native let neck_tightenLipsyncPoseOutput: Float;
  public native let neck_l_sternocleidomastoid_flexLipsyncPoseOutput: Float;
  public native let neck_r_sternocleidomastoid_flexLipsyncPoseOutput: Float;
  public native let neck_l_platysma_flexLipsyncPoseOutput: Float;
  public native let neck_r_platysma_flexLipsyncPoseOutput: Float;
  public native let neck_throat_adamsApple_upLipsyncPoseOutput: Float;
  public native let neck_throat_adamsApple_dnLipsyncPoseOutput: Float;
  public native let neck_throat_compressLipsyncPoseOutput: Float;
  public native let neck_throat_openLipsyncPoseOutput: Float;
  public native let neck_l_turnLipsyncPoseOutput: Float;
  public native let neck_r_turnLipsyncPoseOutput: Float;
  public native let neck_up_turnLipsyncPoseOutput: Float;
  public native let neck_dn_turnLipsyncPoseOutput: Float;
  public native let neck_l_tiltLipsyncPoseOutput: Float;
  public native let neck_r_tiltLipsyncPoseOutput: Float;
  public native let head_neck_up_turnLipsyncPoseOutput: Float;
  public native let head_neck_dn_turnLipsyncPoseOutput: Float;
  public native let head_neck_l_tiltLipsyncPoseOutput: Float;
  public native let head_neck_r_tiltLipsyncPoseOutput: Float;
  public native let ear_l_shift_upLipsyncPoseOutput: Float;
  public native let ear_r_shift_upLipsyncPoseOutput: Float;
  public native let sculp_mid_slideLipsyncPoseOutput: Float;
  public native let face_gravity_fwdLipsyncPoseOutput: Float;
  public native let face_gravity_backLipsyncPoseOutput: Float;
  public native let face_gravity_lLipsyncPoseOutput: Float;
  public native let face_gravity_rLipsyncPoseOutput: Float;
  public native let tongue_mid_base_lLipsyncPoseOutput: Float;
  public native let tongue_mid_base_rLipsyncPoseOutput: Float;
  public native let tongue_mid_base_dnLipsyncPoseOutput: Float;
  public native let tongue_mid_base_upLipsyncPoseOutput: Float;
  public native let tongue_mid_base_fwdLipsyncPoseOutput: Float;
  public native let tongue_mid_base_frontLipsyncPoseOutput: Float;
  public native let tongue_mid_base_backLipsyncPoseOutput: Float;
  public native let tongue_mid_fwdLipsyncPoseOutput: Float;
  public native let tongue_mid_liftLipsyncPoseOutput: Float;
  public native let tongue_mid_tip_lLipsyncPoseOutput: Float;
  public native let tongue_mid_tip_rLipsyncPoseOutput: Float;
  public native let tongue_mid_tip_dnLipsyncPoseOutput: Float;
  public native let tongue_mid_tip_upLipsyncPoseOutput: Float;
  public native let tongue_mid_twist_lLipsyncPoseOutput: Float;
  public native let tongue_mid_twist_rLipsyncPoseOutput: Float;
  public native let tongue_mid_thickLipsyncPoseOutput: Float;
  public native let eye_l_oculi_squint_outer_lowerWrnkl: Float;
  public native let eye_r_oculi_squint_outer_lowerWrnkl: Float;
  public native let eye_l_oculi_squint_outer_upperWrnkl: Float;
  public native let eye_r_oculi_squint_outer_upperWrnkl: Float;
  public native let eye_l_brows_raise_inWrnkl: Float;
  public native let eye_r_brows_raise_inWrnkl: Float;
  public native let eye_l_brows_raise_outWrnkl: Float;
  public native let eye_r_brows_raise_outWrnkl: Float;
  public native let eye_l_brows_lowerWrnkl: Float;
  public native let eye_r_brows_lowerWrnkl: Float;
  public native let eye_l_brows_lateralWrnkl: Float;
  public native let eye_r_brows_lateralWrnkl: Float;
  public native let nose_l_snearWrnkl: Float;
  public native let nose_r_snearWrnkl: Float;
  public native let lips_l_upper_raiseWrnkl: Float;
  public native let lips_r_upper_raiseWrnkl: Float;
  public native let lips_l_corner_upWrnkl: Float;
  public native let lips_r_corner_upWrnkl: Float;
  public native let lips_l_corner_wideWrnkl: Float;
  public native let lips_r_corner_wideWrnkl: Float;
  public native let lips_l_corner_stretchWrnkl: Float;
  public native let lips_r_corner_stretchWrnkl: Float;
  public native let lips_l_lower_raiseWrnkl: Float;
  public native let lips_r_lower_raiseWrnkl: Float;
  public native let lips_chin_raiseWrnkl: Float;
  public native let lips_l_purseWrnkl: Float;
  public native let lips_r_purseWrnkl: Float;
  public native let lips_l_funnelWrnkl: Float;
  public native let lips_r_funnelWrnkl: Float;
  public native let jaw_mid_openWrnkl: Float;
  public native let neck_l_stretchWrnkl: Float;
  public native let neck_r_stretchWrnkl: Float;
  public native let head_neck_dn_turnWrnkl: Float;
}

public native struct animSetBoneTransform_JsonEntry {
  public native let transformToChange: CName;
  public native let setMethod: animSetBoneTransformEntry_SetMethod;
  public native let snapToReference: Bool;
  public native let sourceBone: CName;
  public native let offsetToReference: Bool;
  public native let offsetSpaceBone: CName;
  public native let offset: QsTransform;
}

public native class animSetBoneTransform_JsonProperties extends ISerializable {
  public native let entries: array<animSetBoneTransform_JsonEntry>;
}

public enum animSetBoneTransformEntry_SetMethod {
  NoSnapping = 0,
  WholeTransform = 1,
  TranslationOnly = 2,
  RotationOnly = 3,
}

public native struct animSetBoneTransformEntry {
  public native let transformToChange: animTransformIndex;
  public native let setMethod: animSetBoneTransformEntry_SetMethod;
  public native let snapToReference: Bool;
  public native let sourceBone: animTransformIndex;
  public native let offsetToReference: Bool;
  public native let offsetSpaceBone: animTransformIndex;
  public native let offset: QsTransform;
}

public native class animSimpleBounce_JsonProperties extends ISerializable {
  public native let multiplier: Float;
  public native let negativeMultiplier: Float;
  public native let smoothStep: Float;
  public native let offset: Float;
  public native let delay: Float;
  public native let startTransform: animTransformIndex;
  public native let endTransform: animTransformIndex;
  public native let transformOutputs: array<animSimpleBounceTransformOutput>;
  public native let trackOutputs: array<animSimpleBounceTrackOutput>;
  public native let outputDriverTrack: animNamedTrackIndex;
}

public native struct animSimpleBounceTrackOutput {
  public native let targetTrack: animNamedTrackIndex;
  public native let multiplier: Float;
}

public native struct animSimpleBounceTransformOutput_ChannelEntry {
  public native let transformChannel: animTransformChannel;
  public native let multiplier: Float;
}

public native struct animSimpleBounceTransformOutput {
  public native let targetTransform: animTransformIndex;
  public native let parentTransform: animTransformIndex;
  public native let targetTransformChannel: animTransformChannel;
  public native let multiplier: Float;
  public native let channelEntries: array<animSimpleBounceTransformOutput_ChannelEntry>;
}

public native struct animSmoothFloatClamp {
  public native let min: Float;
  public native let max: Float;
  public native let marginEaseOutCurve: CurveDataFloat;
}

public native struct animSnapToTerrainIkRequest {
  public native let ikChain: CName;
  public native let footTransformIndex: animTransformIndex;
  public native let poleVectorRefTransformIndex: animTransformIndex;
  public native let enableFootLockFloatTrack: animNamedTrackIndex;
}

public native class animSplineCompressedMotionExtraction extends animIMotionExtraction {
  public native let duration: Float;
  public native let posKeysData: array<Uint8>;
  public native let rotKeysData: array<Uint8>;
}

public enum animSpringProjectionType {
  Disabled = 0,
  ShortestPath = 1,
}

public native struct animStackTracksExtender_JsonEntry {
  public native let name: CName;
  public native let referenceValue: Float;
}

public native class animStackTracksExtender_JsonProperties extends ISerializable {
  public native let entries: array<animStackTracksExtender_JsonEntry>;
}

public native struct animStackTransformsExtender_Entry {
  public native let transformInfo: animTransformInfo;
  public native let snapMethod: animStackTransformsExtender_SnapToBoneMethod;
  public native let snapToReference: Bool;
  public native let snapTargetBone: animTransformIndex;
  public native let offsetToReference: Bool;
  public native let offsetSpaceBone: animTransformIndex;
  public native let offset: QsTransform;
}

public native struct animStackTransformsExtender_JsonEntry {
  public native let name: CName;
  public native let parentName: CName;
  public native let referenceTransformLs: QsTransform;
  public native let snapMethod: animStackTransformsExtender_SnapToBoneMethod;
  public native let snapToReference: Bool;
  public native let snapTargetBone: CName;
  public native let offsetToReference: Bool;
  public native let offsetSpaceBone: CName;
  public native let offset: QsTransform;
}

public native class animStackTransformsExtender_JsonProperties extends ISerializable {
  public native let entries: array<animStackTransformsExtender_JsonEntry>;
}

public enum animStackTransformsExtender_SnapToBoneMethod {
  NoSnapping = 0,
  WholeTransform = 1,
  TranslationOnly = 2,
  RotationOnly = 3,
}

public enum animStateTag {
  ST_Invalid = 0,
  Idle = 1,
  Cover = 2,
}

public native struct animSTwoBonesIKSolver {}

public native struct animSTwoBonesIKSolverData {
  public native let upperBone: animTransformIndex;
  public native let jointBone: animTransformIndex;
  public native let subLowerBone: animTransformIndex;
  public native let lowerBone: animTransformIndex;
  public native let ikBone: animTransformIndex;
  public native let limitToLengthPercentage: Float;
  public native let reverseBend: Bool;
  public native let allowToLock: Bool;
  public native let autoSetupDirs: Bool;
  public native let jointSideWeightUpper: Float;
  public native let jointSideWeightJoint: Float;
  public native let jointSideWeightLower: Float;
}

public native class animSyncMethodByEvent extends animISyncMethod {
  public native let eventName: CName;
}

public native class animSyncMethodByFootPhase extends animISyncMethod {}

public native class animSyncMethodByProgress extends animISyncMethod {}

public native class animSyncMethodLocomotion extends animISyncMethod {
  public native let locomotionFeatureName: CName;
  public native let accelStopTimeEvent: CName;
}

public native struct animTEMP_IKTargetsControllerBodyType {
  public native let genderTag: CName;
  public native let bodyTypeTag: CName;
  public native let ikChainSettings: array<IKChainSettings>;
}

public enum animTransformChannel {
  PosX = 0,
  PosY = 1,
  PosZ = 2,
  RotX = 3,
  RotY = 4,
  RotZ = 5,
  ScaleX = 6,
  ScaleY = 7,
  ScaleZ = 8,
}

public native struct animTransformIndex {
  public native let name: CName;
}

public native struct animTransformInfo {
  public native let name: CName;
  public native let parentName: CName;
  public native let referenceTransformLs: QsTransform;
}

public native struct animTransformLink {
  public native let node: wref<animAnimNode_TransformValue>;
}

public native struct animTransformMask {
  public native let index: Int32;
  public native let weight: Float;
}

public native struct animTwistOutput {
  public native let positiveScale: Float;
  public native let negativeScale: Float;
  public native let twistAxis: animAxis;
  public native let twistedTransform: animTransformIndex;
  public native let outputAngleTrack: animNamedTrackIndex;
}

public native class animUncompressedAllAnglesMotionExtraction extends animIMotionExtraction {
  public native let duration: Float;
  public native let frames: array<Transform>;
}

public native class animUncompressedMotionExtraction extends animIMotionExtraction {
  public native let frames: array<Vector4>;
  public native let duration: Float;
}

public enum animVectorCoordinateType {
  X = 0,
  Y = 1,
  Z = 2,
  W = 3,
}

public native struct animVectorLink {
  public native let node: wref<animAnimNode_VectorValue>;
}

public native class animVisualTagCondition extends animIStaticCondition {
  public native let visualTag: CName;
}

public native struct appearanceAlternateAppearanceEntry {
  public native let Original: CName;
  public native let Alternate: CName;
  public native let AlternateAppearanceIndex: Uint8;
}

public native class appearanceAppearanceDefinition extends ISerializable {
  public native let name: CName;
  public native let parentAppearance: CName;
  public native let partsMasks: array<array<CName>>;
  public native let partsValues: array<appearanceAppearancePart>;
  public native let partsOverrides: array<appearanceAppearancePartOverrides>;
  public native let proxyMesh: ResourceAsyncRef; // raRef<CMesh>
  public native let forcedLodDistance: Uint8;
  public native let proxyMeshAppearance: CName;
  public native let cookedDataPathOverride: ResourceAsyncRef; // raRef<CResource>
  public native let parametersBuffer: entEntityParametersBuffer;
  public native let visualTags: redTagList;
  public native let inheritedVisualTags: redTagList;
  public native let hitRepresentationOverrides: array<HitRepresentationOverride>;
  public native let resolvedDependencies: array<ResourceAsyncRef>;
  public native let looseDependencies: array<ResourceAsyncRef>;
  public native let censorFlags: Uint32;
}

public native struct appearanceAppearancePart {
  public native let resource: ResourceAsyncRef; // raRef<entEntityTemplate>
}

public native struct appearanceAppearancePartOverrides {
  public native let partResource: ResourceAsyncRef; // raRef<entEntityTemplate>
  public native let componentsOverrides: array<appearancePartComponentOverrides>;
}

public native class appearanceAppearanceResource extends resStreamedResource {
  public native let alternateAppearanceSettingName: CName;
  public native let alternateAppearanceSuffixes: array<CName>;
  public native let alternateAppearanceMapping: array<appearanceAlternateAppearanceEntry>;
  public native let censorshipMapping: array<appearanceCensorshipEntry>;
  public native let Wounds: array<ref<entdismembermentWoundResource>>;
  public native let DismEffects: array<ref<entdismembermentEffectResource>>;
  public native let DismWoundConfig: entdismembermentWoundsConfigSet;
  public native let baseType: CName;
  public native let baseEntityType: CName;
  public native let baseEntity: ResourceAsyncRef; // raRef<entEntityTemplate>
  public native let partType: CName;
  public native let preset: CName;
  public native let appearances: array<ref<appearanceAppearanceDefinition>>;
  public native let commonCookData: ResourceAsyncRef; // raRef<appearanceCookedAppearanceData>
  public native let proxyPolyCount: Int32;
  public native let forceCompileProxy: Bool;
  public native let generatePlayerBlockingCollisionForProxy: Bool;
}

public native struct appearanceCensorshipEntry {
  public native let Original: CName;
  public native let Censored: CName;
  public native let CensorFlags: Uint32;
}

public native struct appearanceChunkMaskSettings {
  public native let chunksIds: array<Uint64>;
  public native let meshLayout: array<Uint32>;
  public native let meshGeometryHash: Uint64;
}

public native class appearanceCookedAppearanceData extends CResource {
  public native let dependencies: array<ResourceRef>;
  public native let totalSizeOnDisk: Uint32;
}

public native struct appearancePartComponentOverrides {
  public native let componentName: CName;
  public native let meshAppearance: CName;
  public native let chunkMask: Uint64;
  public native let useCustomTransform: Bool;
  public native let initialTransform: Transform;
  public native let visualScale: Vector3;
  public native let acceptDismemberment: Bool;
}

public native class AppearancesReadyTPPRepresentationEvent extends Event {}

public native class AreaShapeOutline extends ISerializable {
  public native let points: array<Vector3>;
  public native let height: Float;
}

public native class at_uiBackendUtility extends IScriptable {
  public final native func ClickOnWidget()
  public final native func FindWidgetByATID()
  public final native func GetAllWidgetGameControllersOfType()
  public final native func GetWidgetGameControllerOfType()
}

public native class AtmosphereAreaSettings extends IAreaSettings {
  public native let skydomeColor: CurveDataHDRColor;
  public native let skylightColor: CurveDataHDRColor;
  public native let groundReflectance: CurveDataHDRColor;
  public native let sunMinZ: CurveDataFloat;
  public native let horizonMinZ: CurveDataFloat;
  public native let horizonFalloff: CurveDataFloat;
  public native let turbidity: CurveDataFloat;
  public native let lutTurbidity: CurveDataFloat;
  public native let artisticDarkeningColor: CurveDataHDRColor;
  public native let artisticDarkeningStartPoint: CurveDataFloat;
  public native let artisticDarkeningEndPoint: CurveDataFloat;
  public native let artisticDarkeningExponent: CurveDataFloat;
  public native let sunColor: CurveDataHDRColor;
  public native let sunFalloff: CurveDataFloat;
  public native let rayTracedSunShadowRange: CurveDataFloat;
  public native let moonColor: CurveDataHDRColor;
  public native let moonFalloff: CurveDataFloat;
  public native let moonGlowIntensity: CurveDataFloat;
  public native let moonGlowFalloff: CurveDataFloat;
  public native let moonTexture: ResourceRef; // rRef<CBitmapTexture>
  public native let galaxyIntensity: CurveDataFloat;
  public native let starMapIntensity: CurveDataFloat;
  public native let starMapBrightScale: CurveDataFloat;
  public native let starMapDimScale: CurveDataFloat;
  public native let starMapConstelationsScale: CurveDataFloat;
  public native let starCornerLuminanceFix: CurveDataFloat;
  public native let starMapTexture: ResourceRef; // rRef<CCubeTexture>
  public native let galaxyTexture: ResourceRef; // rRef<CBitmapTexture>
  public native let probeColorOverrideHorizon: CurveDataHDRColor;
  public native let probeAlphaOverrideHorizon: CurveDataFloat;
  public native let probeColorOverrideZenith: CurveDataHDRColor;
  public native let probeAlphaOverrideZenith: CurveDataFloat;
}

public native class AttachEntity extends Event {
  public native let entity: wref<Entity>;
}

public native struct AttachmentSlotData {
  public native let slotID: TweakDBID;
  public native let itemObject: ref<ItemObject>;
  public native let activeItemID: ItemID;
  public native let prevItemID: ItemID;
  public native let appearanceItemID: ItemID;
}

public native class AttitudePrereq extends IPrereq {
  public native let attitude: EAIAttitude;
}

public native class AttitudePrereqState extends PrereqState {}

public native class attrAttribute extends ISerializable {}

public native class attrCancelable extends attrAttribute {}

public native class attrChoice extends attrAttribute {
  public native let tions: array<String>;
}

public native class attrCommand extends attrAttribute {}

public native class attrDynamicChoice extends attrAttribute {}

public native class attrIcon extends attrAttribute {
  public native let onName: String;
}

public native class attrLabel extends attrAttribute {
  public native let xt: String;
}

public native class attrLongOperation extends attrAttribute {}

public native class attrMinMax extends attrAttribute {
  public native let n: Float;
  public native let x: Float;
}

public native class attrMinMaxVector3 extends attrAttribute {
  public native let n: Vector3;
  public native let x: Vector3;
}

public native class attrNotExposed extends attrAttribute {}

public native class attrReportsProgress extends attrAttribute {}

public native class attrSlider extends attrAttribute {
  public native let ep: Float;
}

public native class attrSoftMinMax extends attrAttribute {
  public native let n: Float;
  public native let x: Float;
}

public native class attrToggleBtn extends attrAttribute {
  public native let nLabel: String;
}

public native class attrTooltip extends attrAttribute {
  public native let xt: String;
}

@mixedRef()
public native class audioAccumulatedSoundDecoratorMetadata extends audioEmitterMetadata {
  public native let accumulatedSounds: array<CName>;
  public native let inSpammingMode: Bool;
  public native let fadeParam: CName;
  public native let soundTimeout: Float;
  public native let loopStart: CName;
  public native let loopEnd: CName;
  public native let spammingSound: CName;
  public native let spammingSoundInterval: Float;
}

@mixedRef()
public native class audioAcousticConstantsPreset extends audioAudioMetadata {
  public native let dopplerFactor: Float;
  public native let speedOfSound: Float;
  public native let wideInteriorLimit: Float;
  public native let enclosedCeilingDistance: Float;
  public native let urbanNarrowDistance: Float;
  public native let urbanStreetDistance: Float;
  public native let exteriorWideAltitude: Float;
  public native let elevatedOpenDistance: Float;
  public native let ambExteriorCeilingMinDistance: Float;
  public native let ambExteriorCeilingMaxDistance: Float;
  public native let badlandsWideRelativeAltitude: Float;
  public native let repositioningStandardZoomFactor: Float;
  public native let repositioningScanningZoomFactor: Float;
  public native let repositioningVoStandardZoomFactor: Float;
  public native let repositioningVoScanningZoomFactor: Float;
  public native let groupingExcludedVisualTags: array<CName>;
  public native let windowEventName: CName;
  public native let maxWindowOffset: Float;
}

@mixedRef()
public native class audioAcousticsEmitterMetadata extends audioEmitterMetadata {
  public native let obstuctionEnabled: Bool;
  public native let occlusionEnabled: Bool;
  public native let repositioningEnabled: Bool;
  public native let obstructionFadeTime: Float;
  public native let enableOutdoorness: Bool;
  public native let postDopplerFactor: Bool;
  public native let dopplerParameter: CName;
  public native let ignoreOcclusionRadius: Float;
  public native let elevateSource: Bool;
  public native let leakingFloorHack: Bool;
}

@mixedRef()
public native class audioAcousticZoneMetadata extends audioAudioMetadata {
  public native let priority: Int32;
  public native let bleadingDistance: Float;
  public native let eventsOnEnter: array<CName>;
  public native let eventsOnExit: array<CName>;
  public native let eventsOnActive: array<CName>;
  public native let soundBanks: array<CName>;
  public native let parameters: array<audioAcousticZoneParameterMapItem>;
  public native let reverbSettings: CName;
  public native let voReverbSettings: CName;
  public native let footstepMaterialOverride: CName;
}

@mixedRef()
public native class audioAcousticZoneParameterMapItem extends audioAudioMetadata {
  public native let param: CName;
  public native let value: Float;
  public native let enterCurveTime: Float;
  public native let exitCurveTime: Float;
}

public enum audioAdvertIndoorFilter {
  Always = 0,
  OnlyIndoor = 1,
  OnlyOutdoor = 2,
}

@mixedRef()
public native class audioAdvertMetadata extends audioEmitterMetadata {
  public native let advertSoundNames: array<CName>;
  public native let minSilenceTime: Float;
  public native let maxSilenceTime: Float;
  public native let minDistance: Float;
  public native let filter: audioAdvertIndoorFilter;
}

@mixedRef()
public native class audioAdvertSoundMetadata extends audioAudioMetadata {
  public native let audioEvent1: CName;
  public native let audioEvent2: CName;
  public native let audioEvent3: CName;
  public native let audioEvent4: CName;
  public native let useCustomDelays: Bool;
  public native let speedOfSound: Float;
  public native let soundDelay1: Float;
  public native let soundDelay2: Float;
  public native let soundDelay3: Float;
  public native let soundDelay4: Float;
}

@mixedRef()
public native class audioAmbientAreaContextActivatedASTCD extends audioAudioStateTransitionConditionData {
  public native let areaMixingContext: CName;
}

public native struct audioAmbientAreaGroupingSettings {
  public native let GroupCountTag: CName;
  public native let GroupCountRtpc: CName;
  public native let GroupAvgDistanceRtpc: CName;
  public native let groupingVariant: audioAmbientGroupingVariant;
  public native let MinDistance: Float;
  public native let MaxDistance: Float;
  public native let GroupingVerticallimit: Float;
}

public native class audioAmbientAreaNotifier extends worldITriggerAreaNotifer {
  public native let Settings: ref<audioAmbientAreaSettings>;
  public native let usePhysicsObstruction: Bool;
  public native let occlusionEnabled: Bool;
  public native let acousticRepositioningEnabled: Bool;
  public native let obstructionChangeTime: Float;
  public native let overrideRolloff: Bool;
  public native let rolloffOverride: Float;
  public native let useAutoOutdoorness: Bool;
}

public native class audioAmbientAreaNotifierInstance extends worldITriggerAreaNotiferInstance {}

@mixedRef()
public native class audioAmbientAreaSettings extends audioAudioMetadata {
  public native let MetadataParent: CName;
  public native let EmitterDecorator: CName;
  public native let Priority: Int32;
  public native let EventsOnEnter: array<audioAudEventStruct>;
  public native let EventsOnExit: array<audioAudEventStruct>;
  public native let EventsOnActive: array<audioAudEventStruct>;
  public native let SoundBanks: array<audioSoundBankStruct>;
  public native let Switches: array<audioAudSwitch>;
  public native let Parameters: array<audioAudParameter>;
  public native let Reverb: CName;
  public native let reverbTransitionTime: Float;
  public native let VoReverb: CName;
  public native let FootstepMaterialOverride: CName;
  public native let soundsLimitingSettings: CName;
  public native let isMusic: Bool;
  public native let groupingSettings: audioAmbientAreaGroupingSettings;
  public native let quadSettings: audioQuadEmitterSettings;
  public native let outerDistance: Float;
  public native let verticalOuterDistance: Float;
  public native let insideSourceDistance: Float;
  public native let eventOverrides: CName;
  public native let outdoornessOverride: Bool;
  public native let outdoorness: Float;
  public native let mergeRoomsWithinArea: Bool;
  public native let mixingContext: CName;
  public native let ambientPaletteEntries: array<audioAmbientPaletteEntry>;
}

public enum audioAmbientGroupingVariant {
  AllEntities = 0,
  IndoorEntities = 1,
  OutdoorEntities = 2,
  AllEntitiesAllDirections = 3,
  IndoorAllDirections = 4,
  OutdoorAllDirections = 5,
  SameRoomEntities = 6,
  DifferentRoomEntities = 7,
  DistanceExclusion = 8,
}

public native struct audioAmbientPaletteBrush {
  public native let distributionBucketSize: Float;
  public native let virtualHearingRadius: Float;
  public native let hearingDistanceCooldown: Float;
  public native let eventsPool: array<CName>;
  public native let radioStationMetadata: CName;
}

@mixedRef()
public native class audioAmbientPaletteBrushCategory extends audioAudioMetadata {
  public native let brushes: ref<audioAmbientPaletteBrushDictionary>;
}

@mixedRef()
public native class audioAmbientPaletteBrushDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioAmbientPaletteBrushDictionaryItem>;
  public native let entryType: ref<audioAmbientPaletteBrushDictionaryItem>;
}

@mixedRef()
public native class audioAmbientPaletteBrushDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: audioAmbientPaletteBrush;
}

public native struct audioAmbientPaletteEntry {
  public native let brushCategory: CName;
}

@mixedRef()
public native class audioAnimationOverrideDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioAnimationOverrideDictionaryItem>;
  public native let entryType: ref<audioAnimationOverrideDictionaryItem>;
}

@mixedRef()
public native class audioAnimationOverrideDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: CName;
}

@mixedRef()
public native class audioAnimationOverrideMetadata extends audioAudioMetadata {
  public native let animationOverrides: ref<audioAnimationOverrideDictionary>;
}

public native struct audioAnyStateTransitionEntry {
  public native let isDisabled: Bool;
  public native let sourceStateId: Uint8;
  public native let targetStateId: Uint8;
  public native let transitionTime: Float;
}

@mixedRef()
public native class audioAppearancesGroup extends audioAudioMetadata {
  public native let appearances: array<CName>;
}

public native struct audioAppearanceToFoleyLoopMetadata {
  public native let appearances: array<CName>;
  public native let loop: audioFoleyLoopMetadata;
}

public native struct audioAppearanceToNPCMetadata {
  public native let appearances: array<CName>;
  public native let foleyNPCMetadata: CName;
}

public native struct audioAppearanceToPlayerMetadata {
  public native let appearances: array<CName>;
  public native let foleyPlayerMetadata: CName;
  public native let priority: audioFoleyItemPriority;
}

public abstract native struct audioApplySoundPositionStrategy {}

@mixedRef()
public native class audioAudBulletTimeModeMap extends audioAudioMetadata {
  public native let bulletTimeMapItems: array<audioAudBulletTimeModeMapItem>;
}

@mixedRef()
public native class audioAudBulletTimeModeMapItem extends audioAudioMetadata {
  public native let enterEvent: CName;
  public native let exitEvent: CName;
  public native let timeModeRTPC: CName;
}

public native struct audioAudEventStruct {
  public native let event: CName;
}

@mixedRef()
public native class audioAudioAttractAreaSounds extends audioAudioMetadata {
  public native let NPCgrunts: array<audioDynamicEventsPerVisualTags>;
  public native let environmentSounds: array<audioDynamicEventsWithInterval>;
}

public native class audioAudioEventArray extends ISerializable {
  public native let isSortedByRedHash: Bool;
  public native let events: array<audioAudioEventMetadataArrayElement>;
  public native let switchGroup: array<audioAudioEventMetadataArrayElement>;
  public native let switch: array<audioAudioEventMetadataArrayElement>;
  public native let stateGroup: array<audioAudioEventMetadataArrayElement>;
  public native let state: array<audioAudioEventMetadataArrayElement>;
  public native let gameParameter: array<audioAudioEventMetadataArrayElement>;
  public native let bus: array<audioAudioEventMetadataArrayElement>;
}

public native class audioAudioEventMetadata extends ISerializable {
  public native let wwiseId: Uint32;
  public native let maxAttenuation: Float;
  public native let minDuration: Float;
  public native let maxDuration: Float;
  public native let isLooping: Bool;
  public native let stopActionEvents: array<CName>;
  public native let tags: array<CName>;
}

@mixedRef()
public native class audioAudioEventPostedASTCD extends audioAudioStateTransitionConditionData {
  public native let audioEvent: CName;
}

public native struct audioAudioFoliageMaterial {
  public native let loopStart: CName;
  public native let loopEnd: CName;
}

@mixedRef()
public native class audioAudioFoliageMaterialDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioAudioFoliageMaterialDictionaryItem>;
  public native let entryType: ref<audioAudioFoliageMaterialDictionaryItem>;
}

@mixedRef()
public native class audioAudioFoliageMaterialDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: audioAudioFoliageMaterial;
}

@mixedRef()
public native class audioAudioFoliageMetadata extends audioAudioMetadata {
  public native let loopStartEvent: CName;
  public native let loopStopEvent: CName;
  public native let locomotionTotalVelocityParam: CName;
  public native let locomotionTotalVelocityThreshold: Float;
  public native let locomotionAngularVelocityMultiplier: Float;
  public native let minFoliageMeshVolumeThreshold: Float;
  public native let maxFoliageMeshHeight: Float;
  public native let playerInsideRequiredPercentage: Float;
  public native let foliageMaterials: ref<audioAudioFoliageMaterialDictionary>;
}

@mixedRef()
public native class audioAudioMaterialMetadataMapItem extends audioAudioMetadata {
  public native let footstepsMetadata: CName;
  public native let npcFootstepsMetadata: CName;
  public native let ragdollMetadata: CName;
  public native let physicalMaterial: CName;
  public native let obstructionData: CName;
  public native let reflectionParams: CName;
  public native let meleeMaterialName: CName;
  public native let vehicleMaterialName: CName;
  public native let foliageMaterialName: CName;
  public native let foliagePaletteTag: CName;
  public native let meleeMaterialType: audioMeleeMaterialType;
}

@mixedRef()
public abstract native class audioAudioMetadata extends audioAudioMetadataBase {}

@mixedRef()
public abstract native class audioAudioMetadataBase extends ISerializable {
  public native let name: CName;
}

@mixedRef()
public native class audioAudioSceneData extends audioAudioMetadata {
  public native let anyStateArray: [audioAudioStateData; 1];
  public native let states: array<audioAudioStateData>;
  public native let anyStateTransitionsTable: array<audioAnyStateTransitionEntry>;
  public native let voLineSignals: array<audioVoLineSignal>;
  public native let signalLeadingToShutdown: CName;
  public native let templateScene: CName;
  public native let templateSceneStateOverrides: array<audioAudioSceneStateOverride>;
  public native let templateSceneSignalOverrides: array<audioAudioSceneSignalOverride>;
}

@mixedRef()
public native class audioAudioSceneDefaults extends audioAudioMetadata {
  public native let parameters: array<audioAudSimpleParameter>;
}

@mixedRef()
public native class audioAudioSceneDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioAudioSceneDictionaryItem>;
  public native let entryType: ref<audioAudioSceneDictionaryItem>;
}

@mixedRef()
public native class audioAudioSceneDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: CName;
}

public native struct audioAudioSceneSignalOverride {
  public native let templateSignal: CName;
  public native let signalOverride: CName;
}

@mixedRef()
public native class audioAudioScenesMap extends audioAudioMetadata {
  public native let defaultScene: CName;
  public native let scenesToActivateByQuestEvent: ref<audioAudioSceneDictionary>;
}

public native struct audioAudioSceneStateOverride {
  public native let templateStateName: CName;
  public native let enterEventOverride: CName;
  public native let exitEventOverride: CName;
}

public native struct audioAudioSceneVariableReadActionData {
  public native let name: CName;
  public native let comparer: audioNumberComparer;
  public native let value: Int32;
}

public native struct audioAudioSceneVariableWriteActionData {
  public native let name: CName;
  public native let operation: audioNumberOperation;
  public native let value: Int32;
}

public native struct audioAudioStateData {
  public native let stateName: CName;
  public native let enterEvent: CName;
  public native let exitEvent: CName;
  public native let exitTransitions: array<audioAudioStateTransitionData>;
  public native let mixingActions: array<audioMixingActionData>;
  public native let interruptionSources: array<CName>;
  public native let writeVariableActions: array<audioAudioSceneVariableWriteActionData>;
}

@mixedRef()
public abstract native class audioAudioStateTransitionConditionData extends audioAudioMetadata {}

public native struct audioAudioStateTransitionData {
  public native let targetStateId: Uint8;
  public native let allConditionsFulfilled: Bool;
  public native let transitionTime: Float;
  public native let exitTime: Float;
  public native let exitSignal: CName;
  public native let readVariableActions: array<audioAudioSceneVariableReadActionData>;
  public native let conditions: array<CName>;
}

public enum audioAudioVehicleCurve {
  ThrottleInput = 0,
  RPM = 1,
  Gear = 2,
}

public native struct audioAudParameter {
  public native let name: CName;
  public native let value: Float;
  public native let enterCurveType: audioESoundCurveType;
  public native let enterCurveTime: Float;
  public native let exitCurveType: audioESoundCurveType;
  public native let exitCurveTime: Float;
}

public native struct audioAudSimpleParameter {
  public native let name: CName;
  public native let value: Float;
}

public native struct audioAudSwitch {
  public native let name: CName;
  public native let value: CName;
}

public native struct audioAuxiliaryMetadata {
  public native let physicalPropSettings: CName;
}

public native struct audioBaseAudioSquadHandler {}

public native struct audioBaseRadioAnnouncementPlayer {}

public enum audiobreathingEventTag {
  Walk = 0,
  Jog = 1,
  Run = 2,
  Sneak = 3,
  Cloth = 4,
  FootStepRegular = 5,
  FootStepSprint = 6,
  LandingRegular = 7,
  LandingHard = 8,
  LandingVeryHard = 9,
  Climb = 10,
  Jump = 11,
  Player = 12,
  Stop = 13,
  Drop_Body = 14,
  Pick_Up_Body = 15,
  Standing_Event = 16,
}

public enum audiobreathingLoopBehavior {
  TimedBreathing = 0,
  BreathEvery2ndStep = 1,
  BreathEveryStep = 2,
  HoldingBreath = 3,
}

@mixedRef()
public native class audioBreathingSettings extends audioAudioMetadata {
  public native let exhaustionRtpc: CName;
  public native let idleFadeOutRtpc: CName;
  public native let initialState: CName;
}

@mixedRef()
public native class audioBreathingStateMetadata extends audioAudioMetadata {
  public native let inhaleSound: CName;
  public native let exhaleSound: CName;
  public native let paramChangeSpeed: Float;
  public native let targetBpm: Float;
  public native let targetTimeDistortion: Float;
  public native let stateMinimalTime: Float;
  public native let exhaustionChangeSpeed: Float;
  public native let targetExhaustion: Float;
  public native let loopBehavior: audiobreathingLoopBehavior;
  public native let startStateFromBreath: Bool;
}

@mixedRef()
public native class audioBreathingStateTransitionMetadata extends audioAudioMetadata {
  public native let fromNames: array<CName>;
  public native let toName: CName;
  public native let transitionStateName: CName;
  public native let conditionType: audioBreathingTransitionType;
  public native let conditionComparator: audioBreathingTransitionComparator;
  public native let value: CName;
  public native let eventTags: array<audiobreathingEventTag>;
  public native let isImmediate: Bool;
}

@mixedRef()
public native class audioBreathingTemporaryStateMetadata extends audioAudioMetadata {
  public native let inhaleSound: CName;
  public native let exhaleSound: CName;
  public native let paramChangeSpeed: Float;
  public native let targetBpm: Float;
  public native let targetTimeDistortion: Float;
  public native let time: Float;
  public native let exhaustionChangeSpeed: Float;
  public native let targetExhaustion: Float;
  public native let loopBehavior: audiobreathingLoopBehavior;
  public native let startStateFromBreath: Bool;
}

public enum audioBreathingTransitionComparator {
  Less = 0,
  Equal = 1,
  Greater = 2,
}

public enum audioBreathingTransitionType {
  PlayerSpeed = 0,
  Event = 1,
  AllEventTags = 2,
  AnyEventTag = 3,
}

@mixedRef()
public native class audioBreathingUnderwaterMetadata extends audioAudioMetadata {
  public native let inhaleSound: CName;
  public native let exhaleSound: CName;
  public native let emergenceSound: CName;
  public native let struggledEmergenceSound: CName;
  public native let divingSuitRTPC: CName;
  public native let BPM: Float;
  public native let lowOxygen: Float;
}

@mixedRef()
public native class audioBulletImpactSettings extends audioEntitySettings {
  public native let lowImpactSound: CName;
  public native let medImpactSound: CName;
  public native let hiImpactSound: CName;
  public native let critImpactSound: CName;
  public native let npcImpactSound: CName;
  public native let mediumDamageDistance: Float;
  public native let highDamageDistance: Float;
}

public enum audioClassificationMethod {
  HasAnyTag = 0,
  HasAllTags = 1,
  NameEquals = 2,
  EventNameEquals = 3,
  HasAllEventTags = 4,
}

@mixedRef()
public native class audioCombatVoManagerSettings extends audioAudioMetadata {
  public native let thresholdDbForCombatDialog: Float;
  public native let maxVoHearableHorizontalDistance: Float;
  public native let maxVoHearableVerticalDistance: Float;
  public native let maxVoVisibleDistance: Float;
  public native let triggerVoEventBufferTime: Float;
  public native let triggerIdleChattersTime: Float;
  public native let minNoVOTimeNeededToTryPlayingGenericVO: Float;
  public native let specificVoicesetVoVariationMinRepeatTime: Float;
  public native let forceApucVoiceTagSelectionProbability: Float;
  public native let voiceTagSelectionRandomTimeOffset: Float;
  public native let genericRelaxedVOContexts: array<CName>;
  public native let genericFearVOContexts: array<CName>;
  public native let genericAlertedVOContexts: array<CName>;
  public native let genericCombatVOContexts: array<CName>;
  public native let genericCombatLosingVOContexts: array<CName>;
  public native let genericCombatSingleEnemyVOContexts: array<CName>;
}

@mixedRef()
public native class audioCombatVoSettings extends audioAudioMetadata {
  public native let answerGroupName: CName;
  public native let isPlayerAlly: Bool;
  public native let contexts: CName;
  public native let voTriggerVariations: CName;
  public native let generalGruntSettings: audioGeneralVoiceGruntSettings;
  public native let voTriggerLimits: audioVoiceTriggerLimits;
  public native let overridingVoTriggerLimits: CName;
  public native let barkTriggerLimits: audioVoiceTriggerLimits;
  public native let gruntTriggerLimits: audioVoiceTriggerLimits;
  public native let minDamageToInterruptVoWithPainShort: Float;
  public native let minDamageToInterruptVoWithPainLong: Float;
}

@mixedRef()
public native class audioCombatVoTriggerVariationsMap extends audioAudioMetadata {
  public native let voTriggerVariations: array<audioCombatVoTriggerVariationsMapItem>;
}

public native struct audioCombatVoTriggerVariationsMapItem {
  public native let name: CName;
  public native let numberOfVariations: Int32;
  public native let shuffle: Bool;
}

public native struct audioCommonEntitySettings {
  public native let onAttachEvent: CName;
  public native let onDetachEvent: CName;
  public native let stopAllSoundsOnDetach: Bool;
}

@mixedRef()
public native class audioCompoundEmitterMetadata extends audioEmitterMetadata {
  public native let childrenNames: array<CName>;
}

@mixedRef()
public native class audioContextualAudEventMap extends audioAudioMetadata {
  public native let contextualAudEventMapItems: array<audioContextualAudEventMapItem>;
}

@mixedRef()
public native class audioContextualAudEventMapItem extends audioAudioMetadata {
  public native let context: CName;
  public native let event: CName;
}

public native struct audioContextualVoiceGrunt {
  public native let regularGrunt: CName;
  public native let stealthGrunt: CName;
}

public native struct audioContextualVoiceGruntSettings {
  public native let painShort: audioContextualVoiceGrunt;
  public native let effort: audioContextualVoiceGrunt;
}

public native struct audioConversationCharacterCondition {
  public native let voiceTag: CName;
  public native let characterRecordId: Uint64;
  public native let actorContextName: CName;
  public native let actorsInitialWorkspotNodeRefHash: Uint64;
}

public native struct audioConversationItemMetadata {
  public native let sceneFile: CName;
  public native let characterConditions: array<audioConversationCharacterCondition>;
  public native let shouldSceneInstanceBeSaved: Bool;
}

@mixedRef()
public native class audioConversationMetadata extends audioAudioMetadata {
  public native let conversations: array<audioConversationItemMetadata>;
}

public enum audioConversationSavingStrategy {
  Default = 0,
  Save = 1,
  DontSave = 2,
}

public native class audioCookedMetadataResource extends CResource {
  public native let entries: array<ref<audioAudioMetadata>>;
}

@mixedRef()
public native class audioCpoConversation extends audioAudioMetadata {
  public native let characterOne: audioVoCpoCharacter;
  public native let characterTwo: audioVoCpoCharacter;
  public native let voTriggers: array<CName>;
}

@mixedRef()
public abstract native class audioCustomEmitterMetadata extends audioAudioMetadata {}

@mixedRef()
public native class audioDefaultMixingSignposts extends audioAudioMetadata {
  public native let endOfCombat: CName;
  public native let inCombat: CName;
  public native let inStealth: CName;
  public native let aiAlerted: CName;
  public native let sceneBootstrapSignpost: CName;
  public native let reservedSignposts: array<CName>;
}

@mixedRef()
public abstract native class audioDeviceSettings extends audioEntitySettings {
  public native let deviceSettings: audioDeviceStateSettings;
}

public native struct audioDeviceStateSettings {
  public native let powerRestoredSound: CName;
  public native let powerCutSound: CName;
  public native let turnOnSound: CName;
  public native let turnOffSound: CName;
  public native let breakingSound: CName;
}

public native struct audioDialogLineEventData {
  public native let stringId: CRUID;
  public native let context: locVoiceoverContext;
  public native let expression: locVoiceoverExpression;
  public native let isPlayer: Bool;
  public native let isRewind: Bool;
  public native let isHolocall: Bool;
  public native let customVoEvent: CName;
  public native let seekTime: Float;
  public native let playbackSpeedParameter: Float;
}

@mixedRef()
public native class audioDirectorSystemSettings extends audioAudioMetadata {
  public native let combatVoManagerSettingsName: CName;
  public native let singleConversationMinRepeatTime: Float;
  public native let allConversationsMinRepeatTime: Float;
  public native let maxVelocityMagnitudeToConsiderPlayerVehicleInactive: Float;
  public native let maxVelocityMagnitudeToConsiderTrafficVehicleIdle: Float;
  public native let playerInactiveMinTimeNeededToEngageMovingFaster: Float;
  public native let vehEngageMovingFasterInterpolation: audioVehicleEngageMovingFasterInterpolationData;
  public native let playerBrakeEventCooldown: Float;
  public native let trafficSpeedRC: Float;
  public native let trafficAccelerationRC: Float;
  public native let trafficRpmRC: Float;
  public native let trafficSlipRatioSkidThreshold: Float;
  public native let trafficHornSingleVehicleCooldown: Float;
  public native let trafficHornAllVehiclesCooldown: Float;
  public native let trafficHornMaxDistanceRangeToPlayer: Float;
  public native let overHeadVisibilityMaxOcclusion: Float;
  public native let overHeadVisibilityMaxObstruction: Float;
  public native let conversationMixCooldown: Float;
  public native let enemyPingCooldown: Float;
  public native let idleTimeBeforeAllowingOwMusicChange: Float;
  public native let drivingStreamingAmbientEmittersDistanceRolloff: Float;
  public native let lowHealthStateMaxTime: Float;
  public native let lowGearMaxTrafficSpeed: Float;
  public native let lowGearAccelerationThreshold: Float;
  public native let mediumGearMaxTrafficSpeed: Float;
  public native let mediumGearAccelerationThreshold: Float;
  public native let highGearAccelerationThreshold: Float;
}

@mixedRef()
public native class audioDismembermentSoundSettings extends audioAudioMetadata {
  public native let headEvent: CName;
  public native let armEvent: CName;
  public native let legEvent: CName;
}

@mixedRef()
public native class audioDistanceSoundDecoratorMetadata extends audioEmitterMetadata {
  public native let onEnter: CName;
  public native let onLeave: CName;
  public native let triggerDistance: Float;
  public native let stopOnlyVirtualSounds: Bool;
}

@mixedRef()
public native class audioDoorDecoratorMetadata extends audioEmitterMetadata {
  public native let startOpen: CName;
  public native let startClose: CName;
  public native let endOpen: CName;
  public native let endClose: CName;
  public native let openLoop: CName;
  public native let closeLoop: CName;
  public native let openTime: Float;
  public native let closeTime: Float;
}

@mixedRef()
public native class audioDoorsSettings extends audioDeviceSettings {
  public native let openEvent: CName;
  public native let openFailedEvent: CName;
  public native let closeEvent: CName;
  public native let lockEvent: CName;
  public native let unlockEvent: CName;
  public native let sealEvent: CName;
  public native let soundBank: CName;
}

@mixedRef()
public native class audioDroneGlobalSettings extends audioAudioMetadata {
  public native let speedRtpc: CName;
  public native let thrustRtpc: CName;
}

@mixedRef()
public native class audioDroneMetadata extends audioCustomEmitterMetadata {
  public native let boneName: CName;
  public native let engineStart: CName;
  public native let engineStop: CName;
  public native let combatEnter: CName;
  public native let combatExit: CName;
  public native let targetLost: CName;
  public native let idle: CName;
  public native let initialReaction: CName;
  public native let investigationIgnore: CName;
  public native let noClearShot: CName;
  public native let targetComplies: CName;
  public native let lookForIntruder: CName;
  public native let droneDestroyed: CName;
  public native let droneDefeated: CName;
  public native let commandHolsterWeapon: CName;
  public native let commandLeaveArea: CName;
  public native let finalWarning: CName;
  public native let playDistance: Float;
  public native let decorators: array<CName>;
}

public native struct audioDynamicEventsPerVisualTags {
  public native let visualTags: array<CName>;
  public native let grunts: array<audioDynamicEventsWithInterval>;
}

public native struct audioDynamicEventsWithInterval {
  public native let events: array<CName>;
  public native let interval: Float;
}

@mixedRef()
public native class audioDynamicReverbSettings extends audioAudioMetadata {
  public native let reverbType: audioDynamicReverbType;
  public native let crossover1: audioReverbCrossoverParams;
  public native let crossover2: audioReverbCrossoverParams;
  public native let maxDistance: Float;
  public native let smallReverb: CName;
  public native let smallReverbMaxDistance: Float;
  public native let smallReverbFadeOutThreshold: Float;
  public native let mediumReverb: CName;
  public native let largeReverb: CName;
  public native let vehicleReverb: CName;
  public native let overrideWeaponTail: Bool;
  public native let sourceBasedReverbSet: CName;
  public native let weaponTailType: audioWeaponTailEnvironment;
  public native let echoPositionType: audioEchoPositionType;
  public native let reportPositionType: audioEchoPositionType;
}

public enum audioDynamicReverbType {
  Dynamic = 0,
  StaticSmall = 1,
  EnvironmentSmallStaticMedium = 2,
  DynamicSource = 3,
}

public enum audioEchoPositionType {
  DynamicEnvironment = 0,
  Simple = 1,
}

@mixedRef()
public native class audioEditorSelectedData extends audioAudioMetadata {
  public native let selectedWeaponConfigurationName: CName;
  public native let selectedFootstepsEventName: CName;
}

@mixedRef()
public native class audioEditorSelectedMeleeWeapon extends audioAudioMetadata {
  public native let selectedWeaponConfigurationName: CName;
}

@mixedRef()
public native class audioElevatorSettings extends audioEntitySettings {
  public native let musicEvents: audioMusicController;
  public native let movementEvents: audioLoopingSoundController;
  public native let callingEvent: CName;
  public native let destinationReachedEvent: CName;
  public native let panelSelectionEvent: CName;
}

public native class audioEmitter extends IPlacedComponent {
  public native let EmitterName: CName;
  public native let EmitterType: audioEntityEmitterContextType;
  public native let OnAttach: gameAudioSyncs;
  public native let OnDetach: gameAudioSyncs;
  public native let updateDistance: Float;
  public native let emitterMetadataName: CName;
  public native let Tags: array<CName>;
  public native let TagList: redTagList;
}

@mixedRef()
public abstract native class audioEmitterMetadata extends audioAudioMetadata {}

public enum audioEnemyState {
  InCombat = 0,
  Alerted = 1,
  Afraid = 2,
  Alive = 3,
  Dead = 4,
}

@mixedRef()
public native class audioEnemyStateCountASTCD extends audioAudioStateTransitionConditionData {
  public native let enemiesState: audioEnemyState;
  public native let countComparer: audioNumberComparer;
  public native let enemiesCount: Uint32;
}

public enum audioEntityEmitterContextType {
  Entity_Emitter = 0,
  Radio_Emitter = 2,
}

public native struct audioEntityEmitterSettings {
  public native let emitterName: CName;
  public native let positionName: CName;
  public native let emitterDecorators: array<CName>;
  public native let keepAlive: Bool;
  public native let isObjectPerPositionEmitter: Bool;
}

@mixedRef()
public native class audioEntityMetadata extends audioAudioMetadata {
  public native let fallbackDecorators: array<CName>;
  public native let defaultPositionName: CName;
  public native let defaultEmitterName: CName;
  public native let isDefaultForEntityType: CName;
  public native let preferSoundComponentPosition: Bool;
  public native let priority: Int32;
  public native let rigMetadata: CName;
  public native let emitterDescriptions: array<audioEntityEmitterSettings>;
  public native let alwaysCreateDefaultEmitter: Bool;
}

@mixedRef()
public abstract native class audioEntitySettings extends audioAudioMetadata {
  public native let commonSettings: audioCommonEntitySettings;
  public native let scanningSettings: audioScanningSettings;
  public native let auxiliaryMetadata: audioAuxiliaryMetadata;
  public native let emitterDecoratorMetadata: CName;
  public native let preferSoundComponentPosition: Bool;
}

@mixedRef()
public native class audioEnvelopeSettings extends audioAudioMetadata {
  public native let attackTime: Float;
  public native let releaseTime: Float;
  public native let holdTime: Float;
}

public enum audioESoundCurveType {
  Log3 = 0,
  Sine = 1,
  InversedSCurve = 3,
  Linear = 4,
  SCurve = 5,
  Exp1 = 6,
  ReciprocalOfSineCurve = 7,
  Exp3 = 8,
}

@mixedRef()
public native class audioEventOverrideDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioEventOverrideDictionaryItem>;
  public native let entryType: ref<audioEventOverrideDictionaryItem>;
}

@mixedRef()
public native class audioEventOverrideDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: CName;
}

@mixedRef()
public native class audioEventOverrides extends audioAudioMetadata {
  public native let eventOverrides: ref<audioEventOverrideDictionary>;
}

public native struct audioFlybySettings {
  public native let movementSpeed: Float;
  public native let flybyEvent: CName;
}

public enum audioFoleyActionType {
  FastHeavy = 0,
  FastMedium = 1,
  FastLight = 2,
  NormalHeavy = 3,
  NormalMedium = 4,
  NormalLight = 5,
  SlowHeavy = 6,
  SlowMedium = 7,
  SlowLight = 8,
  Walk = 9,
  Run = 10,
}

@mixedRef()
public native class audioFoleyAppearanceName extends audioAudioMetadata {
  public native let void: Bool;
}

@mixedRef()
public native class audioFoleyGlobalMetadata extends audioAudioMetadata {
  public native let fadeoutTime: Float;
  public native let fadeoutRtpc: CName;
}

public enum audioFoleyItemPriority {
  P0 = 0,
  P1 = 1,
  P2 = 2,
  P3 = 3,
  P4 = 4,
  P5 = 5,
  P6 = 6,
}

public enum audioFoleyItemType {
  Jacket = 0,
  Top = 1,
  Bottom = 2,
  Jewelry = 3,
}

@mixedRef()
public native class audioFoleyLoopMappingMetadata extends audioAudioMetadata {
  public native let loopsPerAppearance: array<audioAppearanceToFoleyLoopMetadata>;
  public native let loopsPerVisualTag: array<audioVisualTagToFoleyLoopMetadata>;
}

public native struct audioFoleyLoopMetadata {
  public native let startEvent: CName;
  public native let stopEvent: CName;
}

@mixedRef()
public native class audioFoleyNPCAppearanceMappingMetadata extends audioAudioMetadata {
  public native let fallbackMetadata: CName;
  public native let NPCsPerAppearance: array<audioAppearanceToNPCMetadata>;
  public native let NPCsPerMainMaterial: array<audioVisualTagToNPCMetadata>;
  public native let NPCsPerAdditive: array<audioVisualTagToNPCMetadata>;
}

@mixedRef()
public native class audioFoleyNPCMetadata extends audioAudioMetadata {
  public native let fastHeavy: audioMeleeSound;
  public native let fastMedium: audioMeleeSound;
  public native let fastLight: audioMeleeSound;
  public native let normalHeavy: audioMeleeSound;
  public native let normalMedium: audioMeleeSound;
  public native let normalLight: audioMeleeSound;
  public native let slowHeavy: audioMeleeSound;
  public native let slowMedium: audioMeleeSound;
  public native let slowLight: audioMeleeSound;
  public native let walk: audioMeleeSound;
  public native let run: audioMeleeSound;
}

@mixedRef()
public native class audioFoleyPlayerAppearanceMappingMetadata extends audioAudioMetadata {
  public native let fallbackMetadata: CName;
  public native let jacketSettings: array<audioAppearanceToPlayerMetadata>;
  public native let topSettings: array<audioAppearanceToPlayerMetadata>;
  public native let bottomSettings: array<audioAppearanceToPlayerMetadata>;
  public native let jewelrySettings: array<audioAppearanceToPlayerMetadata>;
}

public native struct audioFootstepDecalMaterialEntry {
  public native let materialTag: CName;
  public native let eventsByLocomotionState: ref<audioLocomotionStateEventDictionary>;
}

@mixedRef()
public native class audioFootstepDecalMaterialsMap extends audioAudioMetadata {
  public native let closestDecalDetectionRadius: Float;
  public native let entries: array<audioFootstepDecalMaterialEntry>;
}

@mixedRef()
public native class audioFootstepsMetadata extends audioAudioMetadata {
  public native let defaultFootwearMetadata: CName;
  public native let footwearMetadataArray: array<CName>;
  public native let slideEvent: CName;
  public native let onEnterSound: CName;
  public native let onExitSound: CName;
  public native let defaultFootwearVfxMetadata: CName;
  public native let footwearVfxMetadataArray: array<CName>;
}

@mixedRef()
public native class audioFootwearType extends audioAudioMetadata {
  public native let itemNames: array<CName>;
}

@mixedRef()
public native class audioFootwearVsMaterialMetadata extends audioAudioMetadata {
  public native let footwearType: CName;
  public native let skidEvent: CName;
  public native let defaultFootstep: CName;
  public native let locomotionStates: ref<audioLocomotionStateEventDictionary>;
  public native let customActionEvents: ref<audioLocomotionCustomActionEventDictionary>;
}

@mixedRef()
public native class audioFootwearVsMaterialVfxMetadata extends audioAudioMetadata {
  public native let footwearType: CName;
  public native let defaultVfx: ResourceAsyncRef; // raRef<CResource>
  public native let locomotionStates: ref<audioLocomotionStateVfxDictionary>;
  public native let customActionVfx: ref<audioLocomotionCustomActionVfxDictionary>;
}

public native class AudioFunctionalTests extends IScriptable {
  public final native func IsSoundbankLoaded()
}

public enum audioGameplayTier {
  Undefined = 0,
  Tier1_FullGameplay = 1,
  Tier2_StagedGameplay = 2,
  Tier3_LimitedGameplay = 3,
  Tier4_FPPCinematic = 4,
  Tier5_Cinematic = 5,
}

@mixedRef()
public native class audioGameplayTierActivatedASTCD extends audioAudioStateTransitionConditionData {
  public native let gameplayTier: audioGameplayTier;
}

@mixedRef()
public native class audioGearSweetener extends audioAudioMetadata {
  public native let gear: Uint32;
  public native let rpmThreshold: Float;
  public native let cooldown: Float;
  public native let soundEvent: CName;
  public native let burnoutFactor: Float;
}

public native struct audioGeneralVoiceGruntSettings {
  public native let variationsCount: Uint32;
  public native let painLong: CName;
  public native let agressionShort: CName;
  public native let agressionLong: CName;
  public native let longFall: CName;
  public native let death: CName;
  public native let silentDeath: CName;
  public native let grapple: CName;
  public native let grappleMovement: CName;
  public native let environmentalKnockdown: CName;
  public native let bump: CName;
  public native let curious: CName;
  public native let fear: CName;
  public native let jump: CName;
  public native let effortLong: CName;
  public native let deathShort: CName;
  public native let greet: CName;
  public native let laughHard: CName;
  public native let laughSoft: CName;
  public native let phone: CName;
  public native let braindanceExcited: CName;
  public native let braindanceFearful: CName;
  public native let braindanceNeutral: CName;
  public native let braindanceSexual: CName;
  public native let contextualVoiceGruntSettings: audioContextualVoiceGruntSettings;
  public native let gruntVariations: audioVoiceGruntVariations;
}

@mixedRef()
public native class audioGenericEntitySettings extends audioEntitySettings {}

@mixedRef()
public native class audioGenericGameplayEventOccurredASTCD extends audioAudioStateTransitionConditionData {
  public native let gameplayEvent: CName;
}

@mixedRef()
public native class audioGenericNameEventDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioGenericNameEventItem>;
  public native let entryType: ref<audioGenericNameEventItem>;
}

@mixedRef()
public native class audioGenericNameEventItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: CName;
}

@mixedRef()
public native class audioGenericNameEventMap extends audioAudioMetadata {
  public native let eventOverrides: ref<audioGenericNameEventDictionary>;
}

@mixedRef()
public native class audioGrenadeEntitySettings extends audioEntitySettings {
  public native let explosionSound: CName;
}

@mixedRef()
public native class audioGroupingCountableMetadata extends audioEmitterMetadata {
  public native let void: Bool;
}

@mixedRef()
public native class audioGroupingLimitMetadata extends audioAudioMetadata {
  public native let limit: Float;
}

@mixedRef()
public native class audioGroupingShapeClassifierMetadata extends audioAudioMetadata {
  public native let useAngle: Bool;
  public native let minGroupSize: Float;
  public native let maxGroupSize: Float;
  public native let minGroupAngleSpread: Float;
  public native let maxGroupAngleSpread: Float;
  public native let floorLimit: Bool;
  public native let ceilingLimit: Bool;
  public native let minDistanceLimit: CName;
  public native let maxDistanceLimit: CName;
}

@mixedRef()
public native class audioGroupingTagMetadata extends audioAudioMetadata {
  public native let shape: CName;
  public native let classificationMethod: audioClassificationMethod;
  public native let inputEmitterName: CName;
  public native let inputEventNames: array<CName>;
  public native let inputTags: array<CName>;
  public native let outputEventId: CName;
  public native let minimalGroupCount: Float;
  public native let fullGroupCount: Float;
}

public abstract native struct audioIBasicGameInterface {}

@mixedRef()
public native class audioInlinedAudioMetadata extends audioAudioMetadataBase {}

@mixedRef()
public native class audioKeySoundEventDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioKeySoundEventPairDictionaryItem>;
  public native let entryType: ref<audioKeySoundEventPairDictionaryItem>;
}

@mixedRef()
public native class audioKeySoundEventPairDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: CName;
}

@mixedRef()
public native class audioKeyUiControlDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioKeyUiControlPairDictionaryItem>;
  public native let entryType: ref<audioKeyUiControlPairDictionaryItem>;
}

@mixedRef()
public native class audioKeyUiControlPairDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: audioUiControl;
}

@mixedRef()
public native class audioKeyUiSoundDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioKeyUiSoundPairDictionaryItem>;
  public native let entryType: ref<audioKeyUiSoundPairDictionaryItem>;
}

@mixedRef()
public native class audioKeyUiSoundPairDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: audioUiSound;
}

public native struct audioLanguage {
  public native let longName: String;
  public native let codeName: String;
  public native let hasVO: Bool;
}

@mixedRef()
public native class audioLanguageGameConfiguration extends audioAudioMetadata {
  public native let langsInProject: array<audioLanguageMapItem>;
}

@mixedRef()
public native class audioLanguageMapItem extends audioAudioMetadata {
  public native let language: audioLanguage;
}

public native struct audioLimitedSound {
  public native let soundType: audioLimitedSoundType;
  public native let attenuationDistance: Float;
}

public enum audioLimitedSoundType {
  Locomotion = 0,
  Footsteps = 1,
  Impact = 2,
  Ragdoll = 3,
  Physics = 4,
  Destructibles = 5,
  Ono = 6,
  VO = 7,
}

@mixedRef()
public native class audioLocomotionCustomActionEventDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioLocomotionCustomActionEventDictionaryItem>;
  public native let entryType: ref<audioLocomotionCustomActionEventDictionaryItem>;
}

@mixedRef()
public native class audioLocomotionCustomActionEventDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: CName;
}

@mixedRef()
public native class audioLocomotionCustomActionType extends audioAudioMetadata {
  public native let void: Bool;
}

@mixedRef()
public native class audioLocomotionCustomActionVfxDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioLocomotionCustomActionVfxDictionaryItem>;
  public native let entryType: ref<audioLocomotionCustomActionVfxDictionaryItem>;
}

@mixedRef()
public native class audioLocomotionCustomActionVfxDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: ResourceAsyncRef; // raRef<CResource>
}

@mixedRef()
public native class audioLocomotionEmitterMetadata extends audioEmitterMetadata {
  public native let customMaterialLookup: CName;
  public native let isPlayer: Bool;
  public native let diveSuitName: CName;
}

@mixedRef()
public native class audioLocomotionEventMetadata extends audioAudioMetadata {}

@mixedRef()
public native class audioLocomotionStateEventDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioLocomotionStateEventDictionaryItem>;
  public native let entryType: ref<audioLocomotionStateEventDictionaryItem>;
}

@mixedRef()
public native class audioLocomotionStateEventDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: CName;
}

@mixedRef()
public native class audioLocomotionStateType extends audioAudioMetadata {
  public native let void: Bool;
}

@mixedRef()
public native class audioLocomotionStateVfxDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioLocomotionStateVfxDictionaryItem>;
  public native let entryType: ref<audioLocomotionStateVfxDictionaryItem>;
}

@mixedRef()
public native class audioLocomotionStateVfxDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: ResourceAsyncRef; // raRef<CResource>
}

public native struct audioLocomotionWaterContextSettings {
  public native let minDistanceBetweenImpulsesSquared: Float;
  public native let impulseStrength: Float;
  public native let impulseMinRadius: Float;
  public native let impulseMaxRadius: Float;
}

@mixedRef()
public native class audioLocomotionWaterSettings extends audioAudioMetadata {
  public native let defaultLegVfx: ResourceAsyncRef; // raRef<CResource>
  public native let locomotionStatesLegVfx: ref<audioLocomotionStateVfxDictionary>;
  public native let customActionLegVfx: ref<audioLocomotionCustomActionVfxDictionary>;
  public native let minSpeedToApplyImpulses: Float;
  public native let minHeelDepthToApplyImpulses: Float;
  public native let shallowWaterDepth: Float;
  public native let intermediateWaterDepth: Float;
  public native let shallowSettings: audioLocomotionWaterContextSettings;
  public native let intermediateSettings: audioLocomotionWaterContextSettings;
  public native let deepSettings: audioLocomotionWaterContextSettings;
  public native let minHeelDepthToSpawnFallFx: Float;
  public native let minDownwardSpeedForRegularFall: Float;
  public native let minDownwardSpeedForFastFall: Float;
  public native let regularFallVfx: ResourceAsyncRef; // raRef<CResource>
  public native let regularFallEvent: CName;
  public native let fastFallVfx: ResourceAsyncRef; // raRef<CResource>
  public native let fastFallEvent: CName;
}

@mixedRef()
public native class audioLoopedSoundEmitterMetadata extends audioEmitterMetadata {
  public native let loopSound: CName;
}

public native struct audioLoopingSoundController {
  public native let playEvent: CName;
  public native let preStopEvent: CName;
  public native let stopEvent: CName;
}

public enum audioMaterialHardnessOverride {
  None = 0,
  SetAsSoft = 1,
  SetAsSolid = 2,
  SetAsHard = 3,
}

@mixedRef()
public native class audioMaterialMeleeSoundDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioMaterialMeleeSoundDictionaryItem>;
  public native let entryType: ref<audioMaterialMeleeSoundDictionaryItem>;
}

@mixedRef()
public native class audioMaterialMeleeSoundDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: audioMeleeSound;
}

public native struct audioMaterialOverride {
  public native let base: CName;
  public native let override: CName;
}

public native struct audioMeleeAttackSettings {
  public native let hitEvent: CName;
  public native let penetratingHitEvent: CName;
  public native let criticalHitEvent: CName;
  public native let killingHitEvent: CName;
}

public native struct audioMeleeEvent {
  public native let event: CName;
  public native let params: array<audioAudSimpleParameter>;
}

public enum audioMeleeHitPerMaterialType {
  Light = 0,
  Light_Hard = 1,
  Light_Soft = 2,
  Light_Solid = 3,
  Light_Flesh = 4,
  Light_Flesh_Head = 5,
  Light_Robot = 6,
  Light_Robot_Head = 7,
  Light_Android = 8,
  Light_Android_Head = 9,
  Light_Mech = 10,
  Light_Mech_Head = 11,
  Light_Water = 12,
  Normal = 13,
  Normal_Hard = 14,
  Normal_Soft = 15,
  Normal_Solid = 16,
  Normal_Flesh = 17,
  Normal_Flesh_Head = 18,
  Normal_Robot = 19,
  Normal_Robot_Head = 20,
  Normal_Android = 21,
  Normal_Android_Head = 22,
  Normal_Mech = 23,
  Normal_Mech_Head = 24,
  Normal_Water = 25,
  Heavy = 26,
  Heavy_Hard = 27,
  Heavy_Soft = 28,
  Heavy_Solid = 29,
  Heavy_Flesh = 30,
  Heavy_Flesh_Head = 31,
  Heavy_Robot = 32,
  Heavy_Robot_Head = 33,
  Heavy_Android = 34,
  Heavy_Android_Head = 35,
  Heavy_Mech = 36,
  Heavy_Mech_Head = 37,
  Heavy_Water = 38,
  Slash = 39,
  Slash_Hard = 40,
  Slash_Soft = 41,
  Slash_Solid = 42,
  Slash_Flesh = 43,
  Slash_Flesh_Head = 44,
  Slash_Robot = 45,
  Slash_Robot_Head = 46,
  Slash_Android = 47,
  Slash_Android_Head = 48,
  Slash_Mech = 49,
  Slash_Mech_Head = 50,
  Slash_Water = 51,
  Cut = 52,
  Cut_Hard = 53,
  Cut_Soft = 54,
  Cut_Solid = 55,
  Cut_Flesh = 56,
  Cut_Flesh_Head = 57,
  Cut_Robot = 58,
  Cut_Robot_Head = 59,
  Cut_Android = 60,
  Cut_Android_Head = 61,
  Cut_Mech = 62,
  Cut_Mech_Head = 63,
  Cut_Water = 64,
  Stab = 65,
  Stab_Hard = 66,
  Stab_Soft = 67,
  Stab_Solid = 68,
  Stab_Flesh = 69,
  Stab_Flesh_Head = 70,
  Stab_Robot = 71,
  Stab_Robot_Head = 72,
  Stab_Android = 73,
  Stab_Android_Head = 74,
  Stab_Mech = 75,
  Stab_Mech_Head = 76,
  Stab_Water = 77,
  Finisher = 78,
  Finisher_Hard = 79,
  Finisher_Soft = 80,
  Finisher_Solid = 81,
  Finisher_Flesh = 82,
  Finisher_Flesh_Head = 83,
  Finisher_Robot = 84,
  Finisher_Robot_Head = 85,
  Finisher_Android = 86,
  Finisher_Android_Head = 87,
  Finisher_Mech = 88,
  Finisher_Mech_Head = 89,
  Finisher_Water = 90,
  Weak = 91,
  Weak_Hard = 92,
  Weak_Soft = 93,
  Weak_Solid = 94,
  Weak_Flesh = 95,
  Weak_Flesh_Head = 96,
  Weak_Robot = 97,
  Weak_Robot_Head = 98,
  Weak_Android = 99,
  Weak_Android_Head = 100,
  Weak_Mech = 101,
  Weak_Mech_Head = 102,
  Weak_Water = 103,
  Throw = 104,
  Throw_Hard = 105,
  Throw_Soft = 106,
  Throw_Solid = 107,
  Throw_Flesh = 108,
  Throw_Flesh_Head = 109,
  Throw_Robot = 110,
  Throw_Robot_Head = 111,
  Throw_Android = 112,
  Throw_Android_Head = 113,
  Throw_Mech = 114,
  Throw_Mech_Head = 115,
  Throw_Water = 116,
}

@mixedRef()
public native class audioMeleeHitSoundMetadata extends audioAudioMetadata {
  public native let meleeSoundsByMaterial: ref<audioMaterialMeleeSoundDictionary>;
}

public enum audioMeleeHitType {
  Light = 0,
  Normal = 1,
  Heavy = 2,
  Slash = 3,
  Cut = 4,
  Stab = 5,
  Finisher = 6,
  Weak = 7,
  Throw = 8,
}

@mixedRef()
public native class audioMeleeHitTypeMeleeSoundDictionary extends audioInlinedAudioMetadata {
  public native let entries: array<audioMeleeHitTypeMeleeSoundDictionaryItem>;
  public native let entryType: ref<audioMeleeHitTypeMeleeSoundDictionaryItem>;
}

@mixedRef()
public native class audioMeleeHitTypeMeleeSoundDictionaryItem extends audioInlinedAudioMetadata {
  public native let key: audioMeleeHitPerMaterialType;
  public native let value: audioMeleeSound;
}

public enum audioMeleeMaterialType {
  Hard = 0,
  Soft = 1,
  Solid = 2,
  Flesh = 3,
  Robot = 4,
  Android = 5,
  Mech = 6,
  Water = 7,
}

@mixedRef()
public native class audioMeleeRigMap extends audioAudioMetadata {
  public native let mapItems: array<audioMeleeRigMapItem>;
}

@mixedRef()
public native class audioMeleeRigMapItem extends audioAudioMetadata {
  public native let matchingRigs: array<CName>;
}

public native struct audioMeleeRigTypeMeleeWeaponConfigurationMap {
  public native let mapItems: array<audioMeleeRigTypeMeleeWeaponConfigurationMapItem>;
}

public native struct audioMeleeRigTypeMeleeWeaponConfigurationMapItem {
  public native let name: CName;
  public native let meleeWeaponConfiguration: CName;
}

public native struct audioMeleeSound {
  public native let events: array<audioMeleeEvent>;
}

@mixedRef()
public native class audioMeleeWeaponConfiguration extends audioAudioMetadata {
  public native let fastWhoosh: audioMeleeSound;
  public native let normalWhoosh: audioMeleeSound;
  public native let slowWhoosh: audioMeleeSound;
  public native let detailSound: audioMeleeSound;
  public native let handlingSound: audioMeleeSound;
  public native let equipSound: audioMeleeSound;
  public native let unequipSound: audioMeleeSound;
  public native let blockSound: audioMeleeSound;
  public native let parrySound: audioMeleeSound;
  public native let attackChargedThreshold: Float;
  public native let attackChargedSound: audioMeleeSound;
  public native let attackDischargedSound: audioMeleeSound;
  public native let meleeSoundsByHitPerMaterialType: ref<audioMeleeHitTypeMeleeSoundDictionary>;
  public native let meleeWeaponConfigurationsByRigTypeMap: audioMeleeRigTypeMeleeWeaponConfigurationMap;
}

@mixedRef()
public native class audioMeleeWeaponNpcSettings extends audioMeleeWeaponSettings {}

@mixedRef()
public native class audioMeleeWeaponPlayerSettings extends audioMeleeWeaponSettings {}

@mixedRef()
public abstract native class audioMeleeWeaponSettings extends audioAudioMetadata {
  public native let quickAttackSettings: audioMeleeAttackSettings;
  public native let strongAttackSettings: audioMeleeAttackSettings;
  public native let weaponHandlingSettings: audioWeaponHandlingSettings;
}

@mixedRef()
public native class audioMeleeWeaponVariations extends audioAudioMetadata {
  public native let playerWeaponConfigurationName: CName;
  public native let NPCWeaponConfigurationName: CName;
}

public native struct audioMixingActionData {
  public native let actionType: audioMixingActionType;
  public native let voContext: locVoiceoverContext;
  public native let tagValue: CName;
  public native let dbOffset: Float;
  public native let distanceRolloffFactor: Float;
  public native let voEventOverride: CName;
  public native let customParametersSetKey: Uint64;
  public native let customParameters: array<audioAudSimpleParameter>;
}

public enum audioMixingActionType {
  VoContext = 0,
  EmitterTag = 1,
  SoundTag = 2,
  ActorName = 3,
  DisableCombatVo = 4,
  GlobalParameter = 5,
}

public native struct audioMixParamDescription {
  public native let parameter: CName;
  public native let defaultValue: Float;
}

public enum audioMixParamsAction {
  Mull = 0,
  MullPercent = 1,
  MullComplemtement = 2,
  MullComplemtementPercent = 3,
  Add = 4,
}

@mixedRef()
public native class audioMixSettings extends audioAudioMetadata {
  public native let masterVolume: Float;
  public native let sfxVolume: Float;
  public native let musicVolume: Float;
  public native let voVolume: Float;
  public native let uiMenuVolume: Float;
  public native let onStartupEvent: CName;
}

public native struct audioMusicController {
  public native let playEvent: CName;
  public native let stopEvent: CName;
  public native let muteEvent: CName;
  public native let unmuteEvent: CName;
}

public enum audioMusicSyncType {
  Beat = 1,
  Bar = 0,
  Grid = 2,
  User = 3,
  EntryCue = 5,
  ExitCue = 6,
  Transition = 4,
}

@mixedRef()
public native class audioNpcGunChoirSettings extends audioAudioMetadata {
  public native let voices: array<CName>;
}

@mixedRef()
public native class audioNpcGunChoirVoice extends audioAudioMetadata {
  public native let fireSound: CName;
  public native let burstFireSound: CName;
  public native let chargedSound: CName;
  public native let autoFireSound: CName;
  public native let autoFireStop: CName;
  public native let shutdown: CName;
  public native let init: CName;
}

@mixedRef()
public native class audioNpcWeaponSettings extends audioWeaponSettings {
  public native let gunChoir: CName;
  public native let tails: CName;
  public native let obstructionEnabled: Bool;
  public native let occlusionEnabled: Bool;
  public native let repositionEnabled: Bool;
  public native let obstructionChangeTime: Float;
  public native let disablePathfinding: Bool;
  public native let voiceSwitchCooldown: Float;
  public native let reloadSound: CName;
  public native let quickMeleeAttackSound: CName;
  public native let quickMeleeHitSound: CName;
}

public enum audioNumberComparer {
  Equal = 0,
  NotEqual = 1,
  Greater = 2,
  GreaterOrEqual = 3,
  Lower = 4,
  LowerOrEqual = 5,
}

public enum audioNumberOperation {
  SetEqual = 0,
  Add = 1,
  Subtract = 2,
  MultiplyBy = 3,
  DivideBy = 4,
}

public enum audioObstructionTestPattern {
  Direct = 0,
  Cone = 1,
}

public enum audioObstructionTestType {
  SingleShot = 0,
  Continuous = 1,
}

@mixedRef()
public native class audioPanicModeVirtualizeList extends audioAudioMetadata {
  public native let tags: array<CName>;
}

@mixedRef()
public native class audioParamMixerDecoratorMetadata extends audioEmitterMetadata {
  public native let inParams: array<audioMixParamDescription>;
  public native let outputName: CName;
  public native let operation: audioMixParamsAction;
  public native let globalOutput: Bool;
}

public native struct audioPerfectChargePerkSounds {
  public native let perfectChargeChargingSound: CName;
  public native let perfectChargeChargedSound: CName;
  public native let perfectChargeShootingSound: CName;
}

@mixedRef()
public native class audioPhysicalMaterialSettings extends audioAudioMetadata {
  public native let softImpact: CName;
  public native let solidImpact: CName;
  public native let hardImpact: CName;
  public native let useFoliageSystem: Bool;
  public native let enableRollingOrScraping: Bool;
  public native let scrape: CName;
  public native let roll: CName;
  public native let materialHardnessOverride: audioMaterialHardnessOverride;
  public native let collideOnlyOnce: Bool;
  public native let bulletImpact: CName;
  public native let bulletImpactSniper: CName;
  public native let bulletImpactShotgun: CName;
  public native let bulletImpactRail: CName;
  public native let bulletImpactNpc: CName;
  public native let bulletImpactNpcSniper: CName;
  public native let bulletImpactNpcAuto: CName;
  public native let bulletImpactNpcShotgun: CName;
  public native let bulletImpactNpcRail: CName;
}

@mixedRef()
public native class audioPhysicalMaterialToAudioMetadataMatrix extends audioAudioMetadata {
  public native let physicalToAudioMaterialAssignments: array<audioAudioMaterialMetadataMapItem>;
}

@mixedRef()
public native class audioPhysicalObstructionSettings extends audioAudioMetadata {
  public native let initialAbsorbtion: Float;
  public native let absorptionPerMeter: Float;
}

@mixedRef()
public native class audioPhysicalPropSettings extends audioAudioMetadata {
  public native let shockwaveSound: CName;
  public native let damagedSound: CName;
  public native let destroyedSound: CName;
  public native let materialOverrides: array<CName>;
}

@mixedRef()
public native class audioPlayerInVehicleASTCD extends audioAudioStateTransitionConditionData {
  public native let isInside: Bool;
}

@mixedRef()
public native class audioPlayerWeaponSettings extends audioWeaponSettings {
  public native let fireSound: CName;
  public native let preFireSound: CName;
  public native let burstFireSound: CName;
  public native let autoFireSound: CName;
  public native let autoFireStop: CName;
  public native let timeLimitForAutoFireSingleShot: Float;
  public native let padVibrationGain: Float;
  public native let padVibrationReloadGain: Float;
  public native let tails: CName;
  public native let shellCasingsSettings: CName;
  public native let animEventOverrides: ref<audioWeaponEventOverrides>;
  public native let quickMeleeHitEvent: CName;
  public native let initEvent: CName;
  public native let shutdownEvent: CName;
  public native let aimEnterSound: CName;
  public native let aimExitSound: CName;
  public native let dryFireSound: CName;
  public native let reloadSound: CName;
  public native let triggerEffectSingle: CName;
  public native let triggerEffectAiming: CName;
  public native let triggerEffectAuto: CName;
  public native let perfectChargePerkSounds: audioPerfectChargePerkSounds;
}

@mixedRef()
public native class audioPlaylistEmitterMetadata extends audioEmitterMetadata {
  public native let receiverType: CName;
  public native let playlistMetadataName: CName;
}

@mixedRef()
public native class audioPlaylistMetadata extends audioAudioMetadata {
  public native let broadcastChannel: Uint8;
  public native let tracks: array<CName>;
}

public native struct audioPlaylistTrackEventStruct {
  public native let playlistName: CName;
  public native let trackName: CName;
}

@mixedRef()
public native class audioPoliceDispatcherMetadata extends audioAudioMetadata {
  public native let regularInputs: array<CName>;
  public native let playerChaseStartInputs: array<CName>;
  public native let playerChaseBackupNeededInputs: array<CName>;
  public native let playerChaseEndInputs: array<CName>;
  public native let dispatcherTimeInterval: Float;
  public native let sceneFilePath: String;
}

public native struct audioQuadEmitterSettings {
  public native let Enabled: Bool;
  public native let Interleaved: Bool;
  public native let Radius: Float;
  public native let Offset: Vector3;
  public native let Angle: Float;
  public native let Events: [audioAudEventStruct; 4];
}

public native struct audioRadioBlip {
  public native let blipEventName: CName;
}

public enum audioRadioSoundType {
  Song = 0,
  AnnouncementScene = 1,
}

public enum audioRadioSpeakerType {
  Stanley = 0,
  MaximumMike = 1,
  PoliceDispatch = 2,
  Kurtz = 3,
  Ash = 4,
  None = 5,
}

public native struct audioRadioStationJingleMetadata {
  public native let introJingleEvent: CName;
  public native let introDuration: Float;
  public native let middleJingleEvent: CName;
  public native let endJingleEvent: CName;
  public native let outroDuration: Float;
}

@mixedRef()
public native class audioRadioStationMetadata extends audioAudioMetadata {
  public native let tracks: array<CName>;
  public native let blips: array<audioRadioBlip>;
  public native let speaker: audioRadioSpeakerType;
}

@mixedRef()
public native class audioRadioStationMetadataMap extends audioAudioMetadata {
  public native let radioStations: array<CName>;
  public native let switchStationEvent: CName;
  public native let turnOnRadioEvent: CName;
  public native let turnOffRadioEvent: CName;
  public native let defaultBackgroundJingle: audioRadioStationJingleMetadata;
}

public native struct audioRadioStationSongEventStruct {
  public native let radioStationName: CName;
  public native let radioSongName: CName;
}

public native struct audioRadioTrack {
  public native let trackEventName: CName;
  public native let localizationKey: CName;
  public native let primaryLocKey: Uint64;
  public native let isStreamingFriendly: Bool;
}

@mixedRef()
public native class audioRadioTracksMetadata extends audioAudioMetadata {
  public native let radioTracks: array<audioRadioTrack>;
}

@mixedRef()
public native class audioRagdollCollisionMaterial extends audioAudioMetadata {
  public native let lightCollisionEventName: CName;
  public native let heavyCollisionEventName: CName;
  public native let dismemberedLimbCollisionEventName: CName;
}

@mixedRef()
public native class audioReflectionEmitterSettings extends audioAudioMetadata {
  public native let reflectionEvent: CName;
  public native let fadeout: Float;
  public native let reflectionDeltaThreshold: Float;
  public native let maxConcurrentReflections: Uint32;
  public native let broadcastChannel: Uint32;
  public native let listenerRelativePosition: Bool;
  public native let upReflectionEnabled: Bool;
  public native let shortReflectionIndoors: Bool;
  public native let reflectionVariant: audioReflectionVariant;
  public native let backReflectionCutoffSpread: Float;
  public native let backReflectionCutoffStrength: Float;
  public native let backReflectionCutoffSoftness: Float;
  public native let farReflectionDistance: Float;
  public native let nearReflectionDistance: Float;
  public native let minimumFaceAlignement: Float;
  public native let fixedRaycastPitch: Float;
}

@mixedRef()
public native class audioReflectionMaterialSettings extends audioAudioMetadata {
  public native let lowPass: Float;
  public native let highPass: Float;
  public native let gain: Float;
}

public enum audioReflectionVariant {
  WorldSpaceFixedDrections = 0,
  LocalSpaceFixedDirections = 1,
  FindingMaximumFaceAlignemnt = 2,
  LocalSpaceSideDirections = 3,
  FindingMaximumFaceAligment2Sides = 4,
}

public native struct audioReverbCrossoverParams {
  public native let dist: Float;
  public native let fade: Float;
}

@mixedRef()
public native class audioRigMetadata extends audioAudioMetadata {
  public native let positionBones: array<CName>;
  public native let defaultBone: CName;
}

public native struct audioScanningSettings {
  public native let scanningStartEvent: CName;
  public native let scanningStopEvent: CName;
  public native let scanningCompleteEvent: CName;
  public native let scanningAvailableEvent: CName;
}

public abstract native class audioScriptableAudioInterface extends IScriptable {}

@mixedRef()
public native class audioSecurityTurretMetadata extends audioCustomEmitterMetadata {
  public native let singleFire: CName;
  public native let activated: CName;
  public native let deactivaed: CName;
  public native let destroyed: CName;
  public native let idleStart: CName;
  public native let idleStop: CName;
  public native let triggerEffectSingle: CName;
  public native let triggerEffectAuto: CName;
  public native let obstructionEnabled: Bool;
  public native let occlusionEnabled: Bool;
}

@mixedRef()
public native class audioShockwaveGlobalSettings extends audioAudioMetadata {
  public native let explosionPropagationSpeed: Float;
  public native let thumpPropagationSpeed: Float;
  public native let electroshockPropagationSpeed: Float;
  public native let revealPropagationSpeed: Float;
}

@mixedRef()
public native class audioShockwaveMetadata extends audioEmitterMetadata {
  public native let explosionMetadataName: CName;
  public native let thumpMetadataName: CName;
  public native let electroshockMetadataName: CName;
  public native let revealMetadataName: CName;
}

@mixedRef()
public native class audioShockwavePropertyMetadata extends audioAudioMetadata {
  public native let eventName: CName;
  public native let maxDistance: Float;
  public native let probability: Float;
}

public native struct audioSoundBankStruct {
  public native let soundBank: CName;
}

@mixedRef()
public native class audioSoundsLimiterMetadata extends audioAudioMetadata {
  public native let tooManyPlayingGruntsAndVOsLimitation: array<audioLimitedSound>;
  public native let gunsAreLoudAndMusicIsActiveLimitation: array<audioLimitedSound>;
  public native let gunsAreLoudLimitation: array<audioLimitedSound>;
  public native let tooManyPlayingSoundsLimitation: array<audioLimitedSound>;
}

@mixedRef()
public native class audioSourceBasedReverbBussesMetadata extends audioAudioMetadata {
  public native let exterior: CName;
  public native let interiorLarge: CName;
  public native let interiorMedium: CName;
  public native let interiorSmall: CName;
}

@mixedRef()
public native class audioSpatialSoundLimitMetadata extends audioAudioMetadata {
  public native let eventNames: array<CName>;
  public native let writeOnlyEventNames: array<CName>;
  public native let readOnlyEventNames: array<CName>;
  public native let radius: Float;
}

@mixedRef()
public native class audioTriggerEffectMetadata extends audioAudioMetadata {
  public native let mode: audioTriggerEffectMode;
  public native let target: audioTriggerEffectTarget;
  public native let strength: Float;
  public native let startPosition: Float;
  public native let endPosition: Float;
  public native let frequency: Float;
}

public enum audioTriggerEffectMode {
  Off = 0,
  Feedback = 1,
  Weapon = 2,
  Vibration = 3,
}

public enum audioTriggerEffectTarget {
  L2 = 0,
  R2 = 1,
  Both = 2,
}

public enum audiottsvoicesFemale {
  Olivia = 7,
  Emily = 8,
  Jessica = 9,
  Sophie = 10,
  Elizabeth = 11,
  Carolina = 12,
  Sarah = 13,
}

public enum audiottsvoicesMale {
  Andrew = 0,
  Oliver = 1,
  Jack = 2,
  Harry = 3,
  Simon = 4,
  Charlie = 5,
  Thomas = 6,
}

public enum audiottsvoicesPolishFemale {
  Iwona = 16,
  Paulina = 17,
}

public enum audiottsvoicesPolishMale {
  Mateusz = 14,
  Pawel = 15,
}

public native struct audioUiControl {
  public native let uiEventsByAction: ref<audioKeyUiSoundDictionary>;
}

@mixedRef()
public native class audioUiControlEventsSettingsMapItem extends audioAudioMetadata {
  public native let baseEvent: CName;
  public native let customActionsDictionary: ref<audioKeySoundEventDictionary>;
}

@mixedRef()
public native class audioUiControlMap extends audioAudioMetadata {
  public native let uiControlsByName: ref<audioKeyUiControlDictionary>;
}

@mixedRef()
public native class audioUiGenericControlSettingsMap extends audioAudioMetadata {
  public native let uiControlMatrix: array<audioUiGenericControlSettingsMapItem>;
}

@mixedRef()
public native class audioUiGenericControlSettingsMapItem extends audioAudioMetadata {
  public native let uiEventToAudioEventDictionary: ref<audioKeySoundEventDictionary>;
}

public native struct audioUiSound {
  public native let events: array<CName>;
}

@mixedRef()
public native class audioUiSpecificControlSettingsMap extends audioAudioMetadata {
  public native let specificControlSettingsMatrix: array<audioUiSpecificControlSettingsMapItem>;
}

@mixedRef()
public native class audioUiSpecificControlSettingsMapItem extends audioAudioMetadata {
  public native let uiEventSettingsMatrix: array<audioUiControlEventsSettingsMapItem>;
}

@mixedRef()
public native class audioVehicleCollisionMap extends audioAudioMetadata {
  public native let minImpactVelocityThreshold: Float;
  public native let minRumbleVelocityThreshold: Float;
  public native let rumbleCooldown: Float;
  public native let scrapingMinTangentialVelocityThreshold: Float;
  public native let scrapingMaxCollisionCooldown: Float;
  public native let scrapingMinVehicleUpCollisionContactAngle: Float;
  public native let useScrapingMinVehicleUpCollisionContactAngle: Bool;
  public native let explosionEvent: CName;
  public native let bigFireEvent: CName;
  public native let engineFireEvent: CName;
  public native let coolerDamageEvent: CName;
  public native let interiorCollisionEvent: CName;
  public native let collisionSettings: array<audioVehicleCollisionMapItem>;
}

public native struct audioVehicleCollisionMapItem {
  public native let name: CName;
  public native let impactEvent: CName;
  public native let scrapingLoopStart: CName;
  public native let scrapingLoopEnd: CName;
}

public native struct audioVehicleDestructionGridCell {
  public native let impactEvent: CName;
  public native let impactDetailEvent: CName;
}

public native struct audioVehicleDestructionGridLayer {
  public native let backLeft: audioVehicleDestructionGridCell;
  public native let backRight: audioVehicleDestructionGridCell;
  public native let centerBackLeft: audioVehicleDestructionGridCell;
  public native let centerBackRight: audioVehicleDestructionGridCell;
  public native let centerForwardLeft: audioVehicleDestructionGridCell;
  public native let centerForwardRight: audioVehicleDestructionGridCell;
  public native let frontLeft: audioVehicleDestructionGridCell;
  public native let frontRight: audioVehicleDestructionGridCell;
}

public native struct audioVehicleDoorsSettings {
  public native let openEvent: CName;
  public native let closeEvent: CName;
}

public native struct audioVehicleDoorsSettingsMetadata {
  public native let door: audioVehicleDoorsSettings;
  public native let trunk: audioVehicleDoorsSettings;
  public native let hood: audioVehicleDoorsSettings;
}

public native struct audioVehicleEmitterPositionData {
  public native let engineEmitterPosition: Vector3;
  public native let exaustEmitterPosition: Vector3;
  public native let centralEmitterPosition: Vector3;
  public native let hoodEmitterPosition: Vector3;
  public native let trunkEmitterPosition: Vector3;
  public native let wheel1Position: Vector3;
  public native let wheel2Position: Vector3;
  public native let wheel3Position: Vector3;
  public native let wheel4Position: Vector3;
}

public native struct audioVehicleEngageMovingFasterInterpolationData {
  public native let enterCurveType: audioESoundCurveType;
  public native let enterCurveTime: Float;
  public native let exitCurveType: audioESoundCurveType;
  public native let exitCurveTime: Float;
}

public native struct audioVehicleGeneralData {
  public native let revSoundbankName: CName;
  public native let revElectricSoundbankName: CName;
  public native let reverbSoundbankName: CName;
  public native let enterVehicleEvent: CName;
  public native let exitVehicleEvent: CName;
  public native let ignitionStartEvent: CName;
  public native let ignitionEndEvent: CName;
  public native let UIStartEvent: CName;
  public native let UIEndEvent: CName;
  public native let hornOnEvent: CName;
  public native let hornOffEvent: CName;
  public native let policeHornOnEvent: CName;
  public native let policeHornOffEvent: CName;
  public native let trafficPanicHornOnEvent: CName;
  public native let trafficPanicHornOffEvent: CName;
  public native let sirenOnEvent: CName;
  public native let sirenOffEvent: CName;
  public native let rainStartEvent: CName;
  public native let rainStopEvent: CName;
  public native let waterStartEvent: CName;
  public native let waterStopEvent: CName;
  public native let tyreBurstEvent: CName;
  public native let skid: CName;
  public native let inclination: CName;
  public native let impactVelocity: CName;
  public native let impactGridCellRawChange: CName;
  public native let collisionSoundEvent: CName;
  public native let brakeApplyEvent: CName;
  public native let brakeReleaseEvent: CName;
  public native let handbrakeApplyEvent: CName;
  public native let handbrakeReleaseEvent: CName;
  public native let brakeLoopStartEvent: CName;
  public native let brakeLoopEndEvent: CName;
  public native let lightsOnEvent: CName;
  public native let lightsOffEvent: CName;
  public native let interiorReverbBus: CName;
  public native let acoustingIsolationFactor: CName;
  public native let dopplerShift: CName;
  public native let vehicleDoorsSettings: audioVehicleDoorsSettingsMetadata;
  public native let vehicleInteriorParameterData: audioVehicleInteriorParameterData;
  public native let vehicleTemperatureSettings: audioVehicleTemperatureSettings;
}

@mixedRef()
public native class audioVehicleGridDestruction extends audioAudioMetadata {
  public native let minGridCellRawChangeThreshold: Float;
  public native let specificGridCellImpactCooldown: Float;
  public native let minGridCellValueToPlayDetailedEvent: Float;
  public native let bottomLayer: audioVehicleDestructionGridLayer;
  public native let upperLayer: audioVehicleDestructionGridLayer;
}

public native struct audioVehicleInteriorParameterData {
  public native let enterCurveType: audioESoundCurveType;
  public native let enterCurveTime: Float;
  public native let enterDelayTime: Float;
  public native let exitCurveType: audioESoundCurveType;
  public native let exitCurveTime: Float;
  public native let exitDelayTime: Float;
}

public native struct audioVehicleMechanicalData {
  public native let engineStartEvent: CName;
  public native let engineStopEvent: CName;
  public native let gearUpBeginEvent: CName;
  public native let gearUpEndEvent: CName;
  public native let gearDownBeginEvent: CName;
  public native let gearDownEndEvent: CName;
  public native let throttleOnEvent: CName;
  public native let throttleOffEvent: CName;
  public native let suspensionSqueekEvent: CName;
  public native let fullThrottleAppliedEvent: CName;
  public native let acelleration: CName;
  public native let speed: CName;
  public native let gear: CName;
  public native let brake: CName;
  public native let rpm: CName;
  public native let throttle: CName;
  public native let sidewaysThrottle: CName;
  public native let thrust: CName;
  public native let temperature: CName;
}

@mixedRef()
public native class audioVehicleMetadata extends audioCustomEmitterMetadata {
  public native let generalData: audioVehicleGeneralData;
  public native let mechanicalData: audioVehicleMechanicalData;
  public native let wheelData: audioVehicleWheelData;
  public native let emitterPositionData: audioVehicleEmitterPositionData;
  public native let minRpm: Float;
  public native let maxRpm: Float;
  public native let vehicleCollisionSettings: CName;
  public native let vehicleGridDestructionSettings: CName;
  public native let vehiclePartSettings: CName;
  public native let collisionCooldown: Float;
  public native let maxPlayingDistance: Float;
  public native let dopplerFactor: Float;
  public native let suspensionSqueekTimeout: Float;
  public native let exitDelay: Float;
  public native let gearSweeteners: array<CName>;
  public native let testWheelMaterial: Bool;
  public native let hasRadioReceiver: Bool;
  public native let usesPoliceRadioStation: Bool;
  public native let acousticIsolationFactor: Float;
  public native let trafficEmitterMetadata: CName;
  public native let radioReceiverType: CName;
  public native let matchingStartupRadioStations: array<CName>;
  public native let radioPlaysWhenEngineStartsProbability: Float;
}

public native struct audioVehicleMultipliers {
  public native let throttleInputMultiplier: Float;
  public native let rpmMultiplier: Float;
}

@mixedRef()
public native class audioVehicleNpcOcclusionMetadata extends audioEmitterMetadata {
  public native let void: Bool;
}

@mixedRef()
public native class audioVehiclePartSettingsMap extends audioAudioMetadata {
  public native let minAcousticsIsolationFactorValue: Float;
  public native let partSettings: array<audioVehiclePartSettingsMapItem>;
}

public native struct audioVehiclePartSettingsMapItem {
  public native let name: CName;
  public native let onDetachEvent: CName;
  public native let onDetachAcousticsIsolationFactorReduction: Float;
}

public native struct audioVehicleTemperatureSettings {
  public native let rpmThreshold: Float;
  public native let timeToActivateTemperature: Float;
  public native let cooldownTime: Float;
}

public native struct audioVehicleWheelData {
  public native let wheelStartEvents: array<CName>;
  public native let wheelStopEvents: array<CName>;
  public native let wheelRegularSuspensionImpacts: array<CName>;
  public native let wheelLandingSuspensionImpacts: array<CName>;
  public native let suspensionPressureMultiplier: Float;
  public native let landingSuspensionPressureMultiplier: Float;
  public native let suspensionPressureLimit: Float;
  public native let minSuspensionPressureThreshold: Float;
  public native let suspensionImpactCooldown: Float;
  public native let minWheelTimeInAirBeforeLanding: Float;
}

@mixedRef()
public native class audioVehicleWheelMaterialsMap extends audioAudioMetadata {
  public native let vehicleWheelMaterials: array<audioVehicleWheelMaterialsMapItem>;
}

public native struct audioVehicleWheelMaterialsMapItem {
  public native let name: CName;
  public native let audioMaterialCoeff: Float;
}

public native struct audioVisualTagAppearanceGroup {
  public native let appearances: array<CName>;
  public native let visualTags: array<CName>;
}

@mixedRef()
public native class audioVisualTagAppearanceMapping extends audioAudioMetadata {
  public native let mappings: array<audioVisualTagAppearanceGroup>;
}

public native struct audioVisualTagToFoleyLoopMetadata {
  public native let visualtags: array<CName>;
  public native let loop: audioFoleyLoopMetadata;
}

public native struct audioVisualTagToNPCMetadata {
  public native let visualTags: array<CName>;
  public native let foleyNPCMetadata: CName;
}

public enum audioVoBarkType {
  None = 0,
  Curse = 1,
  Morale = 2,
  Combat_Aggro = 3,
  Combat_Despair = 4,
  Stealth_Curious = 5,
}

public enum audioVoCpoCharacter {
  None = 0,
  Solo = 1,
  Assassin = 2,
  Techie = 3,
  Netrunner = 4,
}

public enum audioVoGruntInterruptMode {
  DontInterrupt = 0,
  PlayOnlyOnInterrupt = 1,
  CanInterrupt = 2,
}

public enum audioVoGruntType {
  None = -1,
  PainShort = 23,
  PainLong = 0,
  AgroShort = 1,
  AgroLong = 2,
  Effort = 25,
  LongFall = 3,
  Death = 4,
  SilentDeath = 5,
  Grapple = 6,
  GrappleMovement = 7,
  EnvironmentalKnockdown = 8,
  Bump = 9,
  Curious = 10,
  Fear = 11,
  Jump = 12,
  EffortLong = 13,
  DeathShort = 14,
  Greet = 15,
  LaughHard = 16,
  LaughSoft = 17,
  Phone = 18,
  BraindanceExcited = 19,
  BraindanceFearful = 20,
  BraindanceNeutral = 21,
  BraindanceSexual = 22,
}

public native struct audioVoiceContextAnswer {
  public native let answerContext: CName;
  public native let radius: Float;
}

@mixedRef()
public native class audioVoiceContextMap extends audioAudioMetadata {
  public native let includes: array<CName>;
  public native let contexts: array<audioVoiceContextMapItem>;
}

@mixedRef()
public native class audioVoiceContextMapItem extends audioAudioMetadata {
  public native let voTrigger: CName;
  public native let bark: audioVoBarkType;
  public native let grunt: audioVoGruntType;
  public native let answer: audioVoiceContextAnswer;
  public native let overridingVoContext: locVoiceoverContext;
  public native let gruntInterruptMode: audioVoGruntInterruptMode;
}

public native struct audioVoiceGruntVariations {
  public native let cachedVariations: array<CName>;
}

public native struct audioVoiceTagAppearanceGroup {
  public native let appearances: array<CName>;
  public native let voicetags: array<CName>;
}

@mixedRef()
public native class audioVoiceTagAppearanceMapping extends audioAudioMetadata {
  public native let mappings: array<audioVoiceTagAppearanceGroup>;
}

@mixedRef()
public native class audioVoiceTagGroup extends audioAudioMetadata {
  public native let voiceTags: array<CName>;
}

public native struct audioVoiceTriggerData {
  public native let name: CName;
  public native let variationIndex: Uint32;
  public native let variationNumber: Uint32;
  public native let overridingVoContext: locVoiceoverContext;
}

public native struct audioVoiceTriggerLimits {
  public native let probability: Float;
  public native let singleNpcMinRepeatTime: Float;
  public native let allNpcsMinRepeatTime: Float;
  public native let allNpcsSharingVoicesetMinRepeatTime: Float;
  public native let combatVolume: Float;
}

@mixedRef()
public native class audioVoiceTriggerLimitsMap extends audioAudioMetadata {
  public native let includes: array<CName>;
  public native let triggers: array<audioVoiceTriggerLimitsMapItem>;
}

public native struct audioVoiceTriggerLimitsMapItem {
  public native let name: CName;
  public native let limits: audioVoiceTriggerLimits;
}

@mixedRef()
public native class audioVoiceTriggerPerSquadOrderMap extends audioAudioMetadata {
  public native let items: array<audioVoiceTriggerPerSquadOrderMapItem>;
}

public native struct audioVoiceTriggerPerSquadOrderMapItem {
  public native let name: CName;
  public native let triggerName: CName;
}

@mixedRef()
public native class audioVoiceTriggerRewireMap extends audioAudioMetadata {
  public native let includes: array<CName>;
  public native let items: array<audioVoiceTriggerRewireMapItem>;
}

public native struct audioVoiceTriggerRewireMapItem {
  public native let name: CName;
  public native let inputToBeRewiredVariationIndex: Uint32;
  public native let inputToBeActuallyPlayedName: CName;
  public native let inputToBeActuallyPlayedVariationIndex: Uint32;
  public native let allowReuse: Bool;
}

public native struct audioVoLineSignal {
  public native let ruid: CRUID;
  public native let signal: CName;
}

@mixedRef()
public native class audioWaitTimeASTCD extends audioAudioStateTransitionConditionData {
  public native let timeToWait: Float;
}

@mixedRef()
public native class audioWeaponAmmoSettingsMap extends audioAudioMetadata {
  public native let standardFlyby: audioFlybySettings;
  public native let sniperFlyby: audioFlybySettings;
  public native let shotFlyby: audioFlybySettings;
  public native let railFlyby: audioFlybySettings;
  public native let automaticFlyby: audioFlybySettings;
  public native let smartFlyby: audioFlybySettings;
  public native let smartSniperFlyby: audioFlybySettings;
  public native let hmgFlyby: audioFlybySettings;
  public native let flybyMinDistance: Float;
}

public enum audioWeaponBulletType {
  standard = 0,
  sniper = 1,
  shot = 2,
  rail = 3,
  automatic = 4,
  smart = 5,
  smart_sniper = 6,
  hmg = 7,
}

@mixedRef()
public native class audioWeaponEventOverride extends audioInlinedAudioMetadata {
  public native let key: CName;
  public native let value: CName;
}

@mixedRef()
public native class audioWeaponEventOverrides extends audioInlinedAudioMetadata {
  public native let entries: array<audioWeaponEventOverride>;
  public native let entryType: ref<audioWeaponEventOverride>;
}

public native struct audioWeaponFireModeSounds {
  public native let burst: CName;
  public native let charge: CName;
  public native let fullAuto: CName;
  public native let semiAuto: CName;
  public native let windup: CName;
}

public native struct audioWeaponHandlingSettings {
  public native let equipEvent: CName;
  public native let unequipStartedEvent: CName;
  public native let unequippedEvent: CName;
}

@mixedRef()
public abstract native class audioWeaponSettings extends audioAudioMetadata {
  public native let bulletType: audioWeaponBulletType;
  public native let shellCasingType: audioWeaponShellCasingType;
  public native let weaponHandlingSettings: audioWeaponHandlingSettings;
  public native let singleShotInSandevistan: Bool;
  public native let chargeStartSound: CName;
  public native let chargeReadySound: CName;
  public native let chargeOverchargeSound: CName;
  public native let chargeDischargeSound: CName;
  public native let fireModeSounds: audioWeaponFireModeSounds;
}

@mixedRef()
public native class audioWeaponSettingsGroup extends audioAudioMetadata {
  public native let playerSettings: CName;
  public native let playerSilenced: CName;
  public native let npcSettings: CName;
  public native let npcSilenced: CName;
}

public enum audioWeaponShellCasingDirection {
  rightFront = 0,
  rightBack = 1,
  leftFront = 2,
  leftBack = 3,
}

public enum audioWeaponShellCasingMode {
  none = 0,
  onShoot = 1,
  onReload = 2,
}

@mixedRef()
public native class audioWeaponShellCasingSettings extends audioAudioMetadata {
  public native let mode: audioWeaponShellCasingMode;
  public native let direction: audioWeaponShellCasingDirection;
  public native let firstCollisionEventName: CName;
  public native let secondCollisionEventName: CName;
  public native let initialDelay: Float;
}

public enum audioWeaponShellCasingType {
  standard = 0,
  large = 1,
  cartridge = 2,
}

public enum audioWeaponTailEnvironment {
  InteriorDefault = 0,
  InteriorWide = 1,
  ExteriorWide = 2,
  ExteriorUrbanNarrow = 3,
  ExteriorUrbanStreet = 4,
  ExteriorUrbanStreetWide = 5,
  ExteriorUrbanOpen = 6,
  ExteriorUrbanEnclosed = 7,
  ExteriorBadlandsOpen = 8,
  ExteriorBadlandsCanyon = 9,
}

@mixedRef()
public native class audioWeaponTailSettings extends audioAudioMetadata {
  public native let interiorDefault: CName;
  public native let interiorWide: CName;
  public native let interiorCar: CName;
  public native let exteriorWide: CName;
  public native let exteriorUrbanNarrow: CName;
  public native let exteriorUrbanStreet: CName;
  public native let exteriorUrbanStreetWide: CName;
  public native let exteriorUrbanOpen: CName;
  public native let exteriorUrbanEnclosed: CName;
  public native let exteriorBadlandsOpen: CName;
  public native let exteriorBadlandsCanyon: CName;
}

@mixedRef()
public native class audioWwiseIgnoredNames extends audioAudioMetadata {
  public native let ignoredNames: array<CName>;
}

public importonly class BakedDestructionComponent extends PhysicalMeshComponent {
  public native let meshFractured: ResourceAsyncRef; // raRef<CMesh>
  public native let meshFracturedAppearance: CName;
  public native let numFrames: Float;
  public native let frameRate: Float;
  public native let playOnlyOnce: Bool;
  public native let restartOnTrigger: Bool;
  public native let disableCollidersOnTrigger: Bool;
  public native let damageThreshold: Float;
  public native let damageEndurance: Float;
  public native let impulseToDamage: Float;
  public native let contactToDamage: Float;
  public native let accumulateDamage: Bool;
  public native let fractureFieldMask: Uint16; // physicsFractureFieldType
  public native let destructionEffect: ResourceAsyncRef; // raRef<worldEffect>
  public native let audioMetadata: CName;
}

public native class Bink extends CResource {}

public native class BlackboardPrereq extends IComparisonPrereq {
  public native let blackboardValue: gameBlackboardPropertyBindingDefinition;
  public native let value: Variant;
}

public native class BlackboardPrereqState extends PrereqState {}

public importonly struct BlackboardSerializableID {
  public native let blackboardName: CName;
  public native let fieldName: CName;
}

public native class BlackboardUpdateProxy extends IBlackboardUpdateProxy {}

public native class BloomAreaSettings extends IAreaSettings {
  public native let blurSizeX: Float;
  public native let blurSizeY: Float;
  public native let mipColors: [Color; 5];
  public native let mipLuminanceClamp: [Float; 3];
  public native let luminanceThresholdMin: Float;
  public native let luminanceThresholdMax: Float;
  public native let sceneColorScale: Float;
  public native let bloomColorScale: Float;
  public native let numDownsamplePasses: Uint8;
  public native let shaftsAreaSettings: ShaftsAreaSettings;
}

public native class BlurAreaSettings extends IAreaSettings {
  public native let circularBlurRadius: Float;
}

public native class BraindanceDissolveComponent extends IComponent {
  public native let dissolveRadius: Float;
}

public native class BumpAgent extends ISerializable {}

@neverRef()
public native class BumpReactionSetting extends ISerializable {
  public native let reaction: gameinteractionsBumpIntensity;
  public native let maxVelocity: Float;
}

public native class C2dArray extends CResource {
  public native let headers: array<String>;
  public native let data: array<array<String>>;
}

public native class CameraAreaSettings extends IAreaSettings {
  public native let cameraNearPlane: Float;
  public native let cameraFarPlane: Float;
  public native let automated: Bool;
  public native let ISO: Uint32;
  public native let shutterTime: Float;
  public native let fStop: Float;
}

public native struct CameraCompensationAreaSettings {
  public native let automated: Bool;
  public native let ISO: Uint32;
  public native let shutterTime: Float;
  public native let fStop: Float;
}

public native class CarriedObjectAttached extends Event {}

public native class CarriedObjectDestroy extends Event {}

public native class CasinoChips extends GameObject {
  public native let digitNames: array<CName>;
  public native let flippedDigitNames: array<CName>;
}

public native struct CBaseEngine {}

public native class CBitmapTexture extends ITexture {
  public native let width: Uint32;
  public native let height: Uint32;
  public native let depth: Uint32;
  public native let setup: STextureGroupSetup;
  public native let histBiasMulCoef: Vector3;
  public native let histBiasAddCoef: Vector3;
  public native let renderResourceBlob: ref<IRenderResourceBlob>;
  public native let renderTextureResource: rendRenderTextureResource;
}

public native struct CCombatTargetData {}

public native struct CCombatTargetDataPtr {}

public native struct CComStaticSkeletonData {
  public native let entries: array<CComStaticSkeletonDataEntry>;
}

public native struct CComStaticSkeletonDataEntry {
  public native let boneIndex: Int32;
  public native let mass: Float;
  public native let locationLS: Vector4;
}

public native class CCubeTexture extends ITexture {
  public native let setup: STextureGroupSetup;
  public native let size: Uint32;
  public native let renderResourceBlob: ref<IRenderResourceBlob>;
  public native let renderTextureResource: rendRenderTextureResource;
}

public native class CDecalSpawner extends ISerializable {
  public native let materialStatic: ResourceRef; // rRef<IMaterial>
  public native let materialSkinned: ResourceRef; // rRef<IMaterial>
  public native let specularColor: Color;
  public native let specularScale: Float;
  public native let specularBase: Float;
  public native let roughnessScale: Float;
  public native let normalThreshold: Float;
  public native let additiveNormals: Bool;
  public native let diffuseRandomColor0: Color;
  public native let diffuseRandomColor1: Color;
  public native let subUVType: ERenderDynamicDecalAtlas;
  public native let specularity: Float;
  public native let farZ: Float;
  public native let nearZ: Float;
  public native let size: ref<IEvaluatorFloat>;
  public native let depthFadePower: Float;
  public native let normalFadeBias: Float;
  public native let normalFadeScale: Float;
  public native let doubleSided: Bool;
  public native let projectionMode: ERenderDynamicDecalProjection;
  public native let decalLifetime: ref<IEvaluatorFloat>;
  public native let decalFadeTime: Float;
  public native let decalFadeInTime: Float;
  public native let projectOnStatic: Bool;
  public native let projectOnSkinned: Bool;
  public native let startScale: Float;
  public native let scaleTime: Float;
  public native let useVerticalProjection: Bool;
  public native let spawnPriority: EDynamicDecalSpawnPriority;
  public native let autoHideDistance: Float;
}

public native class CDistantLightsResource extends resStreamedResource {}

public native struct CEnvDisplaySettingsParams {
  public native let enableInstantAdaptation: Bool;
  public native let enableGlobalLightingTrajectory: Bool;
  public native let enableEnvProbeInstantUpdate: Bool;
  public native let allowEnvProbeUpdate: Bool;
  public native let allowBloom: Bool;
  public native let allowColorMod: Bool;
  public native let allowAntialiasing: Bool;
  public native let allowGlobalFog: Bool;
  public native let allowDOF: Bool;
  public native let allowSSAO: Bool;
  public native let allowCloudsShadow: Bool;
  public native let allowWaterShader: Bool;
  public native let gamma: Float;
}

public native class CEvaluatorColorConst extends IEvaluatorColor {
  public native let value: Color;
}

public native class CEvaluatorColorCurve extends IEvaluatorColor {
  public native let curves: CurveDataVector4;
  public native let numberOfCurveSamples: Uint32;
}

public native class CEvaluatorColorMultiCurve extends IEvaluatorColor {
  public native let numberOfCurveSamples: Uint32;
}

public native class CEvaluatorColorRandom extends IEvaluatorColor {
  public native let min: Color;
  public native let max: Color;
  public native let randomPerChannel: Bool;
}

public native class CEvaluatorColorStartEnd extends IEvaluatorColor {
  public native let start: Color;
  public native let end: Color;
}

public native class CEvaluatorFloatConst extends IEvaluatorFloat {
  public native let value: Float;
}

public native class CEvaluatorFloatCurve extends IEvaluatorFloat {
  public native let curves: CurveDataFloat;
  public native let numberOfCurveSamples: Uint32;
}

public native class CEvaluatorFloatRandomUniform extends IEvaluatorFloat {
  public native let min: Float;
  public native let max: Float;
}

public native class CEvaluatorFloatStartEnd extends IEvaluatorFloat {
  public native let start: Float;
  public native let end: Float;
}

public native class CEvaluatorVectorConst extends IEvaluatorVector {
  public native let value: Vector4;
}

public native class CEvaluatorVectorCurve extends IEvaluatorVector {
  public native let curves: CurveDataVector4;
  public native let numberOfCurveSamples: Uint32;
}

public native class CEvaluatorVectorMultiCurve extends IEvaluatorVector {
  public native let numberOfCurveSamples: Uint32;
}

public native class CEvaluatorVectorRandomUniform extends IEvaluatorVector {
  public native let min: Vector4;
  public native let max: Vector4;
  public native let lockX: Bool;
  public native let lockY: Bool;
  public native let lockZ: Bool;
  public native let lockW: Bool;
}

public native class CEvaluatorVectorStartEnd extends IEvaluatorVector {
  public native let start: Vector4;
  public native let end: Vector4;
}

public native class CFoliageProfile extends CResource {
  public native let cutoffAlphaMinMip: Float;
  public native let cutoffAlphaMaxMip: Float;
  public native let billboardCutoffAlpha: Float;
  public native let aoScale: Float;
  public native let terrainBlendScale: Float;
  public native let terrainBlendBias: Float;
  public native let billboardDepthScale: Float;
  public native let billboardRoughnessBias: Float;
  public native let colorGradient: ResourceRef; // rRef<CGradient>
  public native let colorGradientWeight: Float;
  public native let colorGradientDarkenWeight: Float;
  public native let preserveOriginalColor: Float;
}

public native class CGIDataResource extends resStreamedResource {
  public native let sectorHash: Uint64;
}

public native class CGradient extends CResource {
  public native let gradientEntries: array<rendGradientEntry>;
}

public native class CHairProfile extends CResource {
  public native let sampleCount: Uint16;
  public native let gradientEntriesID: array<rendGradientEntry>;
  public native let gradientEntriesRootToTip: array<rendGradientEntry>;
}

public native class ChangeAspectRatioEvent extends Event {}

public native class ChangeCameraControlHintVisibilityEvent extends Event {
  public native let movementVisible: Bool;
  public native let rotationVisible: Bool;
}

public importonly class ChangeRadioReceiverStation extends Event {}

public importonly class ChangeRadioTierEvent extends Event {}

public native class CharacterBrighteningAreaSettings extends IAreaSettings {
  public native let effectStrengthMultiplier: Float;
  public native let minDistance: Float;
  public native let maxDistance: Float;
  public native let envMultiplier: CurveDataFloat;
}

public native class ChromaticAberrationAreaSettings extends IAreaSettings {
  public native let chromaticAberrationEnabled: Bool;
  public native let chromaticAberrationMargin: Float;
  public native let chromaticAberrationSize: Vector2;
  public native let chromaticAberrationExp: Float;
  public native let subpixelDispersal: Float;
}

public native class CIESDataResource extends CResource {
  public native let samples: [Uint16; 128];
}

public native class ClothResetEvent extends Event {}

public native class CloudAreaSettings extends IAreaSettings {
  public native let cloudSunShadowFaloff: CurveDataFloat;
  public native let cloudSunScattering: CurveDataFloat;
  public native let cloudMoonScattering: CurveDataFloat;
  public native let cloudLightColor: CurveDataHDRColor;
  public native let cloudAmbientIntensity: CurveDataFloat;
  public native let cloudCirrusOpacity: CurveDataFloat;
  public native let cloudCirrusScale: CurveDataFloat;
  public native let cloudCirrusAltitude: CurveDataFloat;
  public native let cloudCirrusTexture: ResourceRef; // rRef<CBitmapTexture>
  public native let volWeatherTexture: ResourceRef; // rRef<CBitmapTexture>
  public native let volNoiseTexture: ResourceRef; // rRef<CBitmapTexture>
  public native let volHorizonCoverage: Float;
  public native let volCoverage: CurveDataFloat;
  public native let volDensity: CurveDataFloat;
  public native let cloudsBottom: Float;
  public native let cloudsTop: Float;
  public native let rayStartOffset: Float;
  public native let rayStartFalloff: Float;
  public native let lightIntensity: CurveDataFloat;
  public native let reflectionProbeLightIntensity: CurveDataFloat;
  public native let shadowIntensity: CurveDataFloat;
  public native let worldShadowIntensity: CurveDataFloat;
  public native let ambientIntensity: CurveDataFloat;
  public native let ambientOutscatter: CurveDataFloat;
  public native let inScatter: Float;
  public native let outScatter: Float;
  public native let inVsOutScatter: Float;
  public native let silverLining: Float;
  public native let volCoverageWindInfluence: Float;
  public native let volNoiseWindInfluence: Float;
  public native let volDetailWindInfluence: Float;
  public native let volDistantFogOpacity: Float;
  public native let volCoverageOffset: Vector2;
}

public native class CMaterialLayerLibrary extends CResource {
  public native let uvTiling: Float;
  public native let mbTiling: Float;
  public native let microblendContrast: Float;
  public native let paletteColorIndex: Uint32;
  public native let layers: array<MaterialLayerDef>;
  public native let microblends: array<MicroblendDef>;
}

public abstract native class CMaterialParameter extends ISerializable {
  public native let parameterName: CName;
  public native let register: Uint32;
}

public native class CMaterialParameterColor extends CMaterialParameter {
  public native let color: Color;
}

public native class CMaterialParameterCpuNameU64 extends CMaterialParameter {
  public native let name: CName;
}

public native class CMaterialParameterCube extends CMaterialParameter {
  public native let texture: ResourceRef; // rRef<ITexture>
}

public native class CMaterialParameterDynamicTexture extends CMaterialParameter {
  public native let texture: ResourceRef; // rRef<ITexture>
}

public native class CMaterialParameterFoliageParameters extends CMaterialParameter {
  public native let foliageProfile: ResourceRef; // rRef<CFoliageProfile>
}

public native class CMaterialParameterGradient extends CMaterialParameter {
  public native let gradient: ResourceRef; // rRef<CGradient>
}

public native class CMaterialParameterHairParameters extends CMaterialParameter {
  public native let hairProfile: ResourceRef; // rRef<CHairProfile>
}

public native class CMaterialParameterMultilayerMask extends CMaterialParameter {
  public native let mask: ResourceRef; // rRef<Multilayer_Mask>
}

public native class CMaterialParameterMultilayerSetup extends CMaterialParameter {
  public native let setup: ResourceRef; // rRef<Multilayer_Setup>
}

public native class CMaterialParameterScalar extends CMaterialParameter {
  public native let scalar: Float;
  public native let min: Float;
  public native let max: Float;
}

public native class CMaterialParameterSkinParameters extends CMaterialParameter {
  public native let skinProfile: ResourceRef; // rRef<CSkinProfile>
}

public native class CMaterialParameterStructBuffer extends CMaterialParameter {}

public native class CMaterialParameterTerrainSetup extends CMaterialParameter {
  public native let setup: ResourceRef; // rRef<CTerrainSetup>
}

public native class CMaterialParameterTexture extends CMaterialParameter {
  public native let texture: ResourceRef; // rRef<ITexture>
}

public native class CMaterialParameterTextureArray extends CMaterialParameter {
  public native let texture: ResourceRef; // rRef<ITexture>
}

public native class CMaterialParameterVector extends CMaterialParameter {
  public native let vector: Vector4;
}

public native class CMaterialTemplate extends IMaterialDefinition {
  public native let name: CName;
  public native let parameters: [array<ref<CMaterialParameter>>; 3];
  public native let techniques: array<MaterialTechnique>;
  public native let samplerStates: [array<SamplerStateInfo>; 3];
  public native let usedParameters: [array<MaterialUsedParameter>; 3];
  public native let materialPriority: EMaterialPriority;
  public native let materialType: ERenderMaterialType;
  public native let audioTag: CName;
  public native let resourceVersion: Uint8;
}

public native class CMesh extends resStreamedResource {
  public native let parameters: array<ref<meshMeshParameter>>;
  public native let boundingBox: Box;
  public native let surfaceAreaPerAxis: Vector3;
  public native let materialEntries: array<CMeshMaterialEntry>;
  public native let externalMaterials: array<ResourceAsyncRef>;
  public native let localMaterialInstances: array<ref<CMaterialInstance>>;
  public native let localMaterialBuffer: meshMeshMaterialBuffer;
  public native let preloadExternalMaterials: array<ResourceRef>;
  public native let preloadLocalMaterialInstances: array<ref<IMaterial>>;
  public native let inplaceResources: array<ResourceRef>;
  public native let appearances: array<ref<meshMeshAppearance>>;
  public native let objectType: ERenderObjectType;
  public native let renderResourceBlob: ref<IRenderResourceBlob>;
  public native let lodLevelInfo: array<Float>;
  public native let floatTrackNames: array<CName>;
  public native let boneNames: array<CName>;
  public native let boneRigMatrices: array<Matrix>;
  public native let boneVertexEpsilons: array<Float>;
  public native let lodBoneMask: array<Uint8>;
  public native let constrainAutoHideDistanceToTerrainHeightMap: Bool;
  public native let forceLoadAllAppearances: Bool;
  public native let castGlobalShadowsCachedInCook: Bool;
  public native let castLocalShadowsCachedInCook: Bool;
  public native let useRayTracingShadowLODBias: Bool;
  public native let castsRayTracedShadowsFromOriginalGeometry: Bool;
  public native let isShadowMesh: Bool;
  public native let isPlayerShadowMesh: Bool;
}

public native struct ColorBalance {
  public native let Red: Float;
  public native let Green: Float;
  public native let Blue: Float;
  public native let Luminance: Float;
}

public native class ColorGradingAreaSettings extends IAreaSettings {
  public native let contrast: Float;
  public native let contrastPivot: Float;
  public native let saturation: Float;
  public native let hue: Float;
  public native let brightness: Float;
  public native let lift: ColorBalance;
  public native let gammaValue: ColorBalance;
  public native let gain: ColorBalance;
  public native let offset: ColorBalance;
  public native let lowRange: Float;
  public native let shadowOffset: ColorBalance;
  public native let midtoneOffset: ColorBalance;
  public native let highRange: Float;
  public native let highlightOffset: ColorBalance;
  public native let ldrLut: ColorGradingLutParams;
  public native let hdrLut: ColorGradingLutParams;
  public native let forceHdrLut: Bool;
}

public native struct ColorGradingLutParams {
  public native let LUT: ResourceRef; // rRef<CBitmapTexture>
  public native let inputMapping: EColorMappingFunction;
  public native let outputMapping: EColorMappingFunction;
}

public native class CombatSquad extends SquadBase {}

public importonly class CommandsManager extends ICommandsManager {}

public native class communityArea extends ISerializable {
  public native let entriesData: array<communityCommunityEntrySpotsData>;
}

public native struct communityCommunityEntryPhaseSpotsData {
  public native let timePeriodsData: array<communityCommunityEntryPhaseTimePeriodData>;
  public native let entryPhaseName: CName;
}

public native struct communityCommunityEntryPhaseTimePeriodData {
  public native let periodName: CName;
  public native let spotNodeIds: array<GlobalNodeID>;
  public native let isSequence: Bool;
}

public native struct communityCommunityEntrySpotsData {
  public native let phasesData: array<communityCommunityEntryPhaseSpotsData>;
  public native let entryName: CName;
}

public native class communityCommunitySpawnSetTemplate extends communityCommunityTemplate {}

public native class communityCommunityTemplate extends CResource {
  public native let communityTemplate: ref<communityCommunityTemplateData>;
}

public native class communityCommunityTemplateData extends ISerializable {
  public native let entries: array<ref<communitySpawnEntry>>;
  public native let crowdEntries: array<gameCrowdTemplateEntry>;
  public native let spawnSetReference: CName;
}

public enum communityECommunitySpawnTime {
  Morning = 0,
  Day = 1,
  Evening = 2,
  Night = 3,
  Midnight = 4,
  _1_00 = 5,
  _2_00 = 6,
  _3_00 = 7,
  _4_00 = 8,
  _5_00 = 9,
  _6_00 = 10,
  _7_00 = 11,
  _8_00 = 12,
  _9_00 = 13,
  _10_00 = 14,
  _11_00 = 15,
  _12_00___Noon = 16,
  _13_00 = 17,
  _14_00 = 18,
  _15_00 = 19,
  _16_00 = 20,
  _17_00 = 21,
  _18_00 = 22,
  _19_00 = 23,
  _20_00 = 24,
  _21_00 = 25,
  _22_00 = 26,
  _23_00 = 27,
}

public enum communityESquadType {
  Global = 0,
  Community = 1,
  Security = 2,
  Unknown = 3,
}

public native class communityPatrolInitializer extends communitySpawnInitializer {
  public native let patrolRole: ref<AIPatrolRole>;
}

public native class communityRole extends ISerializable {
  public native let roleName: CName;
}

public native class communitySpawnEntry extends ISerializable {
  public native let entryName: CName;
  public native let characterRecordId: TweakDBID;
  public native let phases: array<ref<communitySpawnPhase>>;
  public native let spawnInView: gameSpawnInViewState;
  public native let initializers: array<ref<communitySpawnInitializer>>;
}

public abstract native class communitySpawnInitializer extends ISerializable {}

public native class communitySpawnPhase extends ISerializable {
  public native let phaseName: CName;
  public native let appearances: array<CName>;
  public native let timePeriods: array<communityPhaseTimePeriod>;
  public native let alwaysSpawned: gameAlwaysSpawnedState;
  public native let prefetchAppearance: Bool;
}

public native class communitySquadInitializer extends communitySpawnInitializer {
  public native let entries: array<communitySquadInitializerEntry>;
}

public native struct communitySquadInitializerEntry {
  public native let type: communityESquadType;
  public native let value: CName;
}

public native struct communityTimePeriod {
  public native let hour: communityECommunitySpawnTime;
}

public native class communityVoiceTagInitializer extends communitySpawnInitializer {
  public native let voiceTagName: CName;
}

public enum ConfigGraphicsQualityLevel {
  Low = 0,
  Medium = 1,
  High = 2,
  Ultra = 3,
  RaytracingLow = 5,
  RaytracingMedium = 6,
  RaytracingUltra = 7,
  RaytracingOverdrive = 8,
  Cinematic = 9,
  Cinematic_Raytracing = 10,
  CinematicEXR = 11,
  CinematicEXR_Raytracing = 12,
  PlayStation4 = 13,
  XboxOne = 14,
  PlayStation4Pro = 15,
  XboxOneX = 16,
  PlayStation5_Performance = 17,
  PlayStation5_Quality = 18,
  PlayStation5_Backcompat_Performance = 19,
  PlayStation5_Backcompat_Quality = 20,
  XboxSeriesS_Performance = 21,
  XboxSeriesS_Quality = 22,
  XboxSeriesS_Backcompat = 23,
  XboxSeriesX_Performance = 24,
  XboxSeriesX_Quality = 25,
  XboxSeriesX_Backcompat_Performance = 26,
  XboxSeriesX_Backcompat_Quality = 27,
  SteamDeck = 4,
  SafeMode = 30,
  GeForceNow = 28,
  IconsGeneration = 29,
  Auto = 31,
  GGP_Performance = 34,
  GGP_Quality = 35,
}

public enum ConfigMeshQualityLevel {
  Default = 0,
  Console = 1,
  Console_XboxSeriesS = 2,
}

public enum ConfigTextureQualityLevel {
  Console = 0,
  ConsoleSafe = 1,
  Low = 2,
  Medium = 3,
  High = 4,
  SafeMode = 5,
  Auto = 6,
}

public native struct ContactShadowsConfig {
  public native let range: Float;
  public native let rangeLimit: Float;
  public native let screenEdgeFadeRange: Float;
  public native let distanceFadeLimit: Float;
  public native let distanceFadeRange: Float;
}

public native class ContactShadowsSettings extends IAreaSettings {
  public native let contactShadows: ContactShadowsConfig;
}

public native class ContainerVisibilityChangedEvent extends Event {}

public native class ContextualLookAtAddEvent extends LookAtAddEvent {
  public native let contextName: CName;
}

public native class ContextualLookAtRemoveEvent extends LookAtRemoveEvent {
  public native let contextName: CName;
}

public native struct ConvexHull {
  public native let planes: array<Vector4>;
}

public native class CookedMultilayer_Setup extends CResource {
  public native let dependencies: array<ResourceRef>;
}

public native struct Coordinates {
  public native let latitude: Int32;
  public native let longitude: Int32;
}

public native class CorpseComponent extends ISkinableComponent {
  public native let filterData: ref<physicsFilterData>;
  public native let material: CName;
}

public native class CoverSelectionSystem extends AIICoverSelectionSystem {}

public native class cpAnimFeature_Stairs extends AnimFeature {
  public native let onOff: Bool;
}

public native class CParticleDrawerBeam extends CParticleDrawerFacingBeam {
  public native let rotation: Float;
}

public native class CParticleDrawerBillboard extends IParticleDrawer {
  public native let isGPUBased: Bool;
}

public native class CParticleDrawerEmitterOrientation extends IParticleDrawer {
  public native let coordinateSystem: EulerAngles;
  public native let isGPUBased: Bool;
}

public native class CParticleDrawerFacingBeam extends IParticleDrawer {
  public native let texturesPerUnit: Float;
  public native let dynamicTexCoords: Bool;
  public native let transparencyOffset: Float;
  public native let transparencyLength: Float;
  public native let numSegments: Uint32;
  public native let sourceTangent: Vector4;
  public native let targetTangent: Vector4;
  public native let debugTargetTranslation: Vector3;
}

public native class CParticleDrawerFacingTrail extends CParticleDrawerTrail {}

public native class CParticleDrawerMesh extends IParticleDrawer {
  public native let meshes: array<ResourceRef>;
  public native let orientationMode: EMeshParticleOrientationMode;
}

public native class CParticleDrawerMotionBlur extends IParticleDrawer {
  public native let stretchPerVelocity: Float;
  public native let isGPUBased: Bool;
}

public native class CParticleDrawerScreen extends IParticleDrawer {
  public native let isGPUBased: Bool;
}

public native class CParticleDrawerSphereAligned extends IParticleDrawer {
  public native let verticalFixed: Bool;
  public native let isGPUBased: Bool;
}

public native class CParticleDrawerTrail extends IParticleDrawer {
  public native let texturesPerUnit: Float;
  public native let dynamicTexCoords: Bool;
  public native let minSegmentsPer360Degrees: Int32;
  public native let ribbonize: Bool;
  public native let ribbonTesselationDelta: Float;
}

public native class CParticleEmitter extends IParticleModule {
  public native let modules: array<ref<IParticleModule>>;
  public native let positionX: Int32;
  public native let positionY: Int32;
  public native let material: ResourceRef; // rRef<IMaterial>
  public native let localMaterialInstance: ref<IMaterial>;
  public native let maxParticles: Uint16;
  public native let diffuseWrapFactor: Float;
  public native let backLightingFactor: Float;
  public native let lightingMipBias: Uint32;
  public native let emitterLoops: Int8;
  public native let particleDrawer: ref<IParticleDrawer>;
  public native let decalSpawner: ref<CDecalSpawner>;
  public native let maskInsideCar: Bool;
  public native let maskInsideInterior: Bool;
  public native let maskAboveWater: Bool;
  public native let maskUnderWater: Bool;
  public native let useSubFrameEmission: Bool;
  public native let keepSimulationLocal: Bool;
  public native let killOnCollision: Bool;
  public native let initialParticleCount: Uint8;
  public native let envColorGroup: EEnvColorGroup;
  public native let emitterGroup: EEmitterGroup;
  public native let renderObjectType: ERenderObjectType;
  public native let windInfluence: Float;
  public native let internalPriority: Uint8;
  public native let lods: array<SParticleEmitterLODLevel>;
  public native let renderResourceBlob: ref<IRenderResourceBlob>;
  public native let Enabled: Bool;
  public native let Relative: Bool;
  public native let UseEnvironmentFogColor: Bool;
  public native let Color: HDRColor;
  public native let Size: Float;
  public native let Density: Float;
  public native let Falloff: Float;
  public native let NoiseScale: Float;
  public native let NoiseThreshold: Float;
  public native let NoiseVelocity: Vector3;
}

public native class CParticleEventGenerator extends IParticleEvent {
  public native let evtType: EParticleEventType;
  public native let frequency: Float;
  public native let probability: Float;
}

public native class CParticleEventReceiverSpawn extends IParticleEvent {
  public native let spawnObject: EParticleEventSpawnObject;
}

public native class CParticleInitializerAlpha extends IParticleInitializer {
  public native let alpha: ref<IEvaluatorFloat>;
}

public native class CParticleInitializerColor extends IParticleInitializer {
  public native let color: ref<IEvaluatorColor>;
}

public native class CParticleInitializerLifeTime extends IParticleInitializer {
  public native let lifeTime: ref<IEvaluatorFloat>;
}

public native class CParticleInitializerPosition extends IParticleInitializer {
  public native let offset: Float;
  public native let position: ref<IEvaluatorVector>;
  public native let worldSpace: Bool;
}

public native class CParticleInitializerRotation extends IParticleInitializer {
  public native let rotation: ref<IEvaluatorFloat>;
}

public native class CParticleInitializerRotation3D extends IParticleInitializer {
  public native let rotation: ref<IEvaluatorVector>;
}

public native class CParticleInitializerRotationRate extends IParticleInitializer {
  public native let rotationRate: ref<IEvaluatorFloat>;
}

public native class CParticleInitializerRotationRate3D extends IParticleInitializer {
  public native let rotationRate: ref<IEvaluatorVector>;
}

public native class CParticleInitializerSize extends IParticleInitializer {
  public native let size: ref<IEvaluatorVector>;
  public native let scale: Float;
}

public native class CParticleInitializerSpawnBox extends IParticleInitializer {
  public native let extents: ref<IEvaluatorVector>;
  public native let worldSpace: Bool;
  public native let surfaceOnly: Bool;
}

public native class CParticleInitializerSpawnCircle extends IParticleInitializer {
  public native let innerRadius: ref<IEvaluatorFloat>;
  public native let outerRadius: ref<IEvaluatorFloat>;
  public native let surfaceOnly: Bool;
  public native let worldSpace: Bool;
  public native let spawnToLocal: Matrix;
}

public native class CParticleInitializerSpawnSphere extends IParticleInitializer {
  public native let innerRadius: ref<IEvaluatorFloat>;
  public native let outerRadius: ref<IEvaluatorFloat>;
  public native let surfaceOnly: Bool;
  public native let spawnPositiveX: Bool;
  public native let spawnNegativeX: Bool;
  public native let spawnPositiveY: Bool;
  public native let spawnNegativeY: Bool;
  public native let spawnPositiveZ: Bool;
  public native let spawnNegativeZ: Bool;
  public native let velocity: Bool;
  public native let worldSpace: Bool;
  public native let forceScale: ref<IEvaluatorFloat>;
}

public native class CParticleInitializerVelocity extends IParticleInitializer {
  public native let velocity: ref<IEvaluatorVector>;
  public native let scale: Float;
  public native let worldSpace: Bool;
}

public native class CParticleInitializerVelocityInherit extends IParticleInitializer {
  public native let scale: ref<IEvaluatorFloat>;
}

public native class CParticleInitializerVelocitySpread extends IParticleInitializer {
  public native let scale: ref<IEvaluatorFloat>;
  public native let conserveMomentum: Bool;
}

public native class CParticleModificatorAcceleration extends IParticleModificator {
  public native let direction: ref<IEvaluatorVector>;
  public native let scale: ref<IEvaluatorFloat>;
  public native let worldSpace: Bool;
}

public native class CParticleModificatorAlphaByDistance extends IParticleModificator {
  public native let nearBlendDistance: Vector2;
  public native let farBlendDistance: Vector2;
}

public native class CParticleModificatorAlphaOverEffect extends IParticleModificator {}

public native class CParticleModificatorAlphaOverLife extends IParticleModificator {
  public native let alpha: ref<IEvaluatorFloat>;
  public native let modulate: Bool;
}

public native class CParticleModificatorCollision extends IParticleModificator {
  public native let restitution: Float;
  public native let dynamicFriction: Float;
  public native let staticFriction: Float;
  public native let velocityDamp: Float;
  public native let angularVelocityDamp: Float;
  public native let particleMass: Float;
  public native let particleRadius: Float;
  public native let useGPUAcceleration: Bool;
  public native let disableGravity: Bool;
  public native let killOnCollision: Bool;
}

public native class CParticleModificatorColorOverLife extends IParticleModificator {
  public native let color: ref<IEvaluatorColor>;
  public native let modulate: Bool;
}

public native class CParticleModificatorDepthCollision extends IParticleModificator {
  public native let maxCollisions: Uint32;
  public native let restitution: Float;
  public native let friction: Float;
  public native let radius: Float;
  public native let collisionEffect: EDepthCollisionEffect;
}

public native class CParticleModificatorDrag extends IParticleModificator {
  public native let dragCoefficient: ref<IEvaluatorFloat>;
  public native let scale: Float;
}

public native class CParticleModificatorForce extends IParticleModificator {
  public native let pivot: Vector3;
  public native let radius: Float;
  public native let scale: ref<IEvaluatorFloat>;
  public native let damp: ref<IEvaluatorVector>;
}

public native class CParticleModificatorNoise extends IParticleModificator {
  public native let amplitude: ref<IEvaluatorVector>;
  public native let offset: ref<IEvaluatorVector>;
  public native let frequency: ref<IEvaluatorVector>;
  public native let changeRate: Vector3;
  public native let applyToPosition: Bool;
  public native let worldSpaceOffset: Bool;
  public native let noiseType: ENoiseType;
}

public native class CParticleModificatorOrbit extends IParticleModificator {
  public native let offset: ref<IEvaluatorVector>;
  public native let frequency: ref<IEvaluatorVector>;
  public native let phase: ref<IEvaluatorVector>;
  public native let overridePosition: Bool;
}

public native class CParticleModificatorRotation3DOverLife extends IParticleModificator {
  public native let rotation: ref<IEvaluatorVector>;
  public native let modulate: Bool;
}

public native class CParticleModificatorRotationOverLife extends IParticleModificator {
  public native let rotation: ref<IEvaluatorFloat>;
  public native let modulate: Bool;
}

public native class CParticleModificatorRotationRate3DOverLife extends IParticleModificator {
  public native let rotationRate: ref<IEvaluatorVector>;
}

public native class CParticleModificatorRotationRateOverLife extends IParticleModificator {
  public native let rotationRate: ref<IEvaluatorFloat>;
  public native let modulate: Bool;
}

public native class CParticleModificatorSizeByDistance extends IParticleModificator {
  public native let nearDistanceRangeStart: ref<IEvaluatorFloat>;
  public native let nearDistanceRangeEnd: ref<IEvaluatorFloat>;
  public native let nearDistanceSizeMultiplier: ref<IEvaluatorFloat>;
  public native let farDistanceRangeStart: ref<IEvaluatorFloat>;
  public native let farDistanceRangeEnd: ref<IEvaluatorFloat>;
  public native let farDistanceSizeMultiplier: ref<IEvaluatorFloat>;
}

public native class CParticleModificatorSizeOverLife extends IParticleModificator {
  public native let size: ref<IEvaluatorVector>;
  public native let scale: Float;
  public native let modulate: Bool;
}

public native class CParticleModificatorTarget extends IParticleModificator {
  public native let position: ref<IEvaluatorVector>;
  public native let forceScale: ref<IEvaluatorFloat>;
  public native let killRadius: ref<IEvaluatorFloat>;
  public native let maxForce: Float;
}

public native class CParticleModificatorTargetNode extends IParticleModificator {
  public native let forceScale: ref<IEvaluatorFloat>;
  public native let killRadius: ref<IEvaluatorFloat>;
  public native let maxForce: Float;
}

public native class CParticleModificatorTextureAnimation extends IParticleModificator {
  public native let initialFrame: ref<IEvaluatorFloat>;
  public native let animationSpeed: ref<IEvaluatorFloat>;
  public native let animationMode: ETextureAnimationMode;
}

public native class CParticleModificatorVectorFieldAttractor extends IParticleModificator {
  public native let inheritVelocity: Bool;
  public native let attract: Bool;
  public native let drag: Bool;
  public native let restitution: ref<IEvaluatorFloat>;
}

public native class CParticleModificatorVelocityOverLife extends IParticleModificator {
  public native let velocity: ref<IEvaluatorVector>;
  public native let scale: Float;
  public native let modulate: Bool;
  public native let absolute: Bool;
}

public native class CParticleModificatorVelocityTurbulize extends IParticleModificator {
  public native let scale: ref<IEvaluatorVector>;
  public native let timelifeLimit: ref<IEvaluatorFloat>;
  public native let noiseInterval: Float;
  public native let duration: Float;
  public native let worldSpace: Bool;
}

public native class CParticleSystem extends resStreamedResource {
  public native let visibleThroughWalls: Bool;
  public native let prewarmingTime: Float;
  public native let emitters: array<ref<CParticleEmitter>>;
  public native let boundingBox: Box;
  public native let autoHideDistance: Float;
  public native let autoHideRange: Float;
  public native let lastLODFadeoutRange: Float;
  public native let renderingPlane: ERenderingPlane;
  public native let particleDamage: ref<ParticleDamage>;
}

public native class cpBumpEvent extends Event {
  public native let amount: Uint32;
}

public native class cpConveyor extends GameObject {
  public native let lines: array<cpConveyorLine>;
  public native let movementCurve: CurveDataFloat;
  public native let entityDistance: Float;
  public native let entitySpawnOffset: Float;
  public native let audioParameterLineActive: CName;
  public native let audioParameterLineCycle: CName;
  public native let audioParameterLineSpeed: CName;
}

public native class cpConveyorComponent extends IVisualComponent {}

public native struct cpConveyorLine {
  public native let spline: NodeRef;
  public native let template: CName;
  public native let reverseDirection: Bool;
  public native let physicsValidRanges: array<Vector2>;
}

public native class cpConveyorObject extends GameObject {
  public native let rotationLerpFactor: Float;
  public native let ignoreZAxis: Bool;
}

public native class cpConveyorSetupEvent extends Event {}

public native class cpExplosiveBarrel extends gameDestructibleObject {
  public native let colliderComponentName: CName;
  public native let destructionComponentName: CName;
}

public native class cpGameplayLightComponent extends LightComponent {
  public native let reactToTime: Bool;
  public native let begin: GameTime;
  public native let end: GameTime;
  public native let probability: Float;
  public native let delayRange: GameTime;
}

public native class CPhysicsDecorationResource extends CMesh {}

public native class cpMeatBag extends GameObject {
  public native let rotationLerpFactor: Float;
  public native let kinematicBodyBoneName: CName;
  public native let bagBodyBoneName: CName;
  public native let physicalComponentName: CName;
  public native let bagHitComponentName: CName;
  public native let bagDestroyComponentName: CName;
  public native let destructionEffectName: CName;
  public native let jiggleEffectName: CName;
}

public native class cpPlayerDetector_PseudoDevice extends GameObject {
  public native let playerDetector: NodeRef;
}

public native class cpPlayerDetector extends GameObject {
  public native let range: Float;
}

public native class cpPlayerDetectorPS extends GameObjectPS {
  public native persistent let secondsCounter: Int32;
}

public native class cpSplinePlacementProvider_Count extends cpSplinePlacementProvider_Distance {
  public native let count: Uint32;
}

public native class cpSplinePlacementProvider_Distance extends cpSplinePlacementProvider {
  public native let distance: Float;
}

public abstract native class cpSplinePlacementProvider extends ISerializable {}

public native class cpStairsTrigger extends GameObject {}

public native class cpTestComponent extends GameComponent {
  public native let whatever: Float;
  public native let whateverIE: Float;
}

public native class cpTestComponentPS extends GameComponentPS {
  public native persistent let something: Int32;
  public native persistent let somethingNotInstanceEdiable: Bool;
  public native let nameEditable: CName;
  public native let nameInstanceEditable: CName;
  public native persistent let namePersistent: CName;
  public native persistent let namePersistentEdiable: CName;
  public native persistent let namePersistentInstanceEditable: CName;
}

public native class cpTestPhysXDynamicMovement extends GameObject {}

public native class cpTestPlatformController extends GameObject {
  public native let platform: NodeRef;
  public native let pointA: NodeRef;
  public native let pointB: NodeRef;
  public native let speed: Float;
}

public native class cpTimerTest extends GameObject {
  public native let counter: Int32;
}

public native class CReflectionProbeDataResource extends resStreamedResource {
  public native let textureData: rendRenderTextureResource;
  public native let dataHash: Uint64;
  public native let haveSkyData: Bool;
  public native let faceDepth: [Float; 6];
}

public native class CRenderResourceBlobContainer extends ISerializable {
  public native let blob: ref<IRenderResourceBlob>;
}

public native class CRenderSimWaterFFT extends IDynamicTextureGenerator {
  public native let windDir: Float;
  public native let windSpeed: Float;
  public native let windScale: Float;
  public native let amplitude: Float;
  public native let lambda: Float;
}

public native class CRenderSimWaterImpulse extends IDynamicTextureGenerator {
  public native let resolution: Int32;
  public native let simulationSpeed: Float;
  public final static native func AddImpulse()
}

public native class CRenderTextureMaterial extends IDynamicTextureGenerator {}

public native class CSkinProfile extends CResource {
  public native let blurSize: Float;
  public native let diffuse: Color;
  public native let falloff: Color;
  public native let roughness0: Float;
  public native let roughness1: Float;
  public native let lobeMix: Float;
}

public native class CSourceTexture extends ISerializable {
  public native let width: Uint32;
  public native let height: Uint32;
  public native let depth: Uint32;
  public native let pitch: Uint32;
  public native let format: ETextureRawFormat;
}

public native class CTerrainSetup extends CResource {
  public native let tiling: array<Float>;
  public native let physicalMaterial: array<CName>;
}

public native class CTextureArray extends ITexture {
  public native let setup: STextureGroupSetup;
  public native let renderResourceBlob: ref<IRenderResourceBlob>;
  public native let renderTextureResource: rendRenderTextureResource;
}

public native struct CTextureArrayEntry {
  public native let texture: ResourceRef; // rRef<CBitmapTexture>
}

public native class CTextureRegionSet extends CResource {
  public native let regions: array<rendTextureRegion>;
}

public native class CurrentTargetPrereq extends IPrereq {}

public native class CurrentTargetPrereqState extends PrereqState {}

public enum curveEInterpolationType {
  EIT_Constant = 0,
  EIT_Linear = 1,
  EIT_BezierQuadratic = 2,
  EIT_BezierCubic = 3,
  EIT_Hermite = 4,
}

public enum curveESegmentsLinkType {
  ESLT_Normal = 0,
  ESLT_Smooth = 1,
  ESLT_SmoothSymmetric = 2,
}

public native class CurveResourceSet extends CResource {
  public native let curveResources: array<CurveResourceSetEntry>;
}

public native struct CurveResourceSetEntry {
  public native let name: CName;
  public native let curveResRef: ResourceRef; // rRef<CurveSet>
}

public native class CurveSet extends CResource {
  public native let curves: array<CurveSetEntry>;
}

public native struct CurveSetEntry {
  public native let name: CName;
  public native let curve: CurveDataFloat;
}

public native struct curveSingleChannelCurve {
  public native let interpolationType: curveEInterpolationType;
  public native let linkType: curveESegmentsLinkType;
}

public native class CustomLightAreaSettings extends IAreaSettings {
  public native let characterLocalLightRoughnesBias: CurveDataFloat;
}

public native class CustomMoveEvent extends ActionEvent {
  public native let test: Int32;
}

public native class CustomPositionMappin extends RuntimeMappin {}

public abstract native struct CustomRequestFilter {}

public native struct CutCone {
  public native let positionAndRadius1: Vector4;
  public native let normalAndRadius2: Vector4;
  public native let height: Float;
}

public native struct CVariableStoragePtr {}

public native class CVisualDebug extends IScriptable {
  public final native func AddArrow()
  public final native func AddAxis()
  public final native func AddBar()
  public final native func AddBarColorAreas()
  public final native func AddBarColorSmooth()
  public final native func AddBox()
  public final native func AddLine()
  public final native func AddSphere()
  public final native func AddText()
  public final native func RemoveArrow()
  public final native func RemoveAxis()
  public final native func RemoveBar()
  public final native func RemoveBox()
  public final native func RemoveLine()
  public final native func RemoveSphere()
  public final native func RemoveText()
}

public native struct Cylinder {
  public native let positionAndRadius: Vector4;
  public native let normalAndHeight: Vector4;
}

public native class DamagePack extends IScriptable {
  public native let damageList: array<ref<Damage>>;
  public final native func AddDamage()
  public final native func GetDamageList()
  public final native func HasValidDamage()
}

public native class dbgSpawner extends GameObject {
  public native let objectRecordId: TweakDBID;
  public native let appearance: CName;
  public native let isActive: Bool;
  public native let alwaysSpawned: gameAlwaysSpawnedState;
}

public native class debugRuntimeSystemSpeedSplinePreview extends worldIRuntimeSystem {}

public abstract native class DestructionPersistencySystem extends IGameSystem {}

public native class DetachEntity extends Event {
  public native let entity: wref<Entity>;
}

public importonly class DeviceCameraControlComponent extends GameComponent {}

public native class DeviceInteractionManager extends IDeviceInteractionManager {}

public native class DialogLineEvent extends Event {
  public native let data: audioDialogLineEventData;
}

public native class DismemberedBodyPartEvent extends Event {
  public native let bones: [CName; 32];
}

public native class DistantFogAreaSettings extends IAreaSettings {
  public native let range: CurveDataFloat;
  public native let albedoNear: CurveDataHDRColor;
  public native let albedoFar: CurveDataHDRColor;
  public native let nearDistance: CurveDataFloat;
  public native let farDistance: CurveDataFloat;
  public native let density: CurveDataFloat;
  public native let height: CurveDataFloat;
  public native let heightFallof: CurveDataFloat;
  public native let densitySecond: CurveDataFloat;
  public native let heightSecond: CurveDataFloat;
  public native let heightFallofSecond: CurveDataFloat;
  public native let simpleColor: CurveDataHDRColor;
  public native let simpleDensity: CurveDataFloat;
  public native let envProbeColor: CurveDataHDRColor;
  public native let envProbeDensity: CurveDataFloat;
  public native let skyAltitudeBegin: CurveDataFloat;
  public native let skyAltitudeEnd: CurveDataFloat;
  public native let skyOpacity: CurveDataFloat;
}

public native class DistantIrradianceeSettings extends IAreaSettings {
  public native let distantRange: CurveDataVector2;
  public native let distantHeightRange: CurveDataVector3;
  public native let distantLights: CurveDataFloat;
  public native let distantLightsRange: CurveDataVector2;
  public native let blendDistance: CurveDataFloat;
}

public native class DistantLightsAreaSettings extends IAreaSettings {
  public native let distantLightStartDistance: Float;
  public native let distantLightFadeDistance: Float;
}

public native class DistantProxiesSettings extends IAreaSettings {
  public native let distantProxiesEmissive: Float;
  public native let distantProxiesEmissiveHeight: Float;
  public native let distantProxiesEmissivePower: Float;
  public native let distantProxiesBboxzBlend: Float;
}

public importonly class DoneActionEvent extends Event {}

public native class DrawClimbDebug extends Event {}

public native class DrawVaultDebug extends DrawClimbDebug {}

public native class DriverCombatMappinController extends BaseInteractionMappinController {}

public native class DynamicTexture extends ITexture {
  public native let width: Uint32;
  public native let height: Uint32;
  public native let scaleToViewport: Bool;
  public native let mipChain: Bool;
  public native let samplesCount: Uint8;
  public native let dataFormat: DynamicTextureDataFormat;
  public native let generator: ref<IDynamicTextureGenerator>;
}

public enum DynamicTextureDataFormat {
  R_Uint8 = 0,
  R_Float16 = 1,
  R_Float32 = 2,
  RG_Float16 = 3,
  RG_Float32 = 4,
  RGBA_Uint8 = 5,
  RGBA_Uint8_SRGB = 6,
  RGBA_Float16 = 7,
  RGBA_Float32 = 8,
}

public enum EAnimationBufferDataAvailable {
  ABDA_None = 0,
  ABDA_Partial = 1,
  ABDA_All = 2,
}

public enum EAreaLightShape {
  ALS_Sphere = 0,
  ALS_Capsule = 1,
}

public native struct EasingFunction {
  public native let transitionType: ETransitionType;
  public native let easingType: EEasingType;
}

public enum EColorChannel {
  COLCHANNEL_Red = 0,
  COLCHANNEL_Green = 1,
  COLCHANNEL_Blue = 2,
  COLCHANNEL_Alpha = 3,
}

public enum EColorMappingFunction {
  CMF_Linear = 0,
  CMF_sRGB = 1,
  CMF_ArriLogC = 2,
}

public enum EColorPrimary {
  PRIM_REC709 = 0,
  PRIM_DCIP3 = 1,
  PRIM_BT2020 = 2,
}

public enum ECookingPlatform {
  PLATFORM_None = 0,
  PLATFORM_PC = 1,
  PLATFORM_XboxOne = 2,
  PLATFORM_PS4 = 3,
  PLATFORM_PS5 = 4,
  PLATFORM_XSX = 5,
  PLATFORM_WindowsServer = 6,
  PLATFORM_LinuxServer = 7,
  PLATFORM_GGP = 8,
}

public enum ECubeSourceTextureType {
  CST_CrossHorizontal = 0,
  CST_CrossVertical = 1,
  CST_Panorama = 2,
}

public enum ECustomCameraTarget {
  ECCTV_All = 0,
  ECCTV_OnlyOffscreen = 1,
  ECCTV_OnlyOnscreen = 2,
}

public enum ECustomMaterialParam {
  ECMP_CustomParam0 = 1,
  ECMP_CustomParam1 = 2,
  ECMP_CustomParam2 = 4,
  ECMP_CustomParam3 = 8,
  ECMP_CustomParam4 = 16,
  ECMP_CustomParam5 = 32,
  ECMP_CustomParam6 = 64,
}

public enum EDecalRenderMode {
  DRM_AllStatic = 0,
  DRM_ObjectType = 1,
  DRM_AllDynamic = 2,
  DRM_All = 3,
}

public enum EDepthCollisionEffect {
  DCE_Bounce = 1,
  DCE_Glide = 2,
  DCE_Kill = 4,
}

public native class EditorMeshComponent extends MeshComponent {}

public enum EDynamicDecalSpawnPriority {
  RDDS_Normal = 0,
  RDDS_Highest = 1,
}

public enum EEasingType {
  EET_In = 0,
  EET_Out = 1,
  EET_InOut = 2,
}

public enum EEmitterGroup {
  EG_Default = 0,
  EG_Group0 = 1,
  EG_Group1 = 2,
  EG_Group2 = 3,
  EG_Group3 = 4,
  EG_Group4 = 5,
  EG_Group5 = 6,
  EG_Group6 = 7,
  EG_Group7 = 8,
  EG_Group8 = 9,
  EG_Group9 = 10,
  EG_Group10 = 11,
  EG_Group11 = 12,
  EG_Group12 = 13,
  EG_Group13 = 14,
  EG_Group14 = 15,
  EG_Group15 = 16,
}

public enum EEntityHighlightType {
  EHE_None = 0,
  EHE_FillAndOutline = 1,
  EHE_FillOnly = 2,
  EHE_OutlineOnly = 3,
}

public enum EEnvColorGroup {
  ECG_Default = 0,
  ECG_Sky = 1,
  ECG_Group0 = 2,
  ECG_Group1 = 3,
  ECG_Group2 = 4,
  ECG_Group3 = 5,
  ECG_Group4 = 6,
  ECG_Group5 = 7,
  ECG_Group6 = 8,
  ECG_Group7 = 9,
  ECG_Group8 = 10,
  ECG_Group9 = 11,
  ECG_Group10 = 12,
  ECG_Group11 = 13,
  ECG_Group12 = 14,
  ECG_Group13 = 15,
  ECG_Group14 = 16,
  ECG_Group15 = 17,
}

public enum EEnvManagerModifier {
  EMM_None = 0,
  EMM_WireframeSolid = 1,
  EMM_WireframeSeethrough = 2,
  EMM_Overdraw = 3,
  EMM_OverdrawSeethrough = 4,
  EMM_ParticleOverdraw = 5,
  EMM_ParticleNumLights = 6,
  EMM_DecalOverdraw = 7,
  EMM_LightOverdraw = 8,
  EMM_SceneReferredColor = 9,
  EMM_DisplayReferredColor = 10,
  EMM_GlobalIllumination = 11,
  EMM_SurfaceMaterialID = 12,
  EMM_SurfaceObjectID = 13,
  EMM_SurfaceBaseColor = 14,
  EMM_SurfaceAlbedo = 15,
  EMM_SurfaceSpecularity = 16,
  EMM_SurfaceMetalness = 17,
  EMM_SurfaceRoughness = 18,
  EMM_SurfaceEmissive = 19,
  EMM_SurfaceTranslucency = 20,
  EMM_SurfaceNormalsWorldSpace = 21,
  EMM_SurfaceNormalsViewSpace = 22,
  EMM_SurfaceHairDirection = 23,
  EMM_SurfaceHairID = 24,
  EMM_SurfaceLightBlockerIntensity = 25,
  EMM_GBuffer0A = 26,
  EMM_GBuffer1RGB = 27,
  EMM_GBuffer1A = 28,
  EMM_ConeAODir = 29,
  EMM_ConeAOAngle = 30,
  EMM_VelocityBuffer = 31,
  EMM_Depth = 32,
  EMM_UvDensity = 33,
  EMM_ToneMappingLuminance = 34,
  EMM_ToneMappingThresholds = 35,
  EMM_LuminanceSpotMeter = 36,
  EMM_IlluminanceMeter = 37,
  EMM_DiffuseLight = 38,
  EMM_SpecularLight = 39,
  EMM_ClayView = 40,
  EMM_PureGreyscaleView = 41,
  EMM_PureWhiteView = 42,
  EMM_PureReflectionView = 43,
  EMM_PureGreyReflectionView = 44,
  EMM_Cascades = 45,
  EMM_MaskShadow = 46,
  EMM_MaskSSAO = 47,
  EMM_MaskTXAA = 48,
  EMM_MaskDistortion = 49,
  EMM_MaskInvalidation = 50,
  EMM_MaskReactivityFSR2 = 51,
  EMM_SurfaceCacheID = 52,
  EMM_SurfaceCacheResolution = 53,
  EMM_LightChannels = 54,
  EMM_DebugHitProxies = 55,
  EMM_DebugShadowsMode = 56,
  EMM_RayTracingDebug = 57,
  EMM_SSRResults = 58,
  EMM_SSRFade = 59,
  EMM_DepthOfFieldCoC = 60,
  EMM_MultilayeredMode = 61,
  EMM_MultilayeredProxy = 62,
  EMM_MultilayeredUniqueMasks = 63,
  EMM_MultilayeredMaskWeight = 64,
  EMM_LocalShadowsVariance = 65,
  EMM_LocalShadowsRangesOverlapDynamicsOnly = 66,
  EMM_LocalShadowsRangesOverlapStaticsOnly = 67,
  EMM_LODColoring = 68,
  EMM_TodvisRuntimePreview = 69,
  EMM_TodvisBakePreview = 70,
  EMM_RainMask = 71,
  EMM_VolFogDensity = 72,
  EMM_PBRValidationBaseColor = 73,
  EMM_PBRValidationMetalness = 74,
  EMM_GreyPlayMode = 75,
  EMM_RTXDIDiffuseRaw = 76,
  EMM_RTXDISpecularRaw = 77,
  EMM_RTXDIDiffuseDenoised = 78,
  EMM_RTXDISpecularDenoised = 79,
  EMM_RTXDIBRDFFactor = 80,
  EMM_IndirectDiffuseRaw = 81,
  EMM_IndirectSpecularRaw = 82,
  EMM_IndirectDiffuseDenoised = 83,
  EMM_IndirectSpecularDenoised = 84,
}

public enum EFeatureFlag {
  FEATFLAG_Default = 0,
  FEATFLAG_Shadows = 1,
  FEATFLAG_HitProxies = 2,
  FEATFLAG_Selection = 3,
  FEATFLAG_Wireframe = 4,
  FEATFLAG_Overdraw = 10,
  FEATFLAG_VelocityBuffer = 5,
  FEATFLAG_DebugDraw_BlendOff = 6,
  FEATFLAG_DebugDraw_BlendOn = 7,
  FEATFLAG_DynamicDecals = 8,
  FEATFLAG_Highlights = 9,
  FEATFLAG_IndirectInstancedGrass = 11,
  FEATFLAG_DecalsOnStaticObjects = 12,
  FEATFLAG_DecalsOnDynamicObjects = 13,
  FEATFLAG_MaskParticlesInsideCar = 14,
  FEATFLAG_MaskParticlesInsideInterior = 15,
  FEATFLAG_MaskTXAA = 16,
  FEATFLAG_DistantShadows = 17,
  FEATFLAG_FloatTracks = 18,
  FEATFLAG_Rain = 19,
  FEATFLAG_NumLights = 20,
  FEATFLAG_DepthPrepass = 21,
  FEATFLAG_DecalsOnAllObjects = 22,
}

public abstract native class effectBaseItem extends ISerializable {}

public native class effectBloomPlayData extends effectPlacedTrackItemPlayData {}

public native class effectBoneEntries extends effectIPlacementEntries {
  public native let inheritRotation: Bool;
  public native let bones: array<effectBoneEntry>;
}

public native struct effectBoneEntry {
  public native let boneName: CName;
  public native let relativePosition: Vector3;
  public native let relativeRotation: Quaternion;
}

public native class effectCameraComponentSpawner extends effectSpawner {}

public abstract native class effectCameraComponentTrackItemPlayData extends effectTrackItemPlayData {}

public native class effectChromaticAberrationPlayData extends effectPlacedTrackItemPlayData {}

public native class effectColorGradePlayData extends effectGenericTrackItemPlayData {}

public native class effectColorGradeV2PlayData extends effectPlacedTrackItemPlayData {}

public native class effectDataMoshPlayData extends effectPlacedTrackItemPlayData {}

public native class effectDecalPlayData extends effectPlacedTrackItemPlayData {}

public native class effectDynamicDecalPlayData extends effectPlacedTrackItemPlayData {}

public native struct effectEffectParameterEvaluator {
  public native let evaluator: ref<IEvaluator>;
  public native let inputParameterOverride: CName;
}

public native struct effectEffectParameterEvaluatorColor {
  public native let evaluator: ref<IEvaluatorColor>;
  public native let inputParameterOverride: CName;
}

public native struct effectEffectParameterEvaluatorFloat {
  public native let evaluator: ref<IEvaluatorFloat>;
  public native let inputParameterOverride: CName;
  public native let inputParameterIsPostMultiplier: Bool;
}

public native struct effectEffectParameterEvaluatorVector {
  public native let evaluator: ref<IEvaluatorVector>;
  public native let inputParameterOverride: CName;
}

public native class effectEmissivePlayData extends effectPlacedTrackItemPlayData {}

public native class effectExposureScalePlayData extends effectPlacedTrackItemPlayData {}

public native class effectFilmGrainPlayData extends effectPlacedTrackItemPlayData {}

public native class effectFogVolumePlayData extends effectPlacedTrackItemPlayData {}

public native class effectForwardDecalPlayData extends effectPlacedTrackItemPlayData {}

public native class effectFOVPlayData extends effectPlacedTrackItemPlayData {}

public abstract native class effectGenericTrackItemPlayData extends effectTrackItemPlayData {}

public native class effectHudParameterPlayData extends effectVisualComponentTrackItemPlayData {}

public abstract native class effectIPlacementEntries extends ISerializable {}

public native class effectLightParameterPlayData extends effectVisualComponentTrackItemPlayData {}

public native struct effectLoopData {
  public native let startTime: Float;
  public native let endTime: Float;
}

public native class effectMaterialParameterPlayData extends effectVisualComponentTrackItemPlayData {}

public native class effectMotionBlurScalePlayData extends effectCameraComponentTrackItemPlayData {}

public importonly class EffectorObject extends ISerializable {}

public native class effectParticlesPlayData extends effectPlacedTrackItemPlayData {}

public native class effectPlacedSpawner extends effectSpawner {
  public native let placement: ref<effectIPlacementEntries>;
}

public abstract native class effectPlacedTrackItemPlayData extends effectTrackItemPlayData {}

public native class effectPointLightPlayData extends effectPlacedTrackItemPlayData {}

public native class effectRootEntries extends effectIPlacementEntries {
  public native let inheritRotation: Bool;
  public native let roots: array<effectRootEntry>;
}

public native struct effectRootEntry {
  public native let relativePosition: Vector3;
  public native let relativeRotation: Quaternion;
}

public native class effectSlotEntries extends effectIPlacementEntries {
  public native let inheritRotation: Bool;
  public native let slots: array<effectSlotEntry>;
}

public native struct effectSlotEntry {
  public native let slotName: CName;
  public native let relativePosition: Vector3;
  public native let relativeRotation: Quaternion;
}

public native class effectSoundPlayData extends effectPlacedTrackItemPlayData {}

public native class effectSpawner extends ISerializable {}

public native class effectTonemappingPlayData extends effectPlacedTrackItemPlayData {}

public native class effectTrack extends effectTrackBase {
  public native let items: array<ref<effectTrackItem>>;
}

public native class effectTrackBase extends effectBaseItem {}

public native class effectTrackGroup extends effectTrackBase {
  public native let tracks: array<ref<effectTrackBase>>;
  public native let componentName: CName;
}

public abstract native class effectTrackItem extends effectBaseItem {
  public native let timeBegin: Float;
  public native let timeDuration: Float;
  public native let ruid: CRUID;
}

public native class effectTrackItemBloom extends effectTrackItem {
  public native let override: Bool;
  public native let sceneColorScale: effectEffectParameterEvaluatorFloat;
  public native let bloomColorScale: effectEffectParameterEvaluatorFloat;
}

public native class effectTrackItemChromaticAberration extends effectTrackItem {
  public native let override: Bool;
  public native let chromaticAberrationOffset: effectEffectParameterEvaluatorFloat;
  public native let chromaticAberrationExp: effectEffectParameterEvaluatorFloat;
}

public native class effectTrackItemColorGrade extends effectTrackItem {
  public native let contrast: effectEffectParameterEvaluatorFloat;
  public native let saturate: effectEffectParameterEvaluatorFloat;
  public native let brightness: effectEffectParameterEvaluatorFloat;
  public native let lutWeight: effectEffectParameterEvaluatorFloat;
  public native let lutParams: ColorGradingLutParams;
  public native let lutParamsHdr: ColorGradingLutParams;
  public native let blendWithBaseLut: Bool;
  public native let mask: array<ERenderObjectType>;
}

public native class effectTrackItemColorGradeV2 extends effectTrackItem {
  public native let contrast: effectEffectParameterEvaluatorFloat;
  public native let contrastPivot: effectEffectParameterEvaluatorFloat;
  public native let saturation: effectEffectParameterEvaluatorFloat;
  public native let hue: effectEffectParameterEvaluatorFloat;
  public native let brightness: effectEffectParameterEvaluatorFloat;
  public native let lowRange: effectEffectParameterEvaluatorFloat;
  public native let highRange: effectEffectParameterEvaluatorFloat;
  public native let lift: effectEffectParameterEvaluatorVector;
  public native let gamma: effectEffectParameterEvaluatorVector;
  public native let gain: effectEffectParameterEvaluatorVector;
  public native let offset: effectEffectParameterEvaluatorVector;
  public native let shadow: effectEffectParameterEvaluatorVector;
  public native let midtone: effectEffectParameterEvaluatorVector;
  public native let highlight: effectEffectParameterEvaluatorVector;
}

public native class effectTrackItemDataMosh extends effectTrackItem {
  public native let override: Bool;
  public native let intensity: effectEffectParameterEvaluatorFloat;
  public native let useGlitch: Bool;
  public native let glitchColor: effectEffectParameterEvaluatorVector;
  public native let usePixelsort: Bool;
  public native let pixelsortOverride: Bool;
  public native let pixelsortIntensity: effectEffectParameterEvaluatorFloat;
  public native let pixelsortStencil: Bool;
  public native let pixelsortVfx: Bool;
}

public native class effectTrackItemDecal extends effectTrackItem {
  public native let material: ResourceRef; // rRef<IMaterial>
  public native let scale: ref<IEvaluatorVector>;
  public native let emissiveScale: ref<IEvaluatorVector>;
  public native let normalThreshold: Float;
  public native let horizontalFlip: Bool;
  public native let verticalFlip: Bool;
  public native let fadeOutTime: Float;
  public native let fadeInTime: Float;
  public native let additionalRotation: Float;
  public native let randomRotation: Bool;
  public native let randomAtlasing: Bool;
  public native let isStretchEnabled: Bool;
  public native let isAttached: Bool;
  public native let normalsBlendingMode: RenderDecalNormalsBlendingMode;
  public native let atlasFrameStart: Int32;
  public native let atlasFrameEnd: Int32;
  public native let orderPriority: RenderDecalOrderPriority;
  public native let surfaceType: ERenderObjectType;
  public native let decalRenderMode: EDecalRenderMode;
}

public native class effectTrackItemDynamicDecal extends effectTrackItem {
  public native let material: ResourceRef; // rRef<IMaterial>
  public native let width: Float;
  public native let height: Float;
  public native let fadeInTime: Float;
  public native let fadeOutTime: Float;
  public native let additionalRotation: Float;
  public native let randomRotation: Bool;
}

public native class effectTrackItemEmissive extends effectTrackItem {
  public native let override: Bool;
  public native let brigtness: effectEffectParameterEvaluatorFloat;
}

public native class effectTrackItemExposureScale extends effectTrackItem {
  public native let scale: effectEffectParameterEvaluatorFloat;
  public native let useInitialCameraPosDirForFadeout: Bool;
  public native let fullEffectRadius: Float;
  public native let fadeOutRadius: Float;
  public native let fullyVisibleAngle: Float;
  public native let fadeOutAngle: Float;
}

public native class effectTrackItemFilmGrain extends effectTrackItem {
  public native let override: Bool;
  public native let luminanceBias: effectEffectParameterEvaluatorFloat;
  public native let strength: effectEffectParameterEvaluatorVector;
  public native let mask: array<ERenderObjectType>;
}

public native class effectTrackItemFogVolume extends effectTrackItem {
  public native let priority: Uint8;
  public native let densityFalloff: Float;
  public native let blendFalloff: Float;
  public native let density: ref<IEvaluatorFloat>;
  public native let size: ref<IEvaluatorVector>;
  public native let color: ref<IEvaluatorColor>;
}

public native class effectTrackItemForwardDecal extends effectTrackItem {
  public native let mesh: ResourceRef; // rRef<CMesh>
  public native let appearance: CName;
  public native let scale: ref<IEvaluatorVector>;
  public native let additionalRotation: Float;
  public native let sizeThreshold: Float;
  public native let randomRotation: Bool;
  public native let randomAppearance: Bool;
  public native let isAttached: Bool;
  public native let subUVx: Uint32;
  public native let subUVy: Uint32;
  public native let frame: Uint32;
  public native let fadeOutTime: Float;
  public native let fadeInTime: Float;
}

public native class effectTrackItemFOV extends effectTrackItem {
  public native let FOV: effectEffectParameterEvaluatorFloat;
}

public native class effectTrackItemHudParameter extends effectTrackItem {
  public native let scale: Float;
  public native let glitchParameter: effectEffectParameterEvaluator;
  public native let scale1: Float;
  public native let glitchParameter1: effectEffectParameterEvaluator;
  public native let blackwallScale: Float;
  public native let blackwallParameter: effectEffectParameterEvaluator;
}

public native class effectTrackItemLightParameter extends effectTrackItem {
  public native let scale: Float;
  public native let intensityMultiplier: effectEffectParameterEvaluatorFloat;
  public native let intensity: effectEffectParameterEvaluatorFloat;
  public native let radius: effectEffectParameterEvaluatorFloat;
}

public native class effectTrackItemLoopMarker extends effectTrackItemMetadata {}

public native class effectTrackItemMaterialParameter extends effectTrackItem {
  public native let scale0: Float;
  public native let customParameter0: effectEffectParameterEvaluator;
  public native let scale1: Float;
  public native let customParameter1: effectEffectParameterEvaluator;
  public native let scale2: Float;
  public native let customParameter2: effectEffectParameterEvaluator;
  public native let scale3: Float;
  public native let customParameter3: effectEffectParameterEvaluator;
}

public abstract native class effectTrackItemMetadata extends effectTrackItem {}

public native class effectTrackItemMotionBlurScale extends effectTrackItem {
  public native let scale: effectEffectParameterEvaluatorFloat;
}

public native class effectTrackItemParticles extends effectTrackItem {
  public native let particleSystem: ResourceRef; // rRef<CParticleSystem>
  public native let emissionScale: effectEffectParameterEvaluatorFloat;
  public native let alpha: effectEffectParameterEvaluatorFloat;
  public native let size: effectEffectParameterEvaluatorFloat;
  public native let velocity: effectEffectParameterEvaluatorFloat;
  public native let soundPositionName: CName;
  public native let soundPositionOffset: Vector3;
  public native let renderLayerMask: Uint8; // RenderSceneLayerMask
}

public abstract native class effectTrackItemPlayData extends ISerializable {}

public native class effectTrackItemPointLight extends effectTrackItem {
  public native let tint: effectEffectParameterEvaluatorColor;
  public native let intensity: effectEffectParameterEvaluatorFloat;
  public native let EV: Float;
  public native let radius: effectEffectParameterEvaluatorFloat;
  public native let offset: Vector3;
  public native let color: Color;
  public native let envColorGroup: EEnvColorGroup;
  public native let colorGroupSaturation: Uint8;
  public native let roughnessBias: Int8;
  public native let useInGI: Bool;
  public native let useInVolFog: Bool;
  public native let useInTransparents: Bool;
  public native let useInParticles: Bool;
  public native let sceneDiffuse: Bool;
  public native let sceneSpecular: Bool;
  public native let clampAttenuation: Bool;
  public native let flicker: rendSLightFlickering;
}

public native class effectTrackItemSound extends effectTrackItem {
  public native let eventName: CName;
  public native let switches: array<audioAudSwitch>;
  public native let params: array<audioAudParameter>;
  public native let positionName: CName;
  public native let emitterMetadataName: CName;
  public native let rtpcName: CName;
  public native let rtpcValue: ref<IEvaluatorFloat>;
}

public native class effectTrackItemTonemapping extends effectTrackItem {
  public native let override: Bool;
  public native let maxStopsSDR: effectEffectParameterEvaluatorFloat;
  public native let midGrayScaleSDR: effectEffectParameterEvaluatorFloat;
  public native let maxStopsHDR: effectEffectParameterEvaluatorFloat;
  public native let midGrayScaleHDR: effectEffectParameterEvaluatorFloat;
}

public native class effectTrackItemVignette extends effectTrackItem {
  public native let overrideRadiusAndExp: Bool;
  public native let overrideColor: Bool;
  public native let vignetteRadius: effectEffectParameterEvaluatorFloat;
  public native let vignetteExp: effectEffectParameterEvaluatorFloat;
  public native let color: effectEffectParameterEvaluatorColor;
}

public native class effectTrackItemWeaponPlaneBlur extends effectTrackItem {
  public native let farPlaneMultiplier: effectEffectParameterEvaluatorFloat;
  public native let override: Bool;
}

public native class effectVignettePlayData extends effectPlacedTrackItemPlayData {}

public native class effectVisualComponentSpawner extends effectSpawner {
  public native let componentName: array<CName>;
}

public abstract native class effectVisualComponentTrackItemPlayData extends effectTrackItemPlayData {}

public native class effectWeaponPlaneBlurPlayData extends effectPlacedTrackItemPlayData {}

public enum EFreeVectorAxes {
  FVA_One = 1,
  FVA_Two = 2,
  FVA_Three = 3,
  FVA_Four = 4,
}

public enum EInputAction {
  IACT_None = 0,
  IACT_Press = 1,
  IACT_Release = 2,
  IACT_Axis = 3,
}

public enum ELightShadowCastingMode {
  LSCM_None = 0,
  LSCM_Normal = 1,
  LSCM_OnlyDynamic = 2,
  LSCM_OnlyStatic = 3,
  LSCM_NormalAndContact = 4,
  LSCM_OnlyContact = 5,
}

public enum ELightShadowSoftnessMode {
  LSSM_ExtraSoft = 0,
  LSSM_Soft = 1,
  LSSM_Default = 2,
  LSSM_Sharp = 3,
  LSSM_ExtraSharp = 4,
}

public enum ELightType {
  LT_Point = 0,
  LT_Spot = 1,
  LT_Area = 2,
}

public enum ELightUnit {
  LU_Lumen = 0,
  LU_Watt = 1,
  LU_Lux = 2,
  LU_Nit = 3,
  LU_EV100 = 4,
}

public enum EMaterialModifier {
  EMATMOD_HitProxy = 0,
  EMATMOD_WindData = 1,
  EMATMOD_ParticleParams = 2,
  EMATMOD_RemoteCamera = 3,
  EMATMOD_Mirror = 4,
  EMATMOD_CustomStructBuffer = 5,
  EMATMOD_MotionMatrix = 7,
  EMATMOD_ColorAndTexture = 8,
  EMATMOD_MaterialParams = 9,
  EMATMOD_Eye = 10,
  EMATMOD_Skin = 11,
  EMATMOD_Dismemberment = 13,
  EMATMOD_Garments = 14,
  EMATMOD_ShadowsDebugParams = 15,
  EMATMOD_MultilayeredDebug = 16,
  EMATMOD_ParallaxParams = 17,
  EMATMOD_HighlightsParams = 18,
  EMATMOD_DebugColoring = 19,
  EMATMOD_DrawBufferMask = 20,
  EMATMOD_AutoSpawnData = 21,
  EMATMOD_DestructionRegions = 22,
  EMATMOD_VehicleParams = 12,
  EMATMOD_EffectParams = 6,
  EMATMOD_FloatTracks = 23,
  EMATMOD_AutoHideDistance = 24,
  EMATMOD_Rain = 25,
  EMATMOD_PlanarReflections = 26,
  EMATMOD_WaterSim = 27,
  EMATMOD_TransparencyClipParams = 28,
  EMATMOD_FlatTireParams = 29,
  EMATMOD_SecondMultilayerParams = 30,
  EMATMOD_CrystalCoat = 31,
  EMATMOD_MAX = 32,
}

public enum EMaterialPriority {
  EMP_Normal = 0,
  EMP_Front = 1,
}

public enum EMaterialShaderTarget {
  MSH_Invalid = 0,
  MSH_VertexShader = 1,
  MSH_PixelShader = 2,
  MSH_MAX = 3,
}

public enum EMaterialShadingRateMode {
  MSRM_Default = 0,
  MSRM_Disable = 1,
  MSRM_Force2x2 = 2,
}

public enum EMaterialVertexFactory {
  MVF_Terrain = 1,
  MVF_MeshStatic = 2,
  MVF_MeshSkinned = 3,
  MVF_MeshExtSkinned = 4,
  MVF_GarmentMeshSkinned = 5,
  MVF_GarmentMeshExtSkinned = 6,
  MVF_MeshSpeedTree = 7,
  MVF_ParticleBilboard = 8,
  MVF_ParticleParallel = 9,
  MVF_ParticleMotionBlur = 10,
  MVF_ParticleSphereAligned = 11,
  MVF_ParticleVerticalFixed = 12,
  MVF_ParticleTrail = 13,
  MVF_ParticleFacingTrail = 14,
  MVF_ParticleScreen = 15,
  MVF_ParticleBeam = 16,
  MVF_ParticleFacingBeam = 17,
  MVF_Decal = 18,
  MVF_Debug = 19,
  MVF_DrawBuffer = 20,
  MVF_Fullscreen = 21,
  MVF_MeshSkinnedVehicle = 22,
  MVF_MeshStaticVehicle = 23,
  MVF_MeshProcedural = 24,
  MVF_MeshDestructible = 25,
  MVF_MeshDestructibleSkinned = 26,
  MVF_MeshSkinnedLightBlockers = 27,
  MVF_MeshExtSkinnedLightBlockers = 28,
  MVF_GarmentMeshSkinnedLightBlockers = 29,
  MVF_GarmentMeshExtSkinnedLightBlockers = 30,
  MVF_MeshSkinnedSingleBone = 31,
  MVF_MeshProxy = 32,
  MVF_MeshWindowProxy = 33,
}

public enum EMeshParticleOrientationMode {
  MPOM_Normal = 0,
  MPOM_MovementDirection = 1,
  MPOM_NoRotation = 2,
}

public enum EMeshShadowImportanceBias {
  MSIB_EvenLessImportant = -2,
  MSIB_LessImportant = -1,
  MSIB_Default = 0,
  MSIB_MoreImportant = 1,
  MSIB_EvenMoreImportant = 2,
}

public enum EMeshStreamType {
  MST_Position_3F = 1,
  MST_SkinningIndices_4U8 = 2,
  MST_SkinningWeights_4F = 4,
  MST_SkinningIndicesExt_4U8 = 262144,
  MST_SkinningWeightsExt_4F = 524288,
  MST_Color_U32 = 8,
  MST_TexCoord0_2F = 16,
  MST_TexCoord1_2F = 32,
  MST_Normal_3F = 64,
  MST_Tangent_3F = 128,
  MST_Binormal_3F = 256,
  MST_DestructionIndices_2U16 = 1048576,
  MST_Multilayer_1F = 2097152,
  MST_Index_U16 = 512,
  MST_GarmentFlags_U32 = 4194304,
  MST_MorphOffset_3F = 8388608,
  MST_VehicleDmgNormalFront_3F = 16777216,
  MST_VehicleDmgNormalSides_3F = 33554432,
  MST_VehicleDmgPosFront_3F = 67108864,
  MST_VehicleDmgPosSides_3F = 134217728,
  MST_WindBranchData_4F = 1024,
  MST_BranchData_7F = 16384,
  MST_MorphVertexData_3F = 268435456,
  MST_FoliageBoneId_I16 = 536870912,
  MST_LightBlockerIntensity_1F = 1073741824,
}

public enum EMeshVertexType {
  MVT_StaticMesh = 0,
  MVT_ProceduralMesh = 1,
  MVT_SkinnedMesh = 2,
  MVT_ExtSkinnedMesh = 3,
  MVT_GarmentSkinnedMesh = 4,
  MVT_ExtGarmentSkinnedMesh = 5,
  MVT_SpeedTreeMesh = 6,
  MVT_StaticMeshVehicle = 7,
  MVT_SkinnedMeshVehicle = 8,
  MVT_Terrain = 9,
  MVT_DestructibleMesh = 10,
  MVT_DestructibleMeshSkinned = 11,
  MVT_SkinnedMeshLightBlocker = 12,
  MVT_ExtSkinnedMeshLightBlocker = 13,
  MVT_GarmentSkinnedMeshLightBlocker = 14,
  MVT_ExtGarmentSkinnedMeshLightBlocker = 15,
  MVT_SkinnedMeshSingleBone = 16,
  MVT_ProxyMesh = 17,
  MVT_ProxyWindowMesh = 18,
}

public native class EmissiveColorSettings extends IAreaSettings {
  public native let tint: CurveDataHDRColor;
  public native let saturation: CurveDataFloat;
  public native let brigtness: CurveDataFloat;
  public native let exposure: CurveDataVector2;
  public native let cameraLuminance: CurveDataVector2;
  public native let evBlend: CurveDataFloat;
  public native let exposureIBL: CurveDataFloat;
  public native let luminanceIBL: CurveDataFloat;
  public native let curveRampIBL: Float;
  public native let exposureScale: CurveDataFloat;
}

public native struct EmitterDelaySettings {
  public native let emitterDelay: Float;
  public native let emitterDelayLow: Float;
  public native let useEmitterDelayRange: Bool;
  public native let useEmitterDelayOnce: Bool;
}

public native struct EmitterDurationSettings {
  public native let emitterDuration: Float;
  public native let emitterDurationLow: Float;
  public native let useEmitterDurationRange: Bool;
}

public native struct EmitterGroupAreaParams {
  public native let group: EEmitterGroup;
  public native let emissionScale: CurveDataFloat;
  public native let opacityScale: CurveDataFloat;
}

public native class EmitterGroupAreaSettings extends IAreaSettings {
  public native let emitterGroupParams: array<EmitterGroupParams>;
  public native let EmitterGroupParams: array<EmitterGroupAreaParams>;
}

public native struct EmitterGroupParams {
  public native let group: EEmitterGroup;
  public native let emissionScale: Float;
  public native let opacityScale: Float;
}

public importonly class EnableClientSideInteractionEvent extends Event {}

public native class EnableStickerEditorEvent extends Event {}

public native class EngineTurnedOffEvent extends Event {}

public native class EngineTurnedOnEvent extends Event {}

public enum ENoiseType {
  NT_Random = 0,
  NT_Simplex2D = 1,
  NT_Simplex3D = 2,
}

public native class entAllowVehicleCollisionRagdollInSceneEvent extends Event {
  public native let allow: Bool;
}

public native class entAmbientSoundEmitterComponent extends IPlacedComponent {
  public native let Settings: ref<audioAmbientAreaSettings>;
  public native let usePhysicsObstruction: Bool;
  public native let occlusionEnabled: Bool;
  public native let repositionEnabled: Bool;
  public native let obstructionChangeTime: Float;
}

public native class entAnimationControlAttachment extends entIAttachment {}

public native class entAnimationControlBinding extends entISourceBinding {}

public native class entAnimationExtensionAttachment extends entIAttachment {}

public abstract native class entAnimationFloatTrackAttachment extends entIAttachment {}

public native class entAnimationSetupExtensionComponent extends IComponent {
  public native let animations: animAnimSetup;
  public native let isOverrideContainer: Bool;
  public native let controlBinding: ref<entAnimationControlBinding>;
}

public native class entAnimEntityToEntityAttachmentEvent extends Event {}

public native class entAnimGraphCustomDataEvent extends Event {}

public native class entAnimGraphResourceContainer extends IComponent {
  public native let animGraphLookupTable: array<AnimGraphResourceContainerEntry>;
}

public native class entAnimOnStateChangedEvent extends Event {}

public enum entAnimParamSlotFunction {
  RenderingPlane = 0,
  Visibility = 1,
}

public native class entAnimSoundEvent extends entSoundEvent {
  public native let metadataContext: CName;
}

public native struct entAnimTrackParameter {
  public native let animTrackName: CName;
  public native let parameterName: CName;
  public native let defaultValue: Float;
}

public native class entAppearanceDissolveFinishEvent extends Event {}

public native class entAppearanceLODsDistanceOverrideEvent extends Event {}

public native class entAppearanceMeshLoadedEvent extends Event {}

public native class entAppearanceProxyMeshComponent extends PhysicalMeshComponent {}

public enum entAppearanceStatus {
  None = 0,
  Proxy = 1,
  Appearance = 2,
}

public native class entAppearanceStatusEvent extends Event {
  public native let status: entAppearanceStatus;
}

public abstract native class entAttachEffectEvent extends Event {}

public native class entAttachEffectToComponentEvent extends entAttachEffectEvent {}

public native class entAttachEffectToSlotEvent extends entAttachEffectEvent {}

public native class entAttachGraphToSlotEvent extends Event {}

public native class entChangeVoicesetStateEvent extends Event {
  public native let enableVoicesetLines: Bool;
  public native let enableVoicesetGrunts: Bool;
  public native let inputsToBlock: array<entVoicesetInputToBlock>;
}

public native class entCharacterCustomizationSkinnedMeshComponent extends entSkinnedMeshComponent {
  public native let tags: redTagList;
}

public importonly class entClothComponent extends IVisualComponent {
  public native let mesh: ResourceRef; // rRef<CMesh>
  public native let isEnabled: Bool;
}

public native class entCollisionPredictionPositionProvider extends IPositionProvider {}

public native class entComponentsStorage extends ISerializable {
  public native let components: array<ref<IComponent>>;
}

public native class entCorpseParameter extends entEntityParameter {
  public native let lod: Uint32;
  public native let bakedPose: array<QsTransform>;
  public native let bakedBoneNames: array<CName>;
  public native let forceLOD0Components: array<CRUID>;
  public native let baseRig: ResourceAsyncRef; // raRef<animRig>
}

public native class entDebug_MeshComponent extends MeshComponent {
  public native let filterName: String;
}

public native class entDebug_ShapeComponent extends IVisualComponent {
  public native let radius: Float;
  public native let halfHeight: Float;
  public native let color: Color;
  public native let isEnabled: Bool;
}

public enum entDebug_ShapeType {
  Sphere = 0,
  Box = 1,
  Capsule = 2,
  Cylinder = 3,
}

public native class entDebugPositionProvider extends IPositionProvider {}

public native class entDecalComponent extends IVisualComponent {
  public native let material: ResourceRef; // rRef<IMaterial>
  public native let verticalFlip: Bool;
  public native let horizontalFlip: Bool;
  public native let aspectRatio: Float;
  public native let scale: Float;
  public native let visualScale: Vector3;
  public native let alpha: Float;
  public native let normalThreshold: Float;
  public native let roughnessScale: Float;
  public native let orderNo: Uint16;
  public native let surfaceType: ERenderObjectType;
  public native let decalRenderMode: EDecalRenderMode;
  public native let isStretchingEnabled: Bool;
  public native let normalsBlendingMode: RenderDecalNormalsBlendingMode;
  public native let shouldCollectWithRayTracing: Bool;
  public native let isEnabled: Bool;
}

public native class entDestructionAudioEvent extends Event {}

public native class entDetachGraphFromSlotEvent extends Event {}

public native struct entdismembermentAppearanceMatch {
  public native let Character: CName;
  public native let Mesh: CName;
  public native let SetByUser: Bool;
}

public native struct entdismembermentBodyMaterialConfig {
  public native let FleshBodyMask: Uint32; // physicsRagdollBodyPartE
  public native let CyberBodyMask: Uint32; // physicsRagdollBodyPartE
}

public native struct entdismembermentCullObject {
  public native let Plane: Plane;
  public native let Plane1: Plane;
  public native let CapsulePointA: Vector3;
  public native let CapsulePointB: Vector3;
  public native let CapsuleRadius: Float;
  public native let NearestAnimBoneName: CName;
  public native let NearestAnimIndex: Int16;
  public native let RagdollBodyIndex: Uint16;
}

public native struct entdismembermentDangleInfo {
  public native let DangleSegmentLenght: Float;
  public native let DangleVelocityDamping: Float;
  public native let DangleBendStiffness: Float;
  public native let DangleSegmentStiffness: Float;
  public native let DangleCollisionSphereRadius: Float;
}

public native class entdismembermentDebris extends CResource {
  public native let items: array<entdismembermentDebrisResourceItem>;
}

public native struct entdismembermentDebrisResourceItem {
  public native let rig: ResourceRef; // rRef<animRig>
  public native let mesh: ResourceRef; // rRef<CMesh>
}

public native class entdismembermentEffectResource extends ISerializable {
  public native let Name: CName;
  public native let AppearanceNames: array<CName>;
  public native let BodyPartMask: Uint32; // physicsRagdollBodyPartE
  public native let Offset: Transform;
  public native let Placement: Uint16; // entdismembermentPlacementE
  public native let ResourceSets: Uint16; // entdismembermentResourceSetMask
  public native let WoundType: Uint16; // entdismembermentWoundTypeE
  public native let Effect: ResourceAsyncRef; // raRef<worldEffect>
  public native let MatchToWoundByName: Bool;
}

public native struct entdismembermentMeshInfo {
  public native let Mesh: ResourceAsyncRef; // raRef<CMesh>
  public native let MeshAppearance: CName;
  public native let AppearanceMap: array<entdismembermentAppearanceMatch>;
  public native let ShouldReceiveDecal: Bool;
  public native let BodyPartMask: Uint32; // physicsRagdollBodyPartE
  public native let WoundType: Uint16; // entdismembermentWoundTypeE
  public native let CullMesh: Uint16; // entdismembermentWoundTypeE
  public native let Offset: Transform;
  public native let Scale: Vector3;
  public native let Physics: entdismembermentPhysicsInfo;
}

public native struct entdismembermentPhysicsInfo {
  public native let DensityScale: Float;
}

public enum entdismembermentResourceSetE {
  NONE = 16,
  BARE = 0,
  BARE1 = 1,
  BARE2 = 2,
  BARE3 = 3,
  GARMENT = 4,
  GARMENT1 = 5,
  GARMENT2 = 6,
  GARMENT3 = 7,
  CYBER = 8,
  CYBER1 = 9,
  CYBER2 = 10,
  CYBER3 = 11,
  MIXED = 12,
  MIXED1 = 13,
  MIXED2 = 14,
  MIXED3 = 15,
}

public enum entdismembermentSimulationTypeE {
  NONE = 0,
  DANGLE = 128,
}

@neverRef()
public native class entdismembermentWoundConfig extends ISerializable {
  public native let WoundName: CName;
  public native let ResourceSet: entdismembermentResourceSetE;
}

public native class entdismembermentWoundConfigContainer extends ISerializable {
  public native let AppearanceName: CName;
  public native let Wounds: array<entdismembermentWoundConfig>;
}

public native struct entdismembermentWoundDecal {
  public native let OffsetA: Vector3;
  public native let OffsetB: Vector3;
  public native let Scale: Float;
  public native let FadeOrigin: Float;
  public native let FadePower: Float;
  public native let ResourceSets: Uint16; // entdismembermentResourceSetMask
  public native let Material: ResourceAsyncRef; // raRef<IMaterial>
}

public native struct entdismembermentWoundMeshes {
  public native let ResourceSet: entdismembermentResourceSetE;
  public native let Meshes: array<entdismembermentMeshInfo>;
  public native let FillMeshes: array<entdismembermentFillMeshInfo>;
}

public native class entdismembermentWoundResource extends ISerializable {
  public native let Name: CName;
  public native let WoundType: Uint16; // entdismembermentWoundTypeE
  public native let BodyPart: Uint32; // physicsRagdollBodyPartE
  public native let CullObject: entdismembermentCullObject;
  public native let GarmentMorphStrength: Float;
  public native let UseProceduralCut: Bool;
  public native let UseSingleMeshForRagdoll: Bool;
  public native let IsCritical: Bool;
  public native let Resources: array<entdismembermentWoundMeshes>;
  public native let Decals: array<entdismembermentWoundDecal>;
  public native let CensoredPaths: array<Uint64>;
  public native let CensoredCookedPaths: array<ResourceAsyncRef>;
  public native let CensorshipValid: Bool;
}

public native struct entdismembermentWoundsConfigSet {
  public native let Configs: array<ref<entdismembermentWoundConfigContainer>>;
}

public native class entDistanceLODsPresets extends ISerializable {
  public native let definitions: [entLODDefinition; 4];
}

public native class entDynamicActorRepellingComponent extends IPlacedComponent {
  public native let type: entRepellingType;
  public native let shape: entRepellingShape;
  public native let magnitude: Float;
  public native let bendIntensity: Float;
  public native let anchorPointVert: rendWindShapeAnchorPointVert;
  public native let anchorPointHorz: rendWindShapeAnchorPointHorz;
  public native let anchorPointDepth: rendWindShapeAnchorPointDepth;
  public native let radius: Float;
  public native let capsuleRadius: Float;
  public native let capsuleHeight: Float;
}

public enum entEBindingDirection {
  BindToSource = 0,
  BindToDestination = 1,
}

public native class entEffectAttachmentComponent extends IComponent {}

public native class entEffectDesc extends ISerializable {
  public native let id: CRUID;
  public native let effectName: CName;
  public native let effect: ResourceAsyncRef; // raRef<worldEffect>
  public native let compiledEffectInfo: worldCompiledEffectInfo;
  public native let autoSpawnTag: CName;
  public native let isAutoSpawn: Bool;
  public native let randomWeight: Uint8;
}

public importonly class entEffectSpawnerComponent extends IVisualComponent {
  public native let effectDescs: array<ref<entEffectDesc>>;
}

public native class entEntityInstanceData extends ISerializable {}

public native class entEntityOrientationProvider extends IOrientationProvider {
  public native let slotComponent: wref<SlotComponent>;
  public native let slotId: Int32;
  public native let entity: wref<Entity>;
  public native let orientationEntitySpace: Quaternion;
}

public abstract importonly class entEntityParameter extends ISerializable {}

public native struct entEntityParametersBuffer {}

public native class entEntityParametersStorage extends ISerializable {
  public native let parameters: array<ref<entEntityParameter>>;
}

public native class entEntityPositionProvider extends IPositionProvider {}

public native class entEntityPreview extends Entity {}

public enum entEntitySpawnPriority {
  Background = 0,
  Normal = 1,
  Immediate = 2,
  Paramount = 3,
  Critical = 4,
}

public abstract native class entEntitySpawnToken extends IScriptable {}

public native class entEntityTemplate extends resStreamedResource {
  public native let includes: array<entTemplateInclude>;
  public native let appearances: array<entTemplateAppearance>;
  public native let defaultAppearance: CName;
  public native let visualTagsSchema: ref<entVisualTagsSchema>;
  public native let componentResolveSettings: array<entTemplateComponentResolveSettings>;
  public native let bindingOverrides: array<entTemplateBindingOverride>;
  public native let backendDataOverrides: array<entTemplateComponentBackendDataOverrideInfo>;
  public native let resolvedDependencies: array<ResourceAsyncRef>;
  public native let inplaceResources: array<ResourceRef>;
  public native let compiledEntityLODFlags: Uint16;
}

public native struct entEntityUserComponentResolution {
  public native let id: CRUID;
  public native let include: ResourceAsyncRef; // raRef<entEntityTemplate>
  public native let mode: entEntityUserComponentResolutionMode;
}

public enum entEntityUserComponentResolutionMode {
  Select = 0,
  Suppress = 1,
}

public native class enteventsSetCustomCameraTarget extends Event {}

public native class enteventsSetDissolveVisibility extends Event {}

public native class enteventsSetPlaneSetting extends Event {}

public native class entExternalComponent extends IComponent {
  public native let externalComponentName: CName;
}

public native class entFacialCustomizationComponent extends IComponent {
  public native let debugIgnoreComponent: Bool;
  public native let customizationSet: ResourceAsyncRef; // raRef<animFacialCustomizationSet>
  public native let eyes: Uint32;
  public native let nose: Uint32;
  public native let mouth: Uint32;
  public native let jaw: Uint32;
  public native let ears: Uint32;
}

public abstract native class entFactory extends ISerializable {}

public native struct entFallbackSlot {
  public native let slotName: CName;
  public native let boneName: CName;
}

public native class entFogVolumeComponent extends IVisualComponent {
  public native let densityFalloff: Float;
  public native let blendFalloff: Float;
  public native let densityFactor: Float;
  public native let color: Color;
  public native let absorption: Float;
  public native let size: Vector3;
  public native let isEnabled: Bool;
}

public native class entFoleyActionEvent extends Event {
  public native let actionName: CName;
}

public native class entFootPhaseChangedEvent extends Event {
  public native let footPhase: animEFootPhase;
}

public native class entFootPlantedEvent extends Event {
  public native let customAction: CName;
  public native let footSide: animEventSide;
}

public enum entForcedLodDistance {
  Default = 0,
  Background = 1,
  Regular = 2,
  Cinematic = 3,
  Vehicle = 4,
  CinematicVehicle = 5,
  VehicleInterior = 6,
  VehicleDecoration = 7,
  ConsoleLOD = 8,
}

public native class entFuncOrientationProvider extends IOrientationProvider {}

public native class entFuncPositionProvider extends IPositionProvider {}

public native class entGarmentParameter extends entEntityParameter {
  public native let componentsData: array<entGarmentParameterComponentData>;
  public native let collarArea: garmentCollarAreaParams;
}

public native struct entGarmentParameterChunkData {
  public native let morphOffsetScales: array<Uint8>;
  public native let morphOffsetScalesHash: Uint64;
  public native let visibleTriangleInds: array<Uint16>;
  public native let vertexTbn: array<Uint32>;
}

public native struct entGarmentParameterComponentData {
  public native let componentID: CRUID;
  public native let meshGeometryHash: Uint64;
  public native let visibleTrangleIndexBufferHash: Uint64;
  public native let chunks: array<entGarmentParameterChunkData>;
  public native let chunksCount: Uint32;
  public native let hideComponent: Bool;
  public native let bendPowerMultiplier: Float;
  public native let bendPowerOffset: Float;
  public native let smoothingStrength: Float;
  public native let smoothingThreshold: Float;
  public native let smoothingExponent: Float;
  public native let smoothNormalsEnabled: Bool;
  public native let smoothingNumNeighbours: Uint32;
  public native let garmentBorderThreshold: Float;
  public native let removeHiddenTriangles: Bool;
  public native let disableGarment: Bool;
  public native let mergeWithInnerLayer: Bool;
  public native let numIndices: Uint32;
  public native let numOffsets: Uint32;
}

public native class entGarmentSkinnedMeshComponent extends entSkinnedMeshComponent {}

public native class entGenericListFactory extends entFactory {}

public native class entHardAttachment extends entITransformAttachment {}

public native class entHardTransformBinding extends entITransformBinding {
  public native let slotName: CName;
}

public native class entHistoryPositionProvider extends IPositionProvider {}

public native class entHitRepresentationDataParameter extends entEntityParameter {
  public native let hitRepresentationOverrides: array<HitRepresentationOverride>;
}

public native class entIAttachment extends ISerializable {
  public native let source: wref<IComponent>;
  public native let destination: wref<IComponent>;
}

public abstract native class entIBinding extends ISerializable {
  public native let enabled: Bool;
  public native let enableMask: entTagMask;
  public native let bindName: CName;
}

public abstract native class entIDestinationBinding extends entIBinding {}

public abstract importonly class entIMoverComponent extends IComponent {}

public native class entInjectVoiceTagEvent extends Event {
  public native let voiceTagName: CName;
  public native let forceInjection: Bool;
}

public native class entInstancedAnimationComponent extends ISkinableComponent {
  public native let animations: ResourceRef; // rRef<animAnimSet>
  public native let animToSample: CName;
  public native let variantAnimToSample: CName;
  public native let variantTriggerTag: CName;
}

public abstract native class entISkinningAttachment extends entIAttachment {}

public abstract native class entISkinTargetComponent extends IVisualComponent {
  public native let skinning: ref<entSkinningBinding>;
  public native let useSkinningLOD: Bool;
}

public abstract native class entISourceBinding extends entIBinding {}

public native class EntitiesWithStatusEffectPrereq extends IPrereq {}

public native class EntitiesWithStatusEffectPrereqState extends PrereqState {}

public abstract native class entITransformAttachment extends entIAttachment {}

public abstract native class entITransformBinding extends entISourceBinding {}

public native class EntityIDArrayPrereq extends IPrereq {}

public native class EntityIDArrayPrereqState extends PrereqState {}

public native class EntityResizeEvent extends Event {
  public native let extents: Vector3;
}

public importonly class EntitySpawnerComponent extends GameComponent {
  public native let slotDataArray: array<EntitySpawnerSlotData>;
}

public native struct EntitySpawnerSlotData {
  public native let slotName: CName;
  public native let spawnableObject: TweakDBID;
}

public native class EntityStubHandlerProviderSystem extends AIIEntityStubHandlerProviderSystem {}

public native class EntityTargetedEvent extends Event {
  public native let targetingEntity: wref<Entity>;
}

public native class EntityUntargetedEvent extends Event {
  public native let targetingEntity: wref<Entity>;
}

public native class entLightBlockingComponent extends IVisualComponent {
  public native let radius: Float;
  public native let lightBlockerComponentVersion: Uint8;
}

public native struct entLocalizationStringMapEntry {
  public native let key: CName;
  public native let string: LocalizationString;
}

public native class entLocomotionSlideEvent extends Event {}

public native struct entLookAtLimits {
  public native let softLimitDegrees: Float;
  public native let hardLimitDegrees: Float;
  public native let hardLimitDistance: Float;
  public native let backLimitDegrees: Float;
}

public native class entMarketingAnimationComponent extends IPlacedComponent {
  public native let freezeAnimations: Bool;
  public native let animations: array<entMarketingAnimationEntry>;
  public native let enableLookAt: Bool;
  public native let lookAtSettings: ref<animLookAtPreset_FullControl>;
  public native let lookAtCamera: Bool;
  public native let lookAtOrbitDistance: Float;
  public native let lookAtTargetPitch: Float;
  public native let lookAtTargetYaw: Float;
}

public native struct entMarketingAnimationEntry {
  public native let animationName: CName;
  public native let time: Float;
  public native let frame: Float;
}

public enum entMeshComponentLODMode {
  AlwaysVisible = 0,
  Appearance = 1,
  AppearanceProxy = 2,
}

public native class entMorphTargetManagerComponent extends entExternalComponent {}

public native class entMorphTargetSkinnedMeshComponent extends entISkinTargetComponent {
  public native let morphResource: ResourceAsyncRef; // raRef<MorphTargetMesh>
  public native let meshAppearance: CName;
  public native let castShadows: shadowsShadowCastingMode;
  public native let castLocalShadows: shadowsShadowCastingMode;
  public native let acceptDismemberment: Bool;
  public native let chunkMask: Uint64;
  public native let renderingPlaneAnimationParam: CName;
  public native let visibilityAnimationParam: CName;
  public native let isEnabled: Bool;
  public native let tags: redTagList;
  public native let version: Uint8;
}

public native struct entMorphTargetWeightEntry {
  public native let targetName: CName;
  public native let regionName: CName;
  public native let weight: Float;
}

public native class entParticlesComponent extends IVisualComponent {
  public native let emissionRate: Float;
  public native let particleSystem: ResourceRef; // rRef<CParticleSystem>
  public native let autoHideRange: Float;
  public native let renderLayerMask: Uint8; // RenderSceneLayerMask
  public native let isEnabled: Bool;
}

public importonly class entPhysicalFractureFieldComponent extends PhysicalTriggerComponent {
  public native let fractureFieldParams: physicsFractureFieldParams;
}

public importonly class entPhysicalImpulseAreaComponent extends PhysicalTriggerComponent {
  public native let impulse: Vector3;
  public native let impulseRadius: Float;
}

public native class entPlacedComponentPositionProvider extends IPositionProvider {}

public native class entPlaceholderComponent extends IPlacedComponent {}

public importonly class entPreloadAllEffectsEvent extends Event {}

public importonly class entPreloadEffectEvent extends Event {
  public native let effectName: CName;
}

public importonly class entReleasePreloadedEffectEvent extends Event {
  public native let effectName: CName;
}

public importonly class entReleasePreloadedEffectsEvent extends Event {}

public importonly class entRenderHighlightEvent extends Event {
  public native let fillIndex: Uint8;
  public native let outlineIndex: Uint8;
  public native let seeThroughWalls: Bool;
  public native let componentName: CName;
  public native let opacity: Float;
}

public native class entRenderOverlayEvent extends Event {}

public importonly class entRenderScanEvent extends Event {
  public native let scanState: rendPostFx_ScanningState;
}

public native class entRenderToTextureCameraComponent extends entCameraComponent {
  public native let isEnabled: Bool;
  public native let virtualCameraName: CName;
  public native let dynamicTextureRes: ResourceAsyncRef; // raRef<DynamicTexture>
  public native let depthDynamicTextureRes: ResourceRef; // rRef<DynamicTexture>
  public native let albedoDynamicTextureRes: ResourceRef; // rRef<DynamicTexture>
  public native let normalsDynamicTextureRes: ResourceRef; // rRef<DynamicTexture>
  public native let particlesDynamicTextureRes: ResourceRef; // rRef<DynamicTexture>
  public native let resolutionWidth: Uint32;
  public native let resolutionHeight: Uint32;
  public native let aspectRatio: Float;
  public native let env: ResourceRef; // rRef<worldEnvironmentAreaParameters>
  public native let params: WorldRenderAreaSettings;
  public native let renderingMode: entRenderToTextureMode;
  public native let depthCutDistance: Float;
  public native let backgroundColor: Color;
  public native let overrideBackgroundColor: Bool;
  public native let renderSceneLayer: RenderSceneLayer;
  public native let features: entRenderToTextureFeatures;
  public native let streamingDistance: Float;
}

public native struct entRenderToTextureFeatures {
  public native let renderDecals: Bool;
  public native let renderParticles: Bool;
  public native let renderForwardNoTXAA: Bool;
  public native let antiAliasing: entRenderToTextureFeaturesPlatform;
  public native let contactShadows: Bool;
  public native let localShadows: Bool;
  public native let SSAO: entRenderToTextureFeaturesPlatform;
  public native let reflections: entRenderToTextureFeaturesPlatform;
}

public enum entRenderToTextureFeaturesPlatform {
  RTFP_All = 0,
  RTFP_PC = 1,
  RTFP_PC_PS5_XSX = 2,
  RTFP_Consoles = 3,
  RTFP_None = 4,
}

public enum entRenderToTextureMode {
  Shaded = 0,
  GBufferOnly = 1,
}

public enum entRepellingShape {
  Sphere = 0,
  Capsule = 1,
}

public enum entRepellingType {
  Debris = 0,
  BigObjects = 1,
  WindImpulse = 2,
  WaterImpulse = 3,
}

public native struct entReplicatedAnimFeaturesState {
  public native let items: array<entReplicatedAnimFeature>;
  public native let lastAppliedActionsTime: netTime;
}

public native struct entReplicatedAnimWrapperVars {
  public native let serverReplicatedTime: netTime;
  public native let data: array<entReplicatedVariableValue>;
}

public native struct entReplicatedInputSetterBase {
  public native let name: CName;
  public native let applyServerTime: netTime;
}

public native struct entReplicatedInputSetters {
  public native let serverReplicatedTime: netTime;
}

public native struct entReplicatedItem {
  public native let entity: wref<Entity>;
  public native let netTime: netTime;
}

public native struct entReplicatedLookAtData {
  public native let creationNetTime: netTime;
}

public native struct entReplicatedVariableValue {
  public native let name: CName;
  public native let value: Float;
  public native let applyServerTime: netTime;
}

public native class entRuntimeSystemEditorMeshes extends worldIRuntimeSystem {}

public native class entSceneAnimSetEvent extends Event {}

public native class entShadowMeshChangeEvent extends Event {
  public native let requestedState: entAppearanceStatus;
}

public abstract native class entSimpleSkinningAttachment extends entISkinningAttachment {}

public importonly class entSkinnedClothComponent extends entISkinTargetComponent {
  public native let graphicsMesh: ResourceAsyncRef; // raRef<CMesh>
  public native let physicalMesh: ResourceAsyncRef; // raRef<CMesh>
  public native let isEnabled: Bool;
  public native let LODMode: entMeshComponentLODMode;
  public native let meshAppearance: CName;
  public native let chunkMask: Uint64;
  public native let compiledTopologyData: meshCookedClothMeshTopologyData;
}

public native class entSkinnedMeshComponent extends entISkinTargetComponent {
  public native let mesh: ResourceAsyncRef; // raRef<CMesh>
  public native let meshAppearance: CName;
  public native let castShadows: shadowsShadowCastingMode;
  public native let castLocalShadows: shadowsShadowCastingMode;
  public native let acceptDismemberment: Bool;
  public native let chunkMask: Uint64;
  public native let renderingPlaneAnimationParam: CName;
  public native let visibilityAnimationParam: CName;
  public native let order: Uint8;
  public native let isEnabled: Bool;
  public native let LODMode: entMeshComponentLODMode;
  public native let useProxyMeshAsShadowMesh: Bool;
  public native let forcedLodDistance: entForcedLodDistance;
  public native let overrideMeshNavigationImpact: Bool;
  public native let navigationImpact: NavGenNavigationSetting;
  public native let version: Uint8;
}

public native class entSkinningBinding extends entISourceBinding {}

public native struct entSlot {
  public native let slotName: CName;
  public native let relativePosition: Vector3;
  public native let relativeRotation: Quaternion;
  public native let boneName: CName;
}

public native class entSlotAttachment extends entITransformAttachment {}

public native class entSlotPositionProvider extends IPositionProvider {}

public native class entSoundEvent extends Event {
  public native let eventName: CName;
  public native let switches: array<audioAudSwitch>;
  public native let params: array<audioAudParameter>;
  public native let dynamicParams: array<CName>;
}

public native class entSoundListenerComponent extends IPlacedComponent {}

public native class entSpawnersContainer extends ISerializable {}

public native class entStaticOccluderMeshComponent extends IPlacedComponent {
  public native let mesh: ResourceRef; // rRef<CMesh>
  public native let scale: Vector3;
  public native let color: Color;
  public native let occluderType: visWorldOccluderType;
  public native let occluderAutohideDistanceScale: Uint8;
}

public native class entStaticOrientationProvider extends IOrientationProvider {
  public native let staticOrientation: Quaternion;
}

public native class entStaticPositionProvider extends IPositionProvider {}

public native struct entTagMask {
  public native let hardTags: redTagList;
  public native let softTags: redTagList;
  public native let excludedTags: redTagList;
}

public native struct entTemplateAppearance {
  public native let name: CName;
  public native let appearanceResource: ResourceAsyncRef; // raRef<appearanceAppearanceResource>
  public native let appearanceName: CName;
}

public native struct entTemplateBindingOverride {
  public native let componentName: CName;
  public native let propertyName: CName;
  public native let binding: ref<entIBinding>;
}

public native struct entTemplateComponentBackendDataOverrideInfo {
  public native let componentName: CName;
  public native let offset: Vector2;
}

public enum entTemplateComponentResolveMode {
  AutoSelect = 0,
  Select = 1,
  Suppress = 2,
}

public native struct entTemplateComponentResolveSettings {
  public native let componentName: CName;
  public native let nameParam: CName;
  public native let mode: entTemplateComponentResolveMode;
}

public native struct entTemplateInclude {
  public native let name: CName;
  public native let template: ResourceAsyncRef; // raRef<entEntityTemplate>
}

public native class entTransformComponent extends IPlacedComponent {}

public native class entTriggerActivatorComponent extends IPlacedComponent {
  public native let radius: Float;
  public native let height: Float;
  public native let channels: Uint32; // TriggerChannel
  public native let maxContinousDistance: Float;
  public native let enableCCD: Bool;
  public native let isEnabled: Bool;
}

public importonly class entTriggerComponent extends PhysicalTriggerComponent {}

public native class entTriggerDestructionEvent extends Event {}

public native class entTriggerNotifier_Entity extends worldITriggerAreaNotifer {
  public native let entityRef: NodeRef;
}

public native class entTriggerNotifier_EntityInstance extends worldITriggerAreaNotiferInstance {}

public native class entTriggerVOEvent extends Event {
  public native let triggerBaseName: CName;
  public native let triggerVariationIndex: Uint32;
  public native let triggerVariationNumber: Uint32;
  public native let debugInitialContext: CName;
  public native let answeringEntityIDHash: Uint64;
  public native let ignoreGlobalVoLimitCheck: Bool;
  public native let overridingVoContext: locVoiceoverContext;
  public native let overridingVoiceoverExpression: locVoiceoverExpression;
  public native let overrideVoiceoverExpression: Bool;
  public native let overridingVisualStyleValue: Uint8;
  public native let overrideVisualStyle: Bool;
}

public native class entUpdateEffectPositionEvent extends Event {}

public native class entUpdateRenderProxyStateEvent extends Event {}

public native class entVectorFieldComponent extends IVisualComponent {
  public native let direction: Vector3;
  public native let isEnabled: Bool;
}

public native class entVertexAnimationBinding extends entISourceBinding {}

public native class entVertexAnimationComponent extends IComponent {
  public native let vertexAnimationMapper: entVertexAnimationMapper;
  public native let animatedComponent: ref<entISourceBinding>;
}

public native struct entVertexAnimationMapper {
  public native let entries: array<entVertexAnimationMapperEntry>;
}

public native struct entVertexAnimationMapperDestination {
  public native let vertexCustomSlotIndex: Uint32;
}

public native struct entVertexAnimationMapperEntry {
  public native let sources: [entVertexAnimationMapperSource; 4];
  public native let destination: entVertexAnimationMapperDestination;
}

public native struct entVertexAnimationMapperSource {
  public native let type: entVertexAnimationMapperSourceType;
  public native let name: CName;
}

public enum entVertexAnimationMapperSourceType {
  FloatTrack = 0,
  TranslationX = 1,
  TranslationY = 2,
  TranslationZ = 3,
  RotationQuatX = 4,
  RotationQuatY = 5,
  RotationQuatZ = 6,
  RotationQuatW = 7,
}

public native struct entVisualControllerDependency {
  public native let mesh: ResourceAsyncRef; // raRef<CMesh>
  public native let appearanceName: CName;
  public native let componentName: CName;
}

public native class entVisualOffsetTransformComponent extends entTransformComponent {}

public native class entVisualTagsSchema extends ISerializable {
  public native let visualTags: redTagList;
  public native let schema: CName;
}

public native struct entVoicesetInputToBlock {
  public native let input: CName;
  public native let blockSpecificVariation: Bool;
  public native let variationNumber: Uint32;
}

public native class entWorkspotItemEvent extends Event {}

public native class EnvironmentColorGroupsSettings extends IAreaSettings {
  public native let skyTint: CurveDataHDRColor;
  public native let colorGroup: [CurveDataHDRColor; 16];
}

public native class EnvProbeComponent extends IVisualComponent {
  public native let isEnabled: Bool;
  public native let size: Vector3;
  public native let edgeScale: Vector3;
  public native let emissiveScale: Float;
  public native let globalProbe: Bool;
  public native let boxProjection: Bool;
  public native let allInShadow: Bool;
  public native let streamingDistance: Float;
  public native let streamingHeight: Float;
  public native let blendRange: Uint8;
  public native let neighborMode: envUtilsNeighborMode;
  public native let hideSkyColor: Bool;
  public native let ambientMode: envUtilsReflectionProbeAmbientContributionMode;
  public native let brightnessEVClamp: Uint8;
  public native let probeDataRef: ResourceAsyncRef; // raRef<CReflectionProbeDataResource>
  public native let priority: Uint8;
  public native let lightChannels: Uint16; // rendLightChannel
  public native let volumeChannels: Uint16; // rendLightChannel
}

public enum envUtilsNeighborMode {
  eCLOSEST = 0,
  eONLY_GLOBAL = 1,
  eONLY_SELF = 2,
  eFILL_SURROUNDING = 3,
}

public enum envUtilsReflectionProbeAmbientContributionMode {
  eNO_AMBIENT_CONTRIBUTION = 0,
  eALLOW_AMBIENT_CONTRIBUTION = 1,
  eOVERRIDE_GI_AMBIENT = 2,
}

public enum EParticleEventSpawnObject {
  PESO_Particle = 0,
  PESO_Decal = 1,
}

public enum EParticleEventType {
  PET_Any = 5,
  PET_Death = 0,
  PET_OverLife = 1,
  PET_OverDistance = 2,
  PET_Collision = 3,
  PET_PlayOneShotSoundOnSpawn = 4,
}

public native class EquippedPrereq extends IPrereq {
  public native let itemID: ItemID;
  public native let slot: TweakDBID;
}

public native class EquippedPrereqState extends PrereqState {}

public enum ERenderDynamicDecalAtlas {
  RDDA_1x1 = 0,
  RDDA_2x1 = 1,
  RDDA_2x2 = 2,
  RDDA_4x2 = 3,
  RDDA_4x4 = 4,
  RDDA_8x4 = 5,
}

public enum ERenderDynamicDecalProjection {
  RDDP_Ortho = 0,
  RDDP_Sphere = 1,
}

public enum ERenderingMode {
  RM_HitProxies = 2,
  RM_Shaded = 0,
  RM_Shaded_NoAmbient = 1,
  RM_GBufferOnly = 3,
  RM_SafeMode = 4,
  RM_OverlayOnly = 5,
}

public enum ERenderMaterialType {
  RMT_Standard = 0,
  RMT_Subsurface = 1,
  RMT_Cloth = 2,
  RMT_Eye = 3,
  RMT_Hair = 4,
  RMT_Foliage = 5,
}

public enum ERenderMeshStreams {
  RMS_PositionSkinning = 1,
  RMS_TexCoords = 2,
  RMS_TangentFrame = 4,
  RMS_Extended = 8,
  RMS_Custom0 = 16,
  RMS_BindAll = 255,
}

public enum ERenderObjectType {
  ROT_Static = 0,
  ROT_Terrain = 1,
  ROT_Road = 2,
  ROT_Skinned = 20,
  ROT_Character = 21,
  ROT_Foliage = 22,
  ROT_Grass = 23,
  ROT_Vehicle = 24,
  ROT_Weapon = 25,
  ROT_Particle = 26,
  ROT_Enemy = 27,
  ROT_CustomCharacter1 = 12,
  ROT_CustomCharacter2 = 13,
  ROT_CustomCharacter3 = 14,
  ROT_Blackwall1 = 28,
  ROT_Blackwall2 = 29,
  ROT_MainPlayer = 15,
  ROT_NoAO = 16,
  ROT_NoLighting = 17,
  ROT_NoTXAA = 18,
}

public enum ERenderProxyType {
  RPT_None = 0,
  RPT_Mesh = 1,
  RPT_PointLight = 2,
  RPT_SpotLight = 3,
  RPT_AreaLight = 4,
  RPT_Particles = 5,
  RPT_Foliage = 6,
  RPT_SSDecal = 7,
  RPT_VectorField = 8,
  RPT_FogVolume = 9,
  RPT_GI = 10,
  RPT_ReflectionProbe = 11,
  RPT_MorphTargetMesh = 12,
  RPT_LightVolume = 13,
  RPT_DynamicDecalSpawner = 14,
  RPT_AutoSpawner = 15,
  RPT_LightBlocker = 16,
}

public enum ESaveFormat {
  SF_PNG = 2,
  SF_EXR = 32,
  SF_PNG_AND_EXR = 34,
}

public enum ESSAOQualityLevel {
  SSAOQUALITY_VeryLow = 0,
  SSAOQUALITY_Low = 1,
  SSAOQUALITY_Medium = 2,
  SSAOQUALITY_High = 3,
  SSAOQUALITY_VeryHigh = 4,
}

public enum ESystemNotificationTypes {
  DiscOperationIndicator = 0,
  GenericNotModal = 1,
  AchievmentDebug = 2,
  GenericMenuInfo = 3,
  GenericYesNo = 4,
  Generic = 5,
  ExitGame = 6,
  StartNewGame = 7,
  NoDiscSpace = 8,
  OverwriteSaveFile = 9,
  OverwriteSaveFileXbCompatWarning = 10,
  LoadSaveFileInGame = 11,
  LoadSaveFile = 12,
  DeleteSaveFile = 13,
  TransferSaveFile = 14,
  CorruptedSaveFile = 15,
  UnreachableCloudFile = 16,
  RegionMismatchSaveFile = 17,
  NoPlayerProfile = 18,
  GameSaved = 19,
  SaveFailed = 20,
  ScreenshotSaved = 21,
  UnavailableForGuest = 22,
  EnableTelemetry = 23,
  PointOfNoReturn = 24,
  PointOfNoReturnWithReward = 25,
  PointOfNoReturnLootAdded = 26,
  GenericMenuError = 27,
  ControllerReconnected = 28,
  ControllerDisconnected = 29,
  TrialPeriodEnded = 30,
  TrialPeriodTimer = 31,
  FailedToRemoveTransferredSave = 32,
  LoadModdedSaveFile = 33,
  MAX = 34,
  FirstModalHighPriority = 28,
}

public enum ETextureAddressing {
  TA_Wrap = 0,
  TA_Mirror = 1,
  TA_Clamp = 2,
  TA_MirrorOnce = 3,
  TA_Border = 4,
}

public enum ETextureAnimationMode {
  TAM_Speed = 0,
  TAM_LifeTime = 1,
}

public enum ETextureComparisonFunction {
  TCF_None = 0,
  TCF_Less = 1,
  TCF_Equal = 2,
  TCF_LessEqual = 3,
  TCF_Greater = 4,
  TCF_NotEqual = 5,
  TCF_GreaterEqual = 6,
  TCF_Always = 7,
}

public enum ETextureCompression {
  TCM_None = 0,
  TCM_DXTNoAlpha = 1,
  TCM_DXTAlpha = 2,
  TCM_RGBE = 3,
  TCM_Normalmap = 4,
  TCM_Normals_DEPRECATED = 5,
  TCM_NormalsHigh_DEPRECATED = 6,
  TCM_NormalsGloss_DEPRECATED = 7,
  TCM_TileMap = 8,
  TCM_DXTAlphaLinear = 9,
  TCM_QualityR = 10,
  TCM_QualityRG = 11,
  TCM_QualityColor = 12,
  TCM_HalfHDR_Unsigned = 13,
  TCM_HalfHDR_Signed = 14,
  TCM_Max = 15,
  TCM_Normals = 5,
  TCM_NormalsHigh = 6,
  TCM_NormalsGloss = 7,
  TCM_HalfHDR = 13,
}

public enum ETextureFilteringMag {
  TFMag_Point = 0,
  TFMag_Linear = 1,
}

public enum ETextureFilteringMin {
  TFMin_Point = 0,
  TFMin_Linear = 1,
  TFMin_Anisotropic = 2,
  TFMin_AnisotropicLow = 3,
}

public enum ETextureFilteringMip {
  TFMip_None = 0,
  TFMip_Point = 1,
  TFMip_Linear = 2,
}

public enum ETextureRawFormat {
  TRF_Invalid = 0,
  TRF_TrueColor = 1,
  TRF_DeepColor = 2,
  TRF_Grayscale = 3,
  TRF_HDRFloat = 4,
  TRF_HDRHalf = 5,
  TRF_HDRFloatGrayscale = 6,
  TRF_Grayscale_Font = 7,
  TRF_R8G8 = 8,
  TRF_R32UI = 9,
  TRF_AlphaGrayscale = 0,
}

public enum ETimeOfYearSeason {
  ETOYS_Spring = 0,
  ETOYS_Summer = 1,
  ETOYS_Autumn = 2,
  ETOYS_Winter = 3,
}

public enum ETransitionType {
  EET_Linear = 0,
  EET_Sine = 1,
  EET_Cubic = 2,
  EET_Quad = 3,
  EET_Quart = 4,
  EET_Quint = 5,
  EET_Expo = 6,
  EET_Circ = 7,
  EET_Back = 8,
  EET_Bounce = 9,
  EET_Elastic = 10,
}

public enum EVisualizerRuntimeFlags {
  None = 0,
  Locked = 1,
  Failsafe = 2,
  Dbg_Active = 4,
}

public native class ExposureAreaSettings extends IAreaSettings {
  public native let exposureAdaptationSpeedUp: CurveDataFloat;
  public native let exposureAdaptationSpeedDown: CurveDataFloat;
  public native let exposurePercentageThresholdLow: CurveDataFloat;
  public native let exposurePercentageThresholdHigh: CurveDataFloat;
  public native let exposureCompensation: CurveDataFloat;
  public native let exposureSkyImpact: CurveDataFloat;
  public native let exposureMin: CurveDataFloat;
  public native let exposureMax: CurveDataFloat;
  public native let exposureCenterImportance: CurveDataFloat;
  public native let cameraVelocityFaloff: Float;
  public native let exposureCompensationOffset: Float;
}

public native class ExposureCompensationAreaSettings extends IAreaSettings {
  public native let exposureCompensation: Float;
}

public native class ExposureCompensationOffsetAreaSettings extends IAreaSettings {
  public native let exposureCompensationOffset: Float;
}

public abstract native class ExpressionTreeCAINodeDefinition extends ExpressionTreeCNodeDefinition {}

public native class ExpressionTreeCConstBoolNodeDefinition extends ExpressionTreeCGeneralNodeDefinition {
  public native let value: Bool;
}

public native class ExpressionTreeCConstFloatNodeDefinition extends ExpressionTreeCGeneralNodeDefinition {
  public native let value: Float;
}

public native class ExpressionTreeCGeneralAndNodeDefinition extends ExpressionTreeCGeneralCompositeNodeDefinition {}

public native class ExpressionTreeCGeneralCompositeNodeDefinition extends ExpressionTreeCGeneralNodeDefinition {
  public native let children: array<ref<LibTreeINodeDefinition>>;
}

public native class ExpressionTreeCGeneralIfNodeDefinition extends ExpressionTreeCGeneralNodeDefinition {
  public native let expressions: array<ref<LibTreeINodeDefinition>>;
  public native let trueBranch: ref<LibTreeINodeDefinition>;
  public native let falseBranch: ref<LibTreeINodeDefinition>;
}

public abstract native class ExpressionTreeCGeneralNodeDefinition extends ExpressionTreeCNodeDefinition {}

public native class ExpressionTreeCGeneralOrNodeDefinition extends ExpressionTreeCGeneralCompositeNodeDefinition {}

public abstract native class ExpressionTreeCNodeDefinition extends LibTreeINodeDefinition {}

public native class ExpressionTreeCParametrizationNodeDefinition extends ExpressionTreeCNodeDefinition {}

public native class ExpressionTreeCParametrizationNodeReadIntDefinition extends ExpressionTreeCParametrizationNodeDefinition {}

public native struct ExpressionTreeExecutionListenerRef {}

public native class ExternalMovementCameraDataEvent extends Event {}

public native class FearInPlaceEvent extends AIEvent {}

public native struct FeatureFlagsMask {
  public native let flags: Uint64;
}

public native class FilmGrainAreaSettings extends IAreaSettings {
  public native let strength: CurveDataVector4;
  public native let luminanceBias: CurveDataFloat;
  public native let grainSize: Vector3;
  public native let applyAfterUpsampling: Bool;
}

public native struct FixedCapsule {
  public native let PointRadius: Vector4;
  public native let Height: Float;
}

public native struct FixedPoint {
  public native let Bits: Int32;
}

public native struct FoliageShadowConfig {
  public native let foliageShadowCascadeGradient: Float;
  public native let foliageShadowCascadeFilterScale: Float;
  public native let foliageShadowCascadeGradientDistanceRange: Float;
}

public native class FollowerSquad extends SquadBase {}

public native class FollowerSquadMember extends AISquadNPCMember {}

public native class FootstepComponent extends IComponent {
  public native let tweakDBID: TweakDBID;
  public native let leftFootSlot: CName;
  public native let rightFootSlot: CName;
}

public native class FootstepSystem extends gameIFootstepSystem {}

public native class ForceAttributeValueEvent extends Event {}

public native class ForceStickerTransformEvent extends Event {}

public native class FreeCameraComponent extends CameraComponent {}

public importonly class FriendlyFireSystem extends IFriendlyFireSystem {}

public importonly struct FTResult {
  public native let code: FunctionalTestsResultCode;
  public native let msg: String;
  public final static native func IsValid()
  public final static native func Make()
  public final static native func MakeValid()
  public final static native func SetResult()
}

public native struct FunctionalTestQueryOverlapResult {
  public native let entityID: EntityID;
  public native let position: Vector3;
}

@neverRef()
public native class FunctionalTestsDataMemoryPoolRuntimeData extends ISerializable {
  public native let poolName: String;
  public native let bytesAllocated: Int64;
  public native let allocationCount: Int64;
}

@neverRef()
public native class FunctionalTestsDataMemoryPoolStaticData extends ISerializable {
  public native let poolName: String;
  public native let budget: Int64;
  public native let childrenBudget: Int64;
  public native let children: array<String>;
  public native let parent: String;
}

public native class FunctionalTestsDataMemoryStatsData extends ISerializable {
  public native let totalPhysicalMemory: Uint64;
  public native let availablePhysicalMemory: Uint64;
  public native let runtimeTotalBytesAllocated: Uint64;
  public native let cpuBytesAllocated: Uint64;
  public native let gpuBytesAllocated: Uint64;
  public native let totalAllocationCount: Uint32;
  public native let cpuAllocationCount: Uint32;
  public native let gpuAllocationCount: Uint32;
  public native let engineTick: Uint64;
  public native let lastTimeDelta: Float;
  public native let engineTime: Double;
  public native let rawLocalTime: Uint64;
  public native let playerPosition: String;
  public native let playerOrientation: String;
  public native let poolsRuntimeInfo: array<FunctionalTestsDataMemoryPoolRuntimeData>;
  public native let poolsCurrentInfo: array<FunctionalTestsDataMemoryPoolStaticData>;
}

public native class FunctionalTestsDataRenderingStatsData extends ISerializable {
  public native let engineTick: Uint64;
  public native let rawLocalTime: Uint64;
  public native let meshChunkCount: Uint32;
  public native let cameraTriangleCount: Uint32;
  public native let shadowTriangleCount: Uint32;
  public native let playerPosition: String;
  public native let playerOrientation: String;
}

public native class FunctionalTestsDataTimeStatsData extends ISerializable {
  public native let engineTick: Uint64;
  public native let lastFps: Float;
  public native let minFps: Float;
  public native let lastTimeDelta: Float;
  public native let engineTime: Double;
  public native let cpuTime: Float;
  public native let gpuTime: Float;
  public native let rawLocalTime: Uint64;
  public native let playerPosition: String;
  public native let playerOrientation: String;
}

public native class FunctionalTestsGameSystem extends FunctionalTestsGameSystemInterface {
  public final static native func GetLocalizationStringByKey()
  public final native func ActivateSpawner()
  public final native func CheckCurrentAnimation()
  public final native func CheckCurrentAnimations()
  public final native func CheckSessionLoaded()
  public final native func ClearQuestArrays()
  public final native func ClearSingleQuest()
  public final native func DeactivateSpawner()
  public final native func DespawnEntityByID()
  public final native func DisableAutoMemoryDump()
  public final native func DumpMemoryReport()
  public final native func ExecuteDebugCommand()
  public final native func FakeInputAxisAction()
  public final native func FakeInputClickAction()
  public final native func FakeInputHoldAction()
  public final native func FakeInputMultitapAction()
  public final native func FakeInputPressAction()
  public final native func FakeInputReleaseAction()
  public final native func FakeInputReleaseAxisAction()
  public final native func FakePressButton()
  public final native func FakeReleaseButton()
  public final native func FakeSetAxis()
  public final native func GetAnyEntityFromSpawner()
  public final native func GetAxisDeadzoneInner()
  public final native func GetAxisDeadzoneOuter()
  public final native func GetBasicCrowdInfo()
  public final native func GetBoneWorldTransform()
  public final native func GetConfigVar()
  public final native func GetCrowdStubsEntitiesIDs()
  public final native func GetCurrentTargetPosition()
  public final native func GetDebugCameraWorldTransform()
  public final native func GetEntitiesFromSpawner()
  public final native func GetEntityByTag()
  public final native func GetEntityComponent()
  public final native func GetEntityIDsFromSpawner()
  public final native func GetLastSaveName()
  public final native func GetLastSpawnedEntityID()
  public final native func GetNodeEntityByGlobalName()
  public final native func GetPeerID()
  public final native func GetPlayerControlledObject()
  public final native func GetPlayerOrientation()
  public final native func GetPlayerPosition()
  public final native func GetSceneEntity()
  public final native func GetSceneEntityID()
  public final native func GetStaticMarkerWorldMatrix()
  public final native func IsQuestBlockFinished()
  public final native func IsQuestBlockStarted()
  public final native func IsSpawnerActive()
  public final native func IsStreaming()
  public final native func IsStreamingTestFinished()
  public final native func LookAtPosition()
  public final native func NavigateFlatTowards()
  public final native func NotifyReachedCurrentDestination()
  public final native func ReleaseAllInput()
  public final native func RequestAutoSave()
  public final native func SetConfigVar()
  public final native func SetCurrentTargetPosition()
  public final native func SpawnEntity()
  public final native func TakeOverInput()
  public final native func TeleportPlayer()
}

public abstract native class FunctionalTestsGameSystemInterface extends IGameSystem {}

public native struct FunctionalTestsInputManager {}

public abstract native class FunctionalTestsIRuntimeSystem extends worldIRuntimeSystem {}

public native class FunctionalTestsRuntimeSystem extends FunctionalTestsIRuntimeSystem {}

public native class FunctionalTestsState_FunctionalTests extends gsmState {}

public native class FunctionalTestsState_InternalFunctionalTests extends gsmState {}

public native struct fxCompositionShaderParams {
  public native let glitchParam: Float;
  public native let glitchParam1: Float;
  public native let health: Float;
  public native let visionActiveTime: Float;
  public native let uiFactor: Float;
  public native let uiPassthroughFactor: Float;
  public native let mainRenderFactor: Float;
  public native let blurredRenderFactor: Float;
  public native let backgroundTextureFactor: Float;
  public native let backgroundBlurRadius: Float;
  public native let sphericalDistPower: Vector2;
  public native let shadowDistance: Vector2;
  public native let shadowIntensity: Float;
  public native let shadowRadius: Float;
  public native let glowIntensity: Float;
  public native let glowTresholdStart: Float;
  public native let glowTresholdEnd: Float;
  public native let glowBlurRadius: Float;
  public native let vignetteStart: Float;
  public native let vignetteEnd: Float;
  public native let vignetteIntensity: Float;
  public native let blurredRenderSaturation: Float;
  public native let uiSaturation: Float;
  public native let chromaticAberrationStrength: Float;
  public native let uiLayer2Scale: Vector2;
  public native let uiLayer3Scale: Vector2;
  public native let uiLayer4Scale: Vector2;
  public native let uiLayer2Weight: Float;
  public native let uiLayer3Weight: Float;
  public native let uiLayer4Weight: Float;
}

public native struct gameActionReplicatedState {
  public native let replicationId: Uint32;
  public native let type: Uint16;
  public native let startTimeStamp: netTime;
  public native let stopTimeStamp: netTime;
  public native let updateBucket: Uint8;
}

public native struct gameActionsReplicationBuffer {}

public enum gameAggregationType {
  AND = 0,
  OR = 1,
}

public native struct gameAIDirectorSpawner {}

public native class gameAIDirectorSystem extends gameIAIDirectorSystem {}

public native class gameAIDirectorTensionAnalyzeComponent extends IComponent {}

public native struct gameAIDirectorTensionAnalyzer {}

public enum gameAIDirectorTensionEventType {
  Time = 0,
  Progress = 1,
  DealingDamage = 2,
  TakingDamage = 3,
  Kill = 4,
}

public native struct gameaimAssistAimAssist {}

public native struct gameaimAssistAimAssistRemotePlayer {}

public enum gameAlwaysSpawnedState {
  default__false_ = 0,
  true = 1,
  false = 2,
}

public native struct gameAnimationExtractedData {
  public native let animationName: CName;
  public native let animsetsExtractedTransforms: array<gameAnimationTransforms>;
  public native let smartObjectPointType: gameSmartObjectPointType;
}

public native struct gameAnimationOverrideDefinition {
  public native let animset: ResourceAsyncRef; // raRef<animAnimSet>
  public native let variables: array<CName>;
}

public native class gameAnimationPersistentDataSystem extends IGameSystem {}

public native struct gameAnimationTransforms {
  public native let extractedMotion: array<Transform>;
  public native let gatePosition: Transform;
  public native let boneOffset: Transform;
  public native let animsetHash: Uint64;
}

public native class gameAnimFeature_TPPRepresentation extends AnimFeature {
  public native let IsActive: Bool;
}

public native struct gameAnimParamSlotsOption {
  public native let slotID: TweakDBID;
  public native let paramName: CName;
  public native let function: entAnimParamSlotFunction;
}

public native struct gameAnimsetOverrideData {
  public native let animsetHash: Uint64;
  public native let variables: array<CName>;
}

@neverRef()
public native class gameAppearanceNameVisualTagsPreset_AppearanceTags extends ISerializable {
  public native let appearanceName: CName;
  public native let visualTags: redTagList;
}

@neverRef()
public native class gameAppearanceNameVisualTagsPreset_Entity extends ISerializable {
  public native let entityPathHash: Uint64;
  public native let debugEntityPath: CName;
  public native let entityRigPathHash: Uint64;
  public native let debugEntityRigPath: CName;
  public native let commonVisualTags: redTagList;
  public native let appearancesToTags: array<gameAppearanceNameVisualTagsPreset_AppearanceTags>;
}

public native class gameAppearanceNameVisualTagsPreset extends ISerializable {
  public native let presets: array<gameAppearanceNameVisualTagsPreset_Entity>;
}

public enum gameAppearanceSource {
  EntityResource = 0,
  PopulationSpawner = 1,
  CommunityEntry = 2,
  CommunityAppearancePicker = 3,
  TweakDBRecord = 4,
  VisualTag = 5,
  Invalid = 7,
}

public native struct gameAreaData {
  public native let position: Vector4;
  public native let size: Float;
  public native let type: gameEAreaType;
  public native let shape: gameEAreaShape;
  public native let name: CName;
  public native let priority: Uint32;
  public native let lootID: TweakDBID;
}

public native class gameAreaManager extends gameIAreaManager {}

public native struct gameAreaProvider {}

public native class gameAreaResource extends CResource {
  public native let cookedData: array<gameCookedAreaData>;
}

public native class gameAreaVolume extends GameObject {
  public native let areaData: gameAreaData;
}

public native class gameAttachmentSlotEventsItemEquippedInSlot extends AttachmentSlotEvent {}

public native class gameAttachmentSlotEventsItemUnequippedFromSlot extends AttachmentSlotEvent {}

public native struct gameAttachmentSlotReplicatedState {
  public native let slotID: TweakDBID;
  public native let activeItemID: ItemID;
  public native let hasItemObject: Bool;
}

public native class gameAttachmentSlots extends IComponent {
  public native let animParams: array<gameAnimParamSlotsOption>;
}

public native class gameAttachmentSlotsFunctorListener extends AttachmentSlotsListener {}

public native struct gameAttachmentSlotsListenerData {}

public native class gameAttitudeAgentPS extends GameComponentPS {
  public native persistent let currentAttitudeGroup: CName;
  public native persistent let currentAttitudeGroupUnsavable: CName;
}

public native class gameaudioBreathingSubSystem extends gameaudioISoundComponentSubSystem {
  public native let metadataName: CName;
}

public native class gameAudioClueObject extends GameObject {}

public native class gameaudioeventsDialogLineEnd extends Event {}

public native class gameaudioeventsDive extends Event {}

public native class gameaudioeventsEmerge extends Event {
  public native let oxygen: Float;
}

public abstract native class gameaudioeventsEmitterEvent extends Event {
  public native let emitterName: CName;
}

public native class gameaudioeventsHitEvent extends Event {
  public native let attackType: gamedataAttackType;
  public native let hitPosition: Vector4;
  public native let physicsMaterial: CName;
  public native let damage: Float;
  public native let isTargetPuppet: Bool;
  public native let targetPuppetMeleeMaterial: CName;
  public native let isTargetPuppetHead: Bool;
}

public native class gameaudioeventsNotifyBreathingSubSystemStateChangeRequested extends Event {}

public native class gameaudioeventsNotifyFootstepSubSystemStateChangeRequested extends Event {}

public native class gameaudioeventsPlaySoundOnEmitter extends gameaudioeventsEmitterEvent {
  public native let eventName: CName;
}

public native class gameaudioeventsSetParameterOnEmitter extends gameaudioeventsEmitterEvent {
  public native let paramName: CName;
  public native let paramValue: Float;
}

public native class gameaudioeventsStopDialogLine extends Event {
  public native let stringId: CRUID;
  public native let fadeOut: Float;
}

public native class gameaudioeventsStopSoundOnEmitter extends gameaudioeventsEmitterEvent {
  public native let soundName: CName;
}

public native class gameaudioeventsStopTaggedSounds extends Event {
  public native let audioTag: CName;
}

public native class gameaudioeventsSurface extends Event {}

public native class gameaudioeventsVehicleCollision extends Event {}

public native class gameaudioFlybySubSystem extends gameaudioISoundComponentSubSystem {}

public abstract native class gameaudioIAudioSubSystem extends IScriptable {}

public abstract native class gameaudioIScanningSystem extends IGameSystem {}

public abstract native class gameaudioISoundComponentSubSystem extends gameaudioIAudioSubSystem {}

public abstract native class gameaudioIWeaponAudioComponentSubSystem extends gameaudioIAudioSubSystem {}

public native class gameaudioMeleeAudioSubSystem extends gameaudioIWeaponAudioComponentSubSystem {}

public native class gameaudioMusicSyncComponent extends IComponent {
  public native let notifyBeats: Bool;
  public native let notifyBars: Bool;
  public native let notifyGrid: Bool;
  public native let notifyBarProgression: Bool;
  public native let notifyBeatProgression: Bool;
  public native let syncTrack: CName;
}

public native class gameaudioRagdollSubSystem extends gameaudioISoundComponentSubSystem {
  public native let defaultMaterialMetadata: CName;
  public native let customDismembermentSettings: CName;
  public native let lookupMatrixName: CName;
}

public native class gameaudioScanningSystem extends gameaudioIScanningSystem {}

@neverRef()
public native class gameaudioSoundComponentSubSystemWrapper extends ISerializable {
  public native let type: ref<gameaudioISoundComponentSubSystem>;
}

public native struct gameAudioSyncs {
  public native let switchEvents: array<audioAudSwitch>;
  public native let playEvents: array<audioAudEventStruct>;
  public native let stopEvents: array<audioAudEventStruct>;
  public native let parameterEvents: array<audioAudParameter>;
}

public native class gameAugmentedRealitySign extends GameObject {}

public native struct gameAvailableAnimset {
  public native let hash: Uint64;
  public native let resourcePath: String;
}

public abstract native struct gameBaseGameSession {}

public abstract native class gameBaseTimer extends IScriptable {}

public native struct gamebbDynArrayBlackboardStorage {}

public native struct gamebbID {
  public native let g: CName;
}

public native class gameBinkMeshTargetAttachment extends entIAttachment {}

public native class gameBinkMeshTargetBinding extends entISourceBinding {}

public enum gameBinkVideoAction {
  Undefined = 0,
  Start = 1,
  Stop = 2,
}

public native class gameBinkVideoData extends ISerializable {
  public native let data: array<gameBinkVideoRecord>;
}

public native class gameBinkVideoEvent extends Event {
  public native let videoPath: String;
  public native let action: gameBinkVideoAction;
}

@neverRef()
public native class gameBinkVideoRecord extends ISerializable {
  public native let resourceHash: Uint64;
  public native let binkDuration: Float;
}

public native struct gameBlackboardPropertyBindingDefinition {
  public native let serializableID: BlackboardSerializableID;
  public native let propertyPath: array<CName>;
  public native let propertyType: CName;
}

public native class gameBlueprintStackableItemData extends gameItemData {}

public native class gameBodyTriggerDestructionComponent extends gameITriggerDestructionComponent {
  public native let colliderComponentName: CName;
  public native let filterData: ref<physicsFilterData>;
  public native let impulseForce: Float;
  public native let impulseRadius: Float;
}

public native struct gameBodyTypeAnimationDefinition {
  public native let rig: ResourceAsyncRef; // raRef<animRig>
  public native let animsets: array<ResourceAsyncRef>;
  public native let overrides: array<gameAnimationOverrideDefinition>;
}

public native struct gameBodyTypeData {
  public native let rigHash: Uint64;
  public native let animsetHashes: array<Uint64>;
  public native let overrides: array<gameAnimsetOverrideData>;
}

public enum gameBoolSignalAction {
  None = 0,
  TurnOn = 1,
  TurnOff = 2,
}

public native class gameBreachSystem extends gameIBreachSystem {}

public native struct gameCActionAIProxy {}

public native class gameCActionsFactory extends gameIActionsFactory {}

public enum gameCameraCurve {
  CentricPitchOfSpeed = 0,
  CentricVerticalOffsetOfSpeed = 1,
  BoomLengthOfSpeed = 2,
  BoomLengthOfAcc = 3,
  BoomPitchOfSpeed = 4,
  BoomPitchOfGlobalVehiclePitch = 5,
  BoomYawOfTurnCoeff = 6,
  BoomYawRotateRateOfSpeed = 7,
  FOVOfSpeed = 8,
  PivotOffsetXOfTurnCoeff = 9,
  PivotOffsetZOfTurnCoeff = 10,
  COUNT = 11,
}

public native class gameCameraCurveSet extends CurveSet {}

public native class gameCameraCurvesLibrary extends Entity {
  public native let cameraCurves: array<ResourceRef>;
}

public abstract native class gamecameraISettingManager extends IGameSystem {}

public native struct gameCameraLocation {
  public native let position: Vector3;
  public native let rotation: EulerAngles;
}

public native class gamecameraSettingManager extends gamecameraISettingManager {}

public native struct gameCategorySelectionProbability {
  public native let probabilities: array<gameSpotSequenceCategory>;
}

public native class gameCDebugSystem extends gameIDebugSystem {}

public native struct gamecheatsystemObjCheats {
  public native let object: wref<GameObject>;
  public native let flags: Int32;
}

public native struct gameChildEffectsMovingInCone_State {}

public importonly class gameClientEntitySpawnSystem extends IClientEntitySpawnSystem {}

public native class gameCollidableEntityId extends ISerializable {}

public native class gameCollisionQueriesSystem extends gameICollisionQueriesSystem {}

public native class gameCombatQueriesSystem extends gameICombatQueriesSystem {}

public native struct gameCommunityID {
  public native persistent let entityId: EntityID;
}

public native struct gameCommunitySpawnSetNameToID {
  public native let entries: array<gameCommunitySpawnSetNameToIDEntry>;
}

public native struct gameCommunitySpawnSetNameToIDEntry {
  public native let communityId: gameCommunityID;
  public native let nameReference: CName;
}

public native struct gameCommunityTrafficConnectionsEntry {}

public enum gameComparisonType {
  EQUAL = 0,
  NOT_EQUAL = 1,
  LESS = 2,
  GREATER = 3,
  LESS_OR_EQUAL = 4,
  GREATER_OR_EQUAL = 5,
}

public native class gameCompiledCoverData extends gameCompiledSmartObjectData {}

public native class gameCompiledNodes extends ISerializable {
  public native let compiledSmartObjects: array<gameCompiledSmartObjectNode>;
}

public native class gameCompiledShootingSpotData extends gameCompiledCoverData {}

public native class gameCompiledSmartObjectData extends ISerializable {}

public native struct gameCompiledSmartObjectNode {
  public native let compiledData: ref<gameCompiledSmartObjectData>;
  public native let worldTransform: WorldTransform;
}

public native class gameComponentsStateSaveComponent extends IComponent {}

public native class gameComponentsStateSystem extends gameIComponentsStateSystem {}

public native struct gameCompressedSmartObjectPointProperties {
  public native let propertyId: Uint16;
}

public native struct gameCompressedSmartObjectPointTransform {
  public native let transformId: Uint16;
}

public native class gameContainerInventoryListener extends InventoryListener {}

public native class gameContainerObjectAnimated extends gameContainerObjectBase {
  public native let animFeatureName: CName;
}

public abstract native class gameController extends GameObject {}

public native struct gameCookedAreaData {
  public native let entityID: EntityID;
  public native let position: Vector3;
  public native let radius: Float;
  public native let volume: ref<gamemappinsIMappinVolume>;
}

public native struct gameCookedDeviceData {
  public native let className: CName;
  public native let parents: array<Uint64>;
  public native let children: array<Uint64>;
  public native let nodePosition: Vector3;
}

public native struct gameCookedGpsMappinData {
  public native let journalPathHash: Uint32;
  public native let positions: array<Vector3>;
}

public native class gameCookedLootData extends ISerializable {
  public native let lootTables: array<TweakDBID>;
  public native let contentAssignment: TweakDBID;
}

public native struct gameCookedMappinData {
  public native let journalPathHash: Uint32;
  public native let position: Vector3;
  public native let volume: ref<gamemappinsIMappinVolume>;
}

public native struct gameCookedMultiMappinData {
  public native let journalPathHash: Uint32;
  public native let positions: array<Vector3>;
}

public native struct gameCookedPointOfInterestMappinData {
  public native let journalPathHash: Uint32;
  public native let entityID: EntityID;
  public native let position: Vector3;
}

public native class gameCooldownFinishedEvent extends gameCooldownSystemEvent {}

public native class gameCooldownRemovedEvent extends gameCooldownSystemEvent {}

public native class gameCooldownSystem extends ICooldownSystem {}

public native class gameCooldownSystemEvent extends Event {}

public native class gameCoverDefinition extends gameSmartObjectWorkspotDefinition {
  public native let overridenCoveringFOVDegrees: Float;
  public native let overridenCoveringVerticalFOVDegrees: Float;
  public native let fovExposureDegrees: Float;
  public native let overridenHeight: gameCoverHeight;
  public native let overrideGeneratedCoverAngles: Bool;
}

public native struct gameCoveringArc {
  public native let leftAngle: Float;
  public native let rightAngle: Float;
  public native let verticalAngle: Float;
}

public native class gameCoverObject extends GameObject {
  public native let coverType: animCoverState;
  public native let slotRadius: Float;
  public native let hpMax: Float;
  public native let isDestructible: Bool;
  public native let fovDegrees: Float;
  public native let fovExposureDegrees: Float;
}

public native class gameCpoArmouryItem extends GameObject {
  public native let armouryItemID: TweakDBID;
}

public native struct gameCrowdCreationData {
  public native let timePeriods: [gameCrowdPhaseTimePeriod; 4];
}

public enum gameCrowdCreationDataMergeMode {
  Average = 0,
  Override = 1,
}

public native class gameCrowdCreationDataRegistry extends ISerializable {
  public native let creationData: array<gameCrowdCreationData>;
}

public native class gameCrowdEntityReuseEvent extends Event {}

public enum gameCrowdEntryType {
  Pedestrian = 0,
  Vehicle = 1,
  AV = 2,
}

public native struct gameCrowdTemplateCharacterData {
  public native let characterRecordId: TweakDBID;
  public native let weight: Float;
}

public native struct gameCrowdTemplateEntry {
  public native let entryName: CName;
  public native let markings: array<CName>;
  public native let phases: array<gameCrowdTemplateEntryPhase>;
  public native let type: gameCrowdEntryType;
}

public native struct gameCrowdTemplateEntryPhase {
  public native let phaseName: CName;
  public native let timePeriods: array<gameCrowdPhaseTimePeriod>;
  public native let density: Float;
  public native let charactersData: array<gameCrowdTemplateCharacterData>;
  public native let legacy: Bool;
  public native let legacyDensityInTimePeriods: Bool;
  public native let legacyCharactersData: Bool;
}

public native class gameCursorInterpolationOverrides extends inkUserData {
  public native let minSpeed: Vector2;
  public native let enterTime: Float;
}

public native class gameCyberspaceBoundaryNode extends worldTriggerAreaNode {
  public native let marker1Ref: NodeRef;
  public native let marker2Ref: NodeRef;
}

public native class gameCyberspaceBoundaryNodeInstance extends worldTriggerAreaNodeInstance {}

public native struct gameCyberspacePixelsortEffectParams {
  public native let fullscreen: Bool;
  public native let vfx: Bool;
  public native let initialDatamosh: Float;
  public native let targetDatamosh: Float;
  public native let initialIntensity: Float;
  public native let targetIntensity: Float;
  public native let timeBlend: Float;
}

public native class gameDamageSystemSharedState extends gameIGameSystemReplicatedState {
  public native let hitHistory: array<ref<ServerHitData>>;
  public native let killHistory: array<ref<ServerKillData>>;
}

public native class gamedataComplexValueNode extends gamedataValueDataNode {
  public native let data: array<String>;
}

public abstract native class gamedataDataNode extends ISerializable {
  public native let nodeType: gamedataDataNodeType;
  public native let fileName: String;
  public native let parent: wref<gamedataDataNode>;
}

public enum gamedataDataNodeType {
  File = 0,
  Group = 1,
  Variable = 2,
  Value = 3,
  SimpleValue = 4,
  ComplexValue = 5,
}

public native class gamedataFileNode extends gamedataDataNode {
  public native let packageName: String;
  public native let packageDependencies: [wref<gamedataPackageNode>; 16];
  public native let package: wref<gamedataPackageNode>;
  public native let variables: array<ref<gamedataVariableNode>>;
  public native let groups: array<ref<gamedataGroupNode>>;
}

public native class gamedataGroupNode extends gamedataDataNode {
  public native let name: String;
  public native let base: String;
  public native let schema: String;
  public native let isInline: Bool;
  public native let baseGroup: wref<gamedataGroupNode>;
  public native let schemaGroup: wref<gamedataGroupNode>;
  public native let package: wref<gamedataPackageNode>;
  public native let fileNode: ref<gamedataFileNode>;
  public native let inlineGroupId: Uint32;
  public native let inheritanceState: gamedataGroupNodeInheritanceState;
  public native let serializedVariables: array<gamedataGroupNodeGroupVariable>;
  public native let tags: array<CName>;
}

public native struct gamedataGroupNodeGroupVariable {
  public native let node: ref<gamedataVariableNode>;
  public native let deriveInfo: gamedataGroupNodeGroupVariableDeriveInfo;
  public native let flattened: Bool;
  public native let flatId: TweakDBID;
}

public enum gamedataGroupNodeGroupVariableDeriveInfo {
  FullyDerived = 0,
  TypeDerived = 1,
  ValueChanged = 2,
  NotDerived = 3,
}

public enum gamedataGroupNodeInheritanceState {
  Unresolved = 0,
  Resolving = 1,
  Resolved = 2,
}

public native class gamedataPackageNode extends ISerializable {
  public native let name: String;
  public native let serializedVariables: array<ref<gamedataVariableNode>>;
  public native let serializedGroups: array<ref<gamedataGroupNode>>;
  public native let files: array<ref<gamedataFileNode>>;
}

public native class gamedataSimpleValueNode extends gamedataValueDataNode {
  public native let type: gamedataSimpleValueNodeValueType;
  public native let data: String;
}

public enum gamedataSimpleValueNodeValueType {
  String = 0,
  Number = 1,
  Bool = 2,
  Ident = 3,
}

public enum gamedataStatType_1300DEPRECATED {
  Acceleration = 0,
  Accuracy = 1,
  Adrenaline = 2,
  AimFOV = 3,
  AimInTime = 4,
  AimOffset = 5,
  AimOutTime = 6,
  AllowMovementInput = 7,
  AllowRotation = 8,
  Armor = 9,
  Assault = 10,
  AssaultMastery = 11,
  AssaultTrait01Stat = 12,
  Athletics = 13,
  AthleticsMastery = 14,
  AthleticsTrait01Stat = 15,
  AttackPenetration = 16,
  AttackSpeed = 17,
  AttackSpeedPercent = 18,
  AttacksNumber = 19,
  AttacksPerSecond = 20,
  AttacksPerSecondBase = 21,
  AudioLocomotionStimRangeMultiplier = 22,
  AudioStimRangeMultiplier = 23,
  AutoReveal = 24,
  AutocraftDuration = 25,
  AutomaticReplenishment = 26,
  AutomaticUploadPerk = 27,
  BaseChargeTime = 28,
  BaseDamage = 29,
  BaseDamageMax = 30,
  BaseDamageMin = 31,
  BerserkArmorBonus = 32,
  BerserkCooldownBase = 33,
  BerserkCooldownReduction = 34,
  BerserkDurationBase = 35,
  BerserkHealthRegenBonus = 36,
  BerserkMeleeDamageBonus = 37,
  BerserkRecoilReduction = 38,
  BerserkResistancesBonus = 39,
  BerserkShockwaveDamage = 40,
  BerserkShockwaveRangeBonus = 41,
  BerserkSwayReduction = 42,
  BleedingApplicationRate = 43,
  BleedingImmunity = 44,
  BlindImmunity = 45,
  BlindResistance = 46,
  BlockFactor = 47,
  BlockLocomotionWhenLeaningOutOfCover = 48,
  BlockReduction = 49,
  BonusChargeDamage = 50,
  BonusDPS = 51,
  BonusDamageAgainstElites = 52,
  BonusDamageAgainstMechanicals = 53,
  BonusDamageAgainstRares = 54,
  BonusQuickHackDamage = 55,
  BonusRicochetDamage = 56,
  Brake = 57,
  BrakeDot = 58,
  Brawling = 59,
  BrawlingMastery = 60,
  BrawlingTrait01Stat = 61,
  BufferSize = 62,
  BulletMagnetismDefaultAngle = 63,
  BulletMagnetismHighVelocityAngle = 64,
  BulletPseudoPierceHitVFxChance = 65,
  BulletSurroundingHitVFxChance = 66,
  BurningApplicationRate = 67,
  BurningImmunity = 68,
  BurningRegenStamina = 69,
  CPUPower = 70,
  CallReinforcement = 71,
  CameraShutdownExtension = 72,
  CanAerialTakedown = 73,
  CanAimWhileDodging = 74,
  CanAskToFollowOrder = 75,
  CanAskToHolsterWeapon = 76,
  CanAutomaticallyDisassembleJunk = 77,
  CanAutomaticallyRestoreKnives = 78,
  CanBleedingCriticallyHit = 79,
  CanBleedingSlowTarget = 80,
  CanBlindQuickHack = 81,
  CanBlock = 82,
  CanBreatheUnderwater = 83,
  CanBuffCamoQuickHack = 84,
  CanBuffMechanicalsOnTakeControl = 85,
  CanBuffSturdinessQuickHack = 86,
  CanBurningCriticallyHit = 87,
  CanCallDrones = 88,
  CanCallReinforcements = 89,
  CanCatchUp = 90,
  CanCatchUpDistance = 91,
  CanCharge = 92,
  CanChargedShoot = 93,
  CanCloseCombat = 94,
  CanCommsCallInQuickHack = 95,
  CanCommsCallOutQuickHack = 96,
  CanCommsNoiseQuickHack = 97,
  CanControlFullyChargedWeapon = 98,
  CanCraftEpicItems = 99,
  CanCraftFromInventory = 100,
  CanCraftLegendaryItems = 101,
  CanCraftRareItems = 102,
  CanCraftTechAmmunition = 103,
  CanCrouch = 104,
  CanCyberwareMalfunctionQuickHack = 105,
  CanDash = 106,
  CanDataMineQuickHack = 107,
  CanDealFullDamageToArmored = 108,
  CanDeathQuickHack = 109,
  CanDisassemble = 110,
  CanDisassembleConsumables = 111,
  CanDisassembleGadgets = 112,
  CanDropWeapon = 113,
  CanElectrocuteNullifyStats = 114,
  CanElectrocuteRoot = 115,
  CanExitWSOnSoundStimuli = 116,
  CanExplodeQuickHack = 117,
  CanFastTravelWhileEncumbered = 118,
  CanFullyChargeWeapon = 119,
  CanGrab = 120,
  CanGrappleAndroids = 121,
  CanGrappleSilently = 122,
  CanGrenadeLaunch = 123,
  CanGrenadeQuickHack = 124,
  CanGrenadesCriticallyHit = 125,
  CanGrenadesDealExternalDamage = 126,
  CanGuardBreak = 127,
  CanHeartattackQuickHack = 128,
  CanIgnoreArmorDamageReduction = 129,
  CanIgnoreStamina = 130,
  CanInstallTechMods = 131,
  CanJamWeaponQuickHack = 132,
  CanJump = 133,
  CanLandSilently = 134,
  CanLegendaryCraftedWeaponsBeBoosted = 135,
  CanLocomotionMalfunctionQuickHack = 136,
  CanMadnessQuickHack = 137,
  CanMalfunctionQuickHack = 138,
  CanMeleeBerserk = 139,
  CanMeleeDash = 140,
  CanMeleeInfinitelyCombo = 141,
  CanMeleeLeap = 142,
  CanMeleeLeapTakedown = 143,
  CanOverchargeWeapon = 144,
  CanOverheatQuickHack = 145,
  CanOverloadQuickHack = 146,
  CanOverrideAttitudeQuickHack = 147,
  CanOverrideAuthorizationQuickHack = 148,
  CanParry = 149,
  CanPickUpBodyAfterTakedown = 150,
  CanPickUpWeapon = 151,
  CanPingQuickHack = 152,
  CanPlayerBoostConsumables = 153,
  CanPlayerBoostGrenades = 154,
  CanPoisonLowerArmor = 155,
  CanPoisonSlow = 156,
  CanPreciseShoot = 157,
  CanPushBack = 158,
  CanPushFromGrapple = 159,
  CanQuickHackCriticallyHit = 160,
  CanQuickMeleeStagger = 161,
  CanQuickhack = 162,
  CanQuickhackHealPuppet = 163,
  CanQuickhackTransferBetweenEnemies = 164,
  CanRegenInCombat = 165,
  CanRemoveModsFromClothing = 166,
  CanRemoveModsFromWeapons = 167,
  CanResurrectAllies = 168,
  CanRetrieveModsFromDisassemble = 169,
  CanRunSilently = 170,
  CanSandevistanSprintHarass = 171,
  CanScrapPartsFromMechanicals = 172,
  CanSeeGrenadeRadius = 173,
  CanSeeRicochetVisuals = 174,
  CanSeeThroughWalls = 175,
  CanShareThreatsWithPlayer = 176,
  CanShootWhileCarryingBody = 177,
  CanShootWhileDodging = 178,
  CanShootWhileGrappling = 179,
  CanShootWhileMoving = 180,
  CanShootWhileVaulting = 181,
  CanSilentKill = 182,
  CanSmartShoot = 183,
  CanSprint = 184,
  CanSprintHarass = 185,
  CanSprintWhileCarryingBody = 186,
  CanSuicideQuickHack = 187,
  CanSwitchWeapon = 188,
  CanTakeControlQuickHack = 189,
  CanTakedownLethally = 190,
  CanTakedownSilently = 191,
  CanTaunt = 192,
  CanThrowWeapon = 193,
  CanUpgradeFromInventory = 194,
  CanUpgradeToLegendaryQuality = 195,
  CanUseAntiStun = 196,
  CanUseBiohazardGrenades = 197,
  CanUseCloseRing = 198,
  CanUseCombatStims = 199,
  CanUseConsumables = 200,
  CanUseCoolingSystem = 201,
  CanUseCovers = 202,
  CanUseCuttingGrenades = 203,
  CanUseEMPGrenades = 204,
  CanUseExtremeRing = 205,
  CanUseFarRing = 206,
  CanUseFlashbangGrenades = 207,
  CanUseFragGrenades = 208,
  CanUseGrenades = 209,
  CanUseHolographicCamo = 210,
  CanUseIncendiaryGrenades = 211,
  CanUseLeftHand = 212,
  CanUseLegs = 213,
  CanUseMantisBlades = 214,
  CanUseMediumRing = 215,
  CanUseMeleeRing = 216,
  CanUseOpticalCamo = 217,
  CanUsePainInhibitors = 218,
  CanUsePersonalSoundSilencer = 219,
  CanUseProjectileLauncher = 220,
  CanUseReconGrenades = 221,
  CanUseRetractableShield = 222,
  CanUseRightHand = 223,
  CanUseShootingSpots = 224,
  CanUseStaticCamo = 225,
  CanUseStrongArms = 226,
  CanUseTakedowns = 227,
  CanUseTerrainCamo = 228,
  CanUseZoom = 229,
  CanWalkSilently = 230,
  CanWallStick = 231,
  CanWeaponBlock = 232,
  CanWeaponBlockAttack = 233,
  CanWeaponComboAttack = 234,
  CanWeaponCriticallyHit = 235,
  CanWeaponCrouchAttack = 236,
  CanWeaponDash = 237,
  CanWeaponDeflect = 238,
  CanWeaponIgnoreArmor = 239,
  CanWeaponInfinitlyCombo = 240,
  CanWeaponJumpAttack = 241,
  CanWeaponLeap = 242,
  CanWeaponMalfunctionQuickHack = 243,
  CanWeaponReload = 244,
  CanWeaponReloadWhileInactive = 245,
  CanWeaponReloadWhileSliding = 246,
  CanWeaponReloadWhileSprinting = 247,
  CanWeaponReloadWhileVaulting = 248,
  CanWeaponSafeAttack = 249,
  CanWeaponShoot = 250,
  CanWeaponShootWhileSliding = 251,
  CanWeaponShootWhileSprinting = 252,
  CanWeaponShootWhileVaulting = 253,
  CanWeaponSnapToLimbs = 254,
  CanWeaponSprintAttack = 255,
  CanWeaponStrongAttack = 256,
  CanWeaponTriggerHeadshot = 257,
  CannotBeDetectedWhileSubmerged = 258,
  CannotBeHealed = 259,
  CannotSprintHarass = 260,
  CarryCapacity = 261,
  CausingPanicReducesUltimateHacksCost = 262,
  Charge = 263,
  ChargeDischargeTime = 264,
  ChargeFullMultiplier = 265,
  ChargeMaxTimeInChargedState = 266,
  ChargeMultiplier = 267,
  ChargeReadyPercentage = 268,
  ChargeShouldFireWhenReady = 269,
  ChargeTime = 270,
  ChemicalDamage = 271,
  ChemicalDamageMax = 272,
  ChemicalDamageMin = 273,
  ChemicalDamagePercent = 274,
  ChemicalResistance = 275,
  ClimbSpeedModifier = 276,
  ClipTimesCycle = 277,
  ClipTimesCycleBase = 278,
  ClipTimesCyclePlusReload = 279,
  ClipTimesCyclePlusReloadBase = 280,
  CloudComputingTraps = 281,
  ColdBlood = 282,
  ColdBloodBuffBonus = 283,
  ColdBloodMastery = 284,
  ColdBloodMaxDuration = 285,
  ColdBloodMaxStacks = 286,
  ColdBloodTrait01 = 287,
  CombatHacking = 288,
  CombatHackingMastery = 289,
  CommsNoiseJamOnQuickhack = 290,
  Cool = 291,
  Crafting = 292,
  CraftingBonusArmorValue = 293,
  CraftingBonusConsumableDuration = 294,
  CraftingBonusGrenadeDamage = 295,
  CraftingBonusWeaponDamage = 296,
  CraftingCostReduction = 297,
  CraftingItemLevelBoost = 298,
  CraftingMastery = 299,
  CraftingMaterialDropChance = 300,
  CraftingMaterialRandomGrantChance = 301,
  CraftingMaterialRetrieveChance = 302,
  CraftingTrait01 = 303,
  CritChance = 304,
  CritChanceTimeCritDamage = 305,
  CritDPSBonus = 306,
  CritDamage = 307,
  CyberwareCooldownReduction = 308,
  CycleTime = 309,
  CycleTimeAimBlockDuration = 310,
  CycleTimeAimBlockStart = 311,
  CycleTimeBase = 312,
  CycleTimeBonus = 313,
  CycleTimeShootingMult = 314,
  CycleTimeShootingMultPeriod = 315,
  CycleTime_Burst = 316,
  CycleTime_BurstMaxCharge = 317,
  CycleTime_BurstSecondary = 318,
  CycleTriggerModeTime = 319,
  DPS = 320,
  DamageFalloffDisabled = 321,
  DamageHackSpread = 322,
  DamagePerHit = 323,
  DamageReductionDamageOverTime = 324,
  DamageReductionExplosion = 325,
  DashAttackStaminaCostReduction = 326,
  DataLeakTraps = 327,
  DealsChemicalDamage = 328,
  DealsElectricDamage = 329,
  DealsPhysicalDamage = 330,
  DealsThermalDamage = 331,
  Deceleration = 332,
  DefeatedHeadDamageThreshold = 333,
  DefeatedLArmDamageThreshold = 334,
  DefeatedLLegDamageThreshold = 335,
  DefeatedRArmDamageThreshold = 336,
  DefeatedRLegDamageThreshold = 337,
  DefeatingEnemiesReduceHacksCost = 338,
  Demolition = 339,
  DemolitionMastery = 340,
  DemolitionTrait01Stat = 341,
  Detection = 342,
  DeviceMemoryCostReduction = 343,
  DisableCyberwareOnBurning = 344,
  DisassemblingIngredientsDoubleBonus = 345,
  DisassemblingMaterialQualityObtainChance = 346,
  DismHeadDamageThreshold = 347,
  DismLArmDamageThreshold = 348,
  DismLLegDamageThreshold = 349,
  DismRArmDamageThreshold = 350,
  DismRLegDamageThreshold = 351,
  DoNotCheckFriendlyFireMadnessPassive = 352,
  DummyResistanceStat = 353,
  Durability = 354,
  DurationBonusBleeding = 355,
  DurationBonusBurning = 356,
  DurationBonusElectrified = 357,
  DurationBonusPoisoned = 358,
  DurationBonusQuickhack = 359,
  DurationBonusStun = 360,
  EMPImmunity = 361,
  EffectiveDPS = 362,
  EffectiveDamagePerHit = 363,
  EffectiveDamagePerHitMax = 364,
  EffectiveDamagePerHitMin = 365,
  EffectiveDamagePerHitTimesAttacksPerSecond = 366,
  EffectiveRange = 367,
  ElectricDamage = 368,
  ElectricDamageMax = 369,
  ElectricDamageMin = 370,
  ElectricDamagePercent = 371,
  ElectricResistance = 372,
  ElectrocuteImmunity = 373,
  ElectrocutedApplicationRate = 374,
  ElementalDamagePerHit = 375,
  ElementalResistanceMultiplier = 376,
  EmptyReloadTime = 377,
  Engineering = 378,
  EngineeringMastery = 379,
  EngineeringTrait01 = 380,
  EquipActionDuration_Corpo = 381,
  EquipActionDuration_Gang = 382,
  EquipAnimationDuration_Corpo = 383,
  EquipAnimationDuration_Gang = 384,
  EquipDuration = 385,
  EquipDuration_First = 386,
  EquipItemTime_Corpo = 387,
  EquipItemTime_Gang = 388,
  Evasion = 389,
  ExplosionKillsRecudeUltimateHacksCost = 390,
  FFInputLock = 391,
  FallDamageReduction = 392,
  FearOnQuickHackKill = 393,
  FullAutoOnFullCharge = 394,
  Gunslinger = 395,
  GunslingerMastery = 396,
  GunslingerTrait01Stat = 397,
  HackedEnemiesGetDamagedByFriendlyFire = 398,
  HackedEnemyArmorReduction = 399,
  Hacking = 400,
  HackingMastery = 401,
  HackingPenetration = 402,
  HackingResistance = 403,
  HackingResistanceUltimate = 404,
  HasAdditionalSplinterSlot = 405,
  HasAheadTargeting = 406,
  HasAirHover = 407,
  HasAirThrusters = 408,
  HasAutoReloader = 409,
  HasAutomaticReplenishment = 410,
  HasAutomaticTagging = 411,
  HasBerserk = 412,
  HasBleedImmunity = 413,
  HasBlindImmunity = 414,
  HasBoostedCortex = 415,
  HasBurningBuffs = 416,
  HasCameraLinking = 417,
  HasChargeJump = 418,
  HasCritImmunity = 419,
  HasCyberdeck = 420,
  HasCybereye = 421,
  HasDodge = 422,
  HasDodgeAir = 423,
  HasDoubleJump = 424,
  HasElectricCoating = 425,
  HasElectroPlating = 426,
  HasExtendedHitReactionImmunity = 427,
  HasFireproofSkin = 428,
  HasGPS = 429,
  HasGlowingTattoos = 430,
  HasGraphiteTissue = 431,
  HasHackingInteractions = 432,
  HasHealingReapplication = 433,
  HasHealthMonitorBomb = 434,
  HasHostileHackImmunity = 435,
  HasICELevelBooster = 436,
  HasInfravision = 437,
  HasJuiceInjector = 438,
  HasKerenzikov = 439,
  HasKerenzikovSlide = 440,
  HasKers = 441,
  HasLinkToBountySystem = 442,
  HasLoweringPerception = 443,
  HasMadnessLvl4Passive = 444,
  HasMajorQuickhackResistance = 445,
  HasMechanicalControl = 446,
  HasMeleeImmunity = 447,
  HasMeleeTargeting = 448,
  HasMetabolicEnhancer = 449,
  HasPoisonHeal = 450,
  HasPoisonImmunity = 451,
  HasPowerGrip = 452,
  HasQuickhackResistance = 453,
  HasRemoteBotAccessPointBreach = 454,
  HasSandevistan = 455,
  HasSandevistanTier1 = 456,
  HasSandevistanTier2 = 457,
  HasSandevistanTier3 = 458,
  HasSecondHeart = 459,
  HasSelfHealingSkin = 460,
  HasSmartLink = 461,
  HasSpiderBotControl = 462,
  HasStunImmunity = 463,
  HasSubdermalArmor = 464,
  HasSuperheroFall = 465,
  HasThermovision = 466,
  HasTimedImmunity = 467,
  HasToxicCleanser = 468,
  HasWallRunSkill = 469,
  HeadshotDamageMultiplier = 470,
  HeadshotImmunity = 471,
  Health = 472,
  HealthInCombatRegenDelayOnChange = 473,
  HealthInCombatRegenEnabled = 474,
  HealthInCombatRegenEndThreshold = 475,
  HealthInCombatRegenRate = 476,
  HealthInCombatRegenRateAdd = 477,
  HealthInCombatRegenRateBase = 478,
  HealthInCombatRegenRateMult = 479,
  HealthInCombatRegenStartThreshold = 480,
  HealthInCombatStartDelay = 481,
  HealthMonitorCooldownDuration = 482,
  HealthOutOfCombatRegenDelayOnChange = 483,
  HealthOutOfCombatRegenEnabled = 484,
  HealthOutOfCombatRegenEndThreshold = 485,
  HealthOutOfCombatRegenRate = 486,
  HealthOutOfCombatRegenRateAdd = 487,
  HealthOutOfCombatRegenRateBase = 488,
  HealthOutOfCombatRegenRateMult = 489,
  HealthOutOfCombatRegenStartThreshold = 490,
  Hearing = 491,
  HeavyAttacksNumber = 492,
  HighlightAccessPoint = 493,
  HitDismembermentFactor = 494,
  HitReactionDamageHealthFactor = 495,
  HitReactionFactor = 496,
  HitTimerAfterDefeated = 497,
  HitTimerAfterImpact = 498,
  HitTimerAfterImpactMelee = 499,
  HitTimerAfterKnockdown = 500,
  HitTimerAfterPain = 501,
  HitTimerAfterStagger = 502,
  HitTimerAfterStaggerMelee = 503,
  HitWoundsFactor = 504,
  HoldDuration = 505,
  HoldEnterDuration = 506,
  HoldTimeoutDuration = 507,
  HolographicSkinCooldownDuration = 508,
  HolographicSkinDuration = 509,
  IconicItemUpgraded = 510,
  ImpactDamageThreshold = 511,
  ImpactDamageThresholdImpulse = 512,
  ImpactDamageThresholdInCover = 513,
  Intelligence = 514,
  IsAggressive = 515,
  IsBalanced = 516,
  IsBlocking = 517,
  IsCautious = 518,
  IsDefensive = 519,
  IsDeflecting = 520,
  IsDodgeStaminaFree = 521,
  IsDodging = 522,
  IsFastMeleeArchetype = 523,
  IsFastRangedArchetype = 524,
  IsGenericMeleeArchetype = 525,
  IsGenericRangedArchetype = 526,
  IsHeavyRangedArchetype = 527,
  IsInvulnerable = 528,
  IsItemBroken = 529,
  IsItemCracked = 530,
  IsItemCrafted = 531,
  IsItemIconic = 532,
  IsItemUpgraded = 533,
  IsManBig = 534,
  IsManMassive = 535,
  IsMechanical = 536,
  IsNetrunnerArchetype = 537,
  IsNotSlowedDuringADS = 538,
  IsNotSlowedDuringBlock = 539,
  IsNotSlowedDuringReload = 540,
  IsReckless = 541,
  IsShotgunnerArchetype = 542,
  IsSniperArchetype = 543,
  IsSprintStaminaFree = 544,
  IsStrongMeleeArchetype = 545,
  IsTechieArchetype = 546,
  IsTier1Archetype = 547,
  IsTier2Archetype = 548,
  IsTier3Archetype = 549,
  IsTier4Archetype = 550,
  IsWeakspot = 551,
  IsWeaponLethal = 552,
  ItemArmor = 553,
  ItemLevel = 554,
  ItemRequiresElectroPlating = 555,
  ItemRequiresPowerGrip = 556,
  ItemRequiresSmartLink = 557,
  JumpHeight = 558,
  Kenjutsu = 559,
  KenjutsuMastery = 560,
  KenjutsuTrait01Stat = 561,
  KnockdownDamageThreshold = 562,
  KnockdownDamageThresholdImpulse = 563,
  KnockdownDamageThresholdInCover = 564,
  KnockdownImmunity = 565,
  KnockdownImpulse = 566,
  Level = 567,
  LimbHealth = 568,
  LinearDirectionUpdateMax = 569,
  LinearDirectionUpdateMaxADS = 570,
  LinearDirectionUpdateMin = 571,
  LinearDirectionUpdateMinADS = 572,
  LowerActiveCooldownOnDefeat = 573,
  LowerHackingResistanceOnHack = 574,
  MagazineCapacity = 575,
  MagazineCapacityBase = 576,
  MagazineCapacityBonus = 577,
  MaxDuration = 578,
  MaxPercentDamageTakenPerHit = 579,
  MaxSpeed = 580,
  MaxStacks = 581,
  MaxStacksBonusBleeding = 582,
  MaxStacksBonusBurning = 583,
  MaximumRange = 584,
  MechanicalsBuffDPSBonus = 585,
  MeleeAttackDuration = 586,
  Memory = 587,
  MemoryCostModifier = 588,
  MemoryCostReduction = 589,
  MemoryInCombatRegenDelayOnChange = 590,
  MemoryInCombatRegenEnabled = 591,
  MemoryInCombatRegenEndThreshold = 592,
  MemoryInCombatRegenRate = 593,
  MemoryInCombatRegenRateAdd = 594,
  MemoryInCombatRegenRateBase = 595,
  MemoryInCombatRegenRateMult = 596,
  MemoryInCombatRegenStartThreshold = 597,
  MemoryInCombatStartDelay = 598,
  MemoryOutOfCombatRegenDelayOnChange = 599,
  MemoryOutOfCombatRegenEnabled = 600,
  MemoryOutOfCombatRegenEndThreshold = 601,
  MemoryOutOfCombatRegenRate = 602,
  MemoryOutOfCombatRegenRateAdd = 603,
  MemoryOutOfCombatRegenRateBase = 604,
  MemoryOutOfCombatRegenRateMult = 605,
  MemoryOutOfCombatRegenStartThreshold = 606,
  MemoryOutOfCombatStartDelay = 607,
  MemoryTrackerCooldownDuration = 608,
  MemoryWipeImmunity = 609,
  MinSpeed = 610,
  MinigameBufferExtension = 611,
  MinigameMaterialsEarned = 612,
  MinigameMemoryRegenPerk = 613,
  MinigameMoneyMultiplier = 614,
  MinigameNextInstanceBufferExtensionPerk = 615,
  MinigameShardChanceMultiplier = 616,
  MinigameTimeLimitExtension = 617,
  MinigameTrapsPossibilityChance = 618,
  NPCAnimationTime = 619,
  NPCCorpoEquipItemDuration = 620,
  NPCCorpoUnequipItemDuration = 621,
  NPCDamage = 622,
  NPCEquipItemDuration = 623,
  NPCGangEquipItemDuration = 624,
  NPCGangUnequipItemDuration = 625,
  NPCLoopDuration = 626,
  NPCRecoverDuration = 627,
  NPCStartupDuration = 628,
  NPCUnequipItemDuration = 629,
  NPCUploadTime = 630,
  NoJam = 631,
  NumShotsInBurst = 632,
  NumShotsInBurstMaxCharge = 633,
  NumShotsInBurstSecondary = 634,
  NumShotsToFire = 635,
  NumberIgnoredTraps = 636,
  Overheat = 637,
  Oxygen = 638,
  PartArmor = 639,
  PenetrationHealth = 640,
  PersonalityAggressive = 641,
  PersonalityCuriosity = 642,
  PersonalityDisgust = 643,
  PersonalityFear = 644,
  PersonalityFunny = 645,
  PersonalityJoy = 646,
  PersonalitySad = 647,
  PersonalityShock = 648,
  PersonalitySurprise = 649,
  PhoneCallDuration = 650,
  PhysicalDamage = 651,
  PhysicalDamageMax = 652,
  PhysicalDamageMin = 653,
  PhysicalDamagePercent = 654,
  PhysicalImpulse = 655,
  PhysicalResistance = 656,
  PoisonImmunity = 657,
  PoisonRegenHealth = 658,
  PoisonedApplicationRate = 659,
  PowerLevel = 660,
  PreFireTime = 661,
  PrefersCovers = 662,
  PrefersShootingSpots = 663,
  Price = 664,
  ProjectilesPerShot = 665,
  ProjectilesPerShotBase = 666,
  ProjectilesPerShotBonus = 667,
  Quality = 668,
  Quantity = 669,
  QuickHackDuration = 670,
  QuickHackDurationExtension = 671,
  QuickHackImmunity = 672,
  QuickHackResistancesMod = 673,
  QuickHackSpreadDistance = 674,
  QuickHackSpreadNumber = 675,
  QuickHackSuddenDeathChance = 676,
  QuickHackUpload = 677,
  QuickhackExtraDamageMultiplier = 678,
  QuickhackShield = 679,
  QuickhacksCooldownReduction = 680,
  RandomCurveInput = 681,
  Range = 682,
  Recoil = 683,
  RecoilAllowSway = 684,
  RecoilAlternateDir = 685,
  RecoilAlternateDirADS = 686,
  RecoilAngle = 687,
  RecoilAngleADS = 688,
  RecoilAnimation = 689,
  RecoilChargeMult = 690,
  RecoilChargeMultADS = 691,
  RecoilCycleSize = 692,
  RecoilCycleSizeADS = 693,
  RecoilCycleTime = 694,
  RecoilCycleTimeADS = 695,
  RecoilDelay = 696,
  RecoilDir = 697,
  RecoilDirADS = 698,
  RecoilDirPlanCycleRandDir = 699,
  RecoilDirPlanCycleRandDirADS = 700,
  RecoilDirPlanCycleRandRangeDir = 701,
  RecoilDirPlanCycleRandRangeDirADS = 702,
  RecoilDirPlanSequence = 703,
  RecoilDirPlanSequenceADS = 704,
  RecoilDriftRandomRangeMax = 705,
  RecoilDriftRandomRangeMin = 706,
  RecoilEnableCycleX = 707,
  RecoilEnableCycleXADS = 708,
  RecoilEnableCycleY = 709,
  RecoilEnableCycleYADS = 710,
  RecoilEnableLinearX = 711,
  RecoilEnableLinearXADS = 712,
  RecoilEnableLinearY = 713,
  RecoilEnableLinearYADS = 714,
  RecoilEnableScaleX = 715,
  RecoilEnableScaleXADS = 716,
  RecoilEnableScaleY = 717,
  RecoilEnableScaleYADS = 718,
  RecoilFullChargeMult = 719,
  RecoilFullChargeMultADS = 720,
  RecoilHoldDuration = 721,
  RecoilHoldDurationADS = 722,
  RecoilKickMax = 723,
  RecoilKickMaxADS = 724,
  RecoilKickMin = 725,
  RecoilKickMinADS = 726,
  RecoilMagForFullDrift = 727,
  RecoilMaxLength = 728,
  RecoilMaxLengthADS = 729,
  RecoilRecoveryMinSpeed = 730,
  RecoilRecoveryMinSpeedADS = 731,
  RecoilRecoverySpeed = 732,
  RecoilRecoverySpeedADS = 733,
  RecoilRecoveryTime = 734,
  RecoilRecoveryTimeADS = 735,
  RecoilScaleMax = 736,
  RecoilScaleMaxADS = 737,
  RecoilScaleTime = 738,
  RecoilScaleTimeADS = 739,
  RecoilSpeed = 740,
  RecoilSpeedADS = 741,
  RecoilTime = 742,
  RecoilTimeADS = 743,
  RecoilUseDifferentStatsInADS = 744,
  Reflexes = 745,
  RefreshesPingOnQuickhack = 746,
  RegenerateHPMinigamePerk = 747,
  ReloadAmount = 748,
  ReloadEndTime = 749,
  ReloadTime = 750,
  ReloadTimeBase = 751,
  ReloadTimeBonus = 752,
  RemoveAllStacksWhenDurationEnds = 753,
  RemoveColdBloodStacksOneByOne = 754,
  RemoveSprintOnQuickhack = 755,
  ReprimandEscalation = 756,
  RestoreMemoryOnDefeat = 757,
  RevealNetrunnerWhenHacked = 758,
  RicochetChance = 759,
  RicochetCount = 760,
  RicochetMaxAngle = 761,
  RicochetMinAngle = 762,
  RicochetTargetSearchAngle = 763,
  SandevistanDashShoot = 764,
  ScanDepth = 765,
  ScanTimeReduction = 766,
  ScopeFOV = 767,
  ScopeOffset = 768,
  ScrapItemChance = 769,
  SharedCacheTraps = 770,
  ShootingOffsetAI = 771,
  ShortCircuitOnCriticalHit = 772,
  ShorterChains = 773,
  ShotDelay = 774,
  SlideWhenLeaningOutOfCover = 775,
  SmartGunAddSpiralTrajectory = 776,
  SmartGunAdsLockingAnglePitch = 777,
  SmartGunAdsLockingAngleYaw = 778,
  SmartGunAdsMaxLockedTargets = 779,
  SmartGunAdsTagLockAnglePitch = 780,
  SmartGunAdsTagLockAngleYaw = 781,
  SmartGunAdsTargetableAnglePitch = 782,
  SmartGunAdsTargetableAngleYaw = 783,
  SmartGunAdsTimeToLock = 784,
  SmartGunAdsTimeToUnlock = 785,
  SmartGunEvenDistributionPeriod = 786,
  SmartGunHipLockingAnglePitch = 787,
  SmartGunHipLockingAngleYaw = 788,
  SmartGunHipMaxLockedTargets = 789,
  SmartGunHipTagLockAnglePitch = 790,
  SmartGunHipTagLockAngleYaw = 791,
  SmartGunHipTargetableAnglePitch = 792,
  SmartGunHipTargetableAngleYaw = 793,
  SmartGunHipTimeToLock = 794,
  SmartGunHipTimeToUnlock = 795,
  SmartGunHitProbability = 796,
  SmartGunHitProbabilityMultiplier = 797,
  SmartGunMissDelay = 798,
  SmartGunMissRadius = 799,
  SmartGunNPCApplySpreadAtHitplane = 800,
  SmartGunNPCLockOnTime = 801,
  SmartGunNPCLockTimeout = 802,
  SmartGunNPCLockingAnglePitch = 803,
  SmartGunNPCLockingAngleYaw = 804,
  SmartGunNPCProjectileStartingOrientationAngleOffset = 805,
  SmartGunNPCProjectileVelocity = 806,
  SmartGunNPCShootProjectilesOnlyStraight = 807,
  SmartGunNPCSpreadMultiplier = 808,
  SmartGunNPCTrajectoryCurvatureMultiplier = 809,
  SmartGunPlayerProjectileVelocity = 810,
  SmartGunProjectileVelocityVariance = 811,
  SmartGunSpiralCycleTimeMax = 812,
  SmartGunSpiralCycleTimeMin = 813,
  SmartGunSpiralRadius = 814,
  SmartGunSpiralRampDistanceEnd = 815,
  SmartGunSpiralRampDistanceStart = 816,
  SmartGunSpiralRandomizeDirection = 817,
  SmartGunSpreadMultiplier = 818,
  SmartGunStartingAccuracy = 819,
  SmartGunTargetAcquisitionRange = 820,
  SmartGunTimeToMaxAccuracy = 821,
  SmartGunTimeToRemoveOccludedTarget = 822,
  SmartGunTrackAllBodyparts = 823,
  SmartGunTrackHeadComponents = 824,
  SmartGunTrackLegComponents = 825,
  SmartGunTrackMechanicalComponents = 826,
  SmartGunTrackMultipleEntitiesInADS = 827,
  SmartGunUseEvenDistributionTargeting = 828,
  SmartGunUseTagLockTargeting = 829,
  SmartGunUseTimeBasedAccuracy = 830,
  SmartTargetingDisruptionProbability = 831,
  SpecialDamage = 832,
  SpeedBoost = 833,
  SpeedBoostMaxSpeed = 834,
  Spread = 835,
  SpreadAdsChangePerShot = 836,
  SpreadAdsChargeMult = 837,
  SpreadAdsDefaultX = 838,
  SpreadAdsDefaultY = 839,
  SpreadAdsFastSpeedMax = 840,
  SpreadAdsFastSpeedMaxAdd = 841,
  SpreadAdsFastSpeedMin = 842,
  SpreadAdsFastSpeedMinAdd = 843,
  SpreadAdsFullChargeMult = 844,
  SpreadAdsMaxX = 845,
  SpreadAdsMaxY = 846,
  SpreadAdsMinX = 847,
  SpreadAdsMinY = 848,
  SpreadAnimation = 849,
  SpreadChangePerShot = 850,
  SpreadChargeMult = 851,
  SpreadCrouchDefaultMult = 852,
  SpreadCrouchMaxMult = 853,
  SpreadDefaultX = 854,
  SpreadDefaultY = 855,
  SpreadEvenDistributionJitterSize = 856,
  SpreadEvenDistributionRowCount = 857,
  SpreadFastSpeedMax = 858,
  SpreadFastSpeedMaxAdd = 859,
  SpreadFastSpeedMin = 860,
  SpreadFastSpeedMinAdd = 861,
  SpreadFullChargeMult = 862,
  SpreadMaxAI = 863,
  SpreadMaxX = 864,
  SpreadMaxY = 865,
  SpreadMinX = 866,
  SpreadMinY = 867,
  SpreadRandomizeOriginPoint = 868,
  SpreadResetSpeed = 869,
  SpreadResetTimeThreshold = 870,
  SpreadUseCircularSpread = 871,
  SpreadUseEvenDistribution = 872,
  SpreadUseInAds = 873,
  SpreadZeroOnFirstShot = 874,
  StaggerDamageThreshold = 875,
  StaggerDamageThresholdImpulse = 876,
  StaggerDamageThresholdInCover = 877,
  Stamina = 878,
  StaminaCostReduction = 879,
  StaminaCostToBlock = 880,
  StaminaDamage = 881,
  StaminaRegenDelayOnChange = 882,
  StaminaRegenEnabled = 883,
  StaminaRegenEndThrehold = 884,
  StaminaRegenRate = 885,
  StaminaRegenRateAdd = 886,
  StaminaRegenRateBase = 887,
  StaminaRegenRateMult = 888,
  StaminaRegenStartDelay = 889,
  StaminaRegenStartThreshold = 890,
  StaminaSprintDecayRate = 891,
  StatModifierGroupLimit = 892,
  Stealth = 893,
  StealthHacksCostReduction = 894,
  StealthHitDamageMultiplier = 895,
  StealthMastery = 896,
  StealthTrait01Stat = 897,
  StealthWeakspotDamageMultiplier = 898,
  StreetCred = 899,
  Strength = 900,
  StunImmunity = 901,
  Sway = 902,
  SwayCenterMaximumAngleOffset = 903,
  SwayCurvatureMaximumFactor = 904,
  SwayCurvatureMinimumFactor = 905,
  SwayInitialOffsetRandomFactor = 906,
  SwayResetOnAimStart = 907,
  SwaySideBottomAngleLimit = 908,
  SwaySideMaximumAngleDistance = 909,
  SwaySideMinimumAngleDistance = 910,
  SwaySideStepChangeMaximumFactor = 911,
  SwaySideStepChangeMinimumFactor = 912,
  SwaySideTopAngleLimit = 913,
  SwayStartBlendTime = 914,
  SwayStartDelay = 915,
  SwayTraversalTime = 916,
  SystemCollapseImmunity = 917,
  TBHsBaseCoefficient = 918,
  TBHsBaseSourceMultiplierCoefficient = 919,
  TBHsCoverTraceLoSIncreaseSpeed = 920,
  TBHsMinimumLineOfSightTime = 921,
  TBHsSensesTraceLoSIncreaseSpeed = 922,
  TBHsVisibilityCooldown = 923,
  TechBaseChargeThreshold = 924,
  TechMaxChargeThreshold = 925,
  TechOverChargeThreshold = 926,
  TechPierceChargeLevel = 927,
  TechPierceEnabled = 928,
  TechnicalAbility = 929,
  ThermalDamage = 930,
  ThermalDamageMax = 931,
  ThermalDamageMin = 932,
  ThermalDamagePercent = 933,
  ThermalResistance = 934,
  ThreeOrMoreProgramsCooldownRedPerk = 935,
  ThreeOrMoreProgramsMemoryRegPerk = 936,
  TimeDilationGenericDuration = 937,
  TimeDilationGenericTimeScale = 938,
  TimeDilationKerenzikovDuration = 939,
  TimeDilationKerenzikovPlayerTimeScale = 940,
  TimeDilationKerenzikovTimeScale = 941,
  TimeDilationOnDodgesCooldownDuration = 942,
  TimeDilationOnDodgesDuration = 943,
  TimeDilationOnDodgesTimeScale = 944,
  TimeDilationOnHealthDropCooldownDuration = 945,
  TimeDilationOnHealthDropDuration = 946,
  TimeDilationOnHealthDropTimeScale = 947,
  TimeDilationSandevistanCooldownBase = 948,
  TimeDilationSandevistanCooldownReduction = 949,
  TimeDilationSandevistanDuration = 950,
  TimeDilationSandevistanTimeScale = 951,
  TimeDilationWhenEnteringCombatCooldownDuration = 952,
  TimeDilationWhenEnteringCombatDuration = 953,
  TimeDilationWhenEnteringCombatTimeScale = 954,
  TranquilizerImmunity = 955,
  TriggerDismembermentChance = 956,
  TriggerWoundedChance = 957,
  TurretFriendlyExtension = 958,
  TurretShutdownExtension = 959,
  UltimateHackSpread = 960,
  UltimateHacksCostReduction = 961,
  UltimateMemoryCostReduction = 962,
  UnconsciousImmunity = 963,
  UnequipAnimationDuration_Corpo = 964,
  UnequipAnimationDuration_Gang = 965,
  UnequipDuration = 966,
  UnequipDuration_Corpo = 967,
  UnequipDuration_Gang = 968,
  UnequipItemTime_Corpo = 969,
  UnequipItemTime_Gang = 970,
  UnlockProgress = 971,
  UpgradingCostReduction = 972,
  UpgradingMaterialDropChance = 973,
  UpgradingMaterialRandomGrantChance = 974,
  UpgradingMaterialRetrieveChance = 975,
  UploadQuickHackMod = 976,
  Visibility = 977,
  VisualStimRangeMultiplier = 978,
  VulnerabilityExtension = 979,
  WallRunHorSpeedToEnterMin = 980,
  WallRunStrafeAngleMax = 981,
  WallRunTimeMax = 982,
  WallRunVertSpeedToEnterMax = 983,
  WasItemUpgraded = 984,
  WasQuickHacked = 985,
  WeakspotDamageMultiplier = 986,
  WeaponHasAutoloader = 987,
  WeaponNoise = 988,
  WeaponPosAdsX = 989,
  WeaponPosAdsY = 990,
  WeaponPosAdsZ = 991,
  WeaponPosX = 992,
  WeaponPosY = 993,
  WeaponPosZ = 994,
  WeaponRotAdsX = 995,
  WeaponRotAdsY = 996,
  WeaponRotAdsZ = 997,
  WeaponRotX = 998,
  WeaponRotY = 999,
  WeaponRotZ = 1000,
  Weight = 1001,
  WoundHeadDamageThreshold = 1002,
  WoundLArmDamageThreshold = 1003,
  WoundLLegDamageThreshold = 1004,
  WoundRArmDamageThreshold = 1005,
  WoundRLegDamageThreshold = 1006,
  ZoomLevel = 1007,
  CPO_Armor = 1008,
  CPO_NPC_Importance = 1009,
  Count = 1010,
  Invalid = 1011,
}

public enum gamedataTweakDBType {
  Invalid = 0,
  ForeignKey = 1,
  Int = 2,
  Float = 3,
  Bool = 4,
  String = 5,
  CName = 6,
  ResRef = 7,
  LocKey = 8,
  Color = 9,
  Vector2 = 10,
  Vector3 = 11,
  EulerAngles = 12,
  Quaternion = 13,
}

public abstract native class gamedataValueDataNode extends gamedataDataNode {}

public native class gamedataValueNode extends gamedataDataNode {
  public native let data: ref<gamedataValueDataNode>;
  public native let group: ref<gamedataGroupNode>;
}

public native class gamedataVariableNode extends gamedataDataNode {
  public native let hashedName: CName;
  public native let type: String;
  public native let name: String;
  public native let isForeignKey: Bool;
  public native let isArray: Bool;
  public native let hasArrayValues: Bool;
  public native let isAddition: Bool;
  public native let typeEnum: gamedataTweakDBType;
  public native let values: array<gamedataVariableNodeVariableValue>;
}

public native struct gamedataVariableNodeVariableValue {
  public native let node: ref<gamedataValueNode>;
  public native let deriveInfo: gamedataVariableNodeVariableValueDeriveInfo;
}

public enum gamedataVariableNodeVariableValueDeriveInfo {
  NotDerived = 0,
  ArrayAddition = 1,
}

public native class gameDebugCheatsSharedState extends gameIGameSystemReplicatedState {
  public native let activeCheats: array<gamecheatsystemObjCheats>;
  public native let debugTimeDilationIndex: Uint32;
  public native let debugTimeDilationPlayerIndex: Uint32;
}

public native struct gameDebugContextPtr {}

public native struct gameDebugContextUserData {}

public native class gameDebugDrawHistorySystem extends IDebugDrawHistorySystem {}

public native class gamedebugFailure extends ISerializable {
  public native let id: gamedebugFailureId;
  public native let time: Float;
  public native let message: String;
  public native let path: gameDebugPath;
  public native let previous: ref<gamedebugFailure>;
  public native let cause: ref<gamedebugFailure>;
}

public native struct gamedebugFailureId {
  public native let threadId: Uint32;
  public native let unsignedId: Uint32;
}

public native class gameDebugFreeCamera extends GameObject {}

public native struct gameDebugPath {
  public native let str: String;
}

public native class gameDebugPerformanceSystem extends IGameSystem {}

public native class gameDebugTimeState extends gameITimeState {}

@neverRef()
public native class gameDefaultAppearancePreset_Entity extends ISerializable {
  public native let entityPathHash: Uint64;
  public native let debugEntityPath: CName;
  public native let defaultAppearanceName: CName;
}

public enum gameDelayContext {
  Standard_TD = 1,
  Standard_ND = 2,
  Quest_TD = 4,
  SpawnManager_ND = 8,
}

public native class gameDelayedFunctionsScheduler extends ISerializable {
  public native persistent let initialized: Bool;
  public native persistent let currentTime: EngineTime;
  public native persistent let nextCallId: Uint32;
}

public native class gameDelayedTimer extends gameBaseTimer {}

public abstract native class gameDelaySystemCallbackInfo extends gameDelaySystemDelayStruct {}

public abstract native class gameDelaySystemDelayStruct extends ISerializable {}

public abstract native class gameDelaySystemEventStruct extends gameDelaySystemDelayStruct {}

public abstract native class gameDelaySystemPSEventStruct extends gameDelaySystemDelayStruct {}

public abstract native class gameDelaySystemScriptableSysRequestStruct extends gameDelaySystemDelayStruct {}

public abstract native class gameDelaySystemTickOnEventStruct extends gameDelaySystemTickStruct {}

public abstract native class gameDelaySystemTickStruct extends ISerializable {}

public abstract native class gameDelaySystemTickWithCallbackStruct extends gameDelaySystemTickStruct {}

public native class gameDependentWorkspotData extends ISerializable {}

public native class gameDeprecated_GameplayEvent extends Event {}

public native class gameDestructibleObject extends GameObject {
  public native let recordID: TweakDBID;
}

public native class gameDeviceLoaded extends Event {}

public native class gameDeviceResource extends CResource {
  public native let data: ref<gameDeviceResourceData>;
}

public native class gameDeviceResourceData extends ISerializable {
  public native let version: Uint32;
}

public native struct gameDynamicEntityHandler {}

public native class gameDynamicEntityIDSystem extends gameIDynamicEntityIDSystem {}

public native class gameDynamicEventNode extends worldAreaShapeNode {
  public native let mappinRef: NodeRef;
  public native let condition: ref<questIBaseCondition>;
}

public native class gameDynamicEventNodeInstance extends worldAreaShapeNodeInstance {}

public enum gameEActionFlags {
  NONE = 0,
  USE_ANIMATION = 1,
  USE_MOVEMENT = 2,
}

public enum gameEAreaShape {
  NONE = 0,
  SPHERE = 1,
  CUBE = 2,
  COUNT = 3,
}

public enum gameEAreaType {
  NONE = 0,
  LOCATION = 1,
  AFFILIATION = 2,
  COUNT = 3,
}

public enum gameECharacterStance {
  Stance_Stand = 0,
  Stance_Crouch = 1,
  Stance_Kneel = 2,
  Stance_Cover = 3,
  Stance_Standing_Cover = 4,
  Stance_Crouching_Cover = 5,
}

public native class gameEffectAction_ChildEffectsMovingInCone extends EffectPostAction {
  public native let effectsCount: Uint32;
  public native let effectTagInThisFile: CName;
  public native let coneAngle: Float;
  public native let minEffectDuration: Float;
  public native let maxEffectDuration: Float;
  public native let twoDimensional: Bool;
  public native let smoothInterpolations: Bool;
}

public native class gameEffectAction_KillFX extends EffectAction {
  public native let action: gameEffectAction_KillFXAction;
  public native let effectTag: CName;
}

public enum gameEffectAction_KillFXAction {
  Stop = 0,
  BreakLoop = 1,
}

public native class gameEffectAction_MissEvent extends EffectAction {
  public native let npcMissEvents: Bool;
}

public native class gameEffectAction_NewEffect_ReverseFromLastHit extends EffectPostAction {
  public native let tagInThisFile: CName;
  public native let forwardOffset: Float;
  public native let childEffect: Bool;
  public native let childEffectTag: CName;
}

public native class gameEffectAction_NewEffect_Ricochet extends EffectPostAction {
  public native let tagInThisFile: CName;
  public native let forwardOffset: Float;
  public native let childEffect: Bool;
  public native let childEffectTag: CName;
}

public native class gameEffectAction_NewEffect_SpreadingEffect extends EffectPostAction {
  public native let tagInThisFile: CName;
  public native let forwardOffset: Float;
  public native let childEffect: Bool;
  public native let childEffectTag: CName;
}

public native class gameEffectAction_TerminateChildEffect extends EffectAction {
  public native let effectTag: CName;
}

public native class gameEffectAttachment extends entIAttachment {}

public native class gameEffectComponentBinding extends entISourceBinding {}

public native struct gameEffectData_MeleeTireHit {}

public native struct gameEffectData_MeleeWaterFx {}

public native struct gameEffectData_Pierce {}

public native struct gameEffectData_PiercePreview {}

public native struct gameEffectData_Splatter {}

public native struct gameEffectData_SplatterList {}

public native struct gameEffectDebugSettings {
  public native let overrideGlobalSettings: Bool;
  public native let duration: Float;
  public native let color: Color;
}

public native struct gameEffectDefinition {
  public native let tag: CName;
  public native let objectProviders: array<ref<EffectObjectProvider>>;
  public native let objectFilters: array<ref<gameEffectObjectFilter>>;
  public native let effectExecutors: array<ref<EffectExecutor>>;
  public native let durationModifiers: array<ref<EffectDurationModifier>>;
  public native let preActions: array<ref<EffectPreAction>>;
  public native let postActions: array<ref<EffectPostAction>>;
  public native let noTargetsActions: array<ref<EffectAction>>;
  public native let settings: gameEffectSettings;
  public native let debugSettings: gameEffectDebugSettings;
}

public native class gameEffectDuration_Duration_Blackboard extends EffectDurationModifier {}

public native class gameEffectDuration_Infinite extends EffectDurationModifier {}

public native class gameEffectDuration_Instant extends EffectDurationModifier {}

public native class gameEffectDuration_PredefinedTimeout extends EffectDurationModifier {
  public native let timeToLive: Float;
}

public native class gameEffectExecutor_AnimFeature extends EffectExecutor {
  public native let key: CName;
  public native let animFeature: ref<AnimFeature>;
  public native let applyTo: gameEffectExecutor_AnimFeatureApplyTo;
  public native let ignoreWaterImpacts: Bool;
}

public enum gameEffectExecutor_AnimFeatureApplyTo {
  Target = 0,
  Instigator = 1,
}

public native class gameEffectExecutor_DamageProjection extends EffectExecutor {}

public native class gameEffectExecutor_Finisher extends EffectExecutor {
  public native let InfluencedByPlayerCostBlock: Bool;
  public native let finisherScenarios: array<ref<gameIFinisherScenario>>;
  public native let alwaysUseEntryAnims: Bool;
  public native let allowCameraMovement: Bool;
}

public native class gameEffectExecutor_GroundSlamEffects extends EffectExecutor {
  public native let groundEffect: ResourceAsyncRef; // raRef<worldEffect>
  public native let waterEffect: ResourceAsyncRef; // raRef<worldEffect>
  public native let earthquakeLevel1: ResourceAsyncRef; // raRef<worldEffect>
  public native let earthquakeLevel2: ResourceAsyncRef; // raRef<worldEffect>
  public native let earthquakeLevel1ChargeThreshold: Float;
  public native let earthquakeLevel2ChargeThreshold: Float;
}

public native class gameEffectExecutor_HitReaction extends EffectExecutor {
  public native let npcMissEvents: Bool;
}

public native struct gameEffectExecutor_KatanaBulletBendingEffectEntry {
  public native let tag: CName;
  public native let effect: ResourceAsyncRef; // raRef<worldEffect>
  public native let attach: Bool;
}

public native class gameEffectExecutor_LandingFX extends EffectExecutor {}

public native class gameEffectExecutor_NewEffect_CopyData extends gameEffectExecutor_NewEffect {}

public native class gameEffectExecutor_NewEffect_ReflectedVector extends EffectExecutor {}

public native class gameEffectExecutor_NewEffect_RicochetScan extends gameEffectExecutor_NewEffect {
  public native let box: Vector4;
  public native let isPreview: Bool;
  public native let onlyForPlayer: Bool;
}

public abstract native class gameEffectExecutor_NewEffect extends EffectExecutor {
  public native let tagInThisFile: CName;
  public native let forwardOffset: Float;
  public native let childEffect: Bool;
  public native let childEffectTag: CName;
}

public native class gameEffectExecutor_OverrideMaterial extends EffectExecutor {
  public native let material: ResourceRef; // rRef<IMaterial>
}

public native class gameEffectExecutor_PhysicalFractureField extends EffectExecutor {
  public native let fromHitPosition: Bool;
  public native let fieldParams: physicsFractureFieldParams;
  public native let fieldShape: physicsShapeType;
  public native let fieldDimensions: Vector3;
}

public native class gameEffectExecutor_PhysicalImpulseFromInstigator_Value extends EffectExecutor {
  public native let magnitude: Float;
  public native let forceUseHitPosition: Bool;
}

public native class gameEffectExecutor_PhysicalImpulseFromInstigator extends EffectExecutor {}

public native class gameEffectExecutor_RevealObject extends EffectExecutor {
  public native let reason: CName;
}

public native class gameEffectExecutor_SendStatusEffect extends EffectExecutor {}

public native class gameEffectExecutor_SendStimuli extends EffectExecutor {}

public native class gameEffectExecutor_TerminateGameEffect extends EffectExecutor {
  public native let onlyWithPlayerInstigator: Bool;
}

public native class gameEffectExecutor_TriggerDestruction extends EffectExecutor {}

public native class gameEffectExecutor_UpdateMeleeTireHit extends EffectExecutor {}

public native class gameEffectExecutor_VisualEffect extends EffectExecutor {
  public native let effect: ResourceAsyncRef; // raRef<worldEffect>
  public native let attached: Bool;
  public native let breakLoopOnDetach: Bool;
  public native let effectTag: CName;
  public native let vectorEvaluator: ref<gameEffectVectorEvaluator>;
}

public native class gameEffectExecutor_VisualEffectAtInstigator extends EffectExecutor {
  public native let effect: ResourceAsyncRef; // raRef<worldEffect>
}

public native class gameEffectFilter_NotObstructed extends EffectObjectSingleFilter {
  public native let forwardOffset: Float;
  public native let filterData: ref<physicsFilterData>;
  public native let queryPreset: QueryPreset;
  public native let playerUseCameraPositionForCheck: Bool;
}

public native class gameEffectFilter_ReachableByAcousticGraph extends EffectObjectSingleFilter {
  public native let maxPathLength: EffectInputParameter_Float;
}

public native class gameEffectFilter_ReachableByNavigation extends EffectObjectSingleFilter {
  public native let maxPathLength: EffectInputParameter_Float;
}

public enum gameEffectHitDataType {
  Entity = 0,
  Node = 1,
  Static = 2,
}

public native struct gameEffectNearlyHitAgentData {
  public native let hitPosition: Vector4;
  public native let hitDirection: Vector4;
  public native let entity: wref<Entity>;
  public native let isPlayer: Bool;
  public native let wasHit: Bool;
}

public native class gameEffectObjectFilter_AxisRange extends EffectObjectSingleFilter {
  public native let axis: gameEffectObjectFilter_AxisRangeAxis;
  public native let position: EffectInputParameter_Vector;
  public native let constraints: EffectInputParameter_Vector;
}

public enum gameEffectObjectFilter_AxisRangeAxis {
  X = 0,
  Y = 1,
  Z = 2,
}

public native class gameEffectObjectFilter_BlockingGeometry extends gameEffectObjectGroupFilter {
  public native let inclusive: Bool;
  public native let sortQueryResultsByDistance: Bool;
}

public native class gameEffectObjectFilter_Cone extends EffectObjectSingleFilter {}

public native class gameEffectObjectFilter_DistanceFromRoot extends gameEffectObjectGroupFilter {
  public native let rootZOffset: Float;
  public native let bonusRange: Float;
}

public native class gameEffectObjectFilter_EntityType extends gameEffectObjectGroupFilter {
  public native let typeFilter: gameEffectObjectFilter_EntityTypeEntityTypeFilter;
}

public enum gameEffectObjectFilter_EntityTypeEntityTypeFilter {
  Puppet = 0,
  Device = 1,
}

public native class gameEffectObjectFilter_HitRepresentation_Capsule extends gameEffectObjectFilter_HitRepresentation {
  public native let flattenCapsuleToHeight: Bool;
}

public native class gameEffectObjectFilter_HitRepresentation_Quickhack extends gameEffectObjectFilter_HitRepresentation {}

public native class gameEffectObjectFilter_HitRepresentation_Raycast extends gameEffectObjectFilter_HitRepresentation {
  public native let isPreview: Bool;
  public native let fillNearlyHitData: Bool;
}

public native class gameEffectObjectFilter_HitRepresentation_Sphere extends gameEffectObjectFilter_HitRepresentation {}

public native class gameEffectObjectFilter_HitRepresentation_Sweep_Box extends gameEffectObjectFilter_HitRepresentation {}

public native class gameEffectObjectFilter_HitRepresentation_SweepOverTime_Box extends gameEffectObjectFilter_HitRepresentation {}

public abstract native class gameEffectObjectFilter_HitRepresentation extends gameEffectObjectGroupFilter {}

public native class gameEffectObjectFilter_HitType extends EffectObjectSingleFilter {
  public native let action: gameEffectObjectFilter_HitTypeAction;
  public native let hitType: gameEffectHitDataType;
}

public enum gameEffectObjectFilter_HitTypeAction {
  Accept = 0,
  Reject = 1,
}

public native class gameEffectObjectFilter_IgnoreMountedVehicle extends gameEffectObjectGroupFilter {}

public native class gameEffectObjectFilter_NearestWeakspotIfAny extends gameEffectObjectGroupFilter {}

public native class gameEffectObjectFilter_NoDuplicates extends gameEffectObjectGroupFilter {}

public native class gameEffectObjectFilter_NoInstigator_MissEvent extends gameEffectObjectGroupFilter {
  public native let npcMissEvents: Bool;
}

public native class gameEffectObjectFilter_NoInstigator extends gameEffectObjectGroupFilter {}

public native class gameEffectObjectFilter_NoInstigatorIfPlayerControlled extends EffectObjectSingleFilter {}

public native class gameEffectObjectFilter_NoPlayer extends gameEffectObjectGroupFilter {}

public native class gameEffectObjectFilter_NoPuppet extends gameEffectObjectGroupFilter {}

public native class gameEffectObjectFilter_NoSource extends gameEffectObjectGroupFilter {}

public native class gameEffectObjectFilter_NotAlive extends gameEffectObjectGroupFilter {}

public native class gameEffectObjectFilter_NotObstructed extends gameEffectObjectGroupFilter {
  public native let filterData: ref<physicsFilterData>;
  public native let queryPreset: QueryPreset;
}

public native class gameEffectObjectFilter_NoWeapon extends gameEffectObjectGroupFilter {}

public native class gameEffectObjectFilter_OnlyNearest_BB extends gameEffectObjectFilter_OnlyNearest {
  public native let parameter: EffectInputParameter_Int;
}

public native class gameEffectObjectFilter_OnlyNearest_Pierce extends gameEffectObjectFilter_OnlyNearest {
  public native let alwaysApplyFullWeaponCharge: Bool;
  public native let includePierced: Bool;
}

public native class gameEffectObjectFilter_OnlyNearestMelee extends gameEffectObjectGroupFilter {
  public native let count: Uint32;
}

public native class gameEffectObjectFilter_PlayerIgnoreFriendlyAndAlive extends gameEffectObjectGroupFilter {
  public native let ignoreCharacterRecord: TweakDBID;
}

public native class gameEffectObjectFilter_RejectOnPrereq extends EffectObjectSingleFilter {
  public native let prereq: ref<IPrereq>;
}

public native class gameEffectObjectFilter_TechPreview extends gameEffectObjectGroupFilter {}

public native class gameEffectObjectFilter_Unique extends gameEffectObjectGroupFilter {}

public native class gameEffectObjectGroupFilter_Cone extends gameEffectObjectGroupFilter {}

public native class gameEffectObjectProvider_Explosion extends EffectObjectProvider {
  public native let puppets: Bool;
  public native let gameObjects: Bool;
  public native let destructibleAndDynamic: Bool;
}

public native class gameEffectObjectProvider_Laser extends gameEffectObjectProvider_PhysicalRay {
  public native let inputTracesPerSecond: Uint32;
  public native let inputRayOffset: Vector4;
}

public native class gameEffectObjectProvider_PhysicalRay extends EffectObjectProvider {
  public native let inputPosition: EffectInputParameter_Vector;
  public native let inputForward: EffectInputParameter_Vector;
  public native let inputRange: EffectInputParameter_Float;
  public native let outputRaycastEnd: EffectOutputParameter_Vector;
  public native let filterData: ref<physicsFilterData>;
  public native let queryPreset: QueryPreset;
}

public native class gameEffectObjectProvider_PhysicalRayFan extends gameEffectObjectProvider_PhysicalRay {
  public native let inputMinRayAngleDiff: EffectInputParameter_Float;
}

public native class gameEffectObjectProvider_ProjectileHitEvent extends EffectObjectProvider {}

public native class gameEffectObjectProvider_QueryBox extends EffectObjectProvider {
  public native let filterData: ref<physicsFilterData>;
  public native let queryPreset: QueryPreset;
  public native let inputPosition: EffectInputParameter_Vector;
}

public native class gameEffectObjectProvider_QueryCapsule_GrowOverTime extends gameEffectObjectProvider_QueryCapsule {}

public native class gameEffectObjectProvider_QueryCapsule extends EffectObjectProvider {
  public native let gatherOnlyPuppets: Bool;
  public native let queryPreset: QueryPreset;
}

public native class gameEffectObjectProvider_QueryShockwave extends gameEffectObjectProvider_QuerySphere {}

public native class gameEffectObjectProvider_QuerySphere_GrowOverTime extends gameEffectObjectProvider_QuerySphere {}

public native class gameEffectObjectProvider_QuerySphere_Value extends EffectObjectProvider {
  public native let radius: Float;
  public native let filterData: ref<physicsFilterData>;
  public native let queryPreset: QueryPreset;
}

public native class gameEffectObjectProvider_QuerySphere extends EffectObjectProvider {
  public native let gatherOnlyPuppets: Bool;
  public native let filterData: ref<physicsFilterData>;
  public native let queryPreset: QueryPreset;
}

public native class gameEffectObjectProvider_SingleEntity extends EffectObjectProvider {}

public native class gameEffectObjectProvider_SingleRicochetTarget extends EffectObjectProvider {
  public native let filterData: ref<physicsFilterData>;
  public native let queryPreset: QueryPreset;
}

public native class gameEffectObjectProvider_Stimuli_EntitiesInRange extends EffectObjectProvider {}

public native class gameEffectObjectProvider_Sweep_Box extends EffectObjectProvider {
  public native let filterData: ref<physicsFilterData>;
  public native let queryPreset: QueryPreset;
}

public native class gameEffectObjectProvider_SweepMelee_Box extends gameEffectObjectProvider_SweepOverTime {
  public native let playerStaticDetectionConeDistance: Float;
  public native let playerStaticDetectionConeStartAngle: Float;
  public native let playerStaticDetectionConeEndAngle: Float;
  public native let playerUseCameraForObstructionChecks: Bool;
  public native let checkMeleeInvulnerability: Bool;
}

public native class gameEffectObjectProvider_SweepMelee_MantisBlades extends gameEffectObjectProvider_SweepMelee_Box {}

public native class gameEffectObjectProvider_SweepOverTime_Box extends gameEffectObjectProvider_SweepOverTime {}

public native class gameEffectObjectProvider_SweepOverTime_Capsule extends gameEffectObjectProvider_SweepOverTime {
  public native let radius: Float;
  public native let height: Float;
}

public native class gameEffectObjectProvider_SweepOverTime_Sphere extends gameEffectObjectProvider_SweepOverTime {
  public native let radius: Float;
}

public abstract native class gameEffectObjectProvider_SweepOverTime extends EffectObjectProvider {
  public native let filterData: ref<physicsFilterData>;
  public native let queryPreset: QueryPreset;
}

public native class gameEffectObjectProvider_TargetingObjectsInCone extends EffectObjectProvider {
  public native let filterData: ref<physicsFilterData>;
  public native let queryPreset: QueryPreset;
  public native let searchQuery: TargetSearchQuery;
  public native let maxTargets: Uint32;
  public native let usePlayerPosAndForward: Bool;
}

public native class gameEffectObjectSingleFilter_BlackboardBoolCondition extends EffectObjectSingleFilter {
  public native let parameter: EffectInputParameter_Bool;
  public native let filter: ref<EffectObjectSingleFilter>;
}

public native class gameEffectParameter_BoolEvaluator_Blackboard extends gameIEffectParameter_BoolEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
}

public native class gameEffectParameter_BoolEvaluator_Value extends gameIEffectParameter_BoolEvaluator {
  public native let value: Bool;
}

public native class gameEffectParameter_BoolEvaluator_ValueOrBlackboard extends gameIEffectParameter_BoolEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
  public native let value: Bool;
}

public native class gameEffectParameter_CNameEvaluator_Blackboard extends gameIEffectParameter_CNameEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
}

public native class gameEffectParameter_CNameEvaluator_Value extends gameIEffectParameter_CNameEvaluator {
  public native let value: CName;
}

public native class gameEffectParameter_CNameEvaluator_ValueOrBlackboard extends gameIEffectParameter_CNameEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
  public native let value: CName;
}

public native class gameEffectParameter_FloatEvaluator_Blackboard extends gameIEffectParameter_FloatEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
}

public native class gameEffectParameter_FloatEvaluator_Value extends gameIEffectParameter_FloatEvaluator {
  public native let value: Float;
}

public native class gameEffectParameter_FloatEvaluator_ValueOrBlackboard extends gameIEffectParameter_FloatEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
  public native let value: Float;
}

public native class gameEffectParameter_IntEvaluator_Blackboard extends gameIEffectParameter_IntEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
}

public native class gameEffectParameter_IntEvaluator_Value extends gameIEffectParameter_IntEvaluator {
  public native let value: Uint32;
}

public native class gameEffectParameter_IntEvaluator_ValueOrBlackboard extends gameIEffectParameter_IntEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
  public native let value: Uint32;
}

public native class gameEffectParameter_QuatEvaluator_Blackboard extends gameIEffectParameter_QuatEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
}

public native class gameEffectParameter_QuatEvaluator_Value extends gameIEffectParameter_QuatEvaluator {
  public native let value: Quaternion;
}

public native class gameEffectParameter_QuatEvaluator_ValueOrBlackboard extends gameIEffectParameter_QuatEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
  public native let value: Quaternion;
}

public native class gameEffectParameter_StringEvaluator_Blackboard extends gameIEffectParameter_StringEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
}

public native class gameEffectParameter_StringEvaluator_Value extends gameIEffectParameter_StringEvaluator {
  public native let value: String;
}

public native class gameEffectParameter_StringEvaluator_ValueOrBlackboard extends gameIEffectParameter_StringEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
  public native let value: String;
}

public native class gameEffectParameter_VectorEvaluator_Blackboard extends gameIEffectParameter_VectorEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
}

public native class gameEffectParameter_VectorEvaluator_Value extends gameIEffectParameter_VectorEvaluator {
  public native let value: Vector4;
}

public native class gameEffectParameter_VectorEvaluator_ValueOrBlackboard extends gameIEffectParameter_VectorEvaluator {
  public native let blackboardProperty: gameBlackboardPropertyBindingDefinition;
  public native let value: Vector4;
}

public native class gameEffectPostAction_Beam_RicochetPreview extends EffectPostAction {
  public native let ricocheted: gameEffectPostAction_Beam_RicochetPreviewPreviewEffect;
  public native let fromMuzzle: gameEffectPostAction_Beam_RicochetPreviewPreviewEffect;
}

public native struct gameEffectPostAction_Beam_RicochetPreviewPreviewEffect {
  public native let effect: ResourceAsyncRef; // raRef<worldEffect>
  public native let effectTag: CName;
  public native let effectSnap: ResourceAsyncRef; // raRef<worldEffect>
  public native let effectSnapTag: CName;
  public native let forwardOffset: Float;
}

public native class gameEffectPostAction_BeamVFX_Custom extends gameEffectPostAction_BeamVFX {
  public native let effect: ResourceAsyncRef; // raRef<worldEffect>
  public native let attached: Bool;
  public native let breakLoopOnDetach: Bool;
  public native let invert: Bool;
  public native let maxRange: Float;
  public native let maxRangeTPP: Float;
  public native let effectTag: CName;
}

public abstract native class gameEffectPostAction_BeamVFX extends EffectPostAction {}

public native class gameEffectPostAction_BulletExplode extends EffectPostAction {
  public native let endRangeTolerance: Float;
  public native let explosionDuration: Float;
}

public native class gameEffectPostAction_BulletTrace extends gameEffectPostAction_BeamVFX {}

public native class gameEffectPostAction_MeleeTireHit extends EffectPostAction {}

public native class gameEffectPostAction_MeleeWaterEffects extends EffectPostAction {}

public native class gameEffectPostAction_NewEffect_ChimeraMissileExplosion extends EffectPostAction {
  public native let tagInThisFile: CName;
  public native let overrideRadius: Float;
  public native let executeOnNthHit: Int32;
}

public native class gameEffectPostAction_ProcessNearlyHitAgents extends EffectPostAction {}

public native class gameEffectPostAction_UpdateActiveVehicleUIData extends EffectPostAction {}

public native class gameEffectPostAction_WaterImpulse extends EffectPostAction {}

public native class gameEffectPreAction_SpreadingEffect extends EffectPreAction {}

public native class gameEffectPreAction_VisualEffectAtPosition extends EffectPreAction {
  public native let effect: ResourceAsyncRef; // raRef<worldEffect>
  public native let attached: Bool;
  public native let breakLoopOnDetach: Bool;
  public native let vertical: Bool;
  public native let effectTag: CName;
}

public native class gameEffectSet extends CResource {
  public native let effects: array<gameEffectDefinition>;
}

public native struct gameEffectSettings {
  public native let advancedTargetHandling: Bool;
  public native let synchronousProcessingForPlayer: Bool;
  public native let forceSynchronousProcessing: Bool;
  public native let tempExecuteOnlyOnce: Bool;
  public native let tickRate: Float;
  public native let useSimTimeForTick: Bool;
}

public native class gameEffectSpawnerSaveSystem extends gameIEffectSpawnerSaveSystem {}

public native class gameEffectTriggerEffectDesc extends ISerializable {
  public native let effect: ResourceAsyncRef; // raRef<worldEffect>
  public native let positionType: gameEffectTriggerPositioningType;
  public native let rotationType: gameEffectTriggerRotationType;
  public native let offset: Vector3;
  public native let playFromHour: Uint32;
  public native let playTillHour: Uint32;
}

public native class gameEffectTriggerNode extends worldAreaShapeNode {
  public native let effectDescs: array<ref<gameEffectTriggerEffectDesc>>;
}

public native class gameEffectTriggerNodeInstance extends worldAreaShapeNodeInstance {}

public enum gameEffectTriggerPositioningType {
  PlayerRoot = 0,
  CameraRoot = 1,
  AtSpawn = 2,
  XYCameraZPlayer = 3,
  XYPlayerZCamera = 4,
  XYCameraZTerrain = 5,
  XYPlayerZTerrain = 6,
}

public enum gameEffectTriggerRotationType {
  None = 0,
  AtSpawn = 1,
  Continuous = 2,
}

public native class gameEffectTriggerSystem extends gameIEffectTriggerSystem {}

public native class gameEffectVectorEvaluator_HitDirection extends gameEffectVectorEvaluator {}

public native class gameEffectVectorEvaluator_HitNormal extends gameEffectVectorEvaluator {}

public abstract native class gameEffectVectorEvaluator extends ISerializable {
  public native let modifier: Float;
}

public enum gameEInventoryFlags {
  MustSave = 1,
}

public enum gameELootGenerationType {
  DropChance = 0,
  NumberBased = 1,
  Weights = 2,
  Count = 3,
}

public enum gameEMaterialZone {
  Zero = 0,
  One = 1,
  Two = 2,
  Three = 3,
}

public native class gameEnableScanningStatePropagationToParentEvent extends Event {
  public native let isEnabled: Bool;
}

@neverRef()
public native class gameEntityAppearanceColorVariantsArray extends ISerializable {
  public native let appearanceName: CName;
  public native let colorVariants: array<CName>;
}

public native struct gameEntityIDPool {}

public enum gameEntityReferenceType {
  EntityRef = 0,
  Tag = 1,
  SlotID = 2,
  SceneActorContextName = 3,
}

public enum gameEntityStubClass {
  Other = 0,
  Puppet = 1,
  Vehicle = 2,
}

public native class gameEntityStubComponent extends GameComponent {}

public native class gameEntityStubComponentPlacedProxy extends IPlacedComponent {}

public native class gameEntityStubSystem extends gameIEntityStubSystem {}

public native class gameEntityTemplateDefaultAppearancePreset extends ISerializable {
  public native let defaultAppearancePresets: array<gameDefaultAppearancePreset_Entity>;
}

public native class gameEntityTemplateToAppearancesAndColorVariantsMap extends ISerializable {
  public native let entries: array<gameEntityToAppearancesAndColorVariantsMapEntry>;
}

@neverRef()
public native class gameEntityToAppearancesAndColorVariantsMapEntry extends ISerializable {
  public native let entityPathHash: Uint64;
  public native let debugEntityPath: String;
  public native let appearancesAndTheirColorVariants: array<gameEntityAppearanceColorVariantsArray>;
}

public native class gameEnvironmentDamageReceiverBox extends gameEnvironmentDamageReceiverShape {
  public native let dimensions: Vector3;
}

public native class gameEnvironmentDamageReceiverCapsule extends gameEnvironmentDamageReceiverShape {
  public native let radius: Float;
  public native let height: Float;
}

public abstract native class gameEnvironmentDamageReceiverShape extends ISerializable {
  public native let transform: Transform;
}

public native class gameEnvironmentDamageSystem extends gameIEnvironmentDamageSystem {}

public native class gameEquippedPrereqListener extends AttachmentSlotsListener {}

public native struct gameEthnicityPicker {}

public native class gameeventsDeviceRegisterCameraControlOnPuppetEvent extends Event {
  public native let component: ref<DeviceCameraControlComponent>;
  public native let register: Bool;
}

public native class gameeventsMuppetUseLoadoutEvent extends Event {
  public native let adout: ref<CPOLoadoutBase_Record>;
}

public native class gameeventsObjectMarkerVisibilityUpdated extends Event {
  public native let canHaveObjectMarker: Bool;
  public native let isVisible: Bool;
}

public native class gameeventsRefreshVisibility extends Event {}

public native class gameeventsReloadLootEvent extends Event {}

public native class gameeventsSquadStartedCombatEvent extends Event {
  public native let started: Bool;
}

public native class gameeventsStealthMappinCheckLootEvent extends Event {}

public native class gameeventsToggleMinimapVisibilityEvent extends Event {
  public native let show: Bool;
}

public native class gameeventsToggleStealthMappinVisibilityEvent extends Event {
  public native let show: Bool;
}

public native class gameeventsUserEnteredCoverEvent extends Event {
  public native let actionsPoints: array<WorldTransform>;
}

public native class gameeventsUserLeftCoverEvent extends Event {}

public native class gameExistingWorkspotFinisherScenario extends gameIFinisherScenario {
  public native let playerWorkspot: ResourceAsyncRef; // raRef<workWorkspotResource>
  public native let syncAnimSlotName: CName;
  public native let playbackDelay: Float;
  public native let blendTime: Float;
}

public native class gameExtraStatPoolDataModifierStatListener extends gameStatPoolDataModifierStatListener {}

public native class gameFinalTimeState extends gameITimeState {}

public native struct gameFinisherSyncData {
  public native let syncAnimSlotName: CName;
  public native let effector: TweakDBID;
}

public native struct gameFlattenedLootData {
  public native let lootID: TweakDBID;
}

public native class gameFootstepEvent extends Event {}

public importonly class gameForceVisionModuleQuestEvent extends Event {
  public native let moduleName: CName;
  public native let meshComponentNames: array<CName>;
}

public native struct gameFppRepDetachedObjectInfo {
  public native let slotID: TweakDBID;
  public native let itemTDBID: TweakDBID;
}

public native class gameFreeCamera extends GameObject {
  public native let baseSpeed: Float;
  public native let analogTurnRate: Float;
  public native let mouseTurnRate: Float;
  public native let activationBlendTime: Float;
  public native let deactivationBlendTime: Float;
  public native let usePhysicalCollision: Bool;
}

public native struct gameFreeCameraLightSettings {
  public native let s: Vector3;
  public native let dius: Float;
  public native let tensity: Float;
  public native let mperature: Float;
  public native let lor: Vector4;
}

public native struct gameFreeCameraSettings {
  public native let movPrecision: Float;
  public native let rotPrecision: Float;
  public native let roll: Float;
  public native let fov: Float;
  public native let dofIntensity: Float;
  public native let dofNearBlur: Float;
  public native let dofNearFocus: Float;
  public native let dofFarBlur: Float;
  public native let dofFarFocus: Float;
  public native let iso: Int32;
  public native let shutter: Float;
  public native let aperture: Float;
  public native let lights: array<gameFreeCameraLightSettings>;
}

public native class gameFuncCallEntry extends ISerializable {
  public native persistent let callTime: EngineTime;
  public native persistent let callId: Uint32;
}

public enum gameGameplayEventFlag {
  Ai = 1,
  Trigger = 2,
  Component = 4,
  Script = 8,
}

public native class gameGameRulesSystem extends gameIGameRulesSystem {}

public native struct gameGameSessionDesc {}

public native struct gameGameTimeInterval {
  public native let begin: GameTime;
  public native let end: GameTime;
  public native let ignoreDays: Bool;
}

public native class gameGarmentItemObject extends ItemObject {}

public native struct gameGlobalTierSaveData {
  public native let subtype: gameGlobalTierSubtype;
  public native let data: ref<SceneTierData>;
}

public enum gameGlobalTierSubtype {
  Quest = 0,
  Supervisor = 1,
}

public native class gameGodModeSaveData extends ISerializable {
  public native let gods: array<gameGodModeSaveEntityData>;
}

public native struct gameGodModeSaveEntityData {
  public native let entityId: EntityID;
  public native let data: GodModeEntityData;
}

public native class gameGodModeSharedState extends gameIGameSystemReplicatedState {
  public native let datas: array<gameGodModeSharedStateData>;
}

public native struct gameGodModeSharedStateData {
  public native let entity: wref<Entity>;
  public native let flags: Int32;
}

public native class gameGOGRewardsSystem extends IOnlineSystem {}

public native class gamegraphCGraphResource extends CResource {}

public native class gamegraphCNode extends ISerializable {}

public native struct gameGrenadeThrowQuery {}

public native class gameHardcodedSignalPriorityDefinition extends gameSignalPriorityDefinition {
  public native let signals: array<CName>;
}

public native struct gameHitDetectionDebugFrameData {
  public native let t: Bool;
  public native let mponent: wref<HitRepresentationComponent>;
  public native let tTime: netTime;
  public native let apes: array<gameHitDetectionDebugFrameDataShapeEntry>;
}

public native struct gameHitDetectionDebugFrameDataShapeEntry {
  public native let ansformWS: WorldTransform;
}

public native struct gameHitRepresentationResult {
  public native let sult: HitRepresentationQueryResult;
  public native let tityID: EntityID;
}

public native struct gameHitRepresentationResults {
  public native let sults: array<gameHitRepresentationResult>;
}

public native class gameHitRepresentationSystem extends IHitRepresentationSystem {}

public native struct gameHitShapeBVH {
  public native let nodeName: CName;
  public native let childrenNodes: array<gameHitShapeBVH>;
  public native let childrenShapeNames: array<CName>;
}

public native class gameHumanoidBody extends IComponent {
  public native let basePersonalSpace: Float;
  public native let baseHeight: Float;
  public native let baseEyesHeightRatio: Float;
  public native let stanceAnimFeatureName: CName;
  public native let aimAnimFeatureName: CName;
}

public abstract native class gameIActionsFactory extends IGameSystem {}

public abstract native class gameIAIDirectorSystem extends IGameSystem {}

public abstract native class gameIAreaManager extends IGameSystem {}

public abstract native class gameIBreachSystem extends IGameSystem {}

public abstract native class gameICollisionQueriesSystem extends IGameSystem {}

public abstract native class gameIComponentsStateSystem extends IGameSystem {}

public abstract native class gameIDebugSystem extends IGameSystem {}

public abstract native class gameIDynamicEntityIDSystem extends IGameSystem {}

public abstract native struct gameIEffectInputParameter {}

public abstract native struct gameIEffectOutputParameter {}

public abstract native class gameIEffectParameter_BoolEvaluator extends ISerializable {}

public abstract native class gameIEffectParameter_CNameEvaluator extends ISerializable {}

public abstract native class gameIEffectParameter_FloatEvaluator extends ISerializable {}

public abstract native class gameIEffectParameter_IntEvaluator extends ISerializable {}

public abstract native class gameIEffectParameter_QuatEvaluator extends ISerializable {}

public abstract native class gameIEffectParameter_StringEvaluator extends ISerializable {}

public abstract native class gameIEffectParameter_VectorEvaluator extends ISerializable {}

public abstract importonly class gameIEffectSpawnerSaveSystem extends IGameSystem {}

public abstract native class gameIEffectTriggerSystem extends IGameSystem {}

public abstract native class gameIEntityStubSystem extends IGameSystem {}

public abstract native class gameIEnvironmentDamageSystem extends IGameSystem {}

public abstract native class gameIFinisherScenario extends ISerializable {}

public abstract native class gameIFootstepSystem extends IGameSystem {}

public abstract native class gameIGameSystemReplicatedState extends ISerializable {}

public abstract native class gameIItemFactorySystem extends IGameSystem {}

public native struct gameIMovingPlatformMovementInitData {
  public native let initType: gameMovingPlatformMovementInitializationType;
  public native let initValue: Float;
}

public native class gameImpostorComponent extends IComponent {
  public native let isCharacterReplica: Bool;
  public native let addHead: Bool;
  public native let ignorePlayerHeadSlot: Bool;
  public native let slotIDsToOmit: array<TweakDBID>;
}

public native class gameImpostorComponentAttachEvent extends Event {}

public native class gameImpostorComponentSlotListener extends AttachmentSlotsListener {}

public abstract native struct gameIMuppetInputAction {}

public enum gameinfluenceEBoundingBoxType {
  Colider = 0,
  Custom = 1,
}

public native class gameinteractionsAlwaysSamePredicate extends gameinteractionsIPredicateType {
  public native let priority: Float;
}

public enum gameinteractionsBumpType {
  Workspot = 0,
  Crowd = 1,
}

public native class gameinteractionsCAabbDefinition extends gameinteractionsIShapeDefinition {
  public native let min: Vector4;
  public native let max: Vector4;
}

public native class gameinteractionsCFunctorDefinition extends gameinteractionsIFunctorDefinition {
  public native let predicate: gameinteractionsCPredicateDefinition;
  public native let unaryOperator: gameinteractionsEUnaryOperator;
}

public native struct gameinteractionsChoiceLookAtDescriptor {
  public native let type: gameinteractionsChoiceLookAtType;
  public native let slotName: CName;
  public native let offset: Vector3;
  public native let orbId: gameinteractionsOrbID;
}

public enum gameinteractionsChoiceLookAtType {
  Root = 0,
  Slot = 1,
  Orb = 2,
}

public native class gameinteractionsCHotSpotAreaFilterDefinition extends gameinteractionsNodeDefinition {
  public native let slotName: CName;
  public native let transform: Transform;
  public native let functor: ref<gameinteractionsCFunctorDefinition>;
  public native let shapes: array<ref<gameinteractionsIShapeDefinition>>;
  public native let negativeShapes: array<ref<gameinteractionsIShapeDefinition>>;
}

public native struct gameinteractionsCHotSpotDefinition {
  public native let suppressor: Bool;
  public native let layersDefinition: array<ref<gameinteractionsCLinkedLayersDefinition>>;
}

public native class gameinteractionsCHotSpotGameLogicFilterDefinition extends ISerializable {
  public native let hotSpotPrereq: ref<IPrereq>;
  public native let activatorPrereq: ref<IPrereq>;
  public native let scriptedConditionClass: ref<InteractionScriptedCondition>;
}

public native class gameinteractionsCLinkedLayersDefinition extends gameinteractionsNodeDefinition {
  public native let layersDefinitions: array<ref<HotSpotLayerDefinition>>;
  public native let visualizerDefinition: ref<gameinteractionsvisIVisualizerDefinition>;
  public native let tag: CName;
}

public native class gameinteractionsConeDefinition extends gameinteractionsIShapeDefinition {
  public native let pos1: Vector4;
  public native let pos2: Vector4;
  public native let radius1: Float;
  public native let radius2: Float;
}

public native class gameinteractionsContainedInShapesPredicate extends gameinteractionsIPredicateType {
  public native let useCameraPosition: Bool;
}

public native class gameinteractionsCOrientedBoxDefinition extends gameinteractionsIShapeDefinition {
  public native let position: Vector4;
  public native let forward: Vector4;
  public native let right: Vector4;
  public native let up: Vector4;
}

public native struct gameinteractionsCPredicateDefinition {
  public native let predicateType: ref<gameinteractionsIPredicateType>;
  public native let binaryOperator: gameinteractionsEBinaryOperator;
  public native let functor1DataDefinition: ref<gameinteractionsCFunctorDefinition>;
  public native let functor2DataDefinition: ref<gameinteractionsCFunctorDefinition>;
}

public native struct gameinteractionsCSharedDataDefinition {
  public native let defaultChoices: array<String>;
  public native let visualizer: ref<gameuiIChoiceVisualizer>;
}

public native class gameinteractionsCSphereDefinition extends gameinteractionsIShapeDefinition {
  public native let position: Vector4;
  public native let radius: Float;
}

public native class gameinteractionsDistanceFromScreenCenterPredicate extends gameinteractionsIPredicateType {
  public native let height: Float;
  public native let width: Float;
  public native let curvature: Float;
  public native let maxPriorityBoundsFactor: Float;
}

public enum gameinteractionsEBinaryOperator {
  EBinaryOperator_and = 0,
  EBinaryOperator_or = 1,
}

public enum gameinteractionsEGroupType {
  EGT_default = 0,
  EGT_noInput = 1,
  EGT_hint = 2,
}

public enum gameinteractionsELookAtTarget {
  Entity = 0,
  Component = 1,
}

public enum gameinteractionsELookAtTest {
  Targeting = 0,
  Interaction = 1,
}

public enum gameinteractionsEPredicateType {
  EPredicateFunction_true = 0,
  EPredicateFunction_distanceFromScreenCentre = 1,
  EPredicateFunction_containedInShapes = 2,
  EPredicateFunction_onScreenTest = 3,
  EPredicateFunction_visibleTarget = 4,
  EPredicateFunction_lookAt = 5,
  EPredicateFunction_lookAtComponent = 6,
  EPredicateFunction_logicalLookAt = 7,
  EPredicateFunction_obstructedLookAt = 8,
  EPredicateFunction_lineOfSight = 4,
}

public enum gameinteractionsEUnaryOperator {
  EUnaryOperator_empty = 0,
  EUnaryOperator_not = 1,
}

public native struct gameinteractionsHotSpotActivationResult {
  public native let priority: Float;
}

public abstract native class gameinteractionsIFunctorDefinition extends ISerializable {}

public native struct gameinteractionsInteractionDefinitionOverrider {
  public native let tag: CName;
  public native let shapes: array<ref<gameinteractionsIShapeDefinition>>;
  public native let negativeShapes: array<ref<gameinteractionsIShapeDefinition>>;
  public native let priorityMultiplier: Float;
}

public native class gameinteractionsInteractionDescriptorResource extends CResource {
  public native let definition: gameinteractionsCHotSpotDefinition;
}

public abstract native class gameinteractionsIPredicateType extends ISerializable {}

public abstract native class gameinteractionsIShapeDefinition extends ISerializable {}

public native class gameinteractionsLayerActivatedPredicate extends gameinteractionsIPredicateType {
  public native let linkedLayersName: CName;
  public native let layerName: CName;
}

public native class gameinteractionsLookAtPredicate extends gameinteractionsIPredicateType {
  public native let testTarget: gameinteractionsELookAtTarget;
  public native let testType: gameinteractionsELookAtTest;
  public native let stopOnTransparent: Bool;
}

public native class gameinteractionsOnScreenTestPredicate extends gameinteractionsIPredicateType {}

public native class gameinteractionsOrbActivationPredicate extends gameinteractionsIPredicateType {}

public native struct gameinteractionsOrbID {
  public native let id: Uint32;
}

public native class gameinteractionsPieDefinition extends gameinteractionsIShapeDefinition {
  public native let center: Vector4;
  public native let baseLength: Float;
  public native let halfExtentZ: Float;
  public native let radius: Float;
  public native let angle: Float;
}

public abstract native struct gameinteractionsPublisherBaseEvent {}

public native class gameinteractionsSuppressedPredicate extends gameinteractionsIPredicateType {}

public native class gameinteractionsvisDeviceVisualizerDefinition extends gameinteractionsvisIVisualizerDefinition {
  public native let interactionType: gameinteractionsvisInteractionType;
  public native let displayNameOverride: String;
  public native let useDefaultActionMapping: Bool;
  public native let createMappin: Bool;
  public native let isDynamic: Bool;
  public native let timeProvider: ref<IVisualizerTimeProvider>;
}

public native class gameinteractionsvisDeviceVisualizerLogic extends gameinteractionsvisIGroupedVisualizerLogic {}

public native class gameinteractionsvisDialogVisualizerDefinition extends gameinteractionsvisIVisualizerDefinition {
  public native let displayNameOverride: String;
  public native let useLookAt: Bool;
  public native let disableAfterSelectingChoice: Bool;
  public native let timeProvider: ref<IVisualizerTimeProvider>;
  public native let hubPriority: Uint8;
}

public native class gameinteractionsvisDialogVisualizerLogic extends gameinteractionsvisIGroupedVisualizerLogic {}

public abstract native struct gameinteractionsvisFamilyBase {}

public native class gameinteractionsVisibleTargetPredicate extends gameinteractionsIPredicateType {
  public native let stopOnTransparent: Bool;
}

public abstract native class gameinteractionsvisIGroupedVisualizerLogic extends gameinteractionsvisIVisualizerLogicInterface {}

public native struct gameinteractionsvisInteractionDisplayData {
  public native let putAction: CName;
  public native let wInputKey: EInputKey;
  public native let HoldAction: Bool;
  public native let calizedName: String;
  public native let pe: ChoiceTypeWrapper;
  public native let oice: InteractionChoice;
}

public enum gameinteractionsvisInteractionType {
  LookAt = 0,
  Proximity = 1,
}

public abstract native class gameinteractionsvisIVisualizerDefinition extends ISerializable {
  public native let flags: EVisualizerDefinitionFlags;
}

public abstract native class gameinteractionsvisIVisualizerLogicInterface extends ISerializable {}

public native class gameinteractionsvisLootVisualizerDefinition extends gameinteractionsvisIVisualizerDefinition {}

public native class gameinteractionsvisLootVisualizerLogic extends gameinteractionsvisIVisualizerLogicInterface {}

public native class gameIntervalTimer extends gameBaseTimer {}

public native struct gameInventoryListenerData_Base {}

public abstract native class gameIPhantomEntitySystem extends IGameSystem {}

public abstract native class gameIPopulationSystem extends IGameSystem {}

public abstract native class gameIPuppetUpdaterSystem extends IGameSystem {}

public abstract native class gameIRealTimeEventSystem extends IGameSystem {}

public abstract native class gameIRenderGameplayEffectsManagerSystem extends IGameSystem {}

public abstract native class gameISaveSanitizationForbiddenAreaSystem extends IGameSystem {}

public abstract native class gameISchematicSystem extends IGameSystem {}

public native class gameIShootingAccuracySystem extends IGameSystem {}

public abstract native class gameIStatusComboSystem extends IGameSystem {}

public abstract native class gameIStreamingMonitorSystem extends IGameSystem {}

public native struct gameItemDropStorageInventoryListener {}

public native struct gameItemDropStorageManager {}

public importonly class gameItemEventsEquippedToObject extends Event {}

public native class gameItemEventsPropagateRenderingPlane extends Event {}

public native class gameItemEventsRemoveActiveItem extends Event {}

public importonly class gameItemEventsUnequippedFromObject extends Event {}

public native class gameItemEventsUnequipStarted extends Event {}

public native class gameItemFactorySystem extends gameIItemFactorySystem {}

public native struct gameItemFactorySystemPool {}

public native class gameItemsMeshesLoaded extends Event {}

public abstract native class gameITimeState extends ISerializable {}

public abstract native class gameITransformAnimatorSaveSystem extends IGameSystem {}

public abstract native class gameITransformsHistorySystem extends IGameSystem {}

public abstract native class gameITriggerDestructionComponent extends IComponent {
  public native let startActive: Bool;
}

public abstract native class gameIWorldBoundarySystem extends IGameSystem {}

public native class gameJoinTrafficSettings extends ISerializable {}

public abstract native class gameJournalBaseResource extends CResource {}

public native struct gameJournalChoiceEntryData {
  public native let entryPath: ref<gameJournalPath>;
}

public native class gameJournalDescriptorResource extends gameJournalBaseResource {
  public native let entriesActivatedAtStart: array<String>;
}

public native struct gameJournalEntryStateChangeDelayData {
  public native let entryPath: ref<gameJournalPath>;
  public native let entryType: CName;
  public native let oldState: gameJournalEntryState;
  public native let newState: gameJournalEntryState;
  public native let notifyOption: JournalNotifyOption;
  public native let changeType: JournalChangeType;
  public native let delay: Float;
}

public enum gameJournalEntryUserState {
  Undefined = 0,
  Inactive = 1,
  Active = 2,
  Succeeded = 3,
  Failed = 4,
  Read = 5,
  Open = 6,
}

public native struct gameJournalEntryVisitedStatusData {
  public native let entryPath: ref<gameJournalPath>;
  public native let entryType: CName;
  public native let isVisited: Bool;
}

public native class gameJournalFolderEntry extends JournalContainerEntry {}

public native class gameJournalManagerSharedState extends gameIGameSystemReplicatedState {
  public native let entryData: array<gameJournalSharedStateData>;
  public native let trackedQuestPath: Uint32;
}

public native class gameJournalPrimaryFolderEntry extends gameJournalFolderEntry {}

public native struct gameJournalQuestObjectiveCounterData {
  public native let entryPath: ref<gameJournalPath>;
  public native let oldValue: Int32;
  public native let newValue: Int32;
}

public native class gameJournalResource extends gameJournalBaseResource {
  public native let entry: ref<JournalEntry>;
}

public native class gameJournalRootFolderEntry extends gameJournalFolderEntry {
  public native let descriptor: ResourceAsyncRef; // raRef<gameJournalDescriptorResource>
}

public native struct gameJournalSharedStateData {
  public native let pathHash: Uint32;
  public native let entryState: gameJournalEntryState;
}

public native class gameJournalTree extends ISerializable {
  public native let rootEntries: array<ref<gameJournalRootFolderEntry>>;
}

public native class gameKillTriggerNode extends worldAreaShapeNode {}

public native class gameKillTriggerNodeInstance extends worldAreaShapeNodeInstance {}

public native class gameLadderComponent extends IComponent {
  public native let heightOfBottomPart: Float;
  public native let exitStepTop: Float;
  public native let verticalStepTop: Float;
  public native let exitStepBottom: Float;
  public native let verticalStepBottom: Float;
  public native let exitStepJump: Float;
  public native let verticalStepJump: Float;
  public native let enterOffset: Float;
}

public native class gameLadderObject extends GameObject {
  public native let heightOfBottomPart: Float;
  public native let exitStepTop: Float;
  public native let verticalStepTop: Float;
  public native let exitStepBottom: Float;
  public native let verticalStepBottom: Float;
  public native let exitStepJump: Float;
  public native let verticalStepJump: Float;
  public native let enterOffset: Float;
}

public native struct gameLastHitData {
  public native let targetEntityId: EntityID;
  public native let hitType: Uint32;
  public native let hitShapes: array<CName>;
}

public native class gameLocationPrefabMetadata extends worldPrefabMetadata {
  public native let tags: array<CName>;
  public native let ignoreParentPrefabs: Bool;
}

public native class gameLocationResource extends CResource {}

public native class gameLootBagInventoryListener extends InventoryListener {}

public native class gameLootPrefabMetadata extends worldPrefabMetadata {
  public native let lootTableTDBIDs: array<TweakDBID>;
  public native let ignoreParentPrefabs: Bool;
  public native let contentAssignment: TweakDBID;
}

public native class gameLootResource extends CResource {
  public native let data: ref<gameLootResourceData>;
}

public native class gameLootResourceData extends ISerializable {
  public native let version: Uint32;
}

public native class gameLootSlot extends gameLootContainerBase {
  public native let immovableAfterDrop: Bool;
  public native let dropChance: Float;
  public native let lootState: Uint8; // gameLootSlotState
}

public native class gameLootSlotSingleAppearance extends gameLootSlotSingleItem {
  public native let lootAppearance: CName;
}

public native class gameLootSlotSingleItem extends gameLootSlot {
  public native let itemTDBID: TweakDBID;
}

public native class gameLootSlotSingleItemLongStreaming extends gameLootSlotSingleItem {}

public native class gameLootSlotSingleQuery extends gameLootSlot {
  public native let queryTDBID: TweakDBID;
}

public native class gameMappinResource extends CResource {
  public native let cookedData: array<gameCookedMappinData>;
  public native let cookedMultiData: array<gameCookedMultiMappinData>;
  public native let cookedGpsData: array<gameCookedGpsMappinData>;
}

public native class gamemappinsCommonVariant extends gamemappinsIPointOfInterestVariant {
  public native let variant: gamedataMappinVariant;
}

public native struct gamemappinsDynamicQuestMappinRepInfo {
  public native let journalPathHash: Uint32;
  public native let entity: wref<Entity>;
}

public abstract native struct gamemappinsIMappinUpdateData {}

public abstract native class gamemappinsIMappinVolume extends ISerializable {}

public abstract native class gamemappinsIPointOfInterestVariant extends ISerializable {}

public abstract native struct gamemappinsIRuntimeMappinData {}

public native class gamemappinsMappinSystemReplicatedState extends gameIGameSystemReplicatedState {
  public native let mappinState: array<NewMappinID>;
  public native let mappinWithJournalState: array<Uint32>;
}

public native class gamemappinsOutlineMappinVolume extends gamemappinsIMappinVolume {
  public native let height: Float;
  public native let outlinePoints: array<Vector2>;
}

public native class gamemappinsPhaseVariant extends gamemappinsIPointOfInterestVariant {
  public native let phase: gamedataMappinPhase;
  public native let variant: gamedataMappinVariant;
}

public native struct gamemappinsQuestMappinManagerReplicatedState {
  public native let dynamicQuestMappinRepInfo: array<gamemappinsDynamicQuestMappinRepInfo>;
}

public native class gamemappinsStealthMappinStatsListener extends IStatsListener {}

public native struct gameMountDescriptor {
  public native let parentId: EntityID;
  public native let slotName: CName;
  public native let initialTransform: Transform;
  public native let state: PuppetVehicleState;
  public native let mountType: MountDescriptor_MountingType;
}

public abstract native class gamemountingIMountingPublisher extends IGameSystem {}

public native class gamemountingMountingFacility extends IMountingFacility {}

public native class gamemountingMountingFacilitySharedState extends ISerializable {
  public native let children: array<wref<Entity>>;
  public native let parents: array<wref<Entity>>;
  public native let slotIds: array<MountingSlotId>;
  public native let parentTypes: array<gameMountingObjectType>;
  public native let childTypes: array<gameMountingObjectType>;
}

public native class gamemountingMountingPublisher extends gamemountingIMountingPublisher {}

public native class gameMovingPlatformMountableComponent extends MountableComponent {}

public native class gameMovingPlatformRestoreMoveTo extends MoveTo {}

public native struct gameMovingPlatformSavedData {
  public native let currentLocalPosition: Vector4;
  public native let movement: ref<IMovingPlatformMovement>;
  public native let destinationName: CName;
  public native let destinationData: Int32;
  public native let time: Float;
  public native let maxTime: Float;
  public native let mountedPlayerEntityID: Uint32;
  public native let isPaused: Bool;
}

public native class gameMovingPlatformsSavedState extends ISerializable {
  public native let mapping: array<EntityID>;
  public native let data: array<gameMovingPlatformSavedData>;
}

public native struct gameMuppetAbilities {
  public native let canLook: gameMuppetAbility;
  public native let canMove: gameMuppetAbility;
  public native let canCrouch: gameMuppetAbility;
  public native let canSprint: gameMuppetAbility;
  public native let canSwitchWeapon: gameMuppetAbility;
  public native let canHoldWeapon: gameMuppetAbility;
  public native let canShoot: gameMuppetAbility;
  public native let canAimDownSight: gameMuppetAbility;
}

public native struct gameMuppetAbility {
  public native let value: Int32;
  public native let blocks: Int32;
}

public native struct gameMuppetComparisonReportItem {
  public native let type: gameMuppetComparisonReportItemType;
  public native let propertyName: String;
  public native let serverValue: String;
  public native let clientValue: String;
}

public enum gameMuppetComparisonReportItemType {
  Different = 0,
  WithinTolerance = 1,
  Equal = 2,
}

public native struct gameMuppetCompressedInputStates {
  public native let usesCompression: Bool;
  public native let compressedInputStates: array<Uint8>;
  public native let firstFrameId: Uint32;
  public native let replicationTime: netTime;
}

public native struct gameMuppetControllerSnapshot {
  public native let controllerId: CName;
  public native let isActive: Bool;
}

public native struct gameMuppetControllersSnapshot {
  public native let controllers: array<gameMuppetControllerSnapshot>;
}

public enum gameMuppetDebugCommand {
  None = 0,
  Kill = 1,
  KillAll = 2,
}

public native class gameMuppetDebugState extends ISerializable {
  public native let comparisonReports: array<gameMuppetStateComparisonReport>;
  public native let comparisonReportIndex: Uint32;
  public native let subStepsData: array<gameMuppetSubStepData>;
}

public native struct gameMuppetHealthState {
  public native let health: Float;
}

public native struct gameMuppetHighLevelState {
  public native let isDead: Bool;
  public native let deathFrameId: Uint32;
}

public enum gameMuppetInputActionType {
  Unknown = 0,
  Impulse = 1,
  Press = 2,
}

public native struct gameMuppetInputState {
  public native let frameId: Uint32;
}

public native class gameMuppetInventoryGameController extends inkHUDGameController {}

public native struct gameMuppetInventorySlotInfo {
  public native let itemCategory: TweakDBID;
  public native let itemId: ItemID;
  public native let quantity: Uint32;
}

public native struct gameMuppetInventoryState {
  public native let slots: array<gameMuppetInventorySlotInfo>;
  public native let activeSlot: Int32;
}

public native class gameMuppetLoadoutsGameController extends inkHUDGameController {}

public native struct gameMuppetLookState {
  public native let lookDir: EulerAngles;
}

public native struct gameMuppetMoveState {
  public native let desiredSpeed: Float;
  public native let isJumping: Bool;
  public native let isFalling: Bool;
  public native let isDoubleJumped: Bool;
  public native let moveStyle: gameMuppetMoveStyle;
  public native let jumpStartFrameId: Uint32;
  public native let landFrameId: Uint32;
}

public enum gameMuppetMoveStyle {
  Invalid = 0,
  Walk = 1,
  Sprint = 2,
  Crouch = 3,
  WalkAim = 4,
  GravityOnly = 5,
}

public native struct gameMuppetPhysicalState {
  public native let position: Vector4;
  public native let worldYaw: Float;
  public native let velocity: Vector4;
  public native let isOnGround: Bool;
  public native let groundNormal: Vector4;
}

public native struct gameMuppetScanningState {
  public native let isScanning: Bool;
}

public native struct gameMuppetState {
  public native let frameId: Uint32;
  public native let highLevelState: gameMuppetHighLevelState;
  public native let healthState: gameMuppetHealthState;
  public native let physicalMoveState: gameMuppetPhysicalState;
  public native let lookState: gameMuppetLookState;
  public native let moveState: gameMuppetMoveState;
  public native let upperBodyState: gameMuppetUpperBodyState;
  public native let scanningState: gameMuppetScanningState;
  public native let inventoryState: gameMuppetInventoryState;
  public native let abilities: gameMuppetAbilities;
  public native let stateMachinesSnapshot: gameMuppetStateMachinesSnapshot;
  public native let controllersSnapshot: gameMuppetControllersSnapshot;
  public native let snapFrameId: Uint32;
}

public native struct gameMuppetStateComparisonReport {
  public native let frameID: Uint32;
  public native let items: array<gameMuppetComparisonReportItem>;
}

public native struct gameMuppetStateMachineSnapshot {
  public native let stateMachineId: CName;
  public native let stateId: CName;
}

public native struct gameMuppetStateMachinesSnapshot {
  public native let stateMachines: array<gameMuppetStateMachineSnapshot>;
}

public native struct gameMuppetStates {}

public native struct gameMuppetSubStepData {
  public native let frameId: Uint32;
  public native let parentFrameId: Uint32;
  public native let parentFramePrimaryColor: Bool;
  public native let inputState: gameMuppetInputState;
  public native let state: gameMuppetState;
  public native let resimulationSubsteps: array<gameMuppetSubStepData>;
}

public native struct gameMuppetUpperBodyState {
  public native let currentWeapon: ItemID;
  public native let wantedWeapon: ItemID;
  public native let inProgressWeapon: ItemID;
  public native let logicWantedWeapon: ItemID;
  public native let equippingTransitionTime: Float;
  public native let remainingShotTime: Float;
  public native let timeTillNextShootSeconds: Float;
  public native let isAimingDownSight: Bool;
  public native let currentWeaponAmmo: Int32;
  public native let currentWeaponAmmoCapacity: Int32;
  public native let isShooting: Bool;
  public native let weaponZoomLevel: Float;
  public native let weaponAimFOV: Float;
  public native let remainingReloadTime: Float;
  public native let remainingReloadCooldownTime: Float;
  public native let shotsMade: Uint32;
  public native let isMeleeAttackInProgress: Bool;
  public native let meleeAttacksMade: Uint32;
  public native let meleeAttackIndex: Int32;
  public native let remainingMeleeAttackDuration: Float;
  public native let selectedConsumable: ItemID;
  public native let consumableInUse: Bool;
  public native let consumableEffectApplied: Bool;
  public native let consumableUseTimeStartup: Float;
  public native let consumableUseTimeRecovery: Float;
  public native let remainingQuickMeleeTime: Float;
  public native let remainingQuickMeleeCooldownTime: Float;
}

public native class gameNarrationPlateBlackboardUpdater extends ISerializable {}

public native struct gameNetAIState {
  public native let value: Int32;
  public native let prevValue: Int32;
  public native let time: Float;
}

public native struct gameNetrunnerPrototypeStruct {
  public native let key: CName;
  public native let entityTemplate: ResourceAsyncRef; // raRef<entEntityTemplate>
}

public native class gameNPCHealthStatPoolsListener extends gamePuppetStatPoolsListener {}

public native class gameNPCQuickHackUploadStatPoolsListener extends gamePuppetStatPoolsListener {}

public native class gameNPCStatsListener extends gamePuppetStatsListener {}

public native class gameObjectDeathListener extends IStatPoolsListener {}

public native class gameObjectMountableComponent extends MountableComponent {}

public abstract native class gameObjectSpawnParameter extends ISerializable {}

public native class gameObjectSpawnParametersList extends gameObjectSpawnParameter {
  public native let parameterList: array<ref<gameObjectSpawnParameter>>;
}

public native class gameOccupantSlotComponent extends SlotComponent {
  public native let slotData: array<gameOccupantSlotData>;
}

public importonly struct gameOccupantSlotData {
  public native let slotName: CName;
  public native let syncAnimationTag: CName;
  public native let workSpotResource: ResourceRef; // rRef<workWorkspotResource>
  public native let exitOffsetFromSlot: Vector4;
  public native let role: gameMountingSlotRole;
}

public abstract importonly struct gameOnExecutionContext {}

public native struct gamePatrolSplineControlPoint {}

public native class gamePersistentStateDataResource extends CResource {}

public native class gamePhantomEntityComponent extends IComponent {
  public native let params: gamePhantomEntityParameters;
  public native let effectBinding: ref<gameEffectComponentBinding>;
}

public native struct gamePhantomEntityParameters {
  public native let teleportStartEffect: CName;
  public native let teleportEndEffect: CName;
  public native let spawnEffect: CName;
  public native let glitchEffect: CName;
  public native let phantomVisibleStates: array<gamePhantomEntityState>;
  public native let blendableAppearanceMatches: array<gamePhantomEntityParametersBlendableAppearanceMatch>;
}

public native struct gamePhantomEntityParametersBlendableAppearanceMatch {
  public native let blendable: CName;
  public native let notBlendable: CName;
}

public enum gamePhantomEntityState {
  RootMotion = 0,
  Workspot = 1,
  MoveOnSpline = 2,
}

public native class gamePhantomEntitySystem extends gameIPhantomEntitySystem {}

public native class gamePhotoModeAttachmentSlotsListener extends AttachmentSlotsListener {}

public native class gamePhotoModeAutoFocusPositionProvider extends IPositionProvider {}

public native class gamePhotoModeBackgroundCameraComponent extends entCameraComponent {
  public native let isEnabled: Bool;
  public native let virtualCameraName: CName;
  public native let dynamicTextureRes: ResourceAsyncRef; // raRef<DynamicTexture>
  public native let env: ResourceRef; // rRef<worldEnvironmentAreaParameters>
  public native let params: WorldRenderAreaSettings;
  public native let depthCutDistance: Float;
  public native let backgroundColor: Color;
  public native let overrideBackgroundColor: Bool;
  public native let renderSceneLayer: RenderSceneLayer;
  public native let streamingDistance: Float;
}

public native class gamePhotoModeCameraObject extends GameObject {}

public native class gamePhotoModeObjectPositionProvider extends IPositionProvider {}

public native struct gamePhotoModeUtils {}

public native class gamePhysicalDestructionListenerComponent extends IComponent {
  public native let physicalDestructionComponentName: CName;
  public native let thresholdLevels: array<Float>;
}

public native class gamePickupObject extends GameObject {
  public native let interactionTag: CName;
}

public native struct gamePingEntry {
  public native let owner: wref<GameObject>;
  public native let worldPosition: Vector4;
  public native let time: netTime;
  public native let pingType: gamedataPingType;
  public native let hitObject: wref<Entity>;
}

public native class gamePingSystemReplicatedState extends gameIGameSystemReplicatedState {
  public native let replicatedPingEntries: array<gamePingEntry>;
}

public abstract native struct gamePlayer {
  public native let peerID: netPeerID;
  public native let nickname: String;
}

public native class gameplayeractionsAttachSlotListener extends AttachmentSlotsListener {}

public native class gamePlayerArmorStatPoolsListener extends gamePuppetStatPoolsListener {}

public native class gamePlayerCommandConsumerComponent extends IComponent {}

public native class gamePlayerCoverInfo extends IScriptable {}

public native class gamePlayerHealthStatPoolsListener extends gamePuppetStatPoolsListener {}

public native class gamePlayerManager extends gameIPlayerManager {}

public native class gamePlayerReleaseControlAsChild extends Event {}

public native class gamePlayerReleaseControlAsParent extends Event {}

public native struct gamePlayerSocket {}

public native struct gamePlayerSpawnParams {
  public native let isSpectator: Bool;
  public native let spawnPoint: Transform;
  public native let recordId: TweakDBID;
  public native let gender: CName;
  public native let useSpecifiedStartPoint: Bool;
  public native let spawnTags: redTagList;
  public native let nickname: String;
}

public native class gamePlayerStatsListener extends gamePuppetStatsListener {}

public native class gamePlayerTakeControlAsChild extends Event {}

public native class gamePlayerTakeControlAsParent extends Event {}

public native class gamePlayerTierComponent extends IComponent {}

public native struct GameplayFunctionalTestReturnValue {
  public native let value: String;
  public native let errorInfo: String;
}

public native class gamePointOfInterestMappinResource extends CResource {
  public native let cookedData: array<gameCookedPointOfInterestMappinData>;
}

public enum gamePopulationEntityPriority {
  Quest = 0,
  Community = 1,
  Crowd = 2,
}

public native class gamePopulationSystem extends gameIPopulationSystem {}

public native class gamePrepareTPPRepresentationEvent extends Event {}

public native struct gamePrereqDefinition {
  public native let prereqName: CName;
  public native let prereq: ref<IPrereq>;
}

public native class gamePrereqsResource extends CResource {
  public native let prereqs: array<gamePrereqDefinition>;
}

public native class gamePreventionSpawnSystemSavedState extends ISerializable {
  public native let areaIds: array<Uint64>;
}

public native class gamePreviewItemData extends gameUniqueItemData {}

public enum gameprojectileParabolicUnknownVariable {
  TargetPoint = 0,
  VelocityValue = 1,
  Accel = 2,
}

public importonly class gameprojectileSpawnerAttachEvent extends Event {
  public native let owner: wref<GameObject>;
}

public importonly class gameprojectileSpawnerAttachExistingEvent extends Event {
  public native let projectile: wref<GameObject>;
  public native let owner: wref<GameObject>;
}

public native struct gameprojectileVelocityParams {
  public native let xFactor: Float;
  public native let yFactor: Float;
  public native let zFactor: Float;
}

public enum gamePSMCover {
  Any = -1,
  Default = 0,
  InCover = 1,
  Peek = 2,
  Lean = 3,
  OutOfCover = 4,
}

public abstract native class gamePuppetStatPoolsListener extends IStatPoolsListener {}

public abstract native class gamePuppetStatsListener extends IStatsListener {}

public native class gamePuppetStatusEffectListener extends IStatusEffectListener {}

public native class gamePuppetTriggerDestructionComponent extends gameITriggerDestructionComponent {
  public native let projectionDist: Float;
}

public native class gamePuppetUpdaterSystem extends gameIPuppetUpdaterSystem {}

public enum gameQuestGuidanceMarkerPathfindingType {
  Auto = 0,
  Navmesh = 1,
  Traffic = 2,
}

public native class gameQuestOrSceneSetVehiclePhysicsActive extends Event {}

public native class gameRandomStatModifierData extends gameStatModifierData {
  public native persistent let value: Float;
}

public native struct gameRazerChromaAnimation {
  public native let id: Int32;
  public native let name: CName;
}

public native class gameRazerChromaAnimationDatabase extends CResource {
  public native let setsSerialized: array<gameRazerChromaAnimationSet>;
}

public native struct gameRazerChromaAnimationSet {
  public native let name: CName;
  public native let animations: array<gameRazerChromaAnimation>;
}

public native class gameRealTimeEventSystem extends gameIRealTimeEventSystem {}

public native class gameRecordIdSpawnModifier extends populationModifier {}

public native class gameRegular1v1FinisherScenario extends gameIFinisherScenario {
  public native let attackerWorkspot: ResourceAsyncRef; // raRef<workWorkspotResource>
  public native let targetWorkspot: ResourceAsyncRef; // raRef<workWorkspotResource>
  public native let syncData: array<gameFinisherSyncData>;
  public native let targetPlaybackDelay: Float;
  public native let targetBlendTime: Float;
  public native let attackerPlaybackDelay: Float;
  public native let attackerBlendTime: Float;
  public native let pivotSettings: gameRegular1v1FinisherScenarioPivotSetting;
  public native let attackerIsMaster: Bool;
  public native let targetSlotNameToAttachAttackerWeaponLeft: CName;
}

public enum gameRegular1v1FinisherScenarioPivotSetting {
  AttackerSlidesAndRotates_TargetStandsStill = 0,
  AttackerStandsStill_TargetSlidesAndRotates = 1,
}

public native class gameRemains extends GameObject {}

public native class gameRemoveCooldownEvent extends gameCooldownSystemEvent {}

public native class gameRenderGameplayEffectsManagerSaveData extends ISerializable {
  public native let cyberspacePixelsortParams: gameCyberspacePixelsortEffectParams;
  public native let cyberspacePixelsortEnabled: Bool;
  public native let enforceScreenSpaceReflectionsUberQuality: Bool;
}

public native class gameRenderGameplayEffectsManagerSystem extends gameIRenderGameplayEffectsManagerSystem {}

public native struct gameReplAnimTransformRequestBase {
  public native let applyServerTime: netTime;
}

public native struct gameReplAnimTransformSyncElem {
  public native let definitionId: Int32;
  public native let currentTime: Float;
  public native let timeScale: Float;
  public native let duration: Float;
  public native let timesToPlay: Int32;
  public native let playing: Bool;
}

public native struct gameReplicatedAnimControllerEventsState {
  public native let items: array<gameReplicatedAnimEvent>;
  public native let lastAppliedActionsTime: netTime;
}

public native struct gameReplicatedContinuousAttack {
  public native let startTimeStamp: netTime;
  public native let stopTimeStamp: netTime;
  public native let attackId: TweakDBID;
}

public native struct gameReplicatedEntityEventsState {
  public native let items: array<gameReplicatedEntityEvent>;
  public native let lastAppliedActionsTime: netTime;
}

public native struct gameReplicatedShotData {
  public native let timeStamp: netTime;
  public native let attackId: TweakDBID;
  public native let target: wref<GameObject>;
  public native let targetLocalOffset: Vector3;
}

public native class gameRootTransformAnimatorComponent extends entIMoverComponent {
  public native let animations: array<gameTransformAnimationDefinition>;
}

public native class gameRuntimeSystemLights extends worldIRuntimeSystem {}

public native class gameSavedPatrolProgressState extends ISerializable {
  public native persistent let entrySplineParam: Float;
  public native persistent let entrySectionIndex: Uint32;
  public native persistent let controlPointIndex: Uint32;
  public native persistent let splineEntryPosition: Vector3;
  public native persistent let splineEntryTangent: Vector3;
  public native persistent let isSplineReversed: Bool;
  public native persistent let currentDestinationPosition: Vector3;
  public native persistent let currentDestinationTangent: Vector3;
}

public importonly struct gameSavedStatsData {
  public native let statModifiers: array<ref<gameStatModifierData>>;
  public native let inactiveStats: array<gamedataStatType>;
  public native let recordID: TweakDBID;
  public native let seed: Uint32;
}

public native class gameScanningControllerReplicatedState extends ISerializable {
  public native let taggedObjectIDs: array<EntityID>;
}

public native class gameScanningControllerSaveData extends ISerializable {
  public native let taggedObjectIDs: array<EntityID>;
}

public native class gameScanningInternalEvent extends Event {}

public enum gameSceneAnimationMotionActionParamsEasingType {
  Linear = 0,
  SinusoidalEaseInOut = 1,
  QuadraticEaseIn = 2,
  QuadraticEaseOut = 3,
  CubicEaseInOut = 4,
  CubicEaseIn = 5,
  CubicEaseOut = 6,
}

public enum gameSceneAnimationMotionActionParamsMotionType {
  Rid = 0,
  Anim = 1,
}

public native struct gameScenePlayerAnimationParams {}

public native class gameScreenshot360CameraComponent extends CameraComponent {}

public native class gameSetDestinationActionEvent extends ActionEvent {
  public native let position: Vector3;
}

public native class gameSetupControlledByStoryEvent extends AIEvent {}

public native class gameShootingAccuracySystem extends gameIShootingAccuracySystem {}

public native class gameShootingSpotDefinition extends gameCoverDefinition {}

public native struct gameSignalId {
  public native let value: Uint16;
}

public abstract native class gameSignalPriorityDefinition extends ISerializable {
  public native let defaultPriority: Uint16;
}

public native class gameSimpleOccupantSlotSpawner extends IComponent {}

public native class gameSimpleSpecificStatListener extends ISerializable {}

public native class gameSimpleStatPoolDataModifierStatListener extends gameStatPoolDataModifierStatListener {}

public native class gameSmartObjectAnimationDatabase extends ISerializable {
  public native let animationData: array<gameAnimationExtractedData>;
  public native let bodyTypesData: array<gameBodyTypeData>;
}

public native class gameSmartObjectDefinition extends ISerializable {
  public native let resource: ResourceRef; // rRef<gameSmartObjectResource>
  public native let actions: array<CName>;
  public native let motionActionDatabase: ResourceRef; // rRef<animActionAnimDatabase>
  public native let enabled: Bool;
  public native let overrideGeneratedParameters: Bool;
}

public native struct gameSmartObjectGate {
  public native let animationName: CName;
  public native let movementType: moveMovementType;
  public native let movementOrientationType: moveMovementOrientationType;
}

public abstract native struct gameSmartObjectInstance {}

public enum gameSmartObjectInstanceEntryType {
  UseEntryAnimation = 0,
  UseLocomotion = 1,
}

public native class gameSmartObjectMembership extends ISerializable {
  public native let members: array<gameSmartObjectMembershipMemberShip>;
}

public native struct gameSmartObjectMembershipMemberShip {
  public native let hash: Uint64;
  public native let index: Uint32;
}

public native struct gameSmartObjectPoint {
  public native let isReachable: Bool;
}

public enum gameSmartObjectPointType {
  Entry = 0,
  Exit = 1,
  Action = 2,
}

public native class gameSmartObjectPropertyDictionary extends ISerializable {
  public native let properties: array<gameSmartObjectPropertyDictionaryPropertyEntry>;
}

public native struct gameSmartObjectPropertyDictionaryPropertyEntry {
  public native let id: Uint16;
  public native let usage: Uint32;
  public native let animationName: CName;
  public native let sourceAnimset: Uint64;
  public native let type: gameSmartObjectPointType;
  public native let movementType: moveMovementType;
  public native let movementOrientation: moveMovementOrientationType;
  public native let isOnNavmesh: Bool;
  public native let isReachable: Bool;
  public native let overObstacle: Bool;
}

public native class gameSmartObjectResource extends CResource {
  public native let entryPoints: array<gameSmartObjectGate>;
  public native let exitPoints: array<gameSmartObjectGate>;
  public native let bodyTypes: array<gameBodyTypeAnimationDefinition>;
  public native let loopAnimations: array<gameSmartObjectGate>;
  public native let type: gameSmartObjectType;
}

public native class gameSmartObjectsCompiledResource extends resStreamedResource {
  public native let animationDatabase: ref<gameSmartObjectAnimationDatabase>;
  public native let compiledNodesData: ref<gameCompiledNodes>;
  public native let transformDictionary: ref<gameSmartObjectTransformDictionary>;
  public native let propertyDictionary: ref<gameSmartObjectPropertyDictionary>;
  public native let transformSequenceDictionary: ref<gameSmartObjectTransformSequenceDictionary>;
  public native let soMembership: ref<gameSmartObjectMembership>;
  public native let localBoundingBox: Box;
}

public native class gameSmartObjectTransformDictionary extends ISerializable {
  public native let transforms: array<gameSmartObjectTransformDictionaryTransformEntry>;
}

public native struct gameSmartObjectTransformDictionaryTransformEntry {
  public native let transform: Transform;
  public native let usage: Uint32;
  public native let id: Uint16;
}

public native class gameSmartObjectTransformSequenceDictionary extends ISerializable {
  public native let sequences: array<gameSmartObjectTransformSequenceDictionaryEntry>;
}

public native struct gameSmartObjectTransformSequenceDictionaryEntry {
  public native let sequence: array<Uint16>;
  public native let id: Uint8;
}

public enum gameSmartObjectType {
  Default = 0,
  LadderUp = 1,
  LadderDown = 2,
  JumpOnSameLevel = 3,
  Jump3mUp = 4,
  Jump3mDown = 5,
  Climb110cmUp = 6,
  Climb110cmDown = 7,
  Climb200cmUp = 8,
  Climb200cmDown = 9,
  Climb300cmUp = 10,
  Climb300cmDown = 11,
  Vault10cm = 12,
  Vault40cm = 13,
  Vault100cm = 14,
  ChargedJump400cmUp = 15,
  ChargedJump400cmDown = 16,
  ChargedJump600cmUp = 17,
  ChargedJump600cmDown = 18,
  ChargedJump800cmUp = 19,
  ChargedJump800cmDown = 20,
  ThrusterJumpUp = 21,
  ThrusterJumpDown = 22,
  Climb400cmDown = 23,
  Jump4mDown = 24,
  VaultJump7mDown = 25,
}

public native struct gameSmartObjectVisualData {}

public native class gameSmartObjectWorkspotDefinition extends gameSmartObjectDefinition {
  public native let workspotTemplate: ResourceRef; // rRef<workWorkspotResource>
}

public native struct gameSmartObjectWorkspotInstance {}

@neverRef()
public native class gameSourceData extends ISerializable {
  public native persistent let name: CName;
  public native persistent let savable: Bool;
}

public enum gameSpawnInViewState {
  default__true_ = 0,
  true = 1,
  false = 2,
}

public native class gameSpawnOccupantsEvent extends Event {}

public native struct gameSpotSequenceCategory {
  public native let type: gamedataWorkspotCategory;
  public native let probability: Float;
}

public native class gameSquadMemberComponentPS extends GameComponentPS {
  public native persistent let entries: array<gameSquadMemberDataEntry>;
}

public native struct gameSquadMemberDataEntry {
  public native persistent let squadName: CName;
  public native persistent let squadType: AISquadType;
}

public native class gameStackedItemData extends gameItemData {}

public native struct gameStatData {
  public native let modifiers: array<gameStatModifierHandle>;
  public native let statType: gamedataStatType;
}

public abstract native class gamestateMachineIStateActionDefinition extends ISerializable {}

public abstract native class gamestateMachineIStateMachineBody extends ISerializable {}

public native class gamestateMachineparameterTypeInteractionDescription extends IScriptable {
  public native let interactionEntity: wref<Entity>;
  public native let interactionType: CName;
}

public native class gamestateMachineplayeractionsActionCharge extends gamestateMachineplayeractionsWeaponActionBase {}

public native class gamestateMachineplayeractionsActionChargeMax extends gamestateMachineplayeractionsWeaponActionBase {}

public native class gamestateMachineplayeractionsActionChargeReady extends gamestateMachineplayeractionsWeaponActionBase {}

public native class gamestateMachineplayeractionsActionCycleTriggerMode extends gamestateMachineplayeractionsWeaponActionBase {}

public native class gamestateMachineplayeractionsActionDischarge extends gamestateMachineplayeractionsWeaponActionBase {}

public native class gamestateMachineplayeractionsActionProjectileAttach extends gamestateMachineStateActionDefinition {}

public native class gamestateMachineplayeractionsActionProjectileDetach extends gamestateMachineStateActionDefinition {}

public native class gamestateMachineplayeractionsActionProjectileShowPreview extends gamestateMachineplayeractionsActionCharge {}

public native class gamestateMachineplayeractionsActionReady extends gamestateMachineplayeractionsWeaponActionBase {}

public native class gamestateMachineplayeractionsActionReload extends gamestateMachineplayeractionsWeaponActionBase {}

public native class gamestateMachineplayeractionsActionShoot extends gamestateMachineplayeractionsWeaponActionBase {}

public native class gamestateMachineplayeractionsActionWindup extends gamestateMachineplayeractionsWeaponActionBase {}

public native class gamestateMachineplayeractionsClimb extends gamestateMachineplayeractionsLocomotionBase {}

public native class gamestateMachineplayeractionsEquipItem extends gamestateMachineStateActionDefinition {}

public native class gamestateMachineplayeractionsHighLevelAiControlled extends gamestateMachineStateActionDefinition {}

public native class gamestateMachineplayeractionsLocomotionAir extends gamestateMachineplayeractionsLocomotionSimple {}

public native class gamestateMachineplayeractionsLocomotionBase extends gamestateMachineStateActionDefinition {}

public native class gamestateMachineplayeractionsLocomotionBraindance extends gamestateMachineplayeractionsLocomotionBase {}

public native class gamestateMachineplayeractionsLocomotionForceFreeze extends gamestateMachineplayeractionsLocomotionBase {}

public native class gamestateMachineplayeractionsLocomotionForceIdle extends gamestateMachineplayeractionsLocomotionBase {}

public native class gamestateMachineplayeractionsLocomotionLadder extends gamestateMachineplayeractionsLocomotionBase {}

public native class gamestateMachineplayeractionsLocomotionSimple extends gamestateMachineplayeractionsLocomotionBase {}

public native class gamestateMachineplayeractionsLocomotionStart extends gamestateMachineStateActionDefinition {}

public native class gamestateMachineplayeractionsLocomotionSwimmingDiving extends gamestateMachineplayeractionsLocomotionBase {}

public native class gamestateMachineplayeractionsLocomotionSwimmingStart extends gamestateMachineStateActionDefinition {}

public native class gamestateMachineplayeractionsLocomotionSwimmingSurface extends gamestateMachineplayeractionsLocomotionBase {}

public native class gamestateMachineplayeractionsLocomotionWallRun extends gamestateMachineplayeractionsLocomotionBase {}

public native class gamestateMachineplayeractionsUpperBodyBase extends gamestateMachineStateActionDefinition {}

public native class gamestateMachineplayeractionsVault extends gamestateMachineplayeractionsLocomotionBase {}

public native class gamestateMachineplayeractionsVehicleDrive extends gamestateMachineStateActionDefinition {}

public native class gamestateMachineplayeractionsVehicleExiting extends gamestateMachineStateActionDefinition {}

public native class gamestateMachineplayeractionsWeaponActionBase extends gamestateMachineStateActionDefinition {}

public native class gamestateMachineplayeractionsWeaponStart extends gamestateMachineplayeractionsWeaponActionBase {}

public native class gamestateMachineState extends graphGraphNodeDefinition {}

public native class gamestateMachineStateActionDefinition extends gamestateMachineIStateActionDefinition {}

public native struct gamestateMachineStateContext {
  public native let snapshot: StateSnapshotsContainer;
  public native let permanentParameters: gamestateMachineStateContextParameters;
}

public native struct gamestateMachineStateContextConsumableParameters {
  public native let boolParameters: [ConsumableParameterBool; 128];
  public native let intParameters: [ConsumableParameterInt; 128];
  public native let floatParameters: [ConsumableParameterFloat; 128];
  public native let doubleParameters: [ConsumableParameterDouble; 128];
  public native let vectorParameters: [ConsumableParameterVector; 128];
  public native let CNameParameters: [ConsumableParameterCName; 128];
  public native let IScriptableParameters: [ConsumableParameterIScriptable; 128];
  public native let weakIScriptableParameters: [ConsumableParameterWeakIScriptable; 128];
  public native let tweakDBIDParameters: [ConsumableParameterTweakDBID; 128];
}

public native struct gamestateMachineStateContextParameters {
  public native let boolParameters: [ActionParameterBool; 128];
  public native let intParameters: [ActionParameterInt; 128];
  public native let floatParameters: [ActionParameterFloat; 128];
  public native let doubleParameters: [ActionParameterDouble; 128];
  public native let vectorParameters: [ActionParameterVector; 128];
  public native let CNameParameters: [ActionParameterCName; 128];
  public native let IScriptableParameters: [ActionParameterIScriptable; 128];
  public native let tweakDBIDParameters: [ActionParameterTweakDBID; 128];
}

public native class gamestateMachineStateDefinition extends graphGraphNodeDefinition {}

public native class gamestateMachineStateDefinitionSocketDefinition extends graphGraphSocketDefinition {}

public native class gamestateMachineStateMachine extends graphGraphDefinition {}

public native class gamestateMachineStateMachineBody extends gamestateMachineIStateMachineBody {}

public native class gamestateMachineStateMachineBodyLocomotionTier1 extends gamestateMachineStateMachineBody {}

public native class gamestateMachineStateMachineDefinition extends graphGraphDefinition {}

public native class gamestateMachineStateMachineListDefinition extends IScriptable {
  public native let stateMachinesStorage: array<ref<gamestateMachineStateMachineDefinition>>;
}

public native class gamestateMachineStateMachineResource extends graphGraphResource {}

public native class gamestateMachineStateSocketDefinition extends graphGraphSocketDefinition {}

public native class gamestateMachineTransition extends graphGraphConnectionDefinition {
  public native let transitionCondition: ref<StateFunctor>;
}

public native class gamestateMachineTransitionDefinition extends graphGraphConnectionDefinition {
  public native let priority: Float;
}

public enum gameStatIDType {
  EntityID = 0,
  ItemID = 1,
  Invalid = 2,
}

public abstract native struct gameStatModifierBase {}

public native struct gameStatModifierGroup {
  public native let statModifierArray: array<gameStatModifierHandle>;
  public native let statModifiersLimit: Int32;
  public native let statModifiersLimitModifier: TweakDBID;
  public native let relatedModifierGroups: array<TweakDBID>;
  public native let statModifierGroupRecordID: TweakDBID;
  public native let stackCount: Uint16;
  public native let drawBasedOnStatType: Bool;
  public native let saveBasedOnStatType: Bool;
  public native let optimiseCombinedModifiers: Bool;
}

public native struct gameStatModifierHandle {}

public importonly struct gameStatModifierSave {
  public native let statModifierUnions: array<ref<gameStatModifierData>>;
  public native let statsObjectID: StatsObjectID;
  public native let recordID: TweakDBID;
  public native let seed: Uint32;
}

public native struct gameStatPoolData {
  public native let ownerID: StatsObjectID;
  public native let recordID: TweakDBID;
  public native let type: gamedataStatPoolType;
  public native let modifiers: [StatPoolModifier; 2];
  public native let alternativeModifierRecords: [TweakDBID; 2];
  public native let stat: gamedataStatType;
  public native let maxValue: Float;
  public native let customLimitValue: Float;
  public native let changeMode: gameStatPoolDataValueChangeMode;
  public native let bonus: Float;
  public native let bonusType: gameStatPoolDataBonusType;
  public native let currentValue: Float;
  public native let modificationDelay: Float;
  public native let modificationStatus: gameStatPoolDataStatPoolModificationStatus;
}

public enum gameStatPoolDataBonusType {
  None = 0,
  Persistent = 1,
  NonPersistent = 2,
}

public abstract importonly class gameStatPoolDataModifierStatListener extends IStatsListener {}

public enum gameStatPoolDataStatPoolModificationStatus {
  Regeneration = 0,
  Decay = 1,
  NoModification = 2,
}

public enum gameStatPoolDataValueChangeMode {
  Normal = 0,
  IncreasingOnly = 1,
  DecreasingOnly = 2,
  NonZero = 3,
}

public enum gameStatPoolModifierProperty {
  RangeBegin = 0,
  RangeEnd = 1,
  StartDelay = 2,
  ValuePerSec = 3,
  Enabled = 4,
  DelayOnChange = 5,
  Count = 6,
}

public native struct gameStatPoolModifierRuntimeData {
  public native let modifier: StatPoolModifier;
  public native let modificationDelay: Float;
  public native let inRange: Bool;
  public native let recordID: TweakDBID;
}

public native class gameStatPoolsSystemSave extends ISerializable {
  public native let mapping: array<StatsObjectID>;
  public native let statPools: array<gameStatPoolData>;
}

public enum gameStatsBundleOwnerType {
  None = 0,
  Cleared = 1,
  UniqueItem = 2,
  StackableItem = 3,
  InnerItem = 4,
  Entity = 5,
  Stub = 6,
  Reinitialized = 7,
  Count = 8,
  Invalid = 9,
}

public native class gameStatsComponentPS extends GameComponentPS {}

public importonly struct gameStatsSeedKey {
  public native let entityID: EntityID;
  public native let recordID: TweakDBID;
  public native let seed: Uint32;
}

public importonly struct gameStatsStateMapStructure {
  public native let keys: array<StatsObjectID>;
  public native let values: array<gameSavedStatsData>;
}

public importonly class gameStatsSystemSave extends ISerializable {
  public native let statsObjectsData: array<gameStatsSeedKey>;
  public native let statModifiersData: array<gameStatModifierSave>;
}

public native class gameStatsUnit extends ISerializable {
  public native let recordID: TweakDBID;
}

public native class gameStatusComboSystem extends gameIStatusComboSystem {}

public native struct gameStatusEffectReplicatedInfo {
  public native let statusEffectRecordID: TweakDBID;
  public native let stackCount: Uint32;
  public native let source: CName;
}

public native class gameStreamingMonitorSystem extends gameIStreamingMonitorSystem {}

public native class gameSubStatModifierData extends gameStatModifierData {
  public native persistent let refStatType: gamedataStatType;
}

public native class gameTagSpawParameter extends gameObjectSpawnParameter {
  public native let tags: array<CName>;
}

public native class gameTargetingActivatorComponent extends IComponent {}

public native struct gameTargetingComponentData {}

public native class gameTargetingLocalizedEffectComponent extends IComponent {
  public native let streamingDistance: Float;
  public native let visibleTargetRange: Float;
}

public enum gameTelemetryMilestoneType {
  StartFact = 0,
  ImportantFact = 1,
  Reward = 2,
  EndFact = 4,
  EndReward = 3,
  Invalid = 5,
}

public native struct gameTelemetryPostMortem {
  public native let crashVisitId: String;
  public native let playthroughId: String;
  public native let crashVersion: String;
  public native let crashPatch: String;
  public native let timeCrash: String;
  public native let district: String;
  public native let zoneType: String;
  public native let trackedQuest: gameTelemetryTrackedQuest;
  public native let location: Vector3;
  public native let sessionLength: Float;
  public native let isOom: Bool;
}

public native class gameTelemetryPostMortemContainer extends ISerializable {
  public native let postMortem: gameTelemetryPostMortem;
}

public native struct gameTelemetryTrackedQuest {
  public native let name: String;
  public native let objectiveName: String;
  public native let type: String;
  public native let distance: Float;
  public native let questName: String;
  public native let questType: String;
}

public native class gameTierPrereq extends IComparisonPrereq {
  public native let tier: GameplayTier;
}

public native class gameTierPrereqState extends PrereqState {}

public native class gameTierSaveData extends ISerializable {
  public native let globalTiers: array<gameGlobalTierSaveData>;
}

public native class gameTierSystem extends ITierSystem {}

public native class gameTimeDilationEvent extends Event {}

public native class gameTimeSystemReplicatedState extends gameIGameSystemReplicatedState {
  public native let paused: Bool;
  public native let gameTime: GameTime;
}

public native struct GameTimeWrapper {
  public native let gameTime: GameTime;
}

public native class gameTPPCustomizableAppearanceChangeFinishedEvent extends Event {}

public native struct gameTppRepAttachedObjectInfo {
  public native let slotID: TweakDBID;
  public native let itemID: TweakDBID;
}

public native class gameTPPRepresentationComponent extends IComponent {
  public native let detachedObjectInfo: array<gameFppRepDetachedObjectInfo>;
  public native let attachedObjectInfo: array<gameTppRepAttachedObjectInfo>;
  public native let affectedAppearanceSlots: array<TweakDBID>;
}

public native class gameTPPRepresentationCustomizationStateUpdater extends gameuiICustomizationStateUpdater {}

public native class gameTPPRepresentationPositionProvider extends IPositionProvider {}

public native class gameTPPRepresentationSlotListener extends AttachmentSlotsListener {}

public native struct gameTrafficLaneSpanInfo {
  public native let laneId: worldTrafficLaneUID;
  public native let laneX1: Float;
  public native let laneX2: Float;
}

public native class gameTrafficWorkspotTransitionData extends ISerializable {
  public native let workspotData: ref<SetupWorkspotActionEvent>;
  public native let returnPosition: ref<worldTrafficGlobalPathPosition>;
  public native let workspotExitTangent: Vector3;
  public native let trafficLaneReturnTangent: Vector3;
}

public native class gameTransformAnimation_BreakEffectLoop extends gameTransformAnimation_Effects {
  public native let effectTag: CName;
}

public abstract native class gameTransformAnimation_Effects extends gameTransformAnimationTrackItemImpl {}

public native class gameTransformAnimation_KillEffect extends gameTransformAnimation_Effects {
  public native let effectTag: CName;
}

public native class gameTransformAnimation_Move extends gameTransformAnimationTrackItemImpl {
  public native let startPositionEvaluator: ref<gameTransformAnimation_Position>;
  public native let targetPositionEvaluator: ref<gameTransformAnimation_Position>;
  public native let movement: ref<gameTransformAnimation_Movement>;
}

public native class gameTransformAnimation_Movement_CurveSet extends gameTransformAnimation_Movement {}

public native class gameTransformAnimation_Movement_CustomCurve extends gameTransformAnimation_Movement {
  public native let curve: CurveDataFloat;
}

public native class gameTransformAnimation_Movement_PredefinedFunction extends gameTransformAnimation_Movement {
  public native let function: EasingFunction;
}

public abstract native class gameTransformAnimation_Movement extends ISerializable {}

public native class gameTransformAnimation_MoveOnSpline extends gameTransformAnimationTrackItemImpl {
  public native let splineNode: NodeRef;
  public native let from: Float;
  public native let to: Float;
  public native let rotationMode: gameTransformAnimation_MoveOnSplineRotationMode;
  public native let movement: ref<gameTransformAnimation_Movement>;
}

public enum gameTransformAnimation_MoveOnSplineRotationMode {
  Disabled = 0,
  Yaw = 1,
  PitchAndYaw = 2,
}

public native class gameTransformAnimation_PlaySound extends gameTransformAnimationTrackItemImpl {
  public native let soundName: CName;
  public native let unique: Bool;
}

public native class gameTransformAnimation_Position_InitialPosition extends gameTransformAnimation_Position {
  public native let offset: Vector3;
  public native let offsetInWorldSpace: Bool;
}

public native class gameTransformAnimation_Position_LocalPosition extends gameTransformAnimation_Position {
  public native let position: Vector3;
}

public native class gameTransformAnimation_Position_MarkerPosition extends gameTransformAnimation_Position {
  public native let markerNode: NodeRef;
  public native let offset: Vector3;
}

public abstract native class gameTransformAnimation_Position extends ISerializable {}

public native class gameTransformAnimation_RotateFromTo extends gameTransformAnimationTrackItemImpl {
  public native let startRotationEvaluator: ref<gameTransformAnimation_Rotation>;
  public native let targetRotationEvaluator: ref<gameTransformAnimation_Rotation>;
  public native let movement: ref<gameTransformAnimation_Movement>;
}

public native class gameTransformAnimation_RotateOnAxis extends gameTransformAnimationTrackItemImpl {
  public native let axis: gameTransformAnimation_RotateOnAxisAxis;
  public native let numberOfFullRotations: Float;
  public native let startAngle: Float;
  public native let reverseDirection: Bool;
  public native let movement: ref<gameTransformAnimation_Movement>;
}

public enum gameTransformAnimation_RotateOnAxisAxis {
  X = 0,
  Y = 1,
  Z = 2,
}

public native class gameTransformAnimation_Rotation_CurrentRotation extends gameTransformAnimation_Rotation {
  public native let offset: Quaternion;
}

public native class gameTransformAnimation_Rotation_InitialRotation extends gameTransformAnimation_Rotation {}

public native class gameTransformAnimation_Rotation_LocalRotation extends gameTransformAnimation_Rotation {
  public native let rotation: Quaternion;
}

public native class gameTransformAnimation_Rotation_MarkerRotation extends gameTransformAnimation_Rotation {
  public native let markerNode: NodeRef;
  public native let offset: Vector3;
}

public abstract native class gameTransformAnimation_Rotation extends ISerializable {}

public native class gameTransformAnimation_SpawnEffect extends gameTransformAnimation_Effects {
  public native let effectName: CName;
  public native let effectTag: CName;
  public native let persistOnDetach: Bool;
}

public native struct gameTransformAnimationDefinition {
  public native let name: CName;
  public native let autoStart: Bool;
  public native let autoStartDelay: Float;
  public native let timesToPlay: Uint32;
  public native let looping: Bool;
  public native let timeScale: Float;
  public native let reverse: Bool;
  public native let timeline: gameTransformAnimationTimeline;
}

public native struct gameTransformAnimationTimeline {
  public native let items: array<gameTransformAnimationTrackItem>;
}

@neverRef()
public native class gameTransformAnimationTrackItem extends ISerializable {
  public native let impl: ref<gameTransformAnimationTrackItemImpl>;
  public native let startTime: Float;
  public native let duration: Float;
}

public abstract native class gameTransformAnimationTrackItemImpl extends ISerializable {}

public native class gameTransformAnimatorComponent extends IPlacedComponent {
  public native let animations: array<gameTransformAnimationDefinition>;
}

public native class gameTransformAnimatorSaveSystem extends gameITransformAnimatorSaveSystem {}

public native class gameTransformsHistorySystem extends gameITransformsHistorySystem {}

public enum gameTStatModifier {
  Constant = 0,
  Random = 1,
  Curve = 2,
  Combined = 3,
  Count = 4,
  Invalid = 5,
}

public native class gameuiAdvertLightColorPickerController extends inkLogicController {
  public native let lightColor: Color;
}

public native class gameuiarcadeArcadeBackgroundController extends inkLogicController {
  public native let backgroundLayerList: array<inkWidgetRef>;
}

public native struct gameuiarcadeArcadeColliderData {
  public native let type: gameuiarcadeArcadeColliderType;
  public native let shape: ref<gameuiarcadeBoundingShape>;
}

public enum gameuiarcadeArcadeColliderType {
  Body = 0,
  Up = 1,
  Right = 2,
  Bottom = 3,
  Left = 4,
}

public native class gameuiarcadeArcadeGameController extends inkGameController {
  public native let minigame: gameuiarcadeArcadeMinigame;
  public native let defaultScreenTransitionTotalTime: Float;
  public native let screenTransitionWidget: inkImageRef;
  public native let menu: inkWidgetRef;
  public native let gameplay: inkWidgetRef;
  public native let scoreboard: inkWidgetRef;
}

public abstract native class gameuiarcadeArcadeGameplayController extends gameuiarcadeIArcadeScreenController {
  public native let score: inkWidgetRef;
  public native let pauseText: inkWidgetRef;
}

public abstract native class gameuiarcadeArcadeHealthController extends inkLogicController {
  public native let widget: wref<inkWidget>;
}

public native class gameuiarcadeArcadeMenuController extends gameuiarcadeIArcadeScreenController {
  public native let startArrow: inkWidgetRef;
  public native let scoreboardArrow: inkWidgetRef;
}

public enum gameuiarcadeArcadeMinigame {
  RoachRace = 0,
  Shooter = 1,
  Tank = 2,
}

public native class gameuiarcadeArcadeObjectController extends inkLogicController {
  public native let image: inkWidgetRef;
  public native let colliderList: array<gameuiarcadeArcadeColliderData>;
}

public native class gameuiarcadeArcadeParallaxPlaneController extends inkLogicController {
  public native let displacementAxis: gameuiarcadeArcadeParallaxPlaneControllerDisplacementAxis;
  public native let loopType: gameuiarcadeArcadeParallaxPlaneControllerLoopType;
  public native let segmentList: array<inkWidgetRef>;
}

public enum gameuiarcadeArcadeParallaxPlaneControllerDisplacementAxis {
  Horizontal = 0,
  Vertical = 1,
}

public enum gameuiarcadeArcadeParallaxPlaneControllerLoopType {
  None = 0,
  Repeat = 1,
}

public native class gameuiarcadeArcadePermanentResourceManager extends ISerializable {}

public abstract native class gameuiarcadeArcadePlayerController extends inkLogicController {
  public native let colliderList: array<gameuiarcadeArcadeColliderData>;
}

public native class gameuiarcadeArcadeScoreboardController extends gameuiarcadeIArcadeScreenController {
  public native let endingPanel: inkWidgetRef;
  public native let playerCurrentScore: inkTextRef;
  public native let playerHighestScore: inkTextRef;
  public native let playerHighestScoreAlert: inkTextRef;
  public native let pressToPlayAgainText: inkWidgetRef;
  public native let scoreboardNameList: array<inkTextRef>;
  public native let scoreboardScoreList: array<inkTextRef>;
}

public native class gameuiarcadeArcadeScoreController extends inkLogicController {
  public native let scoreText: inkWidgetRef;
}

public native class gameuiarcadeArcadeSpawnerController extends inkLogicController {
  public native let objectLibraryID: CName;
  public native let initialObjectsCount: Uint32;
}

public importonly class gameuiarcadeArcadeSystem extends IGameSystem {}

@mixedRef()
public native class gameuiarcadeBoundingCircle extends gameuiarcadeBoundingShape {}

@mixedRef()
public native class gameuiarcadeBoundingRect extends gameuiarcadeBoundingShape {}

@mixedRef()
public abstract native class gameuiarcadeBoundingShape extends IScriptable {
  public native let boundingShape: inkWidgetRef;
}

public abstract native class gameuiarcadeIArcadeScreenController extends inkLogicController {}

public native class gameuiarcadeRoachRaceBackgroundController extends gameuiarcadeArcadeBackgroundController {
  public native let parallaxPlaneRelativeVelocityList: array<Float>;
  public native let daynightWidget: inkWidgetRef;
  public native let backgroundObjectSpawner: inkWidgetRef;
  public native let cloudSpawner: inkWidgetRef;
}

public native class gameuiarcadeRoachRaceCloudSpawnerController extends gameuiarcadeArcadeSpawnerController {
  public native let minCloudRelativeVelocity: Float;
  public native let maxCloudRelativeVelocity: Float;
  public native let cloudSpawnTime: Float;
}

public native class gameuiarcadeRoachRaceCollisionSystem extends IScriptable {}

public native class gameuiarcadeRoachRaceGameplayController extends gameuiarcadeArcadeGameplayController {
  public native let defaultWorldVelocity: Float;
  public native let cycleWorldVelocityMultiplier: Float;
  public native let carrotPowerupPointsPerSecond: Float;
  public native let carrotPowerupTime: Float;
  public native let carrotPowerupWorldVelocityMultiplier: Float;
  public native let collisionSFX: CName;
  public native let powerupPickupSFX: CName;
  public native let player: inkWidgetRef;
  public native let obstacleSpawner: inkWidgetRef;
  public native let background: inkWidgetRef;
  public native let currentLevelAndCycleText: inkTextRef;
  public native let pointsBoostPickupText: inkTextRef;
  public native let dummy: inkWidgetRef;
  public native let invincibilityCooldownIndicator: inkWidgetRef;
}

public enum gameuiarcadeRoachRaceObjectType {
  BoostObject_Apple = 0,
  BoostObject_Carrot = 1,
  Obstacle = 2,
}

public native class gameuiarcadeRoachRaceObstacleController extends gameuiarcadeArcadeObjectController {}

public native class gameuiarcadeRoachRaceObstacleSpawnerController extends gameuiarcadeArcadeSpawnerController {
  public native let initialMinimumSpawnTime: Float;
  public native let initialDoubleSpawnChance: Float;
  public native let spawnRateIncreasePerCycle: Float;
  public native let doubleSpawnChanceIncreasePerLevel: Float;
  public native let doubleSpawnDelay: Float;
  public native let powerupSpawnTimeDelayMultiplier: Float;
  public native let appleSpawnTime: Float;
  public native let carrotSpawnTime: Float;
}

public native class gameuiarcadeRoachRacePlayerController extends inkLogicController {
  public native let singleJumpBoost: Vector2;
  public native let doubleJumpBoost: Vector2;
  public native let gravity: Vector2;
  public native let teleportLockoutTime: Float;
  public native let carrotPowerupVelocityBoostModifier: Float;
  public native let runningBoundingRectangleRelativeSize: Vector2;
  public native let jumpingboundingRectangleRelativeSize: Vector2;
  public native let poweredupboundingRectangleRelativeSize: Vector2;
  public native let invincibilityTime: Float;
  public native let invincibilityWarningTime: Float;
  public native let roachDeathAnimationTime: Float;
  public native let roachDeathAnimationDisplacement: Float;
  public native let image: inkImageRef;
  public native let jumpSFX: CName;
  public native let doubleJumpSFX: CName;
  public native let teleportSFX: CName;
  public native let invincibilityStartSFX: CName;
  public native let invincibilityStopSFX: CName;
  public native let carrotPowerupStartSFX: CName;
  public native let carrotPowerupStopSFX: CName;
}

public native class gameuiarcadeRoachRaceSceneryObjectSpawnerController extends gameuiarcadeArcadeSpawnerController {
  public native let sceneryObjectSpawnTime: Float;
}

public native class gameuiarcadeShooterAIBase extends gameuiarcadeShooterObjectController {}

public native class gameuiarcadeShooterAIController extends gameuiarcadeShooterAIBase {}

public native class gameuiarcadeShooterAIFlyingDroneController extends gameuiarcadeShooterAIController {}

public native class gameuiarcadeShooterAIMeleeController extends gameuiarcadeShooterAIController {}

public native class gameuiarcadeShooterAINPCDroneController extends gameuiarcadeShooterAIController {}

public native class gameuiarcadeShooterAIPickUpTransporterController extends gameuiarcadeShooterAIController {}

public native class gameuiarcadeShooterAIProp extends gameuiarcadeShooterAIController {}

public native class gameuiarcadeShooterAIRangeController extends gameuiarcadeShooterAIController {}

public native class gameuiarcadeShooterAIRangeGrenadeController extends gameuiarcadeShooterAIController {}

public native class gameuiarcadeShooterAIRescueTransporterController extends gameuiarcadeShooterAIController {}

public native class gameuiarcadeShooterAISpiderDroneController extends gameuiarcadeShooterAIController {}

public native class gameuiarcadeShooterAITransporterController extends gameuiarcadeShooterAIController {}

public enum gameuiarcadeShooterAIType {
  MELEE = 0,
  RANGESHOOTER = 1,
  RANGEGRENADE = 2,
  FLYINGDRONE = 3,
  SPIDERDRONE = 4,
  POWERUPDRONE = 5,
  TRANSPORT = 6,
  VIP = 8,
  VIPPLAT = 9,
  LANDMINE = 12,
  BARREL = 13,
  NINJA = 14,
  BASILISK = 16,
  MEATHEAD = 15,
}

public native class gameuiarcadeShooterAIVIPController extends gameuiarcadeShooterAIController {}

public native class gameuiarcadeShooterArcadeScoreboardController extends gameuiarcadeArcadeScoreboardController {
  public native let scoreBackground: inkWidgetRef;
  public native let endingScoreBackground: inkWidgetRef;
  public native let playerNames: inkWidgetRef;
  public native let ranks: inkWidgetRef;
  public native let scores: inkWidgetRef;
  public native let highestScoreText: inkWidgetRef;
  public native let highScoreText: inkWidgetRef;
  public native let gameOverImage: inkImageRef;
  public native let highestScoreOriginalOffset: Vector2;
  public native let highestScoreEndingOffset: Vector2;
  public native let highScoreTextOriginalOffset: Vector2;
  public native let highScoreTextEndingOffset: Vector2;
  public native let rankScoreOriginalOffset: Vector2;
  public native let rankScoreEndingOffset: Vector2;
  public native let namesOriginalOffset: Vector2;
  public native let namesEndingOffset: Vector2;
}

public native class gameuiarcadeShooterBackgroundController extends inkLogicController {
  public native let layerInfo: array<gameuiarcadeShooterLayerInfo>;
  public native let allowMarginTranslation: Bool;
  public native let expPlatformImageDetails: array<gameuiarcadeShooterExplodingPlatformsImageWidgetDetail>;
}

public native class gameuiarcadeShooterBossBasilisk extends gameuiarcadeShooterBossController {}

public native class gameuiarcadeShooterBossController extends gameuiarcadeShooterAIBase {
  public native let customBoundSize: Bool;
  public native let bossSize: Vector2;
}

public native class gameuiarcadeShooterBossMeatHead extends gameuiarcadeShooterBossController {}

public native class gameuiarcadeShooterBossNinja extends gameuiarcadeShooterBossController {}

public native class gameuiarcadeShooterBullet extends gameuiarcadeShooterObjectController {
  public native let customBoundSize: Bool;
  public native let boundSize: Vector2;
}

public native class gameuiarcadeShooterBulletSpawnerController extends gameuiarcadeArcadeSpawnerController {}

public native class gameuiarcadeShooterCollisionController extends inkLogicController {
  public native let explosionPlatformDelay: Float;
  public native let respawnPlatformDetails: array<gameuiarcadeShooterExplodingPlatformSpawnDetail>;
}

public native struct gameuiarcadeShooterEventData {
  public native let triggerPosition: Vector2;
  public native let finalPosition: Vector2;
  public native let spawnerDataList: array<gameuiarcadeShooterEventSpawnerData>;
}

public native class gameuiarcadeShooterEventManager extends inkLogicController {
  public native let nextLevelThreshold: Vector2;
  public native let levelEndCheckDelay: Float;
  public native let eventFinishDelay: Float;
  public native let eventId: Int32;
  public native let eventList: array<gameuiarcadeShooterEventData>;
}

public native struct gameuiarcadeShooterEventSpawnerData {
  public native let dataName: CName;
  public native let targetSpawner: inkWidgetRef;
  public native let tiedSpawner: inkWidgetRef;
  public native let triggerCondition: gameuiarcadeShooterTriggerType;
  public native let delayDuration: Float;
}

public native struct gameuiarcadeShooterExplodingPlatformsImageWidgetDetail {
  public native let platformName: CName;
  public native let platformImageDetails: array<gameuiarcadeShooterPlatformImageDetail>;
}

public native struct gameuiarcadeShooterExplodingPlatformSpawnDetail {
  public native let spawnPlatformName: CName;
  public native let explodingPlatformsNames: array<CName>;
}

public native class gameuiarcadeShooterGameController extends gameuiarcadeArcadeGameController {}

public native class gameuiarcadeShooterGameplayController extends gameuiarcadeArcadeGameplayController {
  public native let player: inkWidgetRef;
  public native let hud: inkWidgetRef;
  public native let levelContainer: inkWidgetRef;
}

public native class gameuiarcadeShooterHealthController extends gameuiarcadeArcadeHealthController {}

public native class gameuiarcadeShooterHUDController extends inkLogicController {
  public native let selectedWeaponSlot: inkImageRef;
  public native let secondWeaponSlot: inkImageRef;
  public native let thirdWeaponSlot: inkImageRef;
  public native let healthContainer: inkWidgetRef;
  public native let continueText: inkWidgetRef;
  public native let continueCountdownWidget: inkImageRef;
  public native let levelName: inkImageRef;
  public native let levelNumber1: inkImageRef;
  public native let levelNumber2: inkImageRef;
  public native let levelFinishCard: inkWidgetRef;
}

public native struct gameuiarcadeShooterLayerInfo {
  public native let referenceWidget: inkWidgetRef;
  public native let planeRelativeValue: Vector2;
  public native let layerName: CName;
}

public native class gameuiarcadeShooterLevelController extends inkLogicController {
  public native let playerSpawnPoint: inkWidgetRef;
  public native let background: inkWidgetRef;
  public native let collision: inkWidgetRef;
  public native let levelType: gameuiarcadeShooterLevelType;
  public native let spawner: inkWidgetRef;
  public native let enemyBulletSpawner: inkWidgetRef;
  public native let playerBulletSpawner: inkWidgetRef;
  public native let vfxSpawner: inkWidgetRef;
  public native let mapEndBorder: Vector2;
}

public enum gameuiarcadeShooterLevelType {
  HORIZONTAL = 0,
  VERTICALUP = 1,
  VERTICALDOWN = 2,
}

public native class gameuiarcadeShooterObjectController extends gameuiarcadeArcadeObjectController {}

public native class gameuiarcadeShooterPlatformCollisionController extends inkLogicController {}

public native class gameuiarcadeShooterPlatformController extends gameuiarcadeShooterObjectController {}

public native struct gameuiarcadeShooterPlatformImageDetail {
  public native let platformImage: inkWidgetRef;
}

public native class gameuiarcadeShooterPlayerLevelTransitionController extends inkLogicController {}

public native class gameuiarcadeShooterPowerup extends gameuiarcadeShooterObjectController {}

public native class gameuiarcadeShooterSpawnController extends inkLogicController {
  public native let enemyType: gameuiarcadeShooterAIType;
  public native let spawnCondition: gameuiarcadeShooterSpawnerCondition;
  public native let spawnDelay: Float;
  public native let spawnCount: Uint32;
  public native let offScreenSpawnExpiryTime: Float;
  public native let skippable: Bool;
  public native let skipOffset: Float;
  public native let awaitPreviousUnitDead: Bool;
  public native let enemyParameter: String;
}

public enum gameuiarcadeShooterSpawnerCondition {
  ScreenLeft = 0,
  ScreenRight = 1,
  ScreenTop = 2,
  ScreenBottom = 3,
  EventTrigger = 4,
}

public native class gameuiarcadeShooterSpawnerController extends gameuiarcadeArcadeSpawnerController {}

public native struct gameuiarcadeShooterTransporterSpawnData {
  public native let aiType: gameuiarcadeShooterAIType;
  public native let parameter: CName;
  public native let count: Int32;
}

public native class gameuiarcadeShooterTransporterSpawnerController extends inkLogicController {
  public native let spawnDelay: Float;
  public native let isRandomSpawn: Bool;
  public native let choosenMounts: array<gameuiarcadeShooterTransporterSpawnData>;
  public native let choosenOnes: array<gameuiarcadeShooterTransporterSpawnData>;
}

public native class gameuiarcadeShooterTraumaMemberController extends gameuiarcadeShooterObjectController {
  public native let baseFollowDelay: Float;
}

public enum gameuiarcadeShooterTriggerType {
  Delay = 0,
  SpawnerFinish = 1,
  SpawnerObjectsDeath = 2,
}

public native class gameuiarcadeShooterVFXController extends gameuiarcadeShooterObjectController {}

public native class gameuiarcadeShooterVFXSpawnerController extends gameuiarcadeArcadeSpawnerController {}

public native class gameuiarcadeTankBackgroundController extends gameuiarcadeArcadeBackgroundController {
  public native let decorationSpawner: inkWidgetRef;
}

public native class gameuiarcadeTankCounterHUDController extends inkLogicController {
  public native let counterText: inkTextRef;
}

public native class gameuiarcadeTankDecorationSpawnerController extends gameuiarcadeArcadeSpawnerController {}

public native class gameuiarcadeTankDestroyableObjectController extends gameuiarcadeArcadeObjectController {}

public native class gameuiarcadeTankEnemyController extends gameuiarcadeTankDestroyableObjectController {
  public native let headParent: inkWidgetRef;
  public native let head: inkWidgetRef;
}

public enum gameuiarcadeTankEnemyMovementType {
  x_axis = 0,
  x_axisL = 1,
  x_axisR = 2,
  y_axis = 3,
}

public native class gameuiarcadeTankEnemySpawnerController extends gameuiarcadeArcadeSpawnerController {}

public native class gameuiarcadeTankGameplayController extends gameuiarcadeArcadeGameplayController {
  public native let player: inkWidgetRef;
  public native let enemySpawner: inkWidgetRef;
  public native let obstacleSpawner: inkWidgetRef;
  public native let pickupSpawner: inkWidgetRef;
  public native let projectileSpawner: inkWidgetRef;
  public native let background: inkWidgetRef;
  public native let hudCounter: inkWidgetRef;
  public native let hudScoreMultiplier: inkWidgetRef;
}

public native class gameuiarcadeTankObstacleSpawnerController extends gameuiarcadeArcadeSpawnerController {}

public native class gameuiarcadeTankPickupController extends gameuiarcadeArcadeObjectController {
  public native let pickup: inkWidgetRef;
  public native let pickupText: inkWidgetRef;
}

public native class gameuiarcadeTankPickupSpawnerController extends gameuiarcadeArcadeSpawnerController {}

public enum gameuiarcadeTankPickupType {
  Patch_Kit = 0,
  AEAMS = 1,
  Mini_Tank = 2,
  Pile_of_Eddies = 3,
  Pile_of_Guns = 4,
}

public native class gameuiarcadeTankPlayerAEAMSController extends inkLogicController {}

public native class gameuiarcadeTankPlayerController extends gameuiarcadeArcadePlayerController {
  public native let avatarRef: inkWidgetRef;
  public native let health: inkWidgetRef;
  public native let lives: inkWidgetRef;
  public native let aeams: inkWidgetRef;
  public native let projectileSpawner: inkWidgetRef;
}

public native class gameuiarcadeTankPlayerHealthController extends inkLogicController {
  public native let health: inkWidgetRef;
}

public native class gameuiarcadeTankPlayerLivesController extends inkLogicController {}

public native class gameuiarcadeTankProjectileController extends gameuiarcadeArcadeObjectController {}

public native class gameuiarcadeTankProjectileSpawnerController extends gameuiarcadeArcadeSpawnerController {}

public native class gameuiarcadeTankScoreMultiplierHUDController extends inkLogicController {
  public native let scoreMultiplierBarFill: inkImageRef;
}

public native class gameuiAttachmentSlotsListener extends AttachmentSlotsListener {}

public native class gameuiAugmentedRealitySignGameController extends inkGameController {}

public enum gameuiBaseMenuGameControllerPuppetGenderInfo {
  Male = 0,
  Female = 1,
  ShouldBeDetermined = 2,
}

public native struct gameuiBaseMenuGameControllerPuppetSceneInfo {
  public native let sceneName: CName;
  public native let markerRef: NodeRef;
  public native let prefabRef: NodeRef;
  public native let entityTemplate: ResourceAsyncRef; // raRef<entEntityTemplate>
  public native let puppetRecordId: TweakDBID;
  public native let gender: gameuiBaseMenuGameControllerPuppetGenderInfo;
}

public enum gameuiBinkVideoStatus {
  Idle = 0,
  NotStarted = 1,
  Initializing = 2,
  Playing = 3,
  Finished = 4,
  OutOfFrustum = 5,
  Stopped = 6,
  Error = 7,
}

public native class gameuiBodyControllerCustomizationStateUpdater extends gameuiICustomizationStateUpdater {}

public native class gameuiBodyPartsControllerCustomizationStateUpdater extends gameuiICustomizationStateUpdater {}

public native class gameuiBriefingGameController extends inkGameController {
  public native let briefingPlayerType: questBriefingPlayerType;
}

public native struct gameuiCensorshipInfo {
  public native let censorFlag: Uint32; // CensorshipFlags
  public native let censorFlagAction: gameuiCharacterCustomizationActionType;
}

public enum gameuiCharacterCustomization_BrokenNoseStage {
  CCBN_Disabled = 0,
  CCBN_Stage1 = 1,
  CCBN_Stage2 = 2,
  CCBN_FinalScene = 3,
}

public native struct gameuiCharacterCustomizationAction {
  public native let type: gameuiCharacterCustomizationActionType;
  public native let params: String;
  public native let applyToUISlot: Bool;
  public native let applyImmediately: Bool;
}

public enum gameuiCharacterCustomizationActionType {
  Activate = 0,
  Deactivate = 1,
  EquipItem = 2,
  UnequipItem = 3,
  Refresh = 4,
}

public native class gameuiCharacterCustomizationArmCyberwareController extends gameuiCharacterCustomizationBodyPartsController {
  public native let defaultGroupName: CName;
  public native let additionalCyberArmAppearances: array<ResourceAsyncRef>;
}

public native class gameuiCharacterCustomizationBeardController extends gameuiCharacterCustomizationHeadPartsController {}

public native class gameuiCharacterCustomizationBodyController extends gameuiICharacterCustomizationBodyController {}

public abstract native class gameuiCharacterCustomizationBodyPartsController extends gameuiICharacterCustomizationBodyPartsController {
  public native let isHiddenInFpp: Bool;
}

public native class gameuiCharacterCustomizationBrokenNoseController extends gameuiICharacterCustomizationComponent {
  public native let stage1App: gameuiCharacterCustomizationBrokenNoseControllerBrokenNoseAppearance;
  public native let stage2App: gameuiCharacterCustomizationBrokenNoseControllerBrokenNoseAppearance;
  public native let finalSceneGroup: CName;
}

public native struct gameuiCharacterCustomizationBrokenNoseControllerBrokenNoseAppearance {
  public native let resource: ResourceAsyncRef; // raRef<appearanceAppearanceResource>
  public native let definition: CName;
}

public native class gameuiCharacterCustomizationFaceController extends gameuiCharacterCustomizationHeadPartsController {}

public native class gameuiCharacterCustomizationFeetController extends gameuiCharacterCustomizationBodyPartsController {
  public native let liftedFeetGroupName: CName;
  public native let flatFeetGroupName: CName;
}

public native class gameuiCharacterCustomizationGenitalsController extends gameuiCharacterCustomizationBodyPartsController {
  public native let upperBodyGroupName: CName;
  public native let bottomBodyGroupName: CName;
  public native let forceHideGenitals: Bool;
}

public native class gameuiCharacterCustomizationHairstyleController extends gameuiCharacterCustomizationHeadPartsController {}

public abstract native class gameuiCharacterCustomizationHeadPartsController extends gameuiCharacterCustomizationBodyPartsController {
  public native let groupName: CName;
}

public native class gameuiCharacterCustomizationInfoResource extends CResource {
  public native let version: Uint32;
  public native let headCustomizationOptions: array<ref<gameuiCharacterCustomizationInfo>>;
  public native let bodyCustomizationOptions: array<ref<gameuiCharacterCustomizationInfo>>;
  public native let armsCustomizationOptions: array<ref<gameuiCharacterCustomizationInfo>>;
  public native let armsGroups: array<gameuiOptionsGroup>;
  public native let headGroups: array<gameuiOptionsGroup>;
  public native let bodyGroups: array<gameuiOptionsGroup>;
  public native let perspectiveInfo: array<gameuiPerspectiveInfo>;
  public native let uiPresets: array<gameuiCharacterCustomizationUiPresetInfo>;
  public native let excludedFromRandomize: array<CName>;
  public native let versionUpdateInfo: array<gameuiCharacterCustomizationVersionUpdateInfo>;
}

public native class gameuiCharacterCustomizationNailsController extends gameuiCharacterCustomizationBodyPartsController {
  public native let nailsGroupName: CName;
}

public native class gameuiCharacterCustomizationOptionImpl extends CharacterCustomizationOption {}

public native struct gameuiCharacterCustomizationOptionVersionPrereq {
  public native let optionName: CName;
  public native let definitionName: CName;
}

public native struct gameuiCharacterCustomizationOptionVersionUpdateInfo {
  public native let curOptionNames: array<CName>;
  public native let curDefintionName: CName;
  public native let optionPrereqs: array<gameuiCharacterCustomizationOptionVersionPrereq>;
  public native let newOptionName: CName;
  public native let newDefinitionName: CName;
  public native let replaceCurOption: Bool;
}

public native class gameuiCharacterCustomizationPersonalLinkController extends gameuiICharacterCustomizationComponent {
  public native let simpleLinkGroup: CName;
}

public native class gameuiCharacterCustomizationPreset extends CResource {
  public native let isMale: Bool;
  public native let bodyGroups: array<gameuiCustomizationGroup>;
  public native let headGroups: array<gameuiCustomizationGroup>;
  public native let armsGroups: array<gameuiCustomizationGroup>;
  public native let perspectiveInfo: array<gameuiPerspectiveInfo>;
  public native let tags: redTagList;
  public native let version: Uint32;
}

public native class gameuiCharacterCustomizationState extends gameuiICharacterCustomizationState {}

public importonly class gameuiCharacterCustomizationSystem extends gameuiICharacterCustomizationSystem {}

public native class gameuiCharacterCustomizationUiPreset extends CResource {
  public native let isMaleVO: Bool;
  public native let values: array<gameuiCharacterCustomizationUiPresetValue>;
}

public native struct gameuiCharacterCustomizationUiPresetInfo {
  public native let name: CName;
  public native let resource: ResourceAsyncRef; // raRef<gameuiCharacterCustomizationUiPreset>
}

public native struct gameuiCharacterCustomizationUiPresetValue {
  public native let optionName: CName;
  public native let isActive: Bool;
  public native let value: Uint32;
}

public native struct gameuiCharacterCustomizationVersionUpdateInfo {
  public native let newVersion: Uint32;
  public native let optionUpdates: array<gameuiCharacterCustomizationOptionVersionUpdateInfo>;
}

public native struct gameuiCharacterRandomizationInfo {
  public native let minRating: Uint32;
  public native let maxRating: Uint32;
}

public native class gameuiCharacterReplicaInitializedEvent extends Event {}

public enum gameuiChoiceIndicatorType {
  Default = 0,
  Speech = 1,
  Call = 2,
  Arrow = 3,
  Hand = 4,
  Loot = 5,
  Quest = 6,
  FastTravel = 7,
  Solo = 9,
  Netrunner = 10,
  Techie = 12,
}

public enum gameuiChoiceListVisualizerType {
  Interaction = 0,
  Dialog = 1,
}

public native class gameuiCompassWidgetGameController extends inkHUDGameController {
  public native let compassWidget: inkWidgetRef;
}

public native class gameuiCreditsPositionController extends inkLogicController {
  public native let titleText: inkTextRef;
  public native let namesText: inkTextRef;
}

public native class gameuiCreditsSectionController extends inkLogicController {
  public native let sectionName: inkTextRef;
}

public native struct gameuiCustomizationGroup {
  public native let name: CName;
  public native let customization: array<gameuiCustomizationAppearance>;
  public native let morphs: array<gameuiCustomizationMorph>;
}

public enum gameuiCyberspaceElementType {
  CyberspaceNPC = 0,
  CyberspaceFakeObject = 1,
}

public native class gameuiCyberspaceUIObject extends GameObject {
  public native let slotName: CName;
  public native let mappinType: gameuiCyberspaceElementType;
  public native let caption: String;
}

public native class gameuiDelayedNextVOEvt extends Event {}

public native class gameuiDialogListChoiceVisualizer extends gameuiIChoiceVisualizer {}

public native struct gameuiDistrictTriggerData {
  public native let district: gamedataDistrict;
  public native let triggerName: CName;
}

public enum gameuiEIconOrientation {
  Upright = 0,
  Entity = 1,
}

public native class gameuiEntityPreviewGameObject extends GameObject {
  public native let cameraSettings: inkEntityPreviewCameraSettings;
}

public native struct gameuiForcePlayerCustomizationData {
  public native let customizationPart: gameuiCharacterCustomizationPart;
  public native let uiSlot: CName;
  public native let index: Uint32;
  public native let partUiSlot: CName;
  public native let partIndex: Uint32;
  public native let definitionUiSlot: CName;
  public native let definition: CName;
}

public native class gameuiFPSCounterGameController extends inkHUDGameController {
  public native let counterWidget: inkTextRef;
}

public native class gameuiGameVersionTextController extends inkLogicController {
  public native let gameVersionText: inkTextRef;
  public native let expansionWrapper: inkCompoundRef;
  public native let fluffWrapper: inkCompoundRef;
}

public native struct gameuiGarmentSwitchEffectController {
  public native let sceneName: CName;
  public native let effectName: CName;
  public native let switchTime: Float;
  public native let hideTime: Float;
}

public enum gameuiGenericNotificationType {
  Generic = 0,
  QuestUpdate = 1,
  Vendor = 3,
  ZoneAlert = 4,
  VehicleAlert = 5,
  PreventionBounty = 6,
  ProgressionView = 7,
}

public native class gameuiGlobaltvWidgetGameController extends inkGameController {
  public native let overlayContainer: inkCompoundRef;
}

public native class gameuiGPSGameController extends inkHUDGameController {
  public native let gpsSettings: GPSSettings;
}

public native class gameuiGridDataFillFinished extends Event {}

public native class gameuiHackingMinigameLogicController extends inkLogicController {
  public native let grid: inkUniformGridRef;
  public native let buffer: inkCompoundRef;
  public native let programs: inkCompoundRef;
  public native let timer: inkTextRef;
  public native let timerProgressBar: inkWidgetRef;
  public native let timerContainer: inkWidgetRef;
  public native let timerPlaceholder: inkWidgetRef;
  public native let accessInformationText: inkTextRef;
  public native let activatedTraps: inkCompoundRef;
  public native let gridVerticalHiglight: inkWidgetRef;
  public native let gridHorizontalHiglight: inkWidgetRef;
  public native let programsColumnHiglight: inkWidgetRef;
  public native let successScreenWidget: inkCompoundRef;
  public native let failScreenWidget: inkCompoundRef;
  public native let successExitTerminalText: inkTextRef;
  public native let failedExitTerminalText: inkTextRef;
  public native let successExitButton: inkWidgetRef;
  public native let failureExitButton: inkWidgetRef;
  public native let resetButton: inkWidgetRef;
  public native let introAnimName: CName;
  public native let loopAnimName: CName;
  public native let cursorAnimName: CName;
  public native let higlightAnimName: CName;
  public native let gameWonAnimName: CName;
  public native let gameLostAnimName: CName;
  public native let terminalShutdownAnimName: CName;
  public native let trapActivatedAnimName: CName;
  public native let programSucceedAnimName: CName;
  public native let programFailedAnimName: CName;
  public native let programResetFromFailedAnimName: CName;
  public native let gridCellHoverAnimName: CName;
  public native let gridCellClickFlashAnimName: CName;
  public native let bufferCellHoverAnimName: CName;
  public native let bufferCellClickFlashAnimName: CName;
  public native let programCellClickFlashAnimName: CName;
  public native let activatedTrapIconLibraryName: CName;
  public native let bufferCellLibraryName: CName;
  public native let programCellLibraryName: CName;
  public native let gridCellLibraryName: CName;
  public native let programEntryLibraryName: CName;
  public native let trapIconsContainerRelativePath: CName;
  public native let bufferCellTextWidgetRelativePath: CName;
  public native let programCellTextWidgetRelativePath: CName;
  public native let gridCellTrapIconWidgetRelativePath: CName;
  public native let gridCellTrapIconContainerRelativePath: CName;
  public native let gridCellTextWidgetRelativePath: CName;
  public native let gridCellProgramHighlightRelativePath: CName;
  public native let programEntryTextWidgetRelativePath: CName;
  public native let programEntryNoteWidgetRelativePath: CName;
  public native let programEntryInstructionContainerRelativePath: CName;
  public native let programEntryIconPath: CName;
  public native let cursorWidgetRelativePath: CName;
  public native let gridCellDefaultStateName: CName;
  public native let gridCellHoveredStateName: CName;
  public native let gridCellSelectedStateName: CName;
  public native let gridCellDisabledStateName: CName;
  public native let programSucceedStateName: CName;
  public native let programFailedStateName: CName;
  public native let programCellReadyStateName: CName;
  public native let programCellHighlightStateName: CName;
  public native let mainHiglightBarStateName: CName;
  public native let secondaryHiglightBarStateName: CName;
  public native let inactiveHiglightBarStateName: CName;
  public native let gridCellDisabledSymbol: String;
}

public native class gameuiHolocallCameraComponent extends entRenderToTextureCameraComponent {}

public native struct gameuiHudScalingSensitiveWidget {
  public native let widget: inkWidgetRef;
  public native let adjustScale: Bool;
  public native let adjustTranslation: Bool;
  public native let adjustMargin: Bool;
  public native let targetMarginAtDoubleScale: inkMargin;
  public native let marginToScalecorrectOverride: inkMargin;
}

public native class gameuiHUDVideoPlayerController extends inkHUDGameController {
  public native let playOnHud: Bool;
}

public native struct gameuiHUDVideoStartEvent {
  public native let videoPathHash: Uint64;
  public native let playOnHud: Bool;
  public native let fullScreen: Bool;
  public native let useFullscreenVideoState: Bool;
  public native let keepWidescreenAspectRatio: Bool;
  public native let position: Vector2;
  public native let size: Vector2;
  public native let skippable: Bool;
  public native let isLooped: Bool;
  public native let forceVideoFrameRate: Bool;
}

public native struct gameuiHUDVideoStopEvent {
  public native let videoPathHash: Uint64;
  public native let isSkip: Bool;
}

public abstract native class gameuiICharacterCustomizationBodyController extends gameuiICharacterCustomizationComponent {}

public abstract native class gameuiICharacterCustomizationBodyPartsController extends gameuiICharacterCustomizationComponent {}

public abstract native class gameuiICharacterCustomizationComponent extends IComponent {}

public abstract native class gameuiIChoiceVisualizer extends ISerializable {}

public abstract native class gameuiICustomizationStateUpdater extends IScriptable {}

public native class gameuiInGameCharacterCustomizationPuppetAttachmentSlotsListener extends AttachmentSlotsListener {}

public native struct gameuiInGameMenuGameControllerItemSceneInfo {
  public native let sceneName: CName;
  public native let puppetSceneName: CName;
  public native let prefabRef: NodeRef;
  public native let markerRef: NodeRef;
}

public native class gameuiInGameMenuGameCustomizationStateUpdater extends gameuiICustomizationStateUpdater {}

public native class gameuiInkChoiceVisualizer extends gameuiIChoiceVisualizer {
  public native let isDynamic: Bool;
  public native let type: gameuiChoiceListVisualizerType;
}

public native class gameuiItemDataSourceListener extends InventoryListener {}

public abstract native class gameuiIUIObjectsLoaderSystemListener extends ISerializable {}

public native class gameuiLootVisualizer extends gameuiIChoiceVisualizer {}

public native class gameuiNewsFeedDataProvider extends IScriptable {
  public native let newsTitleTweak: TweakDBID;
  public native let randomNewsFeedPack: TweakDBID;
}

public native class gameuiNewsFeedDisplayController extends inkLogicController {
  public native let newsTitleWidget: inkTextRef;
  public native let randomNewsLibraryWidget: CName;
  public native let randomNewsContainer: inkCompoundRef;
}

public native class gameuiOnscreenVOPlayerController extends inkGameController {
  public native let subtitlesContainer: inkCompoundRef;
  public native let subtitlesLibraryResource: ResourceAsyncRef; // raRef<inkWidgetLibraryResource>
  public native let subtitlesRootName: CName;
  public native let audioVOList: array<gameuiVOWithDelay>;
}

public native struct gameuiOptionsGroup {
  public native let name: CName;
  public native let options: array<CName>;
}

public native class gameuiPersonalLinkControllerCustomizationStateUpdater extends gameuiICustomizationStateUpdater {}

public native struct gameuiPerspectiveInfo {
  public native let name: CName;
  public native let fpp: CName;
  public native let tpp: CName;
}

public native class gameuiPreGamePuppetAttachmentSlotsListener extends AttachmentSlotsListener {}

public native class gameuiPuppetAttachmentSlotsListener extends AttachmentSlotsListener {}

public native struct gameuiPuppetPreviewCameraController {
  public native let cameraSetup: array<gameuiPuppetPreviewCameraSetup>;
  public native let activeSetup: Uint32;
  public native let transitionDelay: Float;
}

public native struct gameuiPuppetPreviewCameraSetup {
  public native let slotName: CName;
  public native let cameraZoom: Float;
  public native let interpolationTime: Float;
}

public native class gameuiRandomNewsFeedAnimator extends inkLogicController {
  public native let textWidget: inkTextRef;
  public native let animDuration: Float;
}

public native struct gameuiResolutionSensitiveWidget {
  public native let widget: inkWidgetRef;
  public native let marginToScalecorrectOverride: inkMargin;
}

public native struct gameuiRoadEditorDecorationSettings {
  public native let libraryName: CName;
  public native let offset: Float;
  public native let repeatPatternDensity: Uint32;
  public native let repeatPatternStartOffset: Uint32;
}

public native struct gameuiRoadEditorObstacleSettings {
  public native let libraryName: CName;
  public native let offset: Float;
  public native let speed: Float;
  public native let segmentOffset: Uint32;
}

public native struct gameuiRoadEditorSegment {
  public native let length: Uint32;
  public native let curve: Float;
  public native let hasCheckpoint: Bool;
  public native let obstacleSettings: array<gameuiRoadEditorObstacleSettings>;
  public native let decorationSettings: array<gameuiRoadEditorDecorationSettings>;
}

public native class gameuiRootHudGameController extends inkGameController {
  public native let resolutionSensitiveRoots: array<inkCompoundRef>;
}

public native class gameuiRootHudSaveData extends ISerializable {
  public native let entriesVisibility: array<questHUDEntryVisibilityData>;
}

public native class gameuiScreenAreaMultiplierChangeEvent extends Event {
  public native let screenAreaMultiplier: Float;
}

public native class gameuiSetCharacterCreationDataRequest extends PlayerScriptableSystemRequest {
  public native let lifepath: TweakDBID;
  public native let attributes: array<CharacterCustomizationAttribute>;
}

public native class gameuiSpawnNewFeedEvent extends Event {}

public native class gameuiStaticIconLogicController extends gameuiDynamicIconLogicController {
  public native let iconReference: TweakDBID;
}

public native class gameuiTextureMaxMipBiasChangeEvent extends Event {
  public native let textureMaxMipBias: Uint32;
}

public native class gameuiTextureMinMipBiasChangeEvent extends Event {
  public native let textureMinMipBias: Uint32;
}

public native class gameuiTooltipSlotData extends inkUserData {
  public native let margin: inkMargin;
  public native let placement: gameuiETooltipPlacement;
}

public native class gameuiTrialPeriodTimerController extends inkGenericSystemNotificationLogicController {
  public native let timerText: inkTextRef;
}

public native class gameuiTutorialAreaDespawnEvent extends Event {
  public native let bracketID: CName;
  public native let areaID: Uint32;
}

public native class gameuiTutorialAreaSpawnEvent extends Event {
  public native let bracketID: CName;
  public native let areaID: Uint32;
  public native let widget: wref<inkWidget>;
}

public native class gameuiTutorialBracketHideEvent extends Event {
  public native let bracketID: CName;
}

public native class gameuiTutorialBracketShowEvent extends Event {
  public native let data: TutorialBracketData;
}

public native class gameuiTutorialOverlayHideEvent extends Event {
  public native let itemName: CName;
}

public native class gameuiTutorialOverlayShowEvent extends Event {
  public native let itemName: CName;
}

public native class gameuiUIGameState extends ISerializable {
  public native let uiData: array<ref<gameuiBaseUIData>>;
}

public native class gameuiUIObjectsLoaderSystem extends gameuiIUIObjectsLoaderSystem {}

public native struct gameuiVOWithDelay {
  public native let playDelay: Float;
  public native let voHexID: String;
}

public native class gameuiWorldMapGameObject extends GameObject {
  public native let districts: array<gameuiDistrictTriggerData>;
}

public native class gameuiWorldMapUpdateGroupsEvent extends Event {}

public native class gameUniqueItemData extends gameItemData {}

public enum gameVehicleCommonCurve {
  RPMLimit = 0,
  ForcedBrakeForce = 1,
  COUNT = 2,
}

public native class gameVehicleCommonCurveSet extends CurveSet {}

public enum gameVehicleCurve {
  SpeedToWheelMaxTurn = 0,
  InputToWheelMaxTurn = 1,
  SpeedToWheelTurnSpeed = 2,
  InputToWheelTurnSpeed = 3,
  COUNT = 4,
}

public native class gameVehicleCurveSet extends CurveSet {}

public native class gameVehicleCurvesLibrary extends Entity {
  public native let curves: array<ResourceRef>;
  public native let commonCurves: array<ResourceRef>;
  public native let bikeCurves: array<ResourceRef>;
}

public native struct gameVehicleDynamicSpawnLogic {}

public native class gameVehicleMeleeCleaveEvent extends Event {
  public native let attackData: ref<AttackData>;
  public native let hitPosition: Vector4;
  public native let hitDirection: Vector4;
  public native let hitComponent: wref<IPlacedComponent>;
}

public native class gameVisionActivatorComponent extends IComponent {}

public native class gameVisionAppearanceForcedEvent extends Event {
  public native let state: Bool;
}

public importonly class gameVisionModeActivationEvent extends Event {
  public native let activate: Bool;
}

public native class gameVisionModePrereq extends IPrereq {
  public native let type: gameVisionModeType;
}

public native class gameVisionModePrereqState extends PrereqState {}

@neverRef()
public native class gameVisualTagsAppearanceNamesPreset_Entity extends ISerializable {
  public native let entityPathHash: Uint64;
  public native let debugEntityPath: CName;
  public native let tagsToAppearances: array<gameVisualTagsAppearanceNamesPreset_TagsAppearances>;
}

@neverRef()
public native class gameVisualTagsAppearanceNamesPreset_TagsAppearances extends ISerializable {
  public native let visualTagHash: CName;
  public native let appearanceNames: array<CName>;
}

public native class gameVisualTagsAppearanceNamesPreset extends ISerializable {
  public native let presets: array<gameVisualTagsAppearanceNamesPreset_Entity>;
}

public native class gamewatchdogSystem extends IWatchdogSystem {}

public native class gameWaypoint extends worldIMarker {}

public native struct gameWeakSpotReplicatedInfo {
  public native let weakSpotRecordID: Uint64;
  public native let wsHealthValue: Float;
  public native let LastDamageInstigator: wref<gamePuppet>;
}

public native class gameWeaponAudio extends ISerializable {}

public native class gameWeaponAudioComponent extends SoundComponentBase {}

public native class gameweaponeventsRequestAmmoChange extends Event {}

public native class gameweaponeventsShootEvent extends Event {}

public native class gameweaponeventsStopFiringEvent extends Event {}

public native struct gameWeaponReplicationHistory {
  public native let weaponSlot: TweakDBID;
  public native let shots: [gameReplicatedShotData; 8];
  public native let latestShotId: Uint32;
  public native let continuousAttack: gameReplicatedContinuousAttack;
}

public native struct gameWeaponsReplicatedState {}

public native class gameWorldBoundaryNode extends worldAreaShapeNode {}

public native class gameWorldBoundaryNodeInstance extends worldAreaShapeNodeInstance {}

public native class gameWorldBoundarySystem extends gameIWorldBoundarySystem {}

public native class gameWorldSpaceBlendCamera extends entCameraComponent {}

public importonly class GarageComponent extends GameComponent {}

public importonly class GarageComponentPS extends GameComponentPS {
  public native persistent let spawnedVehiclesData: array<vehicleGarageComponentVehicleData>;
  public native persistent let unregisteredVehiclesData: array<vehicleGarageComponentVehicleData>;
  public native persistent let unlockedVehicles: array<GarageVehicleID>;
  public native persistent let unlockedVehicleArray: array<vehicleUnlockedVehicle>;
  public native persistent let uiFavoritedVehicles: array<GarageVehicleID>;
  public native persistent let activeVehicles: [GarageVehicleID; 3];
  public native persistent let mountedVehicleData: vehicleGarageComponentVehicleData;
  public native persistent let mountedVehicleStolen: Bool;
}

public native struct garmentBendingParams {
  public native let bendPowerOffsetInCM: Float;
}

public native struct garmentCollarAreaParams {
  public native let enable: Bool;
  public native let radiusInCM: Float;
  public native let radiusForTriangleRemovalInCM: Float;
  public native let offsetFromSkinInCM: Float;
  public native let offset: Vector3;
}

public native class garmentGarmentLayerParams extends CResource {
  public native let bending: garmentBendingParams;
  public native let smoothing: garmentSmoothingParams;
  public native let collarArea: garmentCollarAreaParams;
  public native let hiddenTrianglesRemoval: garmentHiddenTrianglesRemovalParams;
}

public native struct garmentHiddenTrianglesRemovalParams {
  public native let garmentBorderThreshold: Float;
  public native let removeHiddenTriangles: Bool;
  public native let removeHiddenTrianglesRasterization: Bool;
  public native let rayLengthInCM: Float;
  public native let rayLengthMorphOffsetFactor: Float;
}

public native class garmentMeshParamGarment extends meshMeshParameter {
  public native let chunks: array<garmentMeshParamGarmentChunkData>;
}

public native struct garmentMeshParamGarmentChunkData {
  public native let numVertices: Uint32;
  public native let lodMask: Uint8;
  public native let isTwoSided: Bool;
}

public native struct garmentSmoothingParams {
  public native let smoothingStrength: Float;
  public native let smoothingRadiusInCM: Float;
  public native let smoothingExponent: Float;
  public native let smoothingNumNeighbours: Uint32;
  public native let smoothNormalsEnabled: Bool;
}

public native class genLevelRandomizer extends GameObject {
  public native let entries: array<genLevelRandomizerEntry>;
  public native let seed: Uint32;
  public native let dataSource: genLevelRandomizerDataSource;
  public native let supervisorType: CName;
  public native let debugSpawnAll: Bool;
}

public enum genLevelRandomizerDataSource {
  Entries = 0,
  Markers = 1,
}

public native struct genLevelRandomizerEntry {
  public native let id: String;
  public native let templateName: CName;
  public native let spawnPos: NodeRef;
  public native let probability: Float;
}

public native class genNullRandomizationSupervisor extends IRandomizationSupervisor {}

public native class genRandomizerMarker extends worldIMarker {
  public native let id: String;
  public native let templateName: CName;
  public native let probability: Float;
}

public native class GeometryShape extends ISerializable {
  public native let vertices: array<Vector3>;
  public native let indices: array<Uint16>;
  public native let faces: array<GeometryShapeFace>;
}

public native struct GeometryShapeFace {
  public native let indices: array<Uint32>;
}

public native class GICGIEditSettings extends ISerializable {}

public enum GIGIOverrideType {
  Default = 0,
  Override_True = 1,
  Override_False = 2,
}

public native class GlobalIlluminationSettings extends IAreaSettings {
  public native let multiBouceScale: CurveDataFloat;
  public native let multiBouceSaturation: CurveDataFloat;
  public native let emissiveScale: CurveDataFloat;
  public native let diffuseScale: CurveDataFloat;
  public native let localLightsScale: CurveDataFloat;
  public native let lightScaleCompenensation: CurveDataFloat;
  public native let reflectionCompensation: CurveDataFloat;
  public native let ambientBase: CurveDataHDRColor;
  public native let rayTracedSkyRadianceScale: CurveDataFloat;
}

public native struct GlobalLightingTrajectory {
  public native let latitude: Float;
  public native let sunRotationOffset: Float;
  public native let moonRotationOffset: Float;
  public native let timeOfYearSeason: ETimeOfYearSeason;
}

public native struct GlobalLightingTrajectoryOverride {
  public native let overrideScale: Float;
  public native let latitude: Float;
  public native let sunRotationOffset: Float;
  public native let moonRotationOffset: Float;
  public native let timeOfYearSeason: ETimeOfYearSeason;
}

public native class GlobalLightOverrideAreaSettings extends IAreaSettings {
  public native let color: CurveDataHDRColor;
  public native let lightAzimuth: Float;
  public native let lightElevation: Float;
}

public native struct GodModeData {
  public native let type: gameGodModeType;
  public native let source: CName;
}

public native struct GodModeEntityData {
  public native let overrides: array<GodModeData>;
  public native let base: array<GodModeData>;
}

public native struct GPSSettings {
  public native let lineEffectOnFoot: ResourceAsyncRef; // raRef<worldEffect>
  public native let lineEffectVehicle: ResourceAsyncRef; // raRef<worldEffect>
  public native let fixedPathOffset: Vector3;
  public native let fixedPortalMappinOffset: Vector3;
  public native let pathRefreshTimeInterval: Float;
  public native let lastPlayerNavmeshPositionRefreshTimeIntervalSecs: Float;
  public native let maxPathDisplayLength: Float;
}

public native class GPSSystem extends IGPSSystem {}

public enum GpuApieBufferUsageType {
  BUT_Default = 0,
  BUT_Immutable = 1,
  BUT_Readback = 2,
  BUT_Dynamic_Legacy = 3,
  BUT_Transient = 4,
  BUT_Mapped = 5,
  BUT_MAX = 6,
}

public enum GpuWrapApiBufferGroup {
  System = 0,
  MeshResource = 1,
  MeshCustom = 2,
  AutoSpawner = 3,
  Debug = 4,
  DPL = 5,
  Weather = 6,
  ReflectionProbe = 7,
  Skinning = 8,
  Lights = 9,
  Video = 10,
  Particles = 11,
  GIManagerLitProbes = 12,
  GIManagerLookup = 13,
  GIManagerInterpolation = 14,
  GIManagerLitBricks = 15,
  GIManagerLights = 16,
  GIManagerEnvVolume = 17,
  GIProxyBrick = 18,
  GIProxySurfel = 19,
  GIProxyProbes = 20,
  GIProxyFactors = 21,
  GIProxyAcceleration = 22,
  Raytracing = 23,
  RaytracingUpload = 24,
  RaytracingAS = 25,
  RaytracingOMM = 26,
  Decals = 27,
  Instances = 28,
  Materials = 29,
  Multilayer = 30,
  FrameResources = 31,
  Misc = 32,
  MorphTargets = 33,
  MAX = 34,
}

public enum GpuWrapApieBufferChunkCategory {
  BCC_Staging = 0,
  BCC_Vertex = 1,
  BCC_VertexUAV = 2,
  BCC_Index16Bit = 3,
  BCC_Index32Bit = 4,
  BCC_VertexIndex16Bit = 5,
  BCC_Constant = 6,
  BCC_TypedUAV = 7,
  BCC_Structured = 8,
  BCC_StructuredUAV = 9,
  BCC_StructuredAppendUAV = 10,
  BCC_IndirectUAV = 11,
  BCC_Index16BitUAV = 12,
  BCC_Raw = 13,
  BCC_ShaderTable = 14,
  BCC_Invalid = 15,
}

public enum GpuWrapApieIndexBufferChunkType {
  IBCT_IndexUInt = 0,
  IBCT_IndexUShort = 1,
  IBCT_Max = 2,
}

public enum GpuWrapApieTextureFormat {
  TEXFMT_A8_Unorm = 0,
  TEXFMT_R8_Unorm = 1,
  TEXFMT_L8_Unorm = 2,
  TEXFMT_R8G8_Unorm = 3,
  TEXFMT_R8G8B8X8_Unorm = 4,
  TEXFMT_R8G8B8A8_Unorm = 5,
  TEXFMT_R8G8B8A8_Unorm_SRGB = 40,
  TEXFMT_R8G8B8A8_Snorm = 6,
  TEXFMT_B8G8R8A8 = 50,
  TEXFMT_B8G8R8A8_SRGB = 51,
  TEXFMT_R16_Unorm = 7,
  TEXFMT_R16_Snorm = 49,
  TEXFMT_R16_Uint = 8,
  TEXFMT_R32_Uint = 9,
  TEXFMT_R32G32B32A32_Uint = 10,
  TEXFMT_R32G32_Uint = 11,
  TEXFMT_R16G16B16A16_Unorm = 12,
  TEXFMT_R16G16B16A16_Uint = 14,
  TEXFMT_R16G16_Uint = 15,
  TEXFMT_R10G10B10A2_Unorm = 16,
  TEXFMT_R16G16B16A16_Float = 17,
  TEXFMT_R11G11B10_Float = 18,
  TEXFMT_R16G16_Float = 19,
  TEXFMT_R32G32_Float = 20,
  TEXFMT_R32G32B32A32_Float = 21,
  TEXFMT_R32_Float = 22,
  TEXFMT_R16_Float = 23,
  TEXFMT_D24S8 = 24,
  TEXFMT_D32FS8 = 25,
  TEXFMT_D32F = 27,
  TEXFMT_D16U = 28,
  TEXFMT_BC1 = 29,
  TEXFMT_BC1_SRGB = 41,
  TEXFMT_BC2 = 30,
  TEXFMT_BC2_SRGB = 42,
  TEXFMT_BC3 = 31,
  TEXFMT_BC3_SRGB = 43,
  TEXFMT_BC4 = 32,
  TEXFMT_BC5 = 33,
  TEXFMT_BC6H_UNSIGNED = 34,
  TEXFMT_BC6H_SIGNED = 35,
  TEXFMT_BC7 = 36,
  TEXFMT_BC7_SRGB = 37,
  TEXFMT_R8_Uint = 38,
  TEXFMT_R16G16_Unorm = 44,
  TEXFMT_R16G16_Sint = 45,
  TEXFMT_R16G16_Snorm = 46,
  TEXFMT_B5G6R5_Unorm = 47,
  TEXFMT_A8 = 0,
  TEXFMT_R8 = 1,
  TEXFMT_L8 = 2,
  TEXFMT_R8G8 = 3,
  TEXFMT_R8G8B8X8 = 4,
  TEXFMT_R8G8B8A8 = 5,
  TEXFMT_Uint_16_norm = 7,
  TEXFMT_Uint_16 = 8,
  TEXFMT_Uint_32 = 9,
  TEXFMT_Uint_R32G32B32A32 = 10,
  TEXFMT_R10G10B10A2 = 16,
  TEXFMT_Float_R16G16B16A16 = 17,
  TEXFMT_Float_R11G11B10 = 18,
  TEXFMT_Float_R16G16 = 19,
  TEXFMT_Float_R32G32 = 20,
  TEXFMT_Float_R32G32B32A32 = 21,
  TEXFMT_Float_R32 = 22,
  TEXFMT_Float_R16 = 23,
  TEXFMT_BC6H = 34,
}

public enum GpuWrapApieTextureGroup {
  TEXG_Generic_Color = 1,
  TEXG_Generic_Grayscale = 2,
  TEXG_Generic_Normal = 3,
  TEXG_Generic_Data = 4,
  TEXG_Generic_UI = 5,
  TEXG_Generic_Font = 6,
  TEXG_Generic_LUT = 7,
  TEXG_Generic_MorphBlend = 8,
  TEXG_Multilayer_Color = 9,
  TEXG_Multilayer_Normal = 10,
  TEXG_Multilayer_Grayscale = 11,
  TEXG_Multilayer_Microblend = 12,
}

public enum GpuWrapApieTextureType {
  TEXTYPE_2D = 0,
  TEXTYPE_CUBE = 1,
  TEXTYPE_ARRAY = 2,
  TEXTYPE_3D = 3,
}

public native struct GpuWrapApiVertexLayoutDesc {
  public native let elements: [GpuWrapApiVertexPackingPackingElement; 32];
  public native let slotStrides: [Uint8; 8];
  public native let slotMask: Uint32;
  public native let hash: Uint32;
}

public enum GpuWrapApiVertexPackingePackingType {
  PT_Invalid = -1,
  PT_Float1 = 0,
  PT_Float2 = 1,
  PT_Float3 = 2,
  PT_Float4 = 3,
  PT_Float16_2 = 4,
  PT_Float16_4 = 5,
  PT_UShort1 = 6,
  PT_UShort2 = 7,
  PT_UShort4 = 8,
  PT_UShort4N = 9,
  PT_Short1 = 10,
  PT_Short2 = 11,
  PT_Short4 = 12,
  PT_Short4N = 13,
  PT_UInt1 = 14,
  PT_UInt2 = 15,
  PT_UInt3 = 16,
  PT_UInt4 = 17,
  PT_Int1 = 18,
  PT_Int2 = 19,
  PT_Int3 = 20,
  PT_Int4 = 21,
  PT_Color = 22,
  PT_UByte1 = 23,
  PT_UByte1F = 24,
  PT_UByte4 = 25,
  PT_UByte4N = 26,
  PT_Byte4N = 27,
  PT_Dec4 = 28,
  PT_Index16 = 29,
  PT_Index32 = 30,
  PT_Max = 31,
}

public enum GpuWrapApiVertexPackingePackingUsage {
  PS_Invalid = -1,
  PS_SysPosition = 0,
  PS_Position = 1,
  PS_Normal = 2,
  PS_Tangent = 3,
  PS_Binormal = 4,
  PS_TexCoord = 5,
  PS_Color = 6,
  PS_SkinIndices = 7,
  PS_SkinWeights = 8,
  PS_DestructionIndices = 9,
  PS_MultilayerPaint = 10,
  PS_InstanceTransform = 11,
  PS_InstanceLODParams = 12,
  PS_InstanceSkinningData = 13,
  PS_PatchSize = 14,
  PS_PatchBias = 15,
  PS_ExtraData = 16,
  PS_VehicleDmgNormal = 17,
  PS_VehicleDmgPosition = 18,
  PS_PositionDelta = 19,
  PS_LightBlockerIntensity = 20,
  PS_BoneIndex = 21,
  PS_Padding = 22,
  PS_PatchOffset = 23,
  PS_Max = 24,
}

public enum GpuWrapApiVertexPackingEStreamType {
  ST_Invalid = -1,
  ST_PerVertex = 0,
  ST_PerInstance = 1,
  ST_Max = 2,
}

public native struct GpuWrapApiVertexPackingPackingElement {
  public native let type: GpuWrapApiVertexPackingePackingType;
  public native let usage: GpuWrapApiVertexPackingePackingUsage;
  public native let usageIndex: Uint8;
  public native let streamIndex: Uint8;
  public native let streamType: GpuWrapApiVertexPackingEStreamType;
}

public native class graphGraphConnectionDefinition extends graphIGraphObjectDefinition {
  public native let source: wref<graphGraphSocketDefinition>;
  public native let destination: wref<graphGraphSocketDefinition>;
}

public abstract native class graphGraphDefinition extends graphIGraphObjectDefinition {
  public native let nodes: array<ref<graphGraphNodeDefinition>>;
}

public abstract native class graphGraphNodeDefinition extends graphIGraphObjectDefinition {
  public native let sockets: array<ref<graphGraphSocketDefinition>>;
}

public abstract native class graphGraphResource extends CResource {
  public native let graph: ref<graphGraphDefinition>;
}

public abstract native class graphIGraphNodeCondition extends ISerializable {}

public abstract native class graphIGraphObjectDefinition extends ISerializable {}

public native struct grsDeathmatchPlayerGameInfo {
  public native let peerID: netPeerID;
  public native let isInGame: Bool;
  public native let isDead: Bool;
  public native let spawnTime: netTime;
  public native let killCount: Uint32;
  public native let deathCount: Uint32;
  public native let lastShooter: netPeerID;
}

public native struct grsDeathmatchState {
  public native let time: netTime;
  public native let status: grsDeathmatchStatus;
  public native let sessionLength: netTime;
  public native let playersInfo: [grsDeathmatchPlayerGameInfo; 7];
}

public enum grsDeathmatchStatus {
  Waiting = 0,
  AdditionalWaiting = 1,
  Starting = 2,
  InGame = 3,
  Ending = 4,
  Sumup = 5,
}

public native struct grsGatherAreaManager {
  public native let activeGatherAreaRepInfo: grsGatherAreaReplicatedInfo;
}

public native struct grsGatherAreaReplicatedInfo {
  public native let enteredPlayerIDs: [netPeerID; 7];
  public native let hasActiveQuestListener: Bool;
  public native let enabled: Bool;
}

public native struct grsHeistPlayerGameInfo {
  public native let peerID: netPeerID;
  public native let isInGame: Bool;
  public native let isReady: Bool;
  public native let isRespawning: Bool;
  public native let isDead: Bool;
  public native let spawnTime: netTime;
  public native let killCount: Uint32;
  public native let deathCount: Uint32;
  public native let characterRecord: String;
}

public native struct grsHeistState {
  public native let time: netTime;
  public native let status: grsHeistStatus;
  public native let playersInfo: [grsHeistPlayerGameInfo; 7];
}

public abstract importonly class gsmBaseRequestsHandler extends inkISystemRequestsHandler {
  public native let SavingComplete: gsmSavingRequesResult;
}

public native class gsmGameDefinition extends CResource {
  public native let mainQuests: array<ref<gsmMainQuest>>;
  public native let world: ResourceAsyncRef; // raRef<worldWorld>
  public native let streamingWorld: ResourceAsyncRef; // raRef<CResource>
  public native let worldName: String;
  public native let spawnPointTags: redTagList;
}

public abstract native struct gsmIStateObserver {}

public native class gsmMainQuest extends ISerializable {
  public native let questFile: ResourceAsyncRef; // raRef<questQuestResource>
  public native let additionalContent: Bool;
  public native let additionalContentName: CName;
}

public native class gsmMenuState_CreateSingleplayerSession extends gsmMenuState {}

public native class gsmMenuState_ErrorPopup extends gsmPopupState {}

public native class gsmMenuState_FindSessions extends gsmMenuState {}

public native class gsmMenuState_GatheringSaves extends gsmPopupState {}

public native class gsmMenuState_InGamePause extends gsmMenuState {}

public native class gsmMenuState_LoadGameDefinition extends gsmMenuState {}

public native class gsmMenuState_LoadSession extends gsmMenuState {}

public native class gsmMenuState_MainMenu extends gsmMenuState {}

public native class gsmMenuState_ModalPopup extends gsmPopupState {}

public native class gsmMenuState_Multiplayer extends gsmMenuState {}

public native class gsmMenuState_MultiplayerSelectCharacter extends gsmMenuState {}

public native class gsmMenuState_PlayRecordedSession extends gsmMenuState {}

public native class gsmMenuState_Singleplayer extends gsmMenuState {}

public abstract native class gsmMenuState extends gsmState {}

public abstract native class gsmPopupState extends gsmState {}

public native class gsmState_AutoJoinServer extends gsmMenuState {}

public native class gsmState_BoothModeMainMenu extends gsmMenuState {}

public native class gsmState_Initialization extends gsmState {}

public native class gsmState_PreGameSession extends gsmState_Session {}

public native class gsmState_ReconnectController extends gsmState {}

public native class gsmState_Session extends gsmState {}

public native class gsmState_SessionActive extends gsmState_SessionStreamingAware {}

public native class gsmState_SessionLoading extends gsmState {}

public native class gsmState_SessionNewGame extends gsmState {}

public native class gsmState_SessionPaused extends gsmState_SessionStreamingAware {}

public native class gsmState_SessionRestoreFromSave extends gsmState {}

public native class gsmState_SessionStreamingAware extends gsmState {}

public native class gsmState_TrialVersionUpgrade extends gsmState {}

public abstract native class gsmState extends IScriptable {}

public enum gsmStateError {
  StateError_OK = 0,
  StateError_SettingsCorrupted = 1,
  StateError_SettingsCorrupted_Save = 2,
  StateError_ProfileCorrupted = 3,
  StateError_ProfileCorrupted_Save = 4,
  StateError_CannotInitializeContext = 5,
  StateError_CantLoadGameDefinition = 6,
  StateError_CantInitializeSession = 7,
  StateError_CantLoadSave_CantLoadFile = 8,
  StateError_CantLoadSave_CantCreateLoadStream = 9,
  StateError_CantLoadSave_CensorshipLevelMismatch = 10,
  StateError_CantLoadSave_RegionMismatch = 11,
  StateError_CantLoadSave_CensorshipOptionalNudity = 12,
  StateError_CantLoadSave_VersionMismatch = 13,
  StateError_CantLoadSave_Corrupted = 14,
  StateError_CantLoadSave_SessionDescInvalid = 15,
  StateError_CantLoadSave_CantLoadCloudFile = 16,
  StateError_CantLoadSave_AdditionalContentIDsMismatch = 17,
}

public native class GTFManager extends IScriptable {
  public final native func ParamManager()
}

public native class GTFParamManager extends IScriptable {
  public final native func SetFPSClamp()
  public final native func SetTurboMode()
}

public native class HACK_AREA_Settings extends IAreaSettings {
  public native let surfelScale: Float;
  public native let missingEnergyScale: Float;
  public native let overrideOnPureView: Bool;
  public native let surfAlbedoOverrideRatio: Float;
  public native let surfAlbedoOverride: HDRColor;
  public native let skyScale: Float;
  public native let bottomHemisphereTint: CurveDataHDRColor;
  public native let bottomHemisphereStrength: Float;
  public native let emissiveScale: Float;
  public native let albedoMetalness: Float;
}

public native class HasDialogVisualizerVisiblePrereq extends IPrereq {}

public native class HasDialogVisualizerVisiblePrereqState extends PrereqState {}

public native class HeatAgentComponent extends IPlacedComponent {}

public native class HeatHazeAreaSettings extends IAreaSettings {
  public native let effectStrength: CurveDataFloat;
  public native let startDistance: CurveDataFloat;
  public native let maxDistance: CurveDataFloat;
  public native let patternScale: CurveDataFloat;
  public native let movementSpeedScale: CurveDataFloat;
}

public native class HideCustomTooltipEvent extends Event {}

public native class HitRepresentationComponent extends SlotComponent {
  public native let representations: array<HitShapeContainer>;
  public native let physicsMaterial: CName;
  public native let bvhRoot: gameHitShapeBVH;
  public native let useResourceData: Bool;
  public native let resource: ResourceAsyncRef; // raRef<HitRepresentationResource>
  public native let appearanceOverrides: array<HitRepresentationOverride>;
}

@neverRef()
public importonly class HitRepresentationOverride extends ISerializable {
  public native let represenationOverride: HitShapeContainer;
}

public importonly class HitRepresentationResource extends CResource {
  public native let representations: array<HitShapeContainer>;
  public native let overrides: array<HitRepresentationVisualTaggedOverride>;
}

@neverRef()
public importonly class HitRepresentationVisualTaggedOverride extends ISerializable {
  public native let visualTags: redTagList;
  public native let represenationOverride: HitShapeContainer;
}

public importonly class HitShape_Capsule extends HitShapeBase {
  public native let radius: Float;
  public native let height: Float;
}

public importonly class HitShape_ColliderComponent extends HitShapeBase {
  public native let componentNames: array<CName>;
}

public importonly class HitShape_OBB extends HitShapeBase {
  public native let dimensions: Vector3;
}

public importonly class HitShape_Sphere extends HitShapeBase {
  public native let radius: Float;
}

public abstract importonly class HitShapeBase extends IHitShape {
  public native let translation: Vector3;
  public native let rotation: Quaternion;
  public native let localTransform: Matrix;
}

public importonly struct HitShapeContainer {
  public native let name: CName;
  public native let slotName: CName;
  public native let color: Color;
  public native let shape: ref<IHitShape>;
  public native let userData: ref<HitShapeUserData>;
  public native let physicsMaterial: physicsMaterialReference;
}

public native class HudMeshComponent extends MeshComponent {}

public abstract native class IActivityCardsSystem extends IGameSystem {}

public abstract native struct IAgent {}

public abstract native class IAreaSettings extends ISerializable {
  public native let enable: Bool;
  public native let disabledIndexedProperties: Uint64;
}

public abstract native class IBackendData extends ISerializable {}

public abstract importonly class IBlackboardUpdateProxy extends IGameSystem {}

public abstract native struct ICameraStorageCustomData {}

public abstract importonly class IClientEntitySpawnSystem extends IGameSystem {}

public abstract native class ICommandsManager extends IGameSystem {}

public abstract native struct IDebugConsole {}

public native class IDestructionPersistencySystem extends DestructionPersistencySystem {}

public abstract native class IDeviceInteractionManager extends IGameSystem {}

public abstract native class IDynamicTextureGenerator extends ISerializable {}

public native class IEvaluator extends ISerializable {}

public abstract native class IEvaluatorColor extends IEvaluator {}

public abstract native class IEvaluatorFloat extends IEvaluator {}

public abstract native class IEvaluatorVector extends IEvaluator {
  public native let freeAxes: EFreeVectorAxes;
  public native let spill: Bool;
}

public abstract native class IGPSSystem extends IGameSystem {}

public abstract native class IHitRepresentationSystem extends IGameSystem {}

public abstract importonly class IHitShape extends ISerializable {}

public native struct IKChainSettings {
  public native let chainName: CName;
  public native let enableFloatTrack: CName;
  public native let ikEndPointOffset: Vector3;
  public native let ikEndRotationOffset: Quaternion;
}

public native class ImageBasedFlareAreaSettings extends IAreaSettings {
  public native let treshold: Float;
  public native let dispersal: Float;
  public native let haloWidth: Float;
  public native let distortion: Float;
  public native let curve: Float;
  public native let tint: [Color; 8];
  public native let scale: CurveDataFloat;
  public native let saturation: CurveDataFloat;
}

public native class ImageTextureGenerator extends IDynamicTextureGenerator {}

public abstract native class IMaterial extends CResource {}

public enum IMaterialDataProviderDescEParameterType {
  PT_None = 0,
  PT_Texture = 1,
  PT_Color = 2,
  PT_Cube = 3,
  PT_Vector = 4,
  PT_Scalar = 5,
  PT_Bool = 6,
  PT_TextureArray = 7,
  PT_StructBuffer = 8,
  PT_Cpu_NameU64 = 9,
  PT_SkinProfile = 10,
  PT_MultilayerSetup = 11,
  PT_MultilayerMask = 12,
  PT_HairProfile = 13,
  PT_FoliageProfile = 14,
  PT_TerrainSetup = 15,
  PT_Gradient = 16,
  PT_DynamicTexture = 17,
  PT_MAX = 18,
}

public abstract native class IMaterialDefinition extends IMaterial {
  public native let paramBlockSize: [Uint32; 3];
  public native let canHaveTangentUpdate: Bool;
  public native let canHaveDismemberment: Bool;
  public native let hasDPL: Bool;
  public native let canBeMasked: Bool;
  public native let shadingRateMode: EMaterialShadingRateMode;
  public native let materialVersion: Uint8;
  public native let vertexFactories: array<EMaterialVertexFactory>;
}

public abstract native class IMovePoliciesSystem extends IGameSystem {}

public abstract importonly class IMoveSystem extends IGameSystem {}

public abstract native class IMovingPlatformSystem extends IGameSystem {}

public native class inkAdvertisementsLayer extends inkWorldFluffLayer {}

public native class inkanimAdvertPauseEvent extends inkAnimEvent {}

public native class inkanimAnimationController extends inkLogicController {}

public native class inkanimAnimationLibraryResource extends CResource {
  public native let sequences: array<ref<inkAnimSequence>>;
}

public native class inkAnimatedAdvertController extends inkLogicController {
  public native let animName: CName;
  public native let loopType: inkanimLoopType;
}

public native class inkanimChangeStateEvent extends inkAnimEvent {
  public native let state: CName;
}

public native class inkanimChangeTexturePartEvent extends inkAnimEvent {
  public native let imageTexturePartName: CName;
}

public native class inkanimExecuteCodeEventEvent extends inkAnimEvent {
  public native let eventToExecute: ref<Event>;
}

public native class inkanimExecuteControllerFunctionEvent extends inkAnimEvent {
  public native let controllerType: CName;
  public native let eventName: CName;
  public native let params: String;
}

public native class inkanimMarkerEvent extends inkAnimEvent {
  public native let markerName: CName;
}

public native class inkanimPlayAnimEvent extends inkAnimEvent {
  public native let animName: CName;
  public native let playbackOptions: inkAnimOptions;
}

public native class inkanimPlaySoundEvent extends inkAnimEvent {
  public native let soundEventName: CName;
}

public native class inkanimPlayVideoEvent extends inkAnimEvent {
  public native let videoResource: ResourceAsyncRef; // raRef<Bink>
}

public native class inkanimPlayVOEvent extends inkAnimEvent {
  public native let VOLine: String;
  public native let speakerName: String;
}

public abstract native class inkanimProcessor extends ISerializable {}

public native class inkanimSequenceTargetInfo extends ISerializable {
  public native let path: array<Uint32>;
}

public native class inkanimSetStyleEvent extends inkAnimEvent {
  public native let style: ResourceAsyncRef; // raRef<inkStyleResource>
}

public native class inkanimSetTextEvent extends inkAnimEvent {
  public native let localizationString: String;
}

public native class inkAnimShapeBorderTransparency extends inkAnimInterpolator {
  public native let startValue: Float;
  public native let endValue: Float;
  public final native func GetEndTransparency()
  public final native func GetStartTransparency()
  public final native func SetEndTransparency()
  public final native func SetStartTransparency()
}

public native class inkAnimShapeFillTransparency extends inkAnimInterpolator {
  public native let startValue: Float;
  public native let endValue: Float;
  public final native func GetEndTransparency()
  public final native func GetStartTransparency()
  public final native func SetEndTransparency()
  public final native func SetStartTransparency()
}

public native class inkanimStopAnimEvent extends inkAnimEvent {
  public native let animName: CName;
}

public native class inkanimStopVideoEvent extends inkAnimEvent {}

public native class inkAnimTextKiroshi extends inkAnimTextInterpolator {}

public native class inkAnimTranslationBetweenWidgets extends inkAnimTranslation {
  public native let startWidgetPath: CName;
  public native let endWidgetPath: CName;
}

public native class inkAnimVideo extends inkAnimInterpolator {
  public native let startValue: Float;
  public native let endValue: Float;
  public native let synchronizeToAudio: Bool;
  public native let allowSkipBackward: Bool;
  public native let audioEvent: CName;
  public native let retriggerAudioOnLoop: Bool;
}

public native class inkAudioHandlerUserData extends inkUserData {}

public native struct inkBinkLanguageDescriptor {
  public native let bink: ResourceAsyncRef; // raRef<Bink>
  public native let languageId: inkLanguageId;
}

public native class inkBlackwallEffect extends inkGlitchEffect {
  public native let scaleX: Float;
  public native let scaleY: Float;
  public native let layerVisibility: Float;
}

public native class inkBoxBlurEffect extends inkIEffect {
  public native let samples: Uint8;
  public native let intensity: Float;
  public native let blurDimension: inkEBlurDimension;
}

public native struct inkBrushWrapper {
  public native let brush: ref<inkWidgetBrush>;
  public native let externalBrush: ResourceRef; // rRef<inkWidgetBrushResource>
}

public enum inkCacheMode {
  Normal = 0,
  Minimap = 1,
  ExternalDynamicTexture = 2,
}

public abstract native struct inkCallbackBase {
  public native let callbackName: CName;
  public native let listeners: array<inkCallbackListener>;
}

public native struct inkCallbackListener {
  public native let object: wref<IScriptable>;
  public native let functionName: CName;
}

public native class inkCensorshipController extends inkLogicController {
  public native let censorshipFlags: Uint32; // CensorshipFlags
}

public native class inkCensorshipEffect extends inkGlitchEffect {
  public native let censorshipFlags: Uint32; // CensorshipFlags
}

public enum inkCharacterEventType {
  CharInput = 0,
  MoveCaretForward = 1,
  MoveCaretBackward = 2,
  Delete = 3,
  Backspace = 4,
}

public abstract native class inkChildren extends ISerializable {}

public native class inkColorCorrectionEffect extends inkIEffect {
  public native let brightness: Float;
  public native let contrast: Float;
  public native let saturation: Float;
}

public native class inkColorFillEffect extends inkIEffect {
  public native let colorR: Float;
  public native let colorG: Float;
  public native let colorB: Float;
  public native let colorA: Float;
  public native let saturation: Float;
}

public native struct inkCompositionInterpolator {
  public native let parameter: CName;
  public native let interpolationMode: inkanimInterpolationMode;
  public native let interpolationType: inkanimInterpolationType;
  public native let duration: Float;
  public native let startDelay: Float;
}

public enum inkCompositionParamType {
  FLOAT = 0,
  VECTOR2 = 1,
}

public native struct inkCompositionPreset {
  public native let stateName: CName;
  public native let useBackgroundTexture: Bool;
  public native let shaderParams: fxCompositionShaderParams;
  public native let transitions: array<inkCompositionTransition>;
}

public native class inkCompositionPreviewSettings extends ISerializable {
  public native let sourceState: CName;
  public native let targetState: CName;
  public native let previewResolution: inkETextureResolution;
  public native let gameFrameTexture: ResourceAsyncRef; // raRef<CBitmapTexture>
  public native let textureAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let texturePart: CName;
}

public native struct inkCompositionTransition {
  public native let targetState: CName;
  public native let interpolators: array<inkCompositionInterpolator>;
}

public native class inkContainerNavigationController extends inkDiscreteNavigationController {
  public native let overrideEntries: array<inkNavigationOverrideEntry>;
  public native let useGlobalInput: Bool;
}

public abstract native class inkControllerProcessor extends ISerializable {}

public native class inkCreditsResource extends CResource {
  public native let sections: array<inkCreditsSectionEntry>;
}

public native struct inkCreditsSectionEntry {
  public native let sectionTitle: String;
  public native let names: array<String>;
  public native let displayMode: inkDisplayMode;
}

public native class inkDebugLayer extends inkFullScreenLayer {}

public native struct inkDebugLayerEntry {
  public native let widgetResource: ResourceAsyncRef; // raRef<inkWidgetLibraryResource>
  public native let anchorPlace: inkEAnchor;
  public native let anchorPoint: Vector2;
}

public native class inkDebugSystem extends inkIDebugSystem {}

public native class inkDebugSystemAccessor extends inkILayerSystemAccesor {}

public native class inkDebugSystemData extends inkILayerSystemData {
  public native let entries: array<inkDebugLayerEntry>;
  public native let rootLibrary: ResourceRef; // rRef<inkWidgetLibraryResource>
}

public native class inkDelayedSetLoadingScreenEvent extends Event {}

public native class inkDelayedSetStateEvent extends Event {}

public enum inkDisplayMode {
  Invalid = 0,
  Basic = 1,
  BasicTranslatable = 2,
  Bold = 3,
  Header = 4,
  Single = 5,
}

public native struct inkDrawArea {
  public native let size: Vector2;
  public native let scale: Float;
  public native let relativePosition: Vector2;
  public native let absolutePosition: Vector2;
}

public native struct inkDynamicTextureSlot {
  public native let texture: ResourceAsyncRef; // raRef<DynamicTexture>
  public native let parts: array<inkTextureAtlasMapper>;
}

public enum inkEBlurDimension {
  Horizontal = 0,
  Vertical = 1,
}

public native class inkEditorLayer extends inkFullScreenLayer {}

public enum inkEEndCapStyle {
  BUTT = 0,
  SQUARE = 1,
  ROUND = 2,
  JOINED = 3,
}

public enum inkEJointStyle {
  MITER = 0,
  BEVEL = 1,
  ROUND = 2,
}

public enum inkELayerLoadPriority {
  Normal = 0,
  High = 1,
}

public native class inkEnableHUDScaleOverride extends inkInitializedWidgetUserData {
  public native let scalingInterpolationValue: Float;
}

public native class inkEngineSettingsResource extends CResource {
  public native let fallbackCompositionResource: ResourceRef; // rRef<inkFullscreenCompositionResource>
  public native let fallbackShapeCollectionResource: ResourceRef; // rRef<inkShapeCollectionResource>
  public native let fallbackIconAtlasResource: ResourceRef; // rRef<inkTextureAtlas>
  public native let inputKeyIconsDefinitionResource: ResourceAsyncRef; // raRef<JsonResource>
  public native let fallbackFontFamilyPath: ResourceRef; // rRef<inkFontFamilyResource>
  public native let blackTexture: ResourceRef; // rRef<CBitmapTexture>
  public native let advertMissingFormatTexture: ResourceRef; // rRef<CBitmapTexture>
  public native let advertWrongResourceTexture: ResourceRef; // rRef<CBitmapTexture>
  public native let fallbackTextureAtlas: ResourceRef; // rRef<inkTextureAtlas>
  public native let imageTilingMaterial: ResourceRef; // rRef<IMaterial>
  public native let imageNineSliceMaterial: ResourceRef; // rRef<IMaterial>
  public native let depthMaterial: ResourceRef; // rRef<IMaterial>
  public native let whiteMaskAtlas: ResourceRef; // rRef<inkTextureAtlas>
  public native let defaultBinkMaterial: ResourceRef; // rRef<CMaterialTemplate>
  public native let tooManyBinksTexture: ResourceRef; // rRef<CBitmapTexture>
  public native let componentMissingTexture: ResourceRef; // rRef<CBitmapTexture>
}

public enum inkEShapeVariant {
  Fill = 0,
  Border = 1,
  FillAndBorder = 2,
}

public enum inkETextDirection {
  LeftToRight = 0,
  RightToLeft = 1,
  Mixed = 2,
}

public enum inkETextureResolution {
  UltraHD_3840_2160 = 0,
  FullHD_1920_1080 = 1,
  HD_1280_720 = 2,
}

public native class inkFastTravelLoadingControllerSupervisor extends inkGameController {
  public native let glitchEffect: ResourceRef; // rRef<worldEffect>
}

public native class inkFinalConfigurationController extends inkLogicController {
  public native let visibilityFlag: inkFinalConfigurationVisibility;
}

public enum inkFinalConfigurationVisibility {
  VisibleOnlyInFinal = 0,
  HiddenOnlyInFinal = 1,
}

public enum inkFitToContentDirection {
  None = 0,
  Horizontal = 2,
  Vertical = 1,
}

public native class inkFitToViewport extends inkUserData {}

public enum inkFocusCause {
  Mouse = 0,
  Navigation = 1,
  SetDirectly = 2,
  Cleared = 3,
  OtherWidgetLostFocus = 4,
  WindowActivate = 5,
}

public native class inkFocusEvent extends inkEvent {
  public final native func GetCause()
}

public native class inkFontFamilyResource extends CResource {
  public native let familyName: CName;
  public native let fontStyles: array<inkFontStyle>;
}

public native struct inkFontStyle {
  public native let styleName: CName;
  public native let font: ResourceRef; // rRef<rendFont>
}

public abstract native class inkFullscreenCompositionManager extends ISerializable {}

public native class inkFullscreenCompositionResource extends CResource {
  public native let compositionPresets: array<inkCompositionPreset>;
  public native let backgroundMenuTextureUHDRes: ResourceAsyncRef; // raRef<CBitmapTexture>
  public native let backgroundMenuTextureFHDRes: ResourceAsyncRef; // raRef<CBitmapTexture>
  public native let previewSettings: ref<inkCompositionPreviewSettings>;
}

public abstract native class inkFullScreenLayer extends inkLayer {}

public native struct inkGalleryData {
  public native let favorites: array<Uint32>;
}

public native class inkGalleryDataContainer extends ISerializable {
  public native let data: inkGalleryData;
}

public native class inkGameNotificationEvt extends Event {}

public native class inkGameNotificationsLayer extends inkFullScreenLayer {}

public native class inkGameSettingsResource extends CResource {
  public native let compositionResource: ResourceRef; // rRef<inkFullscreenCompositionResource>
  public native let permanentTextureAtlases: array<ResourceAsyncRef>;
  public native let permanentTextureAtlasesPC: array<ResourceAsyncRef>;
  public native let permanentTextureAtlasesDurango: array<ResourceAsyncRef>;
  public native let permanentTextureAtlasesOrbis: array<ResourceAsyncRef>;
  public native let permanentTextureAtlasesProspero: array<ResourceAsyncRef>;
  public native let permanentTextureAtlasesStadiaSwitch: array<ResourceAsyncRef>;
  public native let permanentTextureAtlasesStadia: array<ResourceAsyncRef>;
  public native let permanentTextureAtlasesStadiaDurango: array<ResourceAsyncRef>;
  public native let permanentTextureAtlasesStadiaOrbis: array<ResourceAsyncRef>;
  public native let themes: array<inkStyleThemeDescriptor>;
  public native let layersResource: ResourceRef; // rRef<inkLayersResource>
  public native let iconReferenceFallbackTextureAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let initLoadingScreenLogoLoopVideo: ResourceAsyncRef; // raRef<Bink>
  public native let npcNameplateResource: ResourceAsyncRef; // raRef<inkWidgetLibraryResource>
  public native let defaultShapeCollectionResource: ResourceRef; // rRef<inkShapeCollectionResource>
  public native let globalTVBinkLengthDataResource: ResourceAsyncRef; // raRef<JsonResource>
  public native let worldMapFloorplanWidgetResource: ResourceAsyncRef; // raRef<inkWidgetLibraryResource>
  public native let gpsAugmentedRealitySignEntity: ResourceAsyncRef; // raRef<entEntityTemplate>
  public native let gpsAugmentedRealityWidgetTurnLeft: ResourceAsyncRef; // raRef<inkWidgetLibraryResource>
  public native let gpsAugmentedRealityWidgetTurnRight: ResourceAsyncRef; // raRef<inkWidgetLibraryResource>
  public native let gpsAugmentedRealityWidgetTurnBack: ResourceAsyncRef; // raRef<inkWidgetLibraryResource>
  public native let malePresetResource: ResourceAsyncRef; // raRef<CResource>
  public native let femalePresetResource: ResourceAsyncRef; // raRef<CResource>
  public native let fallbackHeadCustomizationFpp: ResourceAsyncRef; // raRef<CResource>
  public native let fallbackHeadCustomizationTpp: ResourceAsyncRef; // raRef<CResource>
  public native let fallbackHeadCustomizationTppFaceRig: ResourceAsyncRef; // raRef<CResource>
  public native let fallbackBodyCustomization: ResourceAsyncRef; // raRef<CResource>
  public native let fallbackArmsCustomization: ResourceAsyncRef; // raRef<CResource>
  public native let vsetSceneResource: ResourceAsyncRef; // raRef<CResource>
  public native let keyboardIconsAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let steamIconsAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let durangoIconsAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let orbisIconsAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let prosperoIconsAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let nintendoSwitchIconsAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let stadiaIconsAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let stadiaDurangoIconsAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let stadiaOrbisIconsAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
}

public native class inkGlitchEffect extends inkIEffect {
  public native let intensity: Float;
  public native let offsetX: Float;
  public native let offsetY: Float;
  public native let sizeX: Float;
  public native let sizeY: Float;
}

public native class inkGradient extends inkBaseShapeWidget {
  public native let gradientMode: inkGradientMode;
  public native let startColor: HDRColor;
  public native let endColor: HDRColor;
  public native let angle: Float;
}

public enum inkGradientMode {
  Linear = 0,
  Rectangular = 1,
}

public native struct inkGridItem {
  public native let rootIdx: Uint32;
}

public native struct inkGridItemTemplate {
  public native let sizeX: Uint32;
  public native let sizeY: Uint32;
  public native let widget: inkWidgetLibraryReference;
}

public native class inkHideLoadingScreenDelayedEvent extends Event {}

public native struct inkHierarchyPooler {}

public native class inkHighwaySignLogicController extends inkIStreetNameSignLogicController {
  public native let districtName: inkTextRef;
  public native let subDistrictName: inkTextRef;
  public native let metroStationIconLeft: inkImageRef;
  public native let metroStationIconRight: inkImageRef;
}

public native class inkHudEntriesResource extends CResource {
  public native let rootWidget: ResourceRef; // rRef<inkWidgetLibraryResource>
  public native let themeOverride: CName;
  public native let entries: array<inkHudWidgetSpawnEntry>;
}

public native class inkHudEntryInfo extends inkUserData {
  public native let size: Vector2;
  public native let offset: Vector2;
  public final native func SetSize()
}

public native class inkHudEntrySpawnedEvent extends Event {}

public native class inkHUDLayer extends inkFullScreenLayer {}

public native class inkHUDScalingMarginAdjustment extends inkInitializedWidgetUserData {
  public native let adjustmentMargin: inkMargin;
}

public native class inkHudSystem extends inkIHudSystem {}

public native class inkHudSystemAccessor extends inkILayerSystemAccesor {}

public native class inkHudSystemData extends inkILayerSystemData {
  public native let rootLibrary: ResourceRef; // rRef<inkWidgetLibraryResource>
  public native let entriesResource: ResourceRef; // rRef<inkHudEntriesResource>
}

public native class inkIconAtlas extends inkIIconAtlas {}

public abstract native class inkIDebugSystem extends inkILayerSystem {}

public abstract native class inkIEffect extends ISerializable {
  public native let isEnabled: Bool;
  public native let effectName: CName;
}

public native class inkIgnoreHUDSafeZones extends inkInitializedWidgetUserData {}

public native class inkIgnoreOnConsoles extends inkUserData {}

public native class inkIgnoresCursorState extends inkUserData {}

public native class inkIgnoreSwapHorizontallyMode extends inkUserData {}

public abstract native class inkIHudSystem extends inkILayerSystem {}

public abstract native class inkIIconAtlas extends IScriptable {}

public abstract native struct inkIIconAtlasManager {}

public abstract native class inkILayerSystem extends IScriptable {}

public abstract native class inkILayerSystemAccesor extends IScriptable {}

public abstract native class inkILayerSystemData extends IScriptable {}

public native struct inkILoadingScreenData {}

public native class inkInitializedWidgetUserData extends inkUserData {}

public native class inkInitialLoadingControllerSupervisor extends gameuiOnscreenVOPlayerController {}

public abstract native class inkInkLayer extends ISerializable {}

public native class inkInnerGlowEffect extends inkIEffect {
  public native let colorR: Float;
  public native let colorG: Float;
  public native let colorB: Float;
  public native let colorA: Float;
  public native let offsetX: Float;
  public native let offsetY: Float;
}

public native class inkInputActionValidityController extends inkLogicController {
  public native let invertVisibility: Bool;
  public native let inputActionName: CName;
  public native let inputValidityDependentWidgets: array<inkWidgetRef>;
}

public native struct inkInputDevicesMappingsJSON {
  public native let devices: array<CName>;
  public native let mappings: array<inkInputIconMappingJSON>;
}

public native struct inkInputIconMappingJSON {
  public native let id: CName;
  public native let part: CName;
  public native let hold: Bool;
}

public native class inkInputKeyDictionaryJSON extends ISerializable {
  public native let devicesMappings: array<inkInputDevicesMappingsJSON>;
}

public native class inkInputKeyIconManager extends ISerializable {}

public native class inkInternationalizationManager extends ISerializable {}

public native class inkIsAbleToSwapHorizontally extends inkUserData {}

public abstract native class inkIStateMachine extends ISerializable {}

public abstract native struct inkIStateMachineState {}

public abstract native class inkIStreetNameSignLogicController extends inkLogicController {}

public abstract native class inkIWaitingSignSystem extends inkILayerSystem {}

public abstract native struct inkIWidgetComponentWrapper {}

public abstract native class inkIWidgetSlotController extends inkLogicController {
  public native let slotID: CName;
  public native let layout: inkWidgetLayout;
}

public abstract native struct inkIWorldWidgetComponentWrapper {}

public native struct inkLanguageDefinition {
  public native let languageCode: CName;
  public native let isoScriptCode: CName;
  public native let textDirection: inkETextDirection;
  public native let fonts: array<inkLanguageFont>;
}

public native struct inkLanguageFont {
  public native let font: ResourceAsyncRef; // raRef<inkFontFamilyResource>
  public native let mapper: ref<inkLanguageFontMapper>;
}

public native class inkLanguageFontMapper extends ISerializable {
  public native let mappings: array<inkLanguageFontMapping>;
}

public native struct inkLanguageFontMapping {
  public native let languageCode: CName;
  public native let font: ResourceAsyncRef; // raRef<inkFontFamilyResource>
  public native let fontSizeModifier: Int16;
  public native let trackingModifier: Uint32;
  public native let lineHeightModifier: Float;
  public native let fontSizeModifierFloat: Float;
  public native let styleModifer: CName;
}

public enum inkLanguageId {
  EN = 0,
  PL = 1,
  JP = 2,
  DE = 3,
  ES = 4,
  MX = 5,
  KR = 6,
  IT = 7,
  FR = 8,
  RU = 9,
  PR = 10,
  ZH_CN = 11,
  TW = 12,
  CZ = 13,
  HU = 14,
  AR = 15,
  TR = 16,
  TH = 17,
  HT = 18,
  UA = 20,
  DEBUG = 21,
}

public enum inkLastTickVideoState {
  NotDrawn = 0,
  Drawn = 1,
  Paused = 2,
}

public abstract native class inkLayer extends ISerializable {}

public native struct inkLayerDefinition_NEW {
  public native let name: CName;
  public native let layerType: inkELayerType;
  public native let drawingPolicy: inkLayerDrawingPolicy;
  public native let loadPriority: inkELayerLoadPriority;
  public native let enabled: Bool;
  public native let isPermanent: Bool;
  public native let useGlobalStyleTheme: Bool;
  public native let isAffectedByFadeout: Bool;
  public native let useGameInput: Bool;
  public native let inputContext: CName;
}

public native struct inkLayerDefinition {
  public native let enabled: Bool;
  public native let rootLibrary: ResourceRef; // rRef<inkWidgetLibraryResource>
  public native let activeByDefault: Bool;
  public native let isPermanent: Bool;
  public native let useGlobalStyleTheme: Bool;
  public native let isAffectedByFadeout: Bool;
  public native let useGameInput: Bool;
  public native let inputContext: CName;
}

public native struct inkLayerDefinitionCollection {
  public native let menuLayer: inkMenuLayerDefinition;
  public native let menuLayerMP: inkMenuLayerDefinition;
  public native let hudLayer: inkHUDLayerDefinition;
  public native let videoLayer: inkVideoLayerDefinition;
  public native let offscreenLayer: inkOffscreenLayerDefinition;
  public native let gameNotificationsLayer: inkGameNotificationsLayerDefinition;
  public native let photoModeLayer: inkPhotoModeLayerDefinition;
  public native let debugLayer: inkDebugLayerDefinition;
}

public native struct inkLayerDefinitionsSet {
  public native let layersDefinitions: array<inkLayerDefinition_NEW>;
  public native let layersSystemConnections: array<inkLayerSystemConnection>;
}

public enum inkLayerDrawingPolicy {
  InOrder = 0,
  InParallel = 1,
}

public abstract native class inkLayerProxy extends ISerializable {}

public native class inkLayersResource extends CResource {
  public native let layerDefinitions: inkLayerDefinitionCollection;
  public native let preGameLayerDefinitions: inkLayerDefinitionCollection;
  public native let permanentLayerDefinitions: inkPermanentLayerDefinitionCollection;
  public native let layerDefinitionsSet: inkLayerDefinitionsSet;
}

public native struct inkLayerSystemConnection {
  public native let layerName: CName;
  public native let system: ref<inkILayerSystemData>;
}

public native class inkLightSweepEffect extends inkIEffect {
  public native let positionX: Float;
  public native let positionY: Float;
  public native let angle: Float;
  public native let width: Float;
  public native let intensity: Float;
}

public native class inkLinearWipeEffect extends inkIEffect {
  public native let angle: Float;
  public native let transition: Float;
}

public enum inkLineType {
  RegularPatternSpacing = 0,
  LoosePatternSpacing = 1,
}

public native struct inkLineVertex {
  public native let int: Vector2;
  public native let neType: inkLineType;
}

public native class inkLoadingLayer extends inkFullScreenLayer {}

public native struct inkLocalizedBink {
  public native let binks: array<inkBinkLanguageDescriptor>;
}

public enum inkMaskDataSource {
  TextureAtlas = 0,
  DynamicTexture = 1,
}

public native class inkMaskEffect extends inkIEffect {
  public native let angle: Float;
  public native let opacity: Float;
  public native let invert: Bool;
}

public native struct inkMenuEntry {
  public native let name: CName;
  public native let menuWidget: ResourceRef; // rRef<inkWidgetLibraryResource>
  public native let depth: Uint32;
  public native let spawnMode: inkSpawnMode;
  public native let isAffectedByFadeout: Bool;
  public native let inputContext: CName;
}

public native class inkMenuInstance_MenuInstanceListener extends Event {}

public abstract importonly class inkMenuInstance extends IScriptable {}

public importonly class inkMenuInstanceImpl extends inkMenuInstance {}

public native class inkMenuLayer extends inkFullScreenLayer {}

public native class inkMenuResource extends CResource {
  public native let menusEntries: array<inkMenuEntry>;
  public native let scenariosNames: array<CName>;
  public native let initialScenarioName: CName;
}

public native class inkMetroSignLogicController extends inkIStreetNameSignLogicController {
  public native let stationName: inkTextRef;
  public native let subDistrictName: inkTextRef;
  public native let metroStationsContainer: inkCompoundRef;
  public native let metroStationLibraryName: CName;
  public native let metroStationTextWidgetName: CName;
}

public native class inkMoveToTopOfMenu extends inkUserData {}

public native class inkMultiChildren extends inkChildren {
  public native let children: array<ref<inkWidget>>;
}

public native class inkMultisamplingEffect extends inkIEffect {}

public native struct inkNavigationOverrideEntry {
  public native let from: inkWidgetRef;
  public native let direction: inkDiscreteNavigationDirection;
  public native let to: inkWidgetRef;
}

public native class inkNewHudSpawnedEvent extends Event {}

public native class inkNoChildren extends inkChildren {}

public native class inkNullIconAtlas extends inkIIconAtlas {}

public native class inkOffscreenLayer extends inkLayer {}

public native class inkOffscreenWidgetSpawnEvt extends Event {}

public native struct inkOnscreenVOData {
  public native let text: CRUID;
}

public native struct inkOnscreenVOHandler {}

public native struct inkPermanentLayerDefinitionCollection {
  public native let loadingLayer: inkLoadingLayerDefinition;
  public native let watermarksLayer: inkWatermarksLayerDefinition;
  public native let sysNotificationsLayer: inkSystemNotificationsLayerDefinition;
  public native let waitingSignLayerDefinition: inkWaitingSignLayerDefinition;
}

public native class inkPhotoModeLayer extends inkFullScreenLayer {}

public native class inkPointCloudEffect extends inkIEffect {
  public native let repeat: Float;
  public native let offsetX: Float;
  public native let offsetY: Float;
  public native let angle: Float;
  public native let fovScale: Float;
  public native let parallaxDepth: Float;
  public native let depthToOpacity: Float;
  public native let depthToBrightness: Float;
}

public native class inkPoolIdentifier extends inkUserData {}

public native class inkProcessLoadingScreenDelayedEvent extends Event {}

public native struct inkPropertyBinding {
  public native let propertyName: CName;
  public native let stylePath: CName;
}

public native class inkPropertyManager extends ISerializable {
  public native let bindings: array<inkPropertyBinding>;
}

public native class inkQuadShape extends inkBaseShapeWidget {
  public native let textureAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let texturePart: CName;
  public native let vertexList: array<Vector2>;
}

public native class inkRadialWipeEffect extends inkIEffect {
  public native let startAngle: Float;
  public native let transition: Float;
}

public native class inkRollingListController extends ListController {
  public native let itemsToDisplay: Int32;
  public native let convexity: Float;
  public native let verticalCompression: Float;
  public native let scrollTime: Float;
}

public native class inkRootWidgetIdentifier extends inkUserData {}

public native struct inkRuntimeStylePropertyReference {}

public native class inkScanlineWipeEffect extends inkIEffect {
  public native let angle: Float;
  public native let transition: Float;
  public native let width: Float;
}

public native class inkSelectItemIndexEvent extends Event {}

public native class inkShapeCollectionResource extends CResource {
  public native let presets: array<inkShapePreset>;
}

public native struct inkShapePreset {
  public native let name: CName;
  public native let points: array<Vector2>;
}

public native class inkShapePresetWraper extends ISerializable {
  public native let shapePreset: inkShapePreset;
}

public native struct inkSimpleHierarchyPool {}

public native struct inkSingleDrawMetric {
  public native let exeedsLimit: Bool;
  public native let hierarchySize: Vector2;
  public native let usedTextures: array<Uint32>;
}

public native struct inkSize {
  public native let width: Float;
  public native let height: Float;
}

public abstract native class inkSpawningProcessor extends ISerializable {}

public enum inkSpawnMode {
  SingleAndMultiplayer = 0,
  OnlySingleplayer = 1,
  OnlyMultiplayer = 2,
}

public enum inkState {
  InitEngine = 0,
  PreGameMenu = 3,
  InitialLoading = 4,
  Game = 5,
  InGameMenu = 6,
  PauseMenu = 7,
  FastTravelLoading = 8,
  PhotoMode = 9,
  MiniGameMenu = 10,
  EndGameLoading = 11,
  EditorMode = 12,
}

public abstract native class inkStateMachine extends inkIStateMachine {}

public native class inkStateTransitionAnimationController extends inkLogicController {
  public native let transition: array<inkWidgetStateAnimatedTransition>;
  public native let stopActiveAnimation: Bool;
}

public native class inkStreetNameSignLogicController extends inkIStreetNameSignLogicController {
  public native let streetName: inkTextRef;
  public native let districtName: inkTextRef;
  public native let subdistrictName: inkTextRef;
}

public native class inkStreetSignsLayer extends inkWorldFluffLayer {}

public native struct inkStyle {
  public native let styleID: CName;
  public native let state: CName;
  public native let properties: array<inkStyleProperty>;
}

public native struct inkStyleOverride {
  public native let overrideType: inkStyleOverrideType;
  public native let styleResource: ResourceRef; // rRef<inkStyleResource>
}

public enum inkStyleOverrideType {
  Invalid = 0,
  BigFont = 1,
  FluffReduction = 2,
}

public native struct inkStyleProperty {
  public native let propertyPath: CName;
  public native let value: Variant;
}

public native struct inkStylePropertyReference {
  public native let referencedPath: CName;
}

public native class inkStyleResource extends CResource {
  public native let styles: array<inkStyle>;
  public native let styleImports: array<ResourceRef>;
  public native let themes: array<inkStyleTheme>;
  public native let overrides: array<inkStyleOverride>;
  public native let hideInInheritingStyles: Bool;
}

public native class inkStyleResourceWrapper extends ISerializable {
  public native let styleResource: ResourceAsyncRef; // raRef<inkStyleResource>
}

public native struct inkStyleTheme {
  public native let themeID: CName;
  public native let styleResource: ResourceRef; // rRef<inkStyleResource>
}

public native struct inkStyleThemeDescriptor {
  public native let themeID: CName;
  public native let themeNameLocKey: CName;
}

public native class inkSubtitlesLanguageOverride extends inkUserData {}

public native class inkSystemNotificationEvt extends Event {}

public native class inkSystemNotificationsLayer extends inkFullScreenLayer {}

public native class inkSystemNotificationToken extends IScriptable {}

public enum inkTextReplaceAnimationControllerWidgetTextUsage {
  BaseText = 0,
  TargetText = 1,
  NoUsage = 2,
}

public native class inkTextureAtlas extends CResource {
  public native let activeTexture: inkTextureType;
  public native let textureResolution: inkETextureResolution;
  public native let texture: ResourceAsyncRef; // raRef<CBitmapTexture>
  public native let dynamicTexture: ResourceAsyncRef; // raRef<DynamicTexture>
  public native let parts: array<inkTextureAtlasMapper>;
  public native let slices: array<inkTextureAtlasSlice>;
  public native let slots: [inkTextureSlot; 3];
  public native let dynamicTextureSlot: inkDynamicTextureSlot;
  public native let isSingleTextureMode: Bool;
}

public native struct inkTextureAtlasMapper {
  public native let partName: CName;
  public native let clippingRectInPixels: Rect;
  public native let clippingRectInUVCoords: RectF;
}

public native struct inkTextureAtlasSlice {
  public native let partName: CName;
  public native let nineSliceScaleRect: RectF;
}

public native struct inkTextureSlot {
  public native let texture: ResourceAsyncRef; // raRef<CBitmapTexture>
  public native let parts: array<inkTextureAtlasMapper>;
  public native let slices: array<inkTextureAtlasSlice>;
}

public enum inkTextWrappingPolicy {
  SingleLine = 0,
  MultiLine = 1,
  MultilineNoWrap = 2,
}

public native class inkTutorialOverlayInputRequest extends Event {
  public native let isInputRequested: Bool;
}

public native class inkTypographyResource extends CResource {
  public native let languages: array<inkLanguageDefinition>;
}

public native struct inkUITransform {
  public native let translation: Vector2;
  public native let scale: Vector2;
  public native let shear: Vector2;
  public native let rotation: Float;
}

public enum inkVideoInstanceDoneReason {
  Failed = 0,
  Stopped = 1,
  Finished = 2,
}

public native class inkVideoLayer extends inkFullScreenLayer {}

public enum inkVideoOptimizationState {
  None = 0,
  TooManyBinks = 1,
  FullscreenBinkVisible = 2,
}

public native class inkVideoSequenceController extends inkLogicController {
  public native let videoWidget: inkVideoRef;
  public native let videoSequence: array<inkVideoSequenceEntry>;
}

public native struct inkVideoSequenceEntry {
  public native let videoResource: ResourceAsyncRef; // raRef<Bink>
  public native let audioEvent: CName;
  public native let syncToAudio: Bool;
  public native let retriggerAudioOnLoop: Bool;
  public native let loop: Bool;
}

public native class inkVirtualWindow extends inkWindow {}

public native class inkVisualStatePopStateMachineEvent extends Event {}

public native class inkVORequestEvt extends Event {}

public native class inkWaitingSignLayer extends inkFullScreenLayer {}

public native class inkWaitingSignSystem extends inkIWaitingSignSystem {}

public native class inkWatermarksLayer extends inkFullScreenLayer {}

public native class inkWidgetBackendData extends IBackendData {
  public native let owner: wref<inkWidget>;
  public native let isHiddenInEditor: Bool;
  public native let isLocked: Bool;
  public native let boundLibraryItemName: CName;
}

public native class inkWidgetBrush extends IScriptable {
  public native let textureAtlas: ResourceRef; // rRef<inkTextureAtlas>
  public native let texturePartId: CName;
  public native let tileType: inkBrushTileType;
  public native let mirrorType: inkBrushMirrorType;
  public final native func GetMirrorType()
  public final native func GetTexturePart()
  public final native func GetTileType()
  public final native func IsTexturePartExist()
  public final native func SetTexturePart()
}

public native class inkWidgetBrushResource extends CResource {
  public native let brush: ref<inkWidgetBrush>;
}

public native class inkWidgetClipboardData extends ISerializable {
  public native let widget: ref<inkWidget>;
  public native let widgetPath: inkWidgetPath;
}

public native struct inkWidgetCompositor {}

public native struct inkWidgetLibraryItem {
  public native let name: CName;
}

public native class inkWidgetLibraryItemClipboardData extends ISerializable {
  public native let libraryItem: ref<inkWidgetLibraryItemUnpackedView>;
}

public native class inkWidgetLibraryItemInstance extends ISerializable {
  public native let rootWidget: ref<inkWidget>;
  public native let gameController: ref<inkIGameController>;
  public native let rootResolution: inkETextureResolution;
}

public native class inkWidgetLibraryItemUnpackedView extends ISerializable {
  public native let name: CName;
  public native let instance: ref<inkWidgetLibraryItemInstance>;
}

public native class inkWidgetLibraryUnpackedView extends ISerializable {
  public native let libraryItems: array<ref<inkWidgetLibraryItemUnpackedView>>;
  public native let externalLibraries: array<ResourceRef>;
}

public enum inkWidgetResourceVersion {
  Default = 0,
  BrushToAtlas = 1,
}

public native struct inkWidgetSlotAttachmentParams {
  public native let slotID: CName;
  public native let useSlotLayout: Bool;
  public native let layoutOverride: inkWidgetLayout;
}

public native class inkWidgetSlotController extends inkIWidgetSlotController {}

public native struct inkWidgetStateAnimatedTransition {
  public native let startState: CName;
  public native let endState: CName;
  public native let animationName: CName;
  public native let playbackOptions: inkAnimOptions;
}

public native class inkWindow extends inkCanvas {}

public native struct inkWindowDrawMetrics {
  public native let allTextures: array<Vector2>;
  public native let textureSizeTypes: array<Vector2>;
  public native let textureTypeTotal: array<Uint32>;
  public native let maxUsedTextureTypes: array<Uint32>;
  public native let drawMetrics: array<inkSingleDrawMetric>;
}

public abstract native class inkWorldFluffLayer extends inkLayer {}

public native class inkWorldLayer extends inkLayer {}

public abstract native class inkWorldWidgetComponentUserData extends inkUserData {}

public enum inputEInputDevice {
  INVALID = 0,
  KBD_MOUSE = 1,
  ORBIS = 2,
  DURANGO = 3,
  STEAM = 4,
  XINPUT_PAD = 5,
  STADIA = 6,
  NINTENDO_SWITCH = 7,
  SCARLETT_GAMEPAD = 8,
  PROSPERO = 9,
  EID_COUNT = 10,
}

public native class InputHintController extends inkLogicController {
  public native let inputDisplayLibRef: inkWidgetLibraryReference;
  public native let inputDisplayContainer: inkCompoundRef;
  public native let textWidgetRef: inkTextRef;
}

public native class InputHintGroupController extends inkLogicController {
  public native let titleTextRef: inkTextRef;
  public native let descriptionTextRef: inkTextRef;
  public native let hintsContainerRef: inkCompoundRef;
  public native let iconRef: inkImageRef;
}

public abstract native struct inputIInputSystem {}

public native class InternalFunctionalTestsRuntimeSystem extends FunctionalTestsIRuntimeSystem {}

public native struct interopDispatchPrefabProxyJobsResult {
  public native let numProxyJobsDispatched: Uint32;
  public native let numProxyJobsSkipped: Uint32;
  public native let numProxyJobsFailed: Uint32;
}

public native struct interopEntityEffectSelectionSyncData {
  public native let effectName: CName;
  public native let effectIDPath: toolsEditorObjectIDPath;
}

public native struct interopEntityEffectSpawnerSyncData {
  public native let componentName: CName;
  public native let effects: array<interopEntityEffectSelectionSyncData>;
  public native let templatePath: String;
  public native let templateColor: Color;
  public native let included: Bool;
}

public native struct interopGlobalNodeIDInfo {
  public native let globalName: String;
  public native let globalNodeIDPath: String;
  public native let globalNodeIDHash: Uint64;
  public native let globalNameIsAutoGenerated: Bool;
}

public native struct interopGlobalNodeIDResult {
  public native let errorMessage: String;
  public native let result: String;
  public native let isValid: Bool;
}

public native struct interopGraphConnectionCreationData {
  public native let data: String;
  public native let extraData: array<String>;
}

public native struct interopMaterialListDescriptor {
  public native let chunksInfo: String;
  public native let chunksLODInfo: String;
  public native let numLayers: Uint32;
  public native let isForward: Bool;
  public native let isMultilayer: Bool;
  public native let isLocalInstance: Bool;
  public native let isTemplate: Bool;
  public native let itemMaterialIndex: Uint32;
  public native let materialName: String;
  public native let appearanceName: String;
  public native let availableMaterials: array<String>;
}

public native struct interopNodeTransformInfo {
  public native let id: interopStringWithID;
  public native let transformInfo: interopTransformInfo;
}

public native struct interopOpaqueData {
  public native let description: String;
  public native let payload: String;
  public native let version: Int32;
}

public native struct interopReExportOptions {
  public native let occlusionExportOptNames: array<CName>;
  public native let occlusionExportOptValues: array<Bool>;
  public native let typeExportOptions: array<Bool>;
  public native let filePath: String;
  public native let runDispatcher: Bool;
  public native let files: array<String>;
  public native let depotPath: String;
  public native let maskDumpFilePath: AbsolutePathSerializable;
  public native let exportMaterials: Bool;
  public native let hjobToken: String;
  public native let hjobParams: String;
  public native let hjobParamsOutput: String;
  public native let assetName: String;
  public native let rigs: String;
  public native let hjobTemplate: String;
  public native let bodyType: String;
  public native let baseType: String;
  public native let exportBounds: Box;
  public native let referencePoint: Vector3;
  public native let assetPaths: array<String>;
  public native let jsonFile: AbsolutePathSerializable;
  public native let prefabType: Uint8;
  public native let proxyFromProxy: Bool;
  public native let onlyProxy: Bool;
  public native let exportTextures: Bool;
  public native let minBBoxDiag: Double;
  public native let asBBoxThreshold: Double;
  public native let asBBoxPrefabsThreshold: Double;
  public native let asBBoxPrefabsSubdivide: Double;
  public native let asBBoxPrefabsForceLast: Bool;
  public native let skipCollisions: Bool;
  public native let preferSmallProxiesTreshold: Float;
  public native let generatePlayerBlockingCollision: Bool;
}

public native struct interopRTTIClassDump {
  public native let classNames: array<String>;
  public native let descriptiveNames: array<String>;
  public native let resourceInfos: array<interopRTTIResourceDumpInfo>;
  public native let entries: array<interopRTTIClassDumpEntry>;
}

public native struct interopRTTIClassDumpEntry {
  public native let i: Int32;
  public native let b: Int32;
  public native let r: Int32;
  public native let a: Int32;
}

public native struct interopRTTIResourceDumpInfo {
  public native let extension: String;
  public native let deprecatedExtension: String;
  public native let friendlyDescription: String;
}

public native struct interopSelectByDefinitionOptions {
  public native let searchInSelection: Bool;
  public native let minBBoxDiagonalLength: Float;
  public native let maxBBoxDiagonalLength: Float;
  public native let maxBBoxParentPercantageDiagonalLength: Float;
  public native let includePrefabNodes: Bool;
  public native let includeDecalNodes: Bool;
  public native let includeMeshNodes: Bool;
}

public native struct interopSelectionChangeInfo {
  public native let selected: array<Uint64>;
  public native let deselected: array<Uint64>;
}

public native struct interopStringUint64Pair {
  public native let string: String;
  public native let number: Uint64;
}

public native struct interopStringWithID {
  public native let text: String;
  public native let id: Uint64;
}

public native struct interopTerrainEditToolCreationSlotInfo {
  public native let scale: Vector2;
  public native let heightMappingOverrideEnable: Bool;
  public native let heightMappingMin: Float;
  public native let heightMappingMax: Float;
}

public native struct interopTerrainEditToolInfo {
  public native let defaultHeightmapMode: Int32;
  public native let defaultEmptyHeightmapWidth: Int32;
  public native let defaultEmptyHeightmapHeight: Int32;
  public native let defaultEmptyHeightmapMaskFalloff: Float;
  public native let defaultEmptyHeightmapMaskRoundness: Float;
  public native let defaultEmptyHeightmapZeroMaskMargin: Uint32;
  public native let defaultHeightmap1: String;
  public native let defaultHeightmap2: String;
  public native let defaultColormap1: String;
  public native let defaultColormap2: String;
  public native let creationSlots: array<interopTerrainEditToolCreationSlotInfo>;
}

public native struct interopTerrainImportedTile {
  public native let heightMapAbsolutePath: String;
  public native let controlMapAbsolutePath: String;
  public native let colorMapAbsolutePath: String;
  public native let position: Point;
}

public native struct interopTerrainImportParams {
  public native let cellRes: Uint32;
  public native let cellSize: Uint32;
  public native let scale: Vector3;
  public native let position: Vector3;
  public native let extraOffset: Vector2;
  public native let tileWidth: Uint32;
  public native let tileHeight: Uint32;
  public native let prefabPlacementInterval: Uint32;
  public native let importHeightMaps: Bool;
  public native let importColorMaps: Bool;
  public native let importControlMaps: Bool;
  public native let overwriteTransformsOfExistingNodes: Bool;
  public native let nodesNamingPattern: String;
  public native let prefabsNamingPattern: String;
  public native let prefabsDestinationPath: String;
  public native let dstPrefabNodePath: toolsEditorObjectIDPath;
}

public native struct interopTerrainNodeInfo {
  public native let width: Uint32;
  public native let height: Uint32;
  public native let externalDataSource: Bool;
  public native let isTerrainNode: Bool;
  public native let blendOrder: Uint8;
  public native let blendModeHeightIsIgnore: Bool;
  public native let blendModeHeightIsNormal: Bool;
  public native let blendModeColorIsIgnore: Bool;
  public native let blendModeHolesIsIgnore: Bool;
  public native let terrainSysID: Uint16;
  public native let nodeName: String;
  public native let nodeScale: Vector3;
  public native let nodeTransform: Transform;
  public native let nodeCellResScale: Float;
  public native let densityTexelSize: Float;
  public native let nodeIDPath: toolsEditorObjectIDPath;
}

public native struct interopTerrainSystemInstanceInfo {
  public native let cellSize: Uint32;
  public native let cellRes: Uint32;
  public native let numUsedCells: Uint32;
  public native let numPatches: Uint32;
  public native let numPatchesFromTerrainNodes: Uint32;
  public native let numPatchesFromRoadNodes: Uint32;
  public native let isEnabled: Bool;
  public native let isVisibleCompiled: Bool;
  public native let useDebugDraw: Bool;
  public native let gridWidth: Uint32;
  public native let gridHeight: Uint32;
  public native let numUsedLODCells: array<Uint32>;
}

public native struct interopTransformInfo {
  public native let translation: Vector3;
  public native let rotation: EulerAngles;
}

public native struct interopUint64Pair {
  public native let first: Uint64;
  public native let second: Uint64;
}

public native class InventoryPrereq extends IComparisonPrereq {
  public native let itemID: ItemID;
  public native let amount: Uint32;
}

public native class InventoryPrereqState extends PrereqState {}

public importonly class InventoryPS extends GameComponentPS {
  public native persistent let isRegisteredShared: Bool;
  public native persistent let accessible: Bool;
}

public abstract native class IObjectCarrySystem extends IGameSystem {}

public abstract native class IObjectScriptBase extends IScriptable {
  public native let gameObject: ref<GameObject>;
  public final native func GetGameObject()
}

public abstract native class IParticleDrawer extends ISerializable {
  public native let pivotOffset: Float;
}

public abstract native class IParticleEvent extends IParticleModule {
  public native let eventName: CName;
}

public abstract native class IParticleInitializer extends IParticleModule {
  public native let seed: Uint32;
}

public abstract native class IParticleModificator extends IParticleInitializer {}

public abstract native class IParticleModule extends ISerializable {
  public native let editorName: String;
  public native let editorGroup: String;
  public native let isEnabled: Bool;
}

public abstract native struct IRenderProxyCustomData {}

public abstract native class IRenderResourceBlob extends ISerializable {}

public abstract native class IRichPresenceSystem extends IGameSystem {}

public abstract native class IRPGPrereq extends IComparisonPrereq {}

public abstract native struct ISceneStorageCustomData {}

public abstract native class ISmartObjectManager extends IGameSystem {}

public native struct IsQuickhackPanelOpenedPrereq {
  public native let inverted: Bool;
}

public native struct IsQuickhackPanelOpenedPrereqState {}

public native class IsVisualizerActivePrereq extends IPrereq {}

public native class IsVisualizerActivePrereqState extends PrereqState {}

public native class ItemDecorationEvent extends Event {}

public native class itempreviewUIObjectsLoaderSystemListener extends gameuiIUIObjectsLoaderSystemListener {}

public abstract native class ITexture extends CResource {}

public abstract native class ITierSystem extends IGameSystem {}

public abstract native class ITonemappingMode extends ISerializable {
  public native let colorPreservation: CurveDataFloat;
}

public abstract native class IUIIconsGeneratorSystem extends IGameSystem {}

public native class IUpdatableSystem extends IScriptable {}

public abstract native class IWorkspotManager extends IGameSystem {}

public native class JoinTrafficEvent extends AIEvent {}

public native class JournalBriefing extends JournalFileEntry {}

public enum JournalCallbackOption {
  DoNotFire = 0,
  Fire = 1,
}

public native class JournalContactModifierEntry extends JournalEntry {}

public native class JournalPointOfInterestGroup extends JournalFileEntry {}

public native class JournalPointOfInterestMappin extends JournalEntry {
  public native let staticNodeRef: NodeRef;
  public native let dynamicEntityRef: EntityReference;
  public native let securityAreaRef: NodeRef;
  public native let mappinData: PointOfInterestMappinData;
  public native let offset: Vector3;
  public native let questPath: ref<gameJournalPath>;
  public native let recommendedLevelID: TweakDBID;
  public native let notificationTriggerAreaRef: NodeRef;
}

public native class JournalQuestMultiMapPin extends JournalQuestMapPinBase {
  public native let references: array<NodeRef>;
  public native let slotName: CName;
  public native let mappinData: MappinData;
  public native let offset: Vector3;
  public native let uiAnimation: TweakDBID;
}

public native class JournalQuestPointOfInterestMapPin extends JournalQuestMapPinBase {}

public native class JournalQuestTitleModifier extends JournalEntry {
  public native let title: LocalizationString;
  public final native func GetTitle()
}

public native struct JournalRequestClassFilter {
  public native let className: CName;
}

public native class JsonResource extends CResource {
  public native let root: ref<ISerializable>;
}

public native struct LanguageSpecificImagData {
  public native let languageID: inkLanguageId;
  public native let textureAtlasForLanguage: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let partNameForLanguage: CName;
}

public native class LanguageSpecificImageController extends inkLogicController {
  public native let languages: array<LanguageSpecificImagData>;
  public native let fallbackTextureAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let fallbackPartName: CName;
}

public native class LanguageSpecificVideoController extends inkLogicController {
  public native let isLooped: Bool;
  public native let specificVideoForLanguage: ResourceAsyncRef; // raRef<Bink>
  public native let languages: array<inkLanguageId>;
  public native let fallbackVideo: ResourceAsyncRef; // raRef<Bink>
}

public abstract native class LibTreeCMetanodeDefinition extends LibTreeINodeDefinition {}

public native class LibTreeCMetanodeIfDefinition extends LibTreeCMetanodeDefinition {
  public native let ifCondition: LibTreeDefBool;
  public native let ifBranch: ref<LibTreeINodeDefinition>;
  public native let elseBranch: ref<LibTreeINodeDefinition>;
}

public abstract native class LibTreeCTreeReference extends ISerializable {
  public native let TreeDefinition: ResourceRef; // rRef<LibTreeCTreeResource>
  public native let parameters: LibTreeParameterList;
}

public abstract native class LibTreeCTreeResource extends CResource {
  public native let variables: LibTreeDefTreeVariablesList;
}

public native struct LibTreeDefBool {
  public native let variableId: Uint16;
  public native let treeVariable: CName;
  public native let v: Bool;
}

public native struct LibTreeDefCName {
  public native let variableId: Uint16;
  public native let treeVariable: CName;
  public native let v: CName;
}

public native struct LibTreeDefEnum {
  public native let variableId: Uint16;
  public native let treeVariable: CName;
  public native let v: Int64;
}

public native struct LibTreeDefFloat {
  public native let variableId: Uint16;
  public native let treeVariable: CName;
  public native let v: Float;
}

public native struct LibTreeDefInt32 {
  public native let variableId: Uint16;
  public native let treeVariable: CName;
  public native let v: Int32;
}

public native struct LibTreeDefISerializable {
  public native let variableId: Uint16;
  public native let treeVariable: CName;
  public native let v: ref<ISerializable>;
}

public native struct LibTreeDefNodeRef {
  public native let variableId: Uint16;
  public native let treeVariable: CName;
  public native let v: NodeRef;
}

public native struct LibTreeDefTree {
  public native let variableId: Uint16;
  public native let treeVariable: CName;
  public native let v: ref<LibTreeCTreeReference>;
}

public native struct LibTreeDefTreeList {
  public native let variableId: Uint16;
  public native let treeVariable: CName;
  public native let v: array<ref<LibTreeCTreeReference>>;
}

public abstract native class LibTreeDefTreeVariable extends ISerializable {
  public native let id: Uint16;
  public native let readableName: CName;
}

public native class LibTreeDefTreeVariableBool extends LibTreeDefTreeVariableBoolBase {
  public native let exportAsProperty: Bool;
  public native let defaultValue: Bool;
}

public abstract native class LibTreeDefTreeVariableBoolBase extends LibTreeDefTreeVariable {}

public native class LibTreeDefTreeVariableCName extends LibTreeDefTreeVariable {
  public native let exportAsProperty: Bool;
  public native let defaultValue: CName;
}

public native class LibTreeDefTreeVariableEnum extends LibTreeDefTreeVariable {
  public native let exportAsProperty: Bool;
  public native let enumClass: CName;
  public native let defaultValue: Int64;
}

public native class LibTreeDefTreeVariableFloat extends LibTreeDefTreeVariable {
  public native let exportAsProperty: Bool;
  public native let defaultValue: Float;
}

public native class LibTreeDefTreeVariableInt32 extends LibTreeDefTreeVariable {
  public native let exportAsProperty: Bool;
  public native let defaultValue: Int32;
}

public abstract native class LibTreeDefTreeVariableISerializable extends LibTreeDefTreeVariable {
  public native let exportAsProperty: Bool;
}

public native class LibTreeDefTreeVariableNodeRef extends LibTreeDefTreeVariable {
  public native let exportAsProperty: Bool;
  public native let defaultValue: NodeRef;
}

public native struct LibTreeDefTreeVariablesList {
  public native let list: array<ref<LibTreeDefTreeVariable>>;
}

public native class LibTreeDefTreeVariableTreeRef extends LibTreeDefTreeVariable {
  public native let exportAsProperty: Bool;
  public native let defaultValue: ref<LibTreeCTreeReference>;
}

public native class LibTreeDefTreeVariableTreeRefList extends LibTreeDefTreeVariable {
  public native let exportAsProperty: Bool;
  public native let defaultValue: array<ref<LibTreeCTreeReference>>;
}

public native class LibTreeDefTreeVariableVector extends LibTreeDefTreeVariable {
  public native let exportAsProperty: Bool;
  public native let defaultValue: Vector3;
}

public native struct LibTreeDefVector {
  public native let variableId: Uint16;
  public native let treeVariable: CName;
  public native let v: Vector3;
}

public enum LibTreeEParameterType {
  PARAM_Bool = 0,
  PARAM_Int32 = 1,
  PARAM_Enum = 2,
  PARAM_Float = 3,
  PARAM_CName = 4,
  PARAM_TreeRef = 5,
  PARAM_TreeRefList = 6,
  PARAM_NodeRef = 7,
  PARAM_Vector = 9,
}

public native struct LibTreeGenericData {}

public abstract native class LibTreeINodeDefinition extends ISerializable {}

public native struct LibTreeParameter {
  public native let parameterName: CName;
  public native let parameterId: Uint16;
  public native let parameterType: LibTreeEParameterType;
  public native let value: Variant;
}

public native struct LibTreeParameterList {
  public native let parameters: array<LibTreeParameter>;
}

public native struct LibTreeParametersForwarder {
  public native let overrides: array<Uint32>;
}

public native struct LibTreeSharedVarReferenceName {
  public native let name: CName;
}

public native struct LibTreeSharedVarRegistrationName {
  public native let name: CName;
}

public native class LightAreaSettings extends IAreaSettings {
  public native let latitude: CurveDataFloat;
  public native let season: ETimeOfYearSeason;
  public native let sunRotationOffset: CurveDataFloat;
  public native let sunColor: CurveDataHDRColor;
  public native let sunSize: CurveDataFloat;
  public native let moonRotationOffset: CurveDataFloat;
  public native let moonColor: CurveDataHDRColor;
  public native let moonSize: CurveDataFloat;
  public native let specularTint: CurveDataHDRColor;
}

public native class LightChannelComponent extends IVisualComponent {
  public native let isEnabled: Bool;
  public native let channels: Uint16; // rendLightChannel
  public native let shape: ref<GeometryShape>;
}

public native class LightColorSettings extends IAreaSettings {
  public native let light: worldWorldGlobalLightParameters;
}

public native class LightDirectionSettings extends IAreaSettings {
  public native let direction: GlobalLightingTrajectoryOverride;
}

public native class LightGroupsAreaSettings extends IAreaSettings {
  public native let groupFade: [CurveDataFloat; 8];
}

public native struct LoadoutData {
  public native let slotID: TweakDBID;
  public native let itemID: ItemID;
}

public native class localizationPersistenceCLNumberDateContainer extends ISerializable {
  public native let clNumber: CName;
  public native let clTimestamp: CName;
  public native let clGeneratedIds: array<String>;
}

public native class localizationPersistenceLocDataMap extends ISerializable {
  public native let entries: array<localizationPersistenceLocDataMapEntry>;
}

public native struct localizationPersistenceLocDataMapEntry {
  public native let langCode: CName;
  public native let onscreensPath: ResourceAsyncRef; // raRef<JsonResource>
  public native let subtitlePath: ResourceAsyncRef; // raRef<JsonResource>
}

public native class localizationPersistenceOnScreenEntries extends ISerializable {
  public native let entries: array<localizationPersistenceOnScreenEntry>;
}

public native struct localizationPersistenceOnScreenEntry {
  public native let primaryKey: Uint64;
  public native let secondaryKey: String;
  public native let femaleVariant: String;
  public native let maleVariant: String;
}

public native class localizationPersistenceSubtitleEntries extends ISerializable {
  public native let entries: array<localizationPersistenceSubtitleEntry>;
}

public native struct localizationPersistenceSubtitleEntry {
  public native let stringId: CRUID;
  public native let femaleVariant: String;
  public native let maleVariant: String;
}

public native class localizationPersistenceSubtitleMap extends ISerializable {
  public native let entries: array<localizationPersistenceSubtitleMapEntry>;
}

public native struct localizationPersistenceSubtitleMapEntry {
  public native let subtitleGroup: CName;
  public native let subtitleFile: ResourceAsyncRef; // raRef<JsonResource>
}

public enum locHolocallActorMode {
  Default = 0,
  ActorUsesHolocall = 1,
  ActorDoesntUseHolocall = 2,
}

public enum locVoiceoverContext {
  Vo_Context_Quest = 0,
  Vo_Context_Community = 1,
  Vo_Context_Combat = 2,
  Vo_Context_Minor_Activity = 3,
  Default_Vo_Context = 5,
}

public enum locVoiceoverExpression {
  Vo_Expression_Spoken = 0,
  Vo_Expression_Phone = 1,
  Vo_Expression_InnerDialog = 2,
  Vo_Expression_Loudspeaker_Room = 3,
  Vo_Expression_Loudspeaker_Street = 4,
  Vo_Expression_Loudspeaker_City = 5,
  Vo_Expression_Radio = 6,
  Vo_Expression_GlobalTV = 7,
  Vo_Experession_Cb_Radio = 8,
  Vo_Expression_Cyberspace = 9,
  Vo_Expression_Possessed = 10,
  Vo_Expression_Helmet = 11,
}

public native class locVoiceoverLengthMap extends ISerializable {
  public native let entries: array<locVoLengthEntry>;
}

public native class locVoiceoverMap extends ISerializable {
  public native let entries: array<locVoLineEntry>;
}

public native struct locVoiceTag {
  public native let voiceTag: CName;
  public native let voicesetScenePath: String;
  public native let id: CRUID;
  public native let isApuc: Bool;
}

public enum locVoiceTagGender {
  Undefined = 0,
  Male = 1,
  Female = 2,
}

public native class locVoiceTagListResource extends CResource {
  public native let voiceTags: array<locVoiceTag>;
}

public native struct locVoLanguageDataEntry {
  public native let languageCode: CName;
  public native let voiceverMapReport: ResourceAsyncRef; // raRef<JsonResource>
  public native let lengthMapReport: ResourceAsyncRef; // raRef<JsonResource>
  public native let voMapChunks: array<ResourceAsyncRef>;
}

public native class locVoLanguageDataMap extends ISerializable {
  public native let entries: array<locVoLanguageDataEntry>;
}

public native struct locVoLengthEntry {
  public native let stringId: CRUID;
  public native let femaleLength: Float;
  public native let maleLength: Float;
}

public native struct locVoLineEntry {
  public native let stringId: CRUID;
  public native let femaleResPath: ResourceAsyncRef; // raRef<locVoResource>
  public native let maleResPath: ResourceAsyncRef; // raRef<locVoResource>
}

public native class locVoResource extends CResource {}

public native struct LookAtPartInfo {
  public native let partName: CName;
  public native let defaultPositionBoneName: CName;
}

public native struct LookAtPartsDependency {
  public native let masterPart: CName;
  public native let slavePart: CName;
  public native let angle: Float;
  public native let speedToTargetFactor: Float;
  public native let speedToTargetByAngleCurve: CurveDataFloat;
  public native let verticalPullSpeedFactor: Float;
  public native let verticalPullSpeedByAngleCurve: CurveDataFloat;
  public native let horizontalPullSpeedFactor: Float;
  public native let horizontalPullSpeedByAngleCurve: CurveDataFloat;
  public native let pullScaleBySquareSizeFactor: Float;
  public native let pullScaleBySquareSizeCurve: CurveDataFloat;
  public native let innerSquareScale: Float;
}

public native struct LookAtStateMachineSettings {
  public native let partName: CName;
  public native let partAlias: CName;
  public native let sphereAttachmentBone: CName;
  public native let sphereRadius: Float;
  public native let followingSpeedFactor: Float;
  public native let followingSpeedByAngleCurve: CurveDataFloat;
  public native let enableFloatTrack: CName;
  public native let eyesOverrideFloatTrack: CName;
  public native let transitionSpeedMultiplier: Float;
  public native let blendWeightPowFactor: Float;
  public native let coneLimitReached: CName;
  public native let allowToBlendBehindBack: Bool;
}

public importonly class LoSFinderSystem extends ILoSFinderSystem {}

public importonly class MappinComponent extends IPlacedComponent {
  public native let data: MappinData;
}

public native struct MaterialLayerDef {
  public native let name: CName;
  public native let size: Uint32;
  public native let colorPalette: array<Color>;
  public native let material: ResourceRef; // rRef<CMaterialInstance>
}

public native struct MaterialParameterInstance {
  public native let name: CName;
  public native let data: Variant;
}

public native struct MaterialPass {
  public native let stagePassNameRegular: CName;
  public native let stagePassNameDiscarded: CName;
  public native let depthStencilMode: PSODescDepthStencilModeDesc;
  public native let rasterizerMode: PSODescRasterizerModeDesc;
  public native let blendMode: PSODescBlendModeDesc;
  public native let stencilReadMask: Uint8;
  public native let stencilWriteMask: Uint8;
  public native let stencilRef: Uint8;
  public native let orderIndex: Uint8;
  public native let enablePixelShader: Bool;
}

public native struct MaterialTechnique {
  public native let passes: array<MaterialPass>;
  public native let featureFlagsEnabledMask: FeatureFlagsMask;
  public native let streamsToBind: Uint32;
}

public native struct MaterialUsedParameter {
  public native let name: CName;
  public native let register: Uint8;
}

public native class mathExprExpression extends ISerializable {
  public native let tokenData: array<Uint32>;
  public native let valuesData: array<Float>;
  public native let returnVarType: Uint16;
}

public native class MergedMesh extends CMesh {}

public native struct meshChunkFlags {
  public native let renderInScene: Bool;
  public native let renderInShadows: Bool;
  public native let isTwoSided: Bool;
  public native let isRayTracedEmissive: Bool;
  public native let isConsoleLOD0: Bool;
  public native let skipDynamicDecalGeneration: Bool;
}

public native struct meshChunkIndicesOffset {
  public native let start: Uint32;
  public native let count: Uint32;
  public native let boneIndex: Uint8;
}

public native struct meshChunkMaterials {
  public native let materialNames: array<CName>;
}

public native struct meshChunkOffset {
  public native let chunkIndex: Uint32;
  public native let start: Uint16;
  public native let count: Uint16;
}

public native struct meshCookedClothMeshTopologyData {
  public native let gfxIndexToTriangles: array<Uint32>;
  public native let phxIndexToTriangles: array<Uint32>;
  public native let gfxBarycentrics: array<Uint32>;
  public native let phxBarycentrics: array<Uint32>;
  public native let phxLodSwitchData: array<Uint32>;
  public native let phxSimulated: array<Uint32>;
  public native let gfxNumIndicesToTriangles: Uint32;
  public native let phxNumIndicesToTriangles: Uint32;
  public native let gfxNumBarycentrics: Uint32;
  public native let phxNumBarycentrics: Uint32;
  public native let phxNumLodSwitchData: Uint32;
  public native let phxNumSimulated: Uint32;
}

public native struct meshDestructionBond {
  public native let bondIndex: Uint16;
  public native let bondHealth: Uint8;
}

public native struct meshGfxClothChunkData {
  public native let simulation: array<Uint16>;
}

public native struct meshImportedSnapTags {
  public native let includeTags: array<CName>;
  public native let excludeTags: array<CName>;
}

public native struct meshLocalMaterialHeader {
  public native let offset: Uint32;
  public native let size: Uint32;
}

public native class meshMeshImportedSnapPoint extends ISerializable {
  public native let localToCloud: Matrix;
  public native let range: Float;
  public native let rotationAlignmentSteps: Uint8;
  public native let snapTags: meshImportedSnapTags;
}

public native struct meshMeshMaterialBuffer {
  public native let rawDataHeaders: array<meshLocalMaterialHeader>;
}

public native class meshMeshParamBakedDestructionData extends meshMeshParameter {
  public native let regionData: array<meshRegionData>;
}

public native class meshMeshParamBendedRoad extends meshMeshParameter {
  public native let occInds: array<Uint16>;
  public native let occVerts: array<Vector4>;
  public native let occSkinWeights: array<Vector4>;
  public native let occSkinInds: array<Color>;
  public native let collInds: array<array<Uint16>>;
  public native let collVerts: array<array<Vector3>>;
  public native let collSkinWeights: array<array<Vector4>>;
  public native let collSkinInds: array<array<Color>>;
  public native let collMaterialName: array<String>;
  public native let collFilterPresetName: array<String>;
  public native let collFaceMatInds: array<array<Uint16>>;
  public native let collFaceMaterialNames: array<array<String>>;
}

public native class meshMeshParamCloth_Graphical extends meshMeshParameter {
  public native let lodChunkIndices: array<array<Uint16>>;
  public native let chunks: array<meshGfxClothChunkData>;
  public native let latchers: array<array<array<Uint16>>>;
}

public native class meshMeshParamCloth extends meshMeshParameter {
  public native let lodChunkIndices: array<array<Uint16>>;
  public native let chunks: array<meshPhxClothChunkData>;
  public native let drivers: array<array<Uint16>>;
  public native let capsules: ref<physicsclothClothCapsuleExportData>;
}

public native class meshMeshParamCompiledPhysics extends meshMeshParameter {
  public native let collection: ref<physicsDeferredCollection>;
}

public native class meshMeshParamDeformableShapesData extends meshMeshParameter {
  public native let ownerIndex: array<Uint8>;
  public native let startingPose: array<Transform>;
  public native let finalPose: array<Transform>;
}

public native class meshMeshParamDestructionBonds extends meshMeshParameter {
  public native let bonds: array<meshDestructionBond>;
}

public native class meshMeshParamDestructionBoneChunkMapping extends meshMeshParameter {
  public native let boneChunkMasks: array<Uint64>;
}

public native class meshMeshParamDestructionChunkIndicesOffsets extends meshMeshParameter {
  public native let offsets: array<meshChunkIndicesOffset>;
  public native let chunkOffsets: array<Uint32>;
}

public native class meshMeshParamDestructionStepData extends meshMeshParameter {
  public native let offsets: array<physicsDestructionHierarchyOffset>;
  public native let isInstantRemovable: String;
}

public abstract native class meshMeshParameter extends ISerializable {}

public native class meshMeshParamGarmentSupport extends meshMeshParameter {
  public native let chunkCapVertices: array<array<Uint32>>;
  public native let customMorph: Bool;
}

public native class meshMeshParamGpuBuffer extends meshMeshParameter {
  public native let stride: Uint32;
}

public native class meshMeshParamImportedSnapPoint extends meshMeshParameter {
  public native let snapFeatureData: array<ref<meshMeshImportedSnapPoint>>;
}

public native class meshMeshParamOccluderData extends meshMeshParameter {
  public native let occluderResource: ref<visIOccluderResource>;
  public native let defaultOccluderType: visWorldOccluderType;
  public native let autoHideDistanceScale: Uint8;
}

public native class meshMeshParamPhysics extends meshMeshParameter {
  public native let physicsData: ref<physicsSystemResource>;
}

public native class meshMeshParamShadowMeshCreationData extends meshMeshParameter {
  public native let geometries: array<ref<physicsICollider>>;
  public native let bonesPerGeometry: array<Int32>;
}

public native class meshMeshParamSpeedTreeWind extends meshMeshParameter {}

public native class meshMeshParamTerrain extends meshMeshParameter {
  public native let chunkBoundingBoxes: array<Box>;
}

public native class meshMeshParamTopologyData extends meshMeshParameter {
  public native let offsets: array<Uint32>;
  public native let sizes: array<Uint32>;
}

public native class meshMeshParamTopologyMetadata extends meshMeshParameter {
  public native let offsets: array<Uint32>;
  public native let sizes: array<Uint32>;
}

public native class meshMeshParamUICollisionData extends meshMeshParameter {
  public native let uvs: array<Vector2>;
  public native let trianglesIndices: array<Uint16>;
  public native let vertices: array<Vector3>;
}

public native class meshMeshParamWaterPatchData extends meshMeshParameter {
  public native let animLoop: Bool;
  public native let animLength: Float;
  public native let nodes: [[Float; 16]; 4096];
}

public native class meshMeshParamWorkspotOffsets extends meshMeshParameter {
  public native let names: array<CName>;
  public native let offsets: array<Matrix>;
}

public native struct meshPhxClothChunkData {}

public native struct meshRawClothData {
  public native let state: physicsclothState;
}

public native struct meshRegionData {
  public native let chunkDataIntact: array<meshChunkOffset>;
  public native let chunkDataFractured: array<meshChunkOffset>;
  public native let chunkMaskIntact: Uint64;
  public native let chunkMaskFractured: Uint64;
  public native let isStaticRemains: Bool;
}

public native struct MicroblendDef {
  public native let name: CName;
  public native let texture: ResourceRef; // rRef<CBitmapTexture>
}

public native class MinigameCollisionLogicAdvanced extends inkLogicController {
  public final native func GetDynObject()
}

public native class MinigameDynObjectAdvanced extends inkLogicController {
  public final native func GetGameState()
}

public abstract native class MinigameLogicControllerAdvanced extends inkLogicController {
  public native let playerLibraryName: CName;
  public native let playerColliderPositionOffset: Vector2;
  public native let playerColliderSizeOffset: Vector2;
  public native let gameplayRoot: inkCompoundRef;
  public native let baseSpeed: Float;
  public native let layers: array<inkWidgetRef>;
  public native let cheatCodes: array<SideScrollerCheatCodeAdvanced>;
  public native let acceptableCheatKeys: array<CName>;
  public final native func FinishGame()
}

public native class MinigamePlayerControllerAdvanced extends inkLogicController {
  public final native func GetGameState()
}

public native class MinimapDataNode extends worldNode {
  public native let encodedShapesRef: ResourceAsyncRef; // raRef<minimapEncodedShapes>
  public native let streamingDistance: Float;
  public native let localBounds: Box;
  public native let allInteriorShapes: Bool;
}

public native class MinimapDataNodeInstance extends worldINodeInstance {}

public native class minimapEncodedShapes extends CResource {
  public native let QuantizationScale: Vector2;
  public native let QuantizationBias: Vector2;
  public native let BoxQuantizationScale: Vector3;
  public native let BoxQuantizationBias: Vector3;
  public native let NumPoints: Uint32;
  public native let NumBorderPoints: Uint32;
  public native let NumFillPoints: Uint32;
  public native let NumShapes: Uint32;
  public native let NumSpatialBuckets: Uint32;
  public native let NumUniqueGeometry: Uint32;
  public native let NumOwners: Uint32;
  public native let Version: Uint32;
}

public native class MinimapHazardWarningMappinController extends BaseMinimapMappinController {}

public native class minimapuiGeometryWidget extends inkCanvas {
  public native let widgetTemplates: array<inkWidgetRef>;
  public native let settings: minimapuiSettings;
}

public native struct minimapuiSettings {
  public native let showTime: Float;
  public native let hideTime: Float;
}

public native struct MipMapGenParams {
  public native let applyToksvig_ShouldInvChannel: Bool;
  public native let applyToksvig_Channel: Uint8;
  public native let applyToksvig_sourceNormalMap: ResourceAsyncRef; // raRef<CBitmapTexture>
}

public native class ModdingSystem extends IGameSystem {}

public native class MorphTargetMesh extends resStreamedResource {
  public native let baseMesh: ResourceRef; // rRef<CMesh>
  public native let targets: array<MorphTargetMeshEntry>;
  public native let boundingBox: Box;
  public native let baseTextureParamName: CName;
  public native let blob: ref<IRenderResourceBlob>;
  public native let baseMeshAppearance: CName;
  public native let baseTexture: ResourceRef; // rRef<ITexture>
}

public native struct MorphTargetMeshEntry {
  public native let name: CName;
  public native let regionName: CName;
  public native let faceRegion: MorphTargetsFaceRegion;
  public native let boneNames: array<CName>;
  public native let boneRigMatrices: array<Matrix>;
}

public enum MorphTargetsDiffTextureSize {
  TEXTURE_SIZE_1024x1024 = 0,
  TEXTURE_SIZE_512x512 = 1,
  TEXTURE_SIZE_256x256 = 2,
}

public enum MorphTargetsFaceRegion {
  FACE_REGION_EYES = 0,
  FACE_REGION_NOSE = 1,
  FACE_REGION_MOUTH = 2,
  FACE_REGION_JAW = 3,
  FACE_REGION_EARS = 4,
  FACE_REGION_NONE = 255,
}

public native struct MorphTargetsTextureBlendInfo {
  public native let blend: Bool;
  public native let diffSize: MorphTargetsDiffTextureSize;
  public native let name: CName;
}

public native class MotionBlurAreaSettings extends IAreaSettings {
  public native let strength: Float;
}

public enum MountDescriptor_MountingType {
  Unmounted = 0,
  KeepState = 1,
  Vehicle = 3,
  MovingPlatform = 4,
}

public native class moveComponent extends entIMoverComponent {}

public native class moveDroneMotionPlannerComponent extends moveMotionPlannerComponent {}

public importonly class MoveEquip extends AttachmentSlotEvent {}

public abstract native class moveIMotionPlannerComponent extends IComponent {}

public native class moveMotionPlannerComponent extends moveIMotionPlannerComponent {
  public native let snapToGround: Bool;
}

public enum moveMovementOrientationType {
  NotSet = 0,
  Forward = 1,
  Backward = 2,
  Left = 3,
  Right = 4,
}

public abstract native class movePoliciesContract extends ISerializable {}

public native class movePoliciesContractMoveToSmartObject extends movePoliciesContract {}

public native class movePoliciesContractMoveToWorkspot extends movePoliciesContract {}

public native class MovePoliciesSystem extends IMovePoliciesSystem {}

public native struct moveReplicatedMovePoliciesState {
  public native let items: array<moveReplicatedMovePolicies>;
  public native let lastAppliedActionsTime: netTime;
}

public native class MoveSystem extends IMoveSystem {}

public native class MoveSystemStopEvent extends ActionEvent {}

public native class MovingPlatformSystem extends IMovingPlatformSystem {}

public native struct mpCMultiplayerDebugFunctions {
  public final static native func MPDebugPlaySound(sound: CName, position: Vector4)
  public final static native func MPDebugRemoteClientShutdown(hardExit: Bool)
}

public native class mpInteractionActivatorComponent extends IPlacedComponent {}

public native class mpPersistentTestBox extends GameObject {}

public native class MultiEcsManagerComponent extends IComponent {}

public native struct Multilayer_Layer {
  public native let matTile: Float;
  public native let mbTile: Float;
  public native let microblend: ResourceRef; // rRef<CBitmapTexture>
  public native let microblendContrast: Float;
  public native let microblendNormalStrength: Float;
  public native let microblendOffsetU: Float;
  public native let microblendOffsetV: Float;
  public native let opacity: Float;
  public native let offsetU: Float;
  public native let offsetV: Float;
  public native let material: ResourceRef; // rRef<Multilayer_LayerTemplate>
  public native let colorScale: CName;
  public native let normalStrength: CName;
  public native let roughLevelsIn: CName;
  public native let roughLevelsOut: CName;
  public native let metalLevelsIn: CName;
  public native let metalLevelsOut: CName;
  public native let overrides: CName;
}

public native struct Multilayer_LayerOverrideSelection {
  public native let colorScale: CName;
  public native let normalStrength: CName;
  public native let roughLevelsIn: CName;
  public native let roughLevelsOut: CName;
  public native let metalLevelsIn: CName;
  public native let metalLevelsOut: CName;
}

public native class Multilayer_LayerTemplate extends CResource {
  public native let overrides: Multilayer_LayerTemplateOverrides;
  public native let defaultOverrides: Multilayer_LayerOverrideSelection;
  public native let colorTexture: ResourceRef; // rRef<CBitmapTexture>
  public native let normalTexture: ResourceRef; // rRef<CBitmapTexture>
  public native let roughnessTexture: ResourceRef; // rRef<CBitmapTexture>
  public native let metalnessTexture: ResourceRef; // rRef<CBitmapTexture>
  public native let tilingMultiplier: Float;
  public native let colorMaskLevelsIn: [Float; 2];
  public native let colorMaskLevelsOut: [Float; 2];
}

public native struct Multilayer_LayerTemplateOverrides {
  public native let colorScale: array<Multilayer_LayerTemplateOverridesColor>;
  public native let roughLevelsIn: array<Multilayer_LayerTemplateOverridesLevels>;
  public native let roughLevelsOut: array<Multilayer_LayerTemplateOverridesLevels>;
  public native let metalLevelsIn: array<Multilayer_LayerTemplateOverridesLevels>;
  public native let metalLevelsOut: array<Multilayer_LayerTemplateOverridesLevels>;
  public native let normalStrength: array<Multilayer_LayerTemplateOverridesNormalStrength>;
}

public native struct Multilayer_LayerTemplateOverridesColor {
  public native let n: CName;
  public native let v: [Float; 3];
}

public native struct Multilayer_LayerTemplateOverridesLevels {
  public native let n: CName;
  public native let v: [Float; 2];
}

public native struct Multilayer_LayerTemplateOverridesNormalStrength {
  public native let n: CName;
  public native let v: Float;
}

public native class Multilayer_Mask extends CResource {
  public native let renderResourceBlob: rendRenderMultilayerMaskResource;
}

public native class Multilayer_Setup extends CResource {
  public native let layers: array<Multilayer_Layer>;
  public native let ratio: Float;
  public native let useNormal: Bool;
}

public importonly class MultiPrereq extends IPrereq {
  public native let aggregationType: gameAggregationType;
  public native let nestedPrereqs: array<ref<IPrereq>>;
}

public native class MuppetBlackboardsComponent extends MuppetComponent {}

public abstract native class MuppetComponent extends IComponent {}

public native class MuppetInputHandlerComponent extends IComponent {}

public native class MuppetInputStates extends MuppetComponent {
  public native let replicationTime: netTime;
}

public native class MuppetInventory extends MuppetComponent {}

public native class MuppetLocomotionComponent extends MuppetComponent {}

public native class MuppetPhysicsComponent extends MuppetComponent {}

public native class MuppetRawInput extends MuppetComponent {}

public native class MuppetStats extends MuppetComponent {}

public native class MuppetUpperBodyRequestsComponent extends MuppetComponent {}

public native class MusicEvent extends Event {
  public native let eventName: CName;
}

public native class MusicSync extends Event {
  public native let syncType: audioMusicSyncType;
  public native let syncParameter: Float;
}

public importonly class NarrationPlateComponent extends IComponent {
  public native let narrationCaption: CName;
  public native let narrationText: CName;
  public native let isEnabled: Bool;
}

public native struct navgendebugCompactCell {
  public native let cellData: Uint64;
}

public native struct navgendebugCompactContour {
  public native let rawVertices: array<Int32>;
  public native let simplifiedVertices: array<Int32>;
  public native let innerPoints: array<Int32>;
  public native let region: Uint16;
  public native let area: Uint8;
  public native let box: Box;
}

@neverRef()
public native class navgendebugCompactPolygon extends ISerializable {
  public native let index: Uint16;
  public native let indices: array<Uint16>;
  public native let neighbors: array<Uint16>;
  public native let area: Uint8;
  public native let region: Uint16;
  public native let flags: Uint16;
}

public native struct navgendebugCompactSpan {
  public native let spanData: Uint32;
}

public native struct navgendebugContourSet {
  public native let contours: array<navgendebugCompactContour>;
  public native let boundingBox: Box;
  public native let cellSize: Float;
  public native let cellHeight: Float;
  public native let width: Int32;
  public native let height: Int32;
  public native let borderSize: Int32;
  public native let maxError: Float;
}

@neverRef()
public native class navgendebugHeightfield extends ISerializable {
  public native let bounds: Box;
  public native let cellSize: Float;
  public native let cellHeight: Float;
  public native let width: Uint16;
  public native let height: Uint16;
  public native let rawSpans: navgendebugSpansData;
  public native let compactSpans: navgendebugSpansData;
  public native let cells: array<navgendebugCompactCell>;
  public native let regions: array<Uint16>;
  public native let distancefield: array<Uint16>;
  public native let maxDistancefieldValue: Uint16;
}

public native struct navgendebugInputGeometry {
  public native let triangles: array<navgendebugInputGeometryTriangle>;
  public native let tileBoundingBox: Box;
  public native let extrudedBoundingBox: Box;
}

public native struct navgendebugInputGeometryTriangle {
  public native let vertices: [Vector3; 3];
  public native let area: Uint8;
}

@neverRef()
public native class navgendebugPolyMesh extends ISerializable {
  public native let vertices: array<Vector3>;
  public native let polygons: array<navgendebugCompactPolygon>;
  public native let bounds: Box;
  public native let cellSize: Float;
  public native let cellHeight: Float;
  public native let borderSize: Int32;
  public native let maxEdgeError: Float;
  public native let maxVerticesPerPolygon: Int32;
}

public native struct navgendebugSpansData {
  public native let spans: array<navgendebugCompactSpan>;
  public native let areas: array<Uint8>;
  public native let filteredAreas: array<Uint8>;
}

public native class navgendebugTileGenerationDebugData extends ISerializable {
  public native let tileIndex: Uint32;
  public native let contours: navgendebugContourSet;
}

public native struct NavGenNavigationSetting {
  public native let navmeshImpact: NavGenNavmeshImpact;
}

public enum NavGenNavmeshImpact {
  Ignored = 1,
  Walkable = 0,
  Blocking = 2,
  Road = 3,
  Stairs = 4,
  Drones = 5,
  Terrain = 6,
  CrowdWalkable = 0,
}

public enum NavGenSamplingDensity {
  None = 0,
  Sparse = 1,
  Dense = 2,
  Very_dense = 3,
}

public native class NavigationFunctionalTests extends IScriptable {
  public final native func GetPathOnNavmesh()
  public final native func RunGPSQuery()
  public final native func UpdateGPSQuery()
}

public native class navLocomotionPath extends ISerializable {
  public native let splineNodeRef: NodeRef;
  public native let segments: array<navLocomotionPathSegmentInfo>;
  public native let backwardSegments: array<navLocomotionPathSegmentInfo>;
  public native let points: array<navLocomotionPathPointInfo>;
  public native let userData: array<navLocomotionPathPointUserDataEntry>;
}

public native struct navLocomotionPathPointInfo {
  public native let point: navSerializableSplineProgression;
  public native let userDataIndex: Uint32;
}

public native class navLocomotionPathPointUserData extends ISerializable {}

public native struct navLocomotionPathPointUserDataEntry {
  public native let userData: ref<navLocomotionPathPointUserData>;
  public native let nextUserData: Uint32;
}

public native class navLocomotionPathResource extends CResource {
  public native let paths: array<ref<navLocomotionPath>>;
}

public native struct navLocomotionPathSegmentInfo {
  public native let type: navLocomotionPathSegmentTypes;
  public native let segmentEnd: navSerializableSplineProgression;
  public native let offMeshLink: Uint64;
}

public enum navLocomotionPathSegmentTypes {
  Invalid = 0,
  Spline = 1,
  OffMeshLink = 2,
}

public enum navNavAreaID {
  Unwalkable = 0,
  Terrain = 1,
  Crouchable = 2,
  Regular = 3,
  Road = 4,
  Pavement = 5,
  Door = 10,
  Ladder = 11,
  Jump = 12,
  Elevator = 14,
  Stairs = 15,
  Drones = 16,
  Exploration = 17,
  CrowdWalkable = 5,
}

public enum navPathQueryDebugStatus {
  InvalidQuery = 0,
  Active = 1,
  WaitingForStreaming = 2,
  Completed = 3,
  NoPathPossible = 4,
}

public native class navRuntimeSystemPathfinding extends worldIRuntimeSystem {}

public native struct navSerializableSplineProgression {
  public native let sectionIdx: Uint32;
  public native let alpha: Float;
}

public native struct netEntityAttachmentInterface {
  public native let time: netTime;
}

public native class netEntitySystem extends worldIRuntimeSystem {}

public abstract native struct netIComponentState {
  public native let componentName: CName;
  public native let enabled: Bool;
}

public abstract native struct netIEntityState {
  public native let recordID: TweakDBID;
  public native let persistentID: Uint64;
}

public abstract native class netIIngameProfilerSystem extends IGameSystem {}

public native struct netPeerID {
  public native let value: Uint8;
}

public importonly class NetrunnerPrototypeComponent extends IComponent {
  public native let structs: array<gameNetrunnerPrototypeStruct>;
}

public importonly class NetrunnerPrototypeNodeSetupEvent extends Event {
  public native let scale: Vector3;
}

public native struct netTime {
  public native let milliSecs: Uint64;
}

public native class NotifyFootstepMaterialContextChangedEvent extends Event {
  public native let footwareType: CName;
  public native let surfaceFlavourName: CName;
}

public native class NotImplementedAICommandParams extends AICommandParams {}

public native class NotPrereq extends IPrereq {
  public native let negatedPrereq: ref<IPrereq>;
}

public native class NotPrereqState extends PrereqState {}

public native struct oauthAuthenticationToken {
  public native let token: String;
  public native let secret: String;
  public native let sessionHandle: String;
  public native let tokenExpiresIn: Uint64;
  public native let authorizationExpiresIn: Uint64;
}

public native class ObjectCarrierComponent extends IComponent {
  public native let objectToSpawn: TweakDBID;
}

public native class ObjectCarrierComponentAttached extends Event {}

public abstract native class ObjectCarrierComponentDetached extends Event {}

public native class ObjectCarrySystem extends IObjectCarrySystem {}

public importonly class ObjectSelectionManager extends AIObjectSelectionManagerInterface {}

public native class OnAxis extends inkPointerEvent {}

public native class OnDoubleClick extends inkPointerEvent {}

public native class OnEnter extends inkPointerEvent {}

public native class OnFocusLost extends inkFocusEvent {}

public native class OnFocusReceived extends inkFocusEvent {}

public native class OnHold extends inkPointerEvent {}

public native class OnHoverOut extends inkPointerEvent {}

public native class OnHoverOver extends inkPointerEvent {}

public native class OnLeave extends inkPointerEvent {}

public native class OnPress extends inkPointerEvent {}

public native class OnRelative extends inkPointerEvent {}

public native class OnRelease extends inkPointerEvent {}

public native class OnRepeat extends inkPointerEvent {}

public native class OnVisibilityBlockerAffectedTBHEvent extends Event {
  public native let newTBHModifier: Float;
}

public native struct OrientedBox {
  public native let position: Vector4;
}

public native class OutlineArea extends IArea {}

public native class PalladiaAdvertisementWidgetComponent extends AdvertisementWidgetComponent {}

public abstract native class PanzerBonus extends MinigameDynObjectAdvanced {
  public native let fallingSpeed: Float;
}

public native class PanzerBullet extends MinigameDynObjectAdvanced {}

public native class PanzerCloud extends MinigameDynObjectAdvanced {}

public native class PanzerEnemy extends MinigameDynObjectAdvanced {
  public native let noBonusChanceCoeff: Uint32;
  public native let health: Int32;
  public native let score: Uint32;
  public native let shootPoint: Vector2;
  public native let bulletSpeed: Float;
  public native let gameLayerName: CName;
  public native let explosionLibraryName: CName;
  public native let bulletLibraryName: CName;
  public native let lifeBonusLibraryName: CName;
  public native let lifeBonusChanceCoeff: Uint32;
  public native let scoreBonusLibraryName: CName;
  public native let scoreBonusChanceCoeff: Uint32;
  public native let score50ChanceCoeff: Uint32;
  public native let score100ChanceCoeff: Uint32;
  public native let score200ChanceCoeff: Uint32;
}

public native class PanzerEnemyAV extends PanzerEnemy {
  public native let speed: Float;
  public native let shotsAmount: Uint32;
  public native let longShotInterval: Float;
  public native let shortShotInterval: Float;
}

public native class PanzerEnemyBullet extends PanzerBullet {}

public native class PanzerEnemyDrone extends PanzerEnemy {
  public native let speed: Float;
  public native let shootIntervalMinimum: Float;
  public native let shootIntervalMaximum: Float;
}

public native class PanzerExplosion extends MinigameDynObjectAdvanced {
  public native let animationName: CName;
}

public native class PanzerFriendlyBullet extends PanzerBullet {}

public native class PanzerGameLogicController extends MinigameLogicControllerAdvanced {
  public native let gameOverDelay: Float;
  public native let mainMenuLibraryName: CName;
  public native let scoreboardLibraryName: CName;
  public native let panelsLayer: CName;
  public native let gameLayer: CName;
  public native let cloudsLayer: CName;
  public native let backgroundLibraryName: CName;
  public native let cloudsLibraryNames: array<CName>;
  public native let minCloudSpawnInterval: Float;
  public native let maxCloudSpawnInterval: Float;
  public native let minCloudSpeed: Float;
  public native let maxCloudSpeed: Float;
  public native let scoreCounter: inkTextRef;
  public native let livesCounter: inkTextRef;
  public native let moveUpKey: CName;
  public native let moveDownKey: CName;
  public native let moveLeftKey: CName;
  public native let moveRightKey: CName;
  public native let shootKey: CName;
  public native let backKey: CName;
  public native let submitKey: CName;
  public native let axisDeadZone: Float;
  public native let moveXAxis: CName;
  public native let moveYAxis: CName;
  public native let shootAxis: CName;
  public native let droneLibraryName: CName;
  public native let minDroneSpawnInterval: Float;
  public native let maxDroneSpawnInterval: Float;
  public native let avLibraryName: CName;
  public native let minAvSpawnInterval: Float;
  public native let maxAvSpawnInterval: Float;
}

public native class PanzerGameState extends MinigameStateAdvanced {}

public native class PanzerLifeBonus extends PanzerBonus {}

public native class PanzerPlayerController extends MinigameDynObjectAdvanced {
  public native let bulletSpeed: Float;
  public native let bulletSpawnOffset: Vector2;
  public native let bulletLibraryname: CName;
  public native let shootInterval: Float;
  public native let gameLayerName: CName;
  public native let invulnerableAnimationName: CName;
  public native let explosionLibraryName: CName;
}

public native class PanzerScoreBoard extends MinigameDynObjectAdvanced {
  public native let scoreboardList: inkVerticalPanelRef;
  public native let champions: array<PanzerScoreRecordData>;
  public native let recordWidgetLibraryName: CName;
}

public native class PanzerScoreBonus extends PanzerBonus {}

public native class PanzerScoreRecord extends inkLogicController {
  public native let nameWidget: inkTextRef;
  public native let scoreWidget: inkTextRef;
}

public native struct PanzerScoreRecordData {
  public native let name: String;
  public native let score: Uint32;
}

public native struct ParamData {
  public native let name: String;
  public native let type: String;
  public native let defaultValue: Variant;
}

public native struct ParticleBurst {
  public native let burstTime: Float;
  public native let spawnCount: Uint32;
  public native let spawnTimeRange: Float;
  public native let repeatTime: Float;
}

public native class ParticleDamage extends ISerializable {
  public native let boundingBoxes: array<Box>;
}

public native class PathTracingSettings extends IAreaSettings {
  public native let albedoModulation: Float;
  public native let diffuseGlobalScale: Float;
  public native let diffuseSunScale: Float;
  public native let diffuseSkyScale: Float;
  public native let diffuseLocalLightsScale: Float;
  public native let diffuseEmissiveScale: Float;
  public native let specularGlobalScale: Float;
  public native let specularSunScale: Float;
  public native let specularSkyScale: Float;
  public native let specularLocalLightsScale: Float;
  public native let specularEmissiveScale: Float;
  public native let maxIntensity: Float;
  public native let GIOnlyLightScale: Float;
  public native let rayNumber: Uint32;
  public native let bounceNumber: Uint32;
  public native let rayNumberScreenshot: Uint32;
  public native let bounceNumberScreenshot: Uint32;
}

public native class PhotoModeBackgroundViewComponent extends IComponent {
  public native let backgroundPrefabRef: NodeRef;
  public native let targetPointRef: NodeRef;
}

public native class PhotoModeCursorStateChangedEvent extends Event {
  public native let cursorEnabled: Bool;
  public native let keepCursorPosition: Bool;
}

public native class PhotoModeFailedToOpenEvent extends Event {}

public native class PhotoModeLastInputDeviceEvent extends Event {}

public native class PhotomodeLightComponent extends LightComponent {}

public native class PhotomodeLightObject extends GameObject {}

public native class PhotomodeLightResetEvent extends Event {}

public native class PhotoModeQuestPrefabStateListener extends worldIQuestPrefabStateListener {}

public native class PhotomodeRefreshSaturationColorEvent extends Event {}

public native class PhotoModeRegisaterCallbacksEvent extends Event {}

public native class PhotoModeUIHideForScreenshotEvent extends Event {
  public native let hide: Bool;
}

public native class PhotoModeUIInteractiveEvent extends Event {
  public native let interactive: Bool;
}

public native class PhotoModeUIVisibilityEvent extends Event {
  public native let visible: Bool;
}

public native class PhysicalDeformShapesEvent extends Event {
  public native let shapes: array<Int32>;
  public native let value: Float;
}

public native class PhysicalDestructionNode extends worldNode {
  public native let mesh: ResourceAsyncRef; // raRef<CMesh>
  public native let meshAppearance: CName;
  public native let forceLODLevel: Int32;
  public native let forceAutoHideDistance: Float;
  public native let destructionParams: physicsDestructionParams;
  public native let destructionLevelData: array<physicsDestructionLevelData>;
  public native let audioMetadata: CName;
  public native let navigationSetting: NavGenNavigationSetting;
  public native let useMeshNavmeshSettings: Bool;
  public native let systemsToNotifyFlags: Uint16;
}

public native class PhysicalFractureFieldNode extends worldNode {
  public native let shape: physicsTriggerShape;
  public native let fractureFieldParams: physicsFractureFieldParams;
}

public importonly class PhysicalSkinnedMeshComponent extends entSkinnedMeshComponent {
  public native let simulationType: physicsSimulationType;
  public native let useResourceSimulationType: Bool;
  public native let startInactive: Bool;
  public native let filterDataSource: physicsFilterDataSource;
  public native let filterData: ref<physicsFilterData>;
  public final native func CreatePhysicalBodyInterface()
}

public abstract importonly class PhysicalTriggerComponent extends IPlacedComponent {
  public native let simulationType: physicsSimulationType;
  public native let shape: physicsTriggerShape;
  public native let filterData: ref<physicsFilterData>;
  public native let isEnabled: Bool;
}

public native struct physicsApperanceMaterial {
  public native let apperanceName: CName;
  public native let materialFrom: CName;
  public native let material: CName;
}

public native struct physicsCacheEntry {
  public native let entryOffset: Uint32;
  public native let entrySize: Uint32;
}

public native struct physicsCacheKey {
  public native let key: physicsGeometryKey;
  public native let entryIndex: Uint32;
}

public native class physicsclothClothCapsuleExportData extends ISerializable {
  public native let capsules: array<physicsclothExportedCapsule>;
}

public native struct physicsclothExportedCapsule {
  public native let p0: Vector3;
  public native let p1: Vector3;
  public native let r0: Float;
  public native let r1: Float;
  public native let boneName: CName;
}

public native struct physicsclothPhaseConfig {
  public native let stiffness: Float;
  public native let stiffnessMultiplier: Float;
  public native let compressionLimit: Float;
  public native let stretchLimit: Float;
}

public native struct physicsclothRuntimeInfo {
  public native let translation: Vector3;
  public native let rotation: Quaternion;
  public native let gravity: Vector3;
  public native let damping: Float;
  public native let drag: Float;
  public native let inertia: Float;
  public native let numSolverIterations: Uint32;
  public native let stiffnessFrequency: Float;
  public native let friction: Float;
  public native let tetherStiffness: Float;
  public native let tetherScale: Float;
  public native let selfCollisionDistance: Float;
  public native let selfCollisionStiffness: Float;
  public native let liftCoefficient: Float;
  public native let dragCoefficient: Float;
  public native let gravityScale: Float;
  public native let motionConstraintStiffness: Float;
  public native let enableSelfCollision: Bool;
}

public native struct physicsclothState {
  public native let verticalPhaseData: physicsclothPhaseConfig;
  public native let horizontalPhaseData: physicsclothPhaseConfig;
  public native let bendPhaseData: physicsclothPhaseConfig;
  public native let shearPhaseData: physicsclothPhaseConfig;
  public native let runtimeInfo: physicsclothRuntimeInfo;
}

public native class physicsColliderBox extends physicsICollider {
  public native let halfExtents: Vector3;
  public native let isObstacle: Bool;
}

public native class physicsColliderCapsule extends physicsICollider {
  public native let radius: Float;
  public native let height: Float;
}

public native class physicsColliderConvex extends physicsICollider {
  public native let vertices: array<Vector3>;
  public native let indexBuffer: array<Uint8>;
  public native let polygonVertices: array<Uint16>;
}

public native class physicsColliderMesh extends physicsICollider {
  public native let faceMaterials: array<CName>;
}

public native class physicsColliderSphere extends physicsICollider {
  public native let radius: Float;
}

public native class physicsCollisionFilterResource extends ISerializable {
  public native let collisionPresetJson: ResourceRef; // rRef<JsonResource>
  public native let overridesJson: ResourceRef; // rRef<JsonResource>
  public native let queryPresetJson: ResourceRef; // rRef<JsonResource>
  public native let collisionGroups: [CName; 64];
  public native let queryGroups: [CName; 64];
}

@neverRef()
public native class physicsCollisionPresetDefinition extends ISerializable {
  public native let Name: CName;
  public native let Description: String;
  public native let ForceEnableCollisionCallbacks: Bool;
  public native let CollisionType: array<CName>;
  public native let CollisionMask: array<CName>;
  public native let QueryDetect: array<CName>;
}

public native struct physicsCollisionPresetOverride {
  public native let from: CName;
  public native let to: CName;
}

public native class physicsCollisionPresetsOverridesResource extends ISerializable {
  public native let overrides: array<physicsCollisionPresetOverride>;
}

public native class physicsCollisionPresetsResource extends ISerializable {
  public native let presets: array<physicsCollisionPresetDefinition>;
}

public native class physicsCustomFilterData extends ISerializable {
  public native let collisionType: array<CName>;
  public native let collideWith: array<CName>;
  public native let queryDetect: array<CName>;
}

public native class physicsDeferredCollection extends ISerializable {}

public native struct physicsDestructionHierarchyOffset {
  public native let combined: Uint32;
}

public native struct physicsDestructionLevelData {
  public native let filterData: ref<physicsFilterData>;
  public native let fracturingEffect: ResourceAsyncRef; // raRef<worldEffect>
}

public native struct physicsDestructionParams {
  public native let startInactive: Bool;
  public native let simulationType: physicsSimulationType;
  public native let markEdgeChunks: Bool;
  public native let useAggregatesForClusters: Bool;
  public native let turnDynamicOnImpulse: Bool;
  public native let buildConvexForClusters: Bool;
  public native let damageThreshold: Float;
  public native let damageEndurance: Float;
  public native let bondEndurance: Float;
  public native let accumulateDamage: Bool;
  public native let enableImpulseDamage: Bool;
  public native let impulseToDamage: Float;
  public native let contactToDamage: Float;
  public native let maxContactImpulseRatio: Float;
  public native let impulseChildPropagationFactor: Float;
  public native let impulsePropagationFactor: Float;
  public native let impulseDiminishingFactor: Float;
  public native let breakBonds: Bool;
  public native let debrisInstantRemovalThreshold: Float;
  public native let debrisTimeoutThreshold: Float;
  public native let debrisTimeout: Bool;
  public native let debrisTimeoutMin: Float;
  public native let debrisTimeoutMax: Float;
  public native let fadeOutTime: Float;
  public native let debrisMaxSeparation: Float;
  public native let visualsRemain: Bool;
  public native let debrisDestructible: Bool;
  public native let supportDamage: Bool;
  public native let maxAngularVelocity: Float;
  public native let fractureFieldMask: Uint16; // physicsFractureFieldType
}

public native class physicsFilterData extends ISerializable {
  public native let simulationFilter: SimulationFilter;
  public native let queryFilter: QueryFilter;
  public native let preset: CName;
  public native let customFilterData: ref<physicsCustomFilterData>;
}

public enum physicsFilterDataSource {
  Parent = 0,
  Collider = 1,
  Component = 0,
  Body = 1,
}

public enum physicsFractureFieldEffect {
  FE_Fracture = 0,
  FE_Erase = 1,
}

public native struct physicsFractureFieldParams {
  public native let origin: Vector3;
  public native let fractureFieldValue: Float;
  public native let destructionTypeMask: Uint16; // physicsDestructionType
  public native let fractureFieldTypeMask: Uint16; // physicsFractureFieldType
  public native let fractureFieldOptionsMask: Uint16; // physicsFractureFieldOptions
  public native let fractureFieldEffect: physicsFractureFieldEffect;
  public native let fractureFieldValueType: physicsFractureFieldValueType;
}

public enum physicsFractureFieldValueType {
  FFVT_Impulse = 0,
  FFVT_Velocity = 1,
}

public native class PhysicsFunctionalTests extends IScriptable {
  public final native func CreateTrigger()
  public final native func QueryOverlapBox()
}

public native class physicsGeometryCache extends CResource {
  public native let sectorEntries: array<physicsSectorEntry>;
  public native let sectorGeometries: array<physicsGeometryKey>;
  public native let sectorCacheEntries: array<physicsSectorCacheEntry>;
  public native let alwaysLoadedSector: physicsSectorEntry;
}

public native class physicsGeometryCacheArtifact extends CResource {
  public native let entryKeys: array<physicsCacheKey>;
  public native let entryTable: array<physicsCacheEntry>;
}

public native struct physicsGeometryKey {
  public native let pe: Uint8;
  public native let ta: [Uint8; 12];
}

public abstract native class physicsICollider extends ISerializable {
  public native let localToBody: Transform;
  public native let material: CName;
  public native let materialApperanceOverrides: array<physicsApperanceMaterial>;
  public native let tag: CName;
  public native let isImported: Bool;
  public native let isQueryShapeOnly: Bool;
  public native let volumeModifier: Float;
  public native let filterData: ref<physicsFilterData>;
}

public abstract native class physicsISystemObject extends ISerializable {
  public native let name: CName;
}

public enum physicsMaterialFriction {
  Enabled = 0,
  DisabledStrong = 1,
  Disabled = 2,
}

public native class physicsMaterialLibraryResource extends CResource {
  public native let defaultMaterial: ref<physicsMaterialResource>;
}

public native struct physicsMaterialReference {
  public native let name: CName;
}

public native class physicsMaterialResource extends CResource {
  public native let staticFriction: Float;
  public native let dynamicFriction: Float;
  public native let restitution: Float;
  public native let frictionMode: physicsMaterialFriction;
  public native let density: Float;
  public native let tags: physicsMaterialTags;
  public native let color: Color;
  public native let id: Uint64;
}

public enum physicsMaterialTagAIVisibility {
  None = 0,
  SemiTransparent = 1,
  Transparent = 2,
}

public enum physicsMaterialTagProjectilePenetration {
  TechOnly = 0,
  Any = 1,
  Medium = 2,
  Heavy = 3,
  Never = 4,
}

public enum physicsMaterialTagProjectileRicochet {
  Default = 0,
  Always = 1,
}

public native struct physicsMaterialTags {
  public native let aiVisibility: physicsMaterialTagVisibility;
  public native let playerVisibility: physicsMaterialTagVisibility;
  public native let projectilePenetration: physicsMaterialTagProjectilePenetration;
  public native let projectileRicochet: physicsMaterialTagProjectileRicochet;
  public native let vehicleTraction: physicsMaterialTagVehicleTraction;
}

public enum physicsMaterialTagType {
  AIVisibility = 0,
  PlayerVisibility = 1,
  ProjectilePenetration = 2,
  ProjectileRicochet = 3,
  VehicleTraction = 4,
}

public enum physicsMaterialTagVehicleTraction {
  Default = 0,
  Gravel = 1,
}

public enum physicsMaterialTagVisibility {
  None = 0,
  SemiTransparent = 1,
  Transparent = 2,
  Ignore = 3,
}

public abstract native class PhysicsParticleInitializer extends ISerializable {}

public native class physicsPhysicalJointPin extends ISerializable {
  public native let object: ref<physicsISystemObject>;
  public native let featureIndex: Int32;
  public native let localPosition: Vector3;
  public native let localRotation: Quaternion;
}

public enum physicsPhysicalSystemOwner {
  Unknown = 0,
  BakedDestructionNode = 1,
  ClothMeshNode = 2,
  CollisionAreaNode = 3,
  DecorationMeshNode = 4,
  DynamicMeshNode = 5,
  InstancedDestructibleNode = 6,
  PhysicalDestructionNode = 7,
  PhysicalTriggerNode = 8,
  StaticMeshNode = 9,
  TerrainCollisionNode = 10,
  WaterPatchNode = 11,
  WorldCollisionNode = 12,
  BakedDestructionComponent = 13,
  ClothComponent = 14,
  ColliderComponent = 15,
  PhysicalDestructionComponent = 16,
  PhysicalMeshComponent = 17,
  PhysicalSkinnedMeshComponent = 18,
  PhysicalTriggerComponent = 19,
  SimpleColliderComponent = 20,
  SkinnedClothComponent = 21,
  StateMachineComponent = 22,
  VehicleChassisComponent = 23,
  PhysicalParticleSystem = 24,
  PhotoModeSystem = 25,
  RagdollBinder = 26,
  FoliageDestruction = 27,
  EntityProxy = 28,
}

public enum physicsPhysicsJointAxis {
  AxisX = 0,
  AxisY = 1,
  AxisZ = 2,
  Twist = 3,
  Swing1 = 4,
  Swing2 = 5,
}

public native struct physicsPhysicsJointDrive {
  public native let forceLimit: Float;
  public native let isAcceleration: Bool;
  public native let stiffness: Float;
  public native let damping: Float;
}

public enum physicsPhysicsJointDriveType {
  AxisX = 0,
  AxisY = 1,
  AxisZ = 2,
  Swing = 3,
  Twist = 4,
  SLERP = 5,
}

public native struct physicsPhysicsJointDriveVelocity {
  public native let linearVelocity: Vector4;
  public native let angularVelocity: Vector4;
}

public native struct physicsPhysicsJointLimitBase {
  public native let restitution: Float;
  public native let bounceThreshold: Float;
  public native let stiffness: Float;
  public native let damping: Float;
  public native let contactDistance: Float;
}

public enum physicsPhysicsJointMotion {
  Locked = 0,
  Limited = 1,
  Free = 2,
}

public enum physicsProxyType {
  Invalid = 0,
  PhysicalSystem = 1,
  CharacterController = 2,
  Destruction = 3,
  ParticleSystem = 4,
  Trigger = 5,
  Cloth = 6,
  WorldCollision = 7,
  Terrain = 8,
  SimpleCollider = 9,
  AggregateSystem = 10,
  CharacterObstacle = 11,
  Ragdoll = 12,
  FoliageDestruction = 13,
}

@neverRef()
public native class physicsQueryPresetDefinition extends ISerializable {
  public native let name: CName;
  public native let queryGroups: array<CName>;
}

public native class physicsQueryPresetResource extends ISerializable {
  public native let presets: array<physicsQueryPresetDefinition>;
}

public enum physicsQueryUseCase {
  Default = 0,
  ActionAnimation = 1,
  AI = 2,
  AnimationComponent = 3,
  Audio = 4,
  AudioHedgehog = 5,
  Components = 6,
  Debug = 7,
  Gameplay = 8,
  GeomDescription = 9,
  LineOfSightTests = 10,
  MoveZAlignment = 11,
  Navigation = 12,
  Nodes = 13,
  PuppetBlackboardUpdater = 14,
  Ragdoll = 15,
  Scripts = 16,
  TargetingSystem = 17,
  VehicleAI = 18,
  VehicleAIColliders = 19,
  Vehicles = 20,
  VehicleChassis = 21,
  VehiclesCrowd = 22,
  VehicleWheel = 23,
  VehicleStreamingHack = 24,
  VehicleWater = 25,
  VisibilityResolver = 26,
  WorldUI = 27,
  GameEffects = 28,
  GameProjectiles = 29,
}

public native struct physicsRagdollBodyInfo {
  public native let ParentAnimIndex: Int32;
  public native let ChildAnimIndex: Int32;
  public native let ParentBodyIndex: Int32;
  public native let BodyPart: Uint32; // physicsRagdollBodyPartE
  public native let ShapeType: physicsRagdollShapeType;
  public native let ShapeRadius: Float;
  public native let HalfHeight: Float;
  public native let ShapeLocalTranslation: Vector3;
  public native let ShapeLocalRotation: Quaternion;
  public native let IsRootDisplacementPart: Bool;
  public native let SwingAnglesY: [Float; 2];
  public native let SwingAnglesZ: [Float; 2];
  public native let TwistAngles: [Float; 2];
  public native let IsStiff: Bool;
  public native let ExcludeFromEarlyCollision: Bool;
  public native let FilterDataOverride: CName;
}

public native struct physicsRagdollBodyNames {
  public native let ParentAnimName: CName;
  public native let ChildAnimName: CName;
}

public enum physicsRagdollShapeType {
  CAPSULE = 0,
  BOX = 1,
  SPHERE = 2,
}

public native class physicsSectorCacheArtifact extends CResource {
  public native let sectorGeometryKeys: array<physicsGeometryKey>;
  public native let sectorInPlaceGeometry: ref<physicsGeometryCacheArtifact>;
  public native let sectorBounds: Box;
}

public native struct physicsSectorCacheEntry {
  public native let entryOffset: Uint32;
  public native let entrySize: Uint32;
}

public native struct physicsSectorEntry {
  public native let sectorBounds: Box;
  public native let sectorHash: Uint64;
  public native let entryOffset: Uint32;
  public native let entrySize: Uint32;
}

public enum physicsShapeType {
  Box = 0,
  Sphere = 1,
  Capsule = 2,
  ConvexMesh = 3,
  TriangleMesh = 4,
  Invalid = 6,
}

public enum physicsSimulationType {
  Static = 0,
  Dynamic = 1,
  Kinematic = 2,
  Invalid = 3,
}

public enum physicsStaticCollisionShapeCategory {
  Interior = 0,
  Exterior = 1,
  Architecture = 2,
  Decoration = 3,
  Other = 4,
}

public native struct physicsStaticCollisionShapeDebugInfo {
  public native let sourceMeshPathHash: Uint64;
  public native let prefabPathHash: Uint64;
  public native let nodeNameHash: Uint64;
}

public native class physicsSystemBody extends physicsISystemObject {
  public native let params: physicsSystemBodyParams;
  public native let localToModel: Transform;
  public native let collisionShapes: array<ref<physicsICollider>>;
  public native let mappedBoneName: CName;
  public native let mappedBoneToBody: Transform;
  public native let isQueryBodyOnly: Bool;
}

public native struct physicsSystemBodyParams {
  public native let simulationType: physicsSimulationType;
  public native let linearDamping: Float;
  public native let angularDamping: Float;
  public native let solverIterationsCountPosition: Uint32;
  public native let solverIterationsCountVelocity: Uint32;
  public native let maxDepenetrationVelocity: Float;
  public native let maxAngularVelocity: Float;
  public native let maxContactImpulse: Float;
  public native let mass: Float;
  public native let inertia: Vector3;
  public native let comOffset: Transform;
}

public native class physicsSystemJoint extends physicsISystemObject {
  public native let localToWorld: Matrix;
  public native let pinA: ref<physicsPhysicalJointPin>;
  public native let pinB: ref<physicsPhysicalJointPin>;
  public native let linearLimit: physicsPhysicsJointLinearLimit;
  public native let twistLimit: physicsPhysicsJointAngularLimitPair;
  public native let swingLimit: physicsPhysicsJointLimitConePair;
  public native let driveY: physicsPhysicsJointDrive;
  public native let driveX: physicsPhysicsJointDrive;
  public native let driveZ: physicsPhysicsJointDrive;
  public native let driveTwist: physicsPhysicsJointDrive;
  public native let driveSwing: physicsPhysicsJointDrive;
  public native let driveSLERP: physicsPhysicsJointDrive;
  public native let driveVelocity: physicsPhysicsJointDriveVelocity;
  public native let drivePosition: Matrix;
  public native let projectionEnabled: Bool;
  public native let linearTolerance: Float;
  public native let angularTolerance: Float;
  public native let isBreakable: Bool;
  public native let breakingForce: Float;
  public native let breakingTorque: Float;
}

public native class physicsSystemResource extends CResource {
  public native let bodies: array<ref<physicsSystemBody>>;
  public native let joints: array<ref<physicsSystemJoint>>;
}

public native struct physicsTriggerShape {
  public native let shapeType: physicsShapeType;
  public native let shapeSize: Vector3;
  public native let shapeLocalPose: Transform;
}

public native class PingComponent extends IPlacedComponent {
  public native let associatedPingType: gamedataPingType;
}

public native struct Plane {
  public native let NormalDistance: Vector4;
}

public native class PlatformSpecificImageController extends inkLogicController {
  public native let textureAtlas: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let textureAtlas_PS4: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let textureAtlas_Prospero: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let textureAtlas_XB1: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let textureAtlas_Scarlett: ResourceAsyncRef; // raRef<inkTextureAtlas>
  public native let partName: CName;
  public native let partName_PS4: CName;
  public native let partName_Prospero: CName;
  public native let partName_XB1: CName;
  public native let partName_Scarlett: CName;
}

public native class PlatformSpecificTextController extends inkLogicController {
  public native let textLocKey: CName;
  public native let textLocKey_PS4: CName;
  public native let textLocKey_Prospero: CName;
  public native let textLocKey_XB1: CName;
  public native let textLocKey_Scarlett: CName;
}

public native class PlatformSpecificVideoController extends inkLogicController {
  public native let isLooped: Bool;
  public native let video: ResourceAsyncRef; // raRef<Bink>
  public native let video_PS4: ResourceAsyncRef; // raRef<Bink>
  public native let video_XB1: ResourceAsyncRef; // raRef<Bink>
}

public native class PlayerFunctionalTests extends IScriptable {
  public final native func RemoveCollision()
  public final native func SetCameraOrientation()
}

public native class PlayerMappinComponent extends IComponent {}

public native class PlayerProximityPrereq extends IPrereq {
  public native let squaredRange: Float;
}

public native class PlayerProximityPrereqState extends PrereqState {}

public native struct Point {
  public native let x: Int32;
  public native let y: Int32;
}

public native struct Point3D {
  public native let x: Int32;
  public native let y: Int32;
  public native let z: Int32;
}

public abstract native class populationModifier extends ISerializable {}

public native class populationPopulationSpawnParameter extends gameObjectSpawnParameter {}

public enum populationSpawnerObjectCtrlAction {
  Undefined = 0,
  Activate = 1,
  Deactivate = 2,
  Reactivate = 3,
  ResetKillCount = 4,
  Spawn = 1,
  Despawn = 2,
  Respawn = 3,
}

public native class populationSpawnModifier extends populationModifier {
  public native let spawnParameter: ref<gameObjectSpawnParameter>;
}

public native class PositionEvaluator extends PhysicsParticleInitializer {}

public enum ProximityProgressBarAction {
  Activated = 0,
  Inactivated = 1,
  Completed = 2,
  WentOutOfRange = 3,
}

public native class prvFunctionalTestsTrigger extends IScriptable {}

public native class PSMResetPhysicalRepresentation extends Event {}

public native class PSMResetStateMachine extends Event {
  public native let stateMachineIdentifier: StateMachineIdentifier;
}

public native class PSMTeleportEvent extends Event {}

public native struct PSODescBlendModeDesc {
  public native let numTargets: Uint8;
  public native let independent: Bool;
  public native let alphaToCoverage: Bool;
  public native let renderTarget: [PSODescRenderTarget; 8];
}

public enum PSODescBlendModeFactor {
  FAC_Zero = 0,
  FAC_One = 1,
  FAC_SrcColor = 2,
  FAC_InvSrcColor = 3,
  FAC_SrcAlpha = 4,
  FAC_InvSrcAlpha = 5,
  FAC_DestColor = 6,
  FAC_InvDestColor = 7,
  FAC_DestAlpha = 8,
  FAC_InvDestAlpha = 9,
  FAC_BlendFactor = 10,
  FAC_InvBlendFactor = 11,
  FAC_Src1Color = 12,
  FAC_InvSrc1Color = 13,
  FAC_Src1Alpha = 14,
  FAC_InvSrc1Alpha = 15,
}

public enum PSODescBlendModeOp {
  OP_Add = 0,
  OP_Subtract = 1,
  OP_RevSub = 2,
  OP_Min = 3,
  OP_Max = 4,
  OP_Or = 5,
  OP_And = 6,
  OP_Xor = 7,
  OP_nOr = 9,
  OP_nAnd = 8,
}

public enum PSODescBlendModeWriteMask {
  MASK_None = 0,
  MASK_R = 1,
  MASK_G = 2,
  MASK_B = 4,
  MASK_A = 8,
  MASK_RG = 3,
  MASK_RB = 5,
  MASK_RA = 9,
  MASK_GB = 6,
  MASK_GA = 10,
  MASK_BA = 12,
  MASK_RGB = 7,
  MASK_RGA = 11,
  MASK_RBA = 13,
  MASK_GBA = 14,
  MASK_RGBA = 15,
}

public enum PSODescDepthStencilModeComparisonMode {
  COMPARISON_Never = 0,
  COMPARISON_Less = 1,
  COMPARISON_Equal = 2,
  COMPARISON_LessEqual = 3,
  COMPARISON_Greater = 4,
  COMPARISON_NotEqual = 5,
  COMPARISON_GreaterEqual = 6,
  COMPARISON_Always = 7,
}

public native struct PSODescDepthStencilModeDesc {
  public native let depthTestEnable: Bool;
  public native let depthWriteEnable: Bool;
  public native let depthFunc: PSODescDepthStencilModeComparisonMode;
  public native let stencilEnable: Bool;
  public native let stencilReadMask: Bool;
  public native let stencilWriteMask: Bool;
  public native let frontFace: PSODescStencilFuncDesc;
}

public enum PSODescDepthStencilModeStencilOpMode {
  STENCILOP_Keep = 0,
  STENCILOP_Zero = 1,
  STENCILOP_Replace = 2,
  STENCILOP_IncreaseSaturate = 3,
  STENCILOP_DecreaseSaturate = 4,
  STENCILOP_Invert = 5,
  STENCILOP_Increase = 6,
  STENCILOP_Decrease = 7,
}

public enum PSODescPrimitiveTopologyType {
  Invalid = 0,
  Point = 1,
  Line = 2,
  Triangle = 3,
  Patch = 4,
}

public enum PSODescRasterizerModeCullMode {
  CULL_None = 0,
  CULL_Front = 1,
  CULL_Back = 2,
}

public native struct PSODescRasterizerModeDesc {
  public native let wireframe: Bool;
  public native let frontWinding: PSODescRasterizerModeFrontFaceWinding;
  public native let cullMode: PSODescRasterizerModeCullMode;
  public native let allowMSAA: Bool;
  public native let conservativeRasterization: Bool;
  public native let offsetMode: PSODescRasterizerModeOffsetMode;
  public native let scissors: Bool;
  public native let valid: Bool;
}

public enum PSODescRasterizerModeFrontFaceWinding {
  FRONTFACE_CCW = 0,
  FRONTFACE_CW = 1,
}

public enum PSODescRasterizerModeOffsetMode {
  OFFSET_None = 0,
  OFFSET_NormalBias = 1,
  OFFSET_ShadowBias = 2,
  OFFSET_DecalBias = 3,
}

public native struct PSODescRenderTarget {
  public native let blendEnable: Bool;
  public native let writeMask: PSODescBlendModeWriteMask;
  public native let colorOp: PSODescBlendModeOp;
  public native let alphaOp: PSODescBlendModeOp;
  public native let destFactor: PSODescBlendModeFactor;
  public native let destAlphaFactor: PSODescBlendModeFactor;
  public native let srcFactor: PSODescBlendModeFactor;
  public native let srcAlphaFactor: PSODescBlendModeFactor;
}

public native struct PSODescRenderTargetSetup {
  public native let rtFormats: [GpuWrapApieTextureFormat; 8];
  public native let dsFormat: GpuWrapApieTextureFormat;
}

public native struct PSODescStencilFuncDesc {
  public native let stencilPassOp: PSODescDepthStencilModeStencilOpMode;
  public native let stencilFunc: PSODescDepthStencilModeComparisonMode;
}

public native class puppetpreviewPuppetPreview_UIObjectsLoaderSystemListener extends gameuiIUIObjectsLoaderSystemListener {}

public native struct QsTransform {
  public native let Translation: Vector4;
  public native let Rotation: Quaternion;
  public native let Scale: Vector4;
}

public native struct Quad {
  public native let p1: Vector4;
  public native let p2: Vector4;
  public native let p3: Vector4;
  public native let p4: Vector4;
}

public native class QuadRacerPlayer extends MinigamePlayerController {
  public native let playerImage: inkImageRef;
  public native let leftTireSmoke: inkImageRef;
  public native let rightTireSmoke: inkImageRef;
  public native let rightFlame: inkImageRef;
  public native let leftFlame: inkImageRef;
  public native let leftTurnAtlasRegion: CName;
  public native let rightTurnAtlasRegion: CName;
  public native let straightTurnAtlasRegion: CName;
}

public native class QuadRacerRoad extends MinigameDynObject {
  public native let groundParts: array<CName>;
  public native let roadParts: array<CName>;
}

public native class QuadRacerSprite extends MinigameDynObject {}

public native struct QueryPreset {
  public native let presetName: CName;
}

public native class questAchievementManagerNodeDefinition extends questDisableableNodeDefinition {
  public native let type: ref<questIAchievementManagerNodeType>;
}

public native struct questActorOverrideEntry {
  public native let MetadataForOverride: CName;
  public native let ActorName: CName;
}

public native class questAddBraindanceClue_NodeType extends questIUIManagerNodeType {
  public native let clueName: CName;
  public native let startTime: Float;
  public native let endTime: Float;
  public native let layer: gameuiEBraindanceLayer;
}

public native class questAddCombatLogMessage_NodeType extends questIUIManagerNodeType {
  public native let message: String;
  public native let localizedMessage: LocalizationString;
}

public native class questAddRemoveContact_NodeType extends questIPhoneManagerNodeType {
  public native let params: array<questChangeContactList_NodeTypeParams>;
}

public native struct questAddRemoveContact_NodeTypeParams {
  public native let contact: CName;
  public native let addContact: Bool;
}

public native class questAddRemoveItem_NodeType extends questIItemManagerNodeType {
  public native let params: array<ref<questAddRemoveItem_NodeTypeParams>>;
}

public native class questAddRemoveItem_NodeTypeParams extends ISerializable {
  public native let sendNotification: Bool;
  public native let isPlayer: Bool;
  public native let objectRef: EntityReference;
  public native let entityRef: ref<questUniversalRef>;
  public native let nodeType: questEAddRemoveItemType;
  public native let itemID: TweakDBID;
  public native let quantity: Int32;
  public native let flagItemAddedCallbackAsSilent: Bool;
  public native let removeAllQuantity: Bool;
  public native let tagToRemove: CName;
  public native let itemIDsToIgnoreOnRemove: array<TweakDBID>;
  public native let tagsToIgnoreOnRemove: array<CName>;
}

public abstract native class questAICommandNodeBase extends questSignalStoppingNodeDefinition {}

public native class questAnimationEventsOverrideClearNode extends questIAudioNodeType {
  public native let resetGlobalOverride: Bool;
  public native let resetActorsOverride: Bool;
}

public native class questAnimationEventsOverrideNode extends questIAudioNodeType {
  public native let perActorOverrides: array<questActorOverrideEntry>;
  public native let GlobalMetadata: CName;
}

public native struct questAnimMoveOnSplineParams {
  public native let controllersSetupName: CName;
  public native let blendTime: Float;
  public native let globalInBlendTime: Float;
  public native let globalOutBlendTime: Float;
  public native let turnCharacterToMatchVelocity: Bool;
  public native let customStartAnimationName: CName;
  public native let customMainAnimationName: CName;
  public native let customStopAnimationName: CName;
  public native let startSnapToTerrain: Bool;
  public native let mainSnapToTerrain: Bool;
  public native let stopSnapToTerrain: Bool;
  public native let startSnapToTerrainBlendTime: Float;
  public native let stopSnapToTerrainBlendTime: Float;
}

public native class questAssignCharacter_NodeType extends questIVehicleManagerNodeType {
  public native let characterRef: EntityReference;
  public native let vehicleRef: EntityReference;
  public native let isPlayer: Bool;
  public native let assign: Bool;
  public native let slotName: CName;
  public native let isInstant: Bool;
  public native let clearAssignedVehicleIdWhenUnmounting: Bool;
  public native let entryAnimName: CName;
  public native let entrySlotName: CName;
}

public native class questAssignConvoy_NodeType extends questIVehicleManagerNodeType {
  public native let Followers: array<EntityReference>;
  public native let vehicleLeaderRef: EntityReference;
}

public enum questAttachmentOffsetMode {
  UseRealOffset = 0,
  UseCustomOffset = 1,
}

public native class questAudioCharacterManagerBreathing_NodeSubType extends questIAudioCharacterManager_NodeSubType {}

public native class questAudioCharacterManagerFootsteps_NodeSubType extends questIAudioCharacterManager_NodeSubType {}

public native class questAudioCharacterManagerNodeDefinition extends questDisableableNodeDefinition {
  public native let type: ref<questIAudioCharacterManager_NodeType>;
}

public native class questAudioCharacterSystemsManager_NodeType extends questIAudioCharacterManager_NodeType {
  public native let subType: ref<questIAudioCharacterManager_NodeSubType>;
}

public native class questAudioEventNodeType extends questIAudioNodeType {
  public native let events: array<audioAudEventStruct>;
  public native let musicEvents: array<audioAudEventStruct>;
  public native let switches: array<audioAudSwitch>;
  public native let params: array<audioAudParameter>;
  public native let dynamicParams: array<CName>;
  public native let event: audioAudEventStruct;
  public native let ambientUniqueName: CName;
  public native let emitter: CName;
  public native let isMusic: Bool;
  public native let objectRef: EntityReference;
  public native let isPlayer: Bool;
}

public enum questAudioEventPrefetchMode {
  AddEventPrefetch = 0,
  RemoveEventPrefetch = 1,
}

public native class questAudioEventPrefetchNode extends questIAudioNodeType {
  public native let prefetchEvents: array<questAudioEventPrefetchStruct>;
}

public native struct questAudioEventPrefetchStruct {
  public native let eventName: CName;
  public native let mode: questAudioEventPrefetchMode;
}

public native class questAudioFocusNodeType extends questIAudioNodeType {}

public native class questAudioMixNodeType extends questIAudioNodeType {
  public native let mixSignpost: CName;
}

public native class questAudioMusicSyncNodeType extends questIAudioNodeType {
  public native let syncType: audioMusicSyncType;
  public native let description: String;
  public native let syncTrack: CName;
  public native let userCue: CName;
}

public native class questAudioNodeDefinition extends questSignalStoppingNodeDefinition {
  public native let type: ref<questIAudioNodeType>;
}

public native class questAudioParameterNodeType extends questIAudioNodeType {
  public native let param: audioAudParameter;
  public native let isMusic: Bool;
  public native let objectRef: EntityReference;
  public native let isPlayer: Bool;
}

public native class questAudioSetListenerOverrideNodeType extends questIAudioNodeType {
  public native let enable: Bool;
}

public native class questAudioSwitchNodeType extends questIAudioNodeType {
  public native let switch: audioAudSwitch;
  public native let isMusic: Bool;
  public native let objectRef: EntityReference;
  public native let isPlayer: Bool;
}

public native class questAudioVehicleMultipliers_NodeType extends questIVehicleManagerNodeType {
  public native let vehicleRef: EntityReference;
  public native let multipliers: audioVehicleMultipliers;
}

public enum questAvailableVehicleType {
  AnyCar = 0,
  AnyMotorcycle = 1,
  AnyVehicle = 2,
  SpecificVehicle = 3,
}

public abstract native class questBaseObjectNodeDefinition extends questDisableableNodeDefinition {
  public native let reference: NodeRef;
}

public native class questBehaviourManagerNodeDefinition extends questSignalStoppingNodeDefinition {
  public native let puppet: EntityReference;
  public native let type: ref<workIWorkspotQuestAction>;
  public native let newType: ref<questIBehaviourManager_NodeType>;
}

public native class questBehind_ConditionType extends questISensesConditionType {
  public native let targetRef: EntityReference;
  public native let eventType: questBehindInteractionEventType;
}

public enum questBehindInteractionEventType {
  Undefined = 0,
  StartedBeingBehind = 1,
  StoppedBeingBehind = 2,
  IsBehind = 3,
  IsNotBehind = 4,
}

public enum questBlockAction {
  Block = 0,
  Unblock = 1,
  UnblockAll = 2,
}

public native class questBlockTokenActivation_NodeSubType extends questIContentTokenManager_NodeSubType {
  public native let action: questBlockAction;
  public native let source: CName;
  public native let resetTokenSpawnTimer: Bool;
}

public enum questBriefingPlayerType {
  Fullscreen = 0,
  Hud = 1,
  World = 2,
}

public native class questBriefingSequencePlayer_NodeType extends questIUIManagerNodeType {
  public native let function: questBriefingSequencePlayerFunction;
  public native let briefingResource: ResourceAsyncRef; // raRef<inkWidgetLibraryResource>
  public native let userData: ref<inkUserData>;
  public native let audioEvent: CName;
  public native let animationName: CName;
  public native let startMarkerName: CName;
  public native let endMarkerName: CName;
  public native let loopType: inkanimLoopType;
  public native let briefingPlayerType: questBriefingPlayerType;
  public native let briefingType: questBriefingType;
  public native let enableScanner: Bool;
}

public native class questBriefingSequencePlayerEvent extends Event {}

public enum questBriefingSequencePlayerFunction {
  StartSequence = 0,
  ChangeSequence = 1,
  FinishSequence = 2,
}

public enum questBriefingType {
  Fullscreen = 0,
  Hud = 1,
  World = 2,
}

public native class questBuild_ConditionType extends questIStatsScriptConditionType {}

public native class questCallContact_NodeType extends questIPhoneManagerNodeType {
  public native let caller: ref<gameJournalPath>;
  public native let addressee: ref<gameJournalPath>;
  public native let phase: questPhoneCallPhase;
  public native let mode: questPhoneCallMode;
  public native let prefabNodeRef: NodeRef;
  public native let applyPhoneRestriction: Bool;
  public native let isRejectable: Bool;
  public native let showAvatar: Bool;
  public native let visuals: questPhoneCallVisuals;
}

public native class questCameraClippingPlane_NodeType extends questISceneManagerNodeType {
  public native let preset: questCameraPlanesPreset;
}

public native class questCameraFocus_ConditionType extends questISystemConditionType {
  public native let objectRef: EntityReference;
  public native let timeInterval: Float;
  public native let onScreenTest: Bool;
  public native let useFrustrumCheck: Bool;
  public native let angleTolerance: Float;
  public native let inverted: Bool;
  public native let zoomed: Bool;
}

public enum questCameraParallaxSpace {
  Trajectory = 0,
  Camera = 1,
  Chest = 2,
}

public enum questCameraPlanesPreset {
  Undefined = 0,
  VeryNear = 1,
  Near = 2,
  Normal = 3,
  None = 4,
}

public native struct questChangeContactList_NodeTypeParams {
  public native let contact: ref<gameJournalPath>;
  public native let addContact: Bool;
  public native let sendNotification: Bool;
}

public native class questChangeGameDifficulty_NodeSubType extends questIGameManagerNonSignalStoppingNodeType {
  public native let difficulty: gameDifficulty;
}

public native class questChangeVoicesetState_NodeType extends questIVoicesetManager_NodeType {
  public native let params: array<questChangeVoicesetState_NodeTypeParams>;
}

public native struct questChangeVoicesetState_NodeTypeParams {
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let enableVoicesetLines: Bool;
  public native let enableVoicesetGrunts: Bool;
  public native let inputsToBlock: array<entVoicesetInputToBlock>;
}

public native class questCharacterAim_ConditionType extends questICharacterConditionType {
  public native let isPlayer: Bool;
  public native let preciseAiming: Bool;
  public native let targetRef: EntityReference;
}

public native class questCharacterAppearancePrefetched_ConditionType extends questICharacterConditionType {
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let appearanceName: CName;
}

public native class questCharacterAttack_ConditionType extends questICharacterConditionType {
  public native let attackerRef: EntityReference;
  public native let targetRef: EntityReference;
  public native let isTargetPlayer: Bool;
}

public native class questCharacterBodyType_CondtionType extends questICharacterConditionType {
  public native let objectRef: EntityReference;
  public native let isPlayer: Bool;
  public native let gender: CName;
}

public native class questCharacterCallReinforcements_ConditionType extends questICharacterConditionType {
  public native let puppetRef: EntityReference;
}

public native class questCharacterCombat_ConditionType extends questICharacterConditionType {
  public native let objectRef: EntityReference;
  public native let isPlayer: Bool;
  public native let inverted: Bool;
}

public native class questCharacterCondition extends questTypedCondition {
  public native let type: ref<questICharacterConditionType>;
}

public native class questCharacterControlledObjectHit_ConditionType extends questICharacterConditionType {
  public native let attackerRef: EntityReference;
  public native let targetRef: EntityReference;
  public native let isTargetPlayer: Bool;
  public native let includeHitTypes: array<questCharacterHitEventType>;
  public native let excludeHitTypes: array<questCharacterHitEventType>;
  public native let includeHitShapes: array<CName>;
  public native let excludeHitShapes: array<CName>;
}

public native class questCharacterCover_ConditionType extends questICharacterConditionType {
  public native let puppetRef: EntityReference;
  public native let coverRef: NodeRef;
}

public native class questCharacterCyberdeckProgram_ConditionType extends questICharacterConditionType {
  public native let cyberdeckProgramID: TweakDBID;
}

public native class questCharacterEquippedItem_ConditionType extends questICharacterConditionType {
  public native let isPlayer: Bool;
  public native let puppetRef: EntityReference;
  public native let itemID: TweakDBID;
  public native let itemTag: CName;
  public native let excludedTweakDBIDs: array<TweakDBID>;
  public native let excludedTags: array<CName>;
  public native let inverted: Bool;
}

public native class questCharacterEquippedItemAttachmentSlotsListener extends AttachmentSlotsListener {}

public native class questCharacterEquippedItemInventoryListener extends InventoryListener {}

public native class questCharacterEquippedWeapon_ConditionType extends questICharacterConditionType {
  public native let anyWeaponEquipped: Bool;
  public native let weaponID: String;
  public native let weaponTag: CName;
  public native let inverted: Bool;
}

public native class questCharacterGender_CondtionType extends questICharacterConditionType {
  public native let objectRef: EntityReference;
  public native let isPlayer: Bool;
  public native let gender: CName;
}

public native class questCharacterGroupAttitude_CondtionType extends questICharacterConditionType {
  public native let group1Name: CName;
  public native let group2Name: CName;
  public native let attitude: EAIAttitude;
}

public native class questCharacterHealth_ConditionType extends questICharacterConditionType {
  public native let objectRef: EntityReference;
  public native let isPlayer: Bool;
  public native let percent: Float;
  public native let comparisonType: EComparisonType;
}

public native class questCharacterHit_ConditionType extends questICharacterConditionType {
  public native let attackerRef: EntityReference;
  public native let isAttackerPlayer: Bool;
  public native let targetRef: EntityReference;
  public native let isTargetPlayer: Bool;
  public native let includeHitTypes: array<questCharacterHitEventType>;
  public native let excludeHitTypes: array<questCharacterHitEventType>;
  public native let includeHitShapes: array<CName>;
  public native let excludeHitShapes: array<CName>;
}

public enum questCharacterHitEventType {
  Bullet = 0,
  Explosion = 1,
  Melee = 2,
  Other = 3,
}

public native class questCharacterKilled_ConditionType extends questICharacterConditionType {
  public native let objectRef: EntityReference;
  public native let source: ref<questUniversalRef>;
  public native let comparisonParams: ref<questComparisonParam>;
  public native let killed: Bool;
  public native let unconscious: Bool;
  public native let defeated: Bool;
}

public native class questCharacterLifePath_ConditionType extends questICharacterConditionType {
  public native let lifePathID: TweakDBID;
}

public native class questCharacterManagerCombat_AssignSquad extends questICharacterManagerCombat_NodeSubType {
  public native let presetID: TweakDBID;
  public native let puppetRef: EntityReference;
  public native let squadType: AISquadType;
}

public native class questCharacterManagerCombat_ChangeLevel extends questICharacterManagerCombat_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let level: questInt32ValueWrapper;
  public native let setExactLevel: Bool;
}

public native class questCharacterManagerCombat_EquipWeapon extends questICharacterManagerCombat_NodeSubType {
  public native let equip: Bool;
  public native let weaponID: TweakDBID;
  public native let slotID: TweakDBID;
  public native let equipLastWeapon: Bool;
  public native let forceFirstEquip: Bool;
  public native let instant: Bool;
  public native let ignoreStateMachine: Bool;
}

public native class questCharacterManagerCombat_Kill extends questICharacterManagerCombat_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let noAnimation: Bool;
  public native let noRagdoll: Bool;
  public native let skipDefeatedState: Bool;
  public native let doDismemberment: Bool;
  public native let bodyPart: Uint32; // physicsRagdollBodyPartE
  public native let woundType: Uint16; // entdismembermentWoundTypeE
  public native let dismembermentStrenght: Float;
}

public native class questCharacterManagerCombat_ManageRagdoll extends questICharacterManagerCombat_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let enableRagdoll: Bool;
}

public native class questCharacterManagerCombat_ModifyHealth extends questICharacterManagerCombat_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let percent: Float;
  public native let setExactValue: Bool;
  public native let noDamageIndicator: Bool;
  public native let damageSourceRef: EntityReference;
}

public native class questCharacterManagerCombat_NodeType extends questICharacterManager_NodeType {
  public native let subtype: ref<questICharacterManagerCombat_NodeSubType>;
}

public native class questCharacterManagerCombat_SetDeathDirection extends questICharacterManagerCombat_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let direction: gameeventsDeathDirection;
}

public native class questCharacterManagerCombat_SetWeaponState extends questICharacterManagerCombat_NodeSubType {
  public native let areaType: gameCityAreaType;
}

public native class questCharacterManagerNodeDefinition extends questSignalStoppingNodeDefinition {
  public native let type: ref<questICharacterManager_NodeType>;
}

public native class questCharacterManagerParameters_EnableBumps extends questICharacterManagerParameters_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let enable: Bool;
  public native let policy: AIinfluenceEBumpPolicy;
}

public native class questCharacterManagerParameters_HealPlayer extends questICharacterManagerParameters_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let heal: Bool;
  public native let removeStatusEffects: Bool;
  public native let removeBuffs: Bool;
  public native let removeDebuffs: Bool;
  public native let resetCyberdeckRAM: Bool;
}

public native class questCharacterManagerParameters_NodeType extends questICharacterManager_NodeType {
  public native let subtype: ref<questICharacterManagerParameters_NodeSubType>;
}

public native class questCharacterManagerParameters_SetAnimset extends questICharacterManagerParameters_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let variableName: CName;
  public native let value: Float;
}

public native class questCharacterManagerParameters_SetAsCrowdObstacle extends questICharacterManagerParameters_NodeSubType {
  public native let params: array<questSetAsCrowdObstacle_NodeTypeParams>;
}

public native class questCharacterManagerParameters_SetAttitudeGroupForPuppet extends questICharacterManagerParameters_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let groupName: CName;
}

public native class questCharacterManagerParameters_SetCombatSpace extends questICharacterManagerCombat_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let combatSpaceSize: AICombatSpaceSize;
}

public native class questCharacterManagerParameters_SetGender extends questICharacterManagerParameters_NodeSubType {
  public native let params: array<questSetGender_NodeTypeParams>;
}

public native class questCharacterManagerParameters_SetGroupsAttitude extends questICharacterManagerParameters_NodeSubType {
  public native let set: Bool;
  public native let group1Name: CName;
  public native let group2Name: CName;
  public native let attitude: EAIAttitude;
}

public native class questCharacterManagerParameters_SetLifePath extends questICharacterManagerParameters_NodeSubType {
  public native let lifePathID: TweakDBID;
}

public native class questCharacterManagerParameters_SetLowGravity extends questICharacterManagerParameters_NodeSubType {
  public native let enable: Bool;
}

public native class questCharacterManagerParameters_SetMortality extends questICharacterManagerParameters_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let state: gameGodModeType;
  public native let resetToDefault: Bool;
  public native let source: CName;
}

public native class questCharacterManagerParameters_SetProgressionBuild extends questICharacterManagerParameters_NodeSubType {
  public native let buildID: TweakDBID;
}

public native class questCharacterManagerParameters_SetReactionPreset extends questICharacterManagerParameters_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let recordSelector: ref<questReactionPresetRecordSelector>;
}

public native class questCharacterManagerParameters_SetSensePreset extends questICharacterManagerParameters_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let presetID: TweakDBID;
  public native let main: Bool;
  public native let resetToMain: Bool;
}

public native class questCharacterManagerParameters_SetStatusEffect extends questICharacterManagerParameters_NodeSubType {
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let statusEffectID: TweakDBID;
  public native let isPlayerStatusEffectSource: Bool;
  public native let statusEffectSourceObject: EntityReference;
  public native let recordSelector: ref<questRecordSelector>;
  public native let set: Bool;
}

public native class questCharacterManagerVisuals_BreastSizeController extends questICharacterManagerVisuals_NodeSubType {
  public native let bodyGroupName: CName;
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let customizedSize: Bool;
}

public native class questCharacterManagerVisuals_ChangeEntityAppearance extends questCharacterManagerVisuals_EntityAppearanceOperationBase {}

public abstract native class questCharacterManagerVisuals_EntityAppearanceOperationBase extends questICharacterManagerVisuals_NodeSubType {
  public native let appearanceEntries: array<questCharacterManagerVisuals_EntityAppearanceOperationBaseEntityAppearanceEntry>;
}

public native struct questCharacterManagerVisuals_EntityAppearanceOperationBaseEntityAppearanceEntry {
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let appearanceName: CName;
}

public native class questCharacterManagerVisuals_GenitalsManager extends questICharacterManagerVisuals_NodeSubType {
  public native let bodyGroupName: CName;
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let enable: Bool;
}

public native class questCharacterManagerVisuals_NodeType extends questICharacterManager_NodeType {
  public native let subtype: ref<questICharacterManagerVisuals_NodeSubType>;
}

public native class questCharacterManagerVisuals_OverridePlayerCustomizations extends questICharacterManagerVisuals_NodeSubType {
  public native let customizationData: array<gameuiForcePlayerCustomizationData>;
}

public native class questCharacterManagerVisuals_OverridePlayerHairstyleAppearance extends questICharacterManagerVisuals_NodeSubType {
  public native let hairstyleIndex: Uint32;
  public native let hairstyleDefinitionName: CName;
  public native let beardIndex: Uint32;
  public native let beardPartIndex: Uint32;
  public native let beardDefinitionName: CName;
}

public native class questCharacterManagerVisuals_PrefetchEntityAppearance extends questCharacterManagerVisuals_EntityAppearanceOperationBase {}

public native class questCharacterManagerVisuals_SetBrokenNoseStage extends questICharacterManagerVisuals_NodeSubType {
  public native let brokenNoseStage: gameuiCharacterCustomization_BrokenNoseStage;
}

public native class questCharacterMount_ConditionType extends questICharacterConditionType {
  public native let anyParent: Bool;
  public native let parentRef: EntityReference;
  public native let parentIsPlayer: Bool;
  public native let anyChild: Bool;
  public native let childRef: EntityReference;
  public native let childIsPlayer: Bool;
  public native let condition: questMountConditionType;
  public native let enterAnimationFinished: Bool;
  public native let role: gameMountingSlotRole;
  public native let usePlayersVehicle: Bool;
  public native let playerVehicleName: String;
  public native let vehicleType: questMountVehicleType;
  public native let vehicleOrigin: questMountVehicleOrigin;
  public native let vehicleAfiliation: gamedataAffiliation;
}

public native class questCharacterMountedTogether_ConditionType extends questICharacterConditionType {
  public native let vehicleType: questMountVehicleType;
  public native let vehicleOrigin: questMountVehicleOrigin;
  public native let characters: array<ref<questMountedObjectInfo>>;
}

public native class questCharacterQuickHacked_ConditionType extends questICharacterConditionType {
  public native let objectRef: EntityReference;
  public native let quickHacked: Bool;
}

public native class questCharacterQuickHackUploadBegin_ConditionType extends questICharacterConditionType {
  public native let objectRef: EntityReference;
}

public native class questCharacterReaction_ConditionType extends questICharacterConditionType {
  public native let puppetRef: EntityReference;
  public native let isAnyReaction: Bool;
  public native let reactionBehaviorID: TweakDBID;
}

public native class questCharacterRoleFinished_ConditionType extends questICharacterConditionType {
  public native let objectRef: EntityReference;
  public native let role: AIFiniteRoleType;
}

public native class questCharacterSceneSpot_ConditionType extends questICharacterConditionType {
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let workName: CName;
  public native let waitForEnd: Bool;
}

public native class questCharacterSpawned_ConditionType extends questICharacterConditionType {
  public native let objectRef: EntityReference;
  public native let comparisonParams: ref<questComparisonParam>;
}

public native class questCharacterState_ConditionType extends questICharacterConditionType {
  public native let subType: ref<questICharacterConditionSubType>;
}

public native class questCharacterState_PlayerSubType extends questICharacterConditionSubType {
  public native let locomotionComparisonType: questEComparisonTypeEquality;
  public native let locomotionState: gamePSMLocomotionStates;
  public native let upperBodyComparisonType: questEComparisonTypeEquality;
  public native let upperBodyState: gamePSMUpperBodyStates;
  public native let weaponComparisonType: questEComparisonTypeEquality;
  public native let weaponState: gamePSMRangedWeaponStates;
  public native let timeDilationComparisonType: questEComparisonTypeEquality;
  public native let timeDilationState: gamePSMTimeDilation;
  public native let vehicleComparisonType: questEComparisonTypeEquality;
  public native let vehicleState: gamePSMVehicle;
  public native let takedownStateComparisonType: questEComparisonTypeEquality;
  public native let takedownState: gamePSMTakedown;
  public native let swimmingStateComparisonType: questEComparisonTypeEquality;
  public native let swimmingState: gamePSMSwimming;
}

public native class questCharacterState_PuppetSubType extends questICharacterConditionSubType {
  public native let puppetRef: EntityReference;
  public native let upperBodyComparisonType: questEComparisonTypeEquality;
  public native let upperBodyState: Int32;
  public native let highLevelComparisonType: questEComparisonTypeEquality;
  public native let highLevelState: Int32;
  public native let stanceComparisonType: questEComparisonTypeEquality;
  public native let stanceState: Int32;
}

public native class questCharacterStatPool_ConditionType extends questICharacterConditionType {
  public native let objectRef: EntityReference;
  public native let isPlayer: Bool;
  public native let percent: Float;
  public native let comparisonType: EComparisonType;
  public native let statPoolType: gamedataStatPoolType;
}

public native class questCharacterStatusEffect_CondtionType extends questICharacterConditionType {
  public native let objectRef: EntityReference;
  public native let isPlayer: Bool;
  public native let statusEffectID: String;
  public native let inverted: Bool;
}

public abstract native class questCharacterStatusEffectsListener extends IStatusEffectListener {}

public native class questCharacterTriggeredCombatInSecuritySystem_ConditionType extends questICharacterConditionType {
  public native let objectRef: EntityReference;
}

public native class questCharacterWorkspot_ConditionType extends questICharacterConditionType {
  public native let puppetRef: EntityReference;
  public native let isPlayer: Bool;
  public native let spotRef: NodeRef;
  public native let animationName: CName;
  public native let waitForAnimEnd: Bool;
}

public native class questCheckpointNodeDefinition extends questSignalStoppingNodeDefinition {
  public native let saveLock: Bool;
  public native let ignoreSaveLocks: Bool;
  public native let pointOfN