_G=GLOBAL
local json = require("json")

local running = false
local other = false

local function ShowMessage(message)
    local color = {1.0,0.9,0.0,1}
    _G.ChatHistory:AddToHistory(
        _G.ChatTypes.Message,
        nil,
        nil,
        "Crowd Control",
        message,
        color,
        "cc",
        false,
        false,
        TEXT_FILTER_CTX_CHAT
    )
end

local curplayer = nil
local playerid = nil

local function PrepPlayer()
    playerid = nil
    local host = nil
    
    local netplayers = _G.TheNet:GetClientTable()
    
    if netplayers == nil then    
        host = (_G.AllPlayers and _G.AllPlayers[1]) or _G.ThePlayer
    else
        for _, entity in pairs(netplayers) do
            if entity.performance ~= nil then
                playerid = entity.userid
            end
        end       
        for _, entity in pairs(_G.AllPlayers) do
            if entity.userid == playerid then
                playerid = nil
                host = entity
            end
        end
    end
    
    
    if not other then
        if host == nil then
            host = _G.ThePlayer
        end
        return host
    end
    playerid = nil

    local players = {}
    for _, entity in pairs(netplayers) do
        if entity.performance == nil then
            table.insert(players, entity)
        end
    end

    if #players <= 0 then
        for _, entity in pairs(_G.AllPlayers) do
            if entity ~= host then
                table.insert(players, entity)
            end
        end     
    end    

    if #players <= 0 then
        return nil
    end    

    local net = players[math.random(1, #players)]
    playerid = net.userid

    for _, entity in pairs(_G.AllPlayers) do
        if entity.userid == playerid then
            playerid = nil
            return entity
        end
    end

    return nil


end

local function GetPlayer()
    return curplayer
end

Assets = {
    Asset("IMAGE", "modicon.tex"),
    Asset("ATLAS", "modicon.xml")
}

local function SpeakMessage(message)
    local inst = GetPlayer()
    if inst ~= nil and inst.components.talker ~= nil then
        inst.components.talker:Say(message)
    end
end

local old_GetProfileFlairAtlasAndTex = _G.GetProfileFlairAtlasAndTex

_G.GetProfileFlairAtlasAndTex = function(item_key)
    if item_key=='cc' then
        local PROFILEFLAIR_ATLAS = "modicon.xml"
        local PROFILEFLAIR_DEFAULT = "profileflair_none.tex"
        return PROFILEFLAIR_ATLAS, item_key .. ".tex", PROFILEFLAIR_DEFAULT
    end
    return old_GetProfileFlairAtlasAndTex(item_key)
end

local num = 0
local effcode = {}

local function split(str, delimiter)
    local returnTable = {}
    for k, v in string.gmatch(str, "([^" .. delimiter .. "]+)") 
    do
        returnTable[#returnTable+1] = k
    end
    return returnTable
end

local function round(value, digits)
    digits = digits or 11
    return _G.tonumber(string.format("%." .. digits .. "f", value))
end

local function GetPositionOffsetByAngleAndRadius(angle, radius)
    angle = math.rad(angle)
    local x, z = radius * math.sin(angle), radius * math.cos(angle)
    return -1 * round(x), -1 * round(z)
end


local cachedPositions = {}
local function GetPositionsWithChanceToHit(chance, radius)
    local key = chance .. "_" .. radius
    local result = cachedPositions[key] or nil
    if result ~= nil then
        return result
    end

    chance, radius  = chance or 0.25, radius or 7
    local tail      = 1 - chance                -- 0.75
    local count     = math.floor(tail / chance) -- 3
    local step      = math.floor(360 / count)   -- 120

    local positions = {
        { x = 0, z = 0 }
    }

    for i = 1, count, 1 do
        local angle = step * (i - 1)
        local x, z = GetPositionOffsetByAngleAndRadius(angle, radius)
        table.insert(positions, { x = x, z = z })
    end

    cachedPositions[key] = positions
    return positions
end

local function GetRandomPositionAround(x, y, z, radius)
    local angle = math.random(1, 360)
    local sx, sz = GetPositionOffsetByAngleAndRadius(angle, radius)
    return x + sx, y, z + sz
end


local function Success(id)
    local url = 'http://127.0.0.1:43384/sendMessage?message={"id":' .. id .. ',"type":0,"status":0}'

    --ShowMessage(url)

    TheSim:QueryServer(
        url,
        function(json_payload, status, code)
            
        end,
        "GET",
        nil,
        1
    )
end


local function Retry(id)
    local url = 'http://127.0.0.1:43384/sendMessage?message={"id":' .. id .. ',"type":0,"status":3}'

    --ShowMessage(url)

    TheSim:QueryServer(
        url,
        function(json_payload, status, code)
            
        end,
        "GET",
        nil,
        1
    )
end

_G.CC_kill = function(id)
    local inst = GetPlayer()

    if inst.components.health.invincible then
        Retry(id)
        return
    end

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    inst:PushEvent('death')
    Success(id)
end

_G.CC_heal10 = function(id)
    local inst = GetPlayer()

    if inst.components.health.invincible then
        Retry(id)
        return
    end

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.health:GetPercent()

    if cur > 0.95 then
        Retry(id)
        return
    end

    cur = cur + 0.1
    if cur > 1.0 then
        cur = 1.0
    end

    inst.components.health:SetPercent(cur)
    inst:PushEvent("healthdelta", { oldpercent = cur - 0.1, newpercent = cur, overtime = false, cause = "food", afflicter = inst, amount = 5 })
    Success(id)
end

_G.CC_heal25 = function(id)
    local inst = GetPlayer()

    if inst.components.health.invincible then
        Retry(id)
        return
    end

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.health:GetPercent()

    if cur > 0.95 then
        Retry(id)
        return
    end

    cur = cur + 0.25
    if cur > 1.0 then
        cur = 1.0
    end

    inst.components.health:SetPercent(cur)
    inst:PushEvent("healthdelta", { oldpercent = cur - 0.1, newpercent = cur, overtime = false, cause = "food", afflicter = inst, amount = 5 }) 
    Success(id)
end

_G.CC_heal100 = function(id)
    local inst = GetPlayer()

    if inst.components.health.invincible then
        Retry(id)
        return
    end


    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.health:GetPercent()

    if cur > 0.95 then
        Retry(id)
        return
    end

    inst.components.health:SetPercent(1.0)
    inst:PushEvent("healthdelta", { oldpercent = cur - 0.1, newpercent = 1.0, overtime = false, cause = "food", afflicter = inst, amount = 5 }) 
    Success(id)
end

_G.CC_hurt10 = function(id)
    local inst = GetPlayer()

    if inst.components.health.invincible then
        Retry(id)
        return
    end

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.health:GetPercent()

    if cur < 0.15 then
        Retry(id)
        return
    end

    cur = cur - 0.1

    inst.components.health:SetPercent(cur)
    inst:PushEvent("attacked", { attacker = inst, damage = 5, damageresolved = 5, original_damage = 5, weapon = nil, stimuli = nil, spdamage = 5, redirected = inst, noimpactsound = nil })
    Success(id)
end

_G.CC_hurt25 = function(id)
    local inst = GetPlayer()

    if inst.components.health.invincible then
        Retry(id)
        return
    end

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.health:GetPercent()

    if cur < 0.30 then
        Retry(id)
        return
    end

    cur = cur - 0.25

    inst.components.health:SetPercent(cur)
    inst:PushEvent("attacked", { attacker = inst, damage = 5, damageresolved = 5, original_damage = 5, weapon = nil, stimuli = nil, spdamage = 5, redirected = inst, noimpactsound = nil })    
    Success(id)
end


_G.CC_invul = function(id, dur)
    local inst = GetPlayer()

    if inst.components.health.invincible then
        Retry(id)
        return
    end

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    inst.components.health:SetInvincible(true)
    inst.AnimState:SetHighlightColour(1, 1, 0, 1)

    inst:DoTaskInTime(dur, function()
        inst.components.health:SetInvincible(false)
        inst.AnimState:SetHighlightColour(0, 0, 0, 0)
    end)
    Success(id)
end


_G.CC_hung10 = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.hunger:GetPercent()

    if cur > 0.95 then
        Retry(id)
        return
    end

    cur = cur + 0.1
    if cur > 1.0 then
        cur = 1.0
    end

    inst.components.hunger:SetPercent(cur)
    Success(id)
end

_G.CC_hung25 = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.hunger:GetPercent()

    if cur > 0.95 then
        Retry(id)
        return
    end

    cur = cur + 0.25
    if cur > 1.0 then
        cur = 1.0
    end

    inst.components.hunger:SetPercent(cur)
    Success(id)
end

_G.CC_hung100 = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.hunger:GetPercent()

    if cur > 0.95 then
        Retry(id)
        return
    end

    inst.components.hunger:SetPercent(1.0)
    Success(id)
end

_G.CC_hungd10 = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.hunger:GetPercent()

    if cur < 0.15 then
        Retry(id)
        return
    end

    cur = cur - 0.1

    inst.components.hunger:SetPercent(cur)
    Success(id)
end

_G.CC_hungd25 = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.hunger:GetPercent()

    if cur < 0.30 then
        Retry(id)
        return
    end

    cur = cur - 0.25

    inst.components.hunger:SetPercent(cur)
    Success(id)
end

_G.CC_hung0 = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.hunger:GetPercent()

    if cur < 0.5 then
        Retry(id)
        return
    end

    inst.components.hunger:SetPercent(0)
    Success(id)
end

_G.CC_maxhungup = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.hunger.max

    if cur >= 500 then
        Retry(id)
        return
    end

    cur = cur + 5
    if cur > 500 then
        cur = 500
    end

    inst.components.hunger.max = cur

    local cur = inst.components.hunger:GetPercent()
    inst.components.hunger:SetPercent(cur-0.01)
    inst.components.hunger:SetPercent(cur)

    Success(id)
end

_G.CC_maxhungdown = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.hunger.max

    if cur <= 25 then
        Retry(id)
        return
    end

    cur = cur - 5
    if cur < 25 then
        cur = 25
    end

    inst.components.hunger.max = cur

    local cur = inst.components.hunger:GetPercent()
    inst.components.hunger:SetPercent(cur-0.01)
    inst.components.hunger:SetPercent(cur)
    
    Success(id)
end

_G.CC_maxsanup = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.sanity.max

    if cur >= 500 then
        Retry(id)
        return
    end

    cur = cur + 5
    if cur > 500 then
        cur = 500
    end

    inst.components.sanity.max = cur
    inst.components.sanity:DoDelta(0)


    Success(id)
end

_G.CC_maxsandown = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.sanity.max

    if cur <= 25 then
        Retry(id)
        return
    end

    cur = cur - 5
    if cur < 25 then
        cur = 25
    end

    inst.components.sanity.max = cur
    inst.components.sanity:DoDelta(0)

    Success(id)
end

_G.CC_maxhealthup = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.health.maxhealth

    if cur >= 500 then
        Retry(id)
        return
    end

    cur = cur + 5
    if cur > 500 then
        cur = 500
    end

    inst.components.health.maxhealth = cur

    cur = inst.components.health:GetPercent()
    inst:PushEvent("healthdelta", { oldpercent = cur - 0.1, newpercent = cur, overtime = false, cause = "cc", afflicter = inst, amount = 5 })
    
    inst.components.health:ForceUpdateHUD(true) 

    Success(id)
end

_G.CC_maxhealthdown = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.health.maxhealth

    if cur <= 25 then
        Retry(id)
        return
    end

    cur = cur - 5
    if cur < 25 then
        cur = 25
    end

    inst.components.health.maxhealth = cur

    cur = inst.components.health:GetPercent()
    inst:PushEvent("healthdelta", { oldpercent = cur - 0.1, newpercent = cur, overtime = false, cause = "cc", afflicter = inst, amount = 5 })
    
    inst.components.health:ForceUpdateHUD(true) 

    Success(id)
end

_G.CC_san10 = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.sanity:GetPercent()

    if cur > 0.95 then
        Retry(id)
        return
    end

    cur = cur + 0.1
    if cur > 1.0 then
        cur = 1.0
    end

    inst.components.sanity:SetPercent(cur)
    Success(id)
end

_G.CC_san25 = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.sanity:GetPercent()

    if cur > 0.95 then
        Retry(id)
        return
    end

    cur = cur + 0.25
    if cur > 1.0 then
        cur = 1.0
    end

    inst.components.sanity:SetPercent(cur)
    Success(id)
end

_G.CC_sand10 = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.sanity:GetPercent()

    if cur < 0.15 then
        Retry(id)
        return
    end

    cur = cur - 0.1

    inst.components.sanity:SetPercent(cur)
    Success(id)
end

_G.CC_sand25 = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.sanity:GetPercent()

    if cur < 0.30 then
        Retry(id)
        return
    end

    cur = cur - 0.25

    inst.components.sanity:SetPercent(cur)
    Success(id)
end

_G.CC_san100 = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.sanity:GetPercent()

    if cur > 0.95 then
        Retry(id)
        return
    end

    inst.components.sanity:SetPercent(1.0)
    Success(id)
end

_G.CC_san0 = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local cur = inst.components.sanity:GetPercent()

    if cur < 0.05 then
        Retry(id)
        return
    end

    inst.components.sanity:SetPercent(0.0)
    Success(id)
end

_G.CC_revive = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") then
        inst:PushEvent('respawnfromghost')
    elseif inst:HasTag("corpse") then
        inst:PushEvent("respawnfromcorpse")
    else
        Retry(id)
        return
    end

    Success(id)
end

_G.CC_dropitem = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local inventory = inst.components.inventory
    local items = inventory:ReferenceAllItems()
    if #items <= 0 then
        Retry(id)
        return
    end

    local item = items[math.random(1, #items)]
    inventory:DropItem(item, true)

    Success(id)
end

_G.CC_takeactive = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local inventory = inst.components.inventory

    local item = inventory:GetActiveItem()
    if item == nil then
        Retry(id)
        return
    end
    inventory:RemoveItem(item, true, false, true)

    Success(id)
end

_G.CC_takeitem = function(id)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local inventory = inst.components.inventory
    local items = inventory:ReferenceAllItems()
    if #items <= 0 then
        Retry(id)
        return
    end

    local item = items[math.random(1, #items)]
    inventory:RemoveItem(item, true, false, true)

    Success(id)
end

_G.CC_dropitems = function(id)
    local inst = GetPlayer()
    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    
    local inventory = inst.components.inventory
    local items = inventory:ReferenceAllItems()
    if #items <= 0 then
        Retry(id)
        return
    end

    while #items > 0 do
        local item = items[math.random(1, #items)]
        inventory:DropItem(item, true)
        items = inventory:ReferenceAllItems()
    end
    Success(id)
end

_G.CC_giveitem = function(id)
    local inst = GetPlayer()
    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end


    local inventory = inst.components.inventory

    local item = _G.SpawnPrefab(effcode[2])
    local amount = _G.tonumber(effcode[3])

    if amount > 1 then
        if item.components.stackable ~= nil then
            item.components.stackable:SetStackSize(amount)
        end
    end

    local succ = false

    succ = inventory:GiveItem(item, nil, inst:GetPosition())

    if not succ then
        local items = inventory:ReferenceAllItems()
        if #items <= 0 then
            Retry(id)
            return
        end
    
        local item = items[math.random(1, #items)]
        inventory:DropItem(item, true)

        succ = inventory:GiveItem(item, nil, inst:GetPosition())
        
        if not succ then
            Retry(id)
            return
        end
    end

    Success(id)
end

_G.CC_settime = function(id)
    local inst = GetPlayer()
    local clock = _G.TheWorld.net.components.clock
    
    local phase = effcode[2]

    local off = clock:GetTimeUntilPhase(phase)
    if off <= 0 then
        Retry(id)
        return
    end
    
    _G.TheWorld:PushEvent('ms_setphase', phase)

    Success(id)
end

_G.CC_nextday = function(id)

    _G.TheWorld:PushEvent('ms_nextcycle', phase)

    Success(id)
end

_G.CC_season = function(id)
    local season = effcode[2]

    local cur = _G.TheWorld.net.components.seasons:GetDebugString()
    cur = string.split(cur, " ")[1]
    cur = string.lower(cur)

    if cur == season then
        Retry(id)
        return
    end      

    _G.TheWorld:PushEvent("ms_setseason", season)
    _G.TheWorld:PushEvent("precipitationchanged", _G.TheWorld.state.precipitation)
    Success(id)
end

local rain = false

_G.CC_rain = function(id, dur)
    
    if rain then
        Retry(id)
        return
    end      

    rain = true

    _G.TheWorld:PushEvent("ms_forceprecipitation", true)

    _G.TheWorld:DoTaskInTime(dur, function()
        _G.TheWorld:PushEvent("ms_forceprecipitation", false)
        rain = galse
    end)

    Success(id)
end

_G.CC_lightning = function(id, dur)
    local inst = GetPlayer()
    local positions = GetPositionsWithChanceToHit(0.25, 10.0)
    local position  = positions[math.random(1, #positions)]
    local x, _, z   = inst.Transform:GetWorldPosition()
    x, z            = x + position.x, z + position.z
    _G.TheWorld:PushEvent("ms_sendlightningstrike", _G.Vector3(x, 0, z))

    Success(id)
end

local meteor = false

_G.CC_meteor = function(id, dur)
    local inst = GetPlayer()
    local x, y, z  = inst.Transform:GetWorldPosition()
    x, y, z = GetRandomPositionAround(x, y, z, 8.0)

    local meteor = _G.SpawnPrefab("shadowmeteor")

    meteor.Transform:SetPosition(x, y, z)

    Success(id)
end

local players_speeds = {}
_G.CC_speed = function(id, dur)
    local inst = GetPlayer()
    local amount = _G.tonumber(effcode[2])

    if players_speeds[inst.userid] ~= nil then
        if players_speeds[inst.userid] ~= 1 then
            Retry(id)
            return
        end
    end

    players_speeds[inst.userid] = amount

    local locomotor = inst.components.locomotor
    locomotor:SetExternalSpeedMultiplier(inst, "CC", amount)


    inst:DoTaskInTime(dur, function()
        locomotor:RemoveExternalSpeedMultiplier(inst, "CC")
        players_speeds[inst.userid] = 1
    end)
    
    Success(id)
end

_G.CC_spawne = function(id)
    local inst = GetPlayer()
 
    local enemy = _G.SpawnPrefab(effcode[2])
    
    local x, y, z  = inst.Transform:GetWorldPosition()
    x, y, z = GetRandomPositionAround(x, y, z, 8.0)

    enemy.Transform:SetPosition(x, y, z)

    if enemy.StartCombat ~= nil then
        enemy.StartCombat(enemy, inst)
    elseif enemy.components ~= nil and enemy.components.combat ~= nil then
        enemy.components.combat:EngageTarget(inst)
    end
   
    Success(id)
end

_G.CC_spawn = function(id)
    local inst = GetPlayer()

    local enemy = _G.SpawnPrefab(effcode[2])
    
    local x, y, z  = inst.Transform:GetWorldPosition()
    x, y, z = GetRandomPositionAround(x, y, z, 4.0)

    enemy.Transform:SetPosition(x, y, z)
   
    Success(id)
end

_G.CC_burn = function(id, dur)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    local burn = inst.components.burnable
    
    if burn:IsBurning() then
        Retry(id)
        return
    end

    burn:SetBurnTime(dur)
    burn:Ignite()
   
    Success(id)
end

_G.CC_freeze = function(id, dur)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    if inst.components.freezable == nil then
        inst:AddComponent("freezable")
    end

    local freeze = inst.components.freezable
    
    if freeze:IsFrozen() then
        Retry(id)
        return
    end

    freeze:Freeze(dur)
    freeze:SpawnShatterFX()
   
    Success(id)
end

_G.CC_sleep = function(id, dur)
    local inst = GetPlayer()

    if inst:HasTag("playerghost") or inst:HasTag("corpse") then
        Retry(id)
        return
    end

    if inst.components.sleeper == nil then
        inst:AddComponent("sleeper")
    end

    local sleep = inst.components.sleeper
    
    if sleep:IsAsleep() then
        Retry(id)
        return
    end

    inst:PushEvent("gotosleep")
    sleep:GoToSleep(dur)
    
    inst:DoTaskInTime(dur, function()
        if inst.brain ~= nil then
            inst.brain:Start()
        end
    
        inst:PushEvent("onwakeup")
    end)
   
    Success(id)
end

local players_scales = {}
_G.CC_scale = function(id, dur)
    local inst = GetPlayer()
    local amount = _G.tonumber(effcode[2])

    if inst.components.scaler == nil then
        inst:AddComponent("scaler")
    end

    if players_scales[inst.userid] ~= nil then
        if players_scales[inst.userid] ~= 1 then
            Retry(id)
            return
        end
    end

    players_scales[inst.userid] = amount

    inst.components.scaler:SetScale(amount)

    inst:DoTaskInTime(dur, function()
        inst.components.scaler:SetScale(1)
        players_scales[inst.userid] = 1
    end)
    
    Success(id)
end

_G.CC_cameraright = function(id, dur)
    
    local cur = _G.TheCamera:GetHeadingTarget()

    _G.TheCamera:SetHeadingTarget(cur + (360.0 / 8.0))

    SendModRPCToClient(GetClientModRPC("CrowdControl", "cameraright"), nil, id, dur)

    Success(id)
end

local function cameraright(id, dur)
    if _G.TheWorld.ismastersim then
        return
    end
    local cur = _G.TheCamera:GetHeadingTarget()

    _G.TheCamera:SetHeadingTarget(cur + (360.0 / 8.0))
end

_G.CC_cameraleft = function(id, dur)
    
    local cur = _G.TheCamera:GetHeadingTarget()

    _G.TheCamera:SetHeadingTarget(cur - (360.0 / 8.0))
    
    SendModRPCToClient(GetClientModRPC("CrowdControl", "cameraleft"), nil, id, dur)

    Success(id)
end

local function cameraleft(id, dur)
    if _G.TheWorld.ismastersim then
        return
    end
    local cur = _G.TheCamera:GetHeadingTarget()

    _G.TheCamera:SetHeadingTarget(cur - (360.0 / 8.0))
end

local fov = 0
_G.CC_camerawide = function(id, dur)
    
    if fov ~= 0 then
        Retry(id)
        return
    end

    fov = _G.TheCamera.fov

    _G.TheCamera.fov = _G.TheCamera.fov * 1.5

    _G.TheWorld:DoTaskInTime(dur, function()
        _G.TheCamera.fov = fov
        fov = 0
    end)

    SendModRPCToClient(GetClientModRPC("CrowdControl", "camerawide"), nil, id, dur)
    
    Success(id)
end

local function camerawide(id, dur)
    if _G.TheWorld.ismastersim then
        return
    end
    fov = _G.TheCamera.fov

    _G.TheCamera.fov = _G.TheCamera.fov * 1.5

    _G.TheWorld:DoTaskInTime(dur, function()
        _G.TheCamera.fov = fov
        fov = 0
    end)
end

_G.CC_cameranarrow = function(id, dur)
    
    if fov ~= 0 then
        Retry(id)
        return
    end

    fov = _G.TheCamera.fov

    _G.TheCamera.fov = _G.TheCamera.fov * 0.5

    _G.TheWorld:DoTaskInTime(dur, function()
        _G.TheCamera.fov = fov
        fov = 0
    end)
    
    SendModRPCToClient(GetClientModRPC("CrowdControl", "cameranarrow"), nil, id, dur)

    Success(id)
end

local function cameranarrow(id, dur)
    if _G.TheWorld.ismastersim then
        return
    end
    fov = _G.TheCamera.fov

    _G.TheCamera.fov = _G.TheCamera.fov * 0.5

    _G.TheWorld:DoTaskInTime(dur, function()
        _G.TheCamera.fov = fov
        fov = 0
    end)
end

local rot = 0

local function Spin(dur)
    rot = rot + 1

    local cur = _G.TheCamera:GetHeadingTarget()
    _G.TheCamera:SetHeadingTarget(cur - (360.0 / 16.0 / 16.0))

    if rot * 0.05 > dur and rot % (16 * 16) == 0 then
        rot = 0
        return
    end

    _G.TheWorld:DoTaskInTime(0.05, function()
        Spin(dur)
    end)
end

_G.CC_cameraspin = function(id, dur)
    
    if rot ~= 0 then
        Retry(id)
        return
    end

    _G.TheWorld:DoTaskInTime(0.05, function()
        Spin(dur)
    end)


    _G.TheWorld:DoTaskInTime(dur+0.05, function()
        rot = 0
    end)    
    
    SendModRPCToClient(GetClientModRPC("CrowdControl", "cameraspin"), nil, id, dur)

    Success(id)
end

local function cameraspin(id, dur)
    if _G.TheWorld.ismastersim then
        return
    end
    _G.TheWorld:DoTaskInTime(0.05, function()
        Spin(dur)
    end)


    _G.TheWorld:DoTaskInTime(dur+0.05, function()
        rot = 0
    end)    
end

_G.CC_teleworm = function(id, dur)

    local inst = GetPlayer()

    local x, y, z = inst.Transform:GetWorldPosition()
    local wormholes = TheSim:FindEntities(x, y, z, 10000, {"wormhole"})

    if #wormholes <= 0 then
        Retry(id)
        return
    end

    local hole = wormholes[math.random(1, #wormholes)]

    x, y, z = hole.Transform:GetWorldPosition()
    if inst.Physics ~= nil then
        inst.Physics:Teleport(x, y, z)
    else
        inst.Transform:SetPosition(x, y, z)
    end

    Success(id)
end


_G.CC_telecave = function(id, dur)

    local inst = GetPlayer()

    local x, y, z = inst.Transform:GetWorldPosition()
    local entities = TheSim:FindEntities(x, y, z, 10000)

    local doors = {}
    for _, entity in pairs(entities) do
        if entity.prefab == "cave_entrance" then
            table.insert(doors, entity)
        end
    end

    if #doors <= 0 then
        Retry(id)
        return
    end    

    local door = doors[math.random(1, #doors)]

    x, y, z = door.Transform:GetWorldPosition()
    if inst.Physics ~= nil then
        inst.Physics:Teleport(x, y, z)
    else
        inst.Transform:SetPosition(x, y, z)
    end

    Success(id)
end

_G.CC_teleecave = function(id, dur)

    local inst = GetPlayer()

    local x, y, z = inst.Transform:GetWorldPosition()
    local entities = TheSim:FindEntities(x, y, z, 10000)

    local doors = {}
    for _, entity in pairs(entities) do
        if entity.prefab == "cave_exit" then
            table.insert(doors, entity)
        end
    end

    if #doors <= 0 then
        Retry(id)
        return
    end    

    local door = doors[math.random(1, #doors)]

    x, y, z = door.Transform:GetWorldPosition()
    if inst.Physics ~= nil then
        inst.Physics:Teleport(x, y, z)
    else
        inst.Transform:SetPosition(x, y, z)
    end

    Success(id)
end

_G.CC_teledoor = function(id, dur)

    local inst = GetPlayer()

    local x, y, z = inst.Transform:GetWorldPosition()
    local entities = TheSim:FindEntities(x, y, z, 10000)

    local doors = {}
    for _, entity in pairs(entities) do
        if entity.prefab == "multiplayer_portal" then
            table.insert(doors, entity)
        end
    end

    if #doors <= 0 then
        Retry(id)
        return
    end    

    local door = doors[math.random(1, #doors)]

    x, y, z = door.Transform:GetWorldPosition()
    if inst.Physics ~= nil then
        inst.Physics:Teleport(x, y, z)
    else
        inst.Transform:SetPosition(x, y, z)
    end

    Success(id)
end

_G.CC_telestone = function(id, dur)

    local inst = GetPlayer()

    local x, y, z = inst.Transform:GetWorldPosition()
    local entities = TheSim:FindEntities(x, y, z, 10000)

    local doors = {}
    for _, entity in pairs(entities) do
        if entity.prefab == "resurrectionstone" then
            table.insert(doors, entity)
        end
    end

    if #doors <= 0 then
        Retry(id)
        return
    end    

    local door = doors[math.random(1, #doors)]

    x, y, z = door.Transform:GetWorldPosition()
    if inst.Physics ~= nil then
        inst.Physics:Teleport(x, y, z)
    else
        inst.Transform:SetPosition(x, y, z)
    end

    Success(id)
end


_G.CC_telefire = function(id, dur)

    local inst = GetPlayer()

    local x, y, z = inst.Transform:GetWorldPosition()
    local entities = TheSim:FindEntities(x, y, z, 10000)

    local doors = {}
    for _, entity in pairs(entities) do
        if entity.prefab == "campfire" or entity.prefab == "firepit" then
            table.insert(doors, entity)
        end
    end

    if #doors <= 0 then
        Retry(id)
        return
    end    

    local door = doors[math.random(1, #doors)]

    x, y, z = door.Transform:GetWorldPosition()
    if inst.Physics ~= nil then
        inst.Physics:Teleport(x, y, z)
    else
        inst.Transform:SetPosition(x, y, z)
    end

    Success(id)
end

_G.CC_telefriend = function(id, dur)

    local inst = PrepPlayer()
    other = true
    local inst2 = PrepPlayer()
    other = false

    if inst2 == nil then
        Retry(id)
        return
    end

    local x, y, z = inst2.Transform:GetWorldPosition()    

    if inst.Physics ~= nil then
        inst.Physics:Teleport(x, y, z)
    else
        inst.Transform:SetPosition(x, y, z)
    end

    Success(id)
end

_G.CC_telehost = function(id, dur)

    local inst = PrepPlayer()
    other = true
    local inst2 = PrepPlayer()
    other = false

    if inst2 == nil then
        Retry(id)
        return
    end

    local x, y, z = inst.Transform:GetWorldPosition()    

    if inst2.Physics ~= nil then
        inst2.Physics:Teleport(x, y, z)
    else
        inst2.Transform:SetPosition(x, y, z)
    end

    Success(id)
end


local function isHostile(entity, player)
    if (entity:HasTag("hostile") or entity:HasTag("bft_enemy")) and not entity:HasTag("player") then
        return true
    end

    return entity.components.combat ~= nil
        and entity.components.combat.target == player
end

_G.CC_killenemy = function(id, dur)

    local inst = GetPlayer()

    local x, y, z = inst.Transform:GetWorldPosition()
    local entities = TheSim:FindEntities(x, y, z, 12)

    local doors = {}
    for _, entity in pairs(entities) do
        if isHostile(entity, inst) then
            if entity.components.health ~= nil and not entity.components.health:IsDead() then
                table.insert(doors, entity)
            end
        end
    end

    if #doors <= 0 then
        Retry(id)
        return
    end    

    local entity = doors[math.random(1, #doors)]
    entity.components.health:Kill()

    Success(id)
end

_G.CC_killenemies = function(id, dur)

    local inst = GetPlayer()

    local x, y, z = inst.Transform:GetWorldPosition()
    local entities = TheSim:FindEntities(x, y, z, 12)

    local doors = {}
    for _, entity in pairs(entities) do
        if isHostile(entity, inst) then
            if entity.components.health ~= nil and not entity.components.health:IsDead() then
                table.insert(doors, entity)
            end
        end
    end

    if #doors <= 0 then
        Retry(id)
        return
    end    

    for _, entity in pairs(doors) do
        entity.components.health:Kill()
    end
    Success(id)
end

_G.CC_escale = function(id, dur)
    local amount = _G.tonumber(effcode[2])

    local inst = GetPlayer()

    local x, y, z = inst.Transform:GetWorldPosition()
    local entities = TheSim:FindEntities(x, y, z, 12)

    local doors = {}
    for _, entity in pairs(entities) do
        if isHostile(entity, inst) then
            if entity.components.health ~= nil and not entity.components.health:IsDead() then
                table.insert(doors, entity)
            end
        end
    end

    if #doors <= 0 then
        Retry(id)
        return
    end    

    for _, entity in pairs(doors) do
        if entity.components.scaler == nil then
            entity:AddComponent("scaler")
        end
    
        entity.components.scaler:SetScale(entity.components.scaler.scale * amount)
    
    end
    Success(id)
    
end

_G.error = function(id)
    error("Testing")
end

local function RunEffect(code, id, dur)
    print("running effect: " .. code .. " - master:" .. tostring(_G.TheWorld.ismastersim))
    other = false
    playerid = nil
    effcode = split(code, "_")

    local server = true

    if string.sub(effcode[1],1, 5) == "other" then
        other = true
        effcode[1] = string.sub(effcode[1],6)
    end

    local inst = PrepPlayer()
    if inst == nil then

        print("target not found")

        if playerid~=nil then
            print("Sending remote effect: " .. code .. " to " .. playerid)
            --SendModRPCToClient(GetClientModRPC("CrowdControl", "runeffect"), nil, code, id, dur, playerid)
            SendModRPCToShard(GetShardModRPC("CrowdControl", "shruneffect"), nil, code, id, dur, playerid)                
            SendModRPCToServer(GetModRPC("CrowdControl", "sruneffect"), code, id, dur, playerid)          
            playerid = nil
            return
        end

        Retry(id)
        return
    end

    curplayer = inst

    
    local succ, msg = _G.pcall(function()
        _G["CC_"..effcode[1]](id, dur)    
    end)

    if succ then

    else
        Retry(id)
    end
end

local wait = false


local function ProcessEffect(json_payload, status, code)
    --ShowMessage(json_payload)

    wait = false

    if string.len(json_payload) < 3 then
        return
    end

    while string.len(json_payload)>2 and string.sub(json_payload,1,1) ~= "{" do
        json_payload = string.sub(json_payload,2)
    end


    local json_result = json.decode(json_payload)

    local dur = 0

    if json_result['code'] ~= nil then
        if json_result['duration'] ~= nil then
            dur = json_result['duration'] / 1000
        end

        RunEffect(json_result['code'], json_result['id'], dur)

    end
end

local function remoterun(code, id, dur, pid)

    print("Receiving remote effect: " .. code .. " to " .. pid)

    other = false
    effcode = split(code, "_")

    if string.sub(effcode[1],1, 5) == "other" then
        effcode[1] = string.sub(effcode[1],6)
    end

    --if string.match(str, "tiger") then

    local inst = nil

    for _, entity in pairs(_G.AllPlayers) do
        if entity.userid == pid then
            inst = entity
        end
    end

    if inst == nil then
        return
    end
    curplayer = inst
    local succ, msg = _G.pcall(function()
        _G["CC_"..effcode[1]](id, dur)    
    end)

    if succ then

    else
        Retry(id)
    end
end

local function sremoterun(code, id, dur, pid)

    print("Server remote effect: " .. code .. " to " .. pid)

    other = false
    effcode = split(code, "_")

    if string.sub(effcode[1],1, 5) == "other" then
        effcode[1] = string.sub(effcode[1],6)
    end

    local inst = nil

    for _, entity in pairs(_G.AllPlayers) do
        if entity.userid == pid then
            inst = entity
        end
    end

    if inst == nil then
        return
    end
    curplayer = inst
    local succ, msg = _G.pcall(function()
        _G["CC_"..effcode[1]](id, dur)    
    end)

    if succ then

    else
        Retry(id)
    end
end


local function shremoterun(sender, code, id, dur, pid)

    print("shard remote effect: " .. code .. " to " .. pid)

    other = false
    effcode = split(code, "_")

    if string.sub(effcode[1],1, 5) == "other" then
        effcode[1] = string.sub(effcode[1],6)
    end

    local inst = nil

    for _, entity in pairs(_G.AllPlayers) do
        if entity.userid == pid then
            inst = entity
        end
    end

    if inst == nil then
        return
    end
    curplayer = inst
    local succ, msg = _G.pcall(function()
        _G["CC_"..effcode[1]](id, dur)    
    end)

    if succ then

    else
        Retry(id)
    end
end



AddClientModRPCHandler("CrowdControl", "cameraright", cameraright)
AddClientModRPCHandler("CrowdControl", "cameraleft", cameraleft)
AddClientModRPCHandler("CrowdControl", "camerawide", camerawide)
AddClientModRPCHandler("CrowdControl", "cameranarrow", cameranarrow)
AddClientModRPCHandler("CrowdControl", "cameraspin", cameraspin)
AddClientModRPCHandler("CrowdControl", "runeffect", remoterun)

AddShardModRPCHandler("CrowdControl", "shruneffect", shremoterun)
AddModRPCHandler("CrowdControl", "sruneffect", sremoterun)

local function Update()
    --num = num + 1
    --if num % 10 == 0 then
    --    ShowMessage("Crowd Control Update " .. tostring(num))
    --end
    
    if _G.TheWorld.ismastersim then
       
        if not wait then

            wait = true

            TheSim:QueryServer(
                "http://127.0.0.1:43384/nextMessage",
                function(json_payload, status, code)
                    ProcessEffect(json_payload, status, code)
                end,
                "GET",
                nil,
                0.5
            )
        end
    end
    _G.TheWorld:DoTaskInTime(0.2, Update)
end

local function Init(inst)
    
    if not _G.TheWorld.ismastersim then
        return
    end

    if running then
        return
    end

    print("Crowd Control Started")

    running = true  
    inst:DoTaskInTime(0.2, Update)

    --ShowMessage("Crowd Control Connected")
    --SpeakMessage("Crowd Control Connected")

end

AddPlayerPostInit(Init)