/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol;

import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.event.events.player.PlayerConnectEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerDisconnectEvent;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.util.Config;
import dev.qixils.crowdcontrol.Effect;
import dev.qixils.crowdcontrol.EffectRegister;
import dev.qixils.crowdcontrol.PluginConfig;
import dev.qixils.crowdcontrol.util.Application;
import dev.qixils.crowdcontrol.util.ConsoleReceiver;
import dev.qixils.crowdcontrol.util.SemVer;
import dev.qixils.crowdcontrol.util.TrackedEffect;
import dev.qixils.crowdcontrol.util.TriState;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import live.crowdcontrol.cc4j.CCEventType;
import live.crowdcontrol.cc4j.CCMessage;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CrowdControl;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.UserToken;
import live.crowdcontrol.cc4j.websocket.data.CCEffectReport;
import live.crowdcontrol.cc4j.websocket.data.IdentifierType;
import live.crowdcontrol.cc4j.websocket.data.ReportStatus;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.http.CustomEffect;
import live.crowdcontrol.cc4j.websocket.http.CustomEffectBuilder;
import live.crowdcontrol.cc4j.websocket.http.CustomEffectsOperation;
import live.crowdcontrol.cc4j.websocket.http.GamePack;
import live.crowdcontrol.cc4j.websocket.payload.CCUserRecord;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrowdControlPlugin
extends JavaPlugin {
    public static final Color JOIN_MESSAGE_COLOR = new Color(16574932);
    public static final Color USER_COLOR = new Color(10437851);
    public static final Color CMD_COLOR = new Color(11623395);
    public static final Color DIM_CMD_COLOR = new Color(11109058);
    public static final Color _ERROR_COLOR = new Color(16220288);
    public static final Pattern CUSTOM_EFFECTS_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+$");
    public static final Message VIEWER_NAME = Message.raw((String)"A viewer").color(USER_COLOR);
    @Deprecated
    public static final Random RNG = new Random();
    @Nullable
    private static CrowdControlPlugin instance;
    @Nullable
    private CrowdControl crowdControl;
    @Nullable
    private final Config<PluginConfig> configManager;
    @NotNull
    private PluginConfig config = new PluginConfig();
    @NotNull
    private final EffectRegister effectRegister = new EffectRegister(this);
    private final Map<UUID, TrackedEffect> trackedEffects = new HashMap<UUID, TrackedEffect>();

    public CrowdControlPlugin(@NotNull JavaPluginInit init) {
        super(init);
        instance = this;
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[CrowdControlPlugin] Plugin loaded!");
        this.configManager = this.withConfig("CrowdControl", PluginConfig.CODEC);
        this.configManager.load().thenApply(config -> {
            this.config = config;
            return this.configManager.save();
        });
    }

    protected void setup() {
        this.crowdControl = new CrowdControl("Hytale", "Hytale", Application.APPLICATION_ID, Application.APPLICATION_SECRET, this.getDataDirectory().resolve("Auth"));
        this.getEventRegistry().register(PlayerConnectEvent.class, event -> this.onPlayerJoin(event.getPlayerRef()));
        this.getEventRegistry().register(PlayerDisconnectEvent.class, event -> this.onPlayerLeave(event.getPlayerRef()));
        Universe.get().getPlayers().forEach(this::onPlayerJoin);
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[CrowdControlPlugin] Plugin enabled!");
    }

    protected void shutdown() {
        Universe.get().getPlayers().forEach(this::onPlayerLeave);
        if (this.crowdControl != null) {
            this.crowdControl.close();
            this.crowdControl = null;
        }
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[CrowdControlPlugin] Plugin disabled!");
    }

    protected void start() {
        super.start();
        this.effectRegister.getEffects();
    }

    public void startSession(@NotNull CCPlayer ccPlayer) {
        UserToken user = ccPlayer.getUserToken();
        if (user == null) {
            return;
        }
        String token = ccPlayer.getToken();
        if (token == null) {
            return;
        }
        if (this.crowdControl == null) {
            return;
        }
        CompletableFuture<@Nullable GamePack> future = this.crowdControl.getGamePack() != null ? CompletableFuture.completedFuture(this.crowdControl.getGamePack()) : this.crowdControl.loadGamePack(token);
        future.thenAccept(gamePack -> {
            Map<String, CustomEffect> newEffects;
            if (gamePack != null) {
                Map effects = Objects.requireNonNullElseGet(gamePack.getEffects().getGame(), Collections::emptyMap);
                List<Effect> registeredEffects = this.effectRegister.getEffects();
                Set knownEffects = effects.keySet().stream().map(str -> str.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
                newEffects = registeredEffects.stream().filter(command -> command.getPriority() > -128).filter(command -> CUSTOM_EFFECTS_ID_PATTERN.matcher(command.getEffectID().toLowerCase(Locale.ENGLISH)).matches()).filter(command -> !knownEffects.contains(command.getEffectID().toLowerCase(Locale.ENGLISH))).sorted((a, b) -> {
                    if (a.getPriority() != b.getPriority()) {
                        return b.getPriority() - a.getPriority();
                    }
                    return a.getExtensionName().computeSortValue().compareToIgnoreCase(b.getExtensionName().computeSortValue());
                }).limit(75L).map(command -> {
                    ArrayList<String> category = new ArrayList<String>();
                    category.add("Custom Effects");
                    if (command.getCategories() != null) {
                        category.addAll(command.getCategories());
                    }
                    return Map.entry(command.getEffectID().toLowerCase(Locale.ENGLISH), CustomEffectBuilder.builder().name(command.getExtensionName()).price(command.getPrice()).description(command.getDescription()).category(category).image(command.getImage()).inactive(command.isInactive()).duration(command.getExtensionDuration()).build());
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> existing));
            } else {
                newEffects = Collections.emptyMap();
            }
            ((HytaleLogger.Api)this.getLogger().atInfo()).log("Registering custom effects %s (%s, %s)", newEffects.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + ((CustomEffect)entry.getValue()).name().getDisplayName()).toList(), (Object)(gamePack != null ? 1 : 0), this.effectRegister.getEffects());
            ccPlayer.setCustomEffects(Collections.singletonList(new CustomEffectsOperation("replace-all", newEffects)));
            ccPlayer.startSession(this.getConditionalEffectVisibility(user));
        });
    }

    public void onPlayerJoin(PlayerRef playerRef) {
        CrowdControl cc = this.crowdControl;
        if (cc == null) {
            return;
        }
        playerRef.sendMessage(Message.raw((String)"This server is running Crowd Control, developed by qixils.dev"));
        Holder holder = playerRef.getHolder();
        if (holder == null) {
            return;
        }
        Player player = (Player)holder.getComponent(Player.getComponentType());
        if (player == null) {
            return;
        }
        if (!player.hasPermission("crowdcontrol.use", true)) {
            return;
        }
        UUID uuid = playerRef.getUuid();
        CCPlayer ccPlayer = cc.addPlayer(uuid);
        ccPlayer.getEventManager().registerEventConsumer(CCEventType.MESSAGE, message -> {
            Message out = Message.raw((String)("[CrowdControl] " + message.message()));
            if (message.level() == CCMessage.Level.ERROR) {
                out.color(new Color(0xFF5555));
            } else if (message.level() == CCMessage.Level.WARN) {
                out.color(new Color(0xFFAA00));
            }
            playerRef.sendMessage(out);
        });
        ccPlayer.getEventManager().registerEventConsumer(CCEventType.GENERATED_AUTH_CODE, payload -> {
            ((HytaleLogger.Api)this.getLogger().atInfo()).log("generated auth code here");
            String url = ccPlayer.getAuthUrl();
            if (url == null) {
                return;
            }
            ((HytaleLogger.Api)this.getLogger().atInfo()).log("found their auth url");
            playerRef.sendMessage(Message.raw((String)"Let's link your Crowd Control account, it's easy!"));
            playerRef.sendMessage(Message.raw((String)"Step 1: Press Enter to open the chat"));
            playerRef.sendMessage(Message.raw((String)"Step 2: Hide the game on your streaming software"));
            playerRef.sendMessage(Message.raw((String)"Step 3: Click on this message to open your private login URL").link(url));
            playerRef.sendMessage(Message.raw((String)"Follow the rest of the steps in your browser then re-enable the game in your streaming software!"));
        });
        ccPlayer.getEventManager().registerEventRunnable(CCEventType.AUTHENTICATED, () -> {
            if (ccPlayer.getGameSessionId() != null) {
                return;
            }
            UserToken user = ccPlayer.getUserToken();
            if (user == null) {
                return;
            }
            playerRef.sendMessage(Message.join((Message[])new Message[]{Message.raw((String)"You have authenticated as "), Message.raw((String)user.getName()).bold(true)}));
            HytaleServer.SCHEDULED_EXECUTOR.schedule(() -> this.startSession(ccPlayer), 3L, TimeUnit.SECONDS);
        });
        ccPlayer.getEventManager().registerEventRunnable(CCEventType.SESSION_STARTED, () -> {
            this.updateConditionalEffectVisibility(ccPlayer);
            UserToken user = ccPlayer.getUserToken();
            if (user == null) {
                return;
            }
            playerRef.sendMessage(Message.raw((String)"Your Crowd Control session has started! Click here to copy your Interact Link.").link(String.format("https://interact.crowdcontrol.live/#/%s/%s", user.getProfile().getValue(), user.getOriginId())));
        });
        ccPlayer.getEventManager().registerEventConsumer(CCEventType.EFFECT_RESPONSE, response -> {
            Effect effect;
            UUID requestId = response.getRequestId();
            ((HytaleLogger.Api)this.getLogger().atFine()).log("Effect response %s", (Object)requestId);
            ResponseStatus status = response.getStatus();
            TrackedEffect trackedEffect = this.trackedEffects.get(requestId);
            if (trackedEffect == null) {
                return;
            }
            try {
                effect = this.effectRegister.byName(trackedEffect.request().getEffect().getEffectId());
                if (effect == null) {
                    throw new IllegalArgumentException("Unknown effect");
                }
            }
            catch (IllegalArgumentException e) {
                this.trackedEffects.remove(requestId);
                return;
            }
            switch (status) {
                case SUCCESS: {
                    try {
                        ConsoleReceiver.INSTANCE.sendMessage(Message.join((Message[])new Message[]{this.getViewerName(trackedEffect.request(), false), Message.raw((String)" used "), effect.getProcessedDisplayName(trackedEffect.request()).color(CMD_COLOR)}));
                        trackedEffect.receiver().sendMessage(Message.join((Message[])new Message[]{this.getViewerName(trackedEffect.request(), true), Message.raw((String)" used "), effect.getProcessedDisplayName(trackedEffect.request()).color(CMD_COLOR)}));
                    }
                    catch (Exception e) {
                        ((HytaleLogger.Api)((HytaleLogger.Api)this.getLogger().atWarning()).withCause((Throwable)e)).log("Failed to announce effect");
                    }
                }
                case FAIL_TEMPORARY: 
                case FAIL_PERMANENT: 
                case TIMED_END: 
                case UNKNOWN: {
                    this.trackedEffects.remove(requestId);
                }
            }
        });
    }

    public void onPlayerLeave(@NotNull PlayerRef playerRef) {
        if (this.crowdControl == null) {
            return;
        }
        this.crowdControl.removePlayer(playerRef.getUuid());
    }

    @NotNull
    public Message getViewerName(PublicEffectPayload request, boolean chat) {
        if (request.isAnonymous()) {
            return VIEWER_NAME;
        }
        CCUserRecord viewer = request.getRequester();
        if (viewer == null) {
            return VIEWER_NAME;
        }
        String name = viewer.getName();
        if (name.isEmpty()) {
            return VIEWER_NAME;
        }
        return Message.raw((String)name).color(USER_COLOR);
    }

    public Stream<PlayerRef> getPotentialPlayers(IUserRecord user) {
        Stream<Object> playerStream = !this.config.isGlobal() ? Optional.ofNullable(this.crowdControl).stream().flatMap(cc -> cc.getPlayerIds(user.getId()).stream()).flatMap(uuid -> Optional.ofNullable(Universe.get().getPlayer(uuid)).stream()) : Universe.get().getPlayers().stream();
        return playerStream;
    }

    public Stream<PlayerRef> getValidPlayers(IUserRecord user) {
        return this.getPotentialPlayers(user).filter(PlayerRef::isValid);
    }

    @CheckReturnValue
    @NotNull
    public @NotNull CCEffectReport @NotNull [] getConditionalEffectVisibility(IUserRecord user) {
        if (user == null) {
            return new CCEffectReport[0];
        }
        if (this.crowdControl == null) {
            return new CCEffectReport[0];
        }
        List<PlayerRef> potentialPlayers = this.getPotentialPlayers(user).collect(Collectors.toList());
        if (potentialPlayers.isEmpty()) {
            return new CCEffectReport[0];
        }
        boolean globalVisible = potentialPlayers.stream().anyMatch(this::globalEffectsUsableFor);
        HashMap<ReportStatus, List> effects = new HashMap<ReportStatus, List>();
        List<Effect> registeredEffects = this.effectRegister.getEffects();
        List<String> registeredEffectIds = registeredEffects.stream().map(Effect::getEffectID).map(name -> name.toLowerCase(Locale.ENGLISH)).toList();
        List unknownEffects = Optional.ofNullable(this.crowdControl.getGamePack()).map(pack -> pack.getEffects().getGame()).stream().flatMap(map -> map.keySet().stream()).filter(id -> !registeredEffectIds.contains(id)).collect(Collectors.toList());
        if (!unknownEffects.isEmpty()) {
            effects.put(ReportStatus.MENU_HIDDEN, unknownEffects);
        }
        for (Effect effect : registeredEffects) {
            TriState selectable;
            TriState visibility;
            String id2 = effect.getEffectID().toLowerCase(Locale.ENGLISH);
            try {
                visibility = effect.isVisible(user, potentialPlayers);
                if (visibility != TriState.FALSE && effect.isGlobal()) {
                    visibility = TriState.fromBoolean(globalVisible);
                }
            }
            catch (Exception e) {
                ((HytaleLogger.Api)((HytaleLogger.Api)this.getLogger().atWarning()).withCause((Throwable)e)).log("Hiding faulty effect %s", (Object)id2);
                visibility = TriState.FALSE;
            }
            if (visibility != TriState.UNKNOWN) {
                effects.computeIfAbsent(visibility == TriState.TRUE ? ReportStatus.MENU_VISIBLE : ReportStatus.MENU_HIDDEN, k -> new ArrayList()).add(id2);
            }
            try {
                selectable = effect.isSelectable(user, potentialPlayers);
            }
            catch (Exception e) {
                ((HytaleLogger.Api)((HytaleLogger.Api)this.getLogger().atWarning()).withCause((Throwable)e)).log("Disabling faulty effect %s", (Object)id2);
                selectable = TriState.FALSE;
            }
            if (selectable == TriState.UNKNOWN || visibility == TriState.FALSE) continue;
            effects.computeIfAbsent(selectable == TriState.TRUE ? ReportStatus.MENU_AVAILABLE : ReportStatus.MENU_UNAVAILABLE, k -> new ArrayList()).add(id2);
        }
        CCEffectReport[] reports = new CCEffectReport[effects.size()];
        int i = 0;
        for (Map.Entry entry : effects.entrySet()) {
            if (entry.getKey() == ReportStatus.MENU_HIDDEN || entry.getKey() == ReportStatus.MENU_UNAVAILABLE) {
                ((HytaleLogger.Api)this.getLogger().atInfo()).log("%s effects: %s", (Object)((ReportStatus)((Object)entry.getKey())).getValue(), entry.getValue());
            }
            reports[i++] = new CCEffectReport(IdentifierType.EFFECT, (ReportStatus)((Object)entry.getKey()), (List)entry.getValue());
        }
        return reports;
    }

    public void updateConditionalEffectVisibility(CCPlayer ccPlayer) {
        ((HytaleLogger.Api)this.getLogger().atFine()).log("Updating effect visibility for player %s...", (Object)ccPlayer);
        if (ccPlayer == null) {
            return;
        }
        ((HytaleLogger.Api)this.getLogger().atFine()).log("...with session %s & token %s...", (Object)ccPlayer.getGameSessionId(), (Object)ccPlayer.getUserToken());
        if (ccPlayer.getGameSessionId() == null) {
            return;
        }
        if (ccPlayer.getUserToken() == null) {
            return;
        }
        CCEffectReport[] reports = this.getConditionalEffectVisibility(ccPlayer.getUserToken());
        ((HytaleLogger.Api)this.getLogger().atFine()).log("...with %d reports", reports.length);
        if (reports.length == 0) {
            return;
        }
        ccPlayer.sendReport(reports);
    }

    @NotNull
    @CheckReturnValue
    public Optional<CCPlayer> optionalCCPlayer(@NotNull UUID player) {
        return Optional.ofNullable(this.crowdControl).map(cc -> cc.getPlayer(player));
    }

    @NotNull
    @CheckReturnValue
    public Optional<CCPlayer> optionalCCPlayer(@NotNull PlayerRef player) {
        return this.optionalCCPlayer(player.getUuid());
    }

    public void updateConditionalEffectVisibility(PlayerRef player) {
        this.updateConditionalEffectVisibility((CCPlayer)this.optionalCCPlayer(player).orElse(null));
    }

    public void updateConditionalEffectVisibility(UUID player) {
        this.updateConditionalEffectVisibility((CCPlayer)this.optionalCCPlayer(player).orElse(null));
    }

    public void updateConditionalEffectVisibility() {
        if (this.crowdControl == null) {
            return;
        }
        this.crowdControl.getPlayers().forEach(this::updateConditionalEffectVisibility);
    }

    public boolean globalEffectsUsableFor(@NotNull PlayerRef playerRef) {
        if (this.config.isGlobal()) {
            return true;
        }
        if (SemVer.MOD.isSnapshot()) {
            return true;
        }
        return this.isHost(playerRef);
    }

    public boolean isHost(@NotNull PlayerRef playerRef) {
        return false;
    }

    public void trackEffect(@NotNull UUID requestId, @NotNull TrackedEffect effect) {
        this.trackedEffects.put(requestId, effect);
    }

    @Nullable
    public CrowdControl getCrowdControl() {
        return this.crowdControl;
    }

    @NotNull
    public PluginConfig getConfig() {
        return this.config;
    }

    @Nullable
    public static CrowdControlPlugin getInstance() {
        return instance;
    }
}

