/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol;

import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import dev.qixils.crowdcontrol.CrowdControlPlugin;
import dev.qixils.crowdcontrol.util.CCResponseException;
import dev.qixils.crowdcontrol.util.ForwardingMessageReceiver;
import dev.qixils.crowdcontrol.util.QuantityStyle;
import dev.qixils.crowdcontrol.util.SemVer;
import dev.qixils.crowdcontrol.util.TextUtil;
import dev.qixils.crowdcontrol.util.ThreadUtil;
import dev.qixils.crowdcontrol.util.TrackedEffect;
import dev.qixils.crowdcontrol.util.TriState;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import live.crowdcontrol.cc4j.CCEffect;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.http.CustomEffectDuration;
import live.crowdcontrol.cc4j.websocket.payload.CCName;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.NotNull;

public abstract class Effect
implements CCEffect {
    protected final HytaleLogger logger = HytaleLogger.forEnclosingClass();
    protected final CrowdControlPlugin plugin;

    protected Effect(CrowdControlPlugin plugin) {
        this.plugin = plugin;
    }

    public abstract String getEffectID();

    public abstract Message getDisplayName();

    public boolean isGlobal() {
        return false;
    }

    public TriState isVisible(@NotNull IUserRecord user, @NotNull List<PlayerRef> potentialPlayers) {
        return TriState.UNKNOWN;
    }

    public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<PlayerRef> potentialPlayers) {
        return TriState.UNKNOWN;
    }

    protected QuantityStyle getQuantityStyle() {
        return QuantityStyle.APPEND;
    }

    public CCName getExtensionName() {
        return new CCName(TextUtil.asPlain(this.getDisplayName()));
    }

    public int getPrice() {
        return 100;
    }

    public String getDescription() {
        return null;
    }

    public List<String> getCategories() {
        return null;
    }

    public String getImage() {
        return null;
    }

    public CustomEffectDuration getExtensionDuration() {
        return null;
    }

    public byte getPriority() {
        return SemVer.MOD.isSnapshot() ? (byte)0 : -128;
    }

    public boolean isInactive() {
        return !SemVer.MOD.isSnapshot();
    }

    protected abstract CCEffectResponse buildFailure(@NotNull PublicEffectPayload var1, @NotNull CCPlayer var2);

    protected abstract CompletableFuture<Boolean> executeAsync(@NotNull @NotNull Supplier<@NotNull List<@NotNull PlayerRef>> var1, @NotNull PublicEffectPayload var2, @NotNull CCPlayer var3);

    public Message getProcessedDisplayName(@NotNull PublicEffectPayload request) {
        Message displayName = this.getDisplayName();
        try {
            displayName = this.getQuantityName(displayName, request);
            if (request.getEffect().getDurationMillis() > 0L) {
                displayName = this.getDurationName(displayName, request);
            }
        }
        catch (Exception e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Failed to get display name");
        }
        return displayName;
    }

    protected Message getQuantityName(Message displayName, PublicEffectPayload request) {
        QuantityStyle style = this.getQuantityStyle();
        if (style == QuantityStyle.NONE) {
            return displayName;
        }
        if (request.getQuantity() < 1) {
            return displayName;
        }
        if (style == QuantityStyle.APPEND) {
            return Message.join((Message[])new Message[]{displayName, Message.raw((String)(" x" + request.getQuantity())).color(CrowdControlPlugin.DIM_CMD_COLOR)});
        }
        if (style == QuantityStyle.PREPEND) {
            return Message.join((Message[])new Message[]{Message.raw((String)("x" + request.getQuantity() + " ")).color(CrowdControlPlugin.DIM_CMD_COLOR), displayName});
        }
        return displayName;
    }

    protected Message getDurationName(Message message, PublicEffectPayload request) {
        Duration duration = Duration.ofMillis(request.getEffect().getDurationMillis());
        return Message.join((Message[])new Message[]{message, Message.raw((String)(" (" + duration.getSeconds() + "s)")).color(CrowdControlPlugin.DIM_CMD_COLOR)});
    }

    protected Function<Boolean, List<PlayerRef>> getPlayerSupplier(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return force -> {
            List players = this.plugin.getValidPlayers(request.getTarget()).collect(Collectors.toList());
            if (players.isEmpty() && !force.booleanValue()) {
                throw new CCResponseException(new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No available players online"));
            }
            if (this.isGlobal()) {
                if (players.stream().noneMatch(this.plugin::globalEffectsUsableFor) && !force.booleanValue()) {
                    throw new CCResponseException(new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_PERMANENT, "Global effects cannot be used on the target streamer"));
                }
            }
            Collections.shuffle(players);
            return players;
        };
    }

    @Override
    public void onTrigger(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        Function<Boolean, List<PlayerRef>> playerSupplier = this.getPlayerSupplier(request, ccPlayer);
        this.plugin.trackEffect(request.getRequestId(), new TrackedEffect(ForwardingMessageReceiver.ofSuppliedCollection(() -> ((List)playerSupplier.apply(true)).stream().flatMap(playerRef -> {
            Holder holder = playerRef.getHolder();
            if (holder == null) {
                return Stream.empty();
            }
            return Stream.ofNullable((Player)holder.getComponent(Player.getComponentType()));
        }).toList()), request, ccPlayer));
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, remaining -> {
            boolean success = this.executeAsync(() -> (List)playerSupplier.apply(false), request, ccPlayer).orTimeout((long)remaining, TimeUnit.MILLISECONDS).join();
            return success ? (request.getEffect().getDurationMillis() > 0L ? new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis()) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS)) : this.buildFailure(request, ccPlayer);
        }));
    }
}

