/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol;

import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.server.npc.NPCPlugin;
import com.hypixel.hytale.server.npc.asset.builder.BuilderInfo;
import com.hypixel.hytale.server.npc.role.Role;
import dev.qixils.crowdcontrol.CrowdControlPlugin;
import dev.qixils.crowdcontrol.Effect;
import dev.qixils.crowdcontrol.effects.DeleteItemEffect;
import dev.qixils.crowdcontrol.effects.DigEffect;
import dev.qixils.crowdcontrol.effects.EntitySizeEffect;
import dev.qixils.crowdcontrol.effects.GameModeEffect;
import dev.qixils.crowdcontrol.effects.HealEffect;
import dev.qixils.crowdcontrol.effects.KillEffect;
import dev.qixils.crowdcontrol.effects.LaunchEffect;
import dev.qixils.crowdcontrol.effects.RespawnEffect;
import dev.qixils.crowdcontrol.effects.SpawnEntityEffect;
import dev.qixils.crowdcontrol.effects.TimeEffect;
import dev.qixils.crowdcontrol.util.CollectionUtil;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCEffect;
import live.crowdcontrol.cc4j.CrowdControl;
import org.jetbrains.annotations.Nullable;

public class EffectRegister {
    private final CrowdControlPlugin plugin;
    private List<Effect> effects;
    private Map<String, Effect> byName;
    private final HytaleLogger logger = HytaleLogger.forEnclosingClass();

    public EffectRegister(CrowdControlPlugin plugin) {
        this.plugin = plugin;
    }

    public List<Effect> getEffects() {
        if (this.effects != null) {
            return this.effects;
        }
        CrowdControl cc = this.plugin.getCrowdControl();
        if (cc == null) {
            return Collections.emptyList();
        }
        ArrayList<Effect> effects = new ArrayList<Effect>();
        CollectionUtil.initTo(effects, () -> new KillEffect(this.plugin));
        CollectionUtil.initTo(effects, () -> new LaunchEffect(this.plugin));
        CollectionUtil.initTo(effects, () -> new DigEffect(this.plugin));
        CollectionUtil.initTo(effects, () -> new EntitySizeEffect(this.plugin, 0.5f));
        CollectionUtil.initTo(effects, () -> new EntitySizeEffect(this.plugin, 2.0f));
        CollectionUtil.initTo(effects, () -> new HealEffect(this.plugin));
        CollectionUtil.initTo(effects, () -> new DeleteItemEffect(this.plugin));
        CollectionUtil.initTo(effects, () -> new RespawnEffect(this.plugin));
        CollectionUtil.initTo(effects, () -> new TimeEffect(this.plugin, 8));
        CollectionUtil.initTo(effects, () -> new TimeEffect(this.plugin, 20));
        ObjectCollection builders = NPCPlugin.get().getBuilderManager().getAllBuilders().values();
        HashMap<String, List> buildersByType = new HashMap<String, List>();
        for (BuilderInfo builderInfo : builders) {
            int idx;
            String type;
            String name;
            if (builderInfo.getBuilder().category() != Role.class || !builderInfo.getBuilder().isSpawnable() || (name = builderInfo.getKeyName()).contains("Undead") || (type = (idx = name.indexOf(95)) == -1 ? name : name.substring(0, idx)).isEmpty() || "Test".equals(type)) continue;
            buildersByType.computeIfAbsent(type, $ -> new ArrayList()).add(builderInfo);
        }
        for (Map.Entry entry : buildersByType.entrySet()) {
            CollectionUtil.initTo(effects, () -> new SpawnEntityEffect(this.plugin, (String)entry.getKey(), (List)entry.getValue()));
        }
        for (GameMode gameMode : GameMode.VALUES) {
            if (GameMode.Adventure.equals((Object)gameMode)) continue;
            CollectionUtil.initTo(effects, () -> new GameModeEffect(this.plugin, gameMode));
        }
        this.effects = effects;
        this.byName = effects.stream().collect(Collectors.toMap(Effect::getEffectID, Function.identity(), (a, b) -> a));
        effects.forEach(effect -> cc.addEffect(effect.getEffectID(), (CCEffect)effect));
        return effects;
    }

    @Nullable
    public Effect byName(String effectID) {
        return this.byName.get(effectID);
    }
}

