/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.damage.DeathComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.qixils.crowdcontrol.CrowdControlPlugin;
import dev.qixils.crowdcontrol.Effect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.NotNull;

public abstract class PlayerEffect
extends Effect {
    protected PlayerEffect(CrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    protected abstract CCEffectResponse buildFailure(@NotNull PublicEffectPayload var1, @NotNull CCPlayer var2);

    protected abstract boolean executeFor(@NotNull PlayerRef var1, @NotNull World var2, @NotNull PublicEffectPayload var3, @NotNull CCPlayer var4);

    protected CompletableFuture<Boolean> runPerPlayer(@NotNull @NotNull Supplier<@NotNull List<@NotNull PlayerRef>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer, @NotNull PlayerFunction playerFunction) {
        HashMap<UUID, List> playersByWorld = new HashMap<UUID, List>();
        for (PlayerRef playerRef : playerSupplier.get()) {
            UUID worldUuid = playerRef.getWorldUuid();
            if (worldUuid == null) continue;
            playersByWorld.computeIfAbsent(worldUuid, $ -> new ArrayList()).add(playerRef);
        }
        List perWorldFutures = playersByWorld.entrySet().stream().flatMap(entry -> {
            World world = Universe.get().getWorld((UUID)entry.getKey());
            if (world == null) {
                return Stream.empty();
            }
            Store store = world.getEntityStore().getStore();
            return Stream.of(CompletableFuture.supplyAsync(() -> {
                boolean success = false;
                for (PlayerRef playerRef : (List)entry.getValue()) {
                    try {
                        Player player;
                        Ref ref = playerRef.getReference();
                        if (ref == null || store.getArchetype(ref).contains(DeathComponent.getComponentType()) || (player = (Player)store.getComponent(ref, Player.getComponentType())) == null || !player.hasPermission("crowdcontrol.use", true)) continue;
                        success |= playerFunction.executeForPlayer(playerRef, world, request, ccPlayer);
                    }
                    catch (Exception e) {
                        ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Unhandled exception executing effect");
                    }
                }
                return success;
            }, (Executor)world));
        }).toList();
        return CompletableFuture.allOf((CompletableFuture[])perWorldFutures.toArray(CompletableFuture[]::new)).completeOnTimeout(null, 55L, TimeUnit.SECONDS).thenApply(void_ -> perWorldFutures.stream().anyMatch(future -> future.state() == Future.State.SUCCESS && (Boolean)future.resultNow() != false));
    }

    @Override
    protected CompletableFuture<Boolean> executeAsync(@NotNull @NotNull Supplier<@NotNull List<@NotNull PlayerRef>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return this.runPerPlayer(playerSupplier, request, ccPlayer, this::executeFor);
    }

    @FunctionalInterface
    public static interface PlayerFunction {
        public boolean executeForPlayer(@NotNull PlayerRef var1, @NotNull World var2, @NotNull PublicEffectPayload var3, @NotNull CCPlayer var4);
    }
}

