/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.effects;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.qixils.crowdcontrol.CrowdControlPlugin;
import dev.qixils.crowdcontrol.PlayerEffect;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.NotNull;

public class DeleteItemEffect
extends PlayerEffect {
    private final String effectID = "delete_held_item";
    private final Message displayName = Message.raw((String)"Delete Held Item");

    public DeleteItemEffect(CrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public String getEffectID() {
        return "delete_held_item";
    }

    @Override
    public Message getDisplayName() {
        return this.displayName;
    }

    @Override
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Unable to delete item");
    }

    @Override
    protected boolean executeFor(@NotNull PlayerRef playerRef, @NotNull World world, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        byte activeIdx;
        Ref ref = playerRef.getReference();
        if (ref == null) {
            return false;
        }
        Player player = (Player)world.getEntityStore().getStore().getComponent(ref, Player.getComponentType());
        if (player == null) {
            return false;
        }
        ItemStack held = player.getInventory().getItemInHand();
        if (held == null) {
            return false;
        }
        if (held.isEmpty()) {
            return false;
        }
        Inventory inv = player.getInventory();
        boolean isTools = inv.usingToolsItem();
        ItemContainer container = isTools ? inv.getTools() : inv.getHotbar();
        ItemStack item = container.getItemStack((short)(activeIdx = isTools ? inv.getActiveToolsSlot() : inv.getActiveHotbarSlot()));
        if (item == null) {
            return false;
        }
        if (item.isEmpty()) {
            return false;
        }
        container.setItemStackForSlot((short)activeIdx, ItemStack.EMPTY);
        return true;
    }
}

