/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.effects;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3i;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.qixils.crowdcontrol.CrowdControlPlugin;
import dev.qixils.crowdcontrol.PlayerEffect;
import java.util.concurrent.ThreadLocalRandom;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.NotNull;

public class DigEffect
extends PlayerEffect {
    private static final double RADIUS = 0.5;
    private final String effectID = "dig";
    private final Message displayName = Message.raw((String)"Dig Hole");

    private static int depth() {
        return -(3 + ThreadLocalRandom.current().nextInt(5));
    }

    public DigEffect(CrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public String getEffectID() {
        return "dig";
    }

    @Override
    public Message getDisplayName() {
        return this.displayName;
    }

    @Override
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Unable to dig hole");
    }

    @Override
    protected boolean executeFor(@NotNull PlayerRef playerRef, @NotNull World world, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        Ref ref = playerRef.getReference();
        if (ref == null) {
            return false;
        }
        Store store = world.getEntityStore().getStore();
        TransformComponent component = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
        if (component == null) {
            return false;
        }
        Vector3d pos = component.getPosition();
        boolean success = false;
        int depth = DigEffect.depth();
        for (double x = -0.5; x <= 0.5; x += 1.0) {
            for (int y = depth; y <= 0; ++y) {
                for (double z = -0.5; z <= 0.5; z += 1.0) {
                    Vector3i blockPos = pos.clone().add(x, (double)y, z).toVector3i();
                    if (world.getBlock(blockPos) <= 0) continue;
                    world.breakBlock(blockPos.x, blockPos.y, blockPos.z, 0);
                    success = true;
                }
            }
        }
        return success;
    }
}

