/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.effects;

import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.AllLegacyLivingEntityTypesQuery;
import com.hypixel.hytale.server.core.modules.entity.component.EntityScaleComponent;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.qixils.crowdcontrol.CrowdControlPlugin;
import dev.qixils.crowdcontrol.Effect;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.NotNull;

public class EntitySizeEffect
extends Effect {
    private static final double RADIUS = Math.pow(30.0, 2.0);
    private final String effectID;
    private final Message displayName;
    private final float scale;

    public EntitySizeEffect(CrowdControlPlugin plugin, float scale) {
        super(plugin);
        this.scale = scale;
        DecimalFormat df = new DecimalFormat("0");
        df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        df.setMaximumFractionDigits(1);
        this.effectID = String.format("entity_scale_%s", df.format(scale).replaceAll("[^0-9]", "_"));
        this.displayName = Message.raw((String)String.format("Entity Scale %sx", df.format(scale)));
    }

    @Override
    public String getEffectID() {
        return this.effectID;
    }

    @Override
    public Message getDisplayName() {
        return this.displayName;
    }

    @Override
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Unable to dig hole");
    }

    @Override
    protected CompletableFuture<Boolean> executeAsync(@NotNull @NotNull Supplier<@NotNull List<@NotNull PlayerRef>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        CompletableFuture future = new CompletableFuture();
        for (World world : Universe.get().getWorlds().values()) {
            world.execute(() -> {
                Store store = world.getEntityStore().getStore();
                Set playerPositions = world.getPlayerRefs().stream().flatMap(playerRef -> {
                    Ref ref = playerRef.getReference();
                    if (ref == null) {
                        return Stream.empty();
                    }
                    TransformComponent transform = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
                    if (transform == null) {
                        return Stream.empty();
                    }
                    return Stream.of(transform.getPosition());
                }).collect(Collectors.toSet());
                store.forEachEntityParallel((Query)Query.and((Query[])new Query[]{AllLegacyLivingEntityTypesQuery.INSTANCE, TransformComponent.getComponentType(), Query.not((Query)Player.getComponentType())}), (index, archetypeChunk, commandBuffer) -> {
                    Ref ref = archetypeChunk.getReferenceTo(index);
                    world.execute(() -> {
                        try {
                            TransformComponent transform = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
                            if (transform == null) {
                                return;
                            }
                            EntityScaleComponent entityScale = (EntityScaleComponent)store.ensureAndGetComponent(ref, EntityScaleComponent.getComponentType());
                            Vector3d pos = transform.getPosition();
                            boolean nearPlayer = playerPositions.stream().anyMatch(playerPos -> pos.distanceSquaredTo(playerPos) < RADIUS);
                            if (!nearPlayer) {
                                return;
                            }
                            double pow2 = Math.pow(this.scale, 2.0);
                            if (this.scale < 1.0f && (double)entityScale.getScale() <= pow2 + 1.0E-4) {
                                return;
                            }
                            if (this.scale > 1.0f && (double)entityScale.getScale() >= pow2 - 1.0E-4) {
                                return;
                            }
                            entityScale.setScale(entityScale.getScale() * this.scale);
                            store.putComponent(ref, EntityScaleComponent.getComponentType(), (Component)entityScale);
                            future.complete(true);
                        }
                        catch (Exception e) {
                            ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Failed to run entity size task");
                        }
                    });
                });
            });
        }
        return future.orTimeout(3L, TimeUnit.SECONDS).handle((result, throwable) -> throwable == null && result != false);
    }
}

