/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.effects;

import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.qixils.crowdcontrol.CrowdControlPlugin;
import dev.qixils.crowdcontrol.PlayerTimedEffect;
import java.util.Locale;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.http.CustomEffectDuration;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.NotNull;

public class GameModeEffect
extends PlayerTimedEffect {
    private final GameMode gameMode;
    private final String effectID;
    private final Message displayName;
    private final CustomEffectDuration duration = new CustomEffectDuration(15.0);

    public GameModeEffect(CrowdControlPlugin plugin, GameMode gameMode) {
        super(plugin);
        this.gameMode = gameMode;
        this.effectID = "gamemode_" + gameMode.name().toLowerCase(Locale.ENGLISH);
        Message gameModeMessage = Message.translation((String)("server.general.gamemodes." + gameMode.name().toLowerCase(Locale.ENGLISH)));
        this.displayName = Message.join((Message[])new Message[]{Message.raw((String)"Set Game Mode to "), gameModeMessage});
    }

    @Override
    public String getEffectID() {
        return this.effectID;
    }

    @Override
    public Message getDisplayName() {
        return this.displayName;
    }

    @Override
    public CustomEffectDuration getExtensionDuration() {
        return this.duration;
    }

    @Override
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Unable to set gamemode");
    }

    protected static boolean setGameMode(@NotNull PlayerRef playerRef, @NotNull World world, @NotNull GameMode gameMode) {
        Ref ref = playerRef.getReference();
        if (ref == null) {
            return false;
        }
        Store store = world.getEntityStore().getStore();
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player == null) {
            return false;
        }
        if (gameMode.equals((Object)player.getGameMode())) {
            return false;
        }
        Player.setGameMode((Ref)ref, (GameMode)gameMode, (ComponentAccessor)store);
        return true;
    }

    @Override
    protected boolean executeFor(@NotNull PlayerRef playerRef, @NotNull World world, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return GameModeEffect.setGameMode(playerRef, world, this.gameMode);
    }

    @Override
    public void onEndFor(@NotNull PlayerRef playerRef, @NotNull World world, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        GameModeEffect.setGameMode(playerRef, world, GameMode.Adventure);
    }
}

