/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.effects;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatMap;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatValue;
import com.hypixel.hytale.server.core.modules.entitystats.asset.DefaultEntityStatTypes;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.qixils.crowdcontrol.CrowdControlPlugin;
import dev.qixils.crowdcontrol.PlayerEffect;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.NotNull;

public class HealEffect
extends PlayerEffect {
    private final String effectID = "heal";
    private final Message displayName = Message.raw((String)"Heal Player");

    public HealEffect(CrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public String getEffectID() {
        return "heal";
    }

    @Override
    public Message getDisplayName() {
        return this.displayName;
    }

    @Override
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Unable to heal players");
    }

    @Override
    protected boolean executeFor(@NotNull PlayerRef playerRef, @NotNull World world, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        Ref ref = playerRef.getReference();
        if (ref == null) {
            return false;
        }
        EntityStatMap stats = (EntityStatMap)world.getEntityStore().getStore().getComponent(ref, EntityStatMap.getComponentType());
        if (stats == null) {
            return false;
        }
        EntityStatValue currentStat = stats.get(DefaultEntityStatTypes.getHealth());
        if (currentStat == null) {
            return false;
        }
        float current = currentStat.get();
        float newValue = stats.resetStatValue(DefaultEntityStatTypes.getHealth());
        if (newValue == 0.0f) {
            return false;
        }
        return current != newValue;
    }
}

