/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.effects;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.modules.entity.damage.Damage;
import com.hypixel.hytale.server.core.modules.entity.damage.DamageCause;
import com.hypixel.hytale.server.core.modules.entity.damage.DeathComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.qixils.crowdcontrol.CrowdControlPlugin;
import dev.qixils.crowdcontrol.PlayerEffect;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.NotNull;

public class KillEffect
extends PlayerEffect {
    private final String effectID = "kill";
    private final Message displayName = Message.raw((String)"Kill Player");

    public KillEffect(CrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public String getEffectID() {
        return "kill";
    }

    @Override
    public Message getDisplayName() {
        return this.displayName;
    }

    @Override
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Unable to kill players");
    }

    @Override
    protected boolean executeFor(@NotNull PlayerRef playerRef, @NotNull World world, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        Ref ref = playerRef.getReference();
        if (ref == null) {
            return false;
        }
        DeathComponent.tryAddComponent((Store)world.getEntityStore().getStore(), (Ref)ref, (Damage)new Damage(Damage.NULL_SOURCE, DamageCause.COMMAND, 2.1474836E9f));
        return true;
    }
}

