/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.effects;

import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.protocol.ChangeVelocityType;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.knockback.KnockbackComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.qixils.crowdcontrol.CrowdControlPlugin;
import dev.qixils.crowdcontrol.PlayerEffect;
import java.util.concurrent.ThreadLocalRandom;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.NotNull;

public class LaunchEffect
extends PlayerEffect {
    private final String effectID = "launch";
    private final Message displayName = Message.raw((String)"Launch Player");

    private static double randomFlingHoriz() {
        return (double)(ThreadLocalRandom.current().nextBoolean() ? -1 : 1) * ThreadLocalRandom.current().nextDouble(3.0, 7.0);
    }

    public static Vector3d randomFlingVector() {
        return new Vector3d(LaunchEffect.randomFlingHoriz(), ThreadLocalRandom.current().nextDouble(25.0, 40.0), LaunchEffect.randomFlingHoriz());
    }

    public LaunchEffect(CrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public String getEffectID() {
        return "launch";
    }

    @Override
    public Message getDisplayName() {
        return this.displayName;
    }

    @Override
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Unable to launch player");
    }

    @Override
    protected boolean executeFor(@NotNull PlayerRef playerRef, @NotNull World world, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        Ref ref = playerRef.getReference();
        if (ref == null) {
            return false;
        }
        Store store = world.getEntityStore().getStore();
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player == null) {
            return false;
        }
        if (!GameMode.Adventure.equals((Object)player.getGameMode())) {
            return false;
        }
        KnockbackComponent component = (KnockbackComponent)store.ensureAndGetComponent(ref, KnockbackComponent.getComponentType());
        component.setDuration(0.0f);
        component.setVelocity(LaunchEffect.randomFlingVector());
        component.setVelocityType(ChangeVelocityType.Add);
        store.putComponent(ref, KnockbackComponent.getComponentType(), (Component)component);
        return true;
    }
}

