/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.effects;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.modules.entity.component.EntityScaleComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.qixils.crowdcontrol.CrowdControlPlugin;
import dev.qixils.crowdcontrol.PlayerTimedEffect;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.http.CustomEffectDuration;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.NotNull;

public class PlayerSizeEffect
extends PlayerTimedEffect {
    private final String effectID;
    private final Message displayName;
    private final float scale;
    private final CustomEffectDuration duration = new CustomEffectDuration(15.0);

    public PlayerSizeEffect(CrowdControlPlugin plugin, float scale) {
        super(plugin);
        this.scale = scale;
        DecimalFormat df = new DecimalFormat("0");
        df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        df.setMaximumFractionDigits(1);
        this.effectID = String.format("player_scale_%s", df.format(scale).replaceAll("[^0-9]", "_"));
        this.displayName = Message.raw((String)String.format("Player Scale %sx", df.format(scale)));
    }

    @Override
    public String getEffectID() {
        return this.effectID;
    }

    @Override
    public Message getDisplayName() {
        return this.displayName;
    }

    @Override
    public CustomEffectDuration getExtensionDuration() {
        return this.duration;
    }

    @Override
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Unable to set size");
    }

    protected static boolean setScale(@NotNull PlayerRef playerRef, @NotNull World world, float scale) {
        Ref ref = playerRef.getReference();
        if (ref == null) {
            return false;
        }
        Store store = world.getEntityStore().getStore();
        EntityScaleComponent entityScale = (EntityScaleComponent)store.ensureAndGetComponent(ref, EntityScaleComponent.getComponentType());
        if ((double)Math.abs(entityScale.getScale() - scale) < 1.0E-4) {
            return false;
        }
        entityScale.setScale(2.0f);
        return true;
    }

    @Override
    protected boolean executeFor(@NotNull PlayerRef playerRef, @NotNull World world, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return PlayerSizeEffect.setScale(playerRef, world, this.scale);
    }

    @Override
    public void onEndFor(@NotNull PlayerRef playerRef, @NotNull World world, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        PlayerSizeEffect.setScale(playerRef, world, 1.0f);
    }
}

