/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.effects;

import com.hypixel.hytale.common.util.RandomUtil;
import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.function.consumer.TriConsumer;
import com.hypixel.hytale.math.shape.Box;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.protocol.PlayerSkin;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.asset.type.model.config.Model;
import com.hypixel.hytale.server.core.cosmetics.CosmeticsModule;
import com.hypixel.hytale.server.core.modules.entity.component.BoundingBox;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.modules.entity.player.ApplyRandomSkinPersistedComponent;
import com.hypixel.hytale.server.core.modules.entity.player.PlayerSkinComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.npc.NPCPlugin;
import com.hypixel.hytale.server.npc.asset.builder.Builder;
import com.hypixel.hytale.server.npc.asset.builder.BuilderInfo;
import com.hypixel.hytale.server.npc.entities.NPCEntity;
import com.hypixel.hytale.server.spawning.ISpawnableWithModel;
import com.hypixel.hytale.server.spawning.SpawningContext;
import dev.qixils.crowdcontrol.CrowdControlPlugin;
import dev.qixils.crowdcontrol.PlayerEffect;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.NotNull;

public class SpawnEntityEffect
extends PlayerEffect {
    private final List<BuilderInfo> builderInfos;
    private final String effectID;
    private final Message displayName;
    private final byte priority = (byte)-5;
    private final List<String> categories = Collections.singletonList("Summon NPC");
    private final String description;

    public SpawnEntityEffect(CrowdControlPlugin plugin, String type, List<BuilderInfo> builderInfos) {
        super(plugin);
        this.builderInfos = builderInfos;
        if (builderInfos.size() > 1) {
            this.effectID = "spawn_" + type.toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9_]", "_");
            this.displayName = Message.raw((String)("Spawn " + type + " (Random)"));
            this.description = "Spawns a random NPC tagged under \"" + type + "\" on the player";
        } else if (!builderInfos.isEmpty()) {
            BuilderInfo builderInfo = builderInfos.getFirst();
            this.effectID = "spawn_" + builderInfo.getKeyName().toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9_]", "_");
            this.displayName = Message.raw((String)("Spawn " + builderInfo.getKeyName().replaceAll("_", " ")));
            this.description = "Spawns a(n) \"" + type + "\" NPC on the player";
        } else {
            throw new IllegalArgumentException("Must provide at least 1 builder");
        }
    }

    @Override
    public String getEffectID() {
        return this.effectID;
    }

    @Override
    public Message getDisplayName() {
        return this.displayName;
    }

    @Override
    public byte getPriority() {
        return -5;
    }

    @Override
    public List<String> getCategories() {
        return this.categories;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Unable to spawn NPC");
    }

    @Override
    protected boolean executeFor(@NotNull PlayerRef playerRef, @NotNull World world, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        BuilderInfo builderInfo = (BuilderInfo)RandomUtil.selectRandom(this.builderInfos);
        Ref ref = playerRef.getReference();
        if (ref == null) {
            return false;
        }
        Store store = world.getEntityStore().getStore();
        TransformComponent transformComponent = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
        if (transformComponent == null) {
            return false;
        }
        Vector3d playerPosition = transformComponent.getPosition();
        BoundingBox boundingBoxComponent = (BoundingBox)store.getComponent(ref, BoundingBox.getComponentType());
        if (boundingBoxComponent == null) {
            return false;
        }
        Box playerBoundingBox = boundingBoxComponent.getBoundingBox();
        int roleIndex = builderInfo.getIndex();
        NPCPlugin.get().forceValidation(roleIndex);
        if (!NPCPlugin.get().testAndValidateRole(builderInfo)) {
            return false;
        }
        Builder roleBuilder = NPCPlugin.get().tryGetCachedValidRole(roleIndex);
        if (roleBuilder == null) {
            return false;
        }
        if (!(roleBuilder instanceof ISpawnableWithModel)) {
            return false;
        }
        ISpawnableWithModel spawnable = (ISpawnableWithModel)roleBuilder;
        if (!roleBuilder.isSpawnable()) {
            return false;
        }
        SpawningContext spawningContext = new SpawningContext();
        if (!spawningContext.setSpawnable(spawnable)) {
            return false;
        }
        TriConsumer skinApplyingFunction = null;
        Model model = spawningContext.getModel();
        if (model == null) {
            return false;
        }
        if ("Player".equals(model.getModelAssetId()) || "Characters/Player.blockymodel".equals(model.getModel())) {
            PlayerSkin playerSkin = CosmeticsModule.get().generateRandomSkin((Random)RandomUtil.getSecureRandom());
            Model newModel = CosmeticsModule.get().createModel(playerSkin);
            if (newModel != null) {
                model = newModel;
                skinApplyingFunction = (npcEntity, entityStoreRef, entityStore) -> {
                    entityStore.putComponent(entityStoreRef, PlayerSkinComponent.getComponentType(), (Component)new PlayerSkinComponent(playerSkin));
                    entityStore.putComponent(entityStoreRef, ApplyRandomSkinPersistedComponent.getComponentType(), (Component)ApplyRandomSkinPersistedComponent.INSTANCE);
                };
            }
        }
        Vector3f rotation = new Vector3f(0.0f, (float)(2.0 * ThreadLocalRandom.current().nextDouble() * Math.PI), 0.0f);
        Box modelBox = model.getBoundingBox();
        if (modelBox == null) {
            return false;
        }
        Vector3d position = new Vector3d(playerPosition);
        position.y = Math.floor(position.y + playerBoundingBox.min.y + 0.01) - modelBox.min.y;
        Pair npcPair = NPCPlugin.get().spawnEntity(world.getEntityStore().getStore(), roleIndex, position, rotation, model, skinApplyingFunction);
        if (npcPair == null) {
            return false;
        }
        Ref npcRef = (Ref)npcPair.first();
        NPCEntity npc = (NPCEntity)npcPair.second();
        TransformComponent npcTransformComponent = (TransformComponent)store.getComponent(npcRef, TransformComponent.getComponentType());
        if (npcTransformComponent != null) {
            Vector3d npcPosition = npcTransformComponent.getPosition();
            double x = npcPosition.getX();
            double y = npcPosition.getY();
            double z = npcPosition.getZ();
            npcPosition.assign(x, y += 0.1, z);
            npc.saveLeashInformation(npcPosition, npcTransformComponent.getRotation());
        }
        return true;
    }
}

