/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.effects;

import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.modules.time.WorldTimeResource;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.WorldConfig;
import dev.qixils.crowdcontrol.CrowdControlPlugin;
import dev.qixils.crowdcontrol.Effect;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.NotNull;

public class TimeEffect
extends Effect {
    private final String effectID;
    private final Message displayName;
    private final int setHour;

    public TimeEffect(CrowdControlPlugin plugin, int setHour) {
        super(plugin);
        String meridiem;
        this.setHour = setHour;
        String string = meridiem = setHour >= 12 ? "PM" : "AM";
        int display = setHour == 0 ? 12 : (setHour > 12 ? setHour - 12 : setHour);
        this.effectID = "time_" + setHour;
        this.displayName = Message.raw((String)("Set Time to " + display + meridiem));
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public String getEffectID() {
        return this.effectID;
    }

    @Override
    public Message getDisplayName() {
        return this.displayName;
    }

    @Override
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Failed to set time");
    }

    @Override
    protected CompletableFuture<Boolean> executeAsync(@NotNull @NotNull Supplier<@NotNull List<@NotNull PlayerRef>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        List<CompletableFuture> perWorldFutures = Universe.get().getWorlds().values().stream().map(world -> CompletableFuture.supplyAsync(() -> {
            ZonedDateTime startOfHour;
            WorldConfig worldConfig = world.getWorldConfig();
            Store store = world.getEntityStore().getStore();
            WorldTimeResource worldTime = (WorldTimeResource)store.getResource(WorldTimeResource.getResourceType());
            Instant date = worldConfig.getGameTime();
            ZonedDateTime utc = date.atZone(WorldTimeResource.ZONE_OFFSET);
            ZonedDateTime newDay = startOfHour = utc.withNano(0).withSecond(0).withMinute(0);
            if (startOfHour.getHour() >= this.setHour) {
                newDay = newDay.plusDays(1L);
            }
            ZonedDateTime finalDate = newDay.withHour(this.setHour);
            Instant finalInstant = finalDate.toInstant();
            worldConfig.setGameTime(finalInstant);
            worldTime.setGameTime(finalInstant, world, store);
            return true;
        }, (Executor)world)).toList();
        return CompletableFuture.allOf((CompletableFuture[])perWorldFutures.toArray(CompletableFuture[]::new)).completeOnTimeout(null, 55L, TimeUnit.SECONDS).thenApply(void_ -> perWorldFutures.stream().anyMatch(future -> future.state() == Future.State.SUCCESS && (Boolean)future.resultNow() != false));
    }
}

