/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.util;

import com.hypixel.hytale.logger.HytaleLogger;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionUtil {
    private static final HytaleLogger log = HytaleLogger.forEnclosingClass();

    @Nullable
    public static <T> T init(@NotNull Supplier<T> supplier, @Nullable Consumer<Exception> onError) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            if (onError != null) {
                try {
                    onError.accept(e);
                }
                catch (Exception e2) {
                    ((HytaleLogger.Api)((HytaleLogger.Api)log.atWarning()).withCause((Throwable)e)).log("Failed to initialize %s...", (Object)supplier.getClass().getName());
                    ((HytaleLogger.Api)((HytaleLogger.Api)log.atWarning()).withCause((Throwable)e2)).log("...and failed to call onError");
                }
            } else {
                ((HytaleLogger.Api)((HytaleLogger.Api)log.atWarning()).withCause((Throwable)e)).log("Failed to initialize %s", (Object)supplier.getClass().getName());
            }
            return null;
        }
    }

    @Nullable
    public static <T> T init(@NotNull Supplier<T> supplier) {
        return CollectionUtil.init(supplier, null);
    }

    public static <T> void initTo(@NotNull Collection<T> collection, @NotNull Supplier<? extends T> supplier, @Nullable Consumer<Exception> onError) {
        T t = CollectionUtil.init(supplier, onError);
        if (t != null) {
            collection.add(t);
        }
    }

    public static <T> void initTo(@NotNull Collection<T> collection, @NotNull Supplier<? extends T> supplier) {
        CollectionUtil.initTo(collection, supplier, null);
    }
}

