/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.util;

import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.receiver.IMessageReceiver;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class ForwardingMessageReceiver
implements IMessageReceiver {
    private final Supplier<? extends Collection<? extends IMessageReceiver>> supplier;
    private final HytaleLogger logger = HytaleLogger.forEnclosingClass();

    private ForwardingMessageReceiver(Supplier<? extends Collection<? extends IMessageReceiver>> supplier) {
        this.supplier = supplier;
    }

    public void sendMessage(@NotNull Message msg) {
        try {
            for (IMessageReceiver iMessageReceiver : this.supplier.get()) {
                try {
                    iMessageReceiver.sendMessage(msg);
                }
                catch (Exception e) {
                    ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Failed to forward message to receiver");
                }
            }
        }
        catch (Exception e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Failed to forward message to receivers");
        }
    }

    public static ForwardingMessageReceiver ofSuppliedCollection(Supplier<? extends Collection<? extends IMessageReceiver>> supplier) {
        return new ForwardingMessageReceiver(supplier);
    }

    public static ForwardingMessageReceiver ofSuppliedSingle(Supplier<? extends IMessageReceiver> supplier) {
        return ForwardingMessageReceiver.ofSuppliedCollection(() -> Collections.singleton((IMessageReceiver)supplier.get()));
    }

    public static ForwardingMessageReceiver ofCollection(Collection<? extends IMessageReceiver> collection) {
        return ForwardingMessageReceiver.ofSuppliedCollection(() -> collection);
    }

    public static ForwardingMessageReceiver ofSingle(IMessageReceiver single) {
        return ForwardingMessageReceiver.ofCollection(Collections.singleton(single));
    }
}

