/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.util;

import com.hypixel.hytale.logger.HytaleLogger;
import dev.qixils.crowdcontrol.util.CCResponseException;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;

public class ThreadUtil {
    private static final HytaleLogger log = HytaleLogger.forEnclosingClass();
    public static long TRY_FOR = 50000L;

    public static boolean sleep() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            return false;
        }
        return !Thread.interrupted();
    }

    @CheckReturnValue
    @NotNull
    public static CCEffectResponse waitForSuccess(@NotNull PublicEffectPayload request, Function<Long, CCEffectResponse> supplier) {
        CCEffectResponse resp = null;
        long time = System.currentTimeMillis();
        int i = 0;
        while (System.currentTimeMillis() - time < TRY_FOR) {
            try {
                resp = supplier.apply(time + TRY_FOR - System.currentTimeMillis());
            }
            catch (CCResponseException e) {
                resp = e.getResponse();
            }
            catch (CompletionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof CCResponseException) {
                    CCResponseException cc = (CCResponseException)throwable;
                    resp = cc.getResponse();
                } else {
                    ((HytaleLogger.Api)((HytaleLogger.Api)log.atWarning()).withCause((Throwable)e)).log("Failed to supply completed for %s", (Object)request.getEffect().getEffectId());
                }
            }
            catch (Exception e) {
                ((HytaleLogger.Api)((HytaleLogger.Api)log.atWarning()).withCause((Throwable)e)).log("Failed to supply for %s", (Object)request.getEffect().getEffectId());
            }
            if ((resp == null || resp.getStatus() != ResponseStatus.SUCCESS && resp.getStatus() != ResponseStatus.FAIL_PERMANENT && resp.getStatus() != ResponseStatus.TIMED_BEGIN) && (i++ <= 0 || ThreadUtil.sleep())) continue;
        }
        if (resp != null) {
            return resp;
        }
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Effect failed to execute");
    }
}

