/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j;

import io.leangen.geantyref.TypeToken;
import java.util.Objects;
import live.crowdcontrol.cc4j.CCMessage;
import live.crowdcontrol.cc4j.util.CloseData;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.http.GameSessionStartPayload;
import live.crowdcontrol.cc4j.websocket.http.GameSessionStopPayload;
import live.crowdcontrol.cc4j.websocket.payload.ApplicationAuthCodeErrorPayload;
import live.crowdcontrol.cc4j.websocket.payload.ApplicationAuthCodePayload;
import live.crowdcontrol.cc4j.websocket.payload.ApplicationAuthCodeRedeemedPayload;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import live.crowdcontrol.cc4j.websocket.payload.SubscriptionResultPayload;
import org.jetbrains.annotations.NotNull;

public class CCEventType<T> {
    @NotNull
    private final String listenerId;
    @NotNull
    private final TypeToken<T> typeToken;
    public static final CCEventType<CCMessage> MESSAGE = new CCEventType<CCMessage>("message", CCMessage.class);
    public static final CCEventType<Void> CONNECTED = CCEventType.ofVoid("connected");
    public static final CCEventType<CloseData> DISCONNECTED = new CCEventType<CloseData>("disconnected", CloseData.class);
    public static final CCEventType<ApplicationAuthCodePayload> GENERATED_AUTH_CODE = new CCEventType<ApplicationAuthCodePayload>("generated_auth_code", ApplicationAuthCodePayload.class);
    public static final CCEventType<ApplicationAuthCodeRedeemedPayload> REDEEMED_AUTH_CODE = new CCEventType<ApplicationAuthCodeRedeemedPayload>("redeemed_auth_code", ApplicationAuthCodeRedeemedPayload.class);
    public static final CCEventType<ApplicationAuthCodeErrorPayload> ERRORED_AUTH_CODE = new CCEventType<ApplicationAuthCodeErrorPayload>("errored_auth_code", ApplicationAuthCodeErrorPayload.class);
    public static final CCEventType<Void> AUTHENTICATED = CCEventType.ofVoid("authenticated");
    public static final CCEventType<Void> AUTH_EXPIRED = CCEventType.ofVoid("auth_expired");
    public static final CCEventType<Void> UNAUTHENTICATED = CCEventType.ofVoid("unauthenticated");
    public static final CCEventType<PublicEffectPayload> EFFECT_REQUEST = new CCEventType<PublicEffectPayload>("effect_request", PublicEffectPayload.class);
    public static final CCEventType<PublicEffectPayload> EFFECT_FAILURE = new CCEventType<PublicEffectPayload>("effect_failure", PublicEffectPayload.class);
    public static final CCEventType<SubscriptionResultPayload> SUBSCRIBED = new CCEventType<SubscriptionResultPayload>("subscribed", SubscriptionResultPayload.class);
    public static final CCEventType<CCEffectResponse> EFFECT_RESPONSE = new CCEventType<CCEffectResponse>("effect_result", CCEffectResponse.class);
    public static final CCEventType<GameSessionStartPayload> SESSION_STARTED = new CCEventType<GameSessionStartPayload>("game_session_start", GameSessionStartPayload.class);
    public static final CCEventType<GameSessionStopPayload> SESSION_STOPPED = new CCEventType<GameSessionStopPayload>("game_session_stop", GameSessionStopPayload.class);

    public CCEventType(@NotNull String listenerId, @NotNull TypeToken<T> typeToken) {
        this.listenerId = listenerId;
        this.typeToken = typeToken;
    }

    public CCEventType(@NotNull String listenerId, @NotNull Class<T> clazz) {
        this(listenerId, TypeToken.get(clazz));
    }

    public static CCEventType<Void> ofVoid(@NotNull String listenerId) {
        return new CCEventType<Void>(listenerId, Void.class);
    }

    @NotNull
    public String getListenerId() {
        return this.listenerId;
    }

    @NotNull
    public TypeToken<T> getTypeToken() {
        return this.typeToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CCEventType that = (CCEventType)o;
        return Objects.equals(this.listenerId, that.listenerId) && Objects.equals(this.typeToken, that.typeToken);
    }

    public int hashCode() {
        return Objects.hash(this.listenerId, this.typeToken);
    }

    public String toString() {
        return "CCEventType{listenerId='" + this.listenerId + "', typeToken=" + String.valueOf(this.typeToken) + "}";
    }
}

