/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.util;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import live.crowdcontrol.cc4j.CCEventType;
import live.crowdcontrol.cc4j.CrowdControl;
import live.crowdcontrol.cc4j.util.EventRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventManager {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger("CrowdControl/EventManager");
    public static final int CATCH_UP_DEFAULT = -1;
    public static final int RECORD_LIMIT = 100;
    @NotNull
    private final List<EventRecord<?>> records = new ArrayList(100);
    @NotNull
    private final Map<CCEventType<?>, List<Consumer<?>>> listeners = new HashMap();
    @NotNull
    private final CrowdControl parent;

    public EventManager(@NotNull CrowdControl parent) {
        this.parent = parent;
    }

    @NotNull
    private <T> @NotNull Stream<@NotNull EventRecord<T>> getRecords(@NotNull CCEventType<T> event, int catchUpPeriod) {
        if (catchUpPeriod == 0) {
            return Stream.empty();
        }
        return this.records.stream().flatMap(record -> event.equals(record.getEventType()) ? Stream.of(record) : Stream.empty()).peek(record -> log.info("Found record {} for event {}", record, (Object)event)).filter(record -> catchUpPeriod == -1 || !Instant.now().minusSeconds(catchUpPeriod).isBefore(record.getTriggeredAt()));
    }

    private <T> void invoke(@NotNull EventRecord<T> record, @NotNull List<Consumer<T>> listeners, int index) {
        this.parent.getEventPool().submit(() -> {
            Consumer listener = (Consumer)listeners.get(index);
            try {
                listener.accept(record.getEventBody());
            }
            catch (Exception e) {
                log.error("Failed to dispatch event {} to listener {}", record.getEventType(), listener.getClass().getSimpleName(), e);
            }
            int nextIndex = index + 1;
            if (listeners.size() > nextIndex) {
                this.invoke(record, listeners, nextIndex);
            }
        });
    }

    private <T> void _dispatch(@NotNull CCEventType<T> event, @Nullable T body) {
        ArrayList<Consumer<T>> cloned;
        EventRecord<T> record = new EventRecord<T>(event, body);
        List<Consumer<?>> eventListeners = this.listeners.get(event);
        if (eventListeners != null && !(cloned = new ArrayList<Consumer<T>>(eventListeners)).isEmpty()) {
            this.invoke(record, cloned, 0);
        }
        while (this.records.size() >= 100) {
            this.records.remove(0);
        }
        this.records.add(record);
    }

    public <T> void dispatch(@NotNull CCEventType<T> event, @NotNull T body) {
        this._dispatch(event, body);
    }

    public void dispatch(@NotNull CCEventType<Void> event) {
        this._dispatch(event, null);
    }

    public <T> void registerEventConsumer(@NotNull CCEventType<T> event, @NotNull Consumer<T> listener, int catchUpPeriod) {
        this.listeners.computeIfAbsent(event, $ -> new ArrayList()).add(listener);
        this.getRecords(event, catchUpPeriod).forEachOrdered(record -> this.invoke((EventRecord)record, Collections.singletonList(listener), 0));
    }

    public <T> void registerEventConsumer(@NotNull CCEventType<T> event, @NotNull Consumer<T> listener) {
        this.registerEventConsumer(event, listener, -1);
    }

    public void registerEventRunnable(@NotNull CCEventType<?> event, @NotNull Runnable listener, int catchUpPeriod) {
        this.registerEventConsumer(event, $ -> listener.run(), catchUpPeriod);
    }

    public void registerEventRunnable(@NotNull CCEventType<?> event, @NotNull Runnable listener) {
        this.registerEventRunnable(event, listener, -1);
    }
}

