/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.util;

import java.time.Instant;
import live.crowdcontrol.cc4j.CCEventType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EventRecord<T> {
    @NotNull
    private final Instant triggeredAt = Instant.now();
    @NotNull
    private final CCEventType<T> eventType;
    @Nullable
    private final T eventBody;

    public EventRecord(@NotNull CCEventType<T> eventType, @Nullable T eventBody) {
        this.eventType = eventType;
        this.eventBody = eventBody;
    }

    public static EventRecord<Void> ofVoid(@NotNull CCEventType<Void> eventType) {
        return new EventRecord<Object>(eventType, null);
    }

    @NotNull
    public Instant getTriggeredAt() {
        return this.triggeredAt;
    }

    @NotNull
    public CCEventType<T> getEventType() {
        return this.eventType;
    }

    @Nullable
    public T getEventBody() {
        return this.eventBody;
    }
}

