/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.util;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.http.HttpClient;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import live.crowdcontrol.cc4j.CrowdControl;
import live.crowdcontrol.cc4j.websocket.ConnectedPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    @NotNull
    public static final URL OPEN_API_URL;
    public static final HttpClient HTTP_CLIENT;
    @NotNull
    private static final Logger log;
    @NotNull
    private final CrowdControl parent;

    public HttpUtil(@NotNull CrowdControl parent) {
        this.parent = parent;
    }

    @NotNull
    private <T> CompletableFuture<T> apiCall(@NotNull String method, @NotNull String spec, @NotNull Function<InputStream, T> output, @Nullable String token, @Nullable Object data) {
        return CompletableFuture.supplyAsync(() -> {
            HttpURLConnection con = null;
            try {
                URL url = new URL(OPEN_API_URL, spec);
                con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod(method);
                con.setRequestProperty("User-Agent", "crowdcontrol4j");
                con.setRequestProperty("Content-Type", "application/json");
                if (token != null) {
                    con.setRequestProperty("Authorization", "cc-auth-token " + token);
                }
                con.setConnectTimeout(10000);
                con.setReadTimeout(10000);
                if (data != null) {
                    con.setRequestProperty("Accept", "application/json");
                    con.setDoOutput(true);
                    try (OutputStream os = con.getOutputStream();){
                        log.debug("Outputting to {}: {}", (Object)spec, (Object)ConnectedPlayer.JACKSON.writeValueAsString(data));
                        ConnectedPlayer.JACKSON.writeValue(os, data);
                    }
                }
                Object out = output.apply(con.getInputStream());
                if (con.getResponseCode() != 200) {
                    throw new IllegalStateException("Server returned code " + con.getResponseCode());
                }
                Object r = out;
                return r;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }, this.parent.getEffectPool());
    }

    private String asString(InputStream stream) {
        try {
            byte[] bytes = stream.readAllBytes();
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read as string", e);
        }
    }

    @NotNull
    private <T> Function<InputStream, T> createOutputFunction(@NotNull TypeReference<T> output) {
        return input -> {
            try {
                return ConnectedPlayer.JACKSON.readValue((InputStream)input, output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @NotNull
    private <T> Function<InputStream, T> createOutputFunction(@NotNull Class<T> output) {
        return input -> {
            try {
                return ConnectedPlayer.JACKSON.readValue((InputStream)input, output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @NotNull
    public <T> CompletableFuture<T> apiGet(@NotNull String spec, @NotNull TypeReference<T> output, @Nullable String token) {
        return this.apiCall("GET", spec, this.createOutputFunction(output), token, null);
    }

    @NotNull
    public <T> CompletableFuture<T> apiGet(@NotNull String spec, @NotNull Class<T> output, @Nullable String token) {
        return this.apiCall("GET", spec, this.createOutputFunction(output), token, null);
    }

    @NotNull
    public CompletableFuture<String> apiGet(@NotNull String spec, @Nullable String token) {
        return this.apiCall("GET", spec, this::asString, token, null);
    }

    @NotNull
    public <T> CompletableFuture<T> apiPost(@NotNull String spec, @NotNull TypeReference<T> output, @Nullable String token, @Nullable Object data) {
        return this.apiCall("POST", spec, this.createOutputFunction(output), token, data);
    }

    @NotNull
    public <T> CompletableFuture<T> apiPost(@NotNull String spec, @NotNull Class<T> output, @Nullable String token, @Nullable Object data) {
        return this.apiCall("POST", spec, this.createOutputFunction(output), token, data);
    }

    @NotNull
    public CompletableFuture<String> apiPost(@NotNull String spec, @Nullable String token, @Nullable Object data) {
        return this.apiCall("POST", spec, this::asString, token, data);
    }

    @NotNull
    public <T> CompletableFuture<T> apiPut(@NotNull String spec, @NotNull TypeReference<T> output, @Nullable String token, @Nullable Object data) {
        return this.apiCall("PUT", spec, this.createOutputFunction(output), token, data);
    }

    @NotNull
    public <T> CompletableFuture<T> apiPut(@NotNull String spec, @NotNull Class<T> output, @Nullable String token, @Nullable Object data) {
        return this.apiCall("PUT", spec, this.createOutputFunction(output), token, data);
    }

    @NotNull
    public CompletableFuture<String> apiPut(@NotNull String spec, @Nullable String token, @Nullable Object data) {
        return this.apiCall("PUT", spec, this::asString, token, data);
    }

    static {
        HTTP_CLIENT = HttpClient.newHttpClient();
        log = LoggerFactory.getLogger("CrowdControl/Http");
        try {
            OPEN_API_URL = new URL("https://openapi.crowdcontrol.live");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to create OpenAPI URL", e);
        }
    }
}

