/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.websocket.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import live.crowdcontrol.cc4j.websocket.data.IdentifierType;
import live.crowdcontrol.cc4j.websocket.data.ReportStatus;
import org.jetbrains.annotations.NotNull;

public class CCEffectReport {
    @NotNull
    protected final UUID id;
    protected final long stamp;
    @NotNull
    protected final IdentifierType identifierType;
    @NotNull
    protected final @NotNull List<@NotNull String> ids;
    @NotNull
    protected final ReportStatus status;

    @JsonCreator
    CCEffectReport(@JsonProperty(value="id") @NotNull UUID id, @JsonProperty(value="stamp") long stamp, @JsonProperty(value="identifierType") @NotNull IdentifierType identifierType, @JsonProperty(value="ids") @NotNull @NotNull List<@NotNull String> ids, @JsonProperty(value="status") @NotNull ReportStatus status) {
        this.id = id;
        this.stamp = stamp;
        this.identifierType = identifierType;
        this.ids = ids;
        this.status = status;
    }

    public CCEffectReport(@NotNull IdentifierType identifierType, @NotNull ReportStatus status, @NotNull @NotNull List<@NotNull String> ids) {
        this.id = UUID.randomUUID();
        this.stamp = (int)(System.currentTimeMillis() / 1000L);
        this.identifierType = identifierType;
        this.ids = Collections.unmodifiableList(new ArrayList<String>(ids));
        this.status = status;
    }

    public CCEffectReport(@NotNull IdentifierType identifierType, @NotNull ReportStatus status, String ... ids) {
        this(identifierType, status, Arrays.asList(ids));
    }

    public CCEffectReport(@NotNull ReportStatus status, @NotNull @NotNull List<@NotNull String> ids) {
        this(IdentifierType.EFFECT, status, ids);
    }

    public CCEffectReport(@NotNull ReportStatus status, String ... ids) {
        this(status, Arrays.asList(ids));
    }

    @NotNull
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="stamp")
    public long getTimestamp() {
        return this.stamp;
    }

    @NotNull
    public IdentifierType getIdentifierType() {
        return this.identifierType;
    }

    @NotNull
    public @NotNull List<@NotNull String> getIds() {
        return this.ids;
    }

    @NotNull
    public ReportStatus getStatus() {
        return this.status;
    }
}

