/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.websocket.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum IdentifierType {
    EFFECT("effect"),
    CATEGORY("category"),
    GROUP("group"),
    UNKNOWN("");

    private static final Map<String, IdentifierType> BY_VALUE;
    @NotNull
    private final String value;

    @JsonCreator
    @NotNull
    public static IdentifierType fromValue(@NotNull String value) {
        return BY_VALUE.getOrDefault(value, UNKNOWN);
    }

    private IdentifierType(String value) {
        this.value = value;
    }

    @JsonValue
    @NotNull
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    static {
        HashMap<String, IdentifierType> byValue = new HashMap<String, IdentifierType>();
        for (IdentifierType status : IdentifierType.values()) {
            if (status == UNKNOWN) continue;
            byValue.put(status.value, status);
        }
        BY_VALUE = Collections.unmodifiableMap(byValue);
    }
}

