/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.websocket.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum ResponseStatus {
    SUCCESS("success", false, true),
    FAIL_TEMPORARY("failTemporary", false, true),
    FAIL_PERMANENT("failPermanent", false, true),
    DELAY_ESTIMATED("delayEstimated", true, false),
    TIMED_BEGIN("timedBegin", true, true),
    TIMED_PAUSE("timedPause", true, false),
    TIMED_RESUME("timedResume", true, false),
    TIMED_END("timedEnd", false, false),
    UNKNOWN("", false, true);

    private static final Map<String, ResponseStatus> BY_VALUE;
    @NotNull
    private final String value;
    private final boolean timed;
    private final boolean terminating;

    @JsonCreator
    @NotNull
    public static ResponseStatus fromValue(@NotNull String value) {
        return BY_VALUE.getOrDefault(value, UNKNOWN);
    }

    private ResponseStatus(String value, boolean timed, boolean terminating) {
        this.value = value;
        this.timed = timed;
        this.terminating = terminating;
    }

    @JsonValue
    @NotNull
    public String getValue() {
        return this.value;
    }

    public boolean isTimed() {
        return this.timed;
    }

    public boolean isTerminating() {
        return this.terminating;
    }

    public String toString() {
        return this.getValue();
    }

    static {
        HashMap<String, ResponseStatus> byValue = new HashMap<String, ResponseStatus>();
        for (ResponseStatus status : ResponseStatus.values()) {
            if (status == UNKNOWN) continue;
            byValue.put(status.value, status);
        }
        BY_VALUE = Collections.unmodifiableMap(byValue);
    }
}

