/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.websocket.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionData {
    @RegExp
    @NotNull
    public static final String TOPIC_PATTERN = "^(?<domain>overlay|session|prv|pub|app|ext|whisper)(?:/(?<scope>\\*|ccuid-[0-7][0-9a-hjkmnp-tv-z]{25}))?/(?<target>\\*|ccuid-[0-7][0-9a-hjkmnp-tv-z]{25})$";
    @NotNull
    private static final Logger log = LoggerFactory.getLogger("CrowdControl/SubscriptionData");
    @NotNull
    private final @NotNull Set<@NotNull String> topics;
    @Nullable
    private final String token;
    @Nullable
    private final String key;

    @JsonCreator
    public SubscriptionData(@JsonProperty(value="topics") @NotNull @NotNull Set<@NotNull String> topics, @JsonProperty(value="token") @Nullable String token, @JsonProperty(value="key") @Nullable String key) {
        this.topics = Collections.unmodifiableSet(new HashSet<String>(topics));
        for (String topic : this.topics) {
            if (topic.matches(TOPIC_PATTERN)) continue;
            log.warn("Topic {} may be invalid; fails to match expected pattern", (Object)topic);
        }
        this.token = token;
        this.key = key;
    }

    public SubscriptionData(@NotNull @NotNull Set<@NotNull String> topics, @Nullable String token) {
        this(topics, token, null);
    }

    public SubscriptionData(@NotNull @NotNull Set<@NotNull String> topics) {
        this(topics, null, null);
    }

    @NotNull
    public @NotNull Set<@NotNull String> getTopics() {
        return this.topics;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    @Nullable
    public String getKey() {
        return this.key;
    }
}

