/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.websocket.http;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import live.crowdcontrol.cc4j.websocket.http.CustomEffect;
import live.crowdcontrol.cc4j.websocket.http.CustomEffectDuration;
import live.crowdcontrol.cc4j.websocket.http.CustomEffectParameter;
import live.crowdcontrol.cc4j.websocket.http.CustomEffectQuantity;
import live.crowdcontrol.cc4j.websocket.payload.CCName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomEffectBuilder {
    private CCName name;
    private int price;
    private String description = CustomEffect.DEFAULT_DESCRIPTION;
    private List<String> category = CustomEffect.DEFAULT_CATEGORY;
    private String image = CustomEffect.DEFAULT_IMAGE;
    private CustomEffectDuration duration = CustomEffect.DEFAULT_DURATION;
    private CustomEffectQuantity quantity = CustomEffect.DEFAULT_QUANTITY;
    private Map<String, CustomEffectParameter> parameters = CustomEffect.DEFAULT_PARAMETERS;
    private Double sessionCooldown = CustomEffect.DEFAULT_SESSIONCOOLDOWN;
    private Double userCooldown = CustomEffect.DEFAULT_USERCOOLDOWN;
    private Boolean inactive = CustomEffect.DEFAULT_INACTIVE;

    private CustomEffectBuilder() {
    }

    private CustomEffectBuilder(@NotNull CCName name, int price, @Nullable String description, @Nullable List<String> category, @Nullable String image, @Nullable CustomEffectDuration duration, @Nullable CustomEffectQuantity quantity, @Nullable Map<String, CustomEffectParameter> parameters, @Nullable Double sessionCooldown, @Nullable Double userCooldown, @Nullable Boolean inactive) {
        this.name = name;
        this.price = price;
        this.description = description;
        this.category = category;
        this.image = image;
        this.duration = duration;
        this.quantity = quantity;
        this.parameters = parameters;
        this.sessionCooldown = sessionCooldown;
        this.userCooldown = userCooldown;
        this.inactive = inactive;
    }

    public static NameStage builder() {
        CustomEffectBuilder r = new CustomEffectBuilder();
        return name -> {
            r.name(name);
            return price -> {
                r.price(price);
                return () -> r;
            };
        };
    }

    public static CustomEffect CustomEffect(@NotNull CCName name, int price, @Nullable String description, @Nullable List<String> category, @Nullable String image, @Nullable CustomEffectDuration duration, @Nullable CustomEffectQuantity quantity, @Nullable Map<String, CustomEffectParameter> parameters, @Nullable Double sessionCooldown, @Nullable Double userCooldown, @Nullable Boolean inactive) {
        return new CustomEffect(name, price, description, category, image, duration, quantity, parameters, sessionCooldown, userCooldown, inactive);
    }

    public static CustomEffectBuilder builder(CustomEffect from) {
        return new CustomEffectBuilder(from.name(), from.price(), from.description(), from.category(), from.image(), from.duration(), from.quantity(), from.parameters(), from.sessionCooldown(), from.userCooldown(), from.inactive());
    }

    public static With from(CustomEffect from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(CustomEffect record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, CCName>("name", record.name()), new AbstractMap.SimpleImmutableEntry<String, Integer>("price", record.price()), new AbstractMap.SimpleImmutableEntry<String, String>("description", record.description()), new AbstractMap.SimpleImmutableEntry<String, List<String>>("category", record.category()), new AbstractMap.SimpleImmutableEntry<String, String>("image", record.image()), new AbstractMap.SimpleImmutableEntry<String, CustomEffectDuration>("duration", record.duration()), new AbstractMap.SimpleImmutableEntry<String, CustomEffectQuantity>("quantity", record.quantity()), new AbstractMap.SimpleImmutableEntry<String, Map<String, CustomEffectParameter>>("parameters", record.parameters()), new AbstractMap.SimpleImmutableEntry<String, Double>("sessionCooldown", record.sessionCooldown()), new AbstractMap.SimpleImmutableEntry<String, Double>("userCooldown", record.userCooldown()), new AbstractMap.SimpleImmutableEntry<String, Boolean>("inactive", record.inactive()));
    }

    public CustomEffect build() {
        return new CustomEffect(this.name, this.price, this.description, this.category, this.image, this.duration, this.quantity, this.parameters, this.sessionCooldown, this.userCooldown, this.inactive);
    }

    public String toString() {
        return "CustomEffectBuilder[name=" + String.valueOf(this.name) + ", price=" + this.price + ", description=" + this.description + ", category=" + String.valueOf(this.category) + ", image=" + this.image + ", duration=" + String.valueOf(this.duration) + ", quantity=" + String.valueOf(this.quantity) + ", parameters=" + String.valueOf(this.parameters) + ", sessionCooldown=" + this.sessionCooldown + ", userCooldown=" + this.userCooldown + ", inactive=" + this.inactive + "]";
    }

    public int hashCode() {
        return Objects.hash(this.name, this.price, this.description, this.category, this.image, this.duration, this.quantity, this.parameters, this.sessionCooldown, this.userCooldown, this.inactive);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof CustomEffectBuilder)) return false;
        CustomEffectBuilder r = (CustomEffectBuilder)o;
        if (!Objects.equals(this.name, r.name)) return false;
        if (this.price != r.price) return false;
        if (!Objects.equals(this.description, r.description)) return false;
        if (!Objects.equals(this.category, r.category)) return false;
        if (!Objects.equals(this.image, r.image)) return false;
        if (!Objects.equals(this.duration, r.duration)) return false;
        if (!Objects.equals(this.quantity, r.quantity)) return false;
        if (!Objects.equals(this.parameters, r.parameters)) return false;
        if (!Objects.equals(this.sessionCooldown, r.sessionCooldown)) return false;
        if (!Objects.equals(this.userCooldown, r.userCooldown)) return false;
        if (!Objects.equals(this.inactive, r.inactive)) return false;
        return true;
    }

    public CustomEffectBuilder name(@NotNull CCName name) {
        this.name = name;
        return this;
    }

    @NotNull
    public CCName name() {
        return this.name;
    }

    public CustomEffectBuilder price(int price) {
        this.price = price;
        return this;
    }

    public int price() {
        return this.price;
    }

    public CustomEffectBuilder description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public CustomEffectBuilder category(@Nullable List<String> category) {
        this.category = category;
        return this;
    }

    @Nullable
    public List<String> category() {
        return this.category;
    }

    public CustomEffectBuilder image(@Nullable String image) {
        this.image = image;
        return this;
    }

    @Nullable
    public String image() {
        return this.image;
    }

    public CustomEffectBuilder duration(@Nullable CustomEffectDuration duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    public CustomEffectDuration duration() {
        return this.duration;
    }

    public CustomEffectBuilder quantity(@Nullable CustomEffectQuantity quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    public CustomEffectQuantity quantity() {
        return this.quantity;
    }

    public CustomEffectBuilder parameters(@Nullable Map<String, CustomEffectParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    @Nullable
    public Map<String, CustomEffectParameter> parameters() {
        return this.parameters;
    }

    public CustomEffectBuilder sessionCooldown(@Nullable Double sessionCooldown) {
        this.sessionCooldown = sessionCooldown;
        return this;
    }

    @Nullable
    public Double sessionCooldown() {
        return this.sessionCooldown;
    }

    public CustomEffectBuilder userCooldown(@Nullable Double userCooldown) {
        this.userCooldown = userCooldown;
        return this;
    }

    @Nullable
    public Double userCooldown() {
        return this.userCooldown;
    }

    public CustomEffectBuilder inactive(@Nullable Boolean inactive) {
        this.inactive = inactive;
        return this;
    }

    @Nullable
    public Boolean inactive() {
        return this.inactive;
    }

    public static interface NameStage {
        public PriceStage name(@NotNull CCName var1);
    }

    private static final class _FromWith
    implements With {
        private final CustomEffect from;

        private _FromWith(CustomEffect from) {
            this.from = from;
        }

        @Override
        public CCName name() {
            return this.from.name();
        }

        @Override
        public int price() {
            return this.from.price();
        }

        @Override
        public String description() {
            return this.from.description();
        }

        @Override
        public List<String> category() {
            return this.from.category();
        }

        @Override
        public String image() {
            return this.from.image();
        }

        @Override
        public CustomEffectDuration duration() {
            return this.from.duration();
        }

        @Override
        public CustomEffectQuantity quantity() {
            return this.from.quantity();
        }

        @Override
        public Map<String, CustomEffectParameter> parameters() {
            return this.from.parameters();
        }

        @Override
        public Double sessionCooldown() {
            return this.from.sessionCooldown();
        }

        @Override
        public Double userCooldown() {
            return this.from.userCooldown();
        }

        @Override
        public Boolean inactive() {
            return this.from.inactive();
        }
    }

    public static interface PriceStage {
        public CustomEffectBuilderStage price(int var1);
    }

    public static interface CustomEffectBuilderStage {
        default public CustomEffect build() {
            return this.builder().build();
        }

        default public CustomEffectBuilder description(@Nullable String description) {
            return this.builder().description(description);
        }

        default public CustomEffectBuilder category(@Nullable List<String> category) {
            return this.builder().category(category);
        }

        default public CustomEffectBuilder image(@Nullable String image) {
            return this.builder().image(image);
        }

        default public CustomEffectBuilder duration(@Nullable CustomEffectDuration duration) {
            return this.builder().duration(duration);
        }

        default public CustomEffectBuilder quantity(@Nullable CustomEffectQuantity quantity) {
            return this.builder().quantity(quantity);
        }

        default public CustomEffectBuilder parameters(@Nullable Map<String, CustomEffectParameter> parameters) {
            return this.builder().parameters(parameters);
        }

        default public CustomEffectBuilder sessionCooldown(@Nullable Double sessionCooldown) {
            return this.builder().sessionCooldown(sessionCooldown);
        }

        default public CustomEffectBuilder userCooldown(@Nullable Double userCooldown) {
            return this.builder().userCooldown(userCooldown);
        }

        default public CustomEffectBuilder inactive(@Nullable Boolean inactive) {
            return this.builder().inactive(inactive);
        }

        public CustomEffectBuilder builder();
    }

    public static interface With {
        @NotNull
        public CCName name();

        public int price();

        @Nullable
        public String description();

        @Nullable
        public List<String> category();

        @Nullable
        public String image();

        @Nullable
        public CustomEffectDuration duration();

        @Nullable
        public CustomEffectQuantity quantity();

        @Nullable
        public Map<String, CustomEffectParameter> parameters();

        @Nullable
        public Double sessionCooldown();

        @Nullable
        public Double userCooldown();

        @Nullable
        public Boolean inactive();

        default public CustomEffectBuilder with() {
            return new CustomEffectBuilder(this.name(), this.price(), this.description(), this.category(), this.image(), this.duration(), this.quantity(), this.parameters(), this.sessionCooldown(), this.userCooldown(), this.inactive());
        }

        default public CustomEffect with(Consumer<CustomEffectBuilder> consumer) {
            CustomEffectBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public CustomEffect withName(@NotNull CCName name) {
            return new CustomEffect(name, this.price(), this.description(), this.category(), this.image(), this.duration(), this.quantity(), this.parameters(), this.sessionCooldown(), this.userCooldown(), this.inactive());
        }

        default public CustomEffect withPrice(int price) {
            return new CustomEffect(this.name(), price, this.description(), this.category(), this.image(), this.duration(), this.quantity(), this.parameters(), this.sessionCooldown(), this.userCooldown(), this.inactive());
        }

        default public CustomEffect withDescription(@Nullable String description) {
            return new CustomEffect(this.name(), this.price(), description, this.category(), this.image(), this.duration(), this.quantity(), this.parameters(), this.sessionCooldown(), this.userCooldown(), this.inactive());
        }

        default public CustomEffect withCategory(@Nullable List<String> category) {
            return new CustomEffect(this.name(), this.price(), this.description(), category, this.image(), this.duration(), this.quantity(), this.parameters(), this.sessionCooldown(), this.userCooldown(), this.inactive());
        }

        default public CustomEffect withImage(@Nullable String image) {
            return new CustomEffect(this.name(), this.price(), this.description(), this.category(), image, this.duration(), this.quantity(), this.parameters(), this.sessionCooldown(), this.userCooldown(), this.inactive());
        }

        default public CustomEffect withDuration(@Nullable CustomEffectDuration duration) {
            return new CustomEffect(this.name(), this.price(), this.description(), this.category(), this.image(), duration, this.quantity(), this.parameters(), this.sessionCooldown(), this.userCooldown(), this.inactive());
        }

        default public CustomEffect withQuantity(@Nullable CustomEffectQuantity quantity) {
            return new CustomEffect(this.name(), this.price(), this.description(), this.category(), this.image(), this.duration(), quantity, this.parameters(), this.sessionCooldown(), this.userCooldown(), this.inactive());
        }

        default public CustomEffect withParameters(@Nullable Map<String, CustomEffectParameter> parameters) {
            return new CustomEffect(this.name(), this.price(), this.description(), this.category(), this.image(), this.duration(), this.quantity(), parameters, this.sessionCooldown(), this.userCooldown(), this.inactive());
        }

        default public CustomEffect withSessionCooldown(@Nullable Double sessionCooldown) {
            return new CustomEffect(this.name(), this.price(), this.description(), this.category(), this.image(), this.duration(), this.quantity(), this.parameters(), sessionCooldown, this.userCooldown(), this.inactive());
        }

        default public CustomEffect withUserCooldown(@Nullable Double userCooldown) {
            return new CustomEffect(this.name(), this.price(), this.description(), this.category(), this.image(), this.duration(), this.quantity(), this.parameters(), this.sessionCooldown(), userCooldown, this.inactive());
        }

        default public CustomEffect withInactive(@Nullable Boolean inactive) {
            return new CustomEffect(this.name(), this.price(), this.description(), this.category(), this.image(), this.duration(), this.quantity(), this.parameters(), this.sessionCooldown(), this.userCooldown(), inactive);
        }
    }
}

