/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.websocket.payload;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import live.crowdcontrol.cc4j.websocket.payload.CCEffectDescription;
import live.crowdcontrol.cc4j.websocket.payload.CCUserRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicEffectPayload {
    @NotNull
    protected final UUID requestID;
    protected final long timestamp;
    @NotNull
    protected final CCEffectDescription effect;
    @NotNull
    protected final CCUserRecord target;
    @Nullable
    protected final CCUserRecord origin;
    @Nullable
    protected final CCUserRecord requester;
    protected final boolean anonymous;
    protected final int quantity;
    protected final long localTimestamp = System.currentTimeMillis();

    public PublicEffectPayload(@JsonProperty(value="requestID") @NotNull UUID requestID, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="effect") @NotNull CCEffectDescription effect, @JsonProperty(value="target") @NotNull CCUserRecord target, @JsonProperty(value="origin") @Nullable CCUserRecord origin, @JsonProperty(value="requester") @Nullable CCUserRecord requester, @JsonProperty(value="anonymous") boolean anonymous, @JsonProperty(value="quantity") int quantity) {
        this.requestID = requestID;
        this.timestamp = timestamp;
        this.effect = effect;
        this.target = target;
        this.origin = origin;
        this.requester = requester;
        this.anonymous = anonymous;
        this.quantity = Math.max(1, quantity);
    }

    @JsonProperty(value="requestID")
    @NotNull
    public UUID getRequestId() {
        return this.requestID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public CCEffectDescription getEffect() {
        return this.effect;
    }

    @NotNull
    public CCUserRecord getTarget() {
        return this.target;
    }

    @Nullable
    public CCUserRecord getOrigin() {
        return this.origin;
    }

    @Nullable
    public CCUserRecord getRequester() {
        return this.requester;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public long getLocalTimestamp() {
        return this.localTimestamp;
    }

    public String toString() {
        return "PublicEffectPayload{requestID=" + String.valueOf(this.requestID) + ", timestamp=" + this.timestamp + ", effect=" + String.valueOf(this.effect) + ", target=" + String.valueOf(this.target) + ", origin=" + String.valueOf(this.origin) + ", requester=" + String.valueOf(this.requester) + ", anonymous=" + this.anonymous + ", quantity=" + this.quantity + ", localTimestamp=" + this.localTimestamp + "}";
    }
}

