CrowdControl = CrowdControl or {}

CrowdControl.interval = 15
CrowdControl.timer = CrowdControl.interval

CrowdControl.isReady = function()
    if getPlayer():getBodyDamage():getOverallBodyHealth() == 0 then return false end
    if isGamePaused() then return false end
    if isIngameState() == false then return false end
    return true
end

local function OnPostRender()
    local ready = CrowdControl.isReady()

    CrowdControl.timer = CrowdControl.timer - 1
    if CrowdControl.timer == 0 then
        CrowdControl.timer = CrowdControl.interval
        if ready then
            CrowdControl.RunEffects()
            CrowdControl.RunTimed()
        else
            CrowdControl.DelayEffects()
            CrowdControl.DelayTimed()
        end
    end
    if ready then CrowdControl.ExecTimed() end
end

function GameStart()
    print("Crowd Control starting...")
    getPlayer():Say("Crowd Control starting...")
end

local function OnMouseDown(x, y)
    local info = getModInfoByID("CrowdControl")
    if info~=nil then
        --getPlayer():Say(info:getDir())
    end    


end

local function OnServerCommand(module, command, arguments)
end

CrowdControl.DoEffect = function(n)
    getPlayer():Say("Effect received: " .. n)
end

local function OnModsModified()
	getPlayer():Say("Files updated")

    local info = getModInfoById("CrowdControl")
    if info then
        getPlayer():Say(info:getDir())
    end
end



Events.OnPostRender.Add(OnPostRender)
Events.OnModsModified.Add(OnModsModified)
Events.OnServerCommand.Add(OnServerCommand)
Events.OnMouseDown.Add(OnMouseDown)
Events.OnGameStart.Add(GameStart)
