
function cc_pistoldrop()
    local player = getPlayer()
    local items = getScriptManager():getAllItems()
    local category, type, item

    local case = InventoryItemFactory.CreateItem("Base.PistolCase1", 1, true)
    case:setName(CrowdControl.viewer .. "'s pistol drop")

    local guns = { "Pistol", "Pistol2", "Pistol3", "Revolver", "Revolver_Short" }
    local choice = guns[ZombRand(1, 6)]
    if CrowdControl.viewer == "jaku" or CrowdControl.viewer == "crowdcontrol"
            or CrowdControl.viewer  == "blippop" or CrowdControl.viewer == "dtothefourth" then
        choice = "Revolver_Long"
    end
    local gun = InventoryItemFactory.CreateItem("Base." .. choice, 1, true)
    local name = gun:getDisplayName()

    gun:setName(CrowdControl.viewer .. "'s " .. name)
    gun:setClipSize(30)
    gun:setCurrentAmmoCount(30)
    gun:setRoundChambered(true)
    gun:setMinDamage(gun:getMinDamage()*3)
    gun:setMaxDamage(gun:getMaxDamage()*3)
    case:getItemContainer():AddItem(gun)

    local square = player:getSquare()
    local objects = square:getObjects()
    local size = objects:size()
    if size > 1 then return false end

    square:AddWorldInventoryItem(case, 0.5, 0.5, 0)

    player:playSoundLocal("stormy9mmClick")
    player:Say(CrowdControl.viewer .. " spawned a pistol drop!")
end

function spawn_item_in_case(choice, sfxName) 
        local player = getPlayer()
   
        local weapon = InventoryItemFactory.CreateItem("Base." .. choice, 1, true)
        local square = player:getSquare()
        local objects = square:getObjects()
        local size = objects:size()
        if size > 1 then return false end

        square:AddWorldInventoryItem(weapon, 0.5, 0.5, 0)
        player:playSoundLocal("batSwing")
        player:Say(CrowdControl.viewer .. " gave you a " .. choice .." drop!")
        return true
end

function spawn_item_in_case(choice, sfxName) 
    local player = getPlayer()

    local case = InventoryItemFactory.CreateItem("Base.Guitarcase", 1, true)
    case:setName(CrowdControl.viewer .. "'s ".. choice .. " drop")

    local weapon = InventoryItemFactory.CreateItem("Base." .. choice, 1, true)
    local name = weapon:getDisplayName()

    case:getItemContainer():AddItem(weapon)

    local square = player:getSquare()
    local objects = square:getObjects()
    local size = objects:size()
    if size > 1 then return false end

    square:AddWorldInventoryItem(case, 0.5, 0.5, 0)

    player:playSoundLocal(sfxName)
    player:Say(CrowdControl.viewer .. " gave you a " .. choice .." drop!")
    return true
end




function cc_shotgundrop()
    local player = getPlayer()
    local items = getScriptManager():getAllItems()
    local category, type, item

    local case = InventoryItemFactory.CreateItem("Base.Flightcase", 1, true)
    case:setName(CrowdControl.viewer .. "'s shotgun drop")

    local guns = { "DoubleBarrelShotgun", "Shotgun", "DoubleBarrelShotgunSawnoff", "ShotgunSawnoff" }
    local choice = guns[ZombRand(1, 5)]
    local gun = InventoryItemFactory.CreateItem("Base." .. choice, 1, true)
    local name = gun:getDisplayName()

    gun:setName(CrowdControl.viewer .. "'s " .. name)
    gun:setClipSize(20)
    gun:setCurrentAmmoCount(20)
    gun:setRoundChambered(true)
    gun:setMinDamage(gun:getMinDamage()*3)
    gun:setMaxDamage(gun:getMaxDamage()*3)
    case:getItemContainer():AddItem(gun)

    local square = player:getSquare()
    local objects = square:getObjects()
    local size = objects:size()
    if size > 1 then return false end

    square:AddWorldInventoryItem(case, 0.5, 0.5, 0)

    player:playSoundLocal("stormyShotgunPump")
    player:Say(CrowdControl.viewer .. " spawned a shotgun drop!")
end



function cc_rifledrop()
    local player = getPlayer()
    local items = getScriptManager():getAllItems()
    local category, type, item

    local case = InventoryItemFactory.CreateItem("Base.Guitarcase", 1, true)
    case:setName(CrowdControl.viewer .. "'s rifle drop")

    local guns = { "HuntingRifle", "VarmintRifle", "AssaultRifle2" }
    local choice = guns[ZombRand(1, 4)]
    if CrowdControl.viewer == "jaku" or CrowdControl.viewer == "crowdcontrol"
            or CrowdControl.viewer  == "blippop" or CrowdControl.viewer == "dtothefourth" then
        choice = "AssaultRifle"
    end
    local gun = InventoryItemFactory.CreateItem("Base." .. choice, 1, true)
    local name = gun:getDisplayName()

    gun:setName(CrowdControl.viewer .. "'s " .. name)
    gun:setClipSize(60)
    gun:setCurrentAmmoCount(60)
    gun:setRoundChambered(true)
    gun:setMinDamage(gun:getMinDamage()*3)
    gun:setMaxDamage(gun:getMaxDamage()*3)
    case:getItemContainer():AddItem(gun)

    local square = player:getSquare()
    local objects = square:getObjects()
    local size = objects:size()
    if size > 1 then return false end

    square:AddWorldInventoryItem(case, 0.5, 0.5, 0)

    player:playSoundLocal("stormyRifleCock")
    player:Say(CrowdControl.viewer .. " spawned a rifle drop!")
end


function cc_sportsmelee()
    local weapons = { "BadmintonRacket", "FishingRod", "CraftedFishingRod", "FishingRodBreak", "HockeyStick", "IceHockeyStick", "LaCrosseStick", "Poolcue", "BaseballBat", "BaseballBatNails", "TennisRacket" }
    local weapon = weapons[ZombRand(1, #weapons + 1)]
    local result = spawn_item_in_case(weapon, 'batSwing')
    return result
end

function cc_shortblunt()
    local weapons = { "BallPeenHammer", "ChairLeg", "ClubHammer", "DumbBell", "Flute", "Hammer", "LeadPipe", "MetalBar", "Mop", "PipeWrench", "Plunger", "Scissors", "Screwdriver", "Spoon", "Toothbrush", "Wrench" }
    local weapon = weapons[ZombRand(1, #weapons + 1)]
    local result = spawn_item_in_case(weapon, 'thump1')
    return result
end

function cc_longblunt()
    local weapons = { "GuitarElectricBassBlack", "GuitarElectricBassBlue", "GuitarElectricBassRed", "GuitarElectricBlack", "GuitarElectricBlue", "GuitarElectricRed", "Keytar", "LeafRake", "Rake", "Saxophone", "Shovel", "SnowShovel", "Trumpet"}       
    local weapon = weapons[ZombRand(1, #weapons + 1)]
    local result = spawn_item_in_case(weapon, 'thumpa1')
    return result
end

function cc_swords()
    local weapons = { "Katana", "Machete" }
    local weapon = weapons[ZombRand(1, #weapons + 1)]
    local result = spawn_item_in_case(weapon, 'batSwing')
    return result
end

function cc_supplydrop()
    local player = getPlayer()
    local items = getScriptManager():getAllItems()
    local category, type, item

    local junk = {}
    for i=0, items:size()-1 do
        item = items:get(i)
        category = item:getDisplayCategory()
        if category == "Junk" then
            type = item:getFullName()
            table.insert(junk, type)
        end
    end

    local food = {}
    for i=0, items:size()-1 do
        item = items:get(i)
        category = item:getDisplayCategory()
        if category == "Food" then
            type = item:getFullName()
            table.insert(food, type)
        end
    end

    local tool = {}
    for i=0, items:size()-1 do
        item = items:get(i)
        category = item:getDisplayCategory()
        if category == "Tool" then
            type = item:getFullName()
            table.insert(tool, type)
        end
    end

    local firstaid = {}
    for i=0, items:size()-1 do
        item = items:get(i)
        category = item:getDisplayCategory()
        if category == "FirstAid" then
            type = item:getFullName()
            table.insert(firstaid, type)
        end
    end

    local bag = InventoryItemFactory.CreateItem("Base.Bag_DuffelBag", 1, true)
    bag:setName(CrowdControl.viewer .. "'s supply drop")
    bag:getItemContainer():AddItems("Base.WaterBottleFull", 2)
    bag:getItemContainer():AddItem(food[ZombRand(1, #food)])
    bag:getItemContainer():AddItem(food[ZombRand(1, #food)])
    bag:getItemContainer():AddItem(food[ZombRand(1, #food)])
    bag:getItemContainer():AddItem("Base.AlcoholBandage")
    bag:getItemContainer():AddItem("Base.AlcoholBandage")
    bag:getItemContainer():AddItem(firstaid[ZombRand(1, #firstaid)])
    bag:getItemContainer():AddItem(firstaid[ZombRand(1, #firstaid)])
    bag:getItemContainer():AddItem(tool[ZombRand(1, #tool)])
    bag:getItemContainer():AddItem(junk[ZombRand(1, #junk)])
    bag:getItemContainer():AddItem("Base.Spoon")

    local square = player:getSquare()
    local objects = square:getObjects()
    local size = objects:size()
    if size > 1 then return false end

    square:AddWorldInventoryItem(bag, 0.5, 0.5, 0)

    player:playSoundLocal("drawCard")
    player:Say(CrowdControl.viewer .. " spawned a supply drop!")
end



function cc_givejunk()
    local player = getPlayer()
    local items = getScriptManager():getAllItems()
    local inventory = player:getInventory()
    local category, type
    local junk = {}
    for i=0, items:size()-1 do
        item = items:get(i)
        category = item:getDisplayCategory()
        if category == "Junk" then
            type = item:getFullName()
            table.insert(junk, type)
        end
    end
    inventory:AddItem(junk[ZombRand(1, #junk)])
    inventory:AddItem(junk[ZombRand(1, #junk)])
    inventory:AddItem(junk[ZombRand(1, #junk)])
    inventory:AddItem(junk[ZombRand(1, #junk)])
    inventory:AddItem(junk[ZombRand(1, #junk)])

    player:playSoundLocal("breakdoor")
    player:Say(CrowdControl.viewer .. " gave me some junk!")
end



function cc_givewater()
    local player = getPlayer()
    local inventory = player:getInventory()
    inventory:AddItem("Base.WaterBottleFull")

    player:playSoundLocal("waterSplash")
    player:Say(CrowdControl.viewer .. " gave me a bottle of water!")
end



function cc_givechicken()
    local player = getPlayer()
    local inventory = player:getInventory()
    inventory:AddItem("Base.ChickenNuggets")

    player:playSoundLocal("batSwing")
    player:Say(CrowdControl.viewer .. " gave me chicken nuggets!")
end



function cc_givedogfood()
    local player = getPlayer()
    local inventory = player:getInventory()
    inventory:AddItem("Base.DogFoodOpen")

    player:playSoundLocal("unlockDoor")
    player:Say(CrowdControl.viewer .. " gave me dog food!")
end



function cc_ohkozombies()
    local player = getPlayer()
    local zombieList = player:getCell():getZombieList()
    local zombie
    local amount = zombieList:size()
    if amount == 0 then return false end

    for i=0, zombieList:size()-1 do
        zombie = zombieList:get(i)
        zombie:setHealth(0.01)
    end

    player:playSoundLocal("zombiehit2")
    player:Say(CrowdControl.viewer .. " weakened " .. amount .. " zombies!")
end



function cc_spawncar()
    local player = getPlayer()
    local outside = player:isOutside()
    if not outside then return false end
    local z = player:getLlz()
    if z ~= 0 then return false end

    local square = player:getSquare()
    local dirs = { IsoDirections.N, IsoDirections.E, IsoDirections.S, IsoDirections.W,
                   IsoDirections.NE, IsoDirections.SE, IsoDirections.NW, IsoDirections.SW }
    local dir = dirs[ZombRand(1, 9)]

    local cars = { "Base.CarNormal", "Base.SmallCar", "Base.CarStationWagon", "Base.OffRoad",
                   "Base.PickUpTruck", "Base.PickUpVan", "Base.SUV", "Base.CarTaxi" }
    local car = cars[ZombRand(1, 9)]

    if CrowdControl.viewer == "jaku" or CrowdControl.viewer == "crowdcontrol" then
        car = "Base.VanSpiffo"
    end
    if CrowdControl.viewer == "blippop" or CrowdControl.viewer == "dtothefourth" then
        car = "Base.SportsCar"
    end

    addVehicleDebug(car, dir, 0,  square)

    player:Say(CrowdControl.viewer .. " spawned a car!")
end



function cc_teleport()
    local player = getPlayer()
    local cell = player:getCell()
    local tile = cell:getRandomOutdoorTile()
    local x = tile:getX()
    local y = tile:getY()
    local z = tile:getZ()

    player:setPosition(x, y, z)
    local messages = { "eep!", "Ah!", "Oh no!", "Yikes!", "D:", "AAAAA!" }
    local choice = messages[ZombRand(1, 7)]

    player:Say(choice)
    player:Say(CrowdControl.viewer .. " teleported me!")
end



function cc_teleportzombies()
    local player = getPlayer()
    local cell = player:getCell()
    local zombieList = cell:getZombieList()
    if zombieList:size() == 0 then return false end
    local zombie, x, y, z, tile

    for i=0, zombieList:size()-1 do
        zombie = zombieList:get(i)
        tile = cell:getRandomOutdoorTile()
        x = tile:getX()
        y = tile:getY()
        z = tile:getZ()
        zombie:setX(x)
        zombie:setY(y)
        zombie:setZ(z)
    end

    player:playSoundLocal("zombiehit1")
    player:Say(CrowdControl.viewer .. " teleported the zombies around!")
end



function cc_smashwindows()
    local player = getPlayer()
    local windowList = player:getCell():getWindowList()
    local window
    local amount = windowList:size()
    if amount == 0 then return false end

    for i=0, windowList:size()-1 do
        window = windowList:get(i)
        window:smashWindow()
    end

    player:playSoundLocal("bottlesmash")
    player:Say(CrowdControl.viewer .. " smashed " .. amount .. " windows!")
end



function cc_fixwindows()
    local player = getPlayer()
    local windowList = player:getCell():getWindowList()
    local window
    local amount = windowList:size()
    if amount == 0 then return false end

    for i=0, windowList:size()-1 do
        window = windowList:get(i)
        window:setSmashed(false)
    end

    player:playSoundLocal("windowclose")
    player:Say(CrowdControl.viewer .. " fixed " .. amount .. " windows!")
end



function cc_fastzombies()
    local player = getPlayer()
    local zombieList = player:getCell():getZombieList()
    local zombie
    local amount = zombieList:size()
    if amount == 0 then return false end

    for i=0, zombieList:size()-1 do
        zombie = zombieList:get(i)
        zombie:setCanWalk(true)
        zombie:setCrawler(false)
        local oldSpeed = getSandboxOptions():getOptionByName("ZombieLore.Speed")
        oldSpeed = oldSpeed:getValue()
        print(oldSpeed)
        getSandboxOptions():set("ZombieLore.Speed", 4)
        zombie:makeInactive(true)
        zombie:makeInactive(false)
        zombie:DoZombieStats()
        getSandboxOptions():set("ZombieLore.Speed",oldSpeed)
    end

    player:playSoundLocal("zombiehit4")
    player:Say(CrowdControl.viewer .. " made " .. amount .. " zombies fast!")
end



function cc_skeletonzombies()
    local player = getPlayer()
    local zombieList = player:getCell():getZombieList()
    local zombie
    local amount = zombieList:size()
    if amount == 0 then return false end

    for i=0, zombieList:size()-1 do
        zombie = zombieList:get(i)
        zombie:setSkeleton(true)
    end

    player:playSoundLocal("crackwood")
    player:Say(CrowdControl.viewer .. " turned " .. amount .. " zombies into skeletons!")
end



function cc_staggerzombies()
    if CrowdControl.TimedEffects["staggerzombies"]~=nil then
        return false
    end

    if CrowdControl.StartTimed("staggerzombies", 2000) then
        local player = getPlayer()
        local zombieList = player:getCell():getZombieList()
        local zombie
        if zombieList:size() == 0 then return false end

        for i=0, zombieList:size()-1 do
            zombie = zombieList:get(i)
            zombie:setStaggerBack(true)
        end

        player:playSoundLocal("zombiehit5")
        player:Say(CrowdControl.viewer .. " is staggering the zombies!")
    end
end

function cc_staggerzombies_update()
    if CrowdControl.staggerWait == 75 then
        CrowdControl.staggerWait = 0
        local player = getPlayer()
        local zombieList = player:getCell():getZombieList()
        local zombie

        for i=0, zombieList:size()-1 do
            zombie = zombieList:get(i)
            zombie:setStaggerBack(true)
        end
    end
    CrowdControl.staggerWait = CrowdControl.staggerWait + 1
end

function cc_staggerzombies_stop()
    CrowdControl.staggerWait = 0
end



function cc_crawlingzombies()
    if CrowdControl.TimedEffects["staggerzombies"]~=nil then
        return false
    end
    
    local player = getPlayer()
    local zombieList = player:getCell():getZombieList()
    local zombie
    local amount = zombieList:size()
    if amount == 0 then return false end

    for i=0, zombieList:size()-1 do
        zombie = zombieList:get(i)
        zombie:setCanWalk(false)
        zombie:setCrawler(true)
    end

    player:playSoundLocal("zombieImpact")
    player:Say(CrowdControl.viewer .. " made all the zombies crawl!")
end



function cc_knockdownzombies()
    if CrowdControl.TimedEffects["staggerzombies"]~=nil then
        return false
    end

    local player = getPlayer()
    local choices = {true, false}
    local choice
    local zombieList = player:getCell():getZombieList()
    local zombie
    local amount = zombieList:size()
    if amount == 0 then return false end

    for i=0, zombieList:size()-1 do
        zombie = zombieList:get(i)
        choice = choices[ZombRand(1, 3)]
        zombie:knockDown(choice)
    end

    player:playSoundLocal("zombiehit5")
    player:Say(CrowdControl.viewer .. " knocked down " .. amount .. " zombies!")
end



function cc_killzombies()
    if CrowdControl.TimedEffects["staggerzombies"]~=nil then
        return false
    end
    
    local player = getPlayer()
    local zombieList = player:getCell():getZombieList()
    local amount = zombieList:size()
    local zombie
    if amount == 0 then return false end
    for i=0, zombieList:size()-1 do
        zombie = zombieList:get(i)
        zombie:Kill(player, true)
    end

    player:Say(CrowdControl.viewer .. " killed " .. amount .. " zombies!")
end



function cc_glass()
    local player = getPlayer()
    local z = player:getLlz()
    if z ~= 0 then return false end
    local square = player:getSquare()
    local chance

    for startingNorth = 1, 5 do
        square = square:getAdjacentSquare(IsoDirections.N)
    end
    for startingWest = 1, 5 do
        square = square:getAdjacentSquare(IsoDirections.W)
    end

    local dirs = { IsoDirections.N, IsoDirections.E, IsoDirections.S, IsoDirections.W }
    local long = { 2, 4, 2, 3, 1, 3, 4, 2, 4, 1, 3, 1 }
    local short = { 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 1 }

    for i = 1, 12 do
        for j = 1, 9 do
            chance = ZombRand(1, 16)
            if chance <= 5 then
                square:addBrokenGlass()
            end
            square = square:getAdjacentSquare(dirs[long[i]])
        end
        square = square:getAdjacentSquare(dirs[short[i]])
    end

    local shoes = player:getClothingItem_Feet()
    if shoes ~= nil then
        player:removeWornItem(shoes, true)
    end

    player:playSoundLocal("BrokenGlass")
    player:Say(CrowdControl.viewer .. " scattered broken glass!")
end



function cc_jumpscare()
    local player = getPlayer()
    local x = player:getX()
    local y = player:getY()
    local z = player:getZ()
    local square = player:getSquare()

    getSoundManager():PlayWorldSound("ZombieSurprisedPlayer", square, 0, 5, 5, false);
    addSound(player, x, y, z, 150, 50);

    local messages = { "eep!", "Ah!", "Oh no!", "Yikes!", "D:", "AAAAA!" }
    local choice = messages[ZombRand(1, 7)]
    player:setCanShout(true)
    player:SayShout(choice)
    player:Say(CrowdControl.viewer .. " jumpscared me!")
end



function cc_fire()
    local player = getPlayer()
    local z = player:getLlz()
    if z ~= 0 then return false end
    local dir = player:getForwardDirection()
    local isoDir = IsoDirections.fromAngle(dir)
    local tile = getPlayer():getCurrentSquare()
    for i = 1, ZombRand(4, 6) do
        tile = tile:getAdjacentSquare(isoDir)
    end
    tile:explode()

    player:playSoundLocal("explode1")
    player:Say(CrowdControl.viewer .. " set a fire!")
end



function cc_helicopter()
    if CrowdControl.TimedEffects["helicopter"]~=nil then
        return false
    end

    if CrowdControl.StartTimed("helicopter", 2000) then
        local player = getPlayer()
        testHelicopter()

        player:Say(CrowdControl.viewer .. " sent a helicopter!")
    end
end

function cc_helicopter_stop()
    endHelicopter()
end



function cc_spawnzombie()
    local player = getPlayer()
    local x = player:getLlx()
    local y = player:getLly()
    local z = player:getLlz()

    local dir = player:getForwardDirection()
    local dirX = dir:getX()
    local dirY = dir:getY()

    local distanceOffset = ZombRand(2, 6)

    x = x + (dirX * distanceOffset)
    y = y + (dirY * distanceOffset)

    local outfits = {"Biker", "Nurse", "Farmer", "Chef", "Punk", "Doctor", "Golfer", "Bathrobe",
                     "Student", "Tourist", "Cyclist", "Party", "Varsity", "Naked", "Rocker", "Ranger", "Classy"}
    local choice = outfits[ZombRand(1, 18)]
    local gender = 50
    local unique = false

    if CrowdControl.viewer == "jaku" then
        choice = "Spiffo"
        gender = 0
        unique = true
    elseif CrowdControl.viewer == "crowdcontrol" then
        choice = "TinFoilHat"
        gender = 50
        unique = true
    elseif CrowdControl.viewer == "blippop" then
        choice = "StripperBlack"
        gender = 100
        unique = true
    elseif CrowdControl.viewer == "dtothefourth" then
        choice = "StripperPink"
        gender = 100
        unique = true
    end

    addZombiesInOutfit(x, y, 0, 1, choice, gender)
    if unique then
        player:Say(CrowdControl.viewer .. " spawned a unique zombie!")
    else
        player:Say(CrowdControl.viewer .. " spawned a " .. choice .. " zombie!")
    end
end



function cc_spawnsmallhorde()
    local player = getPlayer()
    local x = player:getLlx()
    local y = player:getLly()
    local z = player:getLlz()

    local dir = player:getForwardDirection()
    local dirX = dir:getX()
    local dirY = dir:getY()

    local distanceOffset = ZombRand(15, 25)
    local amount = ZombRand(10, 15)

    local outfits = {"Biker", "Nurse", "Farmer", "Chef", "Punk", "Doctor", "Golfer", "Bathrobe",
                     "Student", "Tourist", "Cyclist", "Party", "Varsity", "Naked", "Rocker",
                     "Ranger", "Classy", "Bandit", "test"}
    local choice = outfits[ZombRand(1, 20)]
    choice = "Bandit"
    local gender = 50
    local unique = false

    if CrowdControl.viewer == "jaku" then
        choice = "Spiffo"
        gender = 0
        unique = true
    elseif CrowdControl.viewer == "crowdcontrol" then
        choice = "TinFoilHat"
        gender = 50
        unique = true
    elseif CrowdControl.viewer == "blippop" then
        choice = "StripperBlack"
        gender = 100
        unique = true
    elseif CrowdControl.viewer == "dtothefourth" then
        choice = "StripperPink"
        gender = 100
        unique = true
    end

    for i = 1, amount do
        addZombiesInOutfit(x + dirX*distanceOffset, y + dirY*distanceOffset, 0, 1, choice, gender)
    end

    local zombieList = player:getCell():getZombieList()
    local zombie, outfit
    for i=0, zombieList:size()-1 do
        zombie = zombieList:get(i)
        outfit = tostring(zombie:getOutfitName())
        if outfit == choice then
            zombie:pathToLocation(x, y, z)
        end
        if outfit == "test" then
            zombie:dressInNamedOutfit("Naked")
            zombie:setSkeleton(true)
        end
    end

    if choice == "test" then choice = "skeleton" end
    if unique then choice = "unique" end
    player:Say(CrowdControl.viewer .. " spawned a horde of " .. amount .. " " .. choice .. " zombies!")
end



function cc_spawnlargehorde()
    local player = getPlayer()
    local x = player:getLlx()
    local y = player:getLly()
    local z = player:getLlz()

    local dir = player:getForwardDirection()
    local dirX = dir:getX()
    local dirY = dir:getY()

    local distanceOffset = ZombRand(25, 35)
    local amount = ZombRand(60, 80)

    local outfits = {"Biker", "Nurse", "Farmer", "Chef", "Punk", "Doctor", "Golfer", "Bathrobe",
                     "Student", "Tourist", "Cyclist", "Party", "Varsity", "Naked", "Rocker",
                     "Ranger", "Classy", "Bandit", "test"}
    local choice = outfits[ZombRand(1, 20)]
    local gender = 50
    local unique = false

    if CrowdControl.viewer == "jaku" then
        choice = "Spiffo"
        gender = 0
        unique = true
    elseif CrowdControl.viewer == "crowdcontrol" then
        choice = "TinFoilHat"
        gender = 50
        unique = true
    elseif CrowdControl.viewer == "blippop" then
        choice = "StripperBlack"
        gender = 100
        unique = true
    elseif CrowdControl.viewer == "dtothefourth" then
        choice = "StripperPink"
        gender = 100
        unique = true
    end

    for i = 1, amount do
        addZombiesInOutfit(x + dirX*distanceOffset, y + dirY*distanceOffset, 0, 1, choice, gender)
    end

    local zombieList = player:getCell():getZombieList()
    local zombie, outfit
    for i=0, zombieList:size()-1 do
        zombie = zombieList:get(i)
        outfit = tostring(zombie:getOutfitName())
        if outfit == choice then
            zombie:pathToLocation(x, y, z)
        end
        if outfit == "test" then
            zombie:dressInNamedOutfit("Naked")
            zombie:setSkeleton(true)
        end
    end

    if choice == "test" then choice = "skeleton" end
    if unique then choice = "unique" end
    player:Say(CrowdControl.viewer .. " spawned a horde of " .. amount .. " " .. choice .. " zombies!")
end



function cc_killplayer()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["noclip"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["ghostmode"]~=nil then
        return false
    end

    local player = getPlayer()
    player:Say(CrowdControl.viewer .. " killed me!")
    getPlayer():setHealth(0)
end



function cc_fullheal()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end

    if CrowdControl.StartTimed("fullheal", 2000) then
        local player = getPlayer()
        player:Say(CrowdControl.viewer .. " fully healed me!")
        player:setGodMod(true)
    end
end

function cc_fullheal_stop()
    getPlayer():setGodMod(false)
end



function cc_godmode()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    if CrowdControl.StartTimed("godmode", 2000) then
        local player = getPlayer()
        player:Say(CrowdControl.viewer .. " made me invincible!")
        player:setGodMod(true)
    end
end

function cc_godmode_stop()
    getPlayer():setGodMod(false)
end



function cc_ghostmode()
    if CrowdControl.TimedEffects["ghostmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    if CrowdControl.StartTimed("ghostmode", 2000) then
        local player = getPlayer()
        player:Say(CrowdControl.viewer .. " activated ghost mode!")
        player:setGhostMode(true)
    end
end

function cc_ghostmode_stop()
    local player = getPlayer()
    player:setGhostMode(false)
    player:Say("Ghost mode has ended!")
end



function cc_healbodypart()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local hp, bodyPart
    local bodyPartsList = player:getBodyDamage():getBodyParts()
    for i = 0, bodyPartsList:size()-1 do
        bodyPart = bodyPartsList:get(i)
        hp = bodyPart:getHealth()
        if hp <= 95 then
            bodyPart:SetHealth(100)
            player:playSoundLocal("PZ_DuctTape")
            player:Say("placeholder healed my " .. CrowdControl.bodyPartsArr[tostring(bodyPart:getType())])
            return end
    end
    return false
end



function cc_damagebodypart()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local hp = player:getBodyDamage():getOverallBodyHealth()
    if hp <= 20 then return false end

    local hp, bodyPart, j
    local bodyPartsList = player:getBodyDamage():getBodyParts()
        bodyPart = bodyPartsList:get(ZombRand(16))
        hp = bodyPart:getHealth()
        if hp >= 20 then
            bodyPart:AddDamage(ZombRand(20, 25))
            player:playSoundLocal("Unstuckkitchenknife")
            player:Say("placeholder damaged my " .. CrowdControl.bodyPartsArr[tostring(bodyPart:getType())])
            return
        end
    return false
end



function cc_breakaleg()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local bodyPartsList, leg, fracture
    local order = {11, 12, 13, 14}
    for i = #order, 2, -1 do
        local j = ZombRand(1, i)
        order[i], order[j] = order[j], order[i]
    end
    for i = 1, 4 do
        bodyPartsList = player:getBodyDamage():getBodyParts()
        leg = bodyPartsList:get(order[i])
        fracture = leg:getFractureTime()
        if fracture == 0 then
            leg:setFractureTime(0.1)
            player:playSoundLocal("sledgehammer")
            player:Say(CrowdControl.viewer .. " broke my leg!")
            return
        end
    end
    return false
end



function cc_unbreakaleg()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local bodyPartsList, leg, fracture
    local order = {11, 12, 13, 14}
    for i = #order, 2, -1 do
        local j = ZombRand(1, i)
        order[i], order[j] = order[j], order[i]
    end
    for i = 1, 4 do
        bodyPartsList = player:getBodyDamage():getBodyParts()
        leg = bodyPartsList:get(order[i])
        fracture = leg:getFractureTime()
        if fracture ~= 0 then
            leg:setFractureTime(0)
            player:playSoundLocal("PZ_DuctTape")
            player:Say(CrowdControl.viewer .. " un-broke my leg!")
            return
        end
    end
    return false
end



function cc_bite()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local bodyPartsList, part, biteTime
    local order = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}
    for i = #order, 2, -1 do
        local j = ZombRand(1, i)
        order[i], order[j] = order[j], order[i]
    end
    for i = 1, 17 do
        bodyPartsList = player:getBodyDamage():getBodyParts()
        part = bodyPartsList:get(order[i])
        biteTime = part:getBiteTime()
        if biteTime <= 0 then
            part:setBiteTime(0.05)
            part:setBleedingTime(0.05)
            part:SetBitten(true, false)
            player:playSoundLocal("zombiebite")
            player:Say(CrowdControl.viewer .. " bit my " .. CrowdControl.bodyPartsArr[tostring(part:getType())] .. "!")
            return
        end
    end
    return false
end



function cc_cut()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local bodyPartsList, part, cutTime
    local order = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}
    for i = #order, 2, -1 do
        local j = ZombRand(1, i)
        order[i], order[j] = order[j], order[i]
    end
    for i = 1, 17 do
        bodyPartsList = player:getBodyDamage():getBodyParts()
        part = bodyPartsList:get(order[i])
        cutTime = part:getCutTime()
        if cutTime == 0 then
            part:setCut(true, true)
            part:setCutTime(0.05)
            part:setBleedingTime(0.05)
            player:playSoundLocal("PZ_FoodSwoosh")
            player:Say(CrowdControl.viewer .. " cut my " .. CrowdControl.bodyPartsArr[tostring(part:getType())] .. "!")
            return
        end
    end
    return false
end



function cc_burn()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local bodyPartsList, part, burnTime
    local order = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}
    for i = #order, 2, -1 do
        local j = ZombRand(1, i)
        order[i], order[j] = order[j], order[i]
    end
    for i = 1, 17 do
        bodyPartsList = player:getBodyDamage():getBodyParts()
        part = bodyPartsList:get(order[i])
        burnTime = part:getBurnTime()
        if burnTime == 0 then
            part:setBurnTime(0.005)
            player:playSoundLocal("explode1")
            player:Say(CrowdControl.viewer .. " burned my " .. CrowdControl.bodyPartsArr[tostring(part:getType())] .. "!")
            return
        end
    end
    return false
end



function cc_healbites()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local bodyPartsList, part, biteTime
    local check = false
    for i = 0, 16 do
        bodyPartsList = player:getBodyDamage():getBodyParts()
        part = bodyPartsList:get(i)
        biteTime = part:getBiteTime()
        if biteTime > 0 then
            part:setBiteTime(0)
            part:setBleedingTime(0)
            part:SetBitten(false, false)
            check = true
        end
    end
    if check then
        player:playSoundLocal("PZ_ClothesRipping")
        player:Say(CrowdControl.viewer .. "healed my bites!") end
    return check
end



function cc_healcuts()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local bodyPartsList, part, cutTime
    local check = false
    for i = 0, 16 do
        bodyPartsList = player:getBodyDamage():getBodyParts()
        part = bodyPartsList:get(i)
        cutTime = part:getCutTime()
        if cutTime > 0 then
            part:setCut(false, true)
            part:setCutTime(0)
            part:setBleedingTime(0)
            check = true
        end
    end
    if check then
        player:playSoundLocal("PZ_ClothesRipping")
        player:Say(CrowdControl.viewer .. " healed my cuts!") end
    return check
end



function cc_healburns()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local bodyPartsList, part, burnTime
    local check = false
    for i = 0, 16 do
        bodyPartsList = player:getBodyDamage():getBodyParts()
        part = bodyPartsList:get(i)
        burnTime = part:getCutTime()
        if burnTime > 0 then
            part:setBurnTime(0)
            check = true
        end
    end
    if check then
        player:playSoundLocal("PZ_ClothesRipping")
        player:Say(CrowdControl.viewer .. " healed my burns!") end
    return check
end



function cc_infect()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local body = player:getBodyDamage()
    local infection_level = body:isInfected()
    if infection_level then return false end
    body:setInfected(true)
    player:Say(CrowdControl.viewer .. " infected me!")
end



function cc_cureinfection()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local hp, bodyPart, infection_level
    local body = player:getBodyDamage()
    local bodyPartsList = body:getBodyParts()
    if body:getInfectionLevel() == 0 then return false end
    for i = 0, bodyPartsList:size()-1 do
        bodyPart = bodyPartsList:get(i)
        infection_level = bodyPart:getWoundInfectionLevel()
        if infection_level ~= 0 then
            bodyPart:setWoundInfectionLevel(0) end
    end
    body:setInfectionLevel(0)
    body:setInfected(false)
    player:Say(CrowdControl.viewer .. " cured my infection!")
end



function cc_drunk0()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local drunk_level = stats:getDrunkenness()
    if drunk_level <= 10 then return false end
    stats:setDrunkenness(0)
    player:Say(CrowdControl.viewer .. " made me sober!")
end



function cc_drunk50()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local drunk_level = stats:getDrunkenness()
    if drunk_level == 50 then return false end
    stats:setDrunkenness(50)
    player:Say(CrowdControl.viewer .. " made me a little drunk!")
end



function cc_drunk100()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local drunk_level = stats:getDrunkenness()
    if drunk_level >= 90 then return false end
    stats:setDrunkenness(100)
    player:Say(CrowdControl.viewer .. " made me very drunk!")
end



function cc_panic0()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local panic_level = stats:getPanic()
    if panic_level <= 10 then return false end
    stats:setPanic(0)
    player:Say(CrowdControl.viewer .. " cleared my panic!")
end


function cc_increasepanic()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local panic_level = stats:getPanic()
    if panic_level == 100 then return false end
    if panic_level >= 90 then
        stats:setPanic(100)
        player:Say(CrowdControl.viewer .. " made me very panicked!")
        return false
    else
    stats:setPanic(panic_level + 10)
    player:Say(CrowdControl.viewer .. " made me panic a little!")
    end
end


function cc_panic50()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local panic_level = stats:getPanic()
    if panic_level == 50 then return false end
    stats:setPanic(50)
    player:Say(CrowdControl.viewer .. " made me panic a little!")
end



function cc_panic100()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local panic_level = stats:getPanic()
    if panic_level >= 90 then return false end
    stats:setPanic(100)
    player:Say(CrowdControl.viewer .. " made me panic a lot!")
end



function cc_anger0()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local anger_level = stats:getAnger()
    if anger_level <= 0.1 then return false end
    stats:setAnger(0)
    player:Say(CrowdControl.viewer .. " cleared my anger!")
end



function cc_anger50()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local anger_level = stats:getAnger()
    if anger_level == 0.5 then return false end
    stats:setAnger(0.5)
    player:Say(CrowdControl.viewer .. " made me angry!")
end



function cc_anger100()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local anger_level = stats:getAnger()
    if anger_level >= 0.9 then return false end
    stats:setAnger(1)
    player:Say(CrowdControl.viewer .. " made me very angry!")
end



function cc_stress0()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local stress_level = stats:getStress()
    if stress_level <= 0.1 then return false end
    stats:setStress(0)
    player:Say(CrowdControl.viewer .. " cleared my stress!")
end



function cc_stress50()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local stress_level = stats:getStress()
    if stress_level == 0.5 then return false end
    stats:setStress(0.5)
    player:Say(CrowdControl.viewer .. " made me stressed!")
end



function cc_stress100()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local stress_level = stats:getStress()
    if stress_level >= 0.9 then return false end
    stats:setStress(1)
    player:Say(CrowdControl.viewer .. " made me very stressed!")
end



function cc_hunger0()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local hunger_level = stats:getHunger()
    if hunger_level <= 0.1 then return false end
    stats:setHunger(0)
    player:Say(CrowdControl.viewer .. " cleared my hunger!")
end



function cc_hunger50()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local hunger_level = stats:getHunger()
    if hunger_level == 0.5 then return false end
    stats:setHunger(0.5)
    player:Say(CrowdControl.viewer .. " made me hungry!")
end



function cc_hunger100()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local hunger_level = stats:getHunger()
    if hunger_level >= 0.9 then return false end
    stats:setHunger(1)
    player:Say(CrowdControl.viewer .. " made me very hungry!")
end



function cc_thirst0()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local thirst_level = stats:getThirst()
    if thirst_level <= 0.1 then return false end
    stats:setThirst(0)
    player:Say(CrowdControl.viewer .. " cleared my thirst!")
end



function cc_thirst50()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local thirst_level = stats:getThirst()
    if thirst_level == 0.5 then return false end
    stats:setThirst(0.5)
    player:Say(CrowdControl.viewer .. " made me thirsty!")
end



function cc_thirst100()
    if CrowdControl.TimedEffects["godmode"]~=nil then
        return false
    end
    if CrowdControl.TimedEffects["fullheal"]~=nil then
        return false
    end

    local player = getPlayer()
    local stats = player:getStats()
    local thirst_level = stats:getThirst()
    if thirst_level >= 0.9 then return false end
    stats:setThirst(1)
    player:Say(CrowdControl.viewer .. " made me very thirsty!")
end



function cc_weightup()
    local player = getPlayer()
    local nutrition = player:getNutrition()
    local weight = nutrition:getWeight()
    if weight > 125 then return false end
    weight = weight + ZombRand(4, 7)
    nutrition:setWeight(weight)
    player:Say(CrowdControl.viewer .. " made me gain weight!")
end



function cc_weightdown()
    local player = getPlayer()
    local nutrition = player:getNutrition()
    local weight = nutrition:getWeight()
    if weight < 40 then return false end
    weight = weight - ZombRand(4, 7)
    nutrition:setWeight(weight)
    player:Say(CrowdControl.viewer .. " made me lose weight!")
end



function cc_passiveup()
    local player = getPlayer()
    local level, newLevel
    local perks = { Perks.Strength, Perks.Fitness }
    local perkNames = { "strength", "fitness" }
    local levelChange = ZombRand(1, 4)
    local choice = ZombRand(1, 3)

    level = player:getPerkLevel(perks[choice])
    if level <= 10-levelChange then
        for i = 1, levelChange do
            player:LevelPerk(perks[choice])
        end
        player:getXp():setXPToLevel(perks[choice], level+levelChange)
        player:Say(CrowdControl.viewer .. " raised my " .. perkNames[choice] .. " skill!")
        return
    end
    return false
end



function cc_passivedown()
    local player = getPlayer()
    local level, newLevel
    local perks = { Perks.Strength, Perks.Fitness }
    local perkNames = { "strength", "fitness" }
    local levelChange = ZombRand(1, 4)
    local choice = ZombRand(1, 3)

    level = player:getPerkLevel(perks[choice])
    if levelChange <= level then
        newLevel = level - levelChange
        player:getXp():setXPToLevel(perks[choice], newLevel)
        player:setPerkLevelDebug(perks[choice], newLevel)
        player:Say(CrowdControl.viewer .. " lowered my " .. perkNames[choice] .. " skill!")
        return
    end
    return false
end



function cc_agilityup()
    local player = getPlayer()
    local level, newLevel
    local perks = { Perks.Sprinting, Perks.Nimble, Perks.Lightfoot, Perks.Sneak }
    local perkNames = { "sprinting", "nimble", "lightfooted", "sneak" }
    local levelChange = ZombRand(1, 4)
    local choice = ZombRand(1, 5)

    level = player:getPerkLevel(perks[choice])
    if level <= 10-levelChange then
        for i = 1, levelChange do
            player:LevelPerk(perks[choice])
        end
        player:getXp():setXPToLevel(perks[choice], level+levelChange)
        player:Say(CrowdControl.viewer .. " raised my " .. perkNames[choice] .. " skill!")
        return
    end
    return false
end



function cc_agilitydown()
    local player = getPlayer()
    local level, newLevel
    local perks = { Perks.Sprinting, Perks.Nimble, Perks.Lightfoot, Perks.Sneak }
    local perkNames = { "sprinting", "nimble", "lightfooted", "sneak" }
    local levelChange = ZombRand(1, 4)
    local choice = ZombRand(1, 5)

    level = player:getPerkLevel(perks[choice])
    if levelChange <= level then
        newLevel = level - levelChange
        player:getXp():setXPToLevel(perks[choice], newLevel)
        player:setPerkLevelDebug(perks[choice], newLevel)
        player:Say(CrowdControl.viewer .. " lowered my " .. perkNames[choice] .. " skill!")
        return
    end
    return false
end



function cc_combatup()
    local player = getPlayer()
    local level, newLevel
    local perks = { Perks.Axe, Perks.Blunt, Perks.SmallBlunt, Perks.LongBlade,
                    Perks.SmallBlade, Perks.Spear, Perks.Maintenance }
    local perkNames = { "axe", "blunt", "short blunt", "long blade",
                        "short blade", "spear", "maintenance" }
    local levelChange = ZombRand(1, 4)
    local choice = ZombRand(1, 8)

    level = player:getPerkLevel(perks[choice])
    if level <= 10-levelChange then
        for i = 1, levelChange do
            player:LevelPerk(perks[choice])
        end
        player:getXp():setXPToLevel(perks[choice], level+levelChange)
        player:Say(CrowdControl.viewer .. " raised my " .. perkNames[choice] .. " skill!")
        return
    end
    return false
end



function cc_combatdown()
    local player = getPlayer()
    local level, newLevel
    local perks = { Perks.Axe, Perks.Blunt, Perks.SmallBlunt, Perks.LongBlade,
                    Perks.SmallBlade, Perks.Spear, Perks.Maintenance }
    local perkNames = { "axe", "blunt", "short blunt", "long blade",
                        "short blade", "spear", "maintenance" }
    local levelChange = ZombRand(1, 4)
    local choice = ZombRand(1, 8)

    level = player:getPerkLevel(perks[choice])
    if levelChange <= level then
        newLevel = level - levelChange
        player:getXp():setXPToLevel(perks[choice], newLevel)
        player:setPerkLevelDebug(perks[choice], newLevel)
        player:Say(CrowdControl.viewer .. " lowered my " .. perkNames[choice] .. " skill!")
        return
    end
    return false
end



function cc_craftingup()
    local player = getPlayer()
    local level, newLevel
    local perks = { Perks.Woodwork, Perks.Cooking, Perks.Farming, Perks.Doctor,
                    Perks.Electricity, Perks.MetalWelding, Perks.Mechanics, Perks.Tailoring }
    local perkNames = { "carpentry", "cooking", "farming", "first aid",
                        "eletrical", "metalworking", "mechanics", "tailoring" }
    local levelChange = ZombRand(1, 4)
    local choice = ZombRand(1, 9)

    level = player:getPerkLevel(perks[choice])
    if level <= 10-levelChange then
        for i = 1, levelChange do
            player:LevelPerk(perks[choice])
        end
        player:getXp():setXPToLevel(perks[choice], level+levelChange)
        player:Say(CrowdControl.viewer .. " raised my " .. perkNames[choice] .. " skill!")
        return
    end
    return false
end



function cc_craftingdown()
    local player = getPlayer()
    local level, newLevel
    local perks = { Perks.Woodwork, Perks.Cooking, Perks.Farming, Perks.Doctor,
                    Perks.Electricity, Perks.MetalWelding, Perks.Mechanics, Perks.Tailoring }
    local perkNames = { "carpentry", "cooking", "farming", "first aid",
                        "eletrical", "metalworking", "mechanics", "tailoring" }
    local levelChange = ZombRand(1, 4)
    local choice = ZombRand(1, 9)

    level = player:getPerkLevel(perks[choice])
    if levelChange <= level then
        newLevel = level - levelChange
        player:getXp():setXPToLevel(perks[choice], newLevel)
        player:setPerkLevelDebug(perks[choice], newLevel)
        player:Say(CrowdControl.viewer .. " lowered my " .. perkNames[choice] .. " skill!")
        return
    end
    return false
end



function cc_firearmup()
    local player = getPlayer()
    local level, newLevel
    local perks = { Perks.Aiming, Perks.Reloading }
    local perkNames = { "aiming", "reloading" }
    local levelChange = ZombRand(1, 4)
    local choice = ZombRand(1, 3)

    level = player:getPerkLevel(perks[choice])
    if level <= 10-levelChange then
        for i = 1, levelChange do
            player:LevelPerk(perks[choice])
        end
        player:getXp():setXPToLevel(perks[choice], level+levelChange)
        player:Say(CrowdControl.viewer .. " raised my " .. perkNames[choice] .. " skill!")
        return
    end
    return false
end



function cc_firearmdown()
    local player = getPlayer()
    local level, newLevel
    local perks = { Perks.Aiming, Perks.Reloading }
    local perkNames = { "aiming", "reloading" }
    local levelChange = ZombRand(1, 4)
    local choice = ZombRand(1, 3)

    level = player:getPerkLevel(perks[choice])
    if levelChange <= level then
        newLevel = level - levelChange
        player:getXp():setXPToLevel(perks[choice], newLevel)
        player:setPerkLevelDebug(perks[choice], newLevel)
        player:Say(CrowdControl.viewer .. " lowered my " .. perkNames[choice] .. " skill!")
        return
    end
    return false
end



function cc_survivalistup()
    local player = getPlayer()
    local level, newLevel
    local perks = { Perks.Fishing, Perks.Trapping, Perks.PlantScavenging }
    local perkNames = { "fishing", "trapping", "foraging" }
    local levelChange = ZombRand(1, 4)
    local choice = ZombRand(1, 4)

    level = player:getPerkLevel(perks[choice])
    if level <= 10-levelChange then
        for i = 1, levelChange do
            player:LevelPerk(perks[choice])
        end
        player:getXp():setXPToLevel(perks[choice], level+levelChange)
        player:Say(CrowdControl.viewer .. " raised my " .. perkNames[choice] .. " skill!")
        return
    end
    return false
end



function cc_survivalistdown()
    local player = getPlayer()
    local level, newLevel
    local perks = { Perks.Fishing, Perks.Trapping, Perks.PlantScavenging }
    local perkNames = { "fishing", "trapping", "foraging" }
    local levelChange = ZombRand(1, 4)
    local choice = ZombRand(1, 4)

    level = player:getPerkLevel(perks[choice])
    if levelChange <= level then
        newLevel = level - levelChange
        player:getXp():setXPToLevel(perks[choice], newLevel)
        player:setPerkLevelDebug(perks[choice], newLevel)
        player:Say(CrowdControl.viewer .. " lowered my " .. perkNames[choice] .. " skill!")
        return
    end
    return false
end



function cc_scamcall()
    local player = getPlayer()
    local x = player:getLlx()
    local y = player:getLly()
    local z = player:getLlz()
    local square = player:getSquare()

    getSoundManager():PlayWorldSound("lightswitch", square, 0, 5, 5, false);
    addSound(player, x, y, z, 150, 50);

    local choice = "We've been trying to reach you about your car's extended warranty!"

    local altCalls = { "Don't delay, get your Spiffo's loyalty card today!",
                       "Remember to keep your zombie insurance up to date!",
                       "Are those pesky zombies getting you down? Become one yourself!",
                       "Bitten by the undead? That's illegal y'know! Knox County Legal Services.",
                       "Have you been injured in a zombie attack? Call the law offices of Dewey, Cheatem, and Howe!",
                       "Looking for a new career? Become a zombie today!",
                       "Are you a zombie? Call 1-800-GET-REKT for a free consultation!",
                       "Zombies are all around us. Stay safe with a zombie-proof bunker from ZomCo!",
                    }
    local altChance = ZombRand(0, 10)
    if altChance > 6 then
        choice = altCalls[ZombRand(1, #altCalls + 1)]
    end
    player:setCanShout(true)
    player:SayShout(choice)
end



function cc_noclip()
    if CrowdControl.TimedEffects["noclip"]~=nil then
        return false
    end

    if CrowdControl.StartTimed("noclip", 2000) then
        local player = getPlayer()
        player:setNoClip(true)
        player:Say(CrowdControl.viewer .. " activated noclip mode!")
    end
end

function cc_noclip_stop()
    local player = getPlayer()
    player:setNoClip(false)
    player:Say("Noclip mode has ended!")
end
