CrowdControl = CrowdControl or {}
require("Effects")

CrowdControl.TimedEffects = {}
CrowdControl.LastTime = 0
CrowdControl.duration = 0
CrowdControl.id = 0
CrowdControl.viewer = ""

CrowdControl.messages = nil

CrowdControl.bodyPartsArr = { ['Hand_L']="Left Hand", ['Hand_R']="Right Hand", ['ForeArm_L']="Left Forearm", ['ForeArm_R']="Right Forearm",
                              ['UpperArm_L']="Left Upper Arm", ['UpperArm_R']="Right Upper Arm", ['Torso_Upper']="Upper Torso",
                              ['Torso_Lower']="Lower Torso", ['Head']="Head", ['Neck']="Neck", ['Groin']="Groin", ['UpperLeg_L']="Left Thigh",
                              ['UpperLeg_R']="Right Thigh", ['LowerLeg_L']="Left Shin", ['LowerLeg_R']="Right Shin",
                              ['Foot_L']="Left Foot", ['Foot_R']="Right Foot" }
CrowdControl.staggerWait = 0

CrowdControl.RunEffects = function()

    local reader = getFileReader("input.txt",true)
    local lineraw = reader:readLine()

    while lineraw~=nil do

        local lineparts = string.split(lineraw,"\0")

        for k,line in pairs(lineparts) do

            if string.match(line, "\"code\":") then

                local items = string.split(line,"\"id\":")
                local id = items[2]

                items = string.split(id,",")

                id = items[1]        
                CrowdControl.id = id


                if string.match(line, "\"duration\":") then
                    items = string.split(line,"\"duration\":")
                    local duration = items[2]

                    items = string.split(duration,",")

                    duration = items[1]   
                    CrowdControl.duration = tonumber(duration)
                else
                    CrowdControl.duration = 0
                end
                
                viewer = "A Ghost"

                if string.match(line, "\"viewers\":") then
                    items = string.split(line,"\"viewers\":")
                    local viewtemp = items[1]

                    if viewtemp~=nil and string.match(viewtemp, "\"viewer\":") then
                        items = string.split(viewtemp,"\"viewer\":\"")
                        viewtemp = items[2]       

                        if viewtemp~=nil and string.match(viewtemp, "\"") then
                            items = string.split(viewtemp,"\"")
                            viewer = items[1]  
                        end
                    end
                else
                    if  string.match(line, "\"viewer\":") then
                        items = string.split(line,"\"viewer\":\"")
                        viewtemp = items[2]       

                        if viewtemp~=nil and string.match(viewtemp, "\"") then
                            items = string.split(viewtemp,"\"")
                            viewer = items[1]  
                        end
                    end                    
                end

                CrowdControl.viewer = viewer                

                items = string.split(line,"\"code\":")

                line = items[2]

                items = string.split(line,"\"")

                line = items[2]            

                --getPlayer():Say("Effect received: " .. line .. " ID: " .. id .. " Viewer:" .. viewer .. " Duration:" .. CrowdControl.duration)

                line = "cc_" .. line

                local ready = true
                

                if _G[line]~=nil then
                    if _G[line]()==false then ready = false end
                end




                
                if ready then
                    CrowdControl.SendMessage(CrowdControl.BuildResponse(id, 0, CrowdControl.duration))
                else
                    CrowdControl.SendMessage(CrowdControl.BuildResponse(id, 3, CrowdControl.duration))
                end

            end
        end
        lineraw = reader:readLine()
    end

    reader:close()

    local writer = getFileWriter("input.txt", false, false)
    writer:write("")
    writer:close()

    if CrowdControl.messages ~= nil then
        writer = getFileWriter("output.txt", false, false)
        writer:write(CrowdControl.messages)
        writer:close()
        CrowdControl.messages = nil
    end

end

CrowdControl.SendMessage = function(msg)

    if CrowdControl.messages == nil then
        CrowdControl.messages = ""
    else
        CrowdControl.messages = "\0" .. CrowdControl.messages
    end

    CrowdControl.messages = msg .. CrowdControl.messages
end

    

CrowdControl.DelayEffects = function()
    local reader = getFileReader("input.txt",true)
    local line = reader:readLine()

    while line~=nil do

        if string.match(line, "\"code\":") then

            local items = string.split(line,"\"id\":")
            local id = items[2]

            items = string.split(id,",")

            id = items[1]        

            CrowdControl.SendMessage(CrowdControl.BuildResponse(id, 3, 0))

        end
        line = reader:readLine()
    end

    reader:close()

    local writer = getFileWriter("input.txt", false, false)
    writer:write("")
    writer:close()

    if CrowdControl.messages ~= nil then
        writer = getFileWriter("output.txt", false, false)
        writer:write(CrowdControl.messages)
        writer:close()
        CrowdControl.messages = nil
    end

end




CrowdControl.StartTimed = function(name, duration)
    if CrowdControl.TimedEffects[name]~=nil then
        return false
    end

    _G["cc_"..name.."_id"] = CrowdControl.id
    _G["cc_"..name.."_paused"] = false

    if CrowdControl.duration > 0 then
        CrowdControl.TimedEffects[name] = CrowdControl.duration
    else
        CrowdControl.TimedEffects[name] = duration
    end
    
    CrowdControl.SendMessage(CrowdControl.BuildResponse(_G["cc_"..name.."_id"], 5, CrowdControl.TimedEffects[name]))

    return true
end

CrowdControl.RunTimed = function()

    local time = os.time() * 1000

    if CrowdControl.LastTime ~= 0 then
        local diff = time - CrowdControl.LastTime

        for name,v in pairs(CrowdControl.TimedEffects) do
            CrowdControl.TimedEffects[name] = CrowdControl.TimedEffects[name] - diff

            if CrowdControl.TimedEffects[name] <= 0 then
                local line = "cc_" .. name .. "_stop"

                if _G[line]~=nil then
                    _G[line]()
                end

                CrowdControl.SendMessage(CrowdControl.BuildResponse(_G["cc_"..name.."_id"], 8, 0))
                CrowdControl.TimedEffects[name] = nil
            else
                if _G["cc_"..name.."_paused"] then
                    CrowdControl.SendMessage(CrowdControl.BuildResponse(_G["cc_"..name.."_id"], 7, CrowdControl.TimedEffects[name]))
                    _G["cc_"..name.."_paused"] = false
                end
            end

        end

    end

    CrowdControl.LastTime = time
end

CrowdControl.DelayTimed = function()

    local time = os.time() * 1000

    for name,v in pairs(CrowdControl.TimedEffects) do

            if _G["cc_"..name.."_paused"] == false then
                CrowdControl.SendMessage(CrowdControl.BuildResponse(_G["cc_"..name.."_id"], 6, CrowdControl.TimedEffects[name]))
                _G["cc_"..name.."_paused"] = true
            end

    end

    CrowdControl.LastTime = time
end

CrowdControl.ExecTimed = function()

    for name,v in pairs(CrowdControl.TimedEffects) do
   
        local line = "cc_" .. name .. "_update"

        if _G[line]~=nil then
            _G[line]()
        end

    end

end

CrowdControl.BuildResponse = function(id, status, time)
    local text = "{\"id\":" .. id .. ",\"type\":0,\"status\":" .. status .. ",\"timeRemaining\":" .. time .. "}"
    return text

end
