exec function testEffect(id : int, msg : String, dur: int)
{
    if (theGame.IsDialogOrCutscenePlaying() || theGame.IsFading() || theGame.IsPaused()){
        LogChannel('CrowdControl', "[" + id + "] - retry");
    } else {
        if(theGame.CC.testEffect(msg, id, dur)){

        } else {
            LogChannel('CrowdControl', "[" + id + "] - retry");
        }
    }
}

function addbuff( type : EEffectType, optional duration : float, optional src : name )
{
    var params : SCustomEffectParams;
    var buffs : array<CBaseGameplayEffect>;
    var i : int;

    buffs = thePlayer.GetBuffs();

    for(i=0; i<buffs.Size(); i+=1)
    {
        if (buffs[i].GetEffectType() == type)
        {
            duration = duration + buffs[i].GetDurationLeft();
        }
    }

    if(duration > 0)
    {
        params.effectType = type;
        params.sourceName = src;
        params.duration = duration;
        thePlayer.AddEffectCustom(params);
    }
    else
    {
        thePlayer.AddEffectDefault(type, NULL, src);
    }

}

exec function testSpawn( template_nbr : int, optional distance : float)
{	
	switch ( template_nbr )
	{
		
		case 1:		
		case 2:		
		case 3:		
		case 4:		
		case 5:		
		case 6:		
		case 7:		
		case 8:		
		case 9:		
			spawnt_inquistion(template_nbr, distance);
			break;
			
		
		case 10:
		case 11:
		case 12:
		case 13:
		case 14:
		case 15:
		case 16:
		case 17:
		case 18:
		case 19:
		case 20:
		case 21:
		case 22:
		case 23:
		case 24:
		case 25:
		case 26:
			spawnt_nilfgard(template_nbr, distance);
			break;
			
		
		case 27:
		case 29:
		case 31:
		case 33:
		case 35:
		case 37:
		case 39:
		case 41:
		case 43:
		case 45:
		case 47:
		case 49:
		case 51:
		case 53:
		case 55:
		case 57:
		case 59:
			spawnt_nml_t1(template_nbr, distance);
			break;
			
		case 28:	
		case 30:
		case 32:
		case 34:
		case 36:
		case 38:
		case 40:
		case 42:
		case 44:
		case 46:
		case 48:
		case 50:
		case 52:
		case 54:
		case 56:
		case 58:
		case 60:
			spawnt_nml_t2(template_nbr, distance);
			break;
			
		
		case 61:
		case 62:
		case 63:
		case 64:
		case 65:
		case 66:
		case 67:
		case 68:
		case 69:
		case 70:
		case 71:
		case 72:
		case 73:
		case 74:
		case 75:
		case 76:
		case 77:
		case 78:
		case 79:
		case 80:
		case 81:
		case 82:
			spawnt_novigrad(template_nbr, distance);
			break;	
			
		
		case 83:
		case 84:
		case 85:
		case 86:
		case 87:
		case 88:
		case 89:
		case 90:
		case 91:
		case 92:
		case 93:
		case 94:
		case 95:
		case 96:
		case 97:
		case 98:
		case 99:
			spawnt_redania(template_nbr, distance);
			break;	
			
		
		case 100:
		case 102:
		case 104:
		case 106:
		case 108:
		case 110:
		case 112:
		case 114:
		case 116:
		case 118:
		case 120:
		case 122:
		case 124:
		case 126:
		case 128:
		case 130:
		case 132:
			spawnt_skellige_t1(template_nbr, distance);
			break;
		
		case 101:	
		case 103:
		case 105:
		case 107:
		case 109:
		case 111:
		case 113:
		case 115:
		case 117:
		case 119:
		case 121:
		case 123:
		case 125:
		case 127:
		case 129:
		case 131:
		case 133:
			spawnt_skellige_t2(template_nbr, distance);
			break;
			
		
		case 134:	
		case 135:
		case 136:
		case 137:
		case 138:
		case 139:
		case 140:
			spawnt_wild_hunt(template_nbr, distance);
			break;
	}
}

statemachine class CrowdControl extends CEntity {

    public var trigger : string;
    public var triggerid : int;
    public var triggerdur : int;

    public function testEffect(msg : string, id: int, dur: int) : bool{
        if(trigger == ""){
            triggerid = id;
            trigger = msg;
            triggerdur = dur;
            return true;
        } else {
            return false;
        }
    }

    public function start() {
        trigger = "";
        this.GotoState('Listening');
    }

}

state Listening in CrowdControl {
    public				var Input  : string;
	public				var Output : string;

    public var ScaleVec : Vector;
    public var ScaleTime : float;
    public var CiriTime : float;
    public var GameSpeed : float;
    public var GameSTime : float;
    public var PlaySpeed : float;
    public var PlayTime : float;

    public var oldFOV : float;
    public var FOV : float;
    public var FOVTime : float;
    public var oldTilt : float;
    public var Tilt : float;
    public var TiltTime : float;
    public var ShakeTime : float;

    public var oldHP : float;
    public var HP : float;
    public var HPTime : float;

    public var InfTime : float;

    event OnEnterState(previous_state_name: name) {
        Input  = "CC BLANT BUF                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ";
		Output = "CCOUTPUT BUF                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ";
        CiriTime = 0;
        ScaleTime = 0;
        GameSTime = 0;
        PlayTime = 0;
        FOVTime  = 0;
        TiltTime  = 0;
        ShakeTime  = 0;
        InfTime = 0;
        HPTime = 0;

        Input = StrReplace(Input, "BLANT", "INPUT");

        thePlayer.DisplayHudMessage("Crowd Control Starting");

        this.entryFunctionExample();
    }

    entry function entryFunctionExample() {
        this.latentFunctionExample();
    }

    latent function runTimers(delta : float){
        var cur : float;

        if(InfTime > 0){
            InfTime = InfTime - delta;

            if(InfTime>0){
                FactsAdd("debug_fact_inf_bolts");
            } else {
                FactsRemove("debug_fact_inf_bolts");
            }
        }   

        if(HPTime > 0){
            HPTime = HPTime - delta;
            cur = thePlayer.GetStat(BCS_Vitality);

            if(HPTime>0){
                if(cur>1.0f)thePlayer.ForceSetStat(BCS_Vitality, HP);
            } else {
                thePlayer.ForceSetStat(BCS_Vitality, oldHP);
            }
        }   

        if(ScaleTime > 0){
            ScaleTime = ScaleTime - delta;

            if(ScaleTime>0){
                ( ( CMovingPhysicalAgentComponent ) thePlayer.GetMovingAgentComponent() ).SetScale( ScaleVec );
            } else {
                ( ( CMovingPhysicalAgentComponent ) thePlayer.GetMovingAgentComponent() ).SetScale( Vector(1.0, 1.0, 1.0));
            }
        }

        if(CiriTime > 0){
            CiriTime = CiriTime - delta;

            if(CiriTime>0){
                if(!thePlayer.IsCiri()){
                    theGame.ChangePlayer( "Ciri" );
                    thePlayer.Debug_ReleaseCriticalStateSaveLocks();
                }
            } else {
                theGame.ChangePlayer( "Geralt" );
                thePlayer.Debug_ReleaseCriticalStateSaveLocks();
            }
        }

        if(GameSTime > 0){
            GameSTime = GameSTime - delta;

            if(GameSTime>0){
                theGame.SetTimeScale(GameSpeed, theGame.GetTimescaleSource(ETS_CFM_On), theGame.GetTimescalePriority(ETS_CFM_On), true );
            } else {
                theGame.SetTimeScale(1.0f, theGame.GetTimescaleSource(ETS_CFM_On), theGame.GetTimescalePriority(ETS_CFM_On), true );
            }
        }

        if(PlayTime > 0){
            PlayTime = PlayTime - delta;

            if(PlayTime>0){
                thePlayer.SetAnimationSpeedMultiplier(PlaySpeed);
            } else {
                thePlayer.SetAnimationSpeedMultiplier(1.0f);
            }
        }

        if(FOVTime > 0){
            FOVTime = FOVTime - delta;

            if(FOVTime>0){
                theGame.GetGameCamera().SetFov(FOV);
            } else {
                theGame.GetGameCamera().SetFov(oldFOV);
            }
        }       

        if(TiltTime > 0){
            TiltTime = TiltTime - delta;

            if(TiltTime>0){
                theGame.GetGameCamera().SetTilt(Tilt);
            } else {
                theGame.GetGameCamera().SetTilt(oldTilt);
            }
        }             

        Sleep(delta);
    }

    latent function latentFunctionExample() {
        var len, index : int;
		var result : string;
		var status : string;
        var code : string;
        var dur : int;

		while(true){

            if(parent.trigger != ""){
                if(executeEffect(parent.trigger, parent.triggerdur)){
                    LogChannel('CrowdControl', "[" + parent.triggerid + "] - success");
                } else {
                    LogChannel('CrowdControl', "[" + parent.triggerid + "] - retry");
                }
                
                parent.trigger = "";

                
            }

            len = StrLen( this.Input );


            result = StrRight( this.Input, len - 12);
			len = len - 12;

            status = StrLeft( result, 1);

            if(status == "R"){
                code = getField(result, "code");

                dur = StringToInt(getFieldInt(result, "duration"),0);
                if(code != ""){
                    executeEffect(code,dur);
                }
                this.Input  = "CC INPUT BUF                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ";
            }

            this.runTimers(0.1f);
		}
    }

    function getField(result : string, field : string) : string
    {
        var len, index : int;
        field = "\"" + field + "\":";

        index = StrFindFirst( result, field);
        if ( index > -1 )
        {
            len = StrLen( result );
            result = StrRight( result, len - index - StrLen(field) );

        } else return "";

        index = StrFindFirst( result, "\"");
        if ( index > -1 )
        {
            len = StrLen( result );
            result = StrRight( result, len - index - 1 );

        } else return "";       

        index = StrFindFirst( result, "\"");
        if ( index > -1 )
        {
            len = StrLen( result );
            result = StrLeft( result, index );
            return result;

        } else return "";        
    }

    function getFieldInt(result : string, field : string) : string
    {
        var len, index : int;
        field = "\"" + field + "\":";

        index = StrFindFirst( result, field);
        if ( index > -1 )
        {
            len = StrLen( result );
            result = StrRight( result, len - index - StrLen(field) );

        } else return "";

        index = StrFindFirst( result, ",");
        if ( index > -1 )
        {
            len = StrLen( result );
            result = StrLeft( result, index );
            return result;

        } else return "";  
    }


    function executeEffect(code : string, dur : int) : bool
    {
        var cur : float;
        var max : float;
        var curi : int;
        var maxi : int;
        var item : string;
        var itype : name;
        var equip : bool;
        var ids	: array<SItemUniqueId>;
        var itemid : SItemUniqueId;
        var mon : bool;

        mon = false;

        if(code == "kill"){
            thePlayer.Kill( 'Kill Trigger' );
            return true;
        }

        if(code == "hurts"){
            cur = thePlayer.GetStat(BCS_Vitality);
            max = thePlayer.GetStatMax(BCS_Vitality);

            if(cur < max / 10.0f)return false;

            if(cur < max / 5.0f)cur = 1.0f;
            else cur -= max / 5.0f;

            thePlayer.ForceSetStat(BCS_Vitality, cur);
            return true;
        }

        if(code == "hurtb"){
            cur = thePlayer.GetStat(BCS_Vitality);
            max = thePlayer.GetStatMax(BCS_Vitality);

            if(cur < max / 4.0f)return false;

            if(cur < max / 2.0f)cur = 1.0f;
            else cur -= max / 2.0f;

            thePlayer.ForceSetStat(BCS_Vitality, cur);
            return true;
        }

        if(code == "hurtf"){
            cur = thePlayer.GetStat(BCS_Vitality);
            max = thePlayer.GetStatMax(BCS_Vitality);

            if(cur < max / 3.0f)return false;

            cur = 1.0f;

            thePlayer.ForceSetStat(BCS_Vitality, cur);
            return true;
        }

        if(code == "heals"){
            cur = thePlayer.GetStat(BCS_Vitality);
            max = thePlayer.GetStatMax(BCS_Vitality);

            if(cur > 9.0 * max / 10.0f)return false;

            if(cur > max - max / 5.0f)cur = max;
            else cur += max / 5.0f;

            thePlayer.ForceSetStat(BCS_Vitality, cur);
            return true;
        }

        if(code == "healb"){
            cur = thePlayer.GetStat(BCS_Vitality);
            max = thePlayer.GetStatMax(BCS_Vitality);

            if(cur > 3.0 * max / 4.0f)return false;

            if(cur > max / 2.0f)cur = max;
            else cur += max / 2.0f;

            thePlayer.ForceSetStat(BCS_Vitality, cur);
            return true;
        }

        if(code == "healf"){
            cur = thePlayer.GetStat(BCS_Vitality);
            max = thePlayer.GetStatMax(BCS_Vitality);

            if(cur > 2.0 * max / 3.0f)return false;

            cur = max;

            thePlayer.ForceSetStat(BCS_Vitality, cur);
            return true;
        }        




        if(code == "drains"){
            cur = thePlayer.GetStat(BCS_Stamina);
            max = thePlayer.GetStatMax(BCS_Stamina);

            if(cur < max / 10.0f)return false;

            if(cur < max / 5.0f)cur = 1.0f;
            else cur -= max / 5.0f;

            thePlayer.ForceSetStat(BCS_Stamina, cur);
            return true;
        }

        if(code == "drainb"){
            cur = thePlayer.GetStat(BCS_Stamina);
            max = thePlayer.GetStatMax(BCS_Stamina);

            if(cur < max / 4.0f)return false;

            if(cur < max / 2.0f)cur = 1.0f;
            else cur -= max / 2.0f;

            thePlayer.ForceSetStat(BCS_Stamina, cur);
            return true;
        }

        if(code == "drainf"){
            cur = thePlayer.GetStat(BCS_Stamina);
            max = thePlayer.GetStatMax(BCS_Stamina);

            if(cur < max / 20.0f)return false;

            cur = 0;

            thePlayer.ForceSetStat(BCS_Stamina, cur);
            return true;
        }

        if(code == "restores"){
            cur = thePlayer.GetStat(BCS_Stamina);
            max = thePlayer.GetStatMax(BCS_Stamina);

            if(cur > 9.0 * max / 10.0f)return false;

            if(cur > max - max / 5.0f)cur = max;
            else cur += max / 5.0f;

            thePlayer.ForceSetStat(BCS_Stamina, cur);
            return true;
        }

        if(code == "restoreb"){
            cur = thePlayer.GetStat(BCS_Stamina);
            max = thePlayer.GetStatMax(BCS_Stamina);

            if(cur > 3.0 * max / 4.0f)return false;

            if(cur > max / 2.0f)cur = max;
            else cur += max / 2.0f;

            thePlayer.ForceSetStat(BCS_Stamina, cur);
            return true;
        }

        if(code == "restoref"){
            cur = thePlayer.GetStat(BCS_Stamina);
            max = thePlayer.GetStatMax(BCS_Stamina);

            if(cur > 2.0 * max / 3.0f)return false;

            cur = max;

            thePlayer.ForceSetStat(BCS_Stamina, cur);
            return true;
        }        

        if(code == "focusup"){
            cur = thePlayer.GetStat(BCS_Focus);
            max = thePlayer.GetStatMax(BCS_Focus);

            if(cur == max)return false;

            cur += 1;

            thePlayer.ForceSetStat(BCS_Focus, cur);
            return true;
        }        

        if(code == "focusdown"){
            cur = thePlayer.GetStat(BCS_Focus);
            max = thePlayer.GetStatMax(BCS_Focus);

            if(cur <= 0)return false;

            cur -= 1;

            thePlayer.ForceSetStat(BCS_Focus, cur);
            return true;
        }


        if(code == "toxicup"){
            cur = thePlayer.GetStat(BCS_Toxicity);
            max = thePlayer.GetStatMax(BCS_Toxicity);

            if(cur >= max)return false;

            if(cur >= 3.0f * max / 4.0f)cur = max;
            cur += max / 4.0f;

            thePlayer.ForceSetStat(BCS_Toxicity, cur);
            return true;
        }

        if(code == "toxicdown"){
            cur = thePlayer.GetStat(BCS_Toxicity);
            max = thePlayer.GetStatMax(BCS_Toxicity);

            if(cur <= 0)return false;

            if(cur <= max / 4.0f)cur = 0;
            cur -= max / 4.0f;

            thePlayer.ForceSetStat(BCS_Toxicity, cur);
            return true;
        }        


        if(code == "goldups"){
            curi = thePlayer.GetMoney();
            if(curi > 999000)return false;
            thePlayer.AddMoney(100);
            return true;
        }
        if(code == "goldupm"){
            curi = thePlayer.GetMoney();
            if(curi > 999000)return false;
            thePlayer.AddMoney(1000);
            return true;
        }
        if(code == "goldupb"){
            curi = thePlayer.GetMoney();
            if(curi > 999000)return false;
            thePlayer.AddMoney(10000);
            return true;
        }

        if(code == "golddowns"){
            curi = thePlayer.GetMoney();
            if(curi < 100)return false;
            thePlayer.RemoveMoney(100);
            return true;
        }
        if(code == "golddownm"){
            curi = thePlayer.GetMoney();
            if(curi < 1000)return false;
            thePlayer.RemoveMoney(1000);
            return true;
        }        
        if(code == "golddownb"){
            curi = thePlayer.GetMoney();
            if(curi < 10000)return false;
            thePlayer.RemoveMoney(10000);
            return true;
        }
        if(code == "ciri"){
            if(CiriTime > 0)return false;
            if(thePlayer.IsCiri())return false;

            CiriTime = dur/1000;

            return true;
        }

        if(code == "giant"){
            if(ScaleTime > 0)return false;
            
            ScaleVec = Vector(2.0, 2.0, 2.0);
            ScaleTime = dur/1000;

            return true;
        }
        if(code == "tiny"){
            if(ScaleTime > 0)return false;
            
            ScaleVec = Vector(0.5, 0.5, 0.5);
            ScaleTime = dur/1000;

            return true;
        }
        if(code == "tall"){
            if(ScaleTime > 0)return false;
            
            ScaleVec = Vector(1.0, 1.0, 2.0);
            ScaleTime = dur/1000;

            return true;
        }
        if(code == "short"){
            if(ScaleTime > 0)return false;
            
            ScaleVec = Vector(1.2, 1.2, 0.5);
            ScaleTime = dur/1000;

            return true;
        }
        if(code == "wide"){
            if(ScaleTime > 0)return false;
            
            ScaleVec = Vector(3.0, 1.0, 1.0);
            ScaleTime = dur/1000;

            return true;
        }
        if(code == "narrow"){
            if(ScaleTime > 0)return false;
            
            ScaleVec = Vector(0.33, 1.0, 1.0);
            ScaleTime = dur/1000;

            return true;
        }        

        if(code == "drunk"){
            addbuff(EET_Drunkenness,dur/1000);
            return true;
        }
        if(code == "blind"){
            addbuff(EET_Blindness,dur/1000);
            return true;
        }
        if(code == "burning"){
            addbuff(EET_Burning,dur/1000);
            return true;
        }
        if(code == "frozen"){
            addbuff(EET_Frozen,dur/1000);
            return true;
        }
        if(code == "confuse"){
            addbuff(EET_Confusion,dur/1000);
            return true;
        }
        if(code == "slow"){
            addbuff(EET_Slowdown,dur/1000);
            return true;
        }                                
        if(code == "regen"){
            addbuff(EET_AutoVitalityRegen,dur/1000);
            return true;
        }    

        if(code == "launch"){
            ( ( CMovingPhysicalAgentComponent ) thePlayer.GetMovingAgentComponent() ).ApplyVelocity(Vector(0,0,100.0f));
            return true;
        }
        if(code == "launch2"){
            ( ( CMovingPhysicalAgentComponent ) thePlayer.GetMovingAgentComponent() ).ApplyVelocity(Vector(0,0,-100.0f));
            return true;
        }
            if(code == "launch3"){
            ( ( CMovingPhysicalAgentComponent ) thePlayer.GetMovingAgentComponent() ).ApplyVelocity(Vector(0,0,1000.0f));
            return true;
        }
          if(code == "launch4"){
            ( ( CMovingPhysicalAgentComponent ) thePlayer.GetMovingAgentComponent() ).ApplyVelocity(Vector(0,0,-1000.0f));
            return true;
        }          
        if(code == "grav"){
            ( ( CMovingPhysicalAgentComponent ) thePlayer.GetMovingAgentComponent() ).SetGravity(true);
            return true;
        }   
        if(code == "antigrav"){
            ( ( CMovingPhysicalAgentComponent ) thePlayer.GetMovingAgentComponent() ).SetGravity(false);
            return true;
        }       

        if(code == "hyper"){
            if(GameSTime > 0)return false;
            GameSpeed = 4.0f;
            GameSTime = dur/1000;
            return true;
        }        
        if(code == "fast"){
            if(GameSTime > 0)return false;
            GameSpeed = 2.0f;
            GameSTime = dur/1000;
            return true;
        }
        if(code == "slow"){
            if(GameSTime > 0)return false;
            GameSpeed = 0.25f;
            GameSTime = dur/1000;
            return true;
        }            
        if(code == "normal"){
            theGame.SetTimeScale(1.0, theGame.GetTimescaleSource(ETS_CFM_On), theGame.GetTimescalePriority(ETS_CFM_On), true );
            return true;
        } 

        if(code == "playhyper"){
            if(PlayTime > 0)return false;
            PlaySpeed = 4.0f;
            PlayTime = dur/1000;
            return true;
        }           
        if(code == "playfast"){
            if(PlayTime > 0)return false;
            PlaySpeed = 2.0f;
            PlayTime = dur/1000;
            return true;
        }     
        if(code == "playslow"){
            if(PlayTime > 0)return false;
            PlaySpeed = 0.25f;
            PlayTime = dur/1000;
            return true;
        }     

        if(code == "widecam"){
            if(FOVTime > 0)return false;
            oldFOV = theGame.GetGameCamera().fov;
            FOV = 130.0f;
            FOVTime = dur/1000;
            return true;
        }     
        if(code == "narrowcam"){
            if(FOVTime > 0)return false;
            oldFOV = theGame.GetGameCamera().fov;
            FOV = 30.0f;
            FOVTime = dur/1000;
            return true;
        }        
        

        if(code == "invertcam"){
            if(TiltTime > 0)return false;
            oldTilt = theGame.GetGameCamera().GetTilt();
            Tilt = oldTilt + 180.0f;
            TiltTime = dur/1000;
            return true;
        }    

        if(code == "ohko"){
            if(HPTime > 0)return false;
            oldHP = thePlayer.GetStat(BCS_Vitality);
            HP = 1.0f;
            HPTime = dur/1000;
            return true;
        }   
        if(code == "invul"){
            if(HPTime > 0)return false;
            oldHP = thePlayer.GetStat(BCS_Vitality);
            HP = thePlayer.GetStatMax(BCS_Vitality);
            HPTime = dur/1000;
            return true;
        }                       
        if(code == "infarrow"){
            if(InfTime > 0)return false;
            InfTime = dur/1000;
            return true;
        }    

        if(code == "givepoint"){
            GetWitcherPlayer().AddPoints(ESkillPoint, 1, true);
            return true;
        }

        if(code == "getpoint"){
            thePlayer.DisplayHudMessage("Ability Points: " + GetWitcherPlayer().levelManager.GetPointsFree(ESkillPoint));            
            return true;
        }        

        if(code == "takepoint"){
            curi = GetWitcherPlayer().levelManager.GetPointsFree(ESkillPoint);   
            if(curi<=0)return false;
            GetWitcherPlayer().levelManager.SetFreeSkillPoints(curi - 1);
            return true;
        }

        if(code == "levelup"){
            if(GetWitcherPlayer().GetLevel() == GetWitcherPlayer().GetMaxLevel())return false;
            GetWitcherPlayer().levelManager.AddPoints(EExperiencePoint, GetWitcherPlayer().levelManager.GetTotalExpForNextLevel() - GetWitcherPlayer().levelManager.GetPointsTotal(EExperiencePoint), true);
            return true;
        }      

        if(code == "leveldown"){
            
            maxi = GetWitcherPlayer().levelManager.GetTotalExpForCurrLevel();
            curi = GetWitcherPlayer().GetPointsTotal(EExperiencePoint);

            if(curi<=maxi)return false;

            GetWitcherPlayer().levelManager.SetFreePoints(EExperiencePoint, 0);
            return true;
        } 

        if(StrLeft(code, 9) == "giveitem_"){

            item = StrRight(code, StrLen(code) - 9);
            curi = 1;
            equip = false;

            switch(item){
                case "Tracking": curi = 5; itype = 'Tracking Bolt'; break;
                case "Bait": curi = 5; itype = 'Bait Bolt'; break;
                case "Blunt": curi = 5; itype = 'Blunt Bolt'; break;
                case "Broadhead": curi = 5; itype = 'Broadhead Bolt'; break;
                case "Target": curi = 5; itype = 'Target Point Bolt'; break;
                case "Split": curi = 5; itype = 'Split Bolt'; break;
                case "Explosive": curi = 5; itype = 'Explosive Bolt'; break;

                case "Leather": curi = 3; itype = 'Hardened leather'; break;
                case "Linen": curi = 3; itype = 'Linen'; break;
                case "Thread": curi = 3; itype = 'Thread'; break;
                case "Twine": curi = 3; itype = 'Twine'; break;
                case "Plate": curi = 3; itype = 'Steel plate'; break;
                case "Cotton": curi = 3; itype = 'Cotton'; break;
                case "Oil": curi = 3; itype = 'Oil'; break;
                case "Shard": curi = 3; itype = 'Infused shard'; break;   

                case "Long": equip = true; itype = 'Long Steel Sword'; break;
                case "Short": equip = true; itype = 'Short Steel Sword'; break;
                case "Dwarven": equip = true; itype = 'Dwarven sword 1'; break;
                case "Gnomish": equip = true; itype = 'Gnomish sword 1'; break;
                case "Inquisitor": equip = true; itype = 'Inquisitor sword 1'; break;
                case "Mans": equip = true; itype = 'No Mans Land sword 1'; break;
                case "Nilfgaardian": equip = true; itype = 'Nilfgaardian sword 1'; break;
                case "Novigraadan": equip = true; itype = 'Novigraadan sword 1'; break;
                case "Scoiatael": equip = true; itype = 'Scoiatael sword 1'; break;
                case "Skellige": equip = true; itype = 'Skellige sword 1'; break;
                case "Wild": equip = true; itype = 'Wild Hunt sword 1'; break;

                case "Silver": equip = true; itype = 'Silver sword 1'; break;
                case "DwarvenS": equip = true; itype = 'Dwarven silver sword 1'; break;
                case "ElvenS": equip = true; itype = 'Elven silver sword 1'; break;
                case "GnomishS": equip = true; itype = 'Gnomish silver sword 1'; break;
                case "Bear": equip = true; itype = 'Bear School silver sword'; break;
                case "Lynx": equip = true; itype = 'Lynx School silver sword'; break;
                case "Gryphon": equip = true; itype = 'Gryphon School silver sword'; break;
                case "Viper": equip = true; itype = 'Viper School silver sword'; break;
                case "Wolf": equip = true; itype = 'Wolf School silver sword'; break;


                case "Dijkstra": curi = 3; itype = 'Dijkstra Dry'; break;
                case "Apple": curi = 3; itype = 'Apple'; break;
                case "Bread": curi = 3; itype = 'Bread'; break;
                case "Cheese": curi = 3; itype = 'Cheese'; break;
                case "Chicken": curi = 3; itype = 'Chicken'; break;
                case "Egg": curi = 3; itype = 'Egg'; break;
                case "Fish": curi = 3; itype = 'Fish'; break;
                case "Cows": curi = 3; itype = 'Cows milk'; break;
                case "Baked": curi = 3; itype = 'Baked potato'; break;
                case "juice": curi = 3; itype = 'Apple juice'; break;
                case "water": curi = 3; itype = 'Bottled water'; break;                

                default: return false;
            }

            ids = thePlayer.inv.AddAnItem(itype, 1, false, false, true);
            if(equip){
                thePlayer.EquipItem(ids[0]);
            }
            return true;
        }

        if(StrLeft(code, 9) == "takeitem_"){

            item = StrRight(code, StrLen(code) - 9);
            curi = 1;
            equip = false;

            switch(item){
                case "Tracking": curi = 5; itype = 'Tracking Bolt'; break;
                case "Bait": curi = 5; itype = 'Bait Bolt'; break;
                case "Blunt": curi = 5; itype = 'Blunt Bolt'; break;
                case "Broadhead": curi = 5; itype = 'Broadhead Bolt'; break;
                case "Target": curi = 5; itype = 'Target Point Bolt'; break;
                case "Split": curi = 5; itype = 'Split Bolt'; break;
                case "Explosive": curi = 5; itype = 'Explosive Bolt'; break;

                case "Leather": curi = 3; itype = 'Hardened leather'; break;
                case "Linen": curi = 3; itype = 'Linen'; break;
                case "Thread": curi = 3; itype = 'Thread'; break;
                case "Twine": curi = 3; itype = 'Twine'; break;
                case "Plate": curi = 3; itype = 'Steel plate'; break;
                case "Cotton": curi = 3; itype = 'Cotton'; break;
                case "Oil": curi = 3; itype = 'Oil'; break;
                case "Shard": curi = 3; itype = 'Infused shard'; break;   

                case "Long": equip = true; itype = 'Long Steel Sword'; break;
                case "Short": equip = true; itype = 'Short Steel Sword'; break;
                case "Dwarven": equip = true; itype = 'Dwarven sword 1'; break;
                case "Gnomish": equip = true; itype = 'Gnomish sword 1'; break;
                case "Inquisitor": equip = true; itype = 'Inquisitor sword 1'; break;
                case "Mans": equip = true; itype = 'No Mans Land sword 1'; break;
                case "Nilfgaardian": equip = true; itype = 'Nilfgaardian sword 1'; break;
                case "Novigraadan": equip = true; itype = 'Novigraadan sword 1'; break;
                case "Scoiatael": equip = true; itype = 'Scoiatael sword 1'; break;
                case "Skellige": equip = true; itype = 'Skellige sword 1'; break;
                case "Wild": equip = true; itype = 'Wild Hunt sword 1'; break;

                case "Silver": equip = true; itype = 'Silver sword 1'; break;
                case "DwarvenS": equip = true; itype = 'Dwarven silver sword 1'; break;
                case "ElvenS": equip = true; itype = 'Elven silver sword 1'; break;
                case "GnomishS": equip = true; itype = 'Gnomish silver sword 1'; break;
                case "Bear": equip = true; itype = 'Bear School silver sword'; break;
                case "Lynx": equip = true; itype = 'Lynx School silver sword'; break;
                case "Gryphon": equip = true; itype = 'Gryphon School silver sword'; break;
                case "Viper": equip = true; itype = 'Viper School silver sword'; break;
                case "Wolf": equip = true; itype = 'Wolf School silver sword'; break;


                case "Dijkstra": curi = 3; itype = 'Dijkstra Dry'; break;
                case "Apple": curi = 3; itype = 'Apple'; break;
                case "Bread": curi = 3; itype = 'Bread'; break;
                case "Cheese": curi = 3; itype = 'Cheese'; break;
                case "Chicken": curi = 3; itype = 'Chicken'; break;
                case "Egg": curi = 3; itype = 'Egg'; break;
                case "Fish": curi = 3; itype = 'Fish'; break;
                case "Cows": curi = 3; itype = 'Cows milk'; break;
                case "Baked": curi = 3; itype = 'Baked potato'; break;
                case "juice": curi = 3; itype = 'Apple juice'; break;
                case "water": curi = 3; itype = 'Bottled water'; break;                

                default: return false;
            }

            maxi = thePlayer.inv.GetItemQuantityByName(itype);
            if(maxi==0)return false;

            if(curi>maxi)curi=maxi;

            thePlayer.inv.RemoveItemByName(itype, curi);

            return true;
        }


        if(code == "unsteel"){
		    if(!GetWitcherPlayer().GetItemEquippedOnSlot(EES_SteelSword, itemid))return false;

            if(!GetWitcherPlayer().UnequipItem(itemid))return false;

            GetWitcherPlayer().inv.RemoveItem(itemid,GetWitcherPlayer().inv.GetItemQuantity(itemid));

            return true;
        }      

        if(code == "unsilver"){
		    if(!GetWitcherPlayer().GetItemEquippedOnSlot(EES_SilverSword, itemid))return false;

            if(!GetWitcherPlayer().UnequipItem(itemid))return false;

            GetWitcherPlayer().inv.RemoveItem(itemid,GetWitcherPlayer().inv.GetItemQuantity(itemid));

            return true;
        }     
		
        if(code == "spawninq"){

            spawnt_inquistion(1);
            return true;

        }

        if(code == "spawntest"){
            spawn_cc ( "gameplay\templates\monsters\ghoul_lvl6.w2ent");
            return true;
        }
		
        if(StrLeft(code, 6) == "spawn_"){

            item = StrRight(code, StrLen(code) - 6);
            curi = 0;
            equip = false;

            switch(item){

                case "sorceress":
                    spawn_cc("gameplay\templates\characters\npcs\test_enemies\enemy_sorceress.w2ent", 1, 3, thePlayer.GetLevel(), equip);
                    return true;
                case "succubus":
                    spawn_cc("gameplay\templates\characters\npcs\test_enemies\enemy_succubus.w2ent", 1, 3, thePlayer.GetLevel(), equip);
                    return true;
                
                
                case "inqsword": item = "\inquisition\inq_1h_mace_t1.w2ent"; break;
                case "inqbow":   item = "\inquisition\inq_crossbos.w2ent";    break;
                
                case "redsword": item = "\redania\red_1h_sword.w2ent"; break;
                case "redbow":   item = "\redania\red_crossbow.w2ent";    break;
                
                case "skesword": item = "\skellige\ske_1h_axe_t1.w2ent"; break;
                case "skebow":   item = "\skellige\ske_bow.w2ent";    break;

                case "novsword": item = "\novigrad\nov_1h_club.w2ent"; break;
                case "novbow":   item = "\novigrad\nov_bandit_crossbow.w2ent";    break;

                case "alghoul":  mon = true; item = "\alghoul_lvl3a.w2ent"; break;
                case "arachas":  mon = true; item = "\arachas_lvl3__poison.w2ent"; break;
                case "basilisk": mon = true; item = "\basilisk_lvl1a.w2ent"; break;
                case "bies":     mon = true; item = "\bies_lvl2a.w2ent"; break;
                case "cyclops":  mon = true; item = "\cyclop_lvl1a.w2ent"; break;
                case "drowner":  mon = true; item = "\drowner_lvl17.w2ent"; break;
                case "endrega":  mon = true; item = "\endriaga_tailvl7__nestboss.w2ent"; break;
                case "fogling":  mon = true; item = "\fogling_lvl26.w2ent"; break;
                case "forktail": mon = true; item = "\forktail_lvl30.w2ent"; break;
                case "gargoyle": mon = true; item = "\gargoyle_lvl1a.w2ent"; break;
                case "ghoul":    mon = true; item = "\ghoul_lvl4.w2ent"; break;
                case "waterhag": mon = true; item = "\hag_water_lvl25.w2ent"; break;
                case "harpy":    mon = true; item = "\harpy_lvl21.w2ent"; break;
                case "nekker":   mon = true; item = "\nekker_lvl9__warrior.w2ent"; break;
                case "rotfiend": mon = true; item = "\rotfiend_lvl1_nestboss.w2ent"; break;
                case "icetroll": mon = true; item = "\troll_ice_lvl13.w2ent"; break;
                case "wolf":     mon = true; item = "\wolf_lvl4_nerf.w2ent"; break;
                case "wraith":   mon = true; item = "\wraith_lvl2.w2ent"; break;
                case "wyvern":   mon = true; item = "\wyvern_lvl2a.w2ent"; break;

                case "botchling":
                    item = "quests\part_1\quest_files\q103_daughter\characters\q103_big_botch.w2ent";
                    spawn_cc(item, 1, 3, thePlayer.GetLevel(), equip);
                    break;

                case "werewolf":
                    item = "quests\part_1\quest_files\q103_daughter\characters\q103_werewolf.w2ent";
                    spawn_cc(item, 1, 3, thePlayer.GetLevel(), equip);
                    break;

                case "lamia":
                    item = "quests\generic_quests\skellige\quest_files\mh210_lamia\characters\mh210_lamia.w2ent";
                    spawn_cc(item, 1, 3, thePlayer.GetLevel(), equip);
                    break;

                case "cockatrice":
                    item = "quests\generic_quests\no_mans_land\quest_files\mh101_cockatrice\characters\mh101_cockatrice.w2ent";
                    spawn_cc(item, 1, 3, thePlayer.GetLevel(), equip);
                    break;
                    
                default: return false;
            }

            if(mon){
                spawn_cc("gameplay\templates\monsters" + item, 1, 3, thePlayer.GetLevel(), equip);
            } else {
                spawn_cc("gameplay\templates\characters\presets" + item, 1, 3, thePlayer.GetLevel(), equip);
            }
            return true;
        }

        return false;

    }
}

function spawn_cc(nam : string, optional quantity : int, optional distance : float, optional level : int, optional rider : bool)
{
	var ent : CEntity;
	var horse : CEntity;
	var pos, cameraDir, player, posFin, normal : Vector;
	var rot : EulerAngles;
	var i, sign : int;
	var s,r,x,y : float;
	var template : CEntityTemplate;
	var horseTemplate : CEntityTemplate;
	var horseTag : array<name>;
	var actor : CActor;
    var attribute : SAbilityAttributeValue;
    var l_aiTree		: CAIHorseDoNothingAction;

	quantity = Max(quantity, 1);
	
	rot = thePlayer.GetWorldRotation();	
	rot.Yaw += 180;		
	
	
	cameraDir = theCamera.GetCameraDirection();
	
	if( distance == 0 ) distance = 3; 
	cameraDir.X *= distance;	
	cameraDir.Y *= distance;
	
	
	player = thePlayer.GetWorldPosition();
	
	
	pos = cameraDir + player;	
	pos.Z = player.Z;
	
	
	posFin.Z = pos.Z;			
	s = quantity / 0.2;			
	r = SqrtF(s/Pi());
	
	
	template = (CEntityTemplate)LoadResource(nam, true);
    if(rider){
	    horseTemplate = (CEntityTemplate)LoadResource('horse');
    }
	
		
	for(i=0; i<quantity; i+=1)
	{		
		x = RandF() * r;			
		y = RandF() * (r - x);		
		
		if(RandRange(2))					
			sign = 1;
		else
			sign = -1;
			
		posFin.X = pos.X + sign * x;	
		
		if(RandRange(2))					
			sign = 1;
		else
			sign = -1;
			
		posFin.Y = pos.Y + sign * y;	
				
		theGame.GetWorld().StaticTrace( posFin + 5, posFin - 5, posFin, normal );
		
		ent = theGame.CreateEntity(template, posFin, rot);
		
		if ( horseTemplate )
		{
			horseTag.PushBack('enemy_horse');
			horse = theGame.CreateEntity(horseTemplate, posFin, rot,true,false,false,PM_DontPersist,horseTag);
			
			l_aiTree = new CAIHorseDoNothingAction in ent;
			l_aiTree.OnCreated();
			((CActor)ent).ForceAIBehavior( l_aiTree, BTAP_AboveEmergency2, 'AI_Rider_Load_Forced' );
			
			((CActor)ent).SignalGameplayEventParamInt( 'RidingManagerMountHorse', MT_instant | MT_fromScript );
		}
			
		((CActor)ent).SetTemporaryAttitudeGroup( 'hostile_to_player', AGP_Default );

        actor = (CActor)ent;

        if(level != 0){
            ((CNewNPC)ent).SetLevel( level );
        }
		
	}
}